<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_rgs_reg_key_Query_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_rgs_reg_key_Query_DataObjectType extends AbstractStructBase
{
    /**
     * The eab_rgs_key
     * Meta information extracted from the WSDL
     * - documentation: eab_rgs_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eab_rgs_key = null;
    /**
     * The eab_rgs_reg_key
     * Meta information extracted from the WSDL
     * - documentation: eab_rgs_reg_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eab_rgs_reg_key = null;
    /**
     * The eab_rgs_gft_key
     * Meta information extracted from the WSDL
     * - documentation: eab_rgs_gft_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eab_rgs_gft_key = null;
    /**
     * Constructor method for FundraisingGift_rgs_reg_key_Query_DataObjectType
     * @uses FundraisingGift_rgs_reg_key_Query_DataObjectType::setEab_rgs_key()
     * @uses FundraisingGift_rgs_reg_key_Query_DataObjectType::setEab_rgs_reg_key()
     * @uses FundraisingGift_rgs_reg_key_Query_DataObjectType::setEab_rgs_gft_key()
     * @param string $eab_rgs_key
     * @param string $eab_rgs_reg_key
     * @param string $eab_rgs_gft_key
     */
    public function __construct(?string $eab_rgs_key = null, ?string $eab_rgs_reg_key = null, ?string $eab_rgs_gft_key = null)
    {
        $this
            ->setEab_rgs_key($eab_rgs_key)
            ->setEab_rgs_reg_key($eab_rgs_reg_key)
            ->setEab_rgs_gft_key($eab_rgs_gft_key);
    }
    /**
     * Get eab_rgs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEab_rgs_key(): ?string
    {
        return $this->eab_rgs_key ?? null;
    }
    /**
     * Set eab_rgs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eab_rgs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_rgs_reg_key_Query_DataObjectType
     */
    public function setEab_rgs_key(?string $eab_rgs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eab_rgs_key) && !is_string($eab_rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eab_rgs_key, true), gettype($eab_rgs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eab_rgs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eab_rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eab_rgs_key, true)), __LINE__);
        }
        if (is_null($eab_rgs_key) || (is_array($eab_rgs_key) && empty($eab_rgs_key))) {
            unset($this->eab_rgs_key);
        } else {
            $this->eab_rgs_key = $eab_rgs_key;
        }
        
        return $this;
    }
    /**
     * Get eab_rgs_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEab_rgs_reg_key(): ?string
    {
        return $this->eab_rgs_reg_key ?? null;
    }
    /**
     * Set eab_rgs_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eab_rgs_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_rgs_reg_key_Query_DataObjectType
     */
    public function setEab_rgs_reg_key(?string $eab_rgs_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eab_rgs_reg_key) && !is_string($eab_rgs_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eab_rgs_reg_key, true), gettype($eab_rgs_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eab_rgs_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eab_rgs_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eab_rgs_reg_key, true)), __LINE__);
        }
        if (is_null($eab_rgs_reg_key) || (is_array($eab_rgs_reg_key) && empty($eab_rgs_reg_key))) {
            unset($this->eab_rgs_reg_key);
        } else {
            $this->eab_rgs_reg_key = $eab_rgs_reg_key;
        }
        
        return $this;
    }
    /**
     * Get eab_rgs_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEab_rgs_gft_key(): ?string
    {
        return $this->eab_rgs_gft_key ?? null;
    }
    /**
     * Set eab_rgs_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eab_rgs_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_rgs_reg_key_Query_DataObjectType
     */
    public function setEab_rgs_gft_key(?string $eab_rgs_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eab_rgs_gft_key) && !is_string($eab_rgs_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eab_rgs_gft_key, true), gettype($eab_rgs_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eab_rgs_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eab_rgs_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eab_rgs_gft_key, true)), __LINE__);
        }
        if (is_null($eab_rgs_gft_key) || (is_array($eab_rgs_gft_key) && empty($eab_rgs_gft_key))) {
            unset($this->eab_rgs_gft_key);
        } else {
            $this->eab_rgs_gft_key = $eab_rgs_gft_key;
        }
        
        return $this;
    }
}
