<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAudience StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class GetAudience extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $currentPage;
    /**
     * The qrh_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $qrh_key = null;
    /**
     * The WithDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $WithDescriptions = null;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $Parameters = null;
    /**
     * Constructor method for GetAudience
     * @uses GetAudience::setCurrentPage()
     * @uses GetAudience::setQrh_key()
     * @uses GetAudience::setWithDescriptions()
     * @uses GetAudience::setParameters()
     * @param int $currentPage
     * @param string $qrh_key
     * @param string $withDescriptions
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     */
    public function __construct(int $currentPage, ?string $qrh_key = null, ?string $withDescriptions = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setQrh_key($qrh_key)
            ->setWithDescriptions($withDescriptions)
            ->setParameters($parameters);
    }
    /**
     * Get currentPage value
     * @return int
     */
    public function getCurrentPage(): int
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudience
     */
    public function setCurrentPage(int $currentPage): self
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        
        return $this;
    }
    /**
     * Get qrh_key value
     * @return string|null
     */
    public function getQrh_key(): ?string
    {
        return $this->qrh_key;
    }
    /**
     * Set qrh_key value
     * @param string $qrh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudience
     */
    public function setQrh_key(?string $qrh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($qrh_key) && !is_string($qrh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrh_key, true), gettype($qrh_key)), __LINE__);
        }
        $this->qrh_key = $qrh_key;
        
        return $this;
    }
    /**
     * Get WithDescriptions value
     * @return string|null
     */
    public function getWithDescriptions(): ?string
    {
        return $this->WithDescriptions;
    }
    /**
     * Set WithDescriptions value
     * @param string $withDescriptions
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudience
     */
    public function setWithDescriptions(?string $withDescriptions = null): self
    {
        // validation for constraint: string
        if (!is_null($withDescriptions) && !is_string($withDescriptions)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withDescriptions, true), gettype($withDescriptions)), __LINE__);
        }
        $this->WithDescriptions = $withDescriptions;
        
        return $this;
    }
    /**
     * Get Parameters value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    public function getParameters(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudience
     */
    public function setParameters(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null): self
    {
        $this->Parameters = $parameters;
        
        return $this;
    }
}
