<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerCommunicationPreference StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class GetCustomerCommunicationPreference extends AbstractStructBase
{
    /**
     * The customerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $customerKey = null;
    /**
     * The preferenceTypeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $preferenceTypeKey = null;
    /**
     * Constructor method for GetCustomerCommunicationPreference
     * @uses GetCustomerCommunicationPreference::setCustomerKey()
     * @uses GetCustomerCommunicationPreference::setPreferenceTypeKey()
     * @param string $customerKey
     * @param string $preferenceTypeKey
     */
    public function __construct(?string $customerKey = null, ?string $preferenceTypeKey = null)
    {
        $this
            ->setCustomerKey($customerKey)
            ->setPreferenceTypeKey($preferenceTypeKey);
    }
    /**
     * Get customerKey value
     * @return string|null
     */
    public function getCustomerKey(): ?string
    {
        return $this->customerKey;
    }
    /**
     * Set customerKey value
     * @param string $customerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreference
     */
    public function setCustomerKey(?string $customerKey = null): self
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->customerKey = $customerKey;
        
        return $this;
    }
    /**
     * Get preferenceTypeKey value
     * @return string|null
     */
    public function getPreferenceTypeKey(): ?string
    {
        return $this->preferenceTypeKey;
    }
    /**
     * Set preferenceTypeKey value
     * @param string $preferenceTypeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreference
     */
    public function setPreferenceTypeKey(?string $preferenceTypeKey = null): self
    {
        // validation for constraint: string
        if (!is_null($preferenceTypeKey) && !is_string($preferenceTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferenceTypeKey, true), gettype($preferenceTypeKey)), __LINE__);
        }
        $this->preferenceTypeKey = $preferenceTypeKey;
        
        return $this;
    }
}
