<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFundraisingEventRegistrantionTotal StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class GetFundraisingEventRegistrantionTotal extends AbstractStructBase
{
    /**
     * The eventKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $eventKey = null;
    /**
     * The customerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $customerKey = null;
    /**
     * Constructor method for GetFundraisingEventRegistrantionTotal
     * @uses GetFundraisingEventRegistrantionTotal::setEventKey()
     * @uses GetFundraisingEventRegistrantionTotal::setCustomerKey()
     * @param string $eventKey
     * @param string $customerKey
     */
    public function __construct(?string $eventKey = null, ?string $customerKey = null)
    {
        $this
            ->setEventKey($eventKey)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get eventKey value
     * @return string|null
     */
    public function getEventKey(): ?string
    {
        return $this->eventKey;
    }
    /**
     * Set eventKey value
     * @param string $eventKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotal
     */
    public function setEventKey(?string $eventKey = null): self
    {
        // validation for constraint: string
        if (!is_null($eventKey) && !is_string($eventKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventKey, true), gettype($eventKey)), __LINE__);
        }
        $this->eventKey = $eventKey;
        
        return $this;
    }
    /**
     * Get customerKey value
     * @return string|null
     */
    public function getCustomerKey(): ?string
    {
        return $this->customerKey;
    }
    /**
     * Set customerKey value
     * @param string $customerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotal
     */
    public function setCustomerKey(?string $customerKey = null): self
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->customerKey = $customerKey;
        
        return $this;
    }
}
