<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrganizationInformation StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class GetOrganizationInformation extends AbstractStructBase
{
    /**
     * The OrganizationKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $OrganizationKey;
    /**
     * Constructor method for GetOrganizationInformation
     * @uses GetOrganizationInformation::setOrganizationKey()
     * @param string $organizationKey
     */
    public function __construct(?string $organizationKey)
    {
        $this
            ->setOrganizationKey($organizationKey);
    }
    /**
     * Get OrganizationKey value
     * @return string|null
     */
    public function getOrganizationKey(): ?string
    {
        return $this->OrganizationKey;
    }
    /**
     * Set OrganizationKey value
     * @param string $organizationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetOrganizationInformation
     */
    public function setOrganizationKey(?string $organizationKey): self
    {
        // validation for constraint: string
        if (!is_null($organizationKey) && !is_string($organizationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationKey, true), gettype($organizationKey)), __LINE__);
        }
        $this->OrganizationKey = $organizationKey;
        
        return $this;
    }
}
