<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndividualAddress_Primary_Affiliation_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class IndividualAddress_Primary_Affiliation_DataObjectType extends AbstractStructBase
{
    /**
     * The ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_key = null;
    /**
     * The ixo_rlt_code
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_rlt_code = null;
    /**
     * The ixo_title
     * Meta information extracted from the WSDL
     * - documentation: Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_title = null;
    /**
     * The ixo_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_start_date = null;
    /**
     * The ixo_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_end_date = null;
    /**
     * The ixo_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Individual Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_ind_cst_key = null;
    /**
     * The ixo_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_org_cst_key = null;
    /**
     * The ixo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_add_date = null;
    /**
     * The ixo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_add_user = null;
    /**
     * The ixo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_change_date = null;
    /**
     * The ixo_rlt_key
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_rlt_key = null;
    /**
     * The ixo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_change_user = null;
    /**
     * The ixo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_delete_flag = null;
    /**
     * The ixo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_key_ext = null;
    /**
     * The ixo_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Owning Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_cst_key_owner = null;
    /**
     * The ixo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixo_entity_key = null;
    /**
     * The ixo_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixo_void_flag = null;
    /**
     * Constructor method for IndividualAddress_Primary_Affiliation_DataObjectType
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_key()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_rlt_code()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_title()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_start_date()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_end_date()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_ind_cst_key()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_org_cst_key()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_add_date()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_add_user()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_change_date()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_rlt_key()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_change_user()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_delete_flag()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_key_ext()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_cst_key_owner()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_entity_key()
     * @uses IndividualAddress_Primary_Affiliation_DataObjectType::setIxo_void_flag()
     * @param string $ixo_key
     * @param string $ixo_rlt_code
     * @param string $ixo_title
     * @param string $ixo_start_date
     * @param string $ixo_end_date
     * @param string $ixo_ind_cst_key
     * @param string $ixo_org_cst_key
     * @param string $ixo_add_date
     * @param string $ixo_add_user
     * @param string $ixo_change_date
     * @param string $ixo_rlt_key
     * @param string $ixo_change_user
     * @param string $ixo_delete_flag
     * @param string $ixo_key_ext
     * @param string $ixo_cst_key_owner
     * @param string $ixo_entity_key
     * @param string $ixo_void_flag
     */
    public function __construct(?string $ixo_key = null, ?string $ixo_rlt_code = null, ?string $ixo_title = null, ?string $ixo_start_date = null, ?string $ixo_end_date = null, ?string $ixo_ind_cst_key = null, ?string $ixo_org_cst_key = null, ?string $ixo_add_date = null, ?string $ixo_add_user = null, ?string $ixo_change_date = null, ?string $ixo_rlt_key = null, ?string $ixo_change_user = null, ?string $ixo_delete_flag = null, ?string $ixo_key_ext = null, ?string $ixo_cst_key_owner = null, ?string $ixo_entity_key = null, ?string $ixo_void_flag = null)
    {
        $this
            ->setIxo_key($ixo_key)
            ->setIxo_rlt_code($ixo_rlt_code)
            ->setIxo_title($ixo_title)
            ->setIxo_start_date($ixo_start_date)
            ->setIxo_end_date($ixo_end_date)
            ->setIxo_ind_cst_key($ixo_ind_cst_key)
            ->setIxo_org_cst_key($ixo_org_cst_key)
            ->setIxo_add_date($ixo_add_date)
            ->setIxo_add_user($ixo_add_user)
            ->setIxo_change_date($ixo_change_date)
            ->setIxo_rlt_key($ixo_rlt_key)
            ->setIxo_change_user($ixo_change_user)
            ->setIxo_delete_flag($ixo_delete_flag)
            ->setIxo_key_ext($ixo_key_ext)
            ->setIxo_cst_key_owner($ixo_cst_key_owner)
            ->setIxo_entity_key($ixo_entity_key)
            ->setIxo_void_flag($ixo_void_flag);
    }
    /**
     * Get ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_key(): ?string
    {
        return $this->ixo_key ?? null;
    }
    /**
     * Set ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_key(?string $ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_key) && !is_string($ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_key, true), gettype($ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_key, true)), __LINE__);
        }
        if (is_null($ixo_key) || (is_array($ixo_key) && empty($ixo_key))) {
            unset($this->ixo_key);
        } else {
            $this->ixo_key = $ixo_key;
        }
        
        return $this;
    }
    /**
     * Get ixo_rlt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_rlt_code(): ?string
    {
        return $this->ixo_rlt_code ?? null;
    }
    /**
     * Set ixo_rlt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_rlt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_rlt_code(?string $ixo_rlt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_rlt_code) && !is_string($ixo_rlt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_rlt_code, true), gettype($ixo_rlt_code)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($ixo_rlt_code) && mb_strlen((string) $ixo_rlt_code) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $ixo_rlt_code)), __LINE__);
        }
        if (is_null($ixo_rlt_code) || (is_array($ixo_rlt_code) && empty($ixo_rlt_code))) {
            unset($this->ixo_rlt_code);
        } else {
            $this->ixo_rlt_code = $ixo_rlt_code;
        }
        
        return $this;
    }
    /**
     * Get ixo_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_title(): ?string
    {
        return $this->ixo_title ?? null;
    }
    /**
     * Set ixo_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_title(?string $ixo_title = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_title) && !is_string($ixo_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_title, true), gettype($ixo_title)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($ixo_title) && mb_strlen((string) $ixo_title) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $ixo_title)), __LINE__);
        }
        if (is_null($ixo_title) || (is_array($ixo_title) && empty($ixo_title))) {
            unset($this->ixo_title);
        } else {
            $this->ixo_title = $ixo_title;
        }
        
        return $this;
    }
    /**
     * Get ixo_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_start_date(): ?string
    {
        return $this->ixo_start_date ?? null;
    }
    /**
     * Set ixo_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_start_date(?string $ixo_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_start_date) && !is_string($ixo_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_start_date, true), gettype($ixo_start_date)), __LINE__);
        }
        if (is_null($ixo_start_date) || (is_array($ixo_start_date) && empty($ixo_start_date))) {
            unset($this->ixo_start_date);
        } else {
            $this->ixo_start_date = $ixo_start_date;
        }
        
        return $this;
    }
    /**
     * Get ixo_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_end_date(): ?string
    {
        return $this->ixo_end_date ?? null;
    }
    /**
     * Set ixo_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_end_date(?string $ixo_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_end_date) && !is_string($ixo_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_end_date, true), gettype($ixo_end_date)), __LINE__);
        }
        if (is_null($ixo_end_date) || (is_array($ixo_end_date) && empty($ixo_end_date))) {
            unset($this->ixo_end_date);
        } else {
            $this->ixo_end_date = $ixo_end_date;
        }
        
        return $this;
    }
    /**
     * Get ixo_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_ind_cst_key(): ?string
    {
        return $this->ixo_ind_cst_key ?? null;
    }
    /**
     * Set ixo_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_ind_cst_key(?string $ixo_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_ind_cst_key) && !is_string($ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_ind_cst_key, true), gettype($ixo_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_ind_cst_key, true)), __LINE__);
        }
        if (is_null($ixo_ind_cst_key) || (is_array($ixo_ind_cst_key) && empty($ixo_ind_cst_key))) {
            unset($this->ixo_ind_cst_key);
        } else {
            $this->ixo_ind_cst_key = $ixo_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ixo_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_org_cst_key(): ?string
    {
        return $this->ixo_org_cst_key ?? null;
    }
    /**
     * Set ixo_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_org_cst_key(?string $ixo_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_org_cst_key) && !is_string($ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_org_cst_key, true), gettype($ixo_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_org_cst_key, true)), __LINE__);
        }
        if (is_null($ixo_org_cst_key) || (is_array($ixo_org_cst_key) && empty($ixo_org_cst_key))) {
            unset($this->ixo_org_cst_key);
        } else {
            $this->ixo_org_cst_key = $ixo_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ixo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_add_date(): ?string
    {
        return $this->ixo_add_date ?? null;
    }
    /**
     * Set ixo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_add_date(?string $ixo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_add_date) && !is_string($ixo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_add_date, true), gettype($ixo_add_date)), __LINE__);
        }
        if (is_null($ixo_add_date) || (is_array($ixo_add_date) && empty($ixo_add_date))) {
            unset($this->ixo_add_date);
        } else {
            $this->ixo_add_date = $ixo_add_date;
        }
        
        return $this;
    }
    /**
     * Get ixo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_add_user(): ?string
    {
        return $this->ixo_add_user ?? null;
    }
    /**
     * Set ixo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_add_user(?string $ixo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_add_user) && !is_string($ixo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_add_user, true), gettype($ixo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ixo_add_user) && mb_strlen((string) $ixo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ixo_add_user)), __LINE__);
        }
        if (is_null($ixo_add_user) || (is_array($ixo_add_user) && empty($ixo_add_user))) {
            unset($this->ixo_add_user);
        } else {
            $this->ixo_add_user = $ixo_add_user;
        }
        
        return $this;
    }
    /**
     * Get ixo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_change_date(): ?string
    {
        return $this->ixo_change_date ?? null;
    }
    /**
     * Set ixo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_change_date(?string $ixo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_change_date) && !is_string($ixo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_change_date, true), gettype($ixo_change_date)), __LINE__);
        }
        if (is_null($ixo_change_date) || (is_array($ixo_change_date) && empty($ixo_change_date))) {
            unset($this->ixo_change_date);
        } else {
            $this->ixo_change_date = $ixo_change_date;
        }
        
        return $this;
    }
    /**
     * Get ixo_rlt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_rlt_key(): ?string
    {
        return $this->ixo_rlt_key ?? null;
    }
    /**
     * Set ixo_rlt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_rlt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_rlt_key(?string $ixo_rlt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_rlt_key) && !is_string($ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_rlt_key, true), gettype($ixo_rlt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_rlt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_rlt_key, true)), __LINE__);
        }
        if (is_null($ixo_rlt_key) || (is_array($ixo_rlt_key) && empty($ixo_rlt_key))) {
            unset($this->ixo_rlt_key);
        } else {
            $this->ixo_rlt_key = $ixo_rlt_key;
        }
        
        return $this;
    }
    /**
     * Get ixo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_change_user(): ?string
    {
        return $this->ixo_change_user ?? null;
    }
    /**
     * Set ixo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_change_user(?string $ixo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_change_user) && !is_string($ixo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_change_user, true), gettype($ixo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ixo_change_user) && mb_strlen((string) $ixo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ixo_change_user)), __LINE__);
        }
        if (is_null($ixo_change_user) || (is_array($ixo_change_user) && empty($ixo_change_user))) {
            unset($this->ixo_change_user);
        } else {
            $this->ixo_change_user = $ixo_change_user;
        }
        
        return $this;
    }
    /**
     * Get ixo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_delete_flag(): ?string
    {
        return $this->ixo_delete_flag ?? null;
    }
    /**
     * Set ixo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_delete_flag(?string $ixo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_delete_flag) && !is_string($ixo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_delete_flag, true), gettype($ixo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ixo_delete_flag) && $ixo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ixo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ixo_delete_flag) && $ixo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ixo_delete_flag, true)), __LINE__);
        }
        if (is_null($ixo_delete_flag) || (is_array($ixo_delete_flag) && empty($ixo_delete_flag))) {
            unset($this->ixo_delete_flag);
        } else {
            $this->ixo_delete_flag = $ixo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ixo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_key_ext(): ?string
    {
        return $this->ixo_key_ext ?? null;
    }
    /**
     * Set ixo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_key_ext(?string $ixo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_key_ext) && !is_string($ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_key_ext, true), gettype($ixo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_key_ext, true)), __LINE__);
        }
        if (is_null($ixo_key_ext) || (is_array($ixo_key_ext) && empty($ixo_key_ext))) {
            unset($this->ixo_key_ext);
        } else {
            $this->ixo_key_ext = $ixo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ixo_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_cst_key_owner(): ?string
    {
        return $this->ixo_cst_key_owner ?? null;
    }
    /**
     * Set ixo_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_cst_key_owner(?string $ixo_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_cst_key_owner) && !is_string($ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_cst_key_owner, true), gettype($ixo_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_cst_key_owner, true)), __LINE__);
        }
        if (is_null($ixo_cst_key_owner) || (is_array($ixo_cst_key_owner) && empty($ixo_cst_key_owner))) {
            unset($this->ixo_cst_key_owner);
        } else {
            $this->ixo_cst_key_owner = $ixo_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get ixo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_entity_key(): ?string
    {
        return $this->ixo_entity_key ?? null;
    }
    /**
     * Set ixo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_entity_key(?string $ixo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_entity_key) && !is_string($ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_entity_key, true), gettype($ixo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixo_entity_key, true)), __LINE__);
        }
        if (is_null($ixo_entity_key) || (is_array($ixo_entity_key) && empty($ixo_entity_key))) {
            unset($this->ixo_entity_key);
        } else {
            $this->ixo_entity_key = $ixo_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ixo_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxo_void_flag(): ?string
    {
        return $this->ixo_void_flag ?? null;
    }
    /**
     * Set ixo_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixo_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
     */
    public function setIxo_void_flag(?string $ixo_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ixo_void_flag) && !is_string($ixo_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixo_void_flag, true), gettype($ixo_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ixo_void_flag) && $ixo_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ixo_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ixo_void_flag) && $ixo_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ixo_void_flag, true)), __LINE__);
        }
        if (is_null($ixo_void_flag) || (is_array($ixo_void_flag) && empty($ixo_void_flag))) {
            unset($this->ixo_void_flag);
        } else {
            $this->ixo_void_flag = $ixo_void_flag;
        }
        
        return $this;
    }
}
