<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndividualPhone_Customer_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class IndividualPhone_Customer_DataObjectType extends AbstractStructBase
{
    /**
     * The cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_key = null;
    /**
     * The cst_type
     * Meta information extracted from the WSDL
     * - documentation: Customer Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_type = null;
    /**
     * The cst_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Name . This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_name_cp = null;
    /**
     * The cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Customer Sort Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_sort_name_dn = null;
    /**
     * The cst_ind_full_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_ind_full_name_dn = null;
    /**
     * The cst_org_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_org_name_dn = null;
    /**
     * The cst_ixo_title_dn
     * Meta information extracted from the WSDL
     * - documentation: Title. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_ixo_title_dn = null;
    /**
     * The cst_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Comm Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_pref_comm_meth = null;
    /**
     * The cst_bio
     * Meta information extracted from the WSDL
     * - documentation: Biographical Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_bio = null;
    /**
     * The cst_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_add_date = null;
    /**
     * The cst_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_add_user = null;
    /**
     * The cst_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_change_date = null;
    /**
     * The cst_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_change_user = null;
    /**
     * The cst_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_delete_flag = null;
    /**
     * The cst_recno
     * Meta information extracted from the WSDL
     * - documentation: Record Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_recno = null;
    /**
     * The cst_id
     * Meta information extracted from the WSDL
     * - documentation: Customer ID. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_id = null;
    /**
     * The cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_key_ext = null;
    /**
     * The cst_email_text_only
     * Meta information extracted from the WSDL
     * - documentation: Send Only Plain Text E-mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_email_text_only = null;
    /**
     * The cst_credit_limit
     * Meta information extracted from the WSDL
     * - documentation: credit limit. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cst_credit_limit = null;
    /**
     * The cst_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_src_key = null;
    /**
     * The cst_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_src_code = null;
    /**
     * The cst_tax_exempt_flag
     * Meta information extracted from the WSDL
     * - documentation: Tax Exempt. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_tax_exempt_flag = null;
    /**
     * The cst_tax_id
     * Meta information extracted from the WSDL
     * - documentation: Tax Id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_tax_id = null;
    /**
     * The cst_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Mailing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cxa_key = null;
    /**
     * The cst_no_email_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact by Email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_email_flag = null;
    /**
     * The cst_cxa_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Billing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cxa_billing_key = null;
    /**
     * The cst_eml_address_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_eml_address_dn = null;
    /**
     * The cst_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_eml_key = null;
    /**
     * The cst_no_phone_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Phone. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_phone_flag = null;
    /**
     * The cst_phn_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_phn_number_complete_dn = null;
    /**
     * The cst_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cph_key = null;
    /**
     * The cst_no_fax_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_fax_flag = null;
    /**
     * The cst_fax_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_fax_number_complete_dn = null;
    /**
     * The cst_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cfx_key = null;
    /**
     * The cst_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_ixo_key = null;
    /**
     * The cst_no_web_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Make Available Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_web_flag = null;
    /**
     * The cst_oldid
     * Meta information extracted from the WSDL
     * - documentation: oldid. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_oldid = null;
    /**
     * The cst_member_flag
     * Meta information extracted from the WSDL
     * - documentation: Member Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_member_flag = null;
    /**
     * The cst_url_code_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Website. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_url_code_dn = null;
    /**
     * The cst_parent_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_parent_cst_key = null;
    /**
     * The cst_url_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Website Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_url_key = null;
    /**
     * The cst_no_msg_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Instant Mess. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_msg_flag = null;
    /**
     * The cst_msg_handle_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Hand. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_msg_handle_dn = null;
    /**
     * The cst_web_login
     * Meta information extracted from the WSDL
     * - documentation: Web Login. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_login = null;
    /**
     * The cst_web_password
     * Meta information extracted from the WSDL
     * - documentation: Web Password. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_password = null;
    /**
     * The cst_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_entity_key = null;
    /**
     * The cst_msg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_msg_key = null;
    /**
     * The cst_no_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_mail_flag = null;
    /**
     * The cst_web_start_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_start_date = null;
    /**
     * The cst_web_end_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_end_date = null;
    /**
     * The cst_web_force_password_change
     * Meta information extracted from the WSDL
     * - documentation: Force User to Change Password. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_force_password_change = null;
    /**
     * The cst_web_login_disabled_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Disabled. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_login_disabled_flag = null;
    /**
     * The cst_comment
     * Meta information extracted from the WSDL
     * - documentation: Comments. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_comment = null;
    /**
     * The cst_credit_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_credit_hold_flag = null;
    /**
     * The cst_credit_hold_reason
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_credit_hold_reason = null;
    /**
     * The cst_web_forgot_password_status
     * Meta information extracted from the WSDL
     * - documentation: Forgot Password Status. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_forgot_password_status = null;
    /**
     * The cst_old_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Old Primary Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_old_cxa_key = null;
    /**
     * The cst_last_email_date
     * Meta information extracted from the WSDL
     * - documentation: last email date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_last_email_date = null;
    /**
     * The cst_no_publish_flag
     * Meta information extracted from the WSDL
     * - documentation: Do not publish to other systems?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_no_publish_flag = null;
    /**
     * The cst_sin_key
     * Meta information extracted from the WSDL
     * - documentation: industry. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_sin_key = null;
    /**
     * The cst_ttl_key
     * Meta information extracted from the WSDL
     * - documentation: title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_ttl_key = null;
    /**
     * The cst_jfn_key
     * Meta information extracted from the WSDL
     * - documentation: job function. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_jfn_key = null;
    /**
     * The cst_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cur_key = null;
    /**
     * The cst_attribute_1
     * Meta information extracted from the WSDL
     * - documentation: price attribute 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_attribute_1 = null;
    /**
     * The cst_attribute_2
     * Meta information extracted from the WSDL
     * - documentation: price attribute 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_attribute_2 = null;
    /**
     * The cst_salutation_1
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_salutation_1 = null;
    /**
     * The cst_salutation_2
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_salutation_2 = null;
    /**
     * The cst_merge_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Merged Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_merge_cst_key = null;
    /**
     * The cst_salutation_3
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_salutation_3 = null;
    /**
     * The cst_salutation_4
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 4. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_salutation_4 = null;
    /**
     * The cst_default_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: default recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_default_recognize_as = null;
    /**
     * The cst_score
     * Meta information extracted from the WSDL
     * - documentation: Score. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cst_score = null;
    /**
     * The cst_score_normalized
     * Meta information extracted from the WSDL
     * - documentation: Normalized Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_score_normalized = null;
    /**
     * The cst_score_trend
     * Meta information extracted from the WSDL
     * - documentation: Scoring Trend. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_score_trend = null;
    /**
     * The cst_vault_account
     * Meta information extracted from the WSDL
     * - documentation: Vault Customer Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_vault_account = null;
    /**
     * The cst_exclude_from_social_flag
     * Meta information extracted from the WSDL
     * - documentation: Exclude from Social. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_exclude_from_social_flag = null;
    /**
     * The cst_social_score
     * Meta information extracted from the WSDL
     * - documentation: Social Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_social_score = null;
    /**
     * The cst_ptin
     * Meta information extracted from the WSDL
     * - documentation: PTIN. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_ptin = null;
    /**
     * The cst_aicpa_member_id
     * Meta information extracted from the WSDL
     * - documentation: AICPA Member ID. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_aicpa_member_id = null;
    /**
     * The cst_vendor_code
     * Meta information extracted from the WSDL
     * - documentation: Vendor Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_vendor_code = null;
    /**
     * The cst_salt
     * Meta information extracted from the WSDL
     * - documentation: Salt. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_salt = null;
    /**
     * The cst_sca_key
     * Meta information extracted from the WSDL
     * - documentation: Primary A-Score Scale. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_sca_key = null;
    /**
     * The cst_iterations
     * Meta information extracted from the WSDL
     * - documentation: Iterations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cst_iterations = null;
    /**
     * The cst_web_password_change_date
     * Meta information extracted from the WSDL
     * - documentation: Web Password Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_password_change_date = null;
    /**
     * The cst_web_failed_login_count
     * Meta information extracted from the WSDL
     * - documentation: Web Failed Login Count. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_failed_login_count = null;
    /**
     * The cst_web_last_failed_login_date
     * Meta information extracted from the WSDL
     * - documentation: Web Last Failed Login Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_last_failed_login_date = null;
    /**
     * The cst_web_login_locked_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Locked. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_web_login_locked_flag = null;
    /**
     * The cst_cph_sms_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Phone SMS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cst_cph_sms_key = null;
    /**
     * The cst_sms_opt
     * Meta information extracted from the WSDL
     * - documentation: SMS OptIn OptOut. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_sms_opt = null;
    /**
     * The cst_sms_consent_type
     * Meta information extracted from the WSDL
     * - documentation: Consent Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_sms_consent_type = null;
    /**
     * The cst_failed_payment_attempts
     * Meta information extracted from the WSDL
     * - documentation: cst_failed_payment_attempts. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cst_failed_payment_attempts = null;
    /**
     * Constructor method for IndividualPhone_Customer_DataObjectType
     * @uses IndividualPhone_Customer_DataObjectType::setCst_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_type()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_name_cp()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_sort_name_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_ind_full_name_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_org_name_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_ixo_title_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_pref_comm_meth()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_bio()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_add_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_add_user()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_change_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_change_user()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_delete_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_recno()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_id()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_key_ext()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_email_text_only()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_credit_limit()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_src_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_src_code()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_tax_exempt_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_tax_id()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cxa_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_email_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cxa_billing_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_eml_address_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_eml_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_phone_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_phn_number_complete_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cph_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_fax_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_fax_number_complete_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cfx_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_ixo_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_web_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_oldid()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_member_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_url_code_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_parent_cst_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_url_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_msg_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_msg_handle_dn()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_login()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_password()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_entity_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_msg_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_mail_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_start_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_end_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_force_password_change()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_login_disabled_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_comment()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_credit_hold_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_credit_hold_reason()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_forgot_password_status()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_old_cxa_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_last_email_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_no_publish_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_sin_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_ttl_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_jfn_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cur_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_attribute_1()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_attribute_2()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_salutation_1()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_salutation_2()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_merge_cst_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_salutation_3()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_salutation_4()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_default_recognize_as()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_score()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_score_normalized()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_score_trend()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_vault_account()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_exclude_from_social_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_social_score()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_ptin()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_aicpa_member_id()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_vendor_code()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_salt()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_sca_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_iterations()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_password_change_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_failed_login_count()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_last_failed_login_date()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_web_login_locked_flag()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_cph_sms_key()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_sms_opt()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_sms_consent_type()
     * @uses IndividualPhone_Customer_DataObjectType::setCst_failed_payment_attempts()
     * @param string $cst_key
     * @param string $cst_type
     * @param string $cst_name_cp
     * @param string $cst_sort_name_dn
     * @param string $cst_ind_full_name_dn
     * @param string $cst_org_name_dn
     * @param string $cst_ixo_title_dn
     * @param string $cst_pref_comm_meth
     * @param string $cst_bio
     * @param string $cst_add_date
     * @param string $cst_add_user
     * @param string $cst_change_date
     * @param string $cst_change_user
     * @param string $cst_delete_flag
     * @param int $cst_recno
     * @param string $cst_id
     * @param string $cst_key_ext
     * @param string $cst_email_text_only
     * @param float $cst_credit_limit
     * @param string $cst_src_key
     * @param string $cst_src_code
     * @param string $cst_tax_exempt_flag
     * @param string $cst_tax_id
     * @param string $cst_cxa_key
     * @param string $cst_no_email_flag
     * @param string $cst_cxa_billing_key
     * @param string $cst_eml_address_dn
     * @param string $cst_eml_key
     * @param string $cst_no_phone_flag
     * @param string $cst_phn_number_complete_dn
     * @param string $cst_cph_key
     * @param string $cst_no_fax_flag
     * @param string $cst_fax_number_complete_dn
     * @param string $cst_cfx_key
     * @param string $cst_ixo_key
     * @param string $cst_no_web_flag
     * @param string $cst_oldid
     * @param string $cst_member_flag
     * @param string $cst_url_code_dn
     * @param string $cst_parent_cst_key
     * @param string $cst_url_key
     * @param string $cst_no_msg_flag
     * @param string $cst_msg_handle_dn
     * @param string $cst_web_login
     * @param string $cst_web_password
     * @param string $cst_entity_key
     * @param string $cst_msg_key
     * @param string $cst_no_mail_flag
     * @param string $cst_web_start_date
     * @param string $cst_web_end_date
     * @param string $cst_web_force_password_change
     * @param string $cst_web_login_disabled_flag
     * @param string $cst_comment
     * @param string $cst_credit_hold_flag
     * @param string $cst_credit_hold_reason
     * @param string $cst_web_forgot_password_status
     * @param string $cst_old_cxa_key
     * @param string $cst_last_email_date
     * @param string $cst_no_publish_flag
     * @param string $cst_sin_key
     * @param string $cst_ttl_key
     * @param string $cst_jfn_key
     * @param string $cst_cur_key
     * @param string $cst_attribute_1
     * @param string $cst_attribute_2
     * @param string $cst_salutation_1
     * @param string $cst_salutation_2
     * @param string $cst_merge_cst_key
     * @param string $cst_salutation_3
     * @param string $cst_salutation_4
     * @param string $cst_default_recognize_as
     * @param float $cst_score
     * @param int $cst_score_normalized
     * @param int $cst_score_trend
     * @param string $cst_vault_account
     * @param string $cst_exclude_from_social_flag
     * @param int $cst_social_score
     * @param string $cst_ptin
     * @param int $cst_aicpa_member_id
     * @param string $cst_vendor_code
     * @param string $cst_salt
     * @param string $cst_sca_key
     * @param int $cst_iterations
     * @param string $cst_web_password_change_date
     * @param string $cst_web_failed_login_count
     * @param string $cst_web_last_failed_login_date
     * @param string $cst_web_login_locked_flag
     * @param string $cst_cph_sms_key
     * @param string $cst_sms_opt
     * @param string $cst_sms_consent_type
     * @param string $cst_failed_payment_attempts
     */
    public function __construct(?string $cst_key = null, ?string $cst_type = null, ?string $cst_name_cp = null, ?string $cst_sort_name_dn = null, ?string $cst_ind_full_name_dn = null, ?string $cst_org_name_dn = null, ?string $cst_ixo_title_dn = null, ?string $cst_pref_comm_meth = null, ?string $cst_bio = null, ?string $cst_add_date = null, ?string $cst_add_user = null, ?string $cst_change_date = null, ?string $cst_change_user = null, ?string $cst_delete_flag = null, ?int $cst_recno = null, ?string $cst_id = null, ?string $cst_key_ext = null, ?string $cst_email_text_only = null, ?float $cst_credit_limit = null, ?string $cst_src_key = null, ?string $cst_src_code = null, ?string $cst_tax_exempt_flag = null, ?string $cst_tax_id = null, ?string $cst_cxa_key = null, ?string $cst_no_email_flag = null, ?string $cst_cxa_billing_key = null, ?string $cst_eml_address_dn = null, ?string $cst_eml_key = null, ?string $cst_no_phone_flag = null, ?string $cst_phn_number_complete_dn = null, ?string $cst_cph_key = null, ?string $cst_no_fax_flag = null, ?string $cst_fax_number_complete_dn = null, ?string $cst_cfx_key = null, ?string $cst_ixo_key = null, ?string $cst_no_web_flag = null, ?string $cst_oldid = null, ?string $cst_member_flag = null, ?string $cst_url_code_dn = null, ?string $cst_parent_cst_key = null, ?string $cst_url_key = null, ?string $cst_no_msg_flag = null, ?string $cst_msg_handle_dn = null, ?string $cst_web_login = null, ?string $cst_web_password = null, ?string $cst_entity_key = null, ?string $cst_msg_key = null, ?string $cst_no_mail_flag = null, ?string $cst_web_start_date = null, ?string $cst_web_end_date = null, ?string $cst_web_force_password_change = null, ?string $cst_web_login_disabled_flag = null, ?string $cst_comment = null, ?string $cst_credit_hold_flag = null, ?string $cst_credit_hold_reason = null, ?string $cst_web_forgot_password_status = null, ?string $cst_old_cxa_key = null, ?string $cst_last_email_date = null, ?string $cst_no_publish_flag = null, ?string $cst_sin_key = null, ?string $cst_ttl_key = null, ?string $cst_jfn_key = null, ?string $cst_cur_key = null, ?string $cst_attribute_1 = null, ?string $cst_attribute_2 = null, ?string $cst_salutation_1 = null, ?string $cst_salutation_2 = null, ?string $cst_merge_cst_key = null, ?string $cst_salutation_3 = null, ?string $cst_salutation_4 = null, ?string $cst_default_recognize_as = null, ?float $cst_score = null, ?int $cst_score_normalized = null, ?int $cst_score_trend = null, ?string $cst_vault_account = null, ?string $cst_exclude_from_social_flag = null, ?int $cst_social_score = null, ?string $cst_ptin = null, ?int $cst_aicpa_member_id = null, ?string $cst_vendor_code = null, ?string $cst_salt = null, ?string $cst_sca_key = null, ?int $cst_iterations = null, ?string $cst_web_password_change_date = null, ?string $cst_web_failed_login_count = null, ?string $cst_web_last_failed_login_date = null, ?string $cst_web_login_locked_flag = null, ?string $cst_cph_sms_key = null, ?string $cst_sms_opt = null, ?string $cst_sms_consent_type = null, ?string $cst_failed_payment_attempts = null)
    {
        $this
            ->setCst_key($cst_key)
            ->setCst_type($cst_type)
            ->setCst_name_cp($cst_name_cp)
            ->setCst_sort_name_dn($cst_sort_name_dn)
            ->setCst_ind_full_name_dn($cst_ind_full_name_dn)
            ->setCst_org_name_dn($cst_org_name_dn)
            ->setCst_ixo_title_dn($cst_ixo_title_dn)
            ->setCst_pref_comm_meth($cst_pref_comm_meth)
            ->setCst_bio($cst_bio)
            ->setCst_add_date($cst_add_date)
            ->setCst_add_user($cst_add_user)
            ->setCst_change_date($cst_change_date)
            ->setCst_change_user($cst_change_user)
            ->setCst_delete_flag($cst_delete_flag)
            ->setCst_recno($cst_recno)
            ->setCst_id($cst_id)
            ->setCst_key_ext($cst_key_ext)
            ->setCst_email_text_only($cst_email_text_only)
            ->setCst_credit_limit($cst_credit_limit)
            ->setCst_src_key($cst_src_key)
            ->setCst_src_code($cst_src_code)
            ->setCst_tax_exempt_flag($cst_tax_exempt_flag)
            ->setCst_tax_id($cst_tax_id)
            ->setCst_cxa_key($cst_cxa_key)
            ->setCst_no_email_flag($cst_no_email_flag)
            ->setCst_cxa_billing_key($cst_cxa_billing_key)
            ->setCst_eml_address_dn($cst_eml_address_dn)
            ->setCst_eml_key($cst_eml_key)
            ->setCst_no_phone_flag($cst_no_phone_flag)
            ->setCst_phn_number_complete_dn($cst_phn_number_complete_dn)
            ->setCst_cph_key($cst_cph_key)
            ->setCst_no_fax_flag($cst_no_fax_flag)
            ->setCst_fax_number_complete_dn($cst_fax_number_complete_dn)
            ->setCst_cfx_key($cst_cfx_key)
            ->setCst_ixo_key($cst_ixo_key)
            ->setCst_no_web_flag($cst_no_web_flag)
            ->setCst_oldid($cst_oldid)
            ->setCst_member_flag($cst_member_flag)
            ->setCst_url_code_dn($cst_url_code_dn)
            ->setCst_parent_cst_key($cst_parent_cst_key)
            ->setCst_url_key($cst_url_key)
            ->setCst_no_msg_flag($cst_no_msg_flag)
            ->setCst_msg_handle_dn($cst_msg_handle_dn)
            ->setCst_web_login($cst_web_login)
            ->setCst_web_password($cst_web_password)
            ->setCst_entity_key($cst_entity_key)
            ->setCst_msg_key($cst_msg_key)
            ->setCst_no_mail_flag($cst_no_mail_flag)
            ->setCst_web_start_date($cst_web_start_date)
            ->setCst_web_end_date($cst_web_end_date)
            ->setCst_web_force_password_change($cst_web_force_password_change)
            ->setCst_web_login_disabled_flag($cst_web_login_disabled_flag)
            ->setCst_comment($cst_comment)
            ->setCst_credit_hold_flag($cst_credit_hold_flag)
            ->setCst_credit_hold_reason($cst_credit_hold_reason)
            ->setCst_web_forgot_password_status($cst_web_forgot_password_status)
            ->setCst_old_cxa_key($cst_old_cxa_key)
            ->setCst_last_email_date($cst_last_email_date)
            ->setCst_no_publish_flag($cst_no_publish_flag)
            ->setCst_sin_key($cst_sin_key)
            ->setCst_ttl_key($cst_ttl_key)
            ->setCst_jfn_key($cst_jfn_key)
            ->setCst_cur_key($cst_cur_key)
            ->setCst_attribute_1($cst_attribute_1)
            ->setCst_attribute_2($cst_attribute_2)
            ->setCst_salutation_1($cst_salutation_1)
            ->setCst_salutation_2($cst_salutation_2)
            ->setCst_merge_cst_key($cst_merge_cst_key)
            ->setCst_salutation_3($cst_salutation_3)
            ->setCst_salutation_4($cst_salutation_4)
            ->setCst_default_recognize_as($cst_default_recognize_as)
            ->setCst_score($cst_score)
            ->setCst_score_normalized($cst_score_normalized)
            ->setCst_score_trend($cst_score_trend)
            ->setCst_vault_account($cst_vault_account)
            ->setCst_exclude_from_social_flag($cst_exclude_from_social_flag)
            ->setCst_social_score($cst_social_score)
            ->setCst_ptin($cst_ptin)
            ->setCst_aicpa_member_id($cst_aicpa_member_id)
            ->setCst_vendor_code($cst_vendor_code)
            ->setCst_salt($cst_salt)
            ->setCst_sca_key($cst_sca_key)
            ->setCst_iterations($cst_iterations)
            ->setCst_web_password_change_date($cst_web_password_change_date)
            ->setCst_web_failed_login_count($cst_web_failed_login_count)
            ->setCst_web_last_failed_login_date($cst_web_last_failed_login_date)
            ->setCst_web_login_locked_flag($cst_web_login_locked_flag)
            ->setCst_cph_sms_key($cst_cph_sms_key)
            ->setCst_sms_opt($cst_sms_opt)
            ->setCst_sms_consent_type($cst_sms_consent_type)
            ->setCst_failed_payment_attempts($cst_failed_payment_attempts);
    }
    /**
     * Get cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_key(): ?string
    {
        return $this->cst_key ?? null;
    }
    /**
     * Set cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_key(?string $cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_key) && !is_string($cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_key, true), gettype($cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_key, true)), __LINE__);
        }
        if (is_null($cst_key) || (is_array($cst_key) && empty($cst_key))) {
            unset($this->cst_key);
        } else {
            $this->cst_key = $cst_key;
        }
        
        return $this;
    }
    /**
     * Get cst_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_type(): ?string
    {
        return $this->cst_type ?? null;
    }
    /**
     * Set cst_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_type(?string $cst_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_type) && !is_string($cst_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_type, true), gettype($cst_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cst_type) && mb_strlen((string) $cst_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cst_type)), __LINE__);
        }
        if (is_null($cst_type) || (is_array($cst_type) && empty($cst_type))) {
            unset($this->cst_type);
        } else {
            $this->cst_type = $cst_type;
        }
        
        return $this;
    }
    /**
     * Get cst_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_name_cp(): ?string
    {
        return $this->cst_name_cp ?? null;
    }
    /**
     * Set cst_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_name_cp(?string $cst_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_name_cp) && !is_string($cst_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_name_cp, true), gettype($cst_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cst_name_cp) && mb_strlen((string) $cst_name_cp) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cst_name_cp)), __LINE__);
        }
        if (is_null($cst_name_cp) || (is_array($cst_name_cp) && empty($cst_name_cp))) {
            unset($this->cst_name_cp);
        } else {
            $this->cst_name_cp = $cst_name_cp;
        }
        
        return $this;
    }
    /**
     * Get cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_sort_name_dn(): ?string
    {
        return $this->cst_sort_name_dn ?? null;
    }
    /**
     * Set cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_sort_name_dn(?string $cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_sort_name_dn) && !is_string($cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_sort_name_dn, true), gettype($cst_sort_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cst_sort_name_dn) && mb_strlen((string) $cst_sort_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cst_sort_name_dn)), __LINE__);
        }
        if (is_null($cst_sort_name_dn) || (is_array($cst_sort_name_dn) && empty($cst_sort_name_dn))) {
            unset($this->cst_sort_name_dn);
        } else {
            $this->cst_sort_name_dn = $cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_ind_full_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_ind_full_name_dn(): ?string
    {
        return $this->cst_ind_full_name_dn ?? null;
    }
    /**
     * Set cst_ind_full_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_ind_full_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_ind_full_name_dn(?string $cst_ind_full_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_ind_full_name_dn) && !is_string($cst_ind_full_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_ind_full_name_dn, true), gettype($cst_ind_full_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cst_ind_full_name_dn) && mb_strlen((string) $cst_ind_full_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cst_ind_full_name_dn)), __LINE__);
        }
        if (is_null($cst_ind_full_name_dn) || (is_array($cst_ind_full_name_dn) && empty($cst_ind_full_name_dn))) {
            unset($this->cst_ind_full_name_dn);
        } else {
            $this->cst_ind_full_name_dn = $cst_ind_full_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_org_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_org_name_dn(): ?string
    {
        return $this->cst_org_name_dn ?? null;
    }
    /**
     * Set cst_org_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_org_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_org_name_dn(?string $cst_org_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_org_name_dn) && !is_string($cst_org_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_org_name_dn, true), gettype($cst_org_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cst_org_name_dn) && mb_strlen((string) $cst_org_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cst_org_name_dn)), __LINE__);
        }
        if (is_null($cst_org_name_dn) || (is_array($cst_org_name_dn) && empty($cst_org_name_dn))) {
            unset($this->cst_org_name_dn);
        } else {
            $this->cst_org_name_dn = $cst_org_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_ixo_title_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_ixo_title_dn(): ?string
    {
        return $this->cst_ixo_title_dn ?? null;
    }
    /**
     * Set cst_ixo_title_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_ixo_title_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_ixo_title_dn(?string $cst_ixo_title_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_ixo_title_dn) && !is_string($cst_ixo_title_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_ixo_title_dn, true), gettype($cst_ixo_title_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cst_ixo_title_dn) && mb_strlen((string) $cst_ixo_title_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cst_ixo_title_dn)), __LINE__);
        }
        if (is_null($cst_ixo_title_dn) || (is_array($cst_ixo_title_dn) && empty($cst_ixo_title_dn))) {
            unset($this->cst_ixo_title_dn);
        } else {
            $this->cst_ixo_title_dn = $cst_ixo_title_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_pref_comm_meth(): ?string
    {
        return $this->cst_pref_comm_meth ?? null;
    }
    /**
     * Set cst_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_pref_comm_meth(?string $cst_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_pref_comm_meth) && !is_string($cst_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_pref_comm_meth, true), gettype($cst_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cst_pref_comm_meth) && mb_strlen((string) $cst_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cst_pref_comm_meth)), __LINE__);
        }
        if (is_null($cst_pref_comm_meth) || (is_array($cst_pref_comm_meth) && empty($cst_pref_comm_meth))) {
            unset($this->cst_pref_comm_meth);
        } else {
            $this->cst_pref_comm_meth = $cst_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get cst_bio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_bio(): ?string
    {
        return $this->cst_bio ?? null;
    }
    /**
     * Set cst_bio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_bio
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_bio(?string $cst_bio = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_bio) && !is_string($cst_bio)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_bio, true), gettype($cst_bio)), __LINE__);
        }
        if (is_null($cst_bio) || (is_array($cst_bio) && empty($cst_bio))) {
            unset($this->cst_bio);
        } else {
            $this->cst_bio = $cst_bio;
        }
        
        return $this;
    }
    /**
     * Get cst_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_add_date(): ?string
    {
        return $this->cst_add_date ?? null;
    }
    /**
     * Set cst_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_add_date(?string $cst_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_add_date) && !is_string($cst_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_add_date, true), gettype($cst_add_date)), __LINE__);
        }
        if (is_null($cst_add_date) || (is_array($cst_add_date) && empty($cst_add_date))) {
            unset($this->cst_add_date);
        } else {
            $this->cst_add_date = $cst_add_date;
        }
        
        return $this;
    }
    /**
     * Get cst_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_add_user(): ?string
    {
        return $this->cst_add_user ?? null;
    }
    /**
     * Set cst_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_add_user(?string $cst_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_add_user) && !is_string($cst_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_add_user, true), gettype($cst_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cst_add_user) && mb_strlen((string) $cst_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cst_add_user)), __LINE__);
        }
        if (is_null($cst_add_user) || (is_array($cst_add_user) && empty($cst_add_user))) {
            unset($this->cst_add_user);
        } else {
            $this->cst_add_user = $cst_add_user;
        }
        
        return $this;
    }
    /**
     * Get cst_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_change_date(): ?string
    {
        return $this->cst_change_date ?? null;
    }
    /**
     * Set cst_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_change_date(?string $cst_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_change_date) && !is_string($cst_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_change_date, true), gettype($cst_change_date)), __LINE__);
        }
        if (is_null($cst_change_date) || (is_array($cst_change_date) && empty($cst_change_date))) {
            unset($this->cst_change_date);
        } else {
            $this->cst_change_date = $cst_change_date;
        }
        
        return $this;
    }
    /**
     * Get cst_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_change_user(): ?string
    {
        return $this->cst_change_user ?? null;
    }
    /**
     * Set cst_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_change_user(?string $cst_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_change_user) && !is_string($cst_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_change_user, true), gettype($cst_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cst_change_user) && mb_strlen((string) $cst_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cst_change_user)), __LINE__);
        }
        if (is_null($cst_change_user) || (is_array($cst_change_user) && empty($cst_change_user))) {
            unset($this->cst_change_user);
        } else {
            $this->cst_change_user = $cst_change_user;
        }
        
        return $this;
    }
    /**
     * Get cst_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_delete_flag(): ?string
    {
        return $this->cst_delete_flag ?? null;
    }
    /**
     * Set cst_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_delete_flag(?string $cst_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_delete_flag) && !is_string($cst_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_delete_flag, true), gettype($cst_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_delete_flag) && $cst_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_delete_flag) && $cst_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_delete_flag, true)), __LINE__);
        }
        if (is_null($cst_delete_flag) || (is_array($cst_delete_flag) && empty($cst_delete_flag))) {
            unset($this->cst_delete_flag);
        } else {
            $this->cst_delete_flag = $cst_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_recno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_recno(): ?int
    {
        return $this->cst_recno ?? null;
    }
    /**
     * Set cst_recno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_recno
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_recno(?int $cst_recno = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_recno) && !(is_int($cst_recno) || ctype_digit($cst_recno))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_recno, true), gettype($cst_recno)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cst_recno) && $cst_recno > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cst_recno, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cst_recno) && $cst_recno < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cst_recno, true)), __LINE__);
        }
        if (is_null($cst_recno) || (is_array($cst_recno) && empty($cst_recno))) {
            unset($this->cst_recno);
        } else {
            $this->cst_recno = $cst_recno;
        }
        
        return $this;
    }
    /**
     * Get cst_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_id(): ?string
    {
        return $this->cst_id ?? null;
    }
    /**
     * Set cst_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_id(?string $cst_id = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_id) && !is_string($cst_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_id, true), gettype($cst_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cst_id) && mb_strlen((string) $cst_id) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cst_id)), __LINE__);
        }
        if (is_null($cst_id) || (is_array($cst_id) && empty($cst_id))) {
            unset($this->cst_id);
        } else {
            $this->cst_id = $cst_id;
        }
        
        return $this;
    }
    /**
     * Get cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_key_ext(): ?string
    {
        return $this->cst_key_ext ?? null;
    }
    /**
     * Set cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_key_ext(?string $cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_key_ext) && !is_string($cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_key_ext, true), gettype($cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_key_ext, true)), __LINE__);
        }
        if (is_null($cst_key_ext) || (is_array($cst_key_ext) && empty($cst_key_ext))) {
            unset($this->cst_key_ext);
        } else {
            $this->cst_key_ext = $cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cst_email_text_only value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_email_text_only(): ?string
    {
        return $this->cst_email_text_only ?? null;
    }
    /**
     * Set cst_email_text_only value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_email_text_only
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_email_text_only(?string $cst_email_text_only = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_email_text_only) && !is_string($cst_email_text_only)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_email_text_only, true), gettype($cst_email_text_only)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_email_text_only) && $cst_email_text_only > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_email_text_only, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_email_text_only) && $cst_email_text_only < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_email_text_only, true)), __LINE__);
        }
        if (is_null($cst_email_text_only) || (is_array($cst_email_text_only) && empty($cst_email_text_only))) {
            unset($this->cst_email_text_only);
        } else {
            $this->cst_email_text_only = $cst_email_text_only;
        }
        
        return $this;
    }
    /**
     * Get cst_credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCst_credit_limit(): ?float
    {
        return $this->cst_credit_limit ?? null;
    }
    /**
     * Set cst_credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cst_credit_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_credit_limit(?float $cst_credit_limit = null): self
    {
        // validation for constraint: float
        if (!is_null($cst_credit_limit) && !(is_float($cst_credit_limit) || is_numeric($cst_credit_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cst_credit_limit, true), gettype($cst_credit_limit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cst_credit_limit) && mb_strlen(mb_substr((string) $cst_credit_limit, false !== mb_strpos((string) $cst_credit_limit, '.') ? mb_strpos((string) $cst_credit_limit, '.') + 1 : mb_strlen((string) $cst_credit_limit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cst_credit_limit, true), mb_strlen(mb_substr((string) $cst_credit_limit, mb_strpos((string) $cst_credit_limit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cst_credit_limit) && mb_strlen(preg_replace('/(\D)/', '', (string) $cst_credit_limit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cst_credit_limit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cst_credit_limit))), __LINE__);
        }
        if (is_null($cst_credit_limit) || (is_array($cst_credit_limit) && empty($cst_credit_limit))) {
            unset($this->cst_credit_limit);
        } else {
            $this->cst_credit_limit = $cst_credit_limit;
        }
        
        return $this;
    }
    /**
     * Get cst_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_src_key(): ?string
    {
        return $this->cst_src_key ?? null;
    }
    /**
     * Set cst_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_src_key(?string $cst_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_src_key) && !is_string($cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_src_key, true), gettype($cst_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_src_key, true)), __LINE__);
        }
        if (is_null($cst_src_key) || (is_array($cst_src_key) && empty($cst_src_key))) {
            unset($this->cst_src_key);
        } else {
            $this->cst_src_key = $cst_src_key;
        }
        
        return $this;
    }
    /**
     * Get cst_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_src_code(): ?string
    {
        return $this->cst_src_code ?? null;
    }
    /**
     * Set cst_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_src_code(?string $cst_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_src_code) && !is_string($cst_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_src_code, true), gettype($cst_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_src_code) && mb_strlen((string) $cst_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_src_code)), __LINE__);
        }
        if (is_null($cst_src_code) || (is_array($cst_src_code) && empty($cst_src_code))) {
            unset($this->cst_src_code);
        } else {
            $this->cst_src_code = $cst_src_code;
        }
        
        return $this;
    }
    /**
     * Get cst_tax_exempt_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_tax_exempt_flag(): ?string
    {
        return $this->cst_tax_exempt_flag ?? null;
    }
    /**
     * Set cst_tax_exempt_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_tax_exempt_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_tax_exempt_flag(?string $cst_tax_exempt_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_tax_exempt_flag) && !is_string($cst_tax_exempt_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_tax_exempt_flag, true), gettype($cst_tax_exempt_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_tax_exempt_flag) && $cst_tax_exempt_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_tax_exempt_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_tax_exempt_flag) && $cst_tax_exempt_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_tax_exempt_flag, true)), __LINE__);
        }
        if (is_null($cst_tax_exempt_flag) || (is_array($cst_tax_exempt_flag) && empty($cst_tax_exempt_flag))) {
            unset($this->cst_tax_exempt_flag);
        } else {
            $this->cst_tax_exempt_flag = $cst_tax_exempt_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_tax_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_tax_id(): ?string
    {
        return $this->cst_tax_id ?? null;
    }
    /**
     * Set cst_tax_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_tax_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_tax_id(?string $cst_tax_id = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_tax_id) && !is_string($cst_tax_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_tax_id, true), gettype($cst_tax_id)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cst_tax_id) && mb_strlen((string) $cst_tax_id) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cst_tax_id)), __LINE__);
        }
        if (is_null($cst_tax_id) || (is_array($cst_tax_id) && empty($cst_tax_id))) {
            unset($this->cst_tax_id);
        } else {
            $this->cst_tax_id = $cst_tax_id;
        }
        
        return $this;
    }
    /**
     * Get cst_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cxa_key(): ?string
    {
        return $this->cst_cxa_key ?? null;
    }
    /**
     * Set cst_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cxa_key(?string $cst_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cxa_key) && !is_string($cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cxa_key, true), gettype($cst_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cxa_key, true)), __LINE__);
        }
        if (is_null($cst_cxa_key) || (is_array($cst_cxa_key) && empty($cst_cxa_key))) {
            unset($this->cst_cxa_key);
        } else {
            $this->cst_cxa_key = $cst_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_email_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_email_flag(): ?string
    {
        return $this->cst_no_email_flag ?? null;
    }
    /**
     * Set cst_no_email_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_email_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_email_flag(?string $cst_no_email_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_email_flag) && !is_string($cst_no_email_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_email_flag, true), gettype($cst_no_email_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_email_flag) && $cst_no_email_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_email_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_email_flag) && $cst_no_email_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_email_flag, true)), __LINE__);
        }
        if (is_null($cst_no_email_flag) || (is_array($cst_no_email_flag) && empty($cst_no_email_flag))) {
            unset($this->cst_no_email_flag);
        } else {
            $this->cst_no_email_flag = $cst_no_email_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_cxa_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cxa_billing_key(): ?string
    {
        return $this->cst_cxa_billing_key ?? null;
    }
    /**
     * Set cst_cxa_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cxa_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cxa_billing_key(?string $cst_cxa_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cxa_billing_key) && !is_string($cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cxa_billing_key, true), gettype($cst_cxa_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cxa_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cxa_billing_key, true)), __LINE__);
        }
        if (is_null($cst_cxa_billing_key) || (is_array($cst_cxa_billing_key) && empty($cst_cxa_billing_key))) {
            unset($this->cst_cxa_billing_key);
        } else {
            $this->cst_cxa_billing_key = $cst_cxa_billing_key;
        }
        
        return $this;
    }
    /**
     * Get cst_eml_address_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_eml_address_dn(): ?string
    {
        return $this->cst_eml_address_dn ?? null;
    }
    /**
     * Set cst_eml_address_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_eml_address_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_eml_address_dn(?string $cst_eml_address_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_eml_address_dn) && !is_string($cst_eml_address_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_eml_address_dn, true), gettype($cst_eml_address_dn)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cst_eml_address_dn) && mb_strlen((string) $cst_eml_address_dn) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cst_eml_address_dn)), __LINE__);
        }
        if (is_null($cst_eml_address_dn) || (is_array($cst_eml_address_dn) && empty($cst_eml_address_dn))) {
            unset($this->cst_eml_address_dn);
        } else {
            $this->cst_eml_address_dn = $cst_eml_address_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_eml_key(): ?string
    {
        return $this->cst_eml_key ?? null;
    }
    /**
     * Set cst_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_eml_key(?string $cst_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_eml_key) && !is_string($cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_eml_key, true), gettype($cst_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_eml_key, true)), __LINE__);
        }
        if (is_null($cst_eml_key) || (is_array($cst_eml_key) && empty($cst_eml_key))) {
            unset($this->cst_eml_key);
        } else {
            $this->cst_eml_key = $cst_eml_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_phone_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_phone_flag(): ?string
    {
        return $this->cst_no_phone_flag ?? null;
    }
    /**
     * Set cst_no_phone_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_phone_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_phone_flag(?string $cst_no_phone_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_phone_flag) && !is_string($cst_no_phone_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_phone_flag, true), gettype($cst_no_phone_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_phone_flag) && $cst_no_phone_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_phone_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_phone_flag) && $cst_no_phone_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_phone_flag, true)), __LINE__);
        }
        if (is_null($cst_no_phone_flag) || (is_array($cst_no_phone_flag) && empty($cst_no_phone_flag))) {
            unset($this->cst_no_phone_flag);
        } else {
            $this->cst_no_phone_flag = $cst_no_phone_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_phn_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_phn_number_complete_dn(): ?string
    {
        return $this->cst_phn_number_complete_dn ?? null;
    }
    /**
     * Set cst_phn_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_phn_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_phn_number_complete_dn(?string $cst_phn_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_phn_number_complete_dn) && !is_string($cst_phn_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_phn_number_complete_dn, true), gettype($cst_phn_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cst_phn_number_complete_dn) && mb_strlen((string) $cst_phn_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cst_phn_number_complete_dn)), __LINE__);
        }
        if (is_null($cst_phn_number_complete_dn) || (is_array($cst_phn_number_complete_dn) && empty($cst_phn_number_complete_dn))) {
            unset($this->cst_phn_number_complete_dn);
        } else {
            $this->cst_phn_number_complete_dn = $cst_phn_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cph_key(): ?string
    {
        return $this->cst_cph_key ?? null;
    }
    /**
     * Set cst_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cph_key(?string $cst_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cph_key) && !is_string($cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cph_key, true), gettype($cst_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cph_key, true)), __LINE__);
        }
        if (is_null($cst_cph_key) || (is_array($cst_cph_key) && empty($cst_cph_key))) {
            unset($this->cst_cph_key);
        } else {
            $this->cst_cph_key = $cst_cph_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_fax_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_fax_flag(): ?string
    {
        return $this->cst_no_fax_flag ?? null;
    }
    /**
     * Set cst_no_fax_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_fax_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_fax_flag(?string $cst_no_fax_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_fax_flag) && !is_string($cst_no_fax_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_fax_flag, true), gettype($cst_no_fax_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_fax_flag) && $cst_no_fax_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_fax_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_fax_flag) && $cst_no_fax_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_fax_flag, true)), __LINE__);
        }
        if (is_null($cst_no_fax_flag) || (is_array($cst_no_fax_flag) && empty($cst_no_fax_flag))) {
            unset($this->cst_no_fax_flag);
        } else {
            $this->cst_no_fax_flag = $cst_no_fax_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_fax_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_fax_number_complete_dn(): ?string
    {
        return $this->cst_fax_number_complete_dn ?? null;
    }
    /**
     * Set cst_fax_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_fax_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_fax_number_complete_dn(?string $cst_fax_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_fax_number_complete_dn) && !is_string($cst_fax_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_fax_number_complete_dn, true), gettype($cst_fax_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cst_fax_number_complete_dn) && mb_strlen((string) $cst_fax_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cst_fax_number_complete_dn)), __LINE__);
        }
        if (is_null($cst_fax_number_complete_dn) || (is_array($cst_fax_number_complete_dn) && empty($cst_fax_number_complete_dn))) {
            unset($this->cst_fax_number_complete_dn);
        } else {
            $this->cst_fax_number_complete_dn = $cst_fax_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cfx_key(): ?string
    {
        return $this->cst_cfx_key ?? null;
    }
    /**
     * Set cst_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cfx_key(?string $cst_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cfx_key) && !is_string($cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cfx_key, true), gettype($cst_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cfx_key, true)), __LINE__);
        }
        if (is_null($cst_cfx_key) || (is_array($cst_cfx_key) && empty($cst_cfx_key))) {
            unset($this->cst_cfx_key);
        } else {
            $this->cst_cfx_key = $cst_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get cst_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_ixo_key(): ?string
    {
        return $this->cst_ixo_key ?? null;
    }
    /**
     * Set cst_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_ixo_key(?string $cst_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_ixo_key) && !is_string($cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_ixo_key, true), gettype($cst_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_ixo_key, true)), __LINE__);
        }
        if (is_null($cst_ixo_key) || (is_array($cst_ixo_key) && empty($cst_ixo_key))) {
            unset($this->cst_ixo_key);
        } else {
            $this->cst_ixo_key = $cst_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_web_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_web_flag(): ?string
    {
        return $this->cst_no_web_flag ?? null;
    }
    /**
     * Set cst_no_web_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_web_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_web_flag(?string $cst_no_web_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_web_flag) && !is_string($cst_no_web_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_web_flag, true), gettype($cst_no_web_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_web_flag) && $cst_no_web_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_web_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_web_flag) && $cst_no_web_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_web_flag, true)), __LINE__);
        }
        if (is_null($cst_no_web_flag) || (is_array($cst_no_web_flag) && empty($cst_no_web_flag))) {
            unset($this->cst_no_web_flag);
        } else {
            $this->cst_no_web_flag = $cst_no_web_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_oldid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_oldid(): ?string
    {
        return $this->cst_oldid ?? null;
    }
    /**
     * Set cst_oldid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_oldid
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_oldid(?string $cst_oldid = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_oldid) && !is_string($cst_oldid)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_oldid, true), gettype($cst_oldid)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($cst_oldid) && mb_strlen((string) $cst_oldid) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $cst_oldid)), __LINE__);
        }
        if (is_null($cst_oldid) || (is_array($cst_oldid) && empty($cst_oldid))) {
            unset($this->cst_oldid);
        } else {
            $this->cst_oldid = $cst_oldid;
        }
        
        return $this;
    }
    /**
     * Get cst_member_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_member_flag(): ?string
    {
        return $this->cst_member_flag ?? null;
    }
    /**
     * Set cst_member_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_member_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_member_flag(?string $cst_member_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_member_flag) && !is_string($cst_member_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_member_flag, true), gettype($cst_member_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_member_flag) && $cst_member_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_member_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_member_flag) && $cst_member_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_member_flag, true)), __LINE__);
        }
        if (is_null($cst_member_flag) || (is_array($cst_member_flag) && empty($cst_member_flag))) {
            unset($this->cst_member_flag);
        } else {
            $this->cst_member_flag = $cst_member_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_url_code_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_url_code_dn(): ?string
    {
        return $this->cst_url_code_dn ?? null;
    }
    /**
     * Set cst_url_code_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_url_code_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_url_code_dn(?string $cst_url_code_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_url_code_dn) && !is_string($cst_url_code_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_url_code_dn, true), gettype($cst_url_code_dn)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($cst_url_code_dn) && mb_strlen((string) $cst_url_code_dn) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $cst_url_code_dn)), __LINE__);
        }
        if (is_null($cst_url_code_dn) || (is_array($cst_url_code_dn) && empty($cst_url_code_dn))) {
            unset($this->cst_url_code_dn);
        } else {
            $this->cst_url_code_dn = $cst_url_code_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_parent_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_parent_cst_key(): ?string
    {
        return $this->cst_parent_cst_key ?? null;
    }
    /**
     * Set cst_parent_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_parent_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_parent_cst_key(?string $cst_parent_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_parent_cst_key) && !is_string($cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_parent_cst_key, true), gettype($cst_parent_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_parent_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_parent_cst_key, true)), __LINE__);
        }
        if (is_null($cst_parent_cst_key) || (is_array($cst_parent_cst_key) && empty($cst_parent_cst_key))) {
            unset($this->cst_parent_cst_key);
        } else {
            $this->cst_parent_cst_key = $cst_parent_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cst_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_url_key(): ?string
    {
        return $this->cst_url_key ?? null;
    }
    /**
     * Set cst_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_url_key(?string $cst_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_url_key) && !is_string($cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_url_key, true), gettype($cst_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_url_key, true)), __LINE__);
        }
        if (is_null($cst_url_key) || (is_array($cst_url_key) && empty($cst_url_key))) {
            unset($this->cst_url_key);
        } else {
            $this->cst_url_key = $cst_url_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_msg_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_msg_flag(): ?string
    {
        return $this->cst_no_msg_flag ?? null;
    }
    /**
     * Set cst_no_msg_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_msg_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_msg_flag(?string $cst_no_msg_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_msg_flag) && !is_string($cst_no_msg_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_msg_flag, true), gettype($cst_no_msg_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_msg_flag) && $cst_no_msg_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_msg_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_msg_flag) && $cst_no_msg_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_msg_flag, true)), __LINE__);
        }
        if (is_null($cst_no_msg_flag) || (is_array($cst_no_msg_flag) && empty($cst_no_msg_flag))) {
            unset($this->cst_no_msg_flag);
        } else {
            $this->cst_no_msg_flag = $cst_no_msg_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_msg_handle_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_msg_handle_dn(): ?string
    {
        return $this->cst_msg_handle_dn ?? null;
    }
    /**
     * Set cst_msg_handle_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_msg_handle_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_msg_handle_dn(?string $cst_msg_handle_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_msg_handle_dn) && !is_string($cst_msg_handle_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_msg_handle_dn, true), gettype($cst_msg_handle_dn)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cst_msg_handle_dn) && mb_strlen((string) $cst_msg_handle_dn) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cst_msg_handle_dn)), __LINE__);
        }
        if (is_null($cst_msg_handle_dn) || (is_array($cst_msg_handle_dn) && empty($cst_msg_handle_dn))) {
            unset($this->cst_msg_handle_dn);
        } else {
            $this->cst_msg_handle_dn = $cst_msg_handle_dn;
        }
        
        return $this;
    }
    /**
     * Get cst_web_login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_login(): ?string
    {
        return $this->cst_web_login ?? null;
    }
    /**
     * Set cst_web_login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_login
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_login(?string $cst_web_login = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_login) && !is_string($cst_web_login)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_login, true), gettype($cst_web_login)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cst_web_login) && mb_strlen((string) $cst_web_login) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cst_web_login)), __LINE__);
        }
        if (is_null($cst_web_login) || (is_array($cst_web_login) && empty($cst_web_login))) {
            unset($this->cst_web_login);
        } else {
            $this->cst_web_login = $cst_web_login;
        }
        
        return $this;
    }
    /**
     * Get cst_web_password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_password(): ?string
    {
        return $this->cst_web_password ?? null;
    }
    /**
     * Set cst_web_password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_password
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_password(?string $cst_web_password = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_password) && !is_string($cst_web_password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_password, true), gettype($cst_web_password)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_web_password) && mb_strlen((string) $cst_web_password) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_web_password)), __LINE__);
        }
        if (is_null($cst_web_password) || (is_array($cst_web_password) && empty($cst_web_password))) {
            unset($this->cst_web_password);
        } else {
            $this->cst_web_password = $cst_web_password;
        }
        
        return $this;
    }
    /**
     * Get cst_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_entity_key(): ?string
    {
        return $this->cst_entity_key ?? null;
    }
    /**
     * Set cst_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_entity_key(?string $cst_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_entity_key) && !is_string($cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_entity_key, true), gettype($cst_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_entity_key, true)), __LINE__);
        }
        if (is_null($cst_entity_key) || (is_array($cst_entity_key) && empty($cst_entity_key))) {
            unset($this->cst_entity_key);
        } else {
            $this->cst_entity_key = $cst_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cst_msg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_msg_key(): ?string
    {
        return $this->cst_msg_key ?? null;
    }
    /**
     * Set cst_msg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_msg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_msg_key(?string $cst_msg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_msg_key) && !is_string($cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_msg_key, true), gettype($cst_msg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_msg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_msg_key, true)), __LINE__);
        }
        if (is_null($cst_msg_key) || (is_array($cst_msg_key) && empty($cst_msg_key))) {
            unset($this->cst_msg_key);
        } else {
            $this->cst_msg_key = $cst_msg_key;
        }
        
        return $this;
    }
    /**
     * Get cst_no_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_mail_flag(): ?string
    {
        return $this->cst_no_mail_flag ?? null;
    }
    /**
     * Set cst_no_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_mail_flag(?string $cst_no_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_mail_flag) && !is_string($cst_no_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_mail_flag, true), gettype($cst_no_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_mail_flag) && $cst_no_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_mail_flag) && $cst_no_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_mail_flag, true)), __LINE__);
        }
        if (is_null($cst_no_mail_flag) || (is_array($cst_no_mail_flag) && empty($cst_no_mail_flag))) {
            unset($this->cst_no_mail_flag);
        } else {
            $this->cst_no_mail_flag = $cst_no_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_web_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_start_date(): ?string
    {
        return $this->cst_web_start_date ?? null;
    }
    /**
     * Set cst_web_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_start_date(?string $cst_web_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_start_date) && !is_string($cst_web_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_start_date, true), gettype($cst_web_start_date)), __LINE__);
        }
        if (is_null($cst_web_start_date) || (is_array($cst_web_start_date) && empty($cst_web_start_date))) {
            unset($this->cst_web_start_date);
        } else {
            $this->cst_web_start_date = $cst_web_start_date;
        }
        
        return $this;
    }
    /**
     * Get cst_web_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_end_date(): ?string
    {
        return $this->cst_web_end_date ?? null;
    }
    /**
     * Set cst_web_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_end_date(?string $cst_web_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_end_date) && !is_string($cst_web_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_end_date, true), gettype($cst_web_end_date)), __LINE__);
        }
        if (is_null($cst_web_end_date) || (is_array($cst_web_end_date) && empty($cst_web_end_date))) {
            unset($this->cst_web_end_date);
        } else {
            $this->cst_web_end_date = $cst_web_end_date;
        }
        
        return $this;
    }
    /**
     * Get cst_web_force_password_change value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_force_password_change(): ?string
    {
        return $this->cst_web_force_password_change ?? null;
    }
    /**
     * Set cst_web_force_password_change value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_force_password_change
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_force_password_change(?string $cst_web_force_password_change = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_force_password_change) && !is_string($cst_web_force_password_change)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_force_password_change, true), gettype($cst_web_force_password_change)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_web_force_password_change) && $cst_web_force_password_change > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_web_force_password_change, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_web_force_password_change) && $cst_web_force_password_change < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_web_force_password_change, true)), __LINE__);
        }
        if (is_null($cst_web_force_password_change) || (is_array($cst_web_force_password_change) && empty($cst_web_force_password_change))) {
            unset($this->cst_web_force_password_change);
        } else {
            $this->cst_web_force_password_change = $cst_web_force_password_change;
        }
        
        return $this;
    }
    /**
     * Get cst_web_login_disabled_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_login_disabled_flag(): ?string
    {
        return $this->cst_web_login_disabled_flag ?? null;
    }
    /**
     * Set cst_web_login_disabled_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_login_disabled_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_login_disabled_flag(?string $cst_web_login_disabled_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_login_disabled_flag) && !is_string($cst_web_login_disabled_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_login_disabled_flag, true), gettype($cst_web_login_disabled_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_web_login_disabled_flag) && $cst_web_login_disabled_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_web_login_disabled_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_web_login_disabled_flag) && $cst_web_login_disabled_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_web_login_disabled_flag, true)), __LINE__);
        }
        if (is_null($cst_web_login_disabled_flag) || (is_array($cst_web_login_disabled_flag) && empty($cst_web_login_disabled_flag))) {
            unset($this->cst_web_login_disabled_flag);
        } else {
            $this->cst_web_login_disabled_flag = $cst_web_login_disabled_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_comment(): ?string
    {
        return $this->cst_comment ?? null;
    }
    /**
     * Set cst_comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_comment
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_comment(?string $cst_comment = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_comment) && !is_string($cst_comment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_comment, true), gettype($cst_comment)), __LINE__);
        }
        if (is_null($cst_comment) || (is_array($cst_comment) && empty($cst_comment))) {
            unset($this->cst_comment);
        } else {
            $this->cst_comment = $cst_comment;
        }
        
        return $this;
    }
    /**
     * Get cst_credit_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_credit_hold_flag(): ?string
    {
        return $this->cst_credit_hold_flag ?? null;
    }
    /**
     * Set cst_credit_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_credit_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_credit_hold_flag(?string $cst_credit_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_credit_hold_flag) && !is_string($cst_credit_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_credit_hold_flag, true), gettype($cst_credit_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_credit_hold_flag) && $cst_credit_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_credit_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_credit_hold_flag) && $cst_credit_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_credit_hold_flag, true)), __LINE__);
        }
        if (is_null($cst_credit_hold_flag) || (is_array($cst_credit_hold_flag) && empty($cst_credit_hold_flag))) {
            unset($this->cst_credit_hold_flag);
        } else {
            $this->cst_credit_hold_flag = $cst_credit_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_credit_hold_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_credit_hold_reason(): ?string
    {
        return $this->cst_credit_hold_reason ?? null;
    }
    /**
     * Set cst_credit_hold_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_credit_hold_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_credit_hold_reason(?string $cst_credit_hold_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_credit_hold_reason) && !is_string($cst_credit_hold_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_credit_hold_reason, true), gettype($cst_credit_hold_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_credit_hold_reason) && mb_strlen((string) $cst_credit_hold_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_credit_hold_reason)), __LINE__);
        }
        if (is_null($cst_credit_hold_reason) || (is_array($cst_credit_hold_reason) && empty($cst_credit_hold_reason))) {
            unset($this->cst_credit_hold_reason);
        } else {
            $this->cst_credit_hold_reason = $cst_credit_hold_reason;
        }
        
        return $this;
    }
    /**
     * Get cst_web_forgot_password_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_forgot_password_status(): ?string
    {
        return $this->cst_web_forgot_password_status ?? null;
    }
    /**
     * Set cst_web_forgot_password_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_forgot_password_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_forgot_password_status(?string $cst_web_forgot_password_status = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_forgot_password_status) && !is_string($cst_web_forgot_password_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_forgot_password_status, true), gettype($cst_web_forgot_password_status)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_web_forgot_password_status) && $cst_web_forgot_password_status > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_web_forgot_password_status, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_web_forgot_password_status) && $cst_web_forgot_password_status < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_web_forgot_password_status, true)), __LINE__);
        }
        if (is_null($cst_web_forgot_password_status) || (is_array($cst_web_forgot_password_status) && empty($cst_web_forgot_password_status))) {
            unset($this->cst_web_forgot_password_status);
        } else {
            $this->cst_web_forgot_password_status = $cst_web_forgot_password_status;
        }
        
        return $this;
    }
    /**
     * Get cst_old_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_old_cxa_key(): ?string
    {
        return $this->cst_old_cxa_key ?? null;
    }
    /**
     * Set cst_old_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_old_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_old_cxa_key(?string $cst_old_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_old_cxa_key) && !is_string($cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_old_cxa_key, true), gettype($cst_old_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_old_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_old_cxa_key, true)), __LINE__);
        }
        if (is_null($cst_old_cxa_key) || (is_array($cst_old_cxa_key) && empty($cst_old_cxa_key))) {
            unset($this->cst_old_cxa_key);
        } else {
            $this->cst_old_cxa_key = $cst_old_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cst_last_email_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_last_email_date(): ?string
    {
        return $this->cst_last_email_date ?? null;
    }
    /**
     * Set cst_last_email_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_last_email_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_last_email_date(?string $cst_last_email_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_last_email_date) && !is_string($cst_last_email_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_last_email_date, true), gettype($cst_last_email_date)), __LINE__);
        }
        if (is_null($cst_last_email_date) || (is_array($cst_last_email_date) && empty($cst_last_email_date))) {
            unset($this->cst_last_email_date);
        } else {
            $this->cst_last_email_date = $cst_last_email_date;
        }
        
        return $this;
    }
    /**
     * Get cst_no_publish_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_no_publish_flag(): ?string
    {
        return $this->cst_no_publish_flag ?? null;
    }
    /**
     * Set cst_no_publish_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_no_publish_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_no_publish_flag(?string $cst_no_publish_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_no_publish_flag) && !is_string($cst_no_publish_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_no_publish_flag, true), gettype($cst_no_publish_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_no_publish_flag) && $cst_no_publish_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_no_publish_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_no_publish_flag) && $cst_no_publish_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_no_publish_flag, true)), __LINE__);
        }
        if (is_null($cst_no_publish_flag) || (is_array($cst_no_publish_flag) && empty($cst_no_publish_flag))) {
            unset($this->cst_no_publish_flag);
        } else {
            $this->cst_no_publish_flag = $cst_no_publish_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_sin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_sin_key(): ?string
    {
        return $this->cst_sin_key ?? null;
    }
    /**
     * Set cst_sin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_sin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_sin_key(?string $cst_sin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_sin_key) && !is_string($cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_sin_key, true), gettype($cst_sin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_sin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_sin_key, true)), __LINE__);
        }
        if (is_null($cst_sin_key) || (is_array($cst_sin_key) && empty($cst_sin_key))) {
            unset($this->cst_sin_key);
        } else {
            $this->cst_sin_key = $cst_sin_key;
        }
        
        return $this;
    }
    /**
     * Get cst_ttl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_ttl_key(): ?string
    {
        return $this->cst_ttl_key ?? null;
    }
    /**
     * Set cst_ttl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_ttl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_ttl_key(?string $cst_ttl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_ttl_key) && !is_string($cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_ttl_key, true), gettype($cst_ttl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_ttl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_ttl_key, true)), __LINE__);
        }
        if (is_null($cst_ttl_key) || (is_array($cst_ttl_key) && empty($cst_ttl_key))) {
            unset($this->cst_ttl_key);
        } else {
            $this->cst_ttl_key = $cst_ttl_key;
        }
        
        return $this;
    }
    /**
     * Get cst_jfn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_jfn_key(): ?string
    {
        return $this->cst_jfn_key ?? null;
    }
    /**
     * Set cst_jfn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_jfn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_jfn_key(?string $cst_jfn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_jfn_key) && !is_string($cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_jfn_key, true), gettype($cst_jfn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_jfn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_jfn_key, true)), __LINE__);
        }
        if (is_null($cst_jfn_key) || (is_array($cst_jfn_key) && empty($cst_jfn_key))) {
            unset($this->cst_jfn_key);
        } else {
            $this->cst_jfn_key = $cst_jfn_key;
        }
        
        return $this;
    }
    /**
     * Get cst_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cur_key(): ?string
    {
        return $this->cst_cur_key ?? null;
    }
    /**
     * Set cst_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cur_key(?string $cst_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cur_key) && !is_string($cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cur_key, true), gettype($cst_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cur_key, true)), __LINE__);
        }
        if (is_null($cst_cur_key) || (is_array($cst_cur_key) && empty($cst_cur_key))) {
            unset($this->cst_cur_key);
        } else {
            $this->cst_cur_key = $cst_cur_key;
        }
        
        return $this;
    }
    /**
     * Get cst_attribute value
     * @return cst_attribute
     */
    public function getCst_attribute_1(): ?string
    {
        return $this->cst_attribute_1 ?? null;
    }
    /**
     * Set cst_attribute value
     * @param cst_attribute $cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_attribute_1(?string $cst_attribute_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_attribute_1) && !is_string($cst_attribute_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_attribute_1, true), gettype($cst_attribute_1)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($cst_attribute_1) && mb_strlen((string) $cst_attribute_1) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $cst_attribute_1)), __LINE__);
        }
        if (is_null($cst_attribute_1) || (is_array($cst_attribute_1) && empty($cst_attribute_1))) {
            unset($this->cst_attribute_1);
        } else {
            $this->cst_attribute_1 = $cst_attribute_1;
        }
        
        return $this;
    }
    /**
     * Get cst_attribute value
     * @return cst_attribute
     */
    public function getCst_attribute_2(): ?string
    {
        return $this->cst_attribute_2 ?? null;
    }
    /**
     * Set cst_attribute value
     * @param cst_attribute $cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_attribute_2(?string $cst_attribute_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_attribute_2) && !is_string($cst_attribute_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_attribute_2, true), gettype($cst_attribute_2)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($cst_attribute_2) && mb_strlen((string) $cst_attribute_2) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $cst_attribute_2)), __LINE__);
        }
        if (is_null($cst_attribute_2) || (is_array($cst_attribute_2) && empty($cst_attribute_2))) {
            unset($this->cst_attribute_2);
        } else {
            $this->cst_attribute_2 = $cst_attribute_2;
        }
        
        return $this;
    }
    /**
     * Get cst_salutation value
     * @return cst_salutation
     */
    public function getCst_salutation_1(): ?string
    {
        return $this->cst_salutation_1 ?? null;
    }
    /**
     * Set cst_salutation value
     * @param cst_salutation $cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_salutation_1(?string $cst_salutation_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_salutation_1) && !is_string($cst_salutation_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_salutation_1, true), gettype($cst_salutation_1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cst_salutation_1) && mb_strlen((string) $cst_salutation_1) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cst_salutation_1)), __LINE__);
        }
        if (is_null($cst_salutation_1) || (is_array($cst_salutation_1) && empty($cst_salutation_1))) {
            unset($this->cst_salutation_1);
        } else {
            $this->cst_salutation_1 = $cst_salutation_1;
        }
        
        return $this;
    }
    /**
     * Get cst_salutation value
     * @return cst_salutation
     */
    public function getCst_salutation_2(): ?string
    {
        return $this->cst_salutation_2 ?? null;
    }
    /**
     * Set cst_salutation value
     * @param cst_salutation $cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_salutation_2(?string $cst_salutation_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_salutation_2) && !is_string($cst_salutation_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_salutation_2, true), gettype($cst_salutation_2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cst_salutation_2) && mb_strlen((string) $cst_salutation_2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cst_salutation_2)), __LINE__);
        }
        if (is_null($cst_salutation_2) || (is_array($cst_salutation_2) && empty($cst_salutation_2))) {
            unset($this->cst_salutation_2);
        } else {
            $this->cst_salutation_2 = $cst_salutation_2;
        }
        
        return $this;
    }
    /**
     * Get cst_merge_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_merge_cst_key(): ?string
    {
        return $this->cst_merge_cst_key ?? null;
    }
    /**
     * Set cst_merge_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_merge_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_merge_cst_key(?string $cst_merge_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_merge_cst_key) && !is_string($cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_merge_cst_key, true), gettype($cst_merge_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_merge_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_merge_cst_key, true)), __LINE__);
        }
        if (is_null($cst_merge_cst_key) || (is_array($cst_merge_cst_key) && empty($cst_merge_cst_key))) {
            unset($this->cst_merge_cst_key);
        } else {
            $this->cst_merge_cst_key = $cst_merge_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cst_salutation value
     * @return cst_salutation
     */
    public function getCst_salutation_3(): ?string
    {
        return $this->cst_salutation_3 ?? null;
    }
    /**
     * Set cst_salutation value
     * @param cst_salutation $cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_salutation_3(?string $cst_salutation_3 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_salutation_3) && !is_string($cst_salutation_3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_salutation_3, true), gettype($cst_salutation_3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cst_salutation_3) && mb_strlen((string) $cst_salutation_3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cst_salutation_3)), __LINE__);
        }
        if (is_null($cst_salutation_3) || (is_array($cst_salutation_3) && empty($cst_salutation_3))) {
            unset($this->cst_salutation_3);
        } else {
            $this->cst_salutation_3 = $cst_salutation_3;
        }
        
        return $this;
    }
    /**
     * Get cst_salutation value
     * @return cst_salutation
     */
    public function getCst_salutation_4(): ?string
    {
        return $this->cst_salutation_4 ?? null;
    }
    /**
     * Set cst_salutation value
     * @param cst_salutation $cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_salutation_4(?string $cst_salutation_4 = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_salutation_4) && !is_string($cst_salutation_4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_salutation_4, true), gettype($cst_salutation_4)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cst_salutation_4) && mb_strlen((string) $cst_salutation_4) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cst_salutation_4)), __LINE__);
        }
        if (is_null($cst_salutation_4) || (is_array($cst_salutation_4) && empty($cst_salutation_4))) {
            unset($this->cst_salutation_4);
        } else {
            $this->cst_salutation_4 = $cst_salutation_4;
        }
        
        return $this;
    }
    /**
     * Get cst_default_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_default_recognize_as(): ?string
    {
        return $this->cst_default_recognize_as ?? null;
    }
    /**
     * Set cst_default_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_default_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_default_recognize_as(?string $cst_default_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_default_recognize_as) && !is_string($cst_default_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_default_recognize_as, true), gettype($cst_default_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($cst_default_recognize_as) && mb_strlen((string) $cst_default_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $cst_default_recognize_as)), __LINE__);
        }
        if (is_null($cst_default_recognize_as) || (is_array($cst_default_recognize_as) && empty($cst_default_recognize_as))) {
            unset($this->cst_default_recognize_as);
        } else {
            $this->cst_default_recognize_as = $cst_default_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get cst_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCst_score(): ?float
    {
        return $this->cst_score ?? null;
    }
    /**
     * Set cst_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cst_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_score(?float $cst_score = null): self
    {
        // validation for constraint: float
        if (!is_null($cst_score) && !(is_float($cst_score) || is_numeric($cst_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cst_score, true), gettype($cst_score)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cst_score) && mb_strlen(mb_substr((string) $cst_score, false !== mb_strpos((string) $cst_score, '.') ? mb_strpos((string) $cst_score, '.') + 1 : mb_strlen((string) $cst_score))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cst_score, true), mb_strlen(mb_substr((string) $cst_score, mb_strpos((string) $cst_score, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cst_score) && mb_strlen(preg_replace('/(\D)/', '', (string) $cst_score)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cst_score, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cst_score))), __LINE__);
        }
        if (is_null($cst_score) || (is_array($cst_score) && empty($cst_score))) {
            unset($this->cst_score);
        } else {
            $this->cst_score = $cst_score;
        }
        
        return $this;
    }
    /**
     * Get cst_score_normalized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_score_normalized(): ?int
    {
        return $this->cst_score_normalized ?? null;
    }
    /**
     * Set cst_score_normalized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_score_normalized
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_score_normalized(?int $cst_score_normalized = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_score_normalized) && !(is_int($cst_score_normalized) || ctype_digit($cst_score_normalized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_score_normalized, true), gettype($cst_score_normalized)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cst_score_normalized) && $cst_score_normalized > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cst_score_normalized, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cst_score_normalized) && $cst_score_normalized < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cst_score_normalized, true)), __LINE__);
        }
        if (is_null($cst_score_normalized) || (is_array($cst_score_normalized) && empty($cst_score_normalized))) {
            unset($this->cst_score_normalized);
        } else {
            $this->cst_score_normalized = $cst_score_normalized;
        }
        
        return $this;
    }
    /**
     * Get cst_score_trend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_score_trend(): ?int
    {
        return $this->cst_score_trend ?? null;
    }
    /**
     * Set cst_score_trend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_score_trend
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_score_trend(?int $cst_score_trend = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_score_trend) && !(is_int($cst_score_trend) || ctype_digit($cst_score_trend))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_score_trend, true), gettype($cst_score_trend)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cst_score_trend) && $cst_score_trend > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cst_score_trend, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cst_score_trend) && $cst_score_trend < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cst_score_trend, true)), __LINE__);
        }
        if (is_null($cst_score_trend) || (is_array($cst_score_trend) && empty($cst_score_trend))) {
            unset($this->cst_score_trend);
        } else {
            $this->cst_score_trend = $cst_score_trend;
        }
        
        return $this;
    }
    /**
     * Get cst_vault_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_vault_account(): ?string
    {
        return $this->cst_vault_account ?? null;
    }
    /**
     * Set cst_vault_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_vault_account
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_vault_account(?string $cst_vault_account = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_vault_account) && !is_string($cst_vault_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_vault_account, true), gettype($cst_vault_account)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($cst_vault_account) && mb_strlen((string) $cst_vault_account) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $cst_vault_account)), __LINE__);
        }
        if (is_null($cst_vault_account) || (is_array($cst_vault_account) && empty($cst_vault_account))) {
            unset($this->cst_vault_account);
        } else {
            $this->cst_vault_account = $cst_vault_account;
        }
        
        return $this;
    }
    /**
     * Get cst_exclude_from_social_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_exclude_from_social_flag(): ?string
    {
        return $this->cst_exclude_from_social_flag ?? null;
    }
    /**
     * Set cst_exclude_from_social_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_exclude_from_social_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_exclude_from_social_flag(?string $cst_exclude_from_social_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_exclude_from_social_flag) && !is_string($cst_exclude_from_social_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_exclude_from_social_flag, true), gettype($cst_exclude_from_social_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_exclude_from_social_flag) && $cst_exclude_from_social_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_exclude_from_social_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_exclude_from_social_flag) && $cst_exclude_from_social_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_exclude_from_social_flag, true)), __LINE__);
        }
        if (is_null($cst_exclude_from_social_flag) || (is_array($cst_exclude_from_social_flag) && empty($cst_exclude_from_social_flag))) {
            unset($this->cst_exclude_from_social_flag);
        } else {
            $this->cst_exclude_from_social_flag = $cst_exclude_from_social_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_social_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_social_score(): ?int
    {
        return $this->cst_social_score ?? null;
    }
    /**
     * Set cst_social_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_social_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_social_score(?int $cst_social_score = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_social_score) && !(is_int($cst_social_score) || ctype_digit($cst_social_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_social_score, true), gettype($cst_social_score)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cst_social_score) && $cst_social_score > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cst_social_score, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cst_social_score) && $cst_social_score < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cst_social_score, true)), __LINE__);
        }
        if (is_null($cst_social_score) || (is_array($cst_social_score) && empty($cst_social_score))) {
            unset($this->cst_social_score);
        } else {
            $this->cst_social_score = $cst_social_score;
        }
        
        return $this;
    }
    /**
     * Get cst_ptin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_ptin(): ?string
    {
        return $this->cst_ptin ?? null;
    }
    /**
     * Set cst_ptin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_ptin
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_ptin(?string $cst_ptin = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_ptin) && !is_string($cst_ptin)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_ptin, true), gettype($cst_ptin)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($cst_ptin) && mb_strlen((string) $cst_ptin) > 9) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen((string) $cst_ptin)), __LINE__);
        }
        if (is_null($cst_ptin) || (is_array($cst_ptin) && empty($cst_ptin))) {
            unset($this->cst_ptin);
        } else {
            $this->cst_ptin = $cst_ptin;
        }
        
        return $this;
    }
    /**
     * Get cst_aicpa_member_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_aicpa_member_id(): ?int
    {
        return $this->cst_aicpa_member_id ?? null;
    }
    /**
     * Set cst_aicpa_member_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_aicpa_member_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_aicpa_member_id(?int $cst_aicpa_member_id = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_aicpa_member_id) && !(is_int($cst_aicpa_member_id) || ctype_digit($cst_aicpa_member_id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_aicpa_member_id, true), gettype($cst_aicpa_member_id)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cst_aicpa_member_id) && $cst_aicpa_member_id > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cst_aicpa_member_id, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cst_aicpa_member_id) && $cst_aicpa_member_id < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cst_aicpa_member_id, true)), __LINE__);
        }
        if (is_null($cst_aicpa_member_id) || (is_array($cst_aicpa_member_id) && empty($cst_aicpa_member_id))) {
            unset($this->cst_aicpa_member_id);
        } else {
            $this->cst_aicpa_member_id = $cst_aicpa_member_id;
        }
        
        return $this;
    }
    /**
     * Get cst_vendor_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_vendor_code(): ?string
    {
        return $this->cst_vendor_code ?? null;
    }
    /**
     * Set cst_vendor_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_vendor_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_vendor_code(?string $cst_vendor_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_vendor_code) && !is_string($cst_vendor_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_vendor_code, true), gettype($cst_vendor_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_vendor_code) && mb_strlen((string) $cst_vendor_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_vendor_code)), __LINE__);
        }
        if (is_null($cst_vendor_code) || (is_array($cst_vendor_code) && empty($cst_vendor_code))) {
            unset($this->cst_vendor_code);
        } else {
            $this->cst_vendor_code = $cst_vendor_code;
        }
        
        return $this;
    }
    /**
     * Get cst_salt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_salt(): ?string
    {
        return $this->cst_salt ?? null;
    }
    /**
     * Set cst_salt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_salt
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_salt(?string $cst_salt = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_salt) && !is_string($cst_salt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_salt, true), gettype($cst_salt)), __LINE__);
        }
        if (is_null($cst_salt) || (is_array($cst_salt) && empty($cst_salt))) {
            unset($this->cst_salt);
        } else {
            $this->cst_salt = $cst_salt;
        }
        
        return $this;
    }
    /**
     * Get cst_sca_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_sca_key(): ?string
    {
        return $this->cst_sca_key ?? null;
    }
    /**
     * Set cst_sca_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_sca_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_sca_key(?string $cst_sca_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_sca_key) && !is_string($cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_sca_key, true), gettype($cst_sca_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_sca_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_sca_key, true)), __LINE__);
        }
        if (is_null($cst_sca_key) || (is_array($cst_sca_key) && empty($cst_sca_key))) {
            unset($this->cst_sca_key);
        } else {
            $this->cst_sca_key = $cst_sca_key;
        }
        
        return $this;
    }
    /**
     * Get cst_iterations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCst_iterations(): ?int
    {
        return $this->cst_iterations ?? null;
    }
    /**
     * Set cst_iterations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cst_iterations
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_iterations(?int $cst_iterations = null): self
    {
        // validation for constraint: int
        if (!is_null($cst_iterations) && !(is_int($cst_iterations) || ctype_digit($cst_iterations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cst_iterations, true), gettype($cst_iterations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cst_iterations) && $cst_iterations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cst_iterations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cst_iterations) && $cst_iterations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cst_iterations, true)), __LINE__);
        }
        if (is_null($cst_iterations) || (is_array($cst_iterations) && empty($cst_iterations))) {
            unset($this->cst_iterations);
        } else {
            $this->cst_iterations = $cst_iterations;
        }
        
        return $this;
    }
    /**
     * Get cst_web_password_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_password_change_date(): ?string
    {
        return $this->cst_web_password_change_date ?? null;
    }
    /**
     * Set cst_web_password_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_password_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_password_change_date(?string $cst_web_password_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_password_change_date) && !is_string($cst_web_password_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_password_change_date, true), gettype($cst_web_password_change_date)), __LINE__);
        }
        if (is_null($cst_web_password_change_date) || (is_array($cst_web_password_change_date) && empty($cst_web_password_change_date))) {
            unset($this->cst_web_password_change_date);
        } else {
            $this->cst_web_password_change_date = $cst_web_password_change_date;
        }
        
        return $this;
    }
    /**
     * Get cst_web_failed_login_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_failed_login_count(): ?string
    {
        return $this->cst_web_failed_login_count ?? null;
    }
    /**
     * Set cst_web_failed_login_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_failed_login_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_failed_login_count(?string $cst_web_failed_login_count = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_failed_login_count) && !is_string($cst_web_failed_login_count)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_failed_login_count, true), gettype($cst_web_failed_login_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_web_failed_login_count) && $cst_web_failed_login_count > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_web_failed_login_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_web_failed_login_count) && $cst_web_failed_login_count < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_web_failed_login_count, true)), __LINE__);
        }
        if (is_null($cst_web_failed_login_count) || (is_array($cst_web_failed_login_count) && empty($cst_web_failed_login_count))) {
            unset($this->cst_web_failed_login_count);
        } else {
            $this->cst_web_failed_login_count = $cst_web_failed_login_count;
        }
        
        return $this;
    }
    /**
     * Get cst_web_last_failed_login_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_last_failed_login_date(): ?string
    {
        return $this->cst_web_last_failed_login_date ?? null;
    }
    /**
     * Set cst_web_last_failed_login_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_last_failed_login_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_last_failed_login_date(?string $cst_web_last_failed_login_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_last_failed_login_date) && !is_string($cst_web_last_failed_login_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_last_failed_login_date, true), gettype($cst_web_last_failed_login_date)), __LINE__);
        }
        if (is_null($cst_web_last_failed_login_date) || (is_array($cst_web_last_failed_login_date) && empty($cst_web_last_failed_login_date))) {
            unset($this->cst_web_last_failed_login_date);
        } else {
            $this->cst_web_last_failed_login_date = $cst_web_last_failed_login_date;
        }
        
        return $this;
    }
    /**
     * Get cst_web_login_locked_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_web_login_locked_flag(): ?string
    {
        return $this->cst_web_login_locked_flag ?? null;
    }
    /**
     * Set cst_web_login_locked_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_web_login_locked_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_web_login_locked_flag(?string $cst_web_login_locked_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_web_login_locked_flag) && !is_string($cst_web_login_locked_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_web_login_locked_flag, true), gettype($cst_web_login_locked_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cst_web_login_locked_flag) && $cst_web_login_locked_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cst_web_login_locked_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cst_web_login_locked_flag) && $cst_web_login_locked_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cst_web_login_locked_flag, true)), __LINE__);
        }
        if (is_null($cst_web_login_locked_flag) || (is_array($cst_web_login_locked_flag) && empty($cst_web_login_locked_flag))) {
            unset($this->cst_web_login_locked_flag);
        } else {
            $this->cst_web_login_locked_flag = $cst_web_login_locked_flag;
        }
        
        return $this;
    }
    /**
     * Get cst_cph_sms_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_cph_sms_key(): ?string
    {
        return $this->cst_cph_sms_key ?? null;
    }
    /**
     * Set cst_cph_sms_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_cph_sms_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_cph_sms_key(?string $cst_cph_sms_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_cph_sms_key) && !is_string($cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_cph_sms_key, true), gettype($cst_cph_sms_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cst_cph_sms_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cst_cph_sms_key, true)), __LINE__);
        }
        if (is_null($cst_cph_sms_key) || (is_array($cst_cph_sms_key) && empty($cst_cph_sms_key))) {
            unset($this->cst_cph_sms_key);
        } else {
            $this->cst_cph_sms_key = $cst_cph_sms_key;
        }
        
        return $this;
    }
    /**
     * Get cst_sms_opt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_sms_opt(): ?string
    {
        return $this->cst_sms_opt ?? null;
    }
    /**
     * Set cst_sms_opt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_sms_opt
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_sms_opt(?string $cst_sms_opt = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_sms_opt) && !is_string($cst_sms_opt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_sms_opt, true), gettype($cst_sms_opt)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_sms_opt) && mb_strlen((string) $cst_sms_opt) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_sms_opt)), __LINE__);
        }
        if (is_null($cst_sms_opt) || (is_array($cst_sms_opt) && empty($cst_sms_opt))) {
            unset($this->cst_sms_opt);
        } else {
            $this->cst_sms_opt = $cst_sms_opt;
        }
        
        return $this;
    }
    /**
     * Get cst_sms_consent_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_sms_consent_type(): ?string
    {
        return $this->cst_sms_consent_type ?? null;
    }
    /**
     * Set cst_sms_consent_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_sms_consent_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_sms_consent_type(?string $cst_sms_consent_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_sms_consent_type) && !is_string($cst_sms_consent_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_sms_consent_type, true), gettype($cst_sms_consent_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cst_sms_consent_type) && mb_strlen((string) $cst_sms_consent_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cst_sms_consent_type)), __LINE__);
        }
        if (is_null($cst_sms_consent_type) || (is_array($cst_sms_consent_type) && empty($cst_sms_consent_type))) {
            unset($this->cst_sms_consent_type);
        } else {
            $this->cst_sms_consent_type = $cst_sms_consent_type;
        }
        
        return $this;
    }
    /**
     * Get cst_failed_payment_attempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCst_failed_payment_attempts(): ?string
    {
        return $this->cst_failed_payment_attempts ?? null;
    }
    /**
     * Set cst_failed_payment_attempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cst_failed_payment_attempts
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
     */
    public function setCst_failed_payment_attempts(?string $cst_failed_payment_attempts = null): self
    {
        // validation for constraint: string
        if (!is_null($cst_failed_payment_attempts) && !is_string($cst_failed_payment_attempts)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_failed_payment_attempts, true), gettype($cst_failed_payment_attempts)), __LINE__);
        }
        if (is_null($cst_failed_payment_attempts) || (is_array($cst_failed_payment_attempts) && empty($cst_failed_payment_attempts))) {
            unset($this->cst_failed_payment_attempts);
        } else {
            $this->cst_failed_payment_attempts = $cst_failed_payment_attempts;
        }
        
        return $this;
    }
}
