<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Home_Fax_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Home_Fax_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cf2__cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_key = null;
    /**
     * The cf2__cfx_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_cst_key = null;
    /**
     * The cf2__cfx_fax_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_fax_key = null;
    /**
     * The cf2__cfx_fxt_key
     * Meta information extracted from the WSDL
     * - documentation: Fax Type.This element has a default value of '785c36f5-aef2-48b8-a229-3a3af0a969f1'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_fxt_key = null;
    /**
     * The cf2__cfx_cst_link_key
     * Meta information extracted from the WSDL
     * - documentation: Linked Fax Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_cst_link_key = null;
    /**
     * The cf2__cfx_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_add_user = null;
    /**
     * The cf2__cfx_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_add_date = null;
    /**
     * The cf2__cfx_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_change_user = null;
    /**
     * The cf2__cfx_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_change_date = null;
    /**
     * The cf2__cfx_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_delete_flag = null;
    /**
     * The cf2__cfx_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_key_ext = null;
    /**
     * The cf2__cfx_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: Unlisted Fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_unlisted_flag = null;
    /**
     * The cf2__cfx_fax_number_complete
     * Meta information extracted from the WSDL
     * - documentation: fax number complete. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_fax_number_complete = null;
    /**
     * The cf2__cfx_extension
     * Meta information extracted from the WSDL
     * - documentation: Fax Extension. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_extension = null;
    /**
     * The cf2__cfx_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cf2__cfx_entity_key = null;
    /**
     * The cf2__cfx_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_primary = null;
    /**
     * The cf2__cfx_owner
     * Meta information extracted from the WSDL
     * - documentation: Fax Owner.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_owner = null;
    /**
     * The cf2__cfx_FaxLinkingDropDownList
     * Meta information extracted from the WSDL
     * - documentation: FaxLinkingDropDownList.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cf2__cfx_FaxLinkingDropDownList = null;
    /**
     * Constructor method for Individual_Home_Fax_XRef_DataObjectType
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_cst_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_fax_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_fxt_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_cst_link_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_add_user()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_add_date()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_change_user()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_change_date()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_delete_flag()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_key_ext()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_unlisted_flag()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_fax_number_complete()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_extension()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_entity_key()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_primary()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_owner()
     * @uses Individual_Home_Fax_XRef_DataObjectType::setCf2__cfx_FaxLinkingDropDownList()
     * @param string $cf2__cfx_key
     * @param string $cf2__cfx_cst_key
     * @param string $cf2__cfx_fax_key
     * @param string $cf2__cfx_fxt_key
     * @param string $cf2__cfx_cst_link_key
     * @param string $cf2__cfx_add_user
     * @param string $cf2__cfx_add_date
     * @param string $cf2__cfx_change_user
     * @param string $cf2__cfx_change_date
     * @param string $cf2__cfx_delete_flag
     * @param string $cf2__cfx_key_ext
     * @param string $cf2__cfx_unlisted_flag
     * @param string $cf2__cfx_fax_number_complete
     * @param string $cf2__cfx_extension
     * @param string $cf2__cfx_entity_key
     * @param string $cf2__cfx_primary
     * @param string $cf2__cfx_owner
     * @param string $cf2__cfx_FaxLinkingDropDownList
     */
    public function __construct(?string $cf2__cfx_key = null, ?string $cf2__cfx_cst_key = null, ?string $cf2__cfx_fax_key = null, ?string $cf2__cfx_fxt_key = null, ?string $cf2__cfx_cst_link_key = null, ?string $cf2__cfx_add_user = null, ?string $cf2__cfx_add_date = null, ?string $cf2__cfx_change_user = null, ?string $cf2__cfx_change_date = null, ?string $cf2__cfx_delete_flag = null, ?string $cf2__cfx_key_ext = null, ?string $cf2__cfx_unlisted_flag = null, ?string $cf2__cfx_fax_number_complete = null, ?string $cf2__cfx_extension = null, ?string $cf2__cfx_entity_key = null, ?string $cf2__cfx_primary = null, ?string $cf2__cfx_owner = null, ?string $cf2__cfx_FaxLinkingDropDownList = null)
    {
        $this
            ->setCf2__cfx_key($cf2__cfx_key)
            ->setCf2__cfx_cst_key($cf2__cfx_cst_key)
            ->setCf2__cfx_fax_key($cf2__cfx_fax_key)
            ->setCf2__cfx_fxt_key($cf2__cfx_fxt_key)
            ->setCf2__cfx_cst_link_key($cf2__cfx_cst_link_key)
            ->setCf2__cfx_add_user($cf2__cfx_add_user)
            ->setCf2__cfx_add_date($cf2__cfx_add_date)
            ->setCf2__cfx_change_user($cf2__cfx_change_user)
            ->setCf2__cfx_change_date($cf2__cfx_change_date)
            ->setCf2__cfx_delete_flag($cf2__cfx_delete_flag)
            ->setCf2__cfx_key_ext($cf2__cfx_key_ext)
            ->setCf2__cfx_unlisted_flag($cf2__cfx_unlisted_flag)
            ->setCf2__cfx_fax_number_complete($cf2__cfx_fax_number_complete)
            ->setCf2__cfx_extension($cf2__cfx_extension)
            ->setCf2__cfx_entity_key($cf2__cfx_entity_key)
            ->setCf2__cfx_primary($cf2__cfx_primary)
            ->setCf2__cfx_owner($cf2__cfx_owner)
            ->setCf2__cfx_FaxLinkingDropDownList($cf2__cfx_FaxLinkingDropDownList);
    }
    /**
     * Get cf2__cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_key(): ?string
    {
        return $this->cf2__cfx_key ?? null;
    }
    /**
     * Set cf2__cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_key(?string $cf2__cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_key) && !is_string($cf2__cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_key, true), gettype($cf2__cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_key) || (is_array($cf2__cfx_key) && empty($cf2__cfx_key))) {
            unset($this->cf2__cfx_key);
        } else {
            $this->cf2__cfx_key = $cf2__cfx_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_cst_key(): ?string
    {
        return $this->cf2__cfx_cst_key ?? null;
    }
    /**
     * Set cf2__cfx_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_cst_key(?string $cf2__cfx_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_cst_key) && !is_string($cf2__cfx_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_cst_key, true), gettype($cf2__cfx_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_cst_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_cst_key) || (is_array($cf2__cfx_cst_key) && empty($cf2__cfx_cst_key))) {
            unset($this->cf2__cfx_cst_key);
        } else {
            $this->cf2__cfx_cst_key = $cf2__cfx_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_fax_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_fax_key(): ?string
    {
        return $this->cf2__cfx_fax_key ?? null;
    }
    /**
     * Set cf2__cfx_fax_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_fax_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_fax_key(?string $cf2__cfx_fax_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_fax_key) && !is_string($cf2__cfx_fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_fax_key, true), gettype($cf2__cfx_fax_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_fax_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_fax_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_fax_key) || (is_array($cf2__cfx_fax_key) && empty($cf2__cfx_fax_key))) {
            unset($this->cf2__cfx_fax_key);
        } else {
            $this->cf2__cfx_fax_key = $cf2__cfx_fax_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_fxt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_fxt_key(): ?string
    {
        return $this->cf2__cfx_fxt_key ?? null;
    }
    /**
     * Set cf2__cfx_fxt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_fxt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_fxt_key(?string $cf2__cfx_fxt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_fxt_key) && !is_string($cf2__cfx_fxt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_fxt_key, true), gettype($cf2__cfx_fxt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_fxt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_fxt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_fxt_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_fxt_key) || (is_array($cf2__cfx_fxt_key) && empty($cf2__cfx_fxt_key))) {
            unset($this->cf2__cfx_fxt_key);
        } else {
            $this->cf2__cfx_fxt_key = $cf2__cfx_fxt_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_cst_link_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_cst_link_key(): ?string
    {
        return $this->cf2__cfx_cst_link_key ?? null;
    }
    /**
     * Set cf2__cfx_cst_link_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_cst_link_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_cst_link_key(?string $cf2__cfx_cst_link_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_cst_link_key) && !is_string($cf2__cfx_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_cst_link_key, true), gettype($cf2__cfx_cst_link_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_cst_link_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_cst_link_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_cst_link_key) || (is_array($cf2__cfx_cst_link_key) && empty($cf2__cfx_cst_link_key))) {
            unset($this->cf2__cfx_cst_link_key);
        } else {
            $this->cf2__cfx_cst_link_key = $cf2__cfx_cst_link_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_add_user(): ?string
    {
        return $this->cf2__cfx_add_user ?? null;
    }
    /**
     * Set cf2__cfx_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_add_user(?string $cf2__cfx_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_add_user) && !is_string($cf2__cfx_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_add_user, true), gettype($cf2__cfx_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cf2__cfx_add_user) && mb_strlen((string) $cf2__cfx_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cf2__cfx_add_user)), __LINE__);
        }
        if (is_null($cf2__cfx_add_user) || (is_array($cf2__cfx_add_user) && empty($cf2__cfx_add_user))) {
            unset($this->cf2__cfx_add_user);
        } else {
            $this->cf2__cfx_add_user = $cf2__cfx_add_user;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_add_date(): ?string
    {
        return $this->cf2__cfx_add_date ?? null;
    }
    /**
     * Set cf2__cfx_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_add_date(?string $cf2__cfx_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_add_date) && !is_string($cf2__cfx_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_add_date, true), gettype($cf2__cfx_add_date)), __LINE__);
        }
        if (is_null($cf2__cfx_add_date) || (is_array($cf2__cfx_add_date) && empty($cf2__cfx_add_date))) {
            unset($this->cf2__cfx_add_date);
        } else {
            $this->cf2__cfx_add_date = $cf2__cfx_add_date;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_change_user(): ?string
    {
        return $this->cf2__cfx_change_user ?? null;
    }
    /**
     * Set cf2__cfx_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_change_user(?string $cf2__cfx_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_change_user) && !is_string($cf2__cfx_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_change_user, true), gettype($cf2__cfx_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cf2__cfx_change_user) && mb_strlen((string) $cf2__cfx_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cf2__cfx_change_user)), __LINE__);
        }
        if (is_null($cf2__cfx_change_user) || (is_array($cf2__cfx_change_user) && empty($cf2__cfx_change_user))) {
            unset($this->cf2__cfx_change_user);
        } else {
            $this->cf2__cfx_change_user = $cf2__cfx_change_user;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_change_date(): ?string
    {
        return $this->cf2__cfx_change_date ?? null;
    }
    /**
     * Set cf2__cfx_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_change_date(?string $cf2__cfx_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_change_date) && !is_string($cf2__cfx_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_change_date, true), gettype($cf2__cfx_change_date)), __LINE__);
        }
        if (is_null($cf2__cfx_change_date) || (is_array($cf2__cfx_change_date) && empty($cf2__cfx_change_date))) {
            unset($this->cf2__cfx_change_date);
        } else {
            $this->cf2__cfx_change_date = $cf2__cfx_change_date;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_delete_flag(): ?string
    {
        return $this->cf2__cfx_delete_flag ?? null;
    }
    /**
     * Set cf2__cfx_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_delete_flag(?string $cf2__cfx_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_delete_flag) && !is_string($cf2__cfx_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_delete_flag, true), gettype($cf2__cfx_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cf2__cfx_delete_flag) && $cf2__cfx_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cf2__cfx_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cf2__cfx_delete_flag) && $cf2__cfx_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cf2__cfx_delete_flag, true)), __LINE__);
        }
        if (is_null($cf2__cfx_delete_flag) || (is_array($cf2__cfx_delete_flag) && empty($cf2__cfx_delete_flag))) {
            unset($this->cf2__cfx_delete_flag);
        } else {
            $this->cf2__cfx_delete_flag = $cf2__cfx_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_key_ext(): ?string
    {
        return $this->cf2__cfx_key_ext ?? null;
    }
    /**
     * Set cf2__cfx_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_key_ext(?string $cf2__cfx_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_key_ext) && !is_string($cf2__cfx_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_key_ext, true), gettype($cf2__cfx_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_key_ext, true)), __LINE__);
        }
        if (is_null($cf2__cfx_key_ext) || (is_array($cf2__cfx_key_ext) && empty($cf2__cfx_key_ext))) {
            unset($this->cf2__cfx_key_ext);
        } else {
            $this->cf2__cfx_key_ext = $cf2__cfx_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_unlisted_flag(): ?string
    {
        return $this->cf2__cfx_unlisted_flag ?? null;
    }
    /**
     * Set cf2__cfx_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_unlisted_flag(?string $cf2__cfx_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_unlisted_flag) && !is_string($cf2__cfx_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_unlisted_flag, true), gettype($cf2__cfx_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cf2__cfx_unlisted_flag) && $cf2__cfx_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cf2__cfx_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cf2__cfx_unlisted_flag) && $cf2__cfx_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cf2__cfx_unlisted_flag, true)), __LINE__);
        }
        if (is_null($cf2__cfx_unlisted_flag) || (is_array($cf2__cfx_unlisted_flag) && empty($cf2__cfx_unlisted_flag))) {
            unset($this->cf2__cfx_unlisted_flag);
        } else {
            $this->cf2__cfx_unlisted_flag = $cf2__cfx_unlisted_flag;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_fax_number_complete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_fax_number_complete(): ?string
    {
        return $this->cf2__cfx_fax_number_complete ?? null;
    }
    /**
     * Set cf2__cfx_fax_number_complete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_fax_number_complete
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_fax_number_complete(?string $cf2__cfx_fax_number_complete = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_fax_number_complete) && !is_string($cf2__cfx_fax_number_complete)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_fax_number_complete, true), gettype($cf2__cfx_fax_number_complete)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cf2__cfx_fax_number_complete) && mb_strlen((string) $cf2__cfx_fax_number_complete) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cf2__cfx_fax_number_complete)), __LINE__);
        }
        if (is_null($cf2__cfx_fax_number_complete) || (is_array($cf2__cfx_fax_number_complete) && empty($cf2__cfx_fax_number_complete))) {
            unset($this->cf2__cfx_fax_number_complete);
        } else {
            $this->cf2__cfx_fax_number_complete = $cf2__cfx_fax_number_complete;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_extension(): ?string
    {
        return $this->cf2__cfx_extension ?? null;
    }
    /**
     * Set cf2__cfx_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_extension(?string $cf2__cfx_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_extension) && !is_string($cf2__cfx_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_extension, true), gettype($cf2__cfx_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cf2__cfx_extension) && mb_strlen((string) $cf2__cfx_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cf2__cfx_extension)), __LINE__);
        }
        if (is_null($cf2__cfx_extension) || (is_array($cf2__cfx_extension) && empty($cf2__cfx_extension))) {
            unset($this->cf2__cfx_extension);
        } else {
            $this->cf2__cfx_extension = $cf2__cfx_extension;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_entity_key(): ?string
    {
        return $this->cf2__cfx_entity_key ?? null;
    }
    /**
     * Set cf2__cfx_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_entity_key(?string $cf2__cfx_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_entity_key) && !is_string($cf2__cfx_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_entity_key, true), gettype($cf2__cfx_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cf2__cfx_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cf2__cfx_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cf2__cfx_entity_key, true)), __LINE__);
        }
        if (is_null($cf2__cfx_entity_key) || (is_array($cf2__cfx_entity_key) && empty($cf2__cfx_entity_key))) {
            unset($this->cf2__cfx_entity_key);
        } else {
            $this->cf2__cfx_entity_key = $cf2__cfx_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_primary(): ?string
    {
        return $this->cf2__cfx_primary ?? null;
    }
    /**
     * Set cf2__cfx_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_primary(?string $cf2__cfx_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_primary) && !is_string($cf2__cfx_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_primary, true), gettype($cf2__cfx_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cf2__cfx_primary) && $cf2__cfx_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cf2__cfx_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cf2__cfx_primary) && $cf2__cfx_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cf2__cfx_primary, true)), __LINE__);
        }
        if (is_null($cf2__cfx_primary) || (is_array($cf2__cfx_primary) && empty($cf2__cfx_primary))) {
            unset($this->cf2__cfx_primary);
        } else {
            $this->cf2__cfx_primary = $cf2__cfx_primary;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_owner(): ?string
    {
        return $this->cf2__cfx_owner ?? null;
    }
    /**
     * Set cf2__cfx_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_owner(?string $cf2__cfx_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_owner) && !is_string($cf2__cfx_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_owner, true), gettype($cf2__cfx_owner)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cf2__cfx_owner) && $cf2__cfx_owner > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cf2__cfx_owner, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cf2__cfx_owner) && $cf2__cfx_owner < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cf2__cfx_owner, true)), __LINE__);
        }
        if (is_null($cf2__cfx_owner) || (is_array($cf2__cfx_owner) && empty($cf2__cfx_owner))) {
            unset($this->cf2__cfx_owner);
        } else {
            $this->cf2__cfx_owner = $cf2__cfx_owner;
        }
        
        return $this;
    }
    /**
     * Get cf2__cfx_FaxLinkingDropDownList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCf2__cfx_FaxLinkingDropDownList(): ?string
    {
        return $this->cf2__cfx_FaxLinkingDropDownList ?? null;
    }
    /**
     * Set cf2__cfx_FaxLinkingDropDownList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cf2__cfx_FaxLinkingDropDownList
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
     */
    public function setCf2__cfx_FaxLinkingDropDownList(?string $cf2__cfx_FaxLinkingDropDownList = null): self
    {
        // validation for constraint: string
        if (!is_null($cf2__cfx_FaxLinkingDropDownList) && !is_string($cf2__cfx_FaxLinkingDropDownList)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cf2__cfx_FaxLinkingDropDownList, true), gettype($cf2__cfx_FaxLinkingDropDownList)), __LINE__);
        }
        if (is_null($cf2__cfx_FaxLinkingDropDownList) || (is_array($cf2__cfx_FaxLinkingDropDownList) && empty($cf2__cfx_FaxLinkingDropDownList))) {
            unset($this->cf2__cfx_FaxLinkingDropDownList);
        } else {
            $this->cf2__cfx_FaxLinkingDropDownList = $cf2__cfx_FaxLinkingDropDownList;
        }
        
        return $this;
    }
}
