<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Individual_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Individual_DataObjectType extends AbstractStructBase
{
    /**
     * The ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_cst_key = null;
    /**
     * The ind_prf_code
     * Meta information extracted from the WSDL
     * - documentation: Prefix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_prf_code = null;
    /**
     * The ind_first_name
     * Meta information extracted from the WSDL
     * - documentation: First Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_first_name = null;
    /**
     * The ind_mid_name
     * Meta information extracted from the WSDL
     * - documentation: Middle Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_mid_name = null;
    /**
     * The ind_last_name
     * Meta information extracted from the WSDL
     * - documentation: Last Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_last_name = null;
    /**
     * The ind_sfx_code
     * Meta information extracted from the WSDL
     * - documentation: Suffix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_sfx_code = null;
    /**
     * The ind_designation
     * Meta information extracted from the WSDL
     * - documentation: Designation. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_designation = null;
    /**
     * The ind_dob
     * Meta information extracted from the WSDL
     * - documentation: Date of Birth. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_dob = null;
    /**
     * The ind_gender
     * Meta information extracted from the WSDL
     * - documentation: Gender. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_gender = null;
    /**
     * The ind_full_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 187
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_full_name_cp = null;
    /**
     * The ind_salutation_cp
     * Meta information extracted from the WSDL
     * - documentation: Salutation. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 51
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_salutation_cp = null;
    /**
     * The ind_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_cst_key_ext = null;
    /**
     * The ind_ssn
     * Meta information extracted from the WSDL
     * - documentation: social security number. This field has this Input Mask: ^[0-9]{3}-?[0-9]{2}-?[0-9]{4}. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_ssn = null;
    /**
     * The ind_spouse_name
     * Meta information extracted from the WSDL
     * - documentation: Spouse&apos;s Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_spouse_name = null;
    /**
     * The ind_age_cp
     * Meta information extracted from the WSDL
     * - documentation: age. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ind_age_cp = null;
    /**
     * The ind_salary
     * Meta information extracted from the WSDL
     * - documentation: annual salary. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ind_salary = null;
    /**
     * The ind_ethnicity
     * Meta information extracted from the WSDL
     * - documentation: ethnicity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_ethnicity = null;
    /**
     * The ind_badge_name
     * Meta information extracted from the WSDL
     * - documentation: badge name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_badge_name = null;
    /**
     * The ind_license_number
     * Meta information extracted from the WSDL
     * - documentation: license number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_license_number = null;
    /**
     * The ind_entered_field_date
     * Meta information extracted from the WSDL
     * - documentation: date first entered field. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_entered_field_date = null;
    /**
     * The ind_num_years_in_field_cp
     * Meta information extracted from the WSDL
     * - documentation: number of years in field. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ind_num_years_in_field_cp = null;
    /**
     * The ind_grad_date
     * Meta information extracted from the WSDL
     * - documentation: Graduation Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_grad_date = null;
    /**
     * The ind_political_party
     * Meta information extracted from the WSDL
     * - documentation: political party. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_political_party = null;
    /**
     * The ind_deceased_flag
     * Meta information extracted from the WSDL
     * - documentation: deceased. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_deceased_flag = null;
    /**
     * The ind_int_code
     * Meta information extracted from the WSDL
     * - documentation: Individual Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_int_code = null;
    /**
     * The ind_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Relationship. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_ixo_key = null;
    /**
     * The ind_marital_status
     * Meta information extracted from the WSDL
     * - documentation: Marital Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_marital_status = null;
    /**
     * The ind_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_add_date = null;
    /**
     * The ind_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_add_user = null;
    /**
     * The ind_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_entity_key = null;
    /**
     * The ind_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_change_date = null;
    /**
     * The ind_cst_passcode_ext
     * Meta information extracted from the WSDL
     * - documentation: cst passcode ext. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_cst_passcode_ext = null;
    /**
     * The ind_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_change_user = null;
    /**
     * The ind_sample_multi
     * Meta information extracted from the WSDL
     * - documentation: sample multi. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_sample_multi = null;
    /**
     * The ind_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_delete_flag = null;
    /**
     * The ind_maiden_name
     * Meta information extracted from the WSDL
     * - documentation: Former Last Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_maiden_name = null;
    /**
     * The ind_progress_ext
     * Meta information extracted from the WSDL
     * - documentation: Progress Ext. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_progress_ext = null;
    /**
     * The ind_ssn_display
     * Meta information extracted from the WSDL
     * - documentation: SSN (Last Four digit). | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_ssn_display = null;
    /**
     * The ind_aicpa_id
     * Meta information extracted from the WSDL
     * - documentation: AICPA ID. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_aicpa_id = null;
    /**
     * The ind_deceased_date
     * Meta information extracted from the WSDL
     * - documentation: Deceased Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_deceased_date = null;
    /**
     * The ind_prn_code
     * Meta information extracted from the WSDL
     * - documentation: Preferred Pronouns. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_prn_code = null;
    /**
     * The ind_popup
     * Meta information extracted from the WSDL
     * - documentation: Popup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_popup = null;
    /**
     * The ind_anonymization_status
     * Meta information extracted from the WSDL
     * - documentation: Anonymization Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ind_anonymization_status = null;
    /**
     * The ind_cst_main_office_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Main Office.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ind_cst_main_office_cst_key = null;
    /**
     * Constructor method for Individual_Individual_DataObjectType
     * @uses Individual_Individual_DataObjectType::setInd_cst_key()
     * @uses Individual_Individual_DataObjectType::setInd_prf_code()
     * @uses Individual_Individual_DataObjectType::setInd_first_name()
     * @uses Individual_Individual_DataObjectType::setInd_mid_name()
     * @uses Individual_Individual_DataObjectType::setInd_last_name()
     * @uses Individual_Individual_DataObjectType::setInd_sfx_code()
     * @uses Individual_Individual_DataObjectType::setInd_designation()
     * @uses Individual_Individual_DataObjectType::setInd_dob()
     * @uses Individual_Individual_DataObjectType::setInd_gender()
     * @uses Individual_Individual_DataObjectType::setInd_full_name_cp()
     * @uses Individual_Individual_DataObjectType::setInd_salutation_cp()
     * @uses Individual_Individual_DataObjectType::setInd_cst_key_ext()
     * @uses Individual_Individual_DataObjectType::setInd_ssn()
     * @uses Individual_Individual_DataObjectType::setInd_spouse_name()
     * @uses Individual_Individual_DataObjectType::setInd_age_cp()
     * @uses Individual_Individual_DataObjectType::setInd_salary()
     * @uses Individual_Individual_DataObjectType::setInd_ethnicity()
     * @uses Individual_Individual_DataObjectType::setInd_badge_name()
     * @uses Individual_Individual_DataObjectType::setInd_license_number()
     * @uses Individual_Individual_DataObjectType::setInd_entered_field_date()
     * @uses Individual_Individual_DataObjectType::setInd_num_years_in_field_cp()
     * @uses Individual_Individual_DataObjectType::setInd_grad_date()
     * @uses Individual_Individual_DataObjectType::setInd_political_party()
     * @uses Individual_Individual_DataObjectType::setInd_deceased_flag()
     * @uses Individual_Individual_DataObjectType::setInd_int_code()
     * @uses Individual_Individual_DataObjectType::setInd_ixo_key()
     * @uses Individual_Individual_DataObjectType::setInd_marital_status()
     * @uses Individual_Individual_DataObjectType::setInd_add_date()
     * @uses Individual_Individual_DataObjectType::setInd_add_user()
     * @uses Individual_Individual_DataObjectType::setInd_entity_key()
     * @uses Individual_Individual_DataObjectType::setInd_change_date()
     * @uses Individual_Individual_DataObjectType::setInd_cst_passcode_ext()
     * @uses Individual_Individual_DataObjectType::setInd_change_user()
     * @uses Individual_Individual_DataObjectType::setInd_sample_multi()
     * @uses Individual_Individual_DataObjectType::setInd_delete_flag()
     * @uses Individual_Individual_DataObjectType::setInd_maiden_name()
     * @uses Individual_Individual_DataObjectType::setInd_progress_ext()
     * @uses Individual_Individual_DataObjectType::setInd_ssn_display()
     * @uses Individual_Individual_DataObjectType::setInd_aicpa_id()
     * @uses Individual_Individual_DataObjectType::setInd_deceased_date()
     * @uses Individual_Individual_DataObjectType::setInd_prn_code()
     * @uses Individual_Individual_DataObjectType::setInd_popup()
     * @uses Individual_Individual_DataObjectType::setInd_anonymization_status()
     * @uses Individual_Individual_DataObjectType::setInd_cst_main_office_cst_key()
     * @param string $ind_cst_key
     * @param string $ind_prf_code
     * @param string $ind_first_name
     * @param string $ind_mid_name
     * @param string $ind_last_name
     * @param string $ind_sfx_code
     * @param string $ind_designation
     * @param string $ind_dob
     * @param string $ind_gender
     * @param string $ind_full_name_cp
     * @param string $ind_salutation_cp
     * @param string $ind_cst_key_ext
     * @param string $ind_ssn
     * @param string $ind_spouse_name
     * @param int $ind_age_cp
     * @param float $ind_salary
     * @param string $ind_ethnicity
     * @param string $ind_badge_name
     * @param string $ind_license_number
     * @param string $ind_entered_field_date
     * @param int $ind_num_years_in_field_cp
     * @param string $ind_grad_date
     * @param string $ind_political_party
     * @param string $ind_deceased_flag
     * @param string $ind_int_code
     * @param string $ind_ixo_key
     * @param string $ind_marital_status
     * @param string $ind_add_date
     * @param string $ind_add_user
     * @param string $ind_entity_key
     * @param string $ind_change_date
     * @param string $ind_cst_passcode_ext
     * @param string $ind_change_user
     * @param string $ind_sample_multi
     * @param string $ind_delete_flag
     * @param string $ind_maiden_name
     * @param string $ind_progress_ext
     * @param string $ind_ssn_display
     * @param string $ind_aicpa_id
     * @param string $ind_deceased_date
     * @param string $ind_prn_code
     * @param string $ind_popup
     * @param string $ind_anonymization_status
     * @param string $ind_cst_main_office_cst_key
     */
    public function __construct(?string $ind_cst_key = null, ?string $ind_prf_code = null, ?string $ind_first_name = null, ?string $ind_mid_name = null, ?string $ind_last_name = null, ?string $ind_sfx_code = null, ?string $ind_designation = null, ?string $ind_dob = null, ?string $ind_gender = null, ?string $ind_full_name_cp = null, ?string $ind_salutation_cp = null, ?string $ind_cst_key_ext = null, ?string $ind_ssn = null, ?string $ind_spouse_name = null, ?int $ind_age_cp = null, ?float $ind_salary = null, ?string $ind_ethnicity = null, ?string $ind_badge_name = null, ?string $ind_license_number = null, ?string $ind_entered_field_date = null, ?int $ind_num_years_in_field_cp = null, ?string $ind_grad_date = null, ?string $ind_political_party = null, ?string $ind_deceased_flag = null, ?string $ind_int_code = null, ?string $ind_ixo_key = null, ?string $ind_marital_status = null, ?string $ind_add_date = null, ?string $ind_add_user = null, ?string $ind_entity_key = null, ?string $ind_change_date = null, ?string $ind_cst_passcode_ext = null, ?string $ind_change_user = null, ?string $ind_sample_multi = null, ?string $ind_delete_flag = null, ?string $ind_maiden_name = null, ?string $ind_progress_ext = null, ?string $ind_ssn_display = null, ?string $ind_aicpa_id = null, ?string $ind_deceased_date = null, ?string $ind_prn_code = null, ?string $ind_popup = null, ?string $ind_anonymization_status = null, ?string $ind_cst_main_office_cst_key = null)
    {
        $this
            ->setInd_cst_key($ind_cst_key)
            ->setInd_prf_code($ind_prf_code)
            ->setInd_first_name($ind_first_name)
            ->setInd_mid_name($ind_mid_name)
            ->setInd_last_name($ind_last_name)
            ->setInd_sfx_code($ind_sfx_code)
            ->setInd_designation($ind_designation)
            ->setInd_dob($ind_dob)
            ->setInd_gender($ind_gender)
            ->setInd_full_name_cp($ind_full_name_cp)
            ->setInd_salutation_cp($ind_salutation_cp)
            ->setInd_cst_key_ext($ind_cst_key_ext)
            ->setInd_ssn($ind_ssn)
            ->setInd_spouse_name($ind_spouse_name)
            ->setInd_age_cp($ind_age_cp)
            ->setInd_salary($ind_salary)
            ->setInd_ethnicity($ind_ethnicity)
            ->setInd_badge_name($ind_badge_name)
            ->setInd_license_number($ind_license_number)
            ->setInd_entered_field_date($ind_entered_field_date)
            ->setInd_num_years_in_field_cp($ind_num_years_in_field_cp)
            ->setInd_grad_date($ind_grad_date)
            ->setInd_political_party($ind_political_party)
            ->setInd_deceased_flag($ind_deceased_flag)
            ->setInd_int_code($ind_int_code)
            ->setInd_ixo_key($ind_ixo_key)
            ->setInd_marital_status($ind_marital_status)
            ->setInd_add_date($ind_add_date)
            ->setInd_add_user($ind_add_user)
            ->setInd_entity_key($ind_entity_key)
            ->setInd_change_date($ind_change_date)
            ->setInd_cst_passcode_ext($ind_cst_passcode_ext)
            ->setInd_change_user($ind_change_user)
            ->setInd_sample_multi($ind_sample_multi)
            ->setInd_delete_flag($ind_delete_flag)
            ->setInd_maiden_name($ind_maiden_name)
            ->setInd_progress_ext($ind_progress_ext)
            ->setInd_ssn_display($ind_ssn_display)
            ->setInd_aicpa_id($ind_aicpa_id)
            ->setInd_deceased_date($ind_deceased_date)
            ->setInd_prn_code($ind_prn_code)
            ->setInd_popup($ind_popup)
            ->setInd_anonymization_status($ind_anonymization_status)
            ->setInd_cst_main_office_cst_key($ind_cst_main_office_cst_key);
    }
    /**
     * Get ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_cst_key(): ?string
    {
        return $this->ind_cst_key ?? null;
    }
    /**
     * Set ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_cst_key(?string $ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_cst_key) && !is_string($ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_cst_key, true), gettype($ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_cst_key, true)), __LINE__);
        }
        if (is_null($ind_cst_key) || (is_array($ind_cst_key) && empty($ind_cst_key))) {
            unset($this->ind_cst_key);
        } else {
            $this->ind_cst_key = $ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ind_prf_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_prf_code(): ?string
    {
        return $this->ind_prf_code ?? null;
    }
    /**
     * Set ind_prf_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_prf_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_prf_code(?string $ind_prf_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_prf_code) && !is_string($ind_prf_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_prf_code, true), gettype($ind_prf_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_prf_code) && mb_strlen((string) $ind_prf_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_prf_code)), __LINE__);
        }
        if (is_null($ind_prf_code) || (is_array($ind_prf_code) && empty($ind_prf_code))) {
            unset($this->ind_prf_code);
        } else {
            $this->ind_prf_code = $ind_prf_code;
        }
        
        return $this;
    }
    /**
     * Get ind_first_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_first_name(): ?string
    {
        return $this->ind_first_name ?? null;
    }
    /**
     * Set ind_first_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_first_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_first_name(?string $ind_first_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_first_name) && !is_string($ind_first_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_first_name, true), gettype($ind_first_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_first_name) && mb_strlen((string) $ind_first_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_first_name)), __LINE__);
        }
        if (is_null($ind_first_name) || (is_array($ind_first_name) && empty($ind_first_name))) {
            unset($this->ind_first_name);
        } else {
            $this->ind_first_name = $ind_first_name;
        }
        
        return $this;
    }
    /**
     * Get ind_mid_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_mid_name(): ?string
    {
        return $this->ind_mid_name ?? null;
    }
    /**
     * Set ind_mid_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_mid_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_mid_name(?string $ind_mid_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_mid_name) && !is_string($ind_mid_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_mid_name, true), gettype($ind_mid_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_mid_name) && mb_strlen((string) $ind_mid_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_mid_name)), __LINE__);
        }
        if (is_null($ind_mid_name) || (is_array($ind_mid_name) && empty($ind_mid_name))) {
            unset($this->ind_mid_name);
        } else {
            $this->ind_mid_name = $ind_mid_name;
        }
        
        return $this;
    }
    /**
     * Get ind_last_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_last_name(): ?string
    {
        return $this->ind_last_name ?? null;
    }
    /**
     * Set ind_last_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_last_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_last_name(?string $ind_last_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_last_name) && !is_string($ind_last_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_last_name, true), gettype($ind_last_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_last_name) && mb_strlen((string) $ind_last_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_last_name)), __LINE__);
        }
        if (is_null($ind_last_name) || (is_array($ind_last_name) && empty($ind_last_name))) {
            unset($this->ind_last_name);
        } else {
            $this->ind_last_name = $ind_last_name;
        }
        
        return $this;
    }
    /**
     * Get ind_sfx_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_sfx_code(): ?string
    {
        return $this->ind_sfx_code ?? null;
    }
    /**
     * Set ind_sfx_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_sfx_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_sfx_code(?string $ind_sfx_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_sfx_code) && !is_string($ind_sfx_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_sfx_code, true), gettype($ind_sfx_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_sfx_code) && mb_strlen((string) $ind_sfx_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_sfx_code)), __LINE__);
        }
        if (is_null($ind_sfx_code) || (is_array($ind_sfx_code) && empty($ind_sfx_code))) {
            unset($this->ind_sfx_code);
        } else {
            $this->ind_sfx_code = $ind_sfx_code;
        }
        
        return $this;
    }
    /**
     * Get ind_designation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_designation(): ?string
    {
        return $this->ind_designation ?? null;
    }
    /**
     * Set ind_designation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_designation
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_designation(?string $ind_designation = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_designation) && !is_string($ind_designation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_designation, true), gettype($ind_designation)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ind_designation) && mb_strlen((string) $ind_designation) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ind_designation)), __LINE__);
        }
        if (is_null($ind_designation) || (is_array($ind_designation) && empty($ind_designation))) {
            unset($this->ind_designation);
        } else {
            $this->ind_designation = $ind_designation;
        }
        
        return $this;
    }
    /**
     * Get ind_dob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_dob(): ?string
    {
        return $this->ind_dob ?? null;
    }
    /**
     * Set ind_dob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_dob
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_dob(?string $ind_dob = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_dob) && !is_string($ind_dob)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_dob, true), gettype($ind_dob)), __LINE__);
        }
        if (is_null($ind_dob) || (is_array($ind_dob) && empty($ind_dob))) {
            unset($this->ind_dob);
        } else {
            $this->ind_dob = $ind_dob;
        }
        
        return $this;
    }
    /**
     * Get ind_gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_gender(): ?string
    {
        return $this->ind_gender ?? null;
    }
    /**
     * Set ind_gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_gender
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_gender(?string $ind_gender = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_gender) && !is_string($ind_gender)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_gender, true), gettype($ind_gender)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_gender) && mb_strlen((string) $ind_gender) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_gender)), __LINE__);
        }
        if (is_null($ind_gender) || (is_array($ind_gender) && empty($ind_gender))) {
            unset($this->ind_gender);
        } else {
            $this->ind_gender = $ind_gender;
        }
        
        return $this;
    }
    /**
     * Get ind_full_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_full_name_cp(): ?string
    {
        return $this->ind_full_name_cp ?? null;
    }
    /**
     * Set ind_full_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_full_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_full_name_cp(?string $ind_full_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_full_name_cp) && !is_string($ind_full_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_full_name_cp, true), gettype($ind_full_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(187)
        if (!is_null($ind_full_name_cp) && mb_strlen((string) $ind_full_name_cp) > 187) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 187', mb_strlen((string) $ind_full_name_cp)), __LINE__);
        }
        if (is_null($ind_full_name_cp) || (is_array($ind_full_name_cp) && empty($ind_full_name_cp))) {
            unset($this->ind_full_name_cp);
        } else {
            $this->ind_full_name_cp = $ind_full_name_cp;
        }
        
        return $this;
    }
    /**
     * Get ind_salutation_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_salutation_cp(): ?string
    {
        return $this->ind_salutation_cp ?? null;
    }
    /**
     * Set ind_salutation_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_salutation_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_salutation_cp(?string $ind_salutation_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_salutation_cp) && !is_string($ind_salutation_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_salutation_cp, true), gettype($ind_salutation_cp)), __LINE__);
        }
        // validation for constraint: maxLength(51)
        if (!is_null($ind_salutation_cp) && mb_strlen((string) $ind_salutation_cp) > 51) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 51', mb_strlen((string) $ind_salutation_cp)), __LINE__);
        }
        if (is_null($ind_salutation_cp) || (is_array($ind_salutation_cp) && empty($ind_salutation_cp))) {
            unset($this->ind_salutation_cp);
        } else {
            $this->ind_salutation_cp = $ind_salutation_cp;
        }
        
        return $this;
    }
    /**
     * Get ind_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_cst_key_ext(): ?string
    {
        return $this->ind_cst_key_ext ?? null;
    }
    /**
     * Set ind_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_cst_key_ext(?string $ind_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_cst_key_ext) && !is_string($ind_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_cst_key_ext, true), gettype($ind_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_cst_key_ext, true)), __LINE__);
        }
        if (is_null($ind_cst_key_ext) || (is_array($ind_cst_key_ext) && empty($ind_cst_key_ext))) {
            unset($this->ind_cst_key_ext);
        } else {
            $this->ind_cst_key_ext = $ind_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ind_ssn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_ssn(): ?string
    {
        return $this->ind_ssn ?? null;
    }
    /**
     * Set ind_ssn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_ssn
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_ssn(?string $ind_ssn = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_ssn) && !is_string($ind_ssn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_ssn, true), gettype($ind_ssn)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($ind_ssn) && mb_strlen((string) $ind_ssn) > 2048) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen((string) $ind_ssn)), __LINE__);
        }
        if (is_null($ind_ssn) || (is_array($ind_ssn) && empty($ind_ssn))) {
            unset($this->ind_ssn);
        } else {
            $this->ind_ssn = $ind_ssn;
        }
        
        return $this;
    }
    /**
     * Get ind_spouse_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_spouse_name(): ?string
    {
        return $this->ind_spouse_name ?? null;
    }
    /**
     * Set ind_spouse_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_spouse_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_spouse_name(?string $ind_spouse_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_spouse_name) && !is_string($ind_spouse_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_spouse_name, true), gettype($ind_spouse_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($ind_spouse_name) && mb_strlen((string) $ind_spouse_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $ind_spouse_name)), __LINE__);
        }
        if (is_null($ind_spouse_name) || (is_array($ind_spouse_name) && empty($ind_spouse_name))) {
            unset($this->ind_spouse_name);
        } else {
            $this->ind_spouse_name = $ind_spouse_name;
        }
        
        return $this;
    }
    /**
     * Get ind_age_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInd_age_cp(): ?int
    {
        return $this->ind_age_cp ?? null;
    }
    /**
     * Set ind_age_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ind_age_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_age_cp(?int $ind_age_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($ind_age_cp) && !(is_int($ind_age_cp) || ctype_digit($ind_age_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ind_age_cp, true), gettype($ind_age_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ind_age_cp) && $ind_age_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ind_age_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ind_age_cp) && $ind_age_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ind_age_cp, true)), __LINE__);
        }
        if (is_null($ind_age_cp) || (is_array($ind_age_cp) && empty($ind_age_cp))) {
            unset($this->ind_age_cp);
        } else {
            $this->ind_age_cp = $ind_age_cp;
        }
        
        return $this;
    }
    /**
     * Get ind_salary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInd_salary(): ?float
    {
        return $this->ind_salary ?? null;
    }
    /**
     * Set ind_salary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ind_salary
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_salary(?float $ind_salary = null): self
    {
        // validation for constraint: float
        if (!is_null($ind_salary) && !(is_float($ind_salary) || is_numeric($ind_salary))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ind_salary, true), gettype($ind_salary)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ind_salary) && mb_strlen(mb_substr((string) $ind_salary, false !== mb_strpos((string) $ind_salary, '.') ? mb_strpos((string) $ind_salary, '.') + 1 : mb_strlen((string) $ind_salary))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ind_salary, true), mb_strlen(mb_substr((string) $ind_salary, mb_strpos((string) $ind_salary, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ind_salary) && mb_strlen(preg_replace('/(\D)/', '', (string) $ind_salary)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ind_salary, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ind_salary))), __LINE__);
        }
        if (is_null($ind_salary) || (is_array($ind_salary) && empty($ind_salary))) {
            unset($this->ind_salary);
        } else {
            $this->ind_salary = $ind_salary;
        }
        
        return $this;
    }
    /**
     * Get ind_ethnicity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_ethnicity(): ?string
    {
        return $this->ind_ethnicity ?? null;
    }
    /**
     * Set ind_ethnicity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_ethnicity
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_ethnicity(?string $ind_ethnicity = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_ethnicity) && !is_string($ind_ethnicity)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_ethnicity, true), gettype($ind_ethnicity)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ind_ethnicity) && mb_strlen((string) $ind_ethnicity) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ind_ethnicity)), __LINE__);
        }
        if (is_null($ind_ethnicity) || (is_array($ind_ethnicity) && empty($ind_ethnicity))) {
            unset($this->ind_ethnicity);
        } else {
            $this->ind_ethnicity = $ind_ethnicity;
        }
        
        return $this;
    }
    /**
     * Get ind_badge_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_badge_name(): ?string
    {
        return $this->ind_badge_name ?? null;
    }
    /**
     * Set ind_badge_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_badge_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_badge_name(?string $ind_badge_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_badge_name) && !is_string($ind_badge_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_badge_name, true), gettype($ind_badge_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_badge_name) && mb_strlen((string) $ind_badge_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_badge_name)), __LINE__);
        }
        if (is_null($ind_badge_name) || (is_array($ind_badge_name) && empty($ind_badge_name))) {
            unset($this->ind_badge_name);
        } else {
            $this->ind_badge_name = $ind_badge_name;
        }
        
        return $this;
    }
    /**
     * Get ind_license_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_license_number(): ?string
    {
        return $this->ind_license_number ?? null;
    }
    /**
     * Set ind_license_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_license_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_license_number(?string $ind_license_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_license_number) && !is_string($ind_license_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_license_number, true), gettype($ind_license_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_license_number) && mb_strlen((string) $ind_license_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_license_number)), __LINE__);
        }
        if (is_null($ind_license_number) || (is_array($ind_license_number) && empty($ind_license_number))) {
            unset($this->ind_license_number);
        } else {
            $this->ind_license_number = $ind_license_number;
        }
        
        return $this;
    }
    /**
     * Get ind_entered_field_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_entered_field_date(): ?string
    {
        return $this->ind_entered_field_date ?? null;
    }
    /**
     * Set ind_entered_field_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_entered_field_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_entered_field_date(?string $ind_entered_field_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_entered_field_date) && !is_string($ind_entered_field_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_entered_field_date, true), gettype($ind_entered_field_date)), __LINE__);
        }
        if (is_null($ind_entered_field_date) || (is_array($ind_entered_field_date) && empty($ind_entered_field_date))) {
            unset($this->ind_entered_field_date);
        } else {
            $this->ind_entered_field_date = $ind_entered_field_date;
        }
        
        return $this;
    }
    /**
     * Get ind_num_years_in_field_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInd_num_years_in_field_cp(): ?int
    {
        return $this->ind_num_years_in_field_cp ?? null;
    }
    /**
     * Set ind_num_years_in_field_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ind_num_years_in_field_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_num_years_in_field_cp(?int $ind_num_years_in_field_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($ind_num_years_in_field_cp) && !(is_int($ind_num_years_in_field_cp) || ctype_digit($ind_num_years_in_field_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ind_num_years_in_field_cp, true), gettype($ind_num_years_in_field_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ind_num_years_in_field_cp) && $ind_num_years_in_field_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ind_num_years_in_field_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ind_num_years_in_field_cp) && $ind_num_years_in_field_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ind_num_years_in_field_cp, true)), __LINE__);
        }
        if (is_null($ind_num_years_in_field_cp) || (is_array($ind_num_years_in_field_cp) && empty($ind_num_years_in_field_cp))) {
            unset($this->ind_num_years_in_field_cp);
        } else {
            $this->ind_num_years_in_field_cp = $ind_num_years_in_field_cp;
        }
        
        return $this;
    }
    /**
     * Get ind_grad_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_grad_date(): ?string
    {
        return $this->ind_grad_date ?? null;
    }
    /**
     * Set ind_grad_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_grad_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_grad_date(?string $ind_grad_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_grad_date) && !is_string($ind_grad_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_grad_date, true), gettype($ind_grad_date)), __LINE__);
        }
        if (is_null($ind_grad_date) || (is_array($ind_grad_date) && empty($ind_grad_date))) {
            unset($this->ind_grad_date);
        } else {
            $this->ind_grad_date = $ind_grad_date;
        }
        
        return $this;
    }
    /**
     * Get ind_political_party value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_political_party(): ?string
    {
        return $this->ind_political_party ?? null;
    }
    /**
     * Set ind_political_party value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_political_party
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_political_party(?string $ind_political_party = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_political_party) && !is_string($ind_political_party)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_political_party, true), gettype($ind_political_party)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_political_party) && mb_strlen((string) $ind_political_party) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_political_party)), __LINE__);
        }
        if (is_null($ind_political_party) || (is_array($ind_political_party) && empty($ind_political_party))) {
            unset($this->ind_political_party);
        } else {
            $this->ind_political_party = $ind_political_party;
        }
        
        return $this;
    }
    /**
     * Get ind_deceased_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_deceased_flag(): ?string
    {
        return $this->ind_deceased_flag ?? null;
    }
    /**
     * Set ind_deceased_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_deceased_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_deceased_flag(?string $ind_deceased_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_deceased_flag) && !is_string($ind_deceased_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_deceased_flag, true), gettype($ind_deceased_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ind_deceased_flag) && $ind_deceased_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ind_deceased_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ind_deceased_flag) && $ind_deceased_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ind_deceased_flag, true)), __LINE__);
        }
        if (is_null($ind_deceased_flag) || (is_array($ind_deceased_flag) && empty($ind_deceased_flag))) {
            unset($this->ind_deceased_flag);
        } else {
            $this->ind_deceased_flag = $ind_deceased_flag;
        }
        
        return $this;
    }
    /**
     * Get ind_int_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_int_code(): ?string
    {
        return $this->ind_int_code ?? null;
    }
    /**
     * Set ind_int_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_int_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_int_code(?string $ind_int_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_int_code) && !is_string($ind_int_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_int_code, true), gettype($ind_int_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ind_int_code) && mb_strlen((string) $ind_int_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ind_int_code)), __LINE__);
        }
        if (is_null($ind_int_code) || (is_array($ind_int_code) && empty($ind_int_code))) {
            unset($this->ind_int_code);
        } else {
            $this->ind_int_code = $ind_int_code;
        }
        
        return $this;
    }
    /**
     * Get ind_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_ixo_key(): ?string
    {
        return $this->ind_ixo_key ?? null;
    }
    /**
     * Set ind_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_ixo_key(?string $ind_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_ixo_key) && !is_string($ind_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_ixo_key, true), gettype($ind_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_ixo_key, true)), __LINE__);
        }
        if (is_null($ind_ixo_key) || (is_array($ind_ixo_key) && empty($ind_ixo_key))) {
            unset($this->ind_ixo_key);
        } else {
            $this->ind_ixo_key = $ind_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get ind_marital_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_marital_status(): ?string
    {
        return $this->ind_marital_status ?? null;
    }
    /**
     * Set ind_marital_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_marital_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_marital_status(?string $ind_marital_status = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_marital_status) && !is_string($ind_marital_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_marital_status, true), gettype($ind_marital_status)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ind_marital_status) && mb_strlen((string) $ind_marital_status) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ind_marital_status)), __LINE__);
        }
        if (is_null($ind_marital_status) || (is_array($ind_marital_status) && empty($ind_marital_status))) {
            unset($this->ind_marital_status);
        } else {
            $this->ind_marital_status = $ind_marital_status;
        }
        
        return $this;
    }
    /**
     * Get ind_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_add_date(): ?string
    {
        return $this->ind_add_date ?? null;
    }
    /**
     * Set ind_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_add_date(?string $ind_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_add_date) && !is_string($ind_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_add_date, true), gettype($ind_add_date)), __LINE__);
        }
        if (is_null($ind_add_date) || (is_array($ind_add_date) && empty($ind_add_date))) {
            unset($this->ind_add_date);
        } else {
            $this->ind_add_date = $ind_add_date;
        }
        
        return $this;
    }
    /**
     * Get ind_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_add_user(): ?string
    {
        return $this->ind_add_user ?? null;
    }
    /**
     * Set ind_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_add_user(?string $ind_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_add_user) && !is_string($ind_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_add_user, true), gettype($ind_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ind_add_user) && mb_strlen((string) $ind_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ind_add_user)), __LINE__);
        }
        if (is_null($ind_add_user) || (is_array($ind_add_user) && empty($ind_add_user))) {
            unset($this->ind_add_user);
        } else {
            $this->ind_add_user = $ind_add_user;
        }
        
        return $this;
    }
    /**
     * Get ind_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_entity_key(): ?string
    {
        return $this->ind_entity_key ?? null;
    }
    /**
     * Set ind_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_entity_key(?string $ind_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_entity_key) && !is_string($ind_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_entity_key, true), gettype($ind_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_entity_key, true)), __LINE__);
        }
        if (is_null($ind_entity_key) || (is_array($ind_entity_key) && empty($ind_entity_key))) {
            unset($this->ind_entity_key);
        } else {
            $this->ind_entity_key = $ind_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ind_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_change_date(): ?string
    {
        return $this->ind_change_date ?? null;
    }
    /**
     * Set ind_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_change_date(?string $ind_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_change_date) && !is_string($ind_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_change_date, true), gettype($ind_change_date)), __LINE__);
        }
        if (is_null($ind_change_date) || (is_array($ind_change_date) && empty($ind_change_date))) {
            unset($this->ind_change_date);
        } else {
            $this->ind_change_date = $ind_change_date;
        }
        
        return $this;
    }
    /**
     * Get ind_cst_passcode_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_cst_passcode_ext(): ?string
    {
        return $this->ind_cst_passcode_ext ?? null;
    }
    /**
     * Set ind_cst_passcode_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_cst_passcode_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_cst_passcode_ext(?string $ind_cst_passcode_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_cst_passcode_ext) && !is_string($ind_cst_passcode_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_cst_passcode_ext, true), gettype($ind_cst_passcode_ext)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_cst_passcode_ext) && mb_strlen((string) $ind_cst_passcode_ext) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_cst_passcode_ext)), __LINE__);
        }
        if (is_null($ind_cst_passcode_ext) || (is_array($ind_cst_passcode_ext) && empty($ind_cst_passcode_ext))) {
            unset($this->ind_cst_passcode_ext);
        } else {
            $this->ind_cst_passcode_ext = $ind_cst_passcode_ext;
        }
        
        return $this;
    }
    /**
     * Get ind_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_change_user(): ?string
    {
        return $this->ind_change_user ?? null;
    }
    /**
     * Set ind_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_change_user(?string $ind_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_change_user) && !is_string($ind_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_change_user, true), gettype($ind_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ind_change_user) && mb_strlen((string) $ind_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ind_change_user)), __LINE__);
        }
        if (is_null($ind_change_user) || (is_array($ind_change_user) && empty($ind_change_user))) {
            unset($this->ind_change_user);
        } else {
            $this->ind_change_user = $ind_change_user;
        }
        
        return $this;
    }
    /**
     * Get ind_sample_multi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_sample_multi(): ?string
    {
        return $this->ind_sample_multi ?? null;
    }
    /**
     * Set ind_sample_multi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_sample_multi
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_sample_multi(?string $ind_sample_multi = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_sample_multi) && !is_string($ind_sample_multi)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_sample_multi, true), gettype($ind_sample_multi)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ind_sample_multi) && mb_strlen((string) $ind_sample_multi) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ind_sample_multi)), __LINE__);
        }
        if (is_null($ind_sample_multi) || (is_array($ind_sample_multi) && empty($ind_sample_multi))) {
            unset($this->ind_sample_multi);
        } else {
            $this->ind_sample_multi = $ind_sample_multi;
        }
        
        return $this;
    }
    /**
     * Get ind_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_delete_flag(): ?string
    {
        return $this->ind_delete_flag ?? null;
    }
    /**
     * Set ind_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_delete_flag(?string $ind_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_delete_flag) && !is_string($ind_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_delete_flag, true), gettype($ind_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ind_delete_flag) && $ind_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ind_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ind_delete_flag) && $ind_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ind_delete_flag, true)), __LINE__);
        }
        if (is_null($ind_delete_flag) || (is_array($ind_delete_flag) && empty($ind_delete_flag))) {
            unset($this->ind_delete_flag);
        } else {
            $this->ind_delete_flag = $ind_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ind_maiden_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_maiden_name(): ?string
    {
        return $this->ind_maiden_name ?? null;
    }
    /**
     * Set ind_maiden_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_maiden_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_maiden_name(?string $ind_maiden_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_maiden_name) && !is_string($ind_maiden_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_maiden_name, true), gettype($ind_maiden_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_maiden_name) && mb_strlen((string) $ind_maiden_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_maiden_name)), __LINE__);
        }
        if (is_null($ind_maiden_name) || (is_array($ind_maiden_name) && empty($ind_maiden_name))) {
            unset($this->ind_maiden_name);
        } else {
            $this->ind_maiden_name = $ind_maiden_name;
        }
        
        return $this;
    }
    /**
     * Get ind_progress_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_progress_ext(): ?string
    {
        return $this->ind_progress_ext ?? null;
    }
    /**
     * Set ind_progress_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_progress_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_progress_ext(?string $ind_progress_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_progress_ext) && !is_string($ind_progress_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_progress_ext, true), gettype($ind_progress_ext)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ind_progress_ext) && mb_strlen((string) $ind_progress_ext) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ind_progress_ext)), __LINE__);
        }
        if (is_null($ind_progress_ext) || (is_array($ind_progress_ext) && empty($ind_progress_ext))) {
            unset($this->ind_progress_ext);
        } else {
            $this->ind_progress_ext = $ind_progress_ext;
        }
        
        return $this;
    }
    /**
     * Get ind_ssn_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_ssn_display(): ?string
    {
        return $this->ind_ssn_display ?? null;
    }
    /**
     * Set ind_ssn_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_ssn_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_ssn_display(?string $ind_ssn_display = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_ssn_display) && !is_string($ind_ssn_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_ssn_display, true), gettype($ind_ssn_display)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($ind_ssn_display) && mb_strlen((string) $ind_ssn_display) > 11) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen((string) $ind_ssn_display)), __LINE__);
        }
        if (is_null($ind_ssn_display) || (is_array($ind_ssn_display) && empty($ind_ssn_display))) {
            unset($this->ind_ssn_display);
        } else {
            $this->ind_ssn_display = $ind_ssn_display;
        }
        
        return $this;
    }
    /**
     * Get ind_aicpa_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_aicpa_id(): ?string
    {
        return $this->ind_aicpa_id ?? null;
    }
    /**
     * Set ind_aicpa_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_aicpa_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_aicpa_id(?string $ind_aicpa_id = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_aicpa_id) && !is_string($ind_aicpa_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_aicpa_id, true), gettype($ind_aicpa_id)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($ind_aicpa_id) && mb_strlen((string) $ind_aicpa_id) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $ind_aicpa_id)), __LINE__);
        }
        if (is_null($ind_aicpa_id) || (is_array($ind_aicpa_id) && empty($ind_aicpa_id))) {
            unset($this->ind_aicpa_id);
        } else {
            $this->ind_aicpa_id = $ind_aicpa_id;
        }
        
        return $this;
    }
    /**
     * Get ind_deceased_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_deceased_date(): ?string
    {
        return $this->ind_deceased_date ?? null;
    }
    /**
     * Set ind_deceased_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_deceased_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_deceased_date(?string $ind_deceased_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_deceased_date) && !is_string($ind_deceased_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_deceased_date, true), gettype($ind_deceased_date)), __LINE__);
        }
        if (is_null($ind_deceased_date) || (is_array($ind_deceased_date) && empty($ind_deceased_date))) {
            unset($this->ind_deceased_date);
        } else {
            $this->ind_deceased_date = $ind_deceased_date;
        }
        
        return $this;
    }
    /**
     * Get ind_prn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_prn_code(): ?string
    {
        return $this->ind_prn_code ?? null;
    }
    /**
     * Set ind_prn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_prn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_prn_code(?string $ind_prn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_prn_code) && !is_string($ind_prn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_prn_code, true), gettype($ind_prn_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ind_prn_code) && mb_strlen((string) $ind_prn_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ind_prn_code)), __LINE__);
        }
        if (is_null($ind_prn_code) || (is_array($ind_prn_code) && empty($ind_prn_code))) {
            unset($this->ind_prn_code);
        } else {
            $this->ind_prn_code = $ind_prn_code;
        }
        
        return $this;
    }
    /**
     * Get ind_popup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_popup(): ?string
    {
        return $this->ind_popup ?? null;
    }
    /**
     * Set ind_popup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_popup
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_popup(?string $ind_popup = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_popup) && !is_string($ind_popup)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_popup, true), gettype($ind_popup)), __LINE__);
        }
        if (is_null($ind_popup) || (is_array($ind_popup) && empty($ind_popup))) {
            unset($this->ind_popup);
        } else {
            $this->ind_popup = $ind_popup;
        }
        
        return $this;
    }
    /**
     * Get ind_anonymization_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_anonymization_status(): ?string
    {
        return $this->ind_anonymization_status ?? null;
    }
    /**
     * Set ind_anonymization_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_anonymization_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_anonymization_status(?string $ind_anonymization_status = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_anonymization_status) && !is_string($ind_anonymization_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_anonymization_status, true), gettype($ind_anonymization_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ind_anonymization_status) && mb_strlen((string) $ind_anonymization_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ind_anonymization_status)), __LINE__);
        }
        if (is_null($ind_anonymization_status) || (is_array($ind_anonymization_status) && empty($ind_anonymization_status))) {
            unset($this->ind_anonymization_status);
        } else {
            $this->ind_anonymization_status = $ind_anonymization_status;
        }
        
        return $this;
    }
    /**
     * Get ind_cst_main_office_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInd_cst_main_office_cst_key(): ?string
    {
        return $this->ind_cst_main_office_cst_key ?? null;
    }
    /**
     * Set ind_cst_main_office_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ind_cst_main_office_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
     */
    public function setInd_cst_main_office_cst_key(?string $ind_cst_main_office_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ind_cst_main_office_cst_key) && !is_string($ind_cst_main_office_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind_cst_main_office_cst_key, true), gettype($ind_cst_main_office_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ind_cst_main_office_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ind_cst_main_office_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ind_cst_main_office_cst_key, true)), __LINE__);
        }
        if (is_null($ind_cst_main_office_cst_key) || (is_array($ind_cst_main_office_cst_key) && empty($ind_cst_main_office_cst_key))) {
            unset($this->ind_cst_main_office_cst_key);
        } else {
            $this->ind_cst_main_office_cst_key = $ind_cst_main_office_cst_key;
        }
        
        return $this;
    }
}
