<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertActionSubType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InsertActionSubType extends AbstractStructBase
{
    /**
     * The actionTypeKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $actionTypeKey;
    /**
     * The actionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $actionCode;
    /**
     * Constructor method for InsertActionSubType
     * @uses InsertActionSubType::setActionTypeKey()
     * @uses InsertActionSubType::setActionCode()
     * @param string $actionTypeKey
     * @param string $actionCode
     */
    public function __construct(string $actionTypeKey, ?string $actionCode)
    {
        $this
            ->setActionTypeKey($actionTypeKey)
            ->setActionCode($actionCode);
    }
    /**
     * Get actionTypeKey value
     * @return string
     */
    public function getActionTypeKey(): string
    {
        return $this->actionTypeKey;
    }
    /**
     * Set actionTypeKey value
     * @param string $actionTypeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertActionSubType
     */
    public function setActionTypeKey(string $actionTypeKey): self
    {
        // validation for constraint: string
        if (!is_null($actionTypeKey) && !is_string($actionTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTypeKey, true), gettype($actionTypeKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($actionTypeKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $actionTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($actionTypeKey, true)), __LINE__);
        }
        $this->actionTypeKey = $actionTypeKey;
        
        return $this;
    }
    /**
     * Get actionCode value
     * @return string|null
     */
    public function getActionCode(): ?string
    {
        return $this->actionCode;
    }
    /**
     * Set actionCode value
     * @param string $actionCode
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertActionSubType
     */
    public function setActionCode(?string $actionCode): self
    {
        // validation for constraint: string
        if (!is_null($actionCode) && !is_string($actionCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionCode, true), gettype($actionCode)), __LINE__);
        }
        $this->actionCode = $actionCode;
        
        return $this;
    }
}
