<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertActionSubTypeResponse StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InsertActionSubTypeResponse extends AbstractStructBase
{
    /**
     * The InsertActionSubTypeResult
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $InsertActionSubTypeResult;
    /**
     * Constructor method for InsertActionSubTypeResponse
     * @uses InsertActionSubTypeResponse::setInsertActionSubTypeResult()
     * @param string $insertActionSubTypeResult
     */
    public function __construct(string $insertActionSubTypeResult)
    {
        $this
            ->setInsertActionSubTypeResult($insertActionSubTypeResult);
    }
    /**
     * Get InsertActionSubTypeResult value
     * @return string
     */
    public function getInsertActionSubTypeResult(): string
    {
        return $this->InsertActionSubTypeResult;
    }
    /**
     * Set InsertActionSubTypeResult value
     * @param string $insertActionSubTypeResult
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertActionSubTypeResponse
     */
    public function setInsertActionSubTypeResult(string $insertActionSubTypeResult): self
    {
        // validation for constraint: string
        if (!is_null($insertActionSubTypeResult) && !is_string($insertActionSubTypeResult)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertActionSubTypeResult, true), gettype($insertActionSubTypeResult)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($insertActionSubTypeResult) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $insertActionSubTypeResult)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($insertActionSubTypeResult, true)), __LINE__);
        }
        $this->InsertActionSubTypeResult = $insertActionSubTypeResult;
        
        return $this;
    }
}
