<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertCustomerActionResponse StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InsertCustomerActionResponse extends AbstractStructBase
{
    /**
     * The InsertCustomerActionResult
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $InsertCustomerActionResult;
    /**
     * Constructor method for InsertCustomerActionResponse
     * @uses InsertCustomerActionResponse::setInsertCustomerActionResult()
     * @param string $insertCustomerActionResult
     */
    public function __construct(string $insertCustomerActionResult)
    {
        $this
            ->setInsertCustomerActionResult($insertCustomerActionResult);
    }
    /**
     * Get InsertCustomerActionResult value
     * @return string
     */
    public function getInsertCustomerActionResult(): string
    {
        return $this->InsertCustomerActionResult;
    }
    /**
     * Set InsertCustomerActionResult value
     * @param string $insertCustomerActionResult
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerActionResponse
     */
    public function setInsertCustomerActionResult(string $insertCustomerActionResult): self
    {
        // validation for constraint: string
        if (!is_null($insertCustomerActionResult) && !is_string($insertCustomerActionResult)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertCustomerActionResult, true), gettype($insertCustomerActionResult)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($insertCustomerActionResult) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $insertCustomerActionResult)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($insertCustomerActionResult, true)), __LINE__);
        }
        $this->InsertCustomerActionResult = $insertCustomerActionResult;
        
        return $this;
    }
}
