<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetailAdditionalType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetailAdditionalType extends AbstractStructBase
{
    /**
     * The Invoice_Detail_Additional
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType $Invoice_Detail_Additional = null;
    /**
     * The Price
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType $Price = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for InvoiceDetailAdditionalType
     * @uses InvoiceDetailAdditionalType::setInvoice_Detail_Additional()
     * @uses InvoiceDetailAdditionalType::setPrice()
     * @uses InvoiceDetailAdditionalType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType $price
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType $price = null, ?string $currentKey = null)
    {
        $this
            ->setInvoice_Detail_Additional($invoice_Detail_Additional)
            ->setPrice($price)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Invoice_Detail_Additional value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType|null
     */
    public function getInvoice_Detail_Additional(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
    {
        return $this->Invoice_Detail_Additional;
    }
    /**
     * Set Invoice_Detail_Additional value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditionalType
     */
    public function setInvoice_Detail_Additional(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional = null): self
    {
        $this->Invoice_Detail_Additional = $invoice_Detail_Additional;
        
        return $this;
    }
    /**
     * Get Price value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType|null
     */
    public function getPrice(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType $price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditionalType
     */
    public function setPrice(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Price_DataObjectType $price = null): self
    {
        $this->Price = $price;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditionalType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
