<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType extends AbstractStructBase
{
    /**
     * The ida_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_key = null;
    /**
     * The ida_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_add_user = null;
    /**
     * The ida_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_add_date = null;
    /**
     * The ida_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_change_user = null;
    /**
     * The ida_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_change_date = null;
    /**
     * The ida_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_delete_flag = null;
    /**
     * The ida_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_key_ext = null;
    /**
     * The ida_type
     * Meta information extracted from the WSDL
     * - documentation: Transaction Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_type = null;
    /**
     * The ida_ivd_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_ivd_inv_key = null;
    /**
     * The ida_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_ivd_key = null;
    /**
     * The ida_amount
     * Meta information extracted from the WSDL
     * - documentation: Amount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ida_amount = null;
    /**
     * The ida_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Price Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_prc_key = null;
    /**
     * The ida_prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_prc_prd_key = null;
    /**
     * The ida_gla_key_cr
     * Meta information extracted from the WSDL
     * - documentation: Credit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_gla_key_cr = null;
    /**
     * The ida_gla_key_dr
     * Meta information extracted from the WSDL
     * - documentation: Debit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_gla_key_dr = null;
    /**
     * The ida_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_void_flag = null;
    /**
     * The ida_void_user
     * Meta information extracted from the WSDL
     * - documentation: Void User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_void_user = null;
    /**
     * The ida_void_date
     * Meta information extracted from the WSDL
     * - documentation: Void Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_void_date = null;
    /**
     * The ida_ivd_key_product
     * Meta information extracted from the WSDL
     * - documentation: Product Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_ivd_key_product = null;
    /**
     * The ida_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_entity_key = null;
    /**
     * The ida_oda_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Additional. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ida_oda_key = null;
    /**
     * The ida_cancel_flag
     * Meta information extracted from the WSDL
     * - documentation: Auto Refund.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ida_cancel_flag = null;
    /**
     * Constructor method for
     * InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_add_user()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_add_date()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_change_user()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_change_date()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_delete_flag()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_key_ext()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_type()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_ivd_inv_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_ivd_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_amount()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_prc_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_prc_prd_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_gla_key_cr()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_gla_key_dr()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_void_flag()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_void_user()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_void_date()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_ivd_key_product()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_entity_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_oda_key()
     * @uses InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType::setIda_cancel_flag()
     * @param string $ida_key
     * @param string $ida_add_user
     * @param string $ida_add_date
     * @param string $ida_change_user
     * @param string $ida_change_date
     * @param string $ida_delete_flag
     * @param string $ida_key_ext
     * @param string $ida_type
     * @param string $ida_ivd_inv_key
     * @param string $ida_ivd_key
     * @param float $ida_amount
     * @param string $ida_prc_key
     * @param string $ida_prc_prd_key
     * @param string $ida_gla_key_cr
     * @param string $ida_gla_key_dr
     * @param string $ida_void_flag
     * @param string $ida_void_user
     * @param string $ida_void_date
     * @param string $ida_ivd_key_product
     * @param string $ida_entity_key
     * @param string $ida_oda_key
     * @param string $ida_cancel_flag
     */
    public function __construct(?string $ida_key = null, ?string $ida_add_user = null, ?string $ida_add_date = null, ?string $ida_change_user = null, ?string $ida_change_date = null, ?string $ida_delete_flag = null, ?string $ida_key_ext = null, ?string $ida_type = null, ?string $ida_ivd_inv_key = null, ?string $ida_ivd_key = null, ?float $ida_amount = null, ?string $ida_prc_key = null, ?string $ida_prc_prd_key = null, ?string $ida_gla_key_cr = null, ?string $ida_gla_key_dr = null, ?string $ida_void_flag = null, ?string $ida_void_user = null, ?string $ida_void_date = null, ?string $ida_ivd_key_product = null, ?string $ida_entity_key = null, ?string $ida_oda_key = null, ?string $ida_cancel_flag = null)
    {
        $this
            ->setIda_key($ida_key)
            ->setIda_add_user($ida_add_user)
            ->setIda_add_date($ida_add_date)
            ->setIda_change_user($ida_change_user)
            ->setIda_change_date($ida_change_date)
            ->setIda_delete_flag($ida_delete_flag)
            ->setIda_key_ext($ida_key_ext)
            ->setIda_type($ida_type)
            ->setIda_ivd_inv_key($ida_ivd_inv_key)
            ->setIda_ivd_key($ida_ivd_key)
            ->setIda_amount($ida_amount)
            ->setIda_prc_key($ida_prc_key)
            ->setIda_prc_prd_key($ida_prc_prd_key)
            ->setIda_gla_key_cr($ida_gla_key_cr)
            ->setIda_gla_key_dr($ida_gla_key_dr)
            ->setIda_void_flag($ida_void_flag)
            ->setIda_void_user($ida_void_user)
            ->setIda_void_date($ida_void_date)
            ->setIda_ivd_key_product($ida_ivd_key_product)
            ->setIda_entity_key($ida_entity_key)
            ->setIda_oda_key($ida_oda_key)
            ->setIda_cancel_flag($ida_cancel_flag);
    }
    /**
     * Get ida_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_key(): ?string
    {
        return $this->ida_key ?? null;
    }
    /**
     * Set ida_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_key(?string $ida_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_key) && !is_string($ida_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_key, true), gettype($ida_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_key, true)), __LINE__);
        }
        if (is_null($ida_key) || (is_array($ida_key) && empty($ida_key))) {
            unset($this->ida_key);
        } else {
            $this->ida_key = $ida_key;
        }
        
        return $this;
    }
    /**
     * Get ida_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_add_user(): ?string
    {
        return $this->ida_add_user ?? null;
    }
    /**
     * Set ida_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_add_user(?string $ida_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_add_user) && !is_string($ida_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_add_user, true), gettype($ida_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ida_add_user) && mb_strlen((string) $ida_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ida_add_user)), __LINE__);
        }
        if (is_null($ida_add_user) || (is_array($ida_add_user) && empty($ida_add_user))) {
            unset($this->ida_add_user);
        } else {
            $this->ida_add_user = $ida_add_user;
        }
        
        return $this;
    }
    /**
     * Get ida_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_add_date(): ?string
    {
        return $this->ida_add_date ?? null;
    }
    /**
     * Set ida_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_add_date(?string $ida_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_add_date) && !is_string($ida_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_add_date, true), gettype($ida_add_date)), __LINE__);
        }
        if (is_null($ida_add_date) || (is_array($ida_add_date) && empty($ida_add_date))) {
            unset($this->ida_add_date);
        } else {
            $this->ida_add_date = $ida_add_date;
        }
        
        return $this;
    }
    /**
     * Get ida_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_change_user(): ?string
    {
        return $this->ida_change_user ?? null;
    }
    /**
     * Set ida_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_change_user(?string $ida_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_change_user) && !is_string($ida_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_change_user, true), gettype($ida_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ida_change_user) && mb_strlen((string) $ida_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ida_change_user)), __LINE__);
        }
        if (is_null($ida_change_user) || (is_array($ida_change_user) && empty($ida_change_user))) {
            unset($this->ida_change_user);
        } else {
            $this->ida_change_user = $ida_change_user;
        }
        
        return $this;
    }
    /**
     * Get ida_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_change_date(): ?string
    {
        return $this->ida_change_date ?? null;
    }
    /**
     * Set ida_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_change_date(?string $ida_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_change_date) && !is_string($ida_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_change_date, true), gettype($ida_change_date)), __LINE__);
        }
        if (is_null($ida_change_date) || (is_array($ida_change_date) && empty($ida_change_date))) {
            unset($this->ida_change_date);
        } else {
            $this->ida_change_date = $ida_change_date;
        }
        
        return $this;
    }
    /**
     * Get ida_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_delete_flag(): ?string
    {
        return $this->ida_delete_flag ?? null;
    }
    /**
     * Set ida_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_delete_flag(?string $ida_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_delete_flag) && !is_string($ida_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_delete_flag, true), gettype($ida_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ida_delete_flag) && $ida_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ida_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ida_delete_flag) && $ida_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ida_delete_flag, true)), __LINE__);
        }
        if (is_null($ida_delete_flag) || (is_array($ida_delete_flag) && empty($ida_delete_flag))) {
            unset($this->ida_delete_flag);
        } else {
            $this->ida_delete_flag = $ida_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ida_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_key_ext(): ?string
    {
        return $this->ida_key_ext ?? null;
    }
    /**
     * Set ida_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_key_ext(?string $ida_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_key_ext) && !is_string($ida_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_key_ext, true), gettype($ida_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_key_ext, true)), __LINE__);
        }
        if (is_null($ida_key_ext) || (is_array($ida_key_ext) && empty($ida_key_ext))) {
            unset($this->ida_key_ext);
        } else {
            $this->ida_key_ext = $ida_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ida_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_type(): ?string
    {
        return $this->ida_type ?? null;
    }
    /**
     * Set ida_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_type(?string $ida_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_type) && !is_string($ida_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_type, true), gettype($ida_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ida_type) && mb_strlen((string) $ida_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ida_type)), __LINE__);
        }
        if (is_null($ida_type) || (is_array($ida_type) && empty($ida_type))) {
            unset($this->ida_type);
        } else {
            $this->ida_type = $ida_type;
        }
        
        return $this;
    }
    /**
     * Get ida_ivd_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_ivd_inv_key(): ?string
    {
        return $this->ida_ivd_inv_key ?? null;
    }
    /**
     * Set ida_ivd_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_ivd_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_ivd_inv_key(?string $ida_ivd_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_ivd_inv_key) && !is_string($ida_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_ivd_inv_key, true), gettype($ida_ivd_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_ivd_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_ivd_inv_key, true)), __LINE__);
        }
        if (is_null($ida_ivd_inv_key) || (is_array($ida_ivd_inv_key) && empty($ida_ivd_inv_key))) {
            unset($this->ida_ivd_inv_key);
        } else {
            $this->ida_ivd_inv_key = $ida_ivd_inv_key;
        }
        
        return $this;
    }
    /**
     * Get ida_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_ivd_key(): ?string
    {
        return $this->ida_ivd_key ?? null;
    }
    /**
     * Set ida_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_ivd_key(?string $ida_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_ivd_key) && !is_string($ida_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_ivd_key, true), gettype($ida_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_ivd_key, true)), __LINE__);
        }
        if (is_null($ida_ivd_key) || (is_array($ida_ivd_key) && empty($ida_ivd_key))) {
            unset($this->ida_ivd_key);
        } else {
            $this->ida_ivd_key = $ida_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ida_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIda_amount(): ?float
    {
        return $this->ida_amount ?? null;
    }
    /**
     * Set ida_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ida_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_amount(?float $ida_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ida_amount) && !(is_float($ida_amount) || is_numeric($ida_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ida_amount, true), gettype($ida_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ida_amount) && mb_strlen(mb_substr((string) $ida_amount, false !== mb_strpos((string) $ida_amount, '.') ? mb_strpos((string) $ida_amount, '.') + 1 : mb_strlen((string) $ida_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ida_amount, true), mb_strlen(mb_substr((string) $ida_amount, mb_strpos((string) $ida_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ida_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ida_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ida_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ida_amount))), __LINE__);
        }
        if (is_null($ida_amount) || (is_array($ida_amount) && empty($ida_amount))) {
            unset($this->ida_amount);
        } else {
            $this->ida_amount = $ida_amount;
        }
        
        return $this;
    }
    /**
     * Get ida_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_prc_key(): ?string
    {
        return $this->ida_prc_key ?? null;
    }
    /**
     * Set ida_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_prc_key(?string $ida_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_prc_key) && !is_string($ida_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_prc_key, true), gettype($ida_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_prc_key, true)), __LINE__);
        }
        if (is_null($ida_prc_key) || (is_array($ida_prc_key) && empty($ida_prc_key))) {
            unset($this->ida_prc_key);
        } else {
            $this->ida_prc_key = $ida_prc_key;
        }
        
        return $this;
    }
    /**
     * Get ida_prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_prc_prd_key(): ?string
    {
        return $this->ida_prc_prd_key ?? null;
    }
    /**
     * Set ida_prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_prc_prd_key(?string $ida_prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_prc_prd_key) && !is_string($ida_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_prc_prd_key, true), gettype($ida_prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_prc_prd_key, true)), __LINE__);
        }
        if (is_null($ida_prc_prd_key) || (is_array($ida_prc_prd_key) && empty($ida_prc_prd_key))) {
            unset($this->ida_prc_prd_key);
        } else {
            $this->ida_prc_prd_key = $ida_prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ida_gla_key_cr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_gla_key_cr(): ?string
    {
        return $this->ida_gla_key_cr ?? null;
    }
    /**
     * Set ida_gla_key_cr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_gla_key_cr
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_gla_key_cr(?string $ida_gla_key_cr = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_gla_key_cr) && !is_string($ida_gla_key_cr)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_gla_key_cr, true), gettype($ida_gla_key_cr)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_gla_key_cr) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_gla_key_cr)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_gla_key_cr, true)), __LINE__);
        }
        if (is_null($ida_gla_key_cr) || (is_array($ida_gla_key_cr) && empty($ida_gla_key_cr))) {
            unset($this->ida_gla_key_cr);
        } else {
            $this->ida_gla_key_cr = $ida_gla_key_cr;
        }
        
        return $this;
    }
    /**
     * Get ida_gla_key_dr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_gla_key_dr(): ?string
    {
        return $this->ida_gla_key_dr ?? null;
    }
    /**
     * Set ida_gla_key_dr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_gla_key_dr
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_gla_key_dr(?string $ida_gla_key_dr = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_gla_key_dr) && !is_string($ida_gla_key_dr)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_gla_key_dr, true), gettype($ida_gla_key_dr)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_gla_key_dr) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_gla_key_dr)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_gla_key_dr, true)), __LINE__);
        }
        if (is_null($ida_gla_key_dr) || (is_array($ida_gla_key_dr) && empty($ida_gla_key_dr))) {
            unset($this->ida_gla_key_dr);
        } else {
            $this->ida_gla_key_dr = $ida_gla_key_dr;
        }
        
        return $this;
    }
    /**
     * Get ida_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_void_flag(): ?string
    {
        return $this->ida_void_flag ?? null;
    }
    /**
     * Set ida_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_void_flag(?string $ida_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_void_flag) && !is_string($ida_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_void_flag, true), gettype($ida_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ida_void_flag) && $ida_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ida_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ida_void_flag) && $ida_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ida_void_flag, true)), __LINE__);
        }
        if (is_null($ida_void_flag) || (is_array($ida_void_flag) && empty($ida_void_flag))) {
            unset($this->ida_void_flag);
        } else {
            $this->ida_void_flag = $ida_void_flag;
        }
        
        return $this;
    }
    /**
     * Get ida_void_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_void_user(): ?string
    {
        return $this->ida_void_user ?? null;
    }
    /**
     * Set ida_void_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_void_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_void_user(?string $ida_void_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_void_user) && !is_string($ida_void_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_void_user, true), gettype($ida_void_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ida_void_user) && mb_strlen((string) $ida_void_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ida_void_user)), __LINE__);
        }
        if (is_null($ida_void_user) || (is_array($ida_void_user) && empty($ida_void_user))) {
            unset($this->ida_void_user);
        } else {
            $this->ida_void_user = $ida_void_user;
        }
        
        return $this;
    }
    /**
     * Get ida_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_void_date(): ?string
    {
        return $this->ida_void_date ?? null;
    }
    /**
     * Set ida_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_void_date(?string $ida_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_void_date) && !is_string($ida_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_void_date, true), gettype($ida_void_date)), __LINE__);
        }
        if (is_null($ida_void_date) || (is_array($ida_void_date) && empty($ida_void_date))) {
            unset($this->ida_void_date);
        } else {
            $this->ida_void_date = $ida_void_date;
        }
        
        return $this;
    }
    /**
     * Get ida_ivd_key_product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_ivd_key_product(): ?string
    {
        return $this->ida_ivd_key_product ?? null;
    }
    /**
     * Set ida_ivd_key_product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_ivd_key_product
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_ivd_key_product(?string $ida_ivd_key_product = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_ivd_key_product) && !is_string($ida_ivd_key_product)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_ivd_key_product, true), gettype($ida_ivd_key_product)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_ivd_key_product) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_ivd_key_product)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_ivd_key_product, true)), __LINE__);
        }
        if (is_null($ida_ivd_key_product) || (is_array($ida_ivd_key_product) && empty($ida_ivd_key_product))) {
            unset($this->ida_ivd_key_product);
        } else {
            $this->ida_ivd_key_product = $ida_ivd_key_product;
        }
        
        return $this;
    }
    /**
     * Get ida_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_entity_key(): ?string
    {
        return $this->ida_entity_key ?? null;
    }
    /**
     * Set ida_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_entity_key(?string $ida_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_entity_key) && !is_string($ida_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_entity_key, true), gettype($ida_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_entity_key, true)), __LINE__);
        }
        if (is_null($ida_entity_key) || (is_array($ida_entity_key) && empty($ida_entity_key))) {
            unset($this->ida_entity_key);
        } else {
            $this->ida_entity_key = $ida_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ida_oda_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_oda_key(): ?string
    {
        return $this->ida_oda_key ?? null;
    }
    /**
     * Set ida_oda_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_oda_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_oda_key(?string $ida_oda_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_oda_key) && !is_string($ida_oda_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_oda_key, true), gettype($ida_oda_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ida_oda_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ida_oda_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ida_oda_key, true)), __LINE__);
        }
        if (is_null($ida_oda_key) || (is_array($ida_oda_key) && empty($ida_oda_key))) {
            unset($this->ida_oda_key);
        } else {
            $this->ida_oda_key = $ida_oda_key;
        }
        
        return $this;
    }
    /**
     * Get ida_cancel_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIda_cancel_flag(): ?string
    {
        return $this->ida_cancel_flag ?? null;
    }
    /**
     * Set ida_cancel_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ida_cancel_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailAdditional_Invoice_Detail_Additional_DataObjectType
     */
    public function setIda_cancel_flag(?string $ida_cancel_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ida_cancel_flag) && !is_string($ida_cancel_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ida_cancel_flag, true), gettype($ida_cancel_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ida_cancel_flag) && $ida_cancel_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ida_cancel_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ida_cancel_flag) && $ida_cancel_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ida_cancel_flag, true)), __LINE__);
        }
        if (is_null($ida_cancel_flag) || (is_array($ida_cancel_flag) && empty($ida_cancel_flag))) {
            unset($this->ida_cancel_flag);
        } else {
            $this->ida_cancel_flag = $ida_cancel_flag;
        }
        
        return $this;
    }
}
