<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType extends AbstractStructBase
{
    /**
     * The idx_idc_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail x Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idx_idc_key = null;
    /**
     * The idx_idc_total
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Total. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idx_idc_total = null;
    /**
     * The idx_idc_original_payamount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Original Payamount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idx_idc_original_payamount = null;
    /**
     * The idx_idc_balance
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Balance. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idx_idc_balance = null;
    /**
     * The idx_idc_original_writeoff_amount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Original Writeoff Amount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idx_idc_original_writeoff_amount = null;
    /**
     * The idx_idc_original_cancel_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Original Cancel Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idx_idc_original_cancel_qty = null;
    /**
     * The idx_idc_available_cancel_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Available Cancel Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idx_idc_available_cancel_qty = null;
    /**
     * The idx_idc_original_return_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Original Return Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idx_idc_original_return_qty = null;
    /**
     * The idx_idc_available_return_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Available Return Quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $idx_idc_available_return_qty = null;
    /**
     * The idx_idc_available_credit_dollar_amount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Customer Available Credit Dollar Amount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idx_idc_available_credit_dollar_amount = null;
    /**
     * Constructor method for
     * InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_total()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_original_payamount()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_balance()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_original_writeoff_amount()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_original_cancel_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_available_cancel_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_original_return_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_available_return_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType::setIdx_idc_available_credit_dollar_amount()
     * @param string $idx_idc_key
     * @param float $idx_idc_total
     * @param float $idx_idc_original_payamount
     * @param float $idx_idc_balance
     * @param float $idx_idc_original_writeoff_amount
     * @param float $idx_idc_original_cancel_qty
     * @param float $idx_idc_available_cancel_qty
     * @param float $idx_idc_original_return_qty
     * @param int $idx_idc_available_return_qty
     * @param float $idx_idc_available_credit_dollar_amount
     */
    public function __construct(?string $idx_idc_key = null, ?float $idx_idc_total = null, ?float $idx_idc_original_payamount = null, ?float $idx_idc_balance = null, ?float $idx_idc_original_writeoff_amount = null, ?float $idx_idc_original_cancel_qty = null, ?float $idx_idc_available_cancel_qty = null, ?float $idx_idc_original_return_qty = null, ?int $idx_idc_available_return_qty = null, ?float $idx_idc_available_credit_dollar_amount = null)
    {
        $this
            ->setIdx_idc_key($idx_idc_key)
            ->setIdx_idc_total($idx_idc_total)
            ->setIdx_idc_original_payamount($idx_idc_original_payamount)
            ->setIdx_idc_balance($idx_idc_balance)
            ->setIdx_idc_original_writeoff_amount($idx_idc_original_writeoff_amount)
            ->setIdx_idc_original_cancel_qty($idx_idc_original_cancel_qty)
            ->setIdx_idc_available_cancel_qty($idx_idc_available_cancel_qty)
            ->setIdx_idc_original_return_qty($idx_idc_original_return_qty)
            ->setIdx_idc_available_return_qty($idx_idc_available_return_qty)
            ->setIdx_idc_available_credit_dollar_amount($idx_idc_available_credit_dollar_amount);
    }
    /**
     * Get idx_idc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdx_idc_key(): ?string
    {
        return $this->idx_idc_key ?? null;
    }
    /**
     * Set idx_idc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idx_idc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_key(?string $idx_idc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idx_idc_key) && !is_string($idx_idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idx_idc_key, true), gettype($idx_idc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idx_idc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idx_idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idx_idc_key, true)), __LINE__);
        }
        if (is_null($idx_idc_key) || (is_array($idx_idc_key) && empty($idx_idc_key))) {
            unset($this->idx_idc_key);
        } else {
            $this->idx_idc_key = $idx_idc_key;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_total(): ?float
    {
        return $this->idx_idc_total ?? null;
    }
    /**
     * Set idx_idc_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_total(?float $idx_idc_total = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_total) && !(is_float($idx_idc_total) || is_numeric($idx_idc_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_total, true), gettype($idx_idc_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_total) && mb_strlen(mb_substr((string) $idx_idc_total, false !== mb_strpos((string) $idx_idc_total, '.') ? mb_strpos((string) $idx_idc_total, '.') + 1 : mb_strlen((string) $idx_idc_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_total, true), mb_strlen(mb_substr((string) $idx_idc_total, mb_strpos((string) $idx_idc_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idx_idc_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idx_idc_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_total))), __LINE__);
        }
        if (is_null($idx_idc_total) || (is_array($idx_idc_total) && empty($idx_idc_total))) {
            unset($this->idx_idc_total);
        } else {
            $this->idx_idc_total = $idx_idc_total;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_original_payamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_original_payamount(): ?float
    {
        return $this->idx_idc_original_payamount ?? null;
    }
    /**
     * Set idx_idc_original_payamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_original_payamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_original_payamount(?float $idx_idc_original_payamount = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_original_payamount) && !(is_float($idx_idc_original_payamount) || is_numeric($idx_idc_original_payamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_original_payamount, true), gettype($idx_idc_original_payamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_original_payamount) && mb_strlen(mb_substr((string) $idx_idc_original_payamount, false !== mb_strpos((string) $idx_idc_original_payamount, '.') ? mb_strpos((string) $idx_idc_original_payamount, '.') + 1 : mb_strlen((string) $idx_idc_original_payamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_original_payamount, true), mb_strlen(mb_substr((string) $idx_idc_original_payamount, mb_strpos((string) $idx_idc_original_payamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idx_idc_original_payamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_payamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idx_idc_original_payamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_payamount))), __LINE__);
        }
        if (is_null($idx_idc_original_payamount) || (is_array($idx_idc_original_payamount) && empty($idx_idc_original_payamount))) {
            unset($this->idx_idc_original_payamount);
        } else {
            $this->idx_idc_original_payamount = $idx_idc_original_payamount;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_balance(): ?float
    {
        return $this->idx_idc_balance ?? null;
    }
    /**
     * Set idx_idc_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_balance(?float $idx_idc_balance = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_balance) && !(is_float($idx_idc_balance) || is_numeric($idx_idc_balance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_balance, true), gettype($idx_idc_balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_balance) && mb_strlen(mb_substr((string) $idx_idc_balance, false !== mb_strpos((string) $idx_idc_balance, '.') ? mb_strpos((string) $idx_idc_balance, '.') + 1 : mb_strlen((string) $idx_idc_balance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_balance, true), mb_strlen(mb_substr((string) $idx_idc_balance, mb_strpos((string) $idx_idc_balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idx_idc_balance) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_balance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idx_idc_balance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_balance))), __LINE__);
        }
        if (is_null($idx_idc_balance) || (is_array($idx_idc_balance) && empty($idx_idc_balance))) {
            unset($this->idx_idc_balance);
        } else {
            $this->idx_idc_balance = $idx_idc_balance;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_original_writeoff_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_original_writeoff_amount(): ?float
    {
        return $this->idx_idc_original_writeoff_amount ?? null;
    }
    /**
     * Set idx_idc_original_writeoff_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_original_writeoff_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_original_writeoff_amount(?float $idx_idc_original_writeoff_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_original_writeoff_amount) && !(is_float($idx_idc_original_writeoff_amount) || is_numeric($idx_idc_original_writeoff_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_original_writeoff_amount, true), gettype($idx_idc_original_writeoff_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_original_writeoff_amount) && mb_strlen(mb_substr((string) $idx_idc_original_writeoff_amount, false !== mb_strpos((string) $idx_idc_original_writeoff_amount, '.') ? mb_strpos((string) $idx_idc_original_writeoff_amount, '.') + 1 : mb_strlen((string) $idx_idc_original_writeoff_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_original_writeoff_amount, true), mb_strlen(mb_substr((string) $idx_idc_original_writeoff_amount, mb_strpos((string) $idx_idc_original_writeoff_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idx_idc_original_writeoff_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_writeoff_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idx_idc_original_writeoff_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_writeoff_amount))), __LINE__);
        }
        if (is_null($idx_idc_original_writeoff_amount) || (is_array($idx_idc_original_writeoff_amount) && empty($idx_idc_original_writeoff_amount))) {
            unset($this->idx_idc_original_writeoff_amount);
        } else {
            $this->idx_idc_original_writeoff_amount = $idx_idc_original_writeoff_amount;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_original_cancel_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_original_cancel_qty(): ?float
    {
        return $this->idx_idc_original_cancel_qty ?? null;
    }
    /**
     * Set idx_idc_original_cancel_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_original_cancel_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_original_cancel_qty(?float $idx_idc_original_cancel_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_original_cancel_qty) && !(is_float($idx_idc_original_cancel_qty) || is_numeric($idx_idc_original_cancel_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_original_cancel_qty, true), gettype($idx_idc_original_cancel_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_original_cancel_qty) && mb_strlen(mb_substr((string) $idx_idc_original_cancel_qty, false !== mb_strpos((string) $idx_idc_original_cancel_qty, '.') ? mb_strpos((string) $idx_idc_original_cancel_qty, '.') + 1 : mb_strlen((string) $idx_idc_original_cancel_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_original_cancel_qty, true), mb_strlen(mb_substr((string) $idx_idc_original_cancel_qty, mb_strpos((string) $idx_idc_original_cancel_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idx_idc_original_cancel_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_cancel_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idx_idc_original_cancel_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_cancel_qty))), __LINE__);
        }
        if (is_null($idx_idc_original_cancel_qty) || (is_array($idx_idc_original_cancel_qty) && empty($idx_idc_original_cancel_qty))) {
            unset($this->idx_idc_original_cancel_qty);
        } else {
            $this->idx_idc_original_cancel_qty = $idx_idc_original_cancel_qty;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_available_cancel_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_available_cancel_qty(): ?float
    {
        return $this->idx_idc_available_cancel_qty ?? null;
    }
    /**
     * Set idx_idc_available_cancel_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_available_cancel_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_available_cancel_qty(?float $idx_idc_available_cancel_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_available_cancel_qty) && !(is_float($idx_idc_available_cancel_qty) || is_numeric($idx_idc_available_cancel_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_available_cancel_qty, true), gettype($idx_idc_available_cancel_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_available_cancel_qty) && mb_strlen(mb_substr((string) $idx_idc_available_cancel_qty, false !== mb_strpos((string) $idx_idc_available_cancel_qty, '.') ? mb_strpos((string) $idx_idc_available_cancel_qty, '.') + 1 : mb_strlen((string) $idx_idc_available_cancel_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_available_cancel_qty, true), mb_strlen(mb_substr((string) $idx_idc_available_cancel_qty, mb_strpos((string) $idx_idc_available_cancel_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idx_idc_available_cancel_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_available_cancel_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idx_idc_available_cancel_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_available_cancel_qty))), __LINE__);
        }
        if (is_null($idx_idc_available_cancel_qty) || (is_array($idx_idc_available_cancel_qty) && empty($idx_idc_available_cancel_qty))) {
            unset($this->idx_idc_available_cancel_qty);
        } else {
            $this->idx_idc_available_cancel_qty = $idx_idc_available_cancel_qty;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_original_return_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_original_return_qty(): ?float
    {
        return $this->idx_idc_original_return_qty ?? null;
    }
    /**
     * Set idx_idc_original_return_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_original_return_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_original_return_qty(?float $idx_idc_original_return_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_original_return_qty) && !(is_float($idx_idc_original_return_qty) || is_numeric($idx_idc_original_return_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_original_return_qty, true), gettype($idx_idc_original_return_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_original_return_qty) && mb_strlen(mb_substr((string) $idx_idc_original_return_qty, false !== mb_strpos((string) $idx_idc_original_return_qty, '.') ? mb_strpos((string) $idx_idc_original_return_qty, '.') + 1 : mb_strlen((string) $idx_idc_original_return_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_original_return_qty, true), mb_strlen(mb_substr((string) $idx_idc_original_return_qty, mb_strpos((string) $idx_idc_original_return_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idx_idc_original_return_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_return_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idx_idc_original_return_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_original_return_qty))), __LINE__);
        }
        if (is_null($idx_idc_original_return_qty) || (is_array($idx_idc_original_return_qty) && empty($idx_idc_original_return_qty))) {
            unset($this->idx_idc_original_return_qty);
        } else {
            $this->idx_idc_original_return_qty = $idx_idc_original_return_qty;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_available_return_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdx_idc_available_return_qty(): ?int
    {
        return $this->idx_idc_available_return_qty ?? null;
    }
    /**
     * Set idx_idc_available_return_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idx_idc_available_return_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_available_return_qty(?int $idx_idc_available_return_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($idx_idc_available_return_qty) && !(is_int($idx_idc_available_return_qty) || ctype_digit($idx_idc_available_return_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idx_idc_available_return_qty, true), gettype($idx_idc_available_return_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($idx_idc_available_return_qty) && $idx_idc_available_return_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($idx_idc_available_return_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($idx_idc_available_return_qty) && $idx_idc_available_return_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($idx_idc_available_return_qty, true)), __LINE__);
        }
        if (is_null($idx_idc_available_return_qty) || (is_array($idx_idc_available_return_qty) && empty($idx_idc_available_return_qty))) {
            unset($this->idx_idc_available_return_qty);
        } else {
            $this->idx_idc_available_return_qty = $idx_idc_available_return_qty;
        }
        
        return $this;
    }
    /**
     * Get idx_idc_available_credit_dollar_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdx_idc_available_credit_dollar_amount(): ?float
    {
        return $this->idx_idc_available_credit_dollar_amount ?? null;
    }
    /**
     * Set idx_idc_available_credit_dollar_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idx_idc_available_credit_dollar_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_View_DataObjectType
     */
    public function setIdx_idc_available_credit_dollar_amount(?float $idx_idc_available_credit_dollar_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($idx_idc_available_credit_dollar_amount) && !(is_float($idx_idc_available_credit_dollar_amount) || is_numeric($idx_idc_available_credit_dollar_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idx_idc_available_credit_dollar_amount, true), gettype($idx_idc_available_credit_dollar_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idx_idc_available_credit_dollar_amount) && mb_strlen(mb_substr((string) $idx_idc_available_credit_dollar_amount, false !== mb_strpos((string) $idx_idc_available_credit_dollar_amount, '.') ? mb_strpos((string) $idx_idc_available_credit_dollar_amount, '.') + 1 : mb_strlen((string) $idx_idc_available_credit_dollar_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idx_idc_available_credit_dollar_amount, true), mb_strlen(mb_substr((string) $idx_idc_available_credit_dollar_amount, mb_strpos((string) $idx_idc_available_credit_dollar_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idx_idc_available_credit_dollar_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_available_credit_dollar_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idx_idc_available_credit_dollar_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idx_idc_available_credit_dollar_amount))), __LINE__);
        }
        if (is_null($idx_idc_available_credit_dollar_amount) || (is_array($idx_idc_available_credit_dollar_amount) && empty($idx_idc_available_credit_dollar_amount))) {
            unset($this->idx_idc_available_credit_dollar_amount);
        } else {
            $this->idx_idc_available_credit_dollar_amount = $idx_idc_available_credit_dollar_amount;
        }
        
        return $this;
    }
}
