<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetailType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetailType extends AbstractStructBase
{
    /**
     * The Invoice_Detail
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType $Invoice_Detail = null;
    /**
     * The Invoice_Detail_Term
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType $Invoice_Detail_Term = null;
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType $Invoice = null;
    /**
     * The Price
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType $Price = null;
    /**
     * The Product
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType $Product = null;
    /**
     * The ShipToCustomer
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType $ShipToCustomer = null;
    /**
     * The SoldToCustomer
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType $SoldToCustomer = null;
    /**
     * The Shipping_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType $Shipping_Address = null;
    /**
     * The Shipping_Address_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType $Shipping_Address_Type = null;
    /**
     * The Invoice_Detail_Additional
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType $Invoice_Detail_Additional = null;
    /**
     * The Package_Component
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType $Package_Component = null;
    /**
     * The Bundle_Component
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType $Bundle_Component = null;
    /**
     * The Product_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType $Product_Type = null;
    /**
     * The Discount_Product_X_Product
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType $Discount_Product_X_Product = null;
    /**
     * The Billing_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType $Billing_Address = null;
    /**
     * The Currency
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType $Currency = null;
    /**
     * The Order_Detail_Schedule
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType $Order_Detail_Schedule = null;
    /**
     * The Invoice_Detail_IP_Range
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType $Invoice_Detail_IP_Range = null;
    /**
     * The Product_Type_Social_Messages
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType $Product_Type_Social_Messages = null;
    /**
     * The Invoice_Detail_Liability
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType $Invoice_Detail_Liability = null;
    /**
     * The Credit_Detail
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType $Credit_Detail = null;
    /**
     * The Invoice_Detail_Amount_Due
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType $Invoice_Detail_Amount_Due = null;
    /**
     * The Invoice_Detail_Get_Balance
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType $Invoice_Detail_Get_Balance = null;
    /**
     * The Additional_Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $Additional_Invoice_DetailCollection = null;
    /**
     * The Invoice_Detail_AdditionalCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType $Invoice_Detail_AdditionalCollection = null;
    /**
     * The Invoice_Detail_LiabilityCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType $Invoice_Detail_LiabilityCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for InvoiceDetailType
     * @uses InvoiceDetailType::setInvoice_Detail()
     * @uses InvoiceDetailType::setInvoice_Detail_Term()
     * @uses InvoiceDetailType::setInvoice()
     * @uses InvoiceDetailType::setPrice()
     * @uses InvoiceDetailType::setProduct()
     * @uses InvoiceDetailType::setShipToCustomer()
     * @uses InvoiceDetailType::setSoldToCustomer()
     * @uses InvoiceDetailType::setShipping_Address()
     * @uses InvoiceDetailType::setShipping_Address_Type()
     * @uses InvoiceDetailType::setInvoice_Detail_Additional()
     * @uses InvoiceDetailType::setPackage_Component()
     * @uses InvoiceDetailType::setBundle_Component()
     * @uses InvoiceDetailType::setProduct_Type()
     * @uses InvoiceDetailType::setDiscount_Product_X_Product()
     * @uses InvoiceDetailType::setBilling_Address()
     * @uses InvoiceDetailType::setCurrency()
     * @uses InvoiceDetailType::setOrder_Detail_Schedule()
     * @uses InvoiceDetailType::setInvoice_Detail_IP_Range()
     * @uses InvoiceDetailType::setProduct_Type_Social_Messages()
     * @uses InvoiceDetailType::setInvoice_Detail_Liability()
     * @uses InvoiceDetailType::setCredit_Detail()
     * @uses InvoiceDetailType::setInvoice_Detail_Amount_Due()
     * @uses InvoiceDetailType::setInvoice_Detail_Get_Balance()
     * @uses InvoiceDetailType::setAdditional_Invoice_DetailCollection()
     * @uses InvoiceDetailType::setInvoice_Detail_AdditionalCollection()
     * @uses InvoiceDetailType::setInvoice_Detail_LiabilityCollection()
     * @uses InvoiceDetailType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType $invoice_Detail
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType $price
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType $product
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType $shipToCustomer
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType $soldToCustomer
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType $shipping_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType $shipping_Address_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType $package_Component
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType $bundle_Component
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType $product_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType $discount_Product_X_Product
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType $billing_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType $currency
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType $order_Detail_Schedule
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType $invoice_Detail_IP_Range
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType $product_Type_Social_Messages
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType $invoice_Detail_Liability
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType $credit_Detail
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType $invoice_Detail_Amount_Due
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType $invoice_Detail_Get_Balance
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType $invoice_Detail_AdditionalCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType $invoice_Detail_LiabilityCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType $invoice_Detail = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType $price = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType $product = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType $shipToCustomer = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType $soldToCustomer = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType $shipping_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType $shipping_Address_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType $package_Component = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType $bundle_Component = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType $product_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType $discount_Product_X_Product = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType $billing_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType $currency = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType $order_Detail_Schedule = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType $invoice_Detail_IP_Range = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType $product_Type_Social_Messages = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType $invoice_Detail_Liability = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType $credit_Detail = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType $invoice_Detail_Amount_Due = null, ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType $invoice_Detail_Get_Balance = null, ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType $invoice_Detail_AdditionalCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType $invoice_Detail_LiabilityCollection = null, ?string $currentKey = null)
    {
        $this
            ->setInvoice_Detail($invoice_Detail)
            ->setInvoice_Detail_Term($invoice_Detail_Term)
            ->setInvoice($invoice)
            ->setPrice($price)
            ->setProduct($product)
            ->setShipToCustomer($shipToCustomer)
            ->setSoldToCustomer($soldToCustomer)
            ->setShipping_Address($shipping_Address)
            ->setShipping_Address_Type($shipping_Address_Type)
            ->setInvoice_Detail_Additional($invoice_Detail_Additional)
            ->setPackage_Component($package_Component)
            ->setBundle_Component($bundle_Component)
            ->setProduct_Type($product_Type)
            ->setDiscount_Product_X_Product($discount_Product_X_Product)
            ->setBilling_Address($billing_Address)
            ->setCurrency($currency)
            ->setOrder_Detail_Schedule($order_Detail_Schedule)
            ->setInvoice_Detail_IP_Range($invoice_Detail_IP_Range)
            ->setProduct_Type_Social_Messages($product_Type_Social_Messages)
            ->setInvoice_Detail_Liability($invoice_Detail_Liability)
            ->setCredit_Detail($credit_Detail)
            ->setInvoice_Detail_Amount_Due($invoice_Detail_Amount_Due)
            ->setInvoice_Detail_Get_Balance($invoice_Detail_Get_Balance)
            ->setAdditional_Invoice_DetailCollection($additional_Invoice_DetailCollection)
            ->setInvoice_Detail_AdditionalCollection($invoice_Detail_AdditionalCollection)
            ->setInvoice_Detail_LiabilityCollection($invoice_Detail_LiabilityCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Invoice_Detail value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType|null
     */
    public function getInvoice_Detail(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
    {
        return $this->Invoice_Detail;
    }
    /**
     * Set Invoice_Detail value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType $invoice_Detail
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType $invoice_Detail = null): self
    {
        $this->Invoice_Detail = $invoice_Detail;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Term value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType|null
     */
    public function getInvoice_Detail_Term(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType
    {
        return $this->Invoice_Detail_Term;
    }
    /**
     * Set Invoice_Detail_Term value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_Term(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term = null): self
    {
        $this->Invoice_Detail_Term = $invoice_Detail_Term;
        
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Price value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType|null
     */
    public function getPrice(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType $price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setPrice(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Price_DataObjectType $price = null): self
    {
        $this->Price = $price;
        
        return $this;
    }
    /**
     * Get Product value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType|null
     */
    public function getProduct(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType $product
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setProduct(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_DataObjectType $product = null): self
    {
        $this->Product = $product;
        
        return $this;
    }
    /**
     * Get ShipToCustomer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType|null
     */
    public function getShipToCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType
    {
        return $this->ShipToCustomer;
    }
    /**
     * Set ShipToCustomer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType $shipToCustomer
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setShipToCustomer(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_ShipToCustomer_DataObjectType $shipToCustomer = null): self
    {
        $this->ShipToCustomer = $shipToCustomer;
        
        return $this;
    }
    /**
     * Get SoldToCustomer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType|null
     */
    public function getSoldToCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType
    {
        return $this->SoldToCustomer;
    }
    /**
     * Set SoldToCustomer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType $soldToCustomer
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setSoldToCustomer(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_SoldToCustomer_DataObjectType $soldToCustomer = null): self
    {
        $this->SoldToCustomer = $soldToCustomer;
        
        return $this;
    }
    /**
     * Get Shipping_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType|null
     */
    public function getShipping_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType
    {
        return $this->Shipping_Address;
    }
    /**
     * Set Shipping_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType $shipping_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setShipping_Address(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_DataObjectType $shipping_Address = null): self
    {
        $this->Shipping_Address = $shipping_Address;
        
        return $this;
    }
    /**
     * Get Shipping_Address_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType|null
     */
    public function getShipping_Address_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
    {
        return $this->Shipping_Address_Type;
    }
    /**
     * Set Shipping_Address_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType $shipping_Address_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setShipping_Address_Type(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType $shipping_Address_Type = null): self
    {
        $this->Shipping_Address_Type = $shipping_Address_Type;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Additional value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType|null
     */
    public function getInvoice_Detail_Additional(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType
    {
        return $this->Invoice_Detail_Additional;
    }
    /**
     * Set Invoice_Detail_Additional value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_Additional(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Additional_DataObjectType $invoice_Detail_Additional = null): self
    {
        $this->Invoice_Detail_Additional = $invoice_Detail_Additional;
        
        return $this;
    }
    /**
     * Get Package_Component value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType|null
     */
    public function getPackage_Component(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType
    {
        return $this->Package_Component;
    }
    /**
     * Set Package_Component value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType $package_Component
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setPackage_Component(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Package_Component_DataObjectType $package_Component = null): self
    {
        $this->Package_Component = $package_Component;
        
        return $this;
    }
    /**
     * Get Bundle_Component value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType|null
     */
    public function getBundle_Component(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
    {
        return $this->Bundle_Component;
    }
    /**
     * Set Bundle_Component value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType $bundle_Component
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setBundle_Component(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType $bundle_Component = null): self
    {
        $this->Bundle_Component = $bundle_Component;
        
        return $this;
    }
    /**
     * Get Product_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType|null
     */
    public function getProduct_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
    {
        return $this->Product_Type;
    }
    /**
     * Set Product_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType $product_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setProduct_Type(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType $product_Type = null): self
    {
        $this->Product_Type = $product_Type;
        
        return $this;
    }
    /**
     * Get Discount_Product_X_Product value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType|null
     */
    public function getDiscount_Product_X_Product(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
    {
        return $this->Discount_Product_X_Product;
    }
    /**
     * Set Discount_Product_X_Product value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType $discount_Product_X_Product
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setDiscount_Product_X_Product(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType $discount_Product_X_Product = null): self
    {
        $this->Discount_Product_X_Product = $discount_Product_X_Product;
        
        return $this;
    }
    /**
     * Get Billing_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType|null
     */
    public function getBilling_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType
    {
        return $this->Billing_Address;
    }
    /**
     * Set Billing_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType $billing_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setBilling_Address(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Billing_Address_DataObjectType $billing_Address = null): self
    {
        $this->Billing_Address = $billing_Address;
        
        return $this;
    }
    /**
     * Get Currency value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType|null
     */
    public function getCurrency(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType $currency
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setCurrency(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Currency_DataObjectType $currency = null): self
    {
        $this->Currency = $currency;
        
        return $this;
    }
    /**
     * Get Order_Detail_Schedule value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType|null
     */
    public function getOrder_Detail_Schedule(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
    {
        return $this->Order_Detail_Schedule;
    }
    /**
     * Set Order_Detail_Schedule value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType $order_Detail_Schedule
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setOrder_Detail_Schedule(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType $order_Detail_Schedule = null): self
    {
        $this->Order_Detail_Schedule = $order_Detail_Schedule;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_IP_Range value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType|null
     */
    public function getInvoice_Detail_IP_Range(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
    {
        return $this->Invoice_Detail_IP_Range;
    }
    /**
     * Set Invoice_Detail_IP_Range value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType $invoice_Detail_IP_Range
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_IP_Range(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType $invoice_Detail_IP_Range = null): self
    {
        $this->Invoice_Detail_IP_Range = $invoice_Detail_IP_Range;
        
        return $this;
    }
    /**
     * Get Product_Type_Social_Messages value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType|null
     */
    public function getProduct_Type_Social_Messages(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
    {
        return $this->Product_Type_Social_Messages;
    }
    /**
     * Set Product_Type_Social_Messages value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType $product_Type_Social_Messages
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setProduct_Type_Social_Messages(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType $product_Type_Social_Messages = null): self
    {
        $this->Product_Type_Social_Messages = $product_Type_Social_Messages;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Liability value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType|null
     */
    public function getInvoice_Detail_Liability(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
    {
        return $this->Invoice_Detail_Liability;
    }
    /**
     * Set Invoice_Detail_Liability value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType $invoice_Detail_Liability
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_Liability(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType $invoice_Detail_Liability = null): self
    {
        $this->Invoice_Detail_Liability = $invoice_Detail_Liability;
        
        return $this;
    }
    /**
     * Get Credit_Detail value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType|null
     */
    public function getCredit_Detail(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
    {
        return $this->Credit_Detail;
    }
    /**
     * Set Credit_Detail value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType $credit_Detail
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setCredit_Detail(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType $credit_Detail = null): self
    {
        $this->Credit_Detail = $credit_Detail;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Amount_Due value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType|null
     */
    public function getInvoice_Detail_Amount_Due(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
    {
        return $this->Invoice_Detail_Amount_Due;
    }
    /**
     * Set Invoice_Detail_Amount_Due value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType $invoice_Detail_Amount_Due
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_Amount_Due(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType $invoice_Detail_Amount_Due = null): self
    {
        $this->Invoice_Detail_Amount_Due = $invoice_Detail_Amount_Due;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Get_Balance value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType|null
     */
    public function getInvoice_Detail_Get_Balance(): ?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
    {
        return $this->Invoice_Detail_Get_Balance;
    }
    /**
     * Set Invoice_Detail_Get_Balance value
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType $invoice_Detail_Get_Balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_Get_Balance(?\Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType $invoice_Detail_Get_Balance = null): self
    {
        $this->Invoice_Detail_Get_Balance = $invoice_Detail_Get_Balance;
        
        return $this;
    }
    /**
     * Get Additional_Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    public function getAdditional_Invoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType
    {
        return $this->Additional_Invoice_DetailCollection;
    }
    /**
     * Set Additional_Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setAdditional_Invoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null): self
    {
        $this->Additional_Invoice_DetailCollection = $additional_Invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_AdditionalCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType|null
     */
    public function getInvoice_Detail_AdditionalCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType
    {
        return $this->Invoice_Detail_AdditionalCollection;
    }
    /**
     * Set Invoice_Detail_AdditionalCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType $invoice_Detail_AdditionalCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_AdditionalCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_AdditionalCollectionType $invoice_Detail_AdditionalCollection = null): self
    {
        $this->Invoice_Detail_AdditionalCollection = $invoice_Detail_AdditionalCollection;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_LiabilityCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType|null
     */
    public function getInvoice_Detail_LiabilityCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType
    {
        return $this->Invoice_Detail_LiabilityCollection;
    }
    /**
     * Set Invoice_Detail_LiabilityCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType $invoice_Detail_LiabilityCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setInvoice_Detail_LiabilityCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Detail_LiabilityCollectionType $invoice_Detail_LiabilityCollection = null): self
    {
        $this->Invoice_Detail_LiabilityCollection = $invoice_Detail_LiabilityCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
