<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Credit_Detail_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Credit_Detail_DataObjectType extends AbstractStructBase
{
    /**
     * The cdd_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_key = null;
    /**
     * The cdd_cdt_key
     * Meta information extracted from the WSDL
     * - documentation: Credit Header Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_cdt_key = null;
    /**
     * The cdd_type
     * Meta information extracted from the WSDL
     * - documentation: credit type.This element has a default value of 'create credit'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_type = null;
    /**
     * The cdd_amount
     * Meta information extracted from the WSDL
     * - documentation: Credit Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cdd_amount = null;
    /**
     * The cdd_gla_dr_key
     * Meta information extracted from the WSDL
     * - documentation: Cash/Return Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_gla_dr_key = null;
    /**
     * The cdd_gla_cr_key
     * Meta information extracted from the WSDL
     * - documentation: Liability/Expense Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_gla_cr_key = null;
    /**
     * The cdd_ret_key
     * Meta information extracted from the WSDL
     * - documentation: Return Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_ret_key = null;
    /**
     * The cdd_ret_ivd_prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Return Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_ret_ivd_prc_prd_key = null;
    /**
     * The cdd_ajd_key
     * Meta information extracted from the WSDL
     * - documentation: Adjustment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_ajd_key = null;
    /**
     * The cdd_closed_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_closed_flag = null;
    /**
     * The cdd_void_date
     * Meta information extracted from the WSDL
     * - documentation: Void Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_void_date = null;
    /**
     * The cdd_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_void_flag = null;
    /**
     * The cdd_void_user
     * Meta information extracted from the WSDL
     * - documentation: Void User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_void_user = null;
    /**
     * The cdd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_add_user = null;
    /**
     * The cdd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_add_date = null;
    /**
     * The cdd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_change_user = null;
    /**
     * The cdd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_change_date = null;
    /**
     * The cdd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_delete_flag = null;
    /**
     * The cdd_from_date
     * Meta information extracted from the WSDL
     * - documentation: Active From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_from_date = null;
    /**
     * The cdd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Suggested Usage Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_ptp_key = null;
    /**
     * The cdd_through_date
     * Meta information extracted from the WSDL
     * - documentation: Active Through. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_through_date = null;
    /**
     * The cdd_pin_key
     * Meta information extracted from the WSDL
     * - documentation: Payment Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_pin_key = null;
    /**
     * The cdd_required_usage_flag
     * Meta information extracted from the WSDL
     * - documentation: Required Usage Flag.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_required_usage_flag = null;
    /**
     * The cdd_ret_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Return Item. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_ret_ivd_key = null;
    /**
     * The cdd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_entity_key = null;
    /**
     * The cdd_auto_apply
     * Meta information extracted from the WSDL
     * - documentation: Automatically Apply. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_auto_apply = null;
    /**
     * The cdd_prg_key
     * Meta information extracted from the WSDL
     * - documentation: Split Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_prg_key = null;
    /**
     * The cdd_mct_key
     * Meta information extracted from the WSDL
     * - documentation: Credit conversion previous multicurrency record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cdd_mct_key = null;
    /**
     * The cdd_distributed_liability_flag
     * Meta information extracted from the WSDL
     * - documentation: Distributed Liability Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cdd_distributed_liability_flag = null;
    /**
     * Constructor method for InvoiceDetail_Credit_Detail_DataObjectType
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_cdt_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_type()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_amount()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_gla_dr_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_gla_cr_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_ret_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_ret_ivd_prc_prd_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_ajd_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_closed_flag()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_void_date()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_void_flag()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_void_user()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_add_user()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_add_date()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_change_user()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_change_date()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_delete_flag()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_from_date()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_ptp_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_through_date()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_pin_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_required_usage_flag()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_ret_ivd_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_entity_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_auto_apply()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_prg_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_mct_key()
     * @uses InvoiceDetail_Credit_Detail_DataObjectType::setCdd_distributed_liability_flag()
     * @param string $cdd_key
     * @param string $cdd_cdt_key
     * @param string $cdd_type
     * @param float $cdd_amount
     * @param string $cdd_gla_dr_key
     * @param string $cdd_gla_cr_key
     * @param string $cdd_ret_key
     * @param string $cdd_ret_ivd_prc_prd_key
     * @param string $cdd_ajd_key
     * @param string $cdd_closed_flag
     * @param string $cdd_void_date
     * @param string $cdd_void_flag
     * @param string $cdd_void_user
     * @param string $cdd_add_user
     * @param string $cdd_add_date
     * @param string $cdd_change_user
     * @param string $cdd_change_date
     * @param string $cdd_delete_flag
     * @param string $cdd_from_date
     * @param string $cdd_ptp_key
     * @param string $cdd_through_date
     * @param string $cdd_pin_key
     * @param string $cdd_required_usage_flag
     * @param string $cdd_ret_ivd_key
     * @param string $cdd_entity_key
     * @param string $cdd_auto_apply
     * @param string $cdd_prg_key
     * @param string $cdd_mct_key
     * @param string $cdd_distributed_liability_flag
     */
    public function __construct(?string $cdd_key = null, ?string $cdd_cdt_key = null, ?string $cdd_type = null, ?float $cdd_amount = null, ?string $cdd_gla_dr_key = null, ?string $cdd_gla_cr_key = null, ?string $cdd_ret_key = null, ?string $cdd_ret_ivd_prc_prd_key = null, ?string $cdd_ajd_key = null, ?string $cdd_closed_flag = null, ?string $cdd_void_date = null, ?string $cdd_void_flag = null, ?string $cdd_void_user = null, ?string $cdd_add_user = null, ?string $cdd_add_date = null, ?string $cdd_change_user = null, ?string $cdd_change_date = null, ?string $cdd_delete_flag = null, ?string $cdd_from_date = null, ?string $cdd_ptp_key = null, ?string $cdd_through_date = null, ?string $cdd_pin_key = null, ?string $cdd_required_usage_flag = null, ?string $cdd_ret_ivd_key = null, ?string $cdd_entity_key = null, ?string $cdd_auto_apply = null, ?string $cdd_prg_key = null, ?string $cdd_mct_key = null, ?string $cdd_distributed_liability_flag = null)
    {
        $this
            ->setCdd_key($cdd_key)
            ->setCdd_cdt_key($cdd_cdt_key)
            ->setCdd_type($cdd_type)
            ->setCdd_amount($cdd_amount)
            ->setCdd_gla_dr_key($cdd_gla_dr_key)
            ->setCdd_gla_cr_key($cdd_gla_cr_key)
            ->setCdd_ret_key($cdd_ret_key)
            ->setCdd_ret_ivd_prc_prd_key($cdd_ret_ivd_prc_prd_key)
            ->setCdd_ajd_key($cdd_ajd_key)
            ->setCdd_closed_flag($cdd_closed_flag)
            ->setCdd_void_date($cdd_void_date)
            ->setCdd_void_flag($cdd_void_flag)
            ->setCdd_void_user($cdd_void_user)
            ->setCdd_add_user($cdd_add_user)
            ->setCdd_add_date($cdd_add_date)
            ->setCdd_change_user($cdd_change_user)
            ->setCdd_change_date($cdd_change_date)
            ->setCdd_delete_flag($cdd_delete_flag)
            ->setCdd_from_date($cdd_from_date)
            ->setCdd_ptp_key($cdd_ptp_key)
            ->setCdd_through_date($cdd_through_date)
            ->setCdd_pin_key($cdd_pin_key)
            ->setCdd_required_usage_flag($cdd_required_usage_flag)
            ->setCdd_ret_ivd_key($cdd_ret_ivd_key)
            ->setCdd_entity_key($cdd_entity_key)
            ->setCdd_auto_apply($cdd_auto_apply)
            ->setCdd_prg_key($cdd_prg_key)
            ->setCdd_mct_key($cdd_mct_key)
            ->setCdd_distributed_liability_flag($cdd_distributed_liability_flag);
    }
    /**
     * Get cdd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_key(): ?string
    {
        return $this->cdd_key ?? null;
    }
    /**
     * Set cdd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_key(?string $cdd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_key) && !is_string($cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_key, true), gettype($cdd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_key, true)), __LINE__);
        }
        if (is_null($cdd_key) || (is_array($cdd_key) && empty($cdd_key))) {
            unset($this->cdd_key);
        } else {
            $this->cdd_key = $cdd_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_cdt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_cdt_key(): ?string
    {
        return $this->cdd_cdt_key ?? null;
    }
    /**
     * Set cdd_cdt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_cdt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_cdt_key(?string $cdd_cdt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_cdt_key) && !is_string($cdd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_cdt_key, true), gettype($cdd_cdt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_cdt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_cdt_key, true)), __LINE__);
        }
        if (is_null($cdd_cdt_key) || (is_array($cdd_cdt_key) && empty($cdd_cdt_key))) {
            unset($this->cdd_cdt_key);
        } else {
            $this->cdd_cdt_key = $cdd_cdt_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_type(): ?string
    {
        return $this->cdd_type ?? null;
    }
    /**
     * Set cdd_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_type(?string $cdd_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_type) && !is_string($cdd_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_type, true), gettype($cdd_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cdd_type) && mb_strlen((string) $cdd_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cdd_type)), __LINE__);
        }
        if (is_null($cdd_type) || (is_array($cdd_type) && empty($cdd_type))) {
            unset($this->cdd_type);
        } else {
            $this->cdd_type = $cdd_type;
        }
        
        return $this;
    }
    /**
     * Get cdd_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCdd_amount(): ?float
    {
        return $this->cdd_amount ?? null;
    }
    /**
     * Set cdd_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cdd_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_amount(?float $cdd_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($cdd_amount) && !(is_float($cdd_amount) || is_numeric($cdd_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cdd_amount, true), gettype($cdd_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cdd_amount) && mb_strlen(mb_substr((string) $cdd_amount, false !== mb_strpos((string) $cdd_amount, '.') ? mb_strpos((string) $cdd_amount, '.') + 1 : mb_strlen((string) $cdd_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cdd_amount, true), mb_strlen(mb_substr((string) $cdd_amount, mb_strpos((string) $cdd_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cdd_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $cdd_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cdd_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cdd_amount))), __LINE__);
        }
        if (is_null($cdd_amount) || (is_array($cdd_amount) && empty($cdd_amount))) {
            unset($this->cdd_amount);
        } else {
            $this->cdd_amount = $cdd_amount;
        }
        
        return $this;
    }
    /**
     * Get cdd_gla_dr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_gla_dr_key(): ?string
    {
        return $this->cdd_gla_dr_key ?? null;
    }
    /**
     * Set cdd_gla_dr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_gla_dr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_gla_dr_key(?string $cdd_gla_dr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_gla_dr_key) && !is_string($cdd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_gla_dr_key, true), gettype($cdd_gla_dr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_gla_dr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_gla_dr_key, true)), __LINE__);
        }
        if (is_null($cdd_gla_dr_key) || (is_array($cdd_gla_dr_key) && empty($cdd_gla_dr_key))) {
            unset($this->cdd_gla_dr_key);
        } else {
            $this->cdd_gla_dr_key = $cdd_gla_dr_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_gla_cr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_gla_cr_key(): ?string
    {
        return $this->cdd_gla_cr_key ?? null;
    }
    /**
     * Set cdd_gla_cr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_gla_cr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_gla_cr_key(?string $cdd_gla_cr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_gla_cr_key) && !is_string($cdd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_gla_cr_key, true), gettype($cdd_gla_cr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_gla_cr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_gla_cr_key, true)), __LINE__);
        }
        if (is_null($cdd_gla_cr_key) || (is_array($cdd_gla_cr_key) && empty($cdd_gla_cr_key))) {
            unset($this->cdd_gla_cr_key);
        } else {
            $this->cdd_gla_cr_key = $cdd_gla_cr_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_ret_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_ret_key(): ?string
    {
        return $this->cdd_ret_key ?? null;
    }
    /**
     * Set cdd_ret_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_ret_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_ret_key(?string $cdd_ret_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_ret_key) && !is_string($cdd_ret_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_ret_key, true), gettype($cdd_ret_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_ret_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_ret_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_ret_key, true)), __LINE__);
        }
        if (is_null($cdd_ret_key) || (is_array($cdd_ret_key) && empty($cdd_ret_key))) {
            unset($this->cdd_ret_key);
        } else {
            $this->cdd_ret_key = $cdd_ret_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_ret_ivd_prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_ret_ivd_prc_prd_key(): ?string
    {
        return $this->cdd_ret_ivd_prc_prd_key ?? null;
    }
    /**
     * Set cdd_ret_ivd_prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_ret_ivd_prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_ret_ivd_prc_prd_key(?string $cdd_ret_ivd_prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_ret_ivd_prc_prd_key) && !is_string($cdd_ret_ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_ret_ivd_prc_prd_key, true), gettype($cdd_ret_ivd_prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_ret_ivd_prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_ret_ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_ret_ivd_prc_prd_key, true)), __LINE__);
        }
        if (is_null($cdd_ret_ivd_prc_prd_key) || (is_array($cdd_ret_ivd_prc_prd_key) && empty($cdd_ret_ivd_prc_prd_key))) {
            unset($this->cdd_ret_ivd_prc_prd_key);
        } else {
            $this->cdd_ret_ivd_prc_prd_key = $cdd_ret_ivd_prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_ajd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_ajd_key(): ?string
    {
        return $this->cdd_ajd_key ?? null;
    }
    /**
     * Set cdd_ajd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_ajd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_ajd_key(?string $cdd_ajd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_ajd_key) && !is_string($cdd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_ajd_key, true), gettype($cdd_ajd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_ajd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_ajd_key, true)), __LINE__);
        }
        if (is_null($cdd_ajd_key) || (is_array($cdd_ajd_key) && empty($cdd_ajd_key))) {
            unset($this->cdd_ajd_key);
        } else {
            $this->cdd_ajd_key = $cdd_ajd_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_closed_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_closed_flag(): ?string
    {
        return $this->cdd_closed_flag ?? null;
    }
    /**
     * Set cdd_closed_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_closed_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_closed_flag(?string $cdd_closed_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_closed_flag) && !is_string($cdd_closed_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_closed_flag, true), gettype($cdd_closed_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_closed_flag) && $cdd_closed_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_closed_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_closed_flag) && $cdd_closed_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_closed_flag, true)), __LINE__);
        }
        if (is_null($cdd_closed_flag) || (is_array($cdd_closed_flag) && empty($cdd_closed_flag))) {
            unset($this->cdd_closed_flag);
        } else {
            $this->cdd_closed_flag = $cdd_closed_flag;
        }
        
        return $this;
    }
    /**
     * Get cdd_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_void_date(): ?string
    {
        return $this->cdd_void_date ?? null;
    }
    /**
     * Set cdd_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_void_date(?string $cdd_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_void_date) && !is_string($cdd_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_void_date, true), gettype($cdd_void_date)), __LINE__);
        }
        if (is_null($cdd_void_date) || (is_array($cdd_void_date) && empty($cdd_void_date))) {
            unset($this->cdd_void_date);
        } else {
            $this->cdd_void_date = $cdd_void_date;
        }
        
        return $this;
    }
    /**
     * Get cdd_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_void_flag(): ?string
    {
        return $this->cdd_void_flag ?? null;
    }
    /**
     * Set cdd_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_void_flag(?string $cdd_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_void_flag) && !is_string($cdd_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_void_flag, true), gettype($cdd_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_void_flag) && $cdd_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_void_flag) && $cdd_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_void_flag, true)), __LINE__);
        }
        if (is_null($cdd_void_flag) || (is_array($cdd_void_flag) && empty($cdd_void_flag))) {
            unset($this->cdd_void_flag);
        } else {
            $this->cdd_void_flag = $cdd_void_flag;
        }
        
        return $this;
    }
    /**
     * Get cdd_void_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_void_user(): ?string
    {
        return $this->cdd_void_user ?? null;
    }
    /**
     * Set cdd_void_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_void_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_void_user(?string $cdd_void_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_void_user) && !is_string($cdd_void_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_void_user, true), gettype($cdd_void_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cdd_void_user) && mb_strlen((string) $cdd_void_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cdd_void_user)), __LINE__);
        }
        if (is_null($cdd_void_user) || (is_array($cdd_void_user) && empty($cdd_void_user))) {
            unset($this->cdd_void_user);
        } else {
            $this->cdd_void_user = $cdd_void_user;
        }
        
        return $this;
    }
    /**
     * Get cdd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_add_user(): ?string
    {
        return $this->cdd_add_user ?? null;
    }
    /**
     * Set cdd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_add_user(?string $cdd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_add_user) && !is_string($cdd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_add_user, true), gettype($cdd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cdd_add_user) && mb_strlen((string) $cdd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cdd_add_user)), __LINE__);
        }
        if (is_null($cdd_add_user) || (is_array($cdd_add_user) && empty($cdd_add_user))) {
            unset($this->cdd_add_user);
        } else {
            $this->cdd_add_user = $cdd_add_user;
        }
        
        return $this;
    }
    /**
     * Get cdd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_add_date(): ?string
    {
        return $this->cdd_add_date ?? null;
    }
    /**
     * Set cdd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_add_date(?string $cdd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_add_date) && !is_string($cdd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_add_date, true), gettype($cdd_add_date)), __LINE__);
        }
        if (is_null($cdd_add_date) || (is_array($cdd_add_date) && empty($cdd_add_date))) {
            unset($this->cdd_add_date);
        } else {
            $this->cdd_add_date = $cdd_add_date;
        }
        
        return $this;
    }
    /**
     * Get cdd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_change_user(): ?string
    {
        return $this->cdd_change_user ?? null;
    }
    /**
     * Set cdd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_change_user(?string $cdd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_change_user) && !is_string($cdd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_change_user, true), gettype($cdd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cdd_change_user) && mb_strlen((string) $cdd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cdd_change_user)), __LINE__);
        }
        if (is_null($cdd_change_user) || (is_array($cdd_change_user) && empty($cdd_change_user))) {
            unset($this->cdd_change_user);
        } else {
            $this->cdd_change_user = $cdd_change_user;
        }
        
        return $this;
    }
    /**
     * Get cdd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_change_date(): ?string
    {
        return $this->cdd_change_date ?? null;
    }
    /**
     * Set cdd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_change_date(?string $cdd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_change_date) && !is_string($cdd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_change_date, true), gettype($cdd_change_date)), __LINE__);
        }
        if (is_null($cdd_change_date) || (is_array($cdd_change_date) && empty($cdd_change_date))) {
            unset($this->cdd_change_date);
        } else {
            $this->cdd_change_date = $cdd_change_date;
        }
        
        return $this;
    }
    /**
     * Get cdd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_delete_flag(): ?string
    {
        return $this->cdd_delete_flag ?? null;
    }
    /**
     * Set cdd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_delete_flag(?string $cdd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_delete_flag) && !is_string($cdd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_delete_flag, true), gettype($cdd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_delete_flag) && $cdd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_delete_flag) && $cdd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_delete_flag, true)), __LINE__);
        }
        if (is_null($cdd_delete_flag) || (is_array($cdd_delete_flag) && empty($cdd_delete_flag))) {
            unset($this->cdd_delete_flag);
        } else {
            $this->cdd_delete_flag = $cdd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cdd_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_from_date(): ?string
    {
        return $this->cdd_from_date ?? null;
    }
    /**
     * Set cdd_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_from_date(?string $cdd_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_from_date) && !is_string($cdd_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_from_date, true), gettype($cdd_from_date)), __LINE__);
        }
        if (is_null($cdd_from_date) || (is_array($cdd_from_date) && empty($cdd_from_date))) {
            unset($this->cdd_from_date);
        } else {
            $this->cdd_from_date = $cdd_from_date;
        }
        
        return $this;
    }
    /**
     * Get cdd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_ptp_key(): ?string
    {
        return $this->cdd_ptp_key ?? null;
    }
    /**
     * Set cdd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_ptp_key(?string $cdd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_ptp_key) && !is_string($cdd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_ptp_key, true), gettype($cdd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_ptp_key, true)), __LINE__);
        }
        if (is_null($cdd_ptp_key) || (is_array($cdd_ptp_key) && empty($cdd_ptp_key))) {
            unset($this->cdd_ptp_key);
        } else {
            $this->cdd_ptp_key = $cdd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_through_date(): ?string
    {
        return $this->cdd_through_date ?? null;
    }
    /**
     * Set cdd_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_through_date(?string $cdd_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_through_date) && !is_string($cdd_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_through_date, true), gettype($cdd_through_date)), __LINE__);
        }
        if (is_null($cdd_through_date) || (is_array($cdd_through_date) && empty($cdd_through_date))) {
            unset($this->cdd_through_date);
        } else {
            $this->cdd_through_date = $cdd_through_date;
        }
        
        return $this;
    }
    /**
     * Get cdd_pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_pin_key(): ?string
    {
        return $this->cdd_pin_key ?? null;
    }
    /**
     * Set cdd_pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_pin_key(?string $cdd_pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_pin_key) && !is_string($cdd_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_pin_key, true), gettype($cdd_pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_pin_key, true)), __LINE__);
        }
        if (is_null($cdd_pin_key) || (is_array($cdd_pin_key) && empty($cdd_pin_key))) {
            unset($this->cdd_pin_key);
        } else {
            $this->cdd_pin_key = $cdd_pin_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_required_usage_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_required_usage_flag(): ?string
    {
        return $this->cdd_required_usage_flag ?? null;
    }
    /**
     * Set cdd_required_usage_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_required_usage_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_required_usage_flag(?string $cdd_required_usage_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_required_usage_flag) && !is_string($cdd_required_usage_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_required_usage_flag, true), gettype($cdd_required_usage_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_required_usage_flag) && $cdd_required_usage_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_required_usage_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_required_usage_flag) && $cdd_required_usage_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_required_usage_flag, true)), __LINE__);
        }
        if (is_null($cdd_required_usage_flag) || (is_array($cdd_required_usage_flag) && empty($cdd_required_usage_flag))) {
            unset($this->cdd_required_usage_flag);
        } else {
            $this->cdd_required_usage_flag = $cdd_required_usage_flag;
        }
        
        return $this;
    }
    /**
     * Get cdd_ret_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_ret_ivd_key(): ?string
    {
        return $this->cdd_ret_ivd_key ?? null;
    }
    /**
     * Set cdd_ret_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_ret_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_ret_ivd_key(?string $cdd_ret_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_ret_ivd_key) && !is_string($cdd_ret_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_ret_ivd_key, true), gettype($cdd_ret_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_ret_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_ret_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_ret_ivd_key, true)), __LINE__);
        }
        if (is_null($cdd_ret_ivd_key) || (is_array($cdd_ret_ivd_key) && empty($cdd_ret_ivd_key))) {
            unset($this->cdd_ret_ivd_key);
        } else {
            $this->cdd_ret_ivd_key = $cdd_ret_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_entity_key(): ?string
    {
        return $this->cdd_entity_key ?? null;
    }
    /**
     * Set cdd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_entity_key(?string $cdd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_entity_key) && !is_string($cdd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_entity_key, true), gettype($cdd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_entity_key, true)), __LINE__);
        }
        if (is_null($cdd_entity_key) || (is_array($cdd_entity_key) && empty($cdd_entity_key))) {
            unset($this->cdd_entity_key);
        } else {
            $this->cdd_entity_key = $cdd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_auto_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_auto_apply(): ?string
    {
        return $this->cdd_auto_apply ?? null;
    }
    /**
     * Set cdd_auto_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_auto_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_auto_apply(?string $cdd_auto_apply = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_auto_apply) && !is_string($cdd_auto_apply)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_auto_apply, true), gettype($cdd_auto_apply)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_auto_apply) && $cdd_auto_apply > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_auto_apply, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_auto_apply) && $cdd_auto_apply < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_auto_apply, true)), __LINE__);
        }
        if (is_null($cdd_auto_apply) || (is_array($cdd_auto_apply) && empty($cdd_auto_apply))) {
            unset($this->cdd_auto_apply);
        } else {
            $this->cdd_auto_apply = $cdd_auto_apply;
        }
        
        return $this;
    }
    /**
     * Get cdd_prg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_prg_key(): ?string
    {
        return $this->cdd_prg_key ?? null;
    }
    /**
     * Set cdd_prg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_prg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_prg_key(?string $cdd_prg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_prg_key) && !is_string($cdd_prg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_prg_key, true), gettype($cdd_prg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_prg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_prg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_prg_key, true)), __LINE__);
        }
        if (is_null($cdd_prg_key) || (is_array($cdd_prg_key) && empty($cdd_prg_key))) {
            unset($this->cdd_prg_key);
        } else {
            $this->cdd_prg_key = $cdd_prg_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_mct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_mct_key(): ?string
    {
        return $this->cdd_mct_key ?? null;
    }
    /**
     * Set cdd_mct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_mct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_mct_key(?string $cdd_mct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_mct_key) && !is_string($cdd_mct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_mct_key, true), gettype($cdd_mct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cdd_mct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cdd_mct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cdd_mct_key, true)), __LINE__);
        }
        if (is_null($cdd_mct_key) || (is_array($cdd_mct_key) && empty($cdd_mct_key))) {
            unset($this->cdd_mct_key);
        } else {
            $this->cdd_mct_key = $cdd_mct_key;
        }
        
        return $this;
    }
    /**
     * Get cdd_distributed_liability_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCdd_distributed_liability_flag(): ?string
    {
        return $this->cdd_distributed_liability_flag ?? null;
    }
    /**
     * Set cdd_distributed_liability_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cdd_distributed_liability_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Credit_Detail_DataObjectType
     */
    public function setCdd_distributed_liability_flag(?string $cdd_distributed_liability_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cdd_distributed_liability_flag) && !is_string($cdd_distributed_liability_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cdd_distributed_liability_flag, true), gettype($cdd_distributed_liability_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cdd_distributed_liability_flag) && $cdd_distributed_liability_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cdd_distributed_liability_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cdd_distributed_liability_flag) && $cdd_distributed_liability_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cdd_distributed_liability_flag, true)), __LINE__);
        }
        if (is_null($cdd_distributed_liability_flag) || (is_array($cdd_distributed_liability_flag) && empty($cdd_distributed_liability_flag))) {
            unset($this->cdd_distributed_liability_flag);
        } else {
            $this->cdd_distributed_liability_flag = $cdd_distributed_liability_flag;
        }
        
        return $this;
    }
}
