<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Discount_Product_X_Product_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Discount_Product_X_Product_DataObjectType extends AbstractStructBase
{
    /**
     * The dxp_dsc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_dsc_prd_key = null;
    /**
     * The dxp_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_ptp_key = null;
    /**
     * The dxp_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_prd_key = null;
    /**
     * The dxp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dxp_add_user = null;
    /**
     * The dxp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dxp_add_date = null;
    /**
     * The dxp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dxp_change_user = null;
    /**
     * The dxp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dxp_change_date = null;
    /**
     * The dxp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dxp_delete_flag = null;
    /**
     * The dxp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_entity_key = null;
    /**
     * The dxp_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Price Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_prc_key = null;
    /**
     * The dxp_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_key = null;
    /**
     * The dxp_parent_key
     * Meta information extracted from the WSDL
     * - documentation: Usage Parent. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_parent_key = null;
    /**
     * The dxp_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dxp_key_ext = null;
    /**
     * Constructor method for InvoiceDetail_Discount_Product_X_Product_DataObjectType
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_dsc_prd_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_ptp_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_prd_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_add_user()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_add_date()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_change_user()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_change_date()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_delete_flag()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_entity_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_prc_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_parent_key()
     * @uses InvoiceDetail_Discount_Product_X_Product_DataObjectType::setDxp_key_ext()
     * @param string $dxp_dsc_prd_key
     * @param string $dxp_ptp_key
     * @param string $dxp_prd_key
     * @param string $dxp_add_user
     * @param string $dxp_add_date
     * @param string $dxp_change_user
     * @param string $dxp_change_date
     * @param string $dxp_delete_flag
     * @param string $dxp_entity_key
     * @param string $dxp_prc_key
     * @param string $dxp_key
     * @param string $dxp_parent_key
     * @param string $dxp_key_ext
     */
    public function __construct(?string $dxp_dsc_prd_key = null, ?string $dxp_ptp_key = null, ?string $dxp_prd_key = null, ?string $dxp_add_user = null, ?string $dxp_add_date = null, ?string $dxp_change_user = null, ?string $dxp_change_date = null, ?string $dxp_delete_flag = null, ?string $dxp_entity_key = null, ?string $dxp_prc_key = null, ?string $dxp_key = null, ?string $dxp_parent_key = null, ?string $dxp_key_ext = null)
    {
        $this
            ->setDxp_dsc_prd_key($dxp_dsc_prd_key)
            ->setDxp_ptp_key($dxp_ptp_key)
            ->setDxp_prd_key($dxp_prd_key)
            ->setDxp_add_user($dxp_add_user)
            ->setDxp_add_date($dxp_add_date)
            ->setDxp_change_user($dxp_change_user)
            ->setDxp_change_date($dxp_change_date)
            ->setDxp_delete_flag($dxp_delete_flag)
            ->setDxp_entity_key($dxp_entity_key)
            ->setDxp_prc_key($dxp_prc_key)
            ->setDxp_key($dxp_key)
            ->setDxp_parent_key($dxp_parent_key)
            ->setDxp_key_ext($dxp_key_ext);
    }
    /**
     * Get dxp_dsc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_dsc_prd_key(): ?string
    {
        return $this->dxp_dsc_prd_key ?? null;
    }
    /**
     * Set dxp_dsc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_dsc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_dsc_prd_key(?string $dxp_dsc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_dsc_prd_key) && !is_string($dxp_dsc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_dsc_prd_key, true), gettype($dxp_dsc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_dsc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_dsc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_dsc_prd_key, true)), __LINE__);
        }
        if (is_null($dxp_dsc_prd_key) || (is_array($dxp_dsc_prd_key) && empty($dxp_dsc_prd_key))) {
            unset($this->dxp_dsc_prd_key);
        } else {
            $this->dxp_dsc_prd_key = $dxp_dsc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_ptp_key(): ?string
    {
        return $this->dxp_ptp_key ?? null;
    }
    /**
     * Set dxp_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_ptp_key(?string $dxp_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_ptp_key) && !is_string($dxp_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_ptp_key, true), gettype($dxp_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_ptp_key, true)), __LINE__);
        }
        if (is_null($dxp_ptp_key) || (is_array($dxp_ptp_key) && empty($dxp_ptp_key))) {
            unset($this->dxp_ptp_key);
        } else {
            $this->dxp_ptp_key = $dxp_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_prd_key(): ?string
    {
        return $this->dxp_prd_key ?? null;
    }
    /**
     * Set dxp_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_prd_key(?string $dxp_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_prd_key) && !is_string($dxp_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_prd_key, true), gettype($dxp_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_prd_key, true)), __LINE__);
        }
        if (is_null($dxp_prd_key) || (is_array($dxp_prd_key) && empty($dxp_prd_key))) {
            unset($this->dxp_prd_key);
        } else {
            $this->dxp_prd_key = $dxp_prd_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_add_user(): ?string
    {
        return $this->dxp_add_user ?? null;
    }
    /**
     * Set dxp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_add_user(?string $dxp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_add_user) && !is_string($dxp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_add_user, true), gettype($dxp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dxp_add_user) && mb_strlen((string) $dxp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dxp_add_user)), __LINE__);
        }
        if (is_null($dxp_add_user) || (is_array($dxp_add_user) && empty($dxp_add_user))) {
            unset($this->dxp_add_user);
        } else {
            $this->dxp_add_user = $dxp_add_user;
        }
        
        return $this;
    }
    /**
     * Get dxp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_add_date(): ?string
    {
        return $this->dxp_add_date ?? null;
    }
    /**
     * Set dxp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_add_date(?string $dxp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_add_date) && !is_string($dxp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_add_date, true), gettype($dxp_add_date)), __LINE__);
        }
        if (is_null($dxp_add_date) || (is_array($dxp_add_date) && empty($dxp_add_date))) {
            unset($this->dxp_add_date);
        } else {
            $this->dxp_add_date = $dxp_add_date;
        }
        
        return $this;
    }
    /**
     * Get dxp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_change_user(): ?string
    {
        return $this->dxp_change_user ?? null;
    }
    /**
     * Set dxp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_change_user(?string $dxp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_change_user) && !is_string($dxp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_change_user, true), gettype($dxp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dxp_change_user) && mb_strlen((string) $dxp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dxp_change_user)), __LINE__);
        }
        if (is_null($dxp_change_user) || (is_array($dxp_change_user) && empty($dxp_change_user))) {
            unset($this->dxp_change_user);
        } else {
            $this->dxp_change_user = $dxp_change_user;
        }
        
        return $this;
    }
    /**
     * Get dxp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_change_date(): ?string
    {
        return $this->dxp_change_date ?? null;
    }
    /**
     * Set dxp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_change_date(?string $dxp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_change_date) && !is_string($dxp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_change_date, true), gettype($dxp_change_date)), __LINE__);
        }
        if (is_null($dxp_change_date) || (is_array($dxp_change_date) && empty($dxp_change_date))) {
            unset($this->dxp_change_date);
        } else {
            $this->dxp_change_date = $dxp_change_date;
        }
        
        return $this;
    }
    /**
     * Get dxp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_delete_flag(): ?string
    {
        return $this->dxp_delete_flag ?? null;
    }
    /**
     * Set dxp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_delete_flag(?string $dxp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_delete_flag) && !is_string($dxp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_delete_flag, true), gettype($dxp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dxp_delete_flag) && $dxp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dxp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dxp_delete_flag) && $dxp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dxp_delete_flag, true)), __LINE__);
        }
        if (is_null($dxp_delete_flag) || (is_array($dxp_delete_flag) && empty($dxp_delete_flag))) {
            unset($this->dxp_delete_flag);
        } else {
            $this->dxp_delete_flag = $dxp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get dxp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_entity_key(): ?string
    {
        return $this->dxp_entity_key ?? null;
    }
    /**
     * Set dxp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_entity_key(?string $dxp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_entity_key) && !is_string($dxp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_entity_key, true), gettype($dxp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_entity_key, true)), __LINE__);
        }
        if (is_null($dxp_entity_key) || (is_array($dxp_entity_key) && empty($dxp_entity_key))) {
            unset($this->dxp_entity_key);
        } else {
            $this->dxp_entity_key = $dxp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_prc_key(): ?string
    {
        return $this->dxp_prc_key ?? null;
    }
    /**
     * Set dxp_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_prc_key(?string $dxp_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_prc_key) && !is_string($dxp_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_prc_key, true), gettype($dxp_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_prc_key, true)), __LINE__);
        }
        if (is_null($dxp_prc_key) || (is_array($dxp_prc_key) && empty($dxp_prc_key))) {
            unset($this->dxp_prc_key);
        } else {
            $this->dxp_prc_key = $dxp_prc_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_key(): ?string
    {
        return $this->dxp_key ?? null;
    }
    /**
     * Set dxp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_key(?string $dxp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_key) && !is_string($dxp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_key, true), gettype($dxp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_key, true)), __LINE__);
        }
        if (is_null($dxp_key) || (is_array($dxp_key) && empty($dxp_key))) {
            unset($this->dxp_key);
        } else {
            $this->dxp_key = $dxp_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_parent_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_parent_key(): ?string
    {
        return $this->dxp_parent_key ?? null;
    }
    /**
     * Set dxp_parent_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_parent_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_parent_key(?string $dxp_parent_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_parent_key) && !is_string($dxp_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_parent_key, true), gettype($dxp_parent_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_parent_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_parent_key, true)), __LINE__);
        }
        if (is_null($dxp_parent_key) || (is_array($dxp_parent_key) && empty($dxp_parent_key))) {
            unset($this->dxp_parent_key);
        } else {
            $this->dxp_parent_key = $dxp_parent_key;
        }
        
        return $this;
    }
    /**
     * Get dxp_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDxp_key_ext(): ?string
    {
        return $this->dxp_key_ext ?? null;
    }
    /**
     * Set dxp_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dxp_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Discount_Product_X_Product_DataObjectType
     */
    public function setDxp_key_ext(?string $dxp_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($dxp_key_ext) && !is_string($dxp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dxp_key_ext, true), gettype($dxp_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dxp_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dxp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dxp_key_ext, true)), __LINE__);
        }
        if (is_null($dxp_key_ext) || (is_array($dxp_key_ext) && empty($dxp_key_ext))) {
            unset($this->dxp_key_ext);
        } else {
            $this->dxp_key_ext = $dxp_key_ext;
        }
        
        return $this;
    }
}
