<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType extends AbstractStructBase
{
    /**
     * The idd_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idd_ivd_key = null;
    /**
     * The idd_ivd_amount_cp
     * Meta information extracted from the WSDL
     * - documentation: Amount cp. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idd_ivd_amount_cp = null;
    /**
     * The idd_ivd_amount_due
     * Meta information extracted from the WSDL
     * - documentation: Amount Due. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idd_ivd_amount_due = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
     * @uses InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType::setIdd_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType::setIdd_ivd_amount_cp()
     * @uses InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType::setIdd_ivd_amount_due()
     * @param string $idd_ivd_key
     * @param float $idd_ivd_amount_cp
     * @param float $idd_ivd_amount_due
     */
    public function __construct(?string $idd_ivd_key = null, ?float $idd_ivd_amount_cp = null, ?float $idd_ivd_amount_due = null)
    {
        $this
            ->setIdd_ivd_key($idd_ivd_key)
            ->setIdd_ivd_amount_cp($idd_ivd_amount_cp)
            ->setIdd_ivd_amount_due($idd_ivd_amount_due);
    }
    /**
     * Get idd_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdd_ivd_key(): ?string
    {
        return $this->idd_ivd_key ?? null;
    }
    /**
     * Set idd_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idd_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
     */
    public function setIdd_ivd_key(?string $idd_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idd_ivd_key) && !is_string($idd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idd_ivd_key, true), gettype($idd_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idd_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idd_ivd_key, true)), __LINE__);
        }
        if (is_null($idd_ivd_key) || (is_array($idd_ivd_key) && empty($idd_ivd_key))) {
            unset($this->idd_ivd_key);
        } else {
            $this->idd_ivd_key = $idd_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get idd_ivd_amount_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdd_ivd_amount_cp(): ?float
    {
        return $this->idd_ivd_amount_cp ?? null;
    }
    /**
     * Set idd_ivd_amount_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idd_ivd_amount_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
     */
    public function setIdd_ivd_amount_cp(?float $idd_ivd_amount_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($idd_ivd_amount_cp) && !(is_float($idd_ivd_amount_cp) || is_numeric($idd_ivd_amount_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idd_ivd_amount_cp, true), gettype($idd_ivd_amount_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idd_ivd_amount_cp) && mb_strlen(mb_substr((string) $idd_ivd_amount_cp, false !== mb_strpos((string) $idd_ivd_amount_cp, '.') ? mb_strpos((string) $idd_ivd_amount_cp, '.') + 1 : mb_strlen((string) $idd_ivd_amount_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idd_ivd_amount_cp, true), mb_strlen(mb_substr((string) $idd_ivd_amount_cp, mb_strpos((string) $idd_ivd_amount_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idd_ivd_amount_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $idd_ivd_amount_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idd_ivd_amount_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idd_ivd_amount_cp))), __LINE__);
        }
        if (is_null($idd_ivd_amount_cp) || (is_array($idd_ivd_amount_cp) && empty($idd_ivd_amount_cp))) {
            unset($this->idd_ivd_amount_cp);
        } else {
            $this->idd_ivd_amount_cp = $idd_ivd_amount_cp;
        }
        
        return $this;
    }
    /**
     * Get idd_ivd_amount_due value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdd_ivd_amount_due(): ?float
    {
        return $this->idd_ivd_amount_due ?? null;
    }
    /**
     * Set idd_ivd_amount_due value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idd_ivd_amount_due
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Amount_Due_DataObjectType
     */
    public function setIdd_ivd_amount_due(?float $idd_ivd_amount_due = null): self
    {
        // validation for constraint: float
        if (!is_null($idd_ivd_amount_due) && !(is_float($idd_ivd_amount_due) || is_numeric($idd_ivd_amount_due))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idd_ivd_amount_due, true), gettype($idd_ivd_amount_due)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idd_ivd_amount_due) && mb_strlen(mb_substr((string) $idd_ivd_amount_due, false !== mb_strpos((string) $idd_ivd_amount_due, '.') ? mb_strpos((string) $idd_ivd_amount_due, '.') + 1 : mb_strlen((string) $idd_ivd_amount_due))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idd_ivd_amount_due, true), mb_strlen(mb_substr((string) $idd_ivd_amount_due, mb_strpos((string) $idd_ivd_amount_due, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idd_ivd_amount_due) && mb_strlen(preg_replace('/(\D)/', '', (string) $idd_ivd_amount_due)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idd_ivd_amount_due, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idd_ivd_amount_due))), __LINE__);
        }
        if (is_null($idd_ivd_amount_due) || (is_array($idd_ivd_amount_due) && empty($idd_ivd_amount_due))) {
            unset($this->idd_ivd_amount_due);
        } else {
            $this->idd_ivd_amount_due = $idd_ivd_amount_due;
        }
        
        return $this;
    }
}
