<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_Detail_Liability_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_Detail_Liability_DataObjectType extends AbstractStructBase
{
    /**
     * The idc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_key = null;
    /**
     * The idc_cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Sort Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_cst_sort_name_dn = null;
    /**
     * The idc_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_cst_key = null;
    /**
     * The idc_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Affiliation Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ixo_key = null;
    /**
     * The idc_ixt_key
     * Meta information extracted from the WSDL
     * - documentation: idc_ixt_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ixt_key = null;
    /**
     * The idc_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ivd_key = null;
    /**
     * The idc_ivd_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ivd_inv_key = null;
    /**
     * The idc_date
     * Meta information extracted from the WSDL
     * - documentation: Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_date = null;
    /**
     * The idc_code
     * Meta information extracted from the WSDL
     * - documentation: Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_code = null;
    /**
     * The idc_price
     * Meta information extracted from the WSDL
     * - documentation: Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_price = null;
    /**
     * The idc_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $idc_qty = null;
    /**
     * The idc_ods_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Schedule Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ods_key = null;
    /**
     * The idc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_add_user = null;
    /**
     * The idc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_add_date = null;
    /**
     * The idc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_change_user = null;
    /**
     * The idc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_change_date = null;
    /**
     * The idc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_delete_flag = null;
    /**
     * The idc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_entity_key = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_cst_sort_name_dn()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_cst_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_ixo_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_ixt_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_ivd_inv_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_date()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_code()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_price()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_qty()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_ods_key()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_add_user()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_add_date()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_change_user()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_change_date()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_delete_flag()
     * @uses InvoiceDetail_Invoice_Detail_Liability_DataObjectType::setIdc_entity_key()
     * @param string $idc_key
     * @param string $idc_cst_sort_name_dn
     * @param string $idc_cst_key
     * @param string $idc_ixo_key
     * @param string $idc_ixt_key
     * @param string $idc_ivd_key
     * @param string $idc_ivd_inv_key
     * @param string $idc_date
     * @param string $idc_code
     * @param float $idc_price
     * @param int $idc_qty
     * @param string $idc_ods_key
     * @param string $idc_add_user
     * @param string $idc_add_date
     * @param string $idc_change_user
     * @param string $idc_change_date
     * @param string $idc_delete_flag
     * @param string $idc_entity_key
     */
    public function __construct(?string $idc_key = null, ?string $idc_cst_sort_name_dn = null, ?string $idc_cst_key = null, ?string $idc_ixo_key = null, ?string $idc_ixt_key = null, ?string $idc_ivd_key = null, ?string $idc_ivd_inv_key = null, ?string $idc_date = null, ?string $idc_code = null, ?float $idc_price = null, ?int $idc_qty = null, ?string $idc_ods_key = null, ?string $idc_add_user = null, ?string $idc_add_date = null, ?string $idc_change_user = null, ?string $idc_change_date = null, ?string $idc_delete_flag = null, ?string $idc_entity_key = null)
    {
        $this
            ->setIdc_key($idc_key)
            ->setIdc_cst_sort_name_dn($idc_cst_sort_name_dn)
            ->setIdc_cst_key($idc_cst_key)
            ->setIdc_ixo_key($idc_ixo_key)
            ->setIdc_ixt_key($idc_ixt_key)
            ->setIdc_ivd_key($idc_ivd_key)
            ->setIdc_ivd_inv_key($idc_ivd_inv_key)
            ->setIdc_date($idc_date)
            ->setIdc_code($idc_code)
            ->setIdc_price($idc_price)
            ->setIdc_qty($idc_qty)
            ->setIdc_ods_key($idc_ods_key)
            ->setIdc_add_user($idc_add_user)
            ->setIdc_add_date($idc_add_date)
            ->setIdc_change_user($idc_change_user)
            ->setIdc_change_date($idc_change_date)
            ->setIdc_delete_flag($idc_delete_flag)
            ->setIdc_entity_key($idc_entity_key);
    }
    /**
     * Get idc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_key(): ?string
    {
        return $this->idc_key ?? null;
    }
    /**
     * Set idc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_key(?string $idc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_key) && !is_string($idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_key, true), gettype($idc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_key, true)), __LINE__);
        }
        if (is_null($idc_key) || (is_array($idc_key) && empty($idc_key))) {
            unset($this->idc_key);
        } else {
            $this->idc_key = $idc_key;
        }
        
        return $this;
    }
    /**
     * Get idc_cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_cst_sort_name_dn(): ?string
    {
        return $this->idc_cst_sort_name_dn ?? null;
    }
    /**
     * Set idc_cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_cst_sort_name_dn(?string $idc_cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_cst_sort_name_dn) && !is_string($idc_cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_cst_sort_name_dn, true), gettype($idc_cst_sort_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($idc_cst_sort_name_dn) && mb_strlen((string) $idc_cst_sort_name_dn) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $idc_cst_sort_name_dn)), __LINE__);
        }
        if (is_null($idc_cst_sort_name_dn) || (is_array($idc_cst_sort_name_dn) && empty($idc_cst_sort_name_dn))) {
            unset($this->idc_cst_sort_name_dn);
        } else {
            $this->idc_cst_sort_name_dn = $idc_cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get idc_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_cst_key(): ?string
    {
        return $this->idc_cst_key ?? null;
    }
    /**
     * Set idc_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_cst_key(?string $idc_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_cst_key) && !is_string($idc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_cst_key, true), gettype($idc_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_cst_key, true)), __LINE__);
        }
        if (is_null($idc_cst_key) || (is_array($idc_cst_key) && empty($idc_cst_key))) {
            unset($this->idc_cst_key);
        } else {
            $this->idc_cst_key = $idc_cst_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ixo_key(): ?string
    {
        return $this->idc_ixo_key ?? null;
    }
    /**
     * Set idc_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ixo_key(?string $idc_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ixo_key) && !is_string($idc_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ixo_key, true), gettype($idc_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ixo_key, true)), __LINE__);
        }
        if (is_null($idc_ixo_key) || (is_array($idc_ixo_key) && empty($idc_ixo_key))) {
            unset($this->idc_ixo_key);
        } else {
            $this->idc_ixo_key = $idc_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ixt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ixt_key(): ?string
    {
        return $this->idc_ixt_key ?? null;
    }
    /**
     * Set idc_ixt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ixt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ixt_key(?string $idc_ixt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ixt_key) && !is_string($idc_ixt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ixt_key, true), gettype($idc_ixt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ixt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ixt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ixt_key, true)), __LINE__);
        }
        if (is_null($idc_ixt_key) || (is_array($idc_ixt_key) && empty($idc_ixt_key))) {
            unset($this->idc_ixt_key);
        } else {
            $this->idc_ixt_key = $idc_ixt_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ivd_key(): ?string
    {
        return $this->idc_ivd_key ?? null;
    }
    /**
     * Set idc_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ivd_key(?string $idc_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ivd_key) && !is_string($idc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ivd_key, true), gettype($idc_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ivd_key, true)), __LINE__);
        }
        if (is_null($idc_ivd_key) || (is_array($idc_ivd_key) && empty($idc_ivd_key))) {
            unset($this->idc_ivd_key);
        } else {
            $this->idc_ivd_key = $idc_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ivd_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ivd_inv_key(): ?string
    {
        return $this->idc_ivd_inv_key ?? null;
    }
    /**
     * Set idc_ivd_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ivd_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ivd_inv_key(?string $idc_ivd_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ivd_inv_key) && !is_string($idc_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ivd_inv_key, true), gettype($idc_ivd_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ivd_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ivd_inv_key, true)), __LINE__);
        }
        if (is_null($idc_ivd_inv_key) || (is_array($idc_ivd_inv_key) && empty($idc_ivd_inv_key))) {
            unset($this->idc_ivd_inv_key);
        } else {
            $this->idc_ivd_inv_key = $idc_ivd_inv_key;
        }
        
        return $this;
    }
    /**
     * Get idc_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_date(): ?string
    {
        return $this->idc_date ?? null;
    }
    /**
     * Set idc_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_date(?string $idc_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_date) && !is_string($idc_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_date, true), gettype($idc_date)), __LINE__);
        }
        if (is_null($idc_date) || (is_array($idc_date) && empty($idc_date))) {
            unset($this->idc_date);
        } else {
            $this->idc_date = $idc_date;
        }
        
        return $this;
    }
    /**
     * Get idc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_code(): ?string
    {
        return $this->idc_code ?? null;
    }
    /**
     * Set idc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_code(?string $idc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_code) && !is_string($idc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_code, true), gettype($idc_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($idc_code) && mb_strlen((string) $idc_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $idc_code)), __LINE__);
        }
        if (is_null($idc_code) || (is_array($idc_code) && empty($idc_code))) {
            unset($this->idc_code);
        } else {
            $this->idc_code = $idc_code;
        }
        
        return $this;
    }
    /**
     * Get idc_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_price(): ?float
    {
        return $this->idc_price ?? null;
    }
    /**
     * Set idc_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_price(?float $idc_price = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_price) && !(is_float($idc_price) || is_numeric($idc_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_price, true), gettype($idc_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_price) && mb_strlen(mb_substr((string) $idc_price, false !== mb_strpos((string) $idc_price, '.') ? mb_strpos((string) $idc_price, '.') + 1 : mb_strlen((string) $idc_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_price, true), mb_strlen(mb_substr((string) $idc_price, mb_strpos((string) $idc_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_price))), __LINE__);
        }
        if (is_null($idc_price) || (is_array($idc_price) && empty($idc_price))) {
            unset($this->idc_price);
        } else {
            $this->idc_price = $idc_price;
        }
        
        return $this;
    }
    /**
     * Get idc_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdc_qty(): ?int
    {
        return $this->idc_qty ?? null;
    }
    /**
     * Set idc_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idc_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_qty(?int $idc_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($idc_qty) && !(is_int($idc_qty) || ctype_digit($idc_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idc_qty, true), gettype($idc_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($idc_qty) && $idc_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($idc_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($idc_qty) && $idc_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($idc_qty, true)), __LINE__);
        }
        if (is_null($idc_qty) || (is_array($idc_qty) && empty($idc_qty))) {
            unset($this->idc_qty);
        } else {
            $this->idc_qty = $idc_qty;
        }
        
        return $this;
    }
    /**
     * Get idc_ods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ods_key(): ?string
    {
        return $this->idc_ods_key ?? null;
    }
    /**
     * Set idc_ods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ods_key(?string $idc_ods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ods_key) && !is_string($idc_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ods_key, true), gettype($idc_ods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ods_key, true)), __LINE__);
        }
        if (is_null($idc_ods_key) || (is_array($idc_ods_key) && empty($idc_ods_key))) {
            unset($this->idc_ods_key);
        } else {
            $this->idc_ods_key = $idc_ods_key;
        }
        
        return $this;
    }
    /**
     * Get idc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_add_user(): ?string
    {
        return $this->idc_add_user ?? null;
    }
    /**
     * Set idc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_add_user(?string $idc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_add_user) && !is_string($idc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_add_user, true), gettype($idc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($idc_add_user) && mb_strlen((string) $idc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $idc_add_user)), __LINE__);
        }
        if (is_null($idc_add_user) || (is_array($idc_add_user) && empty($idc_add_user))) {
            unset($this->idc_add_user);
        } else {
            $this->idc_add_user = $idc_add_user;
        }
        
        return $this;
    }
    /**
     * Get idc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_add_date(): ?string
    {
        return $this->idc_add_date ?? null;
    }
    /**
     * Set idc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_add_date(?string $idc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_add_date) && !is_string($idc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_add_date, true), gettype($idc_add_date)), __LINE__);
        }
        if (is_null($idc_add_date) || (is_array($idc_add_date) && empty($idc_add_date))) {
            unset($this->idc_add_date);
        } else {
            $this->idc_add_date = $idc_add_date;
        }
        
        return $this;
    }
    /**
     * Get idc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_change_user(): ?string
    {
        return $this->idc_change_user ?? null;
    }
    /**
     * Set idc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_change_user(?string $idc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_change_user) && !is_string($idc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_change_user, true), gettype($idc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($idc_change_user) && mb_strlen((string) $idc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $idc_change_user)), __LINE__);
        }
        if (is_null($idc_change_user) || (is_array($idc_change_user) && empty($idc_change_user))) {
            unset($this->idc_change_user);
        } else {
            $this->idc_change_user = $idc_change_user;
        }
        
        return $this;
    }
    /**
     * Get idc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_change_date(): ?string
    {
        return $this->idc_change_date ?? null;
    }
    /**
     * Set idc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_change_date(?string $idc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_change_date) && !is_string($idc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_change_date, true), gettype($idc_change_date)), __LINE__);
        }
        if (is_null($idc_change_date) || (is_array($idc_change_date) && empty($idc_change_date))) {
            unset($this->idc_change_date);
        } else {
            $this->idc_change_date = $idc_change_date;
        }
        
        return $this;
    }
    /**
     * Get idc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_delete_flag(): ?string
    {
        return $this->idc_delete_flag ?? null;
    }
    /**
     * Set idc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_delete_flag(?string $idc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_delete_flag) && !is_string($idc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_delete_flag, true), gettype($idc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($idc_delete_flag) && $idc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($idc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($idc_delete_flag) && $idc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($idc_delete_flag, true)), __LINE__);
        }
        if (is_null($idc_delete_flag) || (is_array($idc_delete_flag) && empty($idc_delete_flag))) {
            unset($this->idc_delete_flag);
        } else {
            $this->idc_delete_flag = $idc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get idc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_entity_key(): ?string
    {
        return $this->idc_entity_key ?? null;
    }
    /**
     * Set idc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_entity_key(?string $idc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_entity_key) && !is_string($idc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_entity_key, true), gettype($idc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_entity_key, true)), __LINE__);
        }
        if (is_null($idc_entity_key) || (is_array($idc_entity_key) && empty($idc_entity_key))) {
            unset($this->idc_entity_key);
        } else {
            $this->idc_entity_key = $idc_entity_key;
        }
        
        return $this;
    }
}
