<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Shipping_Address_Type_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Shipping_Address_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The adt_code
     * Meta information extracted from the WSDL
     * - documentation: Address Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_code = null;
    /**
     * The adt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_add_user = null;
    /**
     * The adt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_add_date = null;
    /**
     * The adt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_change_date = null;
    /**
     * The adt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_change_user = null;
    /**
     * The adt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adt_delete_flag = null;
    /**
     * The adt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adt_key = null;
    /**
     * The adt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adt_key_ext = null;
    /**
     * The adt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adt_entity_key = null;
    /**
     * Constructor method for InvoiceDetail_Shipping_Address_Type_DataObjectType
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_code()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_add_user()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_add_date()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_change_date()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_change_user()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_delete_flag()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_key()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_key_ext()
     * @uses InvoiceDetail_Shipping_Address_Type_DataObjectType::setAdt_entity_key()
     * @param string $adt_code
     * @param string $adt_add_user
     * @param string $adt_add_date
     * @param string $adt_change_date
     * @param string $adt_change_user
     * @param string $adt_delete_flag
     * @param string $adt_key
     * @param string $adt_key_ext
     * @param string $adt_entity_key
     */
    public function __construct(?string $adt_code = null, ?string $adt_add_user = null, ?string $adt_add_date = null, ?string $adt_change_date = null, ?string $adt_change_user = null, ?string $adt_delete_flag = null, ?string $adt_key = null, ?string $adt_key_ext = null, ?string $adt_entity_key = null)
    {
        $this
            ->setAdt_code($adt_code)
            ->setAdt_add_user($adt_add_user)
            ->setAdt_add_date($adt_add_date)
            ->setAdt_change_date($adt_change_date)
            ->setAdt_change_user($adt_change_user)
            ->setAdt_delete_flag($adt_delete_flag)
            ->setAdt_key($adt_key)
            ->setAdt_key_ext($adt_key_ext)
            ->setAdt_entity_key($adt_entity_key);
    }
    /**
     * Get adt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_code(): ?string
    {
        return $this->adt_code ?? null;
    }
    /**
     * Set adt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_code(?string $adt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_code) && !is_string($adt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_code, true), gettype($adt_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($adt_code) && mb_strlen((string) $adt_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $adt_code)), __LINE__);
        }
        if (is_null($adt_code) || (is_array($adt_code) && empty($adt_code))) {
            unset($this->adt_code);
        } else {
            $this->adt_code = $adt_code;
        }
        
        return $this;
    }
    /**
     * Get adt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_add_user(): ?string
    {
        return $this->adt_add_user ?? null;
    }
    /**
     * Set adt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_add_user(?string $adt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_add_user) && !is_string($adt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_add_user, true), gettype($adt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($adt_add_user) && mb_strlen((string) $adt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $adt_add_user)), __LINE__);
        }
        if (is_null($adt_add_user) || (is_array($adt_add_user) && empty($adt_add_user))) {
            unset($this->adt_add_user);
        } else {
            $this->adt_add_user = $adt_add_user;
        }
        
        return $this;
    }
    /**
     * Get adt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_add_date(): ?string
    {
        return $this->adt_add_date ?? null;
    }
    /**
     * Set adt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_add_date(?string $adt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_add_date) && !is_string($adt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_add_date, true), gettype($adt_add_date)), __LINE__);
        }
        if (is_null($adt_add_date) || (is_array($adt_add_date) && empty($adt_add_date))) {
            unset($this->adt_add_date);
        } else {
            $this->adt_add_date = $adt_add_date;
        }
        
        return $this;
    }
    /**
     * Get adt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_change_date(): ?string
    {
        return $this->adt_change_date ?? null;
    }
    /**
     * Set adt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_change_date(?string $adt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_change_date) && !is_string($adt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_change_date, true), gettype($adt_change_date)), __LINE__);
        }
        if (is_null($adt_change_date) || (is_array($adt_change_date) && empty($adt_change_date))) {
            unset($this->adt_change_date);
        } else {
            $this->adt_change_date = $adt_change_date;
        }
        
        return $this;
    }
    /**
     * Get adt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_change_user(): ?string
    {
        return $this->adt_change_user ?? null;
    }
    /**
     * Set adt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_change_user(?string $adt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_change_user) && !is_string($adt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_change_user, true), gettype($adt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($adt_change_user) && mb_strlen((string) $adt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $adt_change_user)), __LINE__);
        }
        if (is_null($adt_change_user) || (is_array($adt_change_user) && empty($adt_change_user))) {
            unset($this->adt_change_user);
        } else {
            $this->adt_change_user = $adt_change_user;
        }
        
        return $this;
    }
    /**
     * Get adt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_delete_flag(): ?string
    {
        return $this->adt_delete_flag ?? null;
    }
    /**
     * Set adt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_delete_flag(?string $adt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_delete_flag) && !is_string($adt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_delete_flag, true), gettype($adt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($adt_delete_flag) && $adt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($adt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($adt_delete_flag) && $adt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($adt_delete_flag, true)), __LINE__);
        }
        if (is_null($adt_delete_flag) || (is_array($adt_delete_flag) && empty($adt_delete_flag))) {
            unset($this->adt_delete_flag);
        } else {
            $this->adt_delete_flag = $adt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get adt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_key(): ?string
    {
        return $this->adt_key ?? null;
    }
    /**
     * Set adt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_key(?string $adt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_key) && !is_string($adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_key, true), gettype($adt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adt_key, true)), __LINE__);
        }
        if (is_null($adt_key) || (is_array($adt_key) && empty($adt_key))) {
            unset($this->adt_key);
        } else {
            $this->adt_key = $adt_key;
        }
        
        return $this;
    }
    /**
     * Get adt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_key_ext(): ?string
    {
        return $this->adt_key_ext ?? null;
    }
    /**
     * Set adt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_key_ext(?string $adt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_key_ext) && !is_string($adt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_key_ext, true), gettype($adt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adt_key_ext, true)), __LINE__);
        }
        if (is_null($adt_key_ext) || (is_array($adt_key_ext) && empty($adt_key_ext))) {
            unset($this->adt_key_ext);
        } else {
            $this->adt_key_ext = $adt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get adt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdt_entity_key(): ?string
    {
        return $this->adt_entity_key ?? null;
    }
    /**
     * Set adt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Shipping_Address_Type_DataObjectType
     */
    public function setAdt_entity_key(?string $adt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($adt_entity_key) && !is_string($adt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adt_entity_key, true), gettype($adt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adt_entity_key, true)), __LINE__);
        }
        if (is_null($adt_entity_key) || (is_array($adt_entity_key) && empty($adt_entity_key))) {
            unset($this->adt_entity_key);
        } else {
            $this->adt_entity_key = $adt_entity_key;
        }
        
        return $this;
    }
}
