<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Claim_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Invoice_Claim_DataObjectType extends AbstractStructBase
{
    /**
     * The cld_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_key = null;
    /**
     * The cld_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_add_user = null;
    /**
     * The cld_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_add_date = null;
    /**
     * The cld_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_change_user = null;
    /**
     * The cld_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_change_date = null;
    /**
     * The cld_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_delete_flag = null;
    /**
     * The cld_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_key_ext = null;
    /**
     * The cld_sfl_key
     * Meta information extracted from the WSDL
     * - documentation: subscription ful key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_sfl_key = null;
    /**
     * The cld_ful_key
     * Meta information extracted from the WSDL
     * - documentation: product ful key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_ful_key = null;
    /**
     * The cld_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: invoice detail key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_ivd_key = null;
    /**
     * The cld_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: customer address key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_cxa_key = null;
    /**
     * The cld_inv_code
     * Meta information extracted from the WSDL
     * - documentation: invoice code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_inv_code = null;
    /**
     * The cld_qty
     * Meta information extracted from the WSDL
     * - documentation: quantity claimed. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cld_qty = null;
    /**
     * The cld_ship_qty
     * Meta information extracted from the WSDL
     * - documentation: quantity shipped. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cld_ship_qty = null;
    /**
     * The cld_ship_date
     * Meta information extracted from the WSDL
     * - documentation: date shipped. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_ship_date = null;
    /**
     * The cld_reshipped
     * Meta information extracted from the WSDL
     * - documentation: reshipped. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_reshipped = null;
    /**
     * The cld_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_entity_key = null;
    /**
     * The cld_claim_date
     * Meta information extracted from the WSDL
     * - documentation: Claim Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_claim_date = null;
    /**
     * The cld_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_cst_key = null;
    /**
     * The cld_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_notes = null;
    /**
     * The cld_ivw_key
     * Meta information extracted from the WSDL
     * - documentation: Warehouse. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_ivw_key = null;
    /**
     * The cld_claim_reason
     * Meta information extracted from the WSDL
     * - documentation: Claim Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_claim_reason = null;
    /**
     * The cld_claim_status
     * Meta information extracted from the WSDL
     * - documentation: Claim Status.This element has a default value of 'Approved'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_claim_status = null;
    /**
     * The cld_email_sent
     * Meta information extracted from the WSDL
     * - documentation: Email Sent?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_email_sent = null;
    /**
     * The cld_sui_prd_key
     * Meta information extracted from the WSDL
     * - documentation: subscription issue. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cld_sui_prd_key = null;
    /**
     * The cld_number
     * Meta information extracted from the WSDL
     * - documentation: Claim Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cld_number = null;
    /**
     * The cld_process_qty
     * Meta information extracted from the WSDL
     * - documentation: process qty. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cld_process_qty = null;
    /**
     * The cld_process_date
     * Meta information extracted from the WSDL
     * - documentation: date processed. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cld_process_date = null;
    /**
     * Constructor method for Invoice_Claim_DataObjectType
     * @uses Invoice_Claim_DataObjectType::setCld_key()
     * @uses Invoice_Claim_DataObjectType::setCld_add_user()
     * @uses Invoice_Claim_DataObjectType::setCld_add_date()
     * @uses Invoice_Claim_DataObjectType::setCld_change_user()
     * @uses Invoice_Claim_DataObjectType::setCld_change_date()
     * @uses Invoice_Claim_DataObjectType::setCld_delete_flag()
     * @uses Invoice_Claim_DataObjectType::setCld_key_ext()
     * @uses Invoice_Claim_DataObjectType::setCld_sfl_key()
     * @uses Invoice_Claim_DataObjectType::setCld_ful_key()
     * @uses Invoice_Claim_DataObjectType::setCld_ivd_key()
     * @uses Invoice_Claim_DataObjectType::setCld_cxa_key()
     * @uses Invoice_Claim_DataObjectType::setCld_inv_code()
     * @uses Invoice_Claim_DataObjectType::setCld_qty()
     * @uses Invoice_Claim_DataObjectType::setCld_ship_qty()
     * @uses Invoice_Claim_DataObjectType::setCld_ship_date()
     * @uses Invoice_Claim_DataObjectType::setCld_reshipped()
     * @uses Invoice_Claim_DataObjectType::setCld_entity_key()
     * @uses Invoice_Claim_DataObjectType::setCld_claim_date()
     * @uses Invoice_Claim_DataObjectType::setCld_cst_key()
     * @uses Invoice_Claim_DataObjectType::setCld_notes()
     * @uses Invoice_Claim_DataObjectType::setCld_ivw_key()
     * @uses Invoice_Claim_DataObjectType::setCld_claim_reason()
     * @uses Invoice_Claim_DataObjectType::setCld_claim_status()
     * @uses Invoice_Claim_DataObjectType::setCld_email_sent()
     * @uses Invoice_Claim_DataObjectType::setCld_sui_prd_key()
     * @uses Invoice_Claim_DataObjectType::setCld_number()
     * @uses Invoice_Claim_DataObjectType::setCld_process_qty()
     * @uses Invoice_Claim_DataObjectType::setCld_process_date()
     * @param string $cld_key
     * @param string $cld_add_user
     * @param string $cld_add_date
     * @param string $cld_change_user
     * @param string $cld_change_date
     * @param string $cld_delete_flag
     * @param string $cld_key_ext
     * @param string $cld_sfl_key
     * @param string $cld_ful_key
     * @param string $cld_ivd_key
     * @param string $cld_cxa_key
     * @param string $cld_inv_code
     * @param float $cld_qty
     * @param float $cld_ship_qty
     * @param string $cld_ship_date
     * @param string $cld_reshipped
     * @param string $cld_entity_key
     * @param string $cld_claim_date
     * @param string $cld_cst_key
     * @param string $cld_notes
     * @param string $cld_ivw_key
     * @param string $cld_claim_reason
     * @param string $cld_claim_status
     * @param string $cld_email_sent
     * @param string $cld_sui_prd_key
     * @param int $cld_number
     * @param float $cld_process_qty
     * @param string $cld_process_date
     */
    public function __construct(?string $cld_key = null, ?string $cld_add_user = null, ?string $cld_add_date = null, ?string $cld_change_user = null, ?string $cld_change_date = null, ?string $cld_delete_flag = null, ?string $cld_key_ext = null, ?string $cld_sfl_key = null, ?string $cld_ful_key = null, ?string $cld_ivd_key = null, ?string $cld_cxa_key = null, ?string $cld_inv_code = null, ?float $cld_qty = null, ?float $cld_ship_qty = null, ?string $cld_ship_date = null, ?string $cld_reshipped = null, ?string $cld_entity_key = null, ?string $cld_claim_date = null, ?string $cld_cst_key = null, ?string $cld_notes = null, ?string $cld_ivw_key = null, ?string $cld_claim_reason = null, ?string $cld_claim_status = null, ?string $cld_email_sent = null, ?string $cld_sui_prd_key = null, ?int $cld_number = null, ?float $cld_process_qty = null, ?string $cld_process_date = null)
    {
        $this
            ->setCld_key($cld_key)
            ->setCld_add_user($cld_add_user)
            ->setCld_add_date($cld_add_date)
            ->setCld_change_user($cld_change_user)
            ->setCld_change_date($cld_change_date)
            ->setCld_delete_flag($cld_delete_flag)
            ->setCld_key_ext($cld_key_ext)
            ->setCld_sfl_key($cld_sfl_key)
            ->setCld_ful_key($cld_ful_key)
            ->setCld_ivd_key($cld_ivd_key)
            ->setCld_cxa_key($cld_cxa_key)
            ->setCld_inv_code($cld_inv_code)
            ->setCld_qty($cld_qty)
            ->setCld_ship_qty($cld_ship_qty)
            ->setCld_ship_date($cld_ship_date)
            ->setCld_reshipped($cld_reshipped)
            ->setCld_entity_key($cld_entity_key)
            ->setCld_claim_date($cld_claim_date)
            ->setCld_cst_key($cld_cst_key)
            ->setCld_notes($cld_notes)
            ->setCld_ivw_key($cld_ivw_key)
            ->setCld_claim_reason($cld_claim_reason)
            ->setCld_claim_status($cld_claim_status)
            ->setCld_email_sent($cld_email_sent)
            ->setCld_sui_prd_key($cld_sui_prd_key)
            ->setCld_number($cld_number)
            ->setCld_process_qty($cld_process_qty)
            ->setCld_process_date($cld_process_date);
    }
    /**
     * Get cld_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_key(): ?string
    {
        return $this->cld_key ?? null;
    }
    /**
     * Set cld_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_key(?string $cld_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_key) && !is_string($cld_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_key, true), gettype($cld_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_key, true)), __LINE__);
        }
        if (is_null($cld_key) || (is_array($cld_key) && empty($cld_key))) {
            unset($this->cld_key);
        } else {
            $this->cld_key = $cld_key;
        }
        
        return $this;
    }
    /**
     * Get cld_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_add_user(): ?string
    {
        return $this->cld_add_user ?? null;
    }
    /**
     * Set cld_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_add_user(?string $cld_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_add_user) && !is_string($cld_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_add_user, true), gettype($cld_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cld_add_user) && mb_strlen((string) $cld_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cld_add_user)), __LINE__);
        }
        if (is_null($cld_add_user) || (is_array($cld_add_user) && empty($cld_add_user))) {
            unset($this->cld_add_user);
        } else {
            $this->cld_add_user = $cld_add_user;
        }
        
        return $this;
    }
    /**
     * Get cld_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_add_date(): ?string
    {
        return $this->cld_add_date ?? null;
    }
    /**
     * Set cld_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_add_date(?string $cld_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_add_date) && !is_string($cld_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_add_date, true), gettype($cld_add_date)), __LINE__);
        }
        if (is_null($cld_add_date) || (is_array($cld_add_date) && empty($cld_add_date))) {
            unset($this->cld_add_date);
        } else {
            $this->cld_add_date = $cld_add_date;
        }
        
        return $this;
    }
    /**
     * Get cld_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_change_user(): ?string
    {
        return $this->cld_change_user ?? null;
    }
    /**
     * Set cld_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_change_user(?string $cld_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_change_user) && !is_string($cld_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_change_user, true), gettype($cld_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cld_change_user) && mb_strlen((string) $cld_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cld_change_user)), __LINE__);
        }
        if (is_null($cld_change_user) || (is_array($cld_change_user) && empty($cld_change_user))) {
            unset($this->cld_change_user);
        } else {
            $this->cld_change_user = $cld_change_user;
        }
        
        return $this;
    }
    /**
     * Get cld_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_change_date(): ?string
    {
        return $this->cld_change_date ?? null;
    }
    /**
     * Set cld_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_change_date(?string $cld_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_change_date) && !is_string($cld_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_change_date, true), gettype($cld_change_date)), __LINE__);
        }
        if (is_null($cld_change_date) || (is_array($cld_change_date) && empty($cld_change_date))) {
            unset($this->cld_change_date);
        } else {
            $this->cld_change_date = $cld_change_date;
        }
        
        return $this;
    }
    /**
     * Get cld_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_delete_flag(): ?string
    {
        return $this->cld_delete_flag ?? null;
    }
    /**
     * Set cld_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_delete_flag(?string $cld_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_delete_flag) && !is_string($cld_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_delete_flag, true), gettype($cld_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cld_delete_flag) && $cld_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cld_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cld_delete_flag) && $cld_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cld_delete_flag, true)), __LINE__);
        }
        if (is_null($cld_delete_flag) || (is_array($cld_delete_flag) && empty($cld_delete_flag))) {
            unset($this->cld_delete_flag);
        } else {
            $this->cld_delete_flag = $cld_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cld_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_key_ext(): ?string
    {
        return $this->cld_key_ext ?? null;
    }
    /**
     * Set cld_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_key_ext(?string $cld_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_key_ext) && !is_string($cld_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_key_ext, true), gettype($cld_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_key_ext, true)), __LINE__);
        }
        if (is_null($cld_key_ext) || (is_array($cld_key_ext) && empty($cld_key_ext))) {
            unset($this->cld_key_ext);
        } else {
            $this->cld_key_ext = $cld_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cld_sfl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_sfl_key(): ?string
    {
        return $this->cld_sfl_key ?? null;
    }
    /**
     * Set cld_sfl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_sfl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_sfl_key(?string $cld_sfl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_sfl_key) && !is_string($cld_sfl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_sfl_key, true), gettype($cld_sfl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_sfl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_sfl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_sfl_key, true)), __LINE__);
        }
        if (is_null($cld_sfl_key) || (is_array($cld_sfl_key) && empty($cld_sfl_key))) {
            unset($this->cld_sfl_key);
        } else {
            $this->cld_sfl_key = $cld_sfl_key;
        }
        
        return $this;
    }
    /**
     * Get cld_ful_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_ful_key(): ?string
    {
        return $this->cld_ful_key ?? null;
    }
    /**
     * Set cld_ful_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_ful_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_ful_key(?string $cld_ful_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_ful_key) && !is_string($cld_ful_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_ful_key, true), gettype($cld_ful_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_ful_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_ful_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_ful_key, true)), __LINE__);
        }
        if (is_null($cld_ful_key) || (is_array($cld_ful_key) && empty($cld_ful_key))) {
            unset($this->cld_ful_key);
        } else {
            $this->cld_ful_key = $cld_ful_key;
        }
        
        return $this;
    }
    /**
     * Get cld_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_ivd_key(): ?string
    {
        return $this->cld_ivd_key ?? null;
    }
    /**
     * Set cld_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_ivd_key(?string $cld_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_ivd_key) && !is_string($cld_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_ivd_key, true), gettype($cld_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_ivd_key, true)), __LINE__);
        }
        if (is_null($cld_ivd_key) || (is_array($cld_ivd_key) && empty($cld_ivd_key))) {
            unset($this->cld_ivd_key);
        } else {
            $this->cld_ivd_key = $cld_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get cld_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_cxa_key(): ?string
    {
        return $this->cld_cxa_key ?? null;
    }
    /**
     * Set cld_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_cxa_key(?string $cld_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_cxa_key) && !is_string($cld_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_cxa_key, true), gettype($cld_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_cxa_key, true)), __LINE__);
        }
        if (is_null($cld_cxa_key) || (is_array($cld_cxa_key) && empty($cld_cxa_key))) {
            unset($this->cld_cxa_key);
        } else {
            $this->cld_cxa_key = $cld_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cld_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_inv_code(): ?string
    {
        return $this->cld_inv_code ?? null;
    }
    /**
     * Set cld_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_inv_code(?string $cld_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_inv_code) && !is_string($cld_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_inv_code, true), gettype($cld_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cld_inv_code) && mb_strlen((string) $cld_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cld_inv_code)), __LINE__);
        }
        if (is_null($cld_inv_code) || (is_array($cld_inv_code) && empty($cld_inv_code))) {
            unset($this->cld_inv_code);
        } else {
            $this->cld_inv_code = $cld_inv_code;
        }
        
        return $this;
    }
    /**
     * Get cld_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCld_qty(): ?float
    {
        return $this->cld_qty ?? null;
    }
    /**
     * Set cld_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cld_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_qty(?float $cld_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($cld_qty) && !(is_float($cld_qty) || is_numeric($cld_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cld_qty, true), gettype($cld_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cld_qty) && mb_strlen(mb_substr((string) $cld_qty, false !== mb_strpos((string) $cld_qty, '.') ? mb_strpos((string) $cld_qty, '.') + 1 : mb_strlen((string) $cld_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cld_qty, true), mb_strlen(mb_substr((string) $cld_qty, mb_strpos((string) $cld_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cld_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $cld_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cld_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cld_qty))), __LINE__);
        }
        if (is_null($cld_qty) || (is_array($cld_qty) && empty($cld_qty))) {
            unset($this->cld_qty);
        } else {
            $this->cld_qty = $cld_qty;
        }
        
        return $this;
    }
    /**
     * Get cld_ship_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCld_ship_qty(): ?float
    {
        return $this->cld_ship_qty ?? null;
    }
    /**
     * Set cld_ship_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cld_ship_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_ship_qty(?float $cld_ship_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($cld_ship_qty) && !(is_float($cld_ship_qty) || is_numeric($cld_ship_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cld_ship_qty, true), gettype($cld_ship_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cld_ship_qty) && mb_strlen(mb_substr((string) $cld_ship_qty, false !== mb_strpos((string) $cld_ship_qty, '.') ? mb_strpos((string) $cld_ship_qty, '.') + 1 : mb_strlen((string) $cld_ship_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cld_ship_qty, true), mb_strlen(mb_substr((string) $cld_ship_qty, mb_strpos((string) $cld_ship_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cld_ship_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $cld_ship_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cld_ship_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cld_ship_qty))), __LINE__);
        }
        if (is_null($cld_ship_qty) || (is_array($cld_ship_qty) && empty($cld_ship_qty))) {
            unset($this->cld_ship_qty);
        } else {
            $this->cld_ship_qty = $cld_ship_qty;
        }
        
        return $this;
    }
    /**
     * Get cld_ship_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_ship_date(): ?string
    {
        return $this->cld_ship_date ?? null;
    }
    /**
     * Set cld_ship_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_ship_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_ship_date(?string $cld_ship_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_ship_date) && !is_string($cld_ship_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_ship_date, true), gettype($cld_ship_date)), __LINE__);
        }
        if (is_null($cld_ship_date) || (is_array($cld_ship_date) && empty($cld_ship_date))) {
            unset($this->cld_ship_date);
        } else {
            $this->cld_ship_date = $cld_ship_date;
        }
        
        return $this;
    }
    /**
     * Get cld_reshipped value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_reshipped(): ?string
    {
        return $this->cld_reshipped ?? null;
    }
    /**
     * Set cld_reshipped value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_reshipped
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_reshipped(?string $cld_reshipped = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_reshipped) && !is_string($cld_reshipped)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_reshipped, true), gettype($cld_reshipped)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cld_reshipped) && $cld_reshipped > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cld_reshipped, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cld_reshipped) && $cld_reshipped < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cld_reshipped, true)), __LINE__);
        }
        if (is_null($cld_reshipped) || (is_array($cld_reshipped) && empty($cld_reshipped))) {
            unset($this->cld_reshipped);
        } else {
            $this->cld_reshipped = $cld_reshipped;
        }
        
        return $this;
    }
    /**
     * Get cld_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_entity_key(): ?string
    {
        return $this->cld_entity_key ?? null;
    }
    /**
     * Set cld_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_entity_key(?string $cld_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_entity_key) && !is_string($cld_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_entity_key, true), gettype($cld_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_entity_key, true)), __LINE__);
        }
        if (is_null($cld_entity_key) || (is_array($cld_entity_key) && empty($cld_entity_key))) {
            unset($this->cld_entity_key);
        } else {
            $this->cld_entity_key = $cld_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cld_claim_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_claim_date(): ?string
    {
        return $this->cld_claim_date ?? null;
    }
    /**
     * Set cld_claim_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_claim_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_claim_date(?string $cld_claim_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_claim_date) && !is_string($cld_claim_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_claim_date, true), gettype($cld_claim_date)), __LINE__);
        }
        if (is_null($cld_claim_date) || (is_array($cld_claim_date) && empty($cld_claim_date))) {
            unset($this->cld_claim_date);
        } else {
            $this->cld_claim_date = $cld_claim_date;
        }
        
        return $this;
    }
    /**
     * Get cld_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_cst_key(): ?string
    {
        return $this->cld_cst_key ?? null;
    }
    /**
     * Set cld_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_cst_key(?string $cld_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_cst_key) && !is_string($cld_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_cst_key, true), gettype($cld_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_cst_key, true)), __LINE__);
        }
        if (is_null($cld_cst_key) || (is_array($cld_cst_key) && empty($cld_cst_key))) {
            unset($this->cld_cst_key);
        } else {
            $this->cld_cst_key = $cld_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cld_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_notes(): ?string
    {
        return $this->cld_notes ?? null;
    }
    /**
     * Set cld_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_notes(?string $cld_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_notes) && !is_string($cld_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_notes, true), gettype($cld_notes)), __LINE__);
        }
        if (is_null($cld_notes) || (is_array($cld_notes) && empty($cld_notes))) {
            unset($this->cld_notes);
        } else {
            $this->cld_notes = $cld_notes;
        }
        
        return $this;
    }
    /**
     * Get cld_ivw_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_ivw_key(): ?string
    {
        return $this->cld_ivw_key ?? null;
    }
    /**
     * Set cld_ivw_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_ivw_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_ivw_key(?string $cld_ivw_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_ivw_key) && !is_string($cld_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_ivw_key, true), gettype($cld_ivw_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_ivw_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_ivw_key, true)), __LINE__);
        }
        if (is_null($cld_ivw_key) || (is_array($cld_ivw_key) && empty($cld_ivw_key))) {
            unset($this->cld_ivw_key);
        } else {
            $this->cld_ivw_key = $cld_ivw_key;
        }
        
        return $this;
    }
    /**
     * Get cld_claim_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_claim_reason(): ?string
    {
        return $this->cld_claim_reason ?? null;
    }
    /**
     * Set cld_claim_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_claim_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_claim_reason(?string $cld_claim_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_claim_reason) && !is_string($cld_claim_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_claim_reason, true), gettype($cld_claim_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cld_claim_reason) && mb_strlen((string) $cld_claim_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cld_claim_reason)), __LINE__);
        }
        if (is_null($cld_claim_reason) || (is_array($cld_claim_reason) && empty($cld_claim_reason))) {
            unset($this->cld_claim_reason);
        } else {
            $this->cld_claim_reason = $cld_claim_reason;
        }
        
        return $this;
    }
    /**
     * Get cld_claim_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_claim_status(): ?string
    {
        return $this->cld_claim_status ?? null;
    }
    /**
     * Set cld_claim_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_claim_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_claim_status(?string $cld_claim_status = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_claim_status) && !is_string($cld_claim_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_claim_status, true), gettype($cld_claim_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cld_claim_status) && mb_strlen((string) $cld_claim_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cld_claim_status)), __LINE__);
        }
        if (is_null($cld_claim_status) || (is_array($cld_claim_status) && empty($cld_claim_status))) {
            unset($this->cld_claim_status);
        } else {
            $this->cld_claim_status = $cld_claim_status;
        }
        
        return $this;
    }
    /**
     * Get cld_email_sent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_email_sent(): ?string
    {
        return $this->cld_email_sent ?? null;
    }
    /**
     * Set cld_email_sent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_email_sent
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_email_sent(?string $cld_email_sent = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_email_sent) && !is_string($cld_email_sent)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_email_sent, true), gettype($cld_email_sent)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cld_email_sent) && $cld_email_sent > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cld_email_sent, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cld_email_sent) && $cld_email_sent < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cld_email_sent, true)), __LINE__);
        }
        if (is_null($cld_email_sent) || (is_array($cld_email_sent) && empty($cld_email_sent))) {
            unset($this->cld_email_sent);
        } else {
            $this->cld_email_sent = $cld_email_sent;
        }
        
        return $this;
    }
    /**
     * Get cld_sui_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_sui_prd_key(): ?string
    {
        return $this->cld_sui_prd_key ?? null;
    }
    /**
     * Set cld_sui_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_sui_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_sui_prd_key(?string $cld_sui_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_sui_prd_key) && !is_string($cld_sui_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_sui_prd_key, true), gettype($cld_sui_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cld_sui_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cld_sui_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cld_sui_prd_key, true)), __LINE__);
        }
        if (is_null($cld_sui_prd_key) || (is_array($cld_sui_prd_key) && empty($cld_sui_prd_key))) {
            unset($this->cld_sui_prd_key);
        } else {
            $this->cld_sui_prd_key = $cld_sui_prd_key;
        }
        
        return $this;
    }
    /**
     * Get cld_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCld_number(): ?int
    {
        return $this->cld_number ?? null;
    }
    /**
     * Set cld_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cld_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_number(?int $cld_number = null): self
    {
        // validation for constraint: int
        if (!is_null($cld_number) && !(is_int($cld_number) || ctype_digit($cld_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cld_number, true), gettype($cld_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cld_number) && $cld_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cld_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cld_number) && $cld_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cld_number, true)), __LINE__);
        }
        if (is_null($cld_number) || (is_array($cld_number) && empty($cld_number))) {
            unset($this->cld_number);
        } else {
            $this->cld_number = $cld_number;
        }
        
        return $this;
    }
    /**
     * Get cld_process_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCld_process_qty(): ?float
    {
        return $this->cld_process_qty ?? null;
    }
    /**
     * Set cld_process_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cld_process_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_process_qty(?float $cld_process_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($cld_process_qty) && !(is_float($cld_process_qty) || is_numeric($cld_process_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cld_process_qty, true), gettype($cld_process_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cld_process_qty) && mb_strlen(mb_substr((string) $cld_process_qty, false !== mb_strpos((string) $cld_process_qty, '.') ? mb_strpos((string) $cld_process_qty, '.') + 1 : mb_strlen((string) $cld_process_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cld_process_qty, true), mb_strlen(mb_substr((string) $cld_process_qty, mb_strpos((string) $cld_process_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cld_process_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $cld_process_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cld_process_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cld_process_qty))), __LINE__);
        }
        if (is_null($cld_process_qty) || (is_array($cld_process_qty) && empty($cld_process_qty))) {
            unset($this->cld_process_qty);
        } else {
            $this->cld_process_qty = $cld_process_qty;
        }
        
        return $this;
    }
    /**
     * Get cld_process_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_process_date(): ?string
    {
        return $this->cld_process_date ?? null;
    }
    /**
     * Set cld_process_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_process_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
     */
    public function setCld_process_date(?string $cld_process_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cld_process_date) && !is_string($cld_process_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cld_process_date, true), gettype($cld_process_date)), __LINE__);
        }
        if (is_null($cld_process_date) || (is_array($cld_process_date) && empty($cld_process_date))) {
            unset($this->cld_process_date);
        } else {
            $this->cld_process_date = $cld_process_date;
        }
        
        return $this;
    }
}
