<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Invoice_Detail_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Invoice_Invoice_Detail_DataObjectType extends AbstractStructBase
{
    /**
     * The ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_key = null;
    /**
     * The ivd_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_inv_key = null;
    /**
     * The ivd_price
     * Meta information extracted from the WSDL
     * - documentation: Sale Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_price = null;
    /**
     * The ivd_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity Sold. This field has this Input Mask: 999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_qty = null;
    /**
     * The ivd_approve_date
     * Meta information extracted from the WSDL
     * - documentation: Date Approved. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_date = null;
    /**
     * The ivd_approve_user
     * Meta information extracted from the WSDL
     * - documentation: Approved By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_user = null;
    /**
     * The ivd_void_date
     * Meta information extracted from the WSDL
     * - documentation: Date Voided. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_date = null;
    /**
     * The ivd_void_user
     * Meta information extracted from the WSDL
     * - documentation: Voided By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_user = null;
    /**
     * The ivd_ajd_key
     * Meta information extracted from the WSDL
     * - documentation: Adjustment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ajd_key = null;
    /**
     * The ivd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_add_user = null;
    /**
     * The ivd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_add_date = null;
    /**
     * The ivd_backorder_flag
     * Meta information extracted from the WSDL
     * - documentation: Backorder?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_backorder_flag = null;
    /**
     * The ivd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_change_user = null;
    /**
     * The ivd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_change_date = null;
    /**
     * The ivd_inventory_held_qty
     * Meta information extracted from the WSDL
     * - documentation: Inventory Held Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_inventory_held_qty = null;
    /**
     * The ivd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_delete_flag = null;
    /**
     * The ivd_ship_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity Shipped. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_ship_qty = null;
    /**
     * The ivd_ship_flag_cp
     * Meta information extracted from the WSDL
     * - documentation: Shipped. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_ship_flag_cp = null;
    /**
     * The ivd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_key_ext = null;
    /**
     * The ivd_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_close_flag = null;
    /**
     * The ivd_approve_flag
     * Meta information extracted from the WSDL
     * - documentation: Approved?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_flag = null;
    /**
     * The ivd_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_flag = null;
    /**
     * The ivd_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Price. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_key = null;
    /**
     * The ivd_prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_prd_key = null;
    /**
     * The ivd_amount_cp
     * Meta information extracted from the WSDL
     * - documentation: Amount. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_amount_cp = null;
    /**
     * The ivd_parity
     * Meta information extracted from the WSDL
     * - documentation: Parity Flag.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_parity = null;
    /**
     * The ivd_parity_amount_cp
     * Meta information extracted from the WSDL
     * - documentation: Parity Amount. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_parity_amount_cp = null;
    /**
     * The ivd_gla_dr_key
     * Meta information extracted from the WSDL
     * - documentation: Debit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_gla_dr_key = null;
    /**
     * The ivd_gla_cr_key
     * Meta information extracted from the WSDL
     * - documentation: Credit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_gla_cr_key = null;
    /**
     * The ivd_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_notes = null;
    /**
     * The ivd_cst_ship_key
     * Meta information extracted from the WSDL
     * - documentation: Ship To Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cst_ship_key = null;
    /**
     * The ivd_prc_prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_prd_ptp_key = null;
    /**
     * The ivd_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Ship To Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cxa_key = null;
    /**
     * The ivd_src_key
     * Meta information extracted from the WSDL
     * - documentation: source code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_src_key = null;
    /**
     * The ivd_type
     * Meta information extracted from the WSDL
     * - documentation: Line Item Type.This element has a default value of 'Product'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_type = null;
    /**
     * The ivd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_entity_key = null;
    /**
     * The ivd_ivw_key
     * Meta information extracted from the WSDL
     * - documentation: Warehouse Inventory. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ivw_key = null;
    /**
     * The ivd_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_odd_key = null;
    /**
     * The ivd_do_not_fulfill
     * Meta information extracted from the WSDL
     * - documentation: Do Not Fulfill. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_do_not_fulfill = null;
    /**
     * The ivd_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pak_prd_key = null;
    /**
     * The ivd_ods_key
     * Meta information extracted from the WSDL
     * - documentation: installment schedule. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ods_key = null;
    /**
     * The ivd_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cst_key = null;
    /**
     * The ivd_account_number
     * Meta information extracted from the WSDL
     * - documentation: account number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_account_number = null;
    /**
     * The ivd_ovr_key
     * Meta information extracted from the WSDL
     * - documentation: Price Override Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ovr_key = null;
    /**
     * The ivd_price_override_reason
     * Meta information extracted from the WSDL
     * - documentation: Price Override Reason Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_price_override_reason = null;
    /**
     * The ivd_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pjt_key = null;
    /**
     * The ivd_backorder_email_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: Backorder email sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_backorder_email_sent_flag = null;
    /**
     * The ivd_process_qty
     * Meta information extracted from the WSDL
     * - documentation: Process Qty. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_process_qty = null;
    /**
     * The ivd_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_bun_prd_key = null;
    /**
     * The ivd_download_count
     * Meta information extracted from the WSDL
     * - documentation: Download Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_count = null;
    /**
     * The ivd_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_eml_key = null;
    /**
     * The ivd_package_grouping_key
     * Meta information extracted from the WSDL
     * - documentation: Package Grouping Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_package_grouping_key = null;
    /**
     * The ivd_cdd_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Card Credit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cdd_key = null;
    /**
     * The ivd_download_limit_override
     * Meta information extracted from the WSDL
     * - documentation: Download Limit Override. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_limit_override = null;
    /**
     * The ivd_discount_program_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Discount Program Applied. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_discount_program_ivd_key = null;
    /**
     * The ivd_distributed_liability_flag
     * Meta information extracted from the WSDL
     * - documentation: Distributed Liability Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_distributed_liability_flag = null;
    /**
     * The ivd_download_days_override
     * Meta information extracted from the WSDL
     * - documentation: Download Days Override. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_days_override = null;
    /**
     * The ivd_gc_number
     * Meta information extracted from the WSDL
     * - documentation: Gift Card Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_gc_number = null;
    /**
     * The ivd_cdt_key
     * Meta information extracted from the WSDL
     * - documentation: Redemption. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cdt_key = null;
    /**
     * The ivd_pro_key
     * Meta information extracted from the WSDL
     * - documentation: ivd_pro_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pro_key = null;
    /**
     * The ivd_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Line Item that the Discount, Tax or Shipping applies to. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ivd_key = null;
    /**
     * Constructor method for Invoice_Invoice_Detail_DataObjectType
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_inv_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_price()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_qty()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_approve_date()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_approve_user()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_void_date()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_void_user()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ajd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_add_user()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_add_date()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_backorder_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_change_user()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_change_date()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_inventory_held_qty()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_delete_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ship_qty()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ship_flag_cp()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_key_ext()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_close_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_approve_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_void_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_prc_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_prc_prd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_amount_cp()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_parity()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_parity_amount_cp()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_gla_dr_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_gla_cr_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_notes()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_cst_ship_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_prc_prd_ptp_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_cxa_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_src_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_type()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_entity_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ivw_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_odd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_do_not_fulfill()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_pak_prd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ods_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_cst_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_account_number()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ovr_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_price_override_reason()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_pjt_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_backorder_email_sent_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_process_qty()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_bun_prd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_download_count()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_eml_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_package_grouping_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_cdd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_download_limit_override()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_discount_program_ivd_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_distributed_liability_flag()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_download_days_override()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_gc_number()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_cdt_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_pro_key()
     * @uses Invoice_Invoice_Detail_DataObjectType::setIvd_ivd_key()
     * @param string $ivd_key
     * @param string $ivd_inv_key
     * @param float $ivd_price
     * @param float $ivd_qty
     * @param string $ivd_approve_date
     * @param string $ivd_approve_user
     * @param string $ivd_void_date
     * @param string $ivd_void_user
     * @param string $ivd_ajd_key
     * @param string $ivd_add_user
     * @param string $ivd_add_date
     * @param string $ivd_backorder_flag
     * @param string $ivd_change_user
     * @param string $ivd_change_date
     * @param float $ivd_inventory_held_qty
     * @param string $ivd_delete_flag
     * @param float $ivd_ship_qty
     * @param int $ivd_ship_flag_cp
     * @param string $ivd_key_ext
     * @param string $ivd_close_flag
     * @param string $ivd_approve_flag
     * @param string $ivd_void_flag
     * @param string $ivd_prc_key
     * @param string $ivd_prc_prd_key
     * @param float $ivd_amount_cp
     * @param int $ivd_parity
     * @param float $ivd_parity_amount_cp
     * @param string $ivd_gla_dr_key
     * @param string $ivd_gla_cr_key
     * @param string $ivd_notes
     * @param string $ivd_cst_ship_key
     * @param string $ivd_prc_prd_ptp_key
     * @param string $ivd_cxa_key
     * @param string $ivd_src_key
     * @param string $ivd_type
     * @param string $ivd_entity_key
     * @param string $ivd_ivw_key
     * @param string $ivd_odd_key
     * @param string $ivd_do_not_fulfill
     * @param string $ivd_pak_prd_key
     * @param string $ivd_ods_key
     * @param string $ivd_cst_key
     * @param string $ivd_account_number
     * @param string $ivd_ovr_key
     * @param string $ivd_price_override_reason
     * @param string $ivd_pjt_key
     * @param string $ivd_backorder_email_sent_flag
     * @param float $ivd_process_qty
     * @param string $ivd_bun_prd_key
     * @param int $ivd_download_count
     * @param string $ivd_eml_key
     * @param string $ivd_package_grouping_key
     * @param string $ivd_cdd_key
     * @param int $ivd_download_limit_override
     * @param string $ivd_discount_program_ivd_key
     * @param string $ivd_distributed_liability_flag
     * @param int $ivd_download_days_override
     * @param string $ivd_gc_number
     * @param string $ivd_cdt_key
     * @param string $ivd_pro_key
     * @param string $ivd_ivd_key
     */
    public function __construct(?string $ivd_key = null, ?string $ivd_inv_key = null, ?float $ivd_price = null, ?float $ivd_qty = null, ?string $ivd_approve_date = null, ?string $ivd_approve_user = null, ?string $ivd_void_date = null, ?string $ivd_void_user = null, ?string $ivd_ajd_key = null, ?string $ivd_add_user = null, ?string $ivd_add_date = null, ?string $ivd_backorder_flag = null, ?string $ivd_change_user = null, ?string $ivd_change_date = null, ?float $ivd_inventory_held_qty = null, ?string $ivd_delete_flag = null, ?float $ivd_ship_qty = null, ?int $ivd_ship_flag_cp = null, ?string $ivd_key_ext = null, ?string $ivd_close_flag = null, ?string $ivd_approve_flag = null, ?string $ivd_void_flag = null, ?string $ivd_prc_key = null, ?string $ivd_prc_prd_key = null, ?float $ivd_amount_cp = null, ?int $ivd_parity = null, ?float $ivd_parity_amount_cp = null, ?string $ivd_gla_dr_key = null, ?string $ivd_gla_cr_key = null, ?string $ivd_notes = null, ?string $ivd_cst_ship_key = null, ?string $ivd_prc_prd_ptp_key = null, ?string $ivd_cxa_key = null, ?string $ivd_src_key = null, ?string $ivd_type = null, ?string $ivd_entity_key = null, ?string $ivd_ivw_key = null, ?string $ivd_odd_key = null, ?string $ivd_do_not_fulfill = null, ?string $ivd_pak_prd_key = null, ?string $ivd_ods_key = null, ?string $ivd_cst_key = null, ?string $ivd_account_number = null, ?string $ivd_ovr_key = null, ?string $ivd_price_override_reason = null, ?string $ivd_pjt_key = null, ?string $ivd_backorder_email_sent_flag = null, ?float $ivd_process_qty = null, ?string $ivd_bun_prd_key = null, ?int $ivd_download_count = null, ?string $ivd_eml_key = null, ?string $ivd_package_grouping_key = null, ?string $ivd_cdd_key = null, ?int $ivd_download_limit_override = null, ?string $ivd_discount_program_ivd_key = null, ?string $ivd_distributed_liability_flag = null, ?int $ivd_download_days_override = null, ?string $ivd_gc_number = null, ?string $ivd_cdt_key = null, ?string $ivd_pro_key = null, ?string $ivd_ivd_key = null)
    {
        $this
            ->setIvd_key($ivd_key)
            ->setIvd_inv_key($ivd_inv_key)
            ->setIvd_price($ivd_price)
            ->setIvd_qty($ivd_qty)
            ->setIvd_approve_date($ivd_approve_date)
            ->setIvd_approve_user($ivd_approve_user)
            ->setIvd_void_date($ivd_void_date)
            ->setIvd_void_user($ivd_void_user)
            ->setIvd_ajd_key($ivd_ajd_key)
            ->setIvd_add_user($ivd_add_user)
            ->setIvd_add_date($ivd_add_date)
            ->setIvd_backorder_flag($ivd_backorder_flag)
            ->setIvd_change_user($ivd_change_user)
            ->setIvd_change_date($ivd_change_date)
            ->setIvd_inventory_held_qty($ivd_inventory_held_qty)
            ->setIvd_delete_flag($ivd_delete_flag)
            ->setIvd_ship_qty($ivd_ship_qty)
            ->setIvd_ship_flag_cp($ivd_ship_flag_cp)
            ->setIvd_key_ext($ivd_key_ext)
            ->setIvd_close_flag($ivd_close_flag)
            ->setIvd_approve_flag($ivd_approve_flag)
            ->setIvd_void_flag($ivd_void_flag)
            ->setIvd_prc_key($ivd_prc_key)
            ->setIvd_prc_prd_key($ivd_prc_prd_key)
            ->setIvd_amount_cp($ivd_amount_cp)
            ->setIvd_parity($ivd_parity)
            ->setIvd_parity_amount_cp($ivd_parity_amount_cp)
            ->setIvd_gla_dr_key($ivd_gla_dr_key)
            ->setIvd_gla_cr_key($ivd_gla_cr_key)
            ->setIvd_notes($ivd_notes)
            ->setIvd_cst_ship_key($ivd_cst_ship_key)
            ->setIvd_prc_prd_ptp_key($ivd_prc_prd_ptp_key)
            ->setIvd_cxa_key($ivd_cxa_key)
            ->setIvd_src_key($ivd_src_key)
            ->setIvd_type($ivd_type)
            ->setIvd_entity_key($ivd_entity_key)
            ->setIvd_ivw_key($ivd_ivw_key)
            ->setIvd_odd_key($ivd_odd_key)
            ->setIvd_do_not_fulfill($ivd_do_not_fulfill)
            ->setIvd_pak_prd_key($ivd_pak_prd_key)
            ->setIvd_ods_key($ivd_ods_key)
            ->setIvd_cst_key($ivd_cst_key)
            ->setIvd_account_number($ivd_account_number)
            ->setIvd_ovr_key($ivd_ovr_key)
            ->setIvd_price_override_reason($ivd_price_override_reason)
            ->setIvd_pjt_key($ivd_pjt_key)
            ->setIvd_backorder_email_sent_flag($ivd_backorder_email_sent_flag)
            ->setIvd_process_qty($ivd_process_qty)
            ->setIvd_bun_prd_key($ivd_bun_prd_key)
            ->setIvd_download_count($ivd_download_count)
            ->setIvd_eml_key($ivd_eml_key)
            ->setIvd_package_grouping_key($ivd_package_grouping_key)
            ->setIvd_cdd_key($ivd_cdd_key)
            ->setIvd_download_limit_override($ivd_download_limit_override)
            ->setIvd_discount_program_ivd_key($ivd_discount_program_ivd_key)
            ->setIvd_distributed_liability_flag($ivd_distributed_liability_flag)
            ->setIvd_download_days_override($ivd_download_days_override)
            ->setIvd_gc_number($ivd_gc_number)
            ->setIvd_cdt_key($ivd_cdt_key)
            ->setIvd_pro_key($ivd_pro_key)
            ->setIvd_ivd_key($ivd_ivd_key);
    }
    /**
     * Get ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_key(): ?string
    {
        return $this->ivd_key ?? null;
    }
    /**
     * Set ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_key(?string $ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_key) && !is_string($ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_key, true), gettype($ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_key) || (is_array($ivd_key) && empty($ivd_key))) {
            unset($this->ivd_key);
        } else {
            $this->ivd_key = $ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_inv_key(): ?string
    {
        return $this->ivd_inv_key ?? null;
    }
    /**
     * Set ivd_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_inv_key(?string $ivd_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_inv_key) && !is_string($ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_inv_key, true), gettype($ivd_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_inv_key, true)), __LINE__);
        }
        if (is_null($ivd_inv_key) || (is_array($ivd_inv_key) && empty($ivd_inv_key))) {
            unset($this->ivd_inv_key);
        } else {
            $this->ivd_inv_key = $ivd_inv_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_price(): ?float
    {
        return $this->ivd_price ?? null;
    }
    /**
     * Set ivd_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_price(?float $ivd_price = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_price) && !(is_float($ivd_price) || is_numeric($ivd_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_price, true), gettype($ivd_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_price) && mb_strlen(mb_substr((string) $ivd_price, false !== mb_strpos((string) $ivd_price, '.') ? mb_strpos((string) $ivd_price, '.') + 1 : mb_strlen((string) $ivd_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_price, true), mb_strlen(mb_substr((string) $ivd_price, mb_strpos((string) $ivd_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price))), __LINE__);
        }
        if (is_null($ivd_price) || (is_array($ivd_price) && empty($ivd_price))) {
            unset($this->ivd_price);
        } else {
            $this->ivd_price = $ivd_price;
        }
        
        return $this;
    }
    /**
     * Get ivd_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_qty(): ?float
    {
        return $this->ivd_qty ?? null;
    }
    /**
     * Set ivd_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_qty(?float $ivd_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_qty) && !(is_float($ivd_qty) || is_numeric($ivd_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_qty, true), gettype($ivd_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_qty) && mb_strlen(mb_substr((string) $ivd_qty, false !== mb_strpos((string) $ivd_qty, '.') ? mb_strpos((string) $ivd_qty, '.') + 1 : mb_strlen((string) $ivd_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_qty, true), mb_strlen(mb_substr((string) $ivd_qty, mb_strpos((string) $ivd_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty))), __LINE__);
        }
        if (is_null($ivd_qty) || (is_array($ivd_qty) && empty($ivd_qty))) {
            unset($this->ivd_qty);
        } else {
            $this->ivd_qty = $ivd_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_date(): ?string
    {
        return $this->ivd_approve_date ?? null;
    }
    /**
     * Set ivd_approve_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_date(?string $ivd_approve_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_date) && !is_string($ivd_approve_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_date, true), gettype($ivd_approve_date)), __LINE__);
        }
        if (is_null($ivd_approve_date) || (is_array($ivd_approve_date) && empty($ivd_approve_date))) {
            unset($this->ivd_approve_date);
        } else {
            $this->ivd_approve_date = $ivd_approve_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_user(): ?string
    {
        return $this->ivd_approve_user ?? null;
    }
    /**
     * Set ivd_approve_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_user(?string $ivd_approve_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_user) && !is_string($ivd_approve_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_user, true), gettype($ivd_approve_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_approve_user) && mb_strlen((string) $ivd_approve_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_approve_user)), __LINE__);
        }
        if (is_null($ivd_approve_user) || (is_array($ivd_approve_user) && empty($ivd_approve_user))) {
            unset($this->ivd_approve_user);
        } else {
            $this->ivd_approve_user = $ivd_approve_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_date(): ?string
    {
        return $this->ivd_void_date ?? null;
    }
    /**
     * Set ivd_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_date(?string $ivd_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_date) && !is_string($ivd_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_date, true), gettype($ivd_void_date)), __LINE__);
        }
        if (is_null($ivd_void_date) || (is_array($ivd_void_date) && empty($ivd_void_date))) {
            unset($this->ivd_void_date);
        } else {
            $this->ivd_void_date = $ivd_void_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_user(): ?string
    {
        return $this->ivd_void_user ?? null;
    }
    /**
     * Set ivd_void_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_user(?string $ivd_void_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_user) && !is_string($ivd_void_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_user, true), gettype($ivd_void_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_void_user) && mb_strlen((string) $ivd_void_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_void_user)), __LINE__);
        }
        if (is_null($ivd_void_user) || (is_array($ivd_void_user) && empty($ivd_void_user))) {
            unset($this->ivd_void_user);
        } else {
            $this->ivd_void_user = $ivd_void_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_ajd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ajd_key(): ?string
    {
        return $this->ivd_ajd_key ?? null;
    }
    /**
     * Set ivd_ajd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ajd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ajd_key(?string $ivd_ajd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ajd_key) && !is_string($ivd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ajd_key, true), gettype($ivd_ajd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ajd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ajd_key, true)), __LINE__);
        }
        if (is_null($ivd_ajd_key) || (is_array($ivd_ajd_key) && empty($ivd_ajd_key))) {
            unset($this->ivd_ajd_key);
        } else {
            $this->ivd_ajd_key = $ivd_ajd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_add_user(): ?string
    {
        return $this->ivd_add_user ?? null;
    }
    /**
     * Set ivd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_add_user(?string $ivd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_add_user) && !is_string($ivd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_add_user, true), gettype($ivd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_add_user) && mb_strlen((string) $ivd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_add_user)), __LINE__);
        }
        if (is_null($ivd_add_user) || (is_array($ivd_add_user) && empty($ivd_add_user))) {
            unset($this->ivd_add_user);
        } else {
            $this->ivd_add_user = $ivd_add_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_add_date(): ?string
    {
        return $this->ivd_add_date ?? null;
    }
    /**
     * Set ivd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_add_date(?string $ivd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_add_date) && !is_string($ivd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_add_date, true), gettype($ivd_add_date)), __LINE__);
        }
        if (is_null($ivd_add_date) || (is_array($ivd_add_date) && empty($ivd_add_date))) {
            unset($this->ivd_add_date);
        } else {
            $this->ivd_add_date = $ivd_add_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_backorder_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_backorder_flag(): ?string
    {
        return $this->ivd_backorder_flag ?? null;
    }
    /**
     * Set ivd_backorder_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_backorder_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_backorder_flag(?string $ivd_backorder_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_backorder_flag) && !is_string($ivd_backorder_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_backorder_flag, true), gettype($ivd_backorder_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_backorder_flag) && $ivd_backorder_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_backorder_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_backorder_flag) && $ivd_backorder_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_backorder_flag, true)), __LINE__);
        }
        if (is_null($ivd_backorder_flag) || (is_array($ivd_backorder_flag) && empty($ivd_backorder_flag))) {
            unset($this->ivd_backorder_flag);
        } else {
            $this->ivd_backorder_flag = $ivd_backorder_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_change_user(): ?string
    {
        return $this->ivd_change_user ?? null;
    }
    /**
     * Set ivd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_change_user(?string $ivd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_change_user) && !is_string($ivd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_change_user, true), gettype($ivd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_change_user) && mb_strlen((string) $ivd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_change_user)), __LINE__);
        }
        if (is_null($ivd_change_user) || (is_array($ivd_change_user) && empty($ivd_change_user))) {
            unset($this->ivd_change_user);
        } else {
            $this->ivd_change_user = $ivd_change_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_change_date(): ?string
    {
        return $this->ivd_change_date ?? null;
    }
    /**
     * Set ivd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_change_date(?string $ivd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_change_date) && !is_string($ivd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_change_date, true), gettype($ivd_change_date)), __LINE__);
        }
        if (is_null($ivd_change_date) || (is_array($ivd_change_date) && empty($ivd_change_date))) {
            unset($this->ivd_change_date);
        } else {
            $this->ivd_change_date = $ivd_change_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_inventory_held_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_inventory_held_qty(): ?float
    {
        return $this->ivd_inventory_held_qty ?? null;
    }
    /**
     * Set ivd_inventory_held_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_inventory_held_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_inventory_held_qty(?float $ivd_inventory_held_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_inventory_held_qty) && !(is_float($ivd_inventory_held_qty) || is_numeric($ivd_inventory_held_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_inventory_held_qty, true), gettype($ivd_inventory_held_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_inventory_held_qty) && mb_strlen(mb_substr((string) $ivd_inventory_held_qty, false !== mb_strpos((string) $ivd_inventory_held_qty, '.') ? mb_strpos((string) $ivd_inventory_held_qty, '.') + 1 : mb_strlen((string) $ivd_inventory_held_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_inventory_held_qty, true), mb_strlen(mb_substr((string) $ivd_inventory_held_qty, mb_strpos((string) $ivd_inventory_held_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_inventory_held_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inventory_held_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_inventory_held_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inventory_held_qty))), __LINE__);
        }
        if (is_null($ivd_inventory_held_qty) || (is_array($ivd_inventory_held_qty) && empty($ivd_inventory_held_qty))) {
            unset($this->ivd_inventory_held_qty);
        } else {
            $this->ivd_inventory_held_qty = $ivd_inventory_held_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_delete_flag(): ?string
    {
        return $this->ivd_delete_flag ?? null;
    }
    /**
     * Set ivd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_delete_flag(?string $ivd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_delete_flag) && !is_string($ivd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_delete_flag, true), gettype($ivd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_delete_flag) && $ivd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_delete_flag) && $ivd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_delete_flag, true)), __LINE__);
        }
        if (is_null($ivd_delete_flag) || (is_array($ivd_delete_flag) && empty($ivd_delete_flag))) {
            unset($this->ivd_delete_flag);
        } else {
            $this->ivd_delete_flag = $ivd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_ship_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_ship_qty(): ?float
    {
        return $this->ivd_ship_qty ?? null;
    }
    /**
     * Set ivd_ship_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_ship_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ship_qty(?float $ivd_ship_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_ship_qty) && !(is_float($ivd_ship_qty) || is_numeric($ivd_ship_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_ship_qty, true), gettype($ivd_ship_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_ship_qty) && mb_strlen(mb_substr((string) $ivd_ship_qty, false !== mb_strpos((string) $ivd_ship_qty, '.') ? mb_strpos((string) $ivd_ship_qty, '.') + 1 : mb_strlen((string) $ivd_ship_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_ship_qty, true), mb_strlen(mb_substr((string) $ivd_ship_qty, mb_strpos((string) $ivd_ship_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_ship_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_ship_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_ship_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_ship_qty))), __LINE__);
        }
        if (is_null($ivd_ship_qty) || (is_array($ivd_ship_qty) && empty($ivd_ship_qty))) {
            unset($this->ivd_ship_qty);
        } else {
            $this->ivd_ship_qty = $ivd_ship_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_ship_flag_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_ship_flag_cp(): ?int
    {
        return $this->ivd_ship_flag_cp ?? null;
    }
    /**
     * Set ivd_ship_flag_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_ship_flag_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ship_flag_cp(?int $ivd_ship_flag_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_ship_flag_cp) && !(is_int($ivd_ship_flag_cp) || ctype_digit($ivd_ship_flag_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_ship_flag_cp, true), gettype($ivd_ship_flag_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_ship_flag_cp) && $ivd_ship_flag_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_ship_flag_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_ship_flag_cp) && $ivd_ship_flag_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_ship_flag_cp, true)), __LINE__);
        }
        if (is_null($ivd_ship_flag_cp) || (is_array($ivd_ship_flag_cp) && empty($ivd_ship_flag_cp))) {
            unset($this->ivd_ship_flag_cp);
        } else {
            $this->ivd_ship_flag_cp = $ivd_ship_flag_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_key_ext(): ?string
    {
        return $this->ivd_key_ext ?? null;
    }
    /**
     * Set ivd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_key_ext(?string $ivd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_key_ext) && !is_string($ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_key_ext, true), gettype($ivd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_key_ext, true)), __LINE__);
        }
        if (is_null($ivd_key_ext) || (is_array($ivd_key_ext) && empty($ivd_key_ext))) {
            unset($this->ivd_key_ext);
        } else {
            $this->ivd_key_ext = $ivd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ivd_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_close_flag(): ?string
    {
        return $this->ivd_close_flag ?? null;
    }
    /**
     * Set ivd_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_close_flag(?string $ivd_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_close_flag) && !is_string($ivd_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_close_flag, true), gettype($ivd_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_close_flag) && $ivd_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_close_flag) && $ivd_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_close_flag, true)), __LINE__);
        }
        if (is_null($ivd_close_flag) || (is_array($ivd_close_flag) && empty($ivd_close_flag))) {
            unset($this->ivd_close_flag);
        } else {
            $this->ivd_close_flag = $ivd_close_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_flag(): ?string
    {
        return $this->ivd_approve_flag ?? null;
    }
    /**
     * Set ivd_approve_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_flag(?string $ivd_approve_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_flag) && !is_string($ivd_approve_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_flag, true), gettype($ivd_approve_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_approve_flag) && $ivd_approve_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_approve_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_approve_flag) && $ivd_approve_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_approve_flag, true)), __LINE__);
        }
        if (is_null($ivd_approve_flag) || (is_array($ivd_approve_flag) && empty($ivd_approve_flag))) {
            unset($this->ivd_approve_flag);
        } else {
            $this->ivd_approve_flag = $ivd_approve_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_flag(): ?string
    {
        return $this->ivd_void_flag ?? null;
    }
    /**
     * Set ivd_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_flag(?string $ivd_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_flag) && !is_string($ivd_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_flag, true), gettype($ivd_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_void_flag) && $ivd_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_void_flag) && $ivd_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_void_flag, true)), __LINE__);
        }
        if (is_null($ivd_void_flag) || (is_array($ivd_void_flag) && empty($ivd_void_flag))) {
            unset($this->ivd_void_flag);
        } else {
            $this->ivd_void_flag = $ivd_void_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_key(): ?string
    {
        return $this->ivd_prc_key ?? null;
    }
    /**
     * Set ivd_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_key(?string $ivd_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_key) && !is_string($ivd_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_key, true), gettype($ivd_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_key) || (is_array($ivd_prc_key) && empty($ivd_prc_key))) {
            unset($this->ivd_prc_key);
        } else {
            $this->ivd_prc_key = $ivd_prc_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_prd_key(): ?string
    {
        return $this->ivd_prc_prd_key ?? null;
    }
    /**
     * Set ivd_prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_prd_key(?string $ivd_prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_prd_key) && !is_string($ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_prd_key, true), gettype($ivd_prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_prd_key) || (is_array($ivd_prc_prd_key) && empty($ivd_prc_prd_key))) {
            unset($this->ivd_prc_prd_key);
        } else {
            $this->ivd_prc_prd_key = $ivd_prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_amount_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_amount_cp(): ?float
    {
        return $this->ivd_amount_cp ?? null;
    }
    /**
     * Set ivd_amount_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_amount_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_amount_cp(?float $ivd_amount_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_amount_cp) && !(is_float($ivd_amount_cp) || is_numeric($ivd_amount_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_amount_cp, true), gettype($ivd_amount_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_amount_cp) && mb_strlen(mb_substr((string) $ivd_amount_cp, false !== mb_strpos((string) $ivd_amount_cp, '.') ? mb_strpos((string) $ivd_amount_cp, '.') + 1 : mb_strlen((string) $ivd_amount_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_amount_cp, true), mb_strlen(mb_substr((string) $ivd_amount_cp, mb_strpos((string) $ivd_amount_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_amount_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_amount_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_cp))), __LINE__);
        }
        if (is_null($ivd_amount_cp) || (is_array($ivd_amount_cp) && empty($ivd_amount_cp))) {
            unset($this->ivd_amount_cp);
        } else {
            $this->ivd_amount_cp = $ivd_amount_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_parity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_parity(): ?int
    {
        return $this->ivd_parity ?? null;
    }
    /**
     * Set ivd_parity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_parity
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_parity(?int $ivd_parity = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_parity) && !(is_int($ivd_parity) || ctype_digit($ivd_parity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_parity, true), gettype($ivd_parity)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_parity) && $ivd_parity > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_parity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_parity) && $ivd_parity < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_parity, true)), __LINE__);
        }
        if (is_null($ivd_parity) || (is_array($ivd_parity) && empty($ivd_parity))) {
            unset($this->ivd_parity);
        } else {
            $this->ivd_parity = $ivd_parity;
        }
        
        return $this;
    }
    /**
     * Get ivd_parity_amount_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_parity_amount_cp(): ?float
    {
        return $this->ivd_parity_amount_cp ?? null;
    }
    /**
     * Set ivd_parity_amount_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_parity_amount_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_parity_amount_cp(?float $ivd_parity_amount_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_parity_amount_cp) && !(is_float($ivd_parity_amount_cp) || is_numeric($ivd_parity_amount_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_parity_amount_cp, true), gettype($ivd_parity_amount_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_parity_amount_cp) && mb_strlen(mb_substr((string) $ivd_parity_amount_cp, false !== mb_strpos((string) $ivd_parity_amount_cp, '.') ? mb_strpos((string) $ivd_parity_amount_cp, '.') + 1 : mb_strlen((string) $ivd_parity_amount_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_parity_amount_cp, true), mb_strlen(mb_substr((string) $ivd_parity_amount_cp, mb_strpos((string) $ivd_parity_amount_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_parity_amount_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_parity_amount_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_parity_amount_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_parity_amount_cp))), __LINE__);
        }
        if (is_null($ivd_parity_amount_cp) || (is_array($ivd_parity_amount_cp) && empty($ivd_parity_amount_cp))) {
            unset($this->ivd_parity_amount_cp);
        } else {
            $this->ivd_parity_amount_cp = $ivd_parity_amount_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_gla_dr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gla_dr_key(): ?string
    {
        return $this->ivd_gla_dr_key ?? null;
    }
    /**
     * Set ivd_gla_dr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gla_dr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_gla_dr_key(?string $ivd_gla_dr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gla_dr_key) && !is_string($ivd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gla_dr_key, true), gettype($ivd_gla_dr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_gla_dr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_gla_dr_key, true)), __LINE__);
        }
        if (is_null($ivd_gla_dr_key) || (is_array($ivd_gla_dr_key) && empty($ivd_gla_dr_key))) {
            unset($this->ivd_gla_dr_key);
        } else {
            $this->ivd_gla_dr_key = $ivd_gla_dr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_gla_cr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gla_cr_key(): ?string
    {
        return $this->ivd_gla_cr_key ?? null;
    }
    /**
     * Set ivd_gla_cr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gla_cr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_gla_cr_key(?string $ivd_gla_cr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gla_cr_key) && !is_string($ivd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gla_cr_key, true), gettype($ivd_gla_cr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_gla_cr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_gla_cr_key, true)), __LINE__);
        }
        if (is_null($ivd_gla_cr_key) || (is_array($ivd_gla_cr_key) && empty($ivd_gla_cr_key))) {
            unset($this->ivd_gla_cr_key);
        } else {
            $this->ivd_gla_cr_key = $ivd_gla_cr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_notes(): ?string
    {
        return $this->ivd_notes ?? null;
    }
    /**
     * Set ivd_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_notes(?string $ivd_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_notes) && !is_string($ivd_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_notes, true), gettype($ivd_notes)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ivd_notes) && mb_strlen((string) $ivd_notes) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ivd_notes)), __LINE__);
        }
        if (is_null($ivd_notes) || (is_array($ivd_notes) && empty($ivd_notes))) {
            unset($this->ivd_notes);
        } else {
            $this->ivd_notes = $ivd_notes;
        }
        
        return $this;
    }
    /**
     * Get ivd_cst_ship_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cst_ship_key(): ?string
    {
        return $this->ivd_cst_ship_key ?? null;
    }
    /**
     * Set ivd_cst_ship_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cst_ship_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_cst_ship_key(?string $ivd_cst_ship_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cst_ship_key) && !is_string($ivd_cst_ship_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cst_ship_key, true), gettype($ivd_cst_ship_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cst_ship_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cst_ship_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cst_ship_key, true)), __LINE__);
        }
        if (is_null($ivd_cst_ship_key) || (is_array($ivd_cst_ship_key) && empty($ivd_cst_ship_key))) {
            unset($this->ivd_cst_ship_key);
        } else {
            $this->ivd_cst_ship_key = $ivd_cst_ship_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_prd_ptp_key(): ?string
    {
        return $this->ivd_prc_prd_ptp_key ?? null;
    }
    /**
     * Set ivd_prc_prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_prd_ptp_key(?string $ivd_prc_prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_prd_ptp_key) && !is_string($ivd_prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_prd_ptp_key, true), gettype($ivd_prc_prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_prd_ptp_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_prd_ptp_key) || (is_array($ivd_prc_prd_ptp_key) && empty($ivd_prc_prd_ptp_key))) {
            unset($this->ivd_prc_prd_ptp_key);
        } else {
            $this->ivd_prc_prd_ptp_key = $ivd_prc_prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cxa_key(): ?string
    {
        return $this->ivd_cxa_key ?? null;
    }
    /**
     * Set ivd_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_cxa_key(?string $ivd_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cxa_key) && !is_string($ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cxa_key, true), gettype($ivd_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cxa_key, true)), __LINE__);
        }
        if (is_null($ivd_cxa_key) || (is_array($ivd_cxa_key) && empty($ivd_cxa_key))) {
            unset($this->ivd_cxa_key);
        } else {
            $this->ivd_cxa_key = $ivd_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_src_key(): ?string
    {
        return $this->ivd_src_key ?? null;
    }
    /**
     * Set ivd_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_src_key(?string $ivd_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_src_key) && !is_string($ivd_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_src_key, true), gettype($ivd_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_src_key, true)), __LINE__);
        }
        if (is_null($ivd_src_key) || (is_array($ivd_src_key) && empty($ivd_src_key))) {
            unset($this->ivd_src_key);
        } else {
            $this->ivd_src_key = $ivd_src_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_type(): ?string
    {
        return $this->ivd_type ?? null;
    }
    /**
     * Set ivd_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_type(?string $ivd_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_type) && !is_string($ivd_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_type, true), gettype($ivd_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ivd_type) && mb_strlen((string) $ivd_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ivd_type)), __LINE__);
        }
        if (is_null($ivd_type) || (is_array($ivd_type) && empty($ivd_type))) {
            unset($this->ivd_type);
        } else {
            $this->ivd_type = $ivd_type;
        }
        
        return $this;
    }
    /**
     * Get ivd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_entity_key(): ?string
    {
        return $this->ivd_entity_key ?? null;
    }
    /**
     * Set ivd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_entity_key(?string $ivd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_entity_key) && !is_string($ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_entity_key, true), gettype($ivd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_entity_key, true)), __LINE__);
        }
        if (is_null($ivd_entity_key) || (is_array($ivd_entity_key) && empty($ivd_entity_key))) {
            unset($this->ivd_entity_key);
        } else {
            $this->ivd_entity_key = $ivd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_ivw_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ivw_key(): ?string
    {
        return $this->ivd_ivw_key ?? null;
    }
    /**
     * Set ivd_ivw_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ivw_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ivw_key(?string $ivd_ivw_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ivw_key) && !is_string($ivd_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ivw_key, true), gettype($ivd_ivw_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ivw_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ivw_key, true)), __LINE__);
        }
        if (is_null($ivd_ivw_key) || (is_array($ivd_ivw_key) && empty($ivd_ivw_key))) {
            unset($this->ivd_ivw_key);
        } else {
            $this->ivd_ivw_key = $ivd_ivw_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_odd_key(): ?string
    {
        return $this->ivd_odd_key ?? null;
    }
    /**
     * Set ivd_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_odd_key(?string $ivd_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_odd_key) && !is_string($ivd_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_odd_key, true), gettype($ivd_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_odd_key, true)), __LINE__);
        }
        if (is_null($ivd_odd_key) || (is_array($ivd_odd_key) && empty($ivd_odd_key))) {
            unset($this->ivd_odd_key);
        } else {
            $this->ivd_odd_key = $ivd_odd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_do_not_fulfill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_do_not_fulfill(): ?string
    {
        return $this->ivd_do_not_fulfill ?? null;
    }
    /**
     * Set ivd_do_not_fulfill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_do_not_fulfill
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_do_not_fulfill(?string $ivd_do_not_fulfill = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_do_not_fulfill) && !is_string($ivd_do_not_fulfill)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_do_not_fulfill, true), gettype($ivd_do_not_fulfill)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_do_not_fulfill) && $ivd_do_not_fulfill > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_do_not_fulfill, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_do_not_fulfill) && $ivd_do_not_fulfill < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_do_not_fulfill, true)), __LINE__);
        }
        if (is_null($ivd_do_not_fulfill) || (is_array($ivd_do_not_fulfill) && empty($ivd_do_not_fulfill))) {
            unset($this->ivd_do_not_fulfill);
        } else {
            $this->ivd_do_not_fulfill = $ivd_do_not_fulfill;
        }
        
        return $this;
    }
    /**
     * Get ivd_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pak_prd_key(): ?string
    {
        return $this->ivd_pak_prd_key ?? null;
    }
    /**
     * Set ivd_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_pak_prd_key(?string $ivd_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pak_prd_key) && !is_string($ivd_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pak_prd_key, true), gettype($ivd_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pak_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_pak_prd_key) || (is_array($ivd_pak_prd_key) && empty($ivd_pak_prd_key))) {
            unset($this->ivd_pak_prd_key);
        } else {
            $this->ivd_pak_prd_key = $ivd_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_ods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ods_key(): ?string
    {
        return $this->ivd_ods_key ?? null;
    }
    /**
     * Set ivd_ods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ods_key(?string $ivd_ods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ods_key) && !is_string($ivd_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ods_key, true), gettype($ivd_ods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ods_key, true)), __LINE__);
        }
        if (is_null($ivd_ods_key) || (is_array($ivd_ods_key) && empty($ivd_ods_key))) {
            unset($this->ivd_ods_key);
        } else {
            $this->ivd_ods_key = $ivd_ods_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cst_key(): ?string
    {
        return $this->ivd_cst_key ?? null;
    }
    /**
     * Set ivd_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_cst_key(?string $ivd_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cst_key) && !is_string($ivd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cst_key, true), gettype($ivd_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cst_key, true)), __LINE__);
        }
        if (is_null($ivd_cst_key) || (is_array($ivd_cst_key) && empty($ivd_cst_key))) {
            unset($this->ivd_cst_key);
        } else {
            $this->ivd_cst_key = $ivd_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_account_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_account_number(): ?string
    {
        return $this->ivd_account_number ?? null;
    }
    /**
     * Set ivd_account_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_account_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_account_number(?string $ivd_account_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_account_number) && !is_string($ivd_account_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_account_number, true), gettype($ivd_account_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ivd_account_number) && mb_strlen((string) $ivd_account_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ivd_account_number)), __LINE__);
        }
        if (is_null($ivd_account_number) || (is_array($ivd_account_number) && empty($ivd_account_number))) {
            unset($this->ivd_account_number);
        } else {
            $this->ivd_account_number = $ivd_account_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_ovr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ovr_key(): ?string
    {
        return $this->ivd_ovr_key ?? null;
    }
    /**
     * Set ivd_ovr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ovr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ovr_key(?string $ivd_ovr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ovr_key) && !is_string($ivd_ovr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ovr_key, true), gettype($ivd_ovr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ovr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ovr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ovr_key, true)), __LINE__);
        }
        if (is_null($ivd_ovr_key) || (is_array($ivd_ovr_key) && empty($ivd_ovr_key))) {
            unset($this->ivd_ovr_key);
        } else {
            $this->ivd_ovr_key = $ivd_ovr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_price_override_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_price_override_reason(): ?string
    {
        return $this->ivd_price_override_reason ?? null;
    }
    /**
     * Set ivd_price_override_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_price_override_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_price_override_reason(?string $ivd_price_override_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_price_override_reason) && !is_string($ivd_price_override_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_price_override_reason, true), gettype($ivd_price_override_reason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($ivd_price_override_reason) && mb_strlen((string) $ivd_price_override_reason) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $ivd_price_override_reason)), __LINE__);
        }
        if (is_null($ivd_price_override_reason) || (is_array($ivd_price_override_reason) && empty($ivd_price_override_reason))) {
            unset($this->ivd_price_override_reason);
        } else {
            $this->ivd_price_override_reason = $ivd_price_override_reason;
        }
        
        return $this;
    }
    /**
     * Get ivd_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pjt_key(): ?string
    {
        return $this->ivd_pjt_key ?? null;
    }
    /**
     * Set ivd_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_pjt_key(?string $ivd_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pjt_key) && !is_string($ivd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pjt_key, true), gettype($ivd_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pjt_key, true)), __LINE__);
        }
        if (is_null($ivd_pjt_key) || (is_array($ivd_pjt_key) && empty($ivd_pjt_key))) {
            unset($this->ivd_pjt_key);
        } else {
            $this->ivd_pjt_key = $ivd_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_backorder_email_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_backorder_email_sent_flag(): ?string
    {
        return $this->ivd_backorder_email_sent_flag ?? null;
    }
    /**
     * Set ivd_backorder_email_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_backorder_email_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_backorder_email_sent_flag(?string $ivd_backorder_email_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_backorder_email_sent_flag) && !is_string($ivd_backorder_email_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_backorder_email_sent_flag, true), gettype($ivd_backorder_email_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_backorder_email_sent_flag) && $ivd_backorder_email_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_backorder_email_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_backorder_email_sent_flag) && $ivd_backorder_email_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_backorder_email_sent_flag, true)), __LINE__);
        }
        if (is_null($ivd_backorder_email_sent_flag) || (is_array($ivd_backorder_email_sent_flag) && empty($ivd_backorder_email_sent_flag))) {
            unset($this->ivd_backorder_email_sent_flag);
        } else {
            $this->ivd_backorder_email_sent_flag = $ivd_backorder_email_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_process_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_process_qty(): ?float
    {
        return $this->ivd_process_qty ?? null;
    }
    /**
     * Set ivd_process_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_process_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_process_qty(?float $ivd_process_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_process_qty) && !(is_float($ivd_process_qty) || is_numeric($ivd_process_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_process_qty, true), gettype($ivd_process_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_process_qty) && mb_strlen(mb_substr((string) $ivd_process_qty, false !== mb_strpos((string) $ivd_process_qty, '.') ? mb_strpos((string) $ivd_process_qty, '.') + 1 : mb_strlen((string) $ivd_process_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_process_qty, true), mb_strlen(mb_substr((string) $ivd_process_qty, mb_strpos((string) $ivd_process_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_process_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_process_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_process_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_process_qty))), __LINE__);
        }
        if (is_null($ivd_process_qty) || (is_array($ivd_process_qty) && empty($ivd_process_qty))) {
            unset($this->ivd_process_qty);
        } else {
            $this->ivd_process_qty = $ivd_process_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_bun_prd_key(): ?string
    {
        return $this->ivd_bun_prd_key ?? null;
    }
    /**
     * Set ivd_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_bun_prd_key(?string $ivd_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_bun_prd_key) && !is_string($ivd_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_bun_prd_key, true), gettype($ivd_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_bun_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_bun_prd_key) || (is_array($ivd_bun_prd_key) && empty($ivd_bun_prd_key))) {
            unset($this->ivd_bun_prd_key);
        } else {
            $this->ivd_bun_prd_key = $ivd_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_count(): ?int
    {
        return $this->ivd_download_count ?? null;
    }
    /**
     * Set ivd_download_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_count(?int $ivd_download_count = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_count) && !(is_int($ivd_download_count) || ctype_digit($ivd_download_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_count, true), gettype($ivd_download_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_count) && $ivd_download_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_count) && $ivd_download_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_count, true)), __LINE__);
        }
        if (is_null($ivd_download_count) || (is_array($ivd_download_count) && empty($ivd_download_count))) {
            unset($this->ivd_download_count);
        } else {
            $this->ivd_download_count = $ivd_download_count;
        }
        
        return $this;
    }
    /**
     * Get ivd_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_eml_key(): ?string
    {
        return $this->ivd_eml_key ?? null;
    }
    /**
     * Set ivd_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_eml_key(?string $ivd_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_eml_key) && !is_string($ivd_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_eml_key, true), gettype($ivd_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_eml_key, true)), __LINE__);
        }
        if (is_null($ivd_eml_key) || (is_array($ivd_eml_key) && empty($ivd_eml_key))) {
            unset($this->ivd_eml_key);
        } else {
            $this->ivd_eml_key = $ivd_eml_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_package_grouping_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_package_grouping_key(): ?string
    {
        return $this->ivd_package_grouping_key ?? null;
    }
    /**
     * Set ivd_package_grouping_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_package_grouping_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_package_grouping_key(?string $ivd_package_grouping_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_package_grouping_key) && !is_string($ivd_package_grouping_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_package_grouping_key, true), gettype($ivd_package_grouping_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_package_grouping_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_package_grouping_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_package_grouping_key, true)), __LINE__);
        }
        if (is_null($ivd_package_grouping_key) || (is_array($ivd_package_grouping_key) && empty($ivd_package_grouping_key))) {
            unset($this->ivd_package_grouping_key);
        } else {
            $this->ivd_package_grouping_key = $ivd_package_grouping_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cdd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cdd_key(): ?string
    {
        return $this->ivd_cdd_key ?? null;
    }
    /**
     * Set ivd_cdd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cdd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_cdd_key(?string $ivd_cdd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cdd_key) && !is_string($ivd_cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cdd_key, true), gettype($ivd_cdd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cdd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cdd_key, true)), __LINE__);
        }
        if (is_null($ivd_cdd_key) || (is_array($ivd_cdd_key) && empty($ivd_cdd_key))) {
            unset($this->ivd_cdd_key);
        } else {
            $this->ivd_cdd_key = $ivd_cdd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_limit_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_limit_override(): ?int
    {
        return $this->ivd_download_limit_override ?? null;
    }
    /**
     * Set ivd_download_limit_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_limit_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_limit_override(?int $ivd_download_limit_override = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_limit_override) && !(is_int($ivd_download_limit_override) || ctype_digit($ivd_download_limit_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_limit_override, true), gettype($ivd_download_limit_override)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_limit_override) && $ivd_download_limit_override > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_limit_override, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_limit_override) && $ivd_download_limit_override < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_limit_override, true)), __LINE__);
        }
        if (is_null($ivd_download_limit_override) || (is_array($ivd_download_limit_override) && empty($ivd_download_limit_override))) {
            unset($this->ivd_download_limit_override);
        } else {
            $this->ivd_download_limit_override = $ivd_download_limit_override;
        }
        
        return $this;
    }
    /**
     * Get ivd_discount_program_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_discount_program_ivd_key(): ?string
    {
        return $this->ivd_discount_program_ivd_key ?? null;
    }
    /**
     * Set ivd_discount_program_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_discount_program_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_discount_program_ivd_key(?string $ivd_discount_program_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_discount_program_ivd_key) && !is_string($ivd_discount_program_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_discount_program_ivd_key, true), gettype($ivd_discount_program_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_discount_program_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_discount_program_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_discount_program_ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_discount_program_ivd_key) || (is_array($ivd_discount_program_ivd_key) && empty($ivd_discount_program_ivd_key))) {
            unset($this->ivd_discount_program_ivd_key);
        } else {
            $this->ivd_discount_program_ivd_key = $ivd_discount_program_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_distributed_liability_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_distributed_liability_flag(): ?string
    {
        return $this->ivd_distributed_liability_flag ?? null;
    }
    /**
     * Set ivd_distributed_liability_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_distributed_liability_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_distributed_liability_flag(?string $ivd_distributed_liability_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_distributed_liability_flag) && !is_string($ivd_distributed_liability_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_distributed_liability_flag, true), gettype($ivd_distributed_liability_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_distributed_liability_flag) && $ivd_distributed_liability_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_distributed_liability_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_distributed_liability_flag) && $ivd_distributed_liability_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_distributed_liability_flag, true)), __LINE__);
        }
        if (is_null($ivd_distributed_liability_flag) || (is_array($ivd_distributed_liability_flag) && empty($ivd_distributed_liability_flag))) {
            unset($this->ivd_distributed_liability_flag);
        } else {
            $this->ivd_distributed_liability_flag = $ivd_distributed_liability_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_days_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_days_override(): ?int
    {
        return $this->ivd_download_days_override ?? null;
    }
    /**
     * Set ivd_download_days_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_days_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_days_override(?int $ivd_download_days_override = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_days_override) && !(is_int($ivd_download_days_override) || ctype_digit($ivd_download_days_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_days_override, true), gettype($ivd_download_days_override)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_days_override) && $ivd_download_days_override > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_days_override, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_days_override) && $ivd_download_days_override < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_days_override, true)), __LINE__);
        }
        if (is_null($ivd_download_days_override) || (is_array($ivd_download_days_override) && empty($ivd_download_days_override))) {
            unset($this->ivd_download_days_override);
        } else {
            $this->ivd_download_days_override = $ivd_download_days_override;
        }
        
        return $this;
    }
    /**
     * Get ivd_gc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gc_number(): ?string
    {
        return $this->ivd_gc_number ?? null;
    }
    /**
     * Set ivd_gc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_gc_number(?string $ivd_gc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gc_number) && !is_string($ivd_gc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gc_number, true), gettype($ivd_gc_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ivd_gc_number) && mb_strlen((string) $ivd_gc_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ivd_gc_number)), __LINE__);
        }
        if (is_null($ivd_gc_number) || (is_array($ivd_gc_number) && empty($ivd_gc_number))) {
            unset($this->ivd_gc_number);
        } else {
            $this->ivd_gc_number = $ivd_gc_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_cdt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cdt_key(): ?string
    {
        return $this->ivd_cdt_key ?? null;
    }
    /**
     * Set ivd_cdt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cdt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_cdt_key(?string $ivd_cdt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cdt_key) && !is_string($ivd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cdt_key, true), gettype($ivd_cdt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cdt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cdt_key, true)), __LINE__);
        }
        if (is_null($ivd_cdt_key) || (is_array($ivd_cdt_key) && empty($ivd_cdt_key))) {
            unset($this->ivd_cdt_key);
        } else {
            $this->ivd_cdt_key = $ivd_cdt_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_pro_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pro_key(): ?string
    {
        return $this->ivd_pro_key ?? null;
    }
    /**
     * Set ivd_pro_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pro_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_pro_key(?string $ivd_pro_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pro_key) && !is_string($ivd_pro_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pro_key, true), gettype($ivd_pro_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pro_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pro_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pro_key, true)), __LINE__);
        }
        if (is_null($ivd_pro_key) || (is_array($ivd_pro_key) && empty($ivd_pro_key))) {
            unset($this->ivd_pro_key);
        } else {
            $this->ivd_pro_key = $ivd_pro_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ivd_key(): ?string
    {
        return $this->ivd_ivd_key ?? null;
    }
    /**
     * Set ivd_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
     */
    public function setIvd_ivd_key(?string $ivd_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ivd_key) && !is_string($ivd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ivd_key, true), gettype($ivd_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_ivd_key) || (is_array($ivd_ivd_key) && empty($ivd_ivd_key))) {
            unset($this->ivd_ivd_key);
        } else {
            $this->ivd_ivd_key = $ivd_ivd_key;
        }
        
        return $this;
    }
}
