<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_currency_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Invoice_currency_DataObjectType extends AbstractStructBase
{
    /**
     * The cur_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cur_key = null;
    /**
     * The cur_code
     * Meta information extracted from the WSDL
     * - documentation: Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_code = null;
    /**
     * The cur_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_description = null;
    /**
     * The cur_symbol_prefix
     * Meta information extracted from the WSDL
     * - documentation: Symbol Prefix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_symbol_prefix = null;
    /**
     * The cur_symbol_suffix
     * Meta information extracted from the WSDL
     * - documentation: Symbol Suffix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_symbol_suffix = null;
    /**
     * The cur_negative_display
     * Meta information extracted from the WSDL
     * - documentation: Negative Display. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_negative_display = null;
    /**
     * The cur_separator
     * Meta information extracted from the WSDL
     * - documentation: Separator.This element has a default value of ','. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_separator = null;
    /**
     * The cur_accuracy
     * Meta information extracted from the WSDL
     * - documentation: Accuracy. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cur_accuracy = null;
    /**
     * The cur_calc_method
     * Meta information extracted from the WSDL
     * - documentation: Calculation Method.This element has a default value of 'multiply'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_calc_method = null;
    /**
     * The cur_unit
     * Meta information extracted from the WSDL
     * - documentation: Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_unit = null;
    /**
     * The cur_sub_unit
     * Meta information extracted from the WSDL
     * - documentation: Sub-unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_sub_unit = null;
    /**
     * The cur_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_add_user = null;
    /**
     * The cur_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_add_date = null;
    /**
     * The cur_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_change_user = null;
    /**
     * The cur_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_change_date = null;
    /**
     * The cur_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_delete_flag = null;
    /**
     * The cur_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cur_entity_key = null;
    /**
     * The cur_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cur_key_ext = null;
    /**
     * The cur_fraction_separator
     * Meta information extracted from the WSDL
     * - documentation: Fractional Separator.This element has a default value of '.'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cur_fraction_separator = null;
    /**
     * Constructor method for Invoice_currency_DataObjectType
     * @uses Invoice_currency_DataObjectType::setCur_key()
     * @uses Invoice_currency_DataObjectType::setCur_code()
     * @uses Invoice_currency_DataObjectType::setCur_description()
     * @uses Invoice_currency_DataObjectType::setCur_symbol_prefix()
     * @uses Invoice_currency_DataObjectType::setCur_symbol_suffix()
     * @uses Invoice_currency_DataObjectType::setCur_negative_display()
     * @uses Invoice_currency_DataObjectType::setCur_separator()
     * @uses Invoice_currency_DataObjectType::setCur_accuracy()
     * @uses Invoice_currency_DataObjectType::setCur_calc_method()
     * @uses Invoice_currency_DataObjectType::setCur_unit()
     * @uses Invoice_currency_DataObjectType::setCur_sub_unit()
     * @uses Invoice_currency_DataObjectType::setCur_add_user()
     * @uses Invoice_currency_DataObjectType::setCur_add_date()
     * @uses Invoice_currency_DataObjectType::setCur_change_user()
     * @uses Invoice_currency_DataObjectType::setCur_change_date()
     * @uses Invoice_currency_DataObjectType::setCur_delete_flag()
     * @uses Invoice_currency_DataObjectType::setCur_entity_key()
     * @uses Invoice_currency_DataObjectType::setCur_key_ext()
     * @uses Invoice_currency_DataObjectType::setCur_fraction_separator()
     * @param string $cur_key
     * @param string $cur_code
     * @param string $cur_description
     * @param string $cur_symbol_prefix
     * @param string $cur_symbol_suffix
     * @param string $cur_negative_display
     * @param string $cur_separator
     * @param int $cur_accuracy
     * @param string $cur_calc_method
     * @param string $cur_unit
     * @param string $cur_sub_unit
     * @param string $cur_add_user
     * @param string $cur_add_date
     * @param string $cur_change_user
     * @param string $cur_change_date
     * @param string $cur_delete_flag
     * @param string $cur_entity_key
     * @param string $cur_key_ext
     * @param string $cur_fraction_separator
     */
    public function __construct(?string $cur_key = null, ?string $cur_code = null, ?string $cur_description = null, ?string $cur_symbol_prefix = null, ?string $cur_symbol_suffix = null, ?string $cur_negative_display = null, ?string $cur_separator = null, ?int $cur_accuracy = null, ?string $cur_calc_method = null, ?string $cur_unit = null, ?string $cur_sub_unit = null, ?string $cur_add_user = null, ?string $cur_add_date = null, ?string $cur_change_user = null, ?string $cur_change_date = null, ?string $cur_delete_flag = null, ?string $cur_entity_key = null, ?string $cur_key_ext = null, ?string $cur_fraction_separator = null)
    {
        $this
            ->setCur_key($cur_key)
            ->setCur_code($cur_code)
            ->setCur_description($cur_description)
            ->setCur_symbol_prefix($cur_symbol_prefix)
            ->setCur_symbol_suffix($cur_symbol_suffix)
            ->setCur_negative_display($cur_negative_display)
            ->setCur_separator($cur_separator)
            ->setCur_accuracy($cur_accuracy)
            ->setCur_calc_method($cur_calc_method)
            ->setCur_unit($cur_unit)
            ->setCur_sub_unit($cur_sub_unit)
            ->setCur_add_user($cur_add_user)
            ->setCur_add_date($cur_add_date)
            ->setCur_change_user($cur_change_user)
            ->setCur_change_date($cur_change_date)
            ->setCur_delete_flag($cur_delete_flag)
            ->setCur_entity_key($cur_entity_key)
            ->setCur_key_ext($cur_key_ext)
            ->setCur_fraction_separator($cur_fraction_separator);
    }
    /**
     * Get cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_key(): ?string
    {
        return $this->cur_key ?? null;
    }
    /**
     * Set cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_key(?string $cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_key) && !is_string($cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_key, true), gettype($cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cur_key, true)), __LINE__);
        }
        if (is_null($cur_key) || (is_array($cur_key) && empty($cur_key))) {
            unset($this->cur_key);
        } else {
            $this->cur_key = $cur_key;
        }
        
        return $this;
    }
    /**
     * Get cur_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_code(): ?string
    {
        return $this->cur_code ?? null;
    }
    /**
     * Set cur_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_code(?string $cur_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_code) && !is_string($cur_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_code, true), gettype($cur_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cur_code) && mb_strlen((string) $cur_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cur_code)), __LINE__);
        }
        if (is_null($cur_code) || (is_array($cur_code) && empty($cur_code))) {
            unset($this->cur_code);
        } else {
            $this->cur_code = $cur_code;
        }
        
        return $this;
    }
    /**
     * Get cur_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_description(): ?string
    {
        return $this->cur_description ?? null;
    }
    /**
     * Set cur_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_description(?string $cur_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_description) && !is_string($cur_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_description, true), gettype($cur_description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cur_description) && mb_strlen((string) $cur_description) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cur_description)), __LINE__);
        }
        if (is_null($cur_description) || (is_array($cur_description) && empty($cur_description))) {
            unset($this->cur_description);
        } else {
            $this->cur_description = $cur_description;
        }
        
        return $this;
    }
    /**
     * Get cur_symbol_prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_symbol_prefix(): ?string
    {
        return $this->cur_symbol_prefix ?? null;
    }
    /**
     * Set cur_symbol_prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_symbol_prefix
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_symbol_prefix(?string $cur_symbol_prefix = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_symbol_prefix) && !is_string($cur_symbol_prefix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_symbol_prefix, true), gettype($cur_symbol_prefix)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cur_symbol_prefix) && mb_strlen((string) $cur_symbol_prefix) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cur_symbol_prefix)), __LINE__);
        }
        if (is_null($cur_symbol_prefix) || (is_array($cur_symbol_prefix) && empty($cur_symbol_prefix))) {
            unset($this->cur_symbol_prefix);
        } else {
            $this->cur_symbol_prefix = $cur_symbol_prefix;
        }
        
        return $this;
    }
    /**
     * Get cur_symbol_suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_symbol_suffix(): ?string
    {
        return $this->cur_symbol_suffix ?? null;
    }
    /**
     * Set cur_symbol_suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_symbol_suffix
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_symbol_suffix(?string $cur_symbol_suffix = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_symbol_suffix) && !is_string($cur_symbol_suffix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_symbol_suffix, true), gettype($cur_symbol_suffix)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cur_symbol_suffix) && mb_strlen((string) $cur_symbol_suffix) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cur_symbol_suffix)), __LINE__);
        }
        if (is_null($cur_symbol_suffix) || (is_array($cur_symbol_suffix) && empty($cur_symbol_suffix))) {
            unset($this->cur_symbol_suffix);
        } else {
            $this->cur_symbol_suffix = $cur_symbol_suffix;
        }
        
        return $this;
    }
    /**
     * Get cur_negative_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_negative_display(): ?string
    {
        return $this->cur_negative_display ?? null;
    }
    /**
     * Set cur_negative_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_negative_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_negative_display(?string $cur_negative_display = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_negative_display) && !is_string($cur_negative_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_negative_display, true), gettype($cur_negative_display)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($cur_negative_display) && mb_strlen((string) $cur_negative_display) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen((string) $cur_negative_display)), __LINE__);
        }
        if (is_null($cur_negative_display) || (is_array($cur_negative_display) && empty($cur_negative_display))) {
            unset($this->cur_negative_display);
        } else {
            $this->cur_negative_display = $cur_negative_display;
        }
        
        return $this;
    }
    /**
     * Get cur_separator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_separator(): ?string
    {
        return $this->cur_separator ?? null;
    }
    /**
     * Set cur_separator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_separator
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_separator(?string $cur_separator = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_separator) && !is_string($cur_separator)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_separator, true), gettype($cur_separator)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cur_separator) && mb_strlen((string) $cur_separator) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $cur_separator)), __LINE__);
        }
        if (is_null($cur_separator) || (is_array($cur_separator) && empty($cur_separator))) {
            unset($this->cur_separator);
        } else {
            $this->cur_separator = $cur_separator;
        }
        
        return $this;
    }
    /**
     * Get cur_accuracy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCur_accuracy(): ?int
    {
        return $this->cur_accuracy ?? null;
    }
    /**
     * Set cur_accuracy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cur_accuracy
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_accuracy(?int $cur_accuracy = null): self
    {
        // validation for constraint: int
        if (!is_null($cur_accuracy) && !(is_int($cur_accuracy) || ctype_digit($cur_accuracy))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cur_accuracy, true), gettype($cur_accuracy)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cur_accuracy) && $cur_accuracy > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cur_accuracy, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cur_accuracy) && $cur_accuracy < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cur_accuracy, true)), __LINE__);
        }
        if (is_null($cur_accuracy) || (is_array($cur_accuracy) && empty($cur_accuracy))) {
            unset($this->cur_accuracy);
        } else {
            $this->cur_accuracy = $cur_accuracy;
        }
        
        return $this;
    }
    /**
     * Get cur_calc_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_calc_method(): ?string
    {
        return $this->cur_calc_method ?? null;
    }
    /**
     * Set cur_calc_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_calc_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_calc_method(?string $cur_calc_method = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_calc_method) && !is_string($cur_calc_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_calc_method, true), gettype($cur_calc_method)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cur_calc_method) && mb_strlen((string) $cur_calc_method) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cur_calc_method)), __LINE__);
        }
        if (is_null($cur_calc_method) || (is_array($cur_calc_method) && empty($cur_calc_method))) {
            unset($this->cur_calc_method);
        } else {
            $this->cur_calc_method = $cur_calc_method;
        }
        
        return $this;
    }
    /**
     * Get cur_unit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_unit(): ?string
    {
        return $this->cur_unit ?? null;
    }
    /**
     * Set cur_unit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_unit
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_unit(?string $cur_unit = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_unit) && !is_string($cur_unit)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_unit, true), gettype($cur_unit)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cur_unit) && mb_strlen((string) $cur_unit) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cur_unit)), __LINE__);
        }
        if (is_null($cur_unit) || (is_array($cur_unit) && empty($cur_unit))) {
            unset($this->cur_unit);
        } else {
            $this->cur_unit = $cur_unit;
        }
        
        return $this;
    }
    /**
     * Get cur_sub_unit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_sub_unit(): ?string
    {
        return $this->cur_sub_unit ?? null;
    }
    /**
     * Set cur_sub_unit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_sub_unit
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_sub_unit(?string $cur_sub_unit = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_sub_unit) && !is_string($cur_sub_unit)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_sub_unit, true), gettype($cur_sub_unit)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cur_sub_unit) && mb_strlen((string) $cur_sub_unit) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cur_sub_unit)), __LINE__);
        }
        if (is_null($cur_sub_unit) || (is_array($cur_sub_unit) && empty($cur_sub_unit))) {
            unset($this->cur_sub_unit);
        } else {
            $this->cur_sub_unit = $cur_sub_unit;
        }
        
        return $this;
    }
    /**
     * Get cur_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_add_user(): ?string
    {
        return $this->cur_add_user ?? null;
    }
    /**
     * Set cur_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_add_user(?string $cur_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_add_user) && !is_string($cur_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_add_user, true), gettype($cur_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cur_add_user) && mb_strlen((string) $cur_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cur_add_user)), __LINE__);
        }
        if (is_null($cur_add_user) || (is_array($cur_add_user) && empty($cur_add_user))) {
            unset($this->cur_add_user);
        } else {
            $this->cur_add_user = $cur_add_user;
        }
        
        return $this;
    }
    /**
     * Get cur_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_add_date(): ?string
    {
        return $this->cur_add_date ?? null;
    }
    /**
     * Set cur_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_add_date(?string $cur_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_add_date) && !is_string($cur_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_add_date, true), gettype($cur_add_date)), __LINE__);
        }
        if (is_null($cur_add_date) || (is_array($cur_add_date) && empty($cur_add_date))) {
            unset($this->cur_add_date);
        } else {
            $this->cur_add_date = $cur_add_date;
        }
        
        return $this;
    }
    /**
     * Get cur_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_change_user(): ?string
    {
        return $this->cur_change_user ?? null;
    }
    /**
     * Set cur_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_change_user(?string $cur_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_change_user) && !is_string($cur_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_change_user, true), gettype($cur_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cur_change_user) && mb_strlen((string) $cur_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cur_change_user)), __LINE__);
        }
        if (is_null($cur_change_user) || (is_array($cur_change_user) && empty($cur_change_user))) {
            unset($this->cur_change_user);
        } else {
            $this->cur_change_user = $cur_change_user;
        }
        
        return $this;
    }
    /**
     * Get cur_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_change_date(): ?string
    {
        return $this->cur_change_date ?? null;
    }
    /**
     * Set cur_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_change_date(?string $cur_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_change_date) && !is_string($cur_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_change_date, true), gettype($cur_change_date)), __LINE__);
        }
        if (is_null($cur_change_date) || (is_array($cur_change_date) && empty($cur_change_date))) {
            unset($this->cur_change_date);
        } else {
            $this->cur_change_date = $cur_change_date;
        }
        
        return $this;
    }
    /**
     * Get cur_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_delete_flag(): ?string
    {
        return $this->cur_delete_flag ?? null;
    }
    /**
     * Set cur_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_delete_flag(?string $cur_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_delete_flag) && !is_string($cur_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_delete_flag, true), gettype($cur_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cur_delete_flag) && $cur_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cur_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cur_delete_flag) && $cur_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cur_delete_flag, true)), __LINE__);
        }
        if (is_null($cur_delete_flag) || (is_array($cur_delete_flag) && empty($cur_delete_flag))) {
            unset($this->cur_delete_flag);
        } else {
            $this->cur_delete_flag = $cur_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cur_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_entity_key(): ?string
    {
        return $this->cur_entity_key ?? null;
    }
    /**
     * Set cur_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_entity_key(?string $cur_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_entity_key) && !is_string($cur_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_entity_key, true), gettype($cur_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cur_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cur_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cur_entity_key, true)), __LINE__);
        }
        if (is_null($cur_entity_key) || (is_array($cur_entity_key) && empty($cur_entity_key))) {
            unset($this->cur_entity_key);
        } else {
            $this->cur_entity_key = $cur_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cur_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_key_ext(): ?string
    {
        return $this->cur_key_ext ?? null;
    }
    /**
     * Set cur_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_key_ext(?string $cur_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_key_ext) && !is_string($cur_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_key_ext, true), gettype($cur_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cur_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cur_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cur_key_ext, true)), __LINE__);
        }
        if (is_null($cur_key_ext) || (is_array($cur_key_ext) && empty($cur_key_ext))) {
            unset($this->cur_key_ext);
        } else {
            $this->cur_key_ext = $cur_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cur_fraction_separator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCur_fraction_separator(): ?string
    {
        return $this->cur_fraction_separator ?? null;
    }
    /**
     * Set cur_fraction_separator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cur_fraction_separator
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
     */
    public function setCur_fraction_separator(?string $cur_fraction_separator = null): self
    {
        // validation for constraint: string
        if (!is_null($cur_fraction_separator) && !is_string($cur_fraction_separator)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cur_fraction_separator, true), gettype($cur_fraction_separator)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cur_fraction_separator) && mb_strlen((string) $cur_fraction_separator) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $cur_fraction_separator)), __LINE__);
        }
        if (is_null($cur_fraction_separator) || (is_array($cur_fraction_separator) && empty($cur_fraction_separator))) {
            unset($this->cur_fraction_separator);
        } else {
            $this->cur_fraction_separator = $cur_fraction_separator;
        }
        
        return $this;
    }
}
