<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailingListSetting StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MailingListSetting extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $status;
    /**
     * The mailing_list_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mailing_list_key = null;
    /**
     * The mailing_list_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mailing_list_name = null;
    /**
     * The mailing_list_category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mailing_list_category = null;
    /**
     * The email_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $email_key = null;
    /**
     * The address_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $address_key = null;
    /**
     * The phone_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $phone_key = null;
    /**
     * The fax_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $fax_key = null;
    /**
     * Constructor method for MailingListSetting
     * @uses MailingListSetting::setStatus()
     * @uses MailingListSetting::setMailing_list_key()
     * @uses MailingListSetting::setMailing_list_name()
     * @uses MailingListSetting::setMailing_list_category()
     * @uses MailingListSetting::setEmail_key()
     * @uses MailingListSetting::setAddress_key()
     * @uses MailingListSetting::setPhone_key()
     * @uses MailingListSetting::setFax_key()
     * @param string $status
     * @param string $mailing_list_key
     * @param string $mailing_list_name
     * @param string $mailing_list_category
     * @param string $email_key
     * @param string $address_key
     * @param string $phone_key
     * @param string $fax_key
     */
    public function __construct(string $status, ?string $mailing_list_key = null, ?string $mailing_list_name = null, ?string $mailing_list_category = null, ?string $email_key = null, ?string $address_key = null, ?string $phone_key = null, ?string $fax_key = null)
    {
        $this
            ->setStatus($status)
            ->setMailing_list_key($mailing_list_key)
            ->setMailing_list_name($mailing_list_name)
            ->setMailing_list_category($mailing_list_category)
            ->setEmail_key($email_key)
            ->setAddress_key($address_key)
            ->setPhone_key($phone_key)
            ->setFax_key($fax_key);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MailingPerferenceStatus::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MailingPerferenceStatus::getValidValues()
     * @throws InvalidArgumentException
     * @param string $status
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setStatus(string $status): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\MailingPerferenceStatus::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\MailingPerferenceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\MailingPerferenceStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        
        return $this;
    }
    /**
     * Get mailing_list_key value
     * @return string|null
     */
    public function getMailing_list_key(): ?string
    {
        return $this->mailing_list_key;
    }
    /**
     * Set mailing_list_key value
     * @param string $mailing_list_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setMailing_list_key(?string $mailing_list_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mailing_list_key) && !is_string($mailing_list_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_list_key, true), gettype($mailing_list_key)), __LINE__);
        }
        $this->mailing_list_key = $mailing_list_key;
        
        return $this;
    }
    /**
     * Get mailing_list_name value
     * @return string|null
     */
    public function getMailing_list_name(): ?string
    {
        return $this->mailing_list_name;
    }
    /**
     * Set mailing_list_name value
     * @param string $mailing_list_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setMailing_list_name(?string $mailing_list_name = null): self
    {
        // validation for constraint: string
        if (!is_null($mailing_list_name) && !is_string($mailing_list_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_list_name, true), gettype($mailing_list_name)), __LINE__);
        }
        $this->mailing_list_name = $mailing_list_name;
        
        return $this;
    }
    /**
     * Get mailing_list_category value
     * @return string|null
     */
    public function getMailing_list_category(): ?string
    {
        return $this->mailing_list_category;
    }
    /**
     * Set mailing_list_category value
     * @param string $mailing_list_category
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setMailing_list_category(?string $mailing_list_category = null): self
    {
        // validation for constraint: string
        if (!is_null($mailing_list_category) && !is_string($mailing_list_category)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_list_category, true), gettype($mailing_list_category)), __LINE__);
        }
        $this->mailing_list_category = $mailing_list_category;
        
        return $this;
    }
    /**
     * Get email_key value
     * @return string|null
     */
    public function getEmail_key(): ?string
    {
        return $this->email_key;
    }
    /**
     * Set email_key value
     * @param string $email_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setEmail_key(?string $email_key = null): self
    {
        // validation for constraint: string
        if (!is_null($email_key) && !is_string($email_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_key, true), gettype($email_key)), __LINE__);
        }
        $this->email_key = $email_key;
        
        return $this;
    }
    /**
     * Get address_key value
     * @return string|null
     */
    public function getAddress_key(): ?string
    {
        return $this->address_key;
    }
    /**
     * Set address_key value
     * @param string $address_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setAddress_key(?string $address_key = null): self
    {
        // validation for constraint: string
        if (!is_null($address_key) && !is_string($address_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address_key, true), gettype($address_key)), __LINE__);
        }
        $this->address_key = $address_key;
        
        return $this;
    }
    /**
     * Get phone_key value
     * @return string|null
     */
    public function getPhone_key(): ?string
    {
        return $this->phone_key;
    }
    /**
     * Set phone_key value
     * @param string $phone_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setPhone_key(?string $phone_key = null): self
    {
        // validation for constraint: string
        if (!is_null($phone_key) && !is_string($phone_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_key, true), gettype($phone_key)), __LINE__);
        }
        $this->phone_key = $phone_key;
        
        return $this;
    }
    /**
     * Get fax_key value
     * @return string|null
     */
    public function getFax_key(): ?string
    {
        return $this->fax_key;
    }
    /**
     * Set fax_key value
     * @param string $fax_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
     */
    public function setFax_key(?string $fax_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_key) && !is_string($fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_key, true), gettype($fax_key)), __LINE__);
        }
        $this->fax_key = $fax_key;
        
        return $this;
    }
}
