<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Association_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Association_DataObjectType extends AbstractStructBase
{
    /**
     * The asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_code = null;
    /**
     * The asn_name
     * Meta information extracted from the WSDL
     * - documentation: Association Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_name = null;
    /**
     * The asn_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_add_date = null;
    /**
     * The asn_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_add_user = null;
    /**
     * The asn_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_change_date = null;
    /**
     * The asn_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_change_user = null;
    /**
     * The asn_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_delete_flag = null;
    /**
     * The asn_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asn_key = null;
    /**
     * The asn_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asn_key_ext = null;
    /**
     * The asn_calendar_flag
     * Meta information extracted from the WSDL
     * - documentation: calendar year. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_calendar_flag = null;
    /**
     * The asn_membership_start_month
     * Meta information extracted from the WSDL
     * - documentation: start month. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_start_month = null;
    /**
     * The asn_membership_start_day
     * Meta information extracted from the WSDL
     * - documentation: start day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_start_day = null;
    /**
     * The asn_membership_sell_next_year_after_month
     * Meta information extracted from the WSDL
     * - documentation: sell for next year after month. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_sell_next_year_after_month = null;
    /**
     * The asn_membership_sell_next_year_after_day
     * Meta information extracted from the WSDL
     * - documentation: sell for next year after day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_sell_next_year_after_day = null;
    /**
     * The asn_membership_grace_period
     * Meta information extracted from the WSDL
     * - documentation: grace period. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_membership_grace_period = null;
    /**
     * The asn_membership_grace_length
     * Meta information extracted from the WSDL
     * - documentation: grace period length. This field has this Input Mask: 999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_grace_length = null;
    /**
     * The asn_membership_next_month_after_day
     * Meta information extracted from the WSDL
     * - documentation: sell next month after day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_membership_next_month_after_day = null;
    /**
     * The asn_update_date_when
     * Meta information extracted from the WSDL
     * - documentation: Update Date When. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_update_date_when = null;
    /**
     * The asn_percent_paid
     * Meta information extracted from the WSDL
     * - documentation: Percent Paid. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asn_percent_paid = null;
    /**
     * The asn_invoice_type
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_invoice_type = null;
    /**
     * The asn_set_on_paid_date_flag
     * Meta information extracted from the WSDL
     * - documentation: Set Dates Based on Payment Dat. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_set_on_paid_date_flag = null;
    /**
     * The asn_flip_customer_member_flag
     * Meta information extracted from the WSDL
     * - documentation: Set Customer Member Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asn_flip_customer_member_flag = null;
    /**
     * The asn_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asn_entity_key = null;
    /**
     * Constructor method for mb_membership_Association_DataObjectType
     * @uses Mb_membership_Association_DataObjectType::setAsn_code()
     * @uses Mb_membership_Association_DataObjectType::setAsn_name()
     * @uses Mb_membership_Association_DataObjectType::setAsn_add_date()
     * @uses Mb_membership_Association_DataObjectType::setAsn_add_user()
     * @uses Mb_membership_Association_DataObjectType::setAsn_change_date()
     * @uses Mb_membership_Association_DataObjectType::setAsn_change_user()
     * @uses Mb_membership_Association_DataObjectType::setAsn_delete_flag()
     * @uses Mb_membership_Association_DataObjectType::setAsn_key()
     * @uses Mb_membership_Association_DataObjectType::setAsn_key_ext()
     * @uses Mb_membership_Association_DataObjectType::setAsn_calendar_flag()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_start_month()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_start_day()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_sell_next_year_after_month()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_sell_next_year_after_day()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_grace_period()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_grace_length()
     * @uses Mb_membership_Association_DataObjectType::setAsn_membership_next_month_after_day()
     * @uses Mb_membership_Association_DataObjectType::setAsn_update_date_when()
     * @uses Mb_membership_Association_DataObjectType::setAsn_percent_paid()
     * @uses Mb_membership_Association_DataObjectType::setAsn_invoice_type()
     * @uses Mb_membership_Association_DataObjectType::setAsn_set_on_paid_date_flag()
     * @uses Mb_membership_Association_DataObjectType::setAsn_flip_customer_member_flag()
     * @uses Mb_membership_Association_DataObjectType::setAsn_entity_key()
     * @param string $asn_code
     * @param string $asn_name
     * @param string $asn_add_date
     * @param string $asn_add_user
     * @param string $asn_change_date
     * @param string $asn_change_user
     * @param string $asn_delete_flag
     * @param string $asn_key
     * @param string $asn_key_ext
     * @param string $asn_calendar_flag
     * @param int $asn_membership_start_month
     * @param int $asn_membership_start_day
     * @param int $asn_membership_sell_next_year_after_month
     * @param int $asn_membership_sell_next_year_after_day
     * @param string $asn_membership_grace_period
     * @param int $asn_membership_grace_length
     * @param int $asn_membership_next_month_after_day
     * @param string $asn_update_date_when
     * @param int $asn_percent_paid
     * @param string $asn_invoice_type
     * @param string $asn_set_on_paid_date_flag
     * @param string $asn_flip_customer_member_flag
     * @param string $asn_entity_key
     */
    public function __construct(?string $asn_code = null, ?string $asn_name = null, ?string $asn_add_date = null, ?string $asn_add_user = null, ?string $asn_change_date = null, ?string $asn_change_user = null, ?string $asn_delete_flag = null, ?string $asn_key = null, ?string $asn_key_ext = null, ?string $asn_calendar_flag = null, ?int $asn_membership_start_month = null, ?int $asn_membership_start_day = null, ?int $asn_membership_sell_next_year_after_month = null, ?int $asn_membership_sell_next_year_after_day = null, ?string $asn_membership_grace_period = null, ?int $asn_membership_grace_length = null, ?int $asn_membership_next_month_after_day = null, ?string $asn_update_date_when = null, ?int $asn_percent_paid = null, ?string $asn_invoice_type = null, ?string $asn_set_on_paid_date_flag = null, ?string $asn_flip_customer_member_flag = null, ?string $asn_entity_key = null)
    {
        $this
            ->setAsn_code($asn_code)
            ->setAsn_name($asn_name)
            ->setAsn_add_date($asn_add_date)
            ->setAsn_add_user($asn_add_user)
            ->setAsn_change_date($asn_change_date)
            ->setAsn_change_user($asn_change_user)
            ->setAsn_delete_flag($asn_delete_flag)
            ->setAsn_key($asn_key)
            ->setAsn_key_ext($asn_key_ext)
            ->setAsn_calendar_flag($asn_calendar_flag)
            ->setAsn_membership_start_month($asn_membership_start_month)
            ->setAsn_membership_start_day($asn_membership_start_day)
            ->setAsn_membership_sell_next_year_after_month($asn_membership_sell_next_year_after_month)
            ->setAsn_membership_sell_next_year_after_day($asn_membership_sell_next_year_after_day)
            ->setAsn_membership_grace_period($asn_membership_grace_period)
            ->setAsn_membership_grace_length($asn_membership_grace_length)
            ->setAsn_membership_next_month_after_day($asn_membership_next_month_after_day)
            ->setAsn_update_date_when($asn_update_date_when)
            ->setAsn_percent_paid($asn_percent_paid)
            ->setAsn_invoice_type($asn_invoice_type)
            ->setAsn_set_on_paid_date_flag($asn_set_on_paid_date_flag)
            ->setAsn_flip_customer_member_flag($asn_flip_customer_member_flag)
            ->setAsn_entity_key($asn_entity_key);
    }
    /**
     * Get asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_code(): ?string
    {
        return $this->asn_code ?? null;
    }
    /**
     * Set asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_code(?string $asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_code) && !is_string($asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_code, true), gettype($asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($asn_code) && mb_strlen((string) $asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $asn_code)), __LINE__);
        }
        if (is_null($asn_code) || (is_array($asn_code) && empty($asn_code))) {
            unset($this->asn_code);
        } else {
            $this->asn_code = $asn_code;
        }
        
        return $this;
    }
    /**
     * Get asn_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_name(): ?string
    {
        return $this->asn_name ?? null;
    }
    /**
     * Set asn_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_name(?string $asn_name = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_name) && !is_string($asn_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_name, true), gettype($asn_name)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($asn_name) && mb_strlen((string) $asn_name) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $asn_name)), __LINE__);
        }
        if (is_null($asn_name) || (is_array($asn_name) && empty($asn_name))) {
            unset($this->asn_name);
        } else {
            $this->asn_name = $asn_name;
        }
        
        return $this;
    }
    /**
     * Get asn_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_add_date(): ?string
    {
        return $this->asn_add_date ?? null;
    }
    /**
     * Set asn_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_add_date(?string $asn_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_add_date) && !is_string($asn_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_add_date, true), gettype($asn_add_date)), __LINE__);
        }
        if (is_null($asn_add_date) || (is_array($asn_add_date) && empty($asn_add_date))) {
            unset($this->asn_add_date);
        } else {
            $this->asn_add_date = $asn_add_date;
        }
        
        return $this;
    }
    /**
     * Get asn_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_add_user(): ?string
    {
        return $this->asn_add_user ?? null;
    }
    /**
     * Set asn_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_add_user(?string $asn_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_add_user) && !is_string($asn_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_add_user, true), gettype($asn_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asn_add_user) && mb_strlen((string) $asn_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asn_add_user)), __LINE__);
        }
        if (is_null($asn_add_user) || (is_array($asn_add_user) && empty($asn_add_user))) {
            unset($this->asn_add_user);
        } else {
            $this->asn_add_user = $asn_add_user;
        }
        
        return $this;
    }
    /**
     * Get asn_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_change_date(): ?string
    {
        return $this->asn_change_date ?? null;
    }
    /**
     * Set asn_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_change_date(?string $asn_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_change_date) && !is_string($asn_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_change_date, true), gettype($asn_change_date)), __LINE__);
        }
        if (is_null($asn_change_date) || (is_array($asn_change_date) && empty($asn_change_date))) {
            unset($this->asn_change_date);
        } else {
            $this->asn_change_date = $asn_change_date;
        }
        
        return $this;
    }
    /**
     * Get asn_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_change_user(): ?string
    {
        return $this->asn_change_user ?? null;
    }
    /**
     * Set asn_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_change_user(?string $asn_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_change_user) && !is_string($asn_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_change_user, true), gettype($asn_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asn_change_user) && mb_strlen((string) $asn_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asn_change_user)), __LINE__);
        }
        if (is_null($asn_change_user) || (is_array($asn_change_user) && empty($asn_change_user))) {
            unset($this->asn_change_user);
        } else {
            $this->asn_change_user = $asn_change_user;
        }
        
        return $this;
    }
    /**
     * Get asn_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_delete_flag(): ?string
    {
        return $this->asn_delete_flag ?? null;
    }
    /**
     * Set asn_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_delete_flag(?string $asn_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_delete_flag) && !is_string($asn_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_delete_flag, true), gettype($asn_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asn_delete_flag) && $asn_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asn_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asn_delete_flag) && $asn_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asn_delete_flag, true)), __LINE__);
        }
        if (is_null($asn_delete_flag) || (is_array($asn_delete_flag) && empty($asn_delete_flag))) {
            unset($this->asn_delete_flag);
        } else {
            $this->asn_delete_flag = $asn_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get asn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_key(): ?string
    {
        return $this->asn_key ?? null;
    }
    /**
     * Set asn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_key(?string $asn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_key) && !is_string($asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_key, true), gettype($asn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asn_key, true)), __LINE__);
        }
        if (is_null($asn_key) || (is_array($asn_key) && empty($asn_key))) {
            unset($this->asn_key);
        } else {
            $this->asn_key = $asn_key;
        }
        
        return $this;
    }
    /**
     * Get asn_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_key_ext(): ?string
    {
        return $this->asn_key_ext ?? null;
    }
    /**
     * Set asn_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_key_ext(?string $asn_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_key_ext) && !is_string($asn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_key_ext, true), gettype($asn_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asn_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asn_key_ext, true)), __LINE__);
        }
        if (is_null($asn_key_ext) || (is_array($asn_key_ext) && empty($asn_key_ext))) {
            unset($this->asn_key_ext);
        } else {
            $this->asn_key_ext = $asn_key_ext;
        }
        
        return $this;
    }
    /**
     * Get asn_calendar_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_calendar_flag(): ?string
    {
        return $this->asn_calendar_flag ?? null;
    }
    /**
     * Set asn_calendar_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_calendar_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_calendar_flag(?string $asn_calendar_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_calendar_flag) && !is_string($asn_calendar_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_calendar_flag, true), gettype($asn_calendar_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asn_calendar_flag) && $asn_calendar_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asn_calendar_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asn_calendar_flag) && $asn_calendar_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asn_calendar_flag, true)), __LINE__);
        }
        if (is_null($asn_calendar_flag) || (is_array($asn_calendar_flag) && empty($asn_calendar_flag))) {
            unset($this->asn_calendar_flag);
        } else {
            $this->asn_calendar_flag = $asn_calendar_flag;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_start_month value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_start_month(): ?int
    {
        return $this->asn_membership_start_month ?? null;
    }
    /**
     * Set asn_membership_start_month value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_start_month
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_start_month(?int $asn_membership_start_month = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_start_month) && !(is_int($asn_membership_start_month) || ctype_digit($asn_membership_start_month))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_start_month, true), gettype($asn_membership_start_month)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_start_month) && $asn_membership_start_month > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_start_month, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_start_month) && $asn_membership_start_month < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_start_month, true)), __LINE__);
        }
        if (is_null($asn_membership_start_month) || (is_array($asn_membership_start_month) && empty($asn_membership_start_month))) {
            unset($this->asn_membership_start_month);
        } else {
            $this->asn_membership_start_month = $asn_membership_start_month;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_start_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_start_day(): ?int
    {
        return $this->asn_membership_start_day ?? null;
    }
    /**
     * Set asn_membership_start_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_start_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_start_day(?int $asn_membership_start_day = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_start_day) && !(is_int($asn_membership_start_day) || ctype_digit($asn_membership_start_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_start_day, true), gettype($asn_membership_start_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_start_day) && $asn_membership_start_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_start_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_start_day) && $asn_membership_start_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_start_day, true)), __LINE__);
        }
        if (is_null($asn_membership_start_day) || (is_array($asn_membership_start_day) && empty($asn_membership_start_day))) {
            unset($this->asn_membership_start_day);
        } else {
            $this->asn_membership_start_day = $asn_membership_start_day;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_sell_next_year_after_month value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_sell_next_year_after_month(): ?int
    {
        return $this->asn_membership_sell_next_year_after_month ?? null;
    }
    /**
     * Set asn_membership_sell_next_year_after_month value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_sell_next_year_after_month
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_sell_next_year_after_month(?int $asn_membership_sell_next_year_after_month = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_sell_next_year_after_month) && !(is_int($asn_membership_sell_next_year_after_month) || ctype_digit($asn_membership_sell_next_year_after_month))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_sell_next_year_after_month, true), gettype($asn_membership_sell_next_year_after_month)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_sell_next_year_after_month) && $asn_membership_sell_next_year_after_month > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_sell_next_year_after_month, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_sell_next_year_after_month) && $asn_membership_sell_next_year_after_month < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_sell_next_year_after_month, true)), __LINE__);
        }
        if (is_null($asn_membership_sell_next_year_after_month) || (is_array($asn_membership_sell_next_year_after_month) && empty($asn_membership_sell_next_year_after_month))) {
            unset($this->asn_membership_sell_next_year_after_month);
        } else {
            $this->asn_membership_sell_next_year_after_month = $asn_membership_sell_next_year_after_month;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_sell_next_year_after_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_sell_next_year_after_day(): ?int
    {
        return $this->asn_membership_sell_next_year_after_day ?? null;
    }
    /**
     * Set asn_membership_sell_next_year_after_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_sell_next_year_after_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_sell_next_year_after_day(?int $asn_membership_sell_next_year_after_day = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_sell_next_year_after_day) && !(is_int($asn_membership_sell_next_year_after_day) || ctype_digit($asn_membership_sell_next_year_after_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_sell_next_year_after_day, true), gettype($asn_membership_sell_next_year_after_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_sell_next_year_after_day) && $asn_membership_sell_next_year_after_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_sell_next_year_after_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_sell_next_year_after_day) && $asn_membership_sell_next_year_after_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_sell_next_year_after_day, true)), __LINE__);
        }
        if (is_null($asn_membership_sell_next_year_after_day) || (is_array($asn_membership_sell_next_year_after_day) && empty($asn_membership_sell_next_year_after_day))) {
            unset($this->asn_membership_sell_next_year_after_day);
        } else {
            $this->asn_membership_sell_next_year_after_day = $asn_membership_sell_next_year_after_day;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_grace_period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_membership_grace_period(): ?string
    {
        return $this->asn_membership_grace_period ?? null;
    }
    /**
     * Set asn_membership_grace_period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_membership_grace_period
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_grace_period(?string $asn_membership_grace_period = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_membership_grace_period) && !is_string($asn_membership_grace_period)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_membership_grace_period, true), gettype($asn_membership_grace_period)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($asn_membership_grace_period) && mb_strlen((string) $asn_membership_grace_period) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $asn_membership_grace_period)), __LINE__);
        }
        if (is_null($asn_membership_grace_period) || (is_array($asn_membership_grace_period) && empty($asn_membership_grace_period))) {
            unset($this->asn_membership_grace_period);
        } else {
            $this->asn_membership_grace_period = $asn_membership_grace_period;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_grace_length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_grace_length(): ?int
    {
        return $this->asn_membership_grace_length ?? null;
    }
    /**
     * Set asn_membership_grace_length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_grace_length
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_grace_length(?int $asn_membership_grace_length = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_grace_length) && !(is_int($asn_membership_grace_length) || ctype_digit($asn_membership_grace_length))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_grace_length, true), gettype($asn_membership_grace_length)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_grace_length) && $asn_membership_grace_length > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_grace_length, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_grace_length) && $asn_membership_grace_length < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_grace_length, true)), __LINE__);
        }
        if (is_null($asn_membership_grace_length) || (is_array($asn_membership_grace_length) && empty($asn_membership_grace_length))) {
            unset($this->asn_membership_grace_length);
        } else {
            $this->asn_membership_grace_length = $asn_membership_grace_length;
        }
        
        return $this;
    }
    /**
     * Get asn_membership_next_month_after_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_membership_next_month_after_day(): ?int
    {
        return $this->asn_membership_next_month_after_day ?? null;
    }
    /**
     * Set asn_membership_next_month_after_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_membership_next_month_after_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_membership_next_month_after_day(?int $asn_membership_next_month_after_day = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_membership_next_month_after_day) && !(is_int($asn_membership_next_month_after_day) || ctype_digit($asn_membership_next_month_after_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_membership_next_month_after_day, true), gettype($asn_membership_next_month_after_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_membership_next_month_after_day) && $asn_membership_next_month_after_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_membership_next_month_after_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_membership_next_month_after_day) && $asn_membership_next_month_after_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_membership_next_month_after_day, true)), __LINE__);
        }
        if (is_null($asn_membership_next_month_after_day) || (is_array($asn_membership_next_month_after_day) && empty($asn_membership_next_month_after_day))) {
            unset($this->asn_membership_next_month_after_day);
        } else {
            $this->asn_membership_next_month_after_day = $asn_membership_next_month_after_day;
        }
        
        return $this;
    }
    /**
     * Get asn_update_date_when value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_update_date_when(): ?string
    {
        return $this->asn_update_date_when ?? null;
    }
    /**
     * Set asn_update_date_when value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_update_date_when
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_update_date_when(?string $asn_update_date_when = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_update_date_when) && !is_string($asn_update_date_when)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_update_date_when, true), gettype($asn_update_date_when)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($asn_update_date_when) && mb_strlen((string) $asn_update_date_when) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $asn_update_date_when)), __LINE__);
        }
        if (is_null($asn_update_date_when) || (is_array($asn_update_date_when) && empty($asn_update_date_when))) {
            unset($this->asn_update_date_when);
        } else {
            $this->asn_update_date_when = $asn_update_date_when;
        }
        
        return $this;
    }
    /**
     * Get asn_percent_paid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsn_percent_paid(): ?int
    {
        return $this->asn_percent_paid ?? null;
    }
    /**
     * Set asn_percent_paid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asn_percent_paid
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_percent_paid(?int $asn_percent_paid = null): self
    {
        // validation for constraint: int
        if (!is_null($asn_percent_paid) && !(is_int($asn_percent_paid) || ctype_digit($asn_percent_paid))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asn_percent_paid, true), gettype($asn_percent_paid)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asn_percent_paid) && $asn_percent_paid > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asn_percent_paid, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asn_percent_paid) && $asn_percent_paid < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asn_percent_paid, true)), __LINE__);
        }
        if (is_null($asn_percent_paid) || (is_array($asn_percent_paid) && empty($asn_percent_paid))) {
            unset($this->asn_percent_paid);
        } else {
            $this->asn_percent_paid = $asn_percent_paid;
        }
        
        return $this;
    }
    /**
     * Get asn_invoice_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_invoice_type(): ?string
    {
        return $this->asn_invoice_type ?? null;
    }
    /**
     * Set asn_invoice_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_invoice_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_invoice_type(?string $asn_invoice_type = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_invoice_type) && !is_string($asn_invoice_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_invoice_type, true), gettype($asn_invoice_type)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($asn_invoice_type) && mb_strlen((string) $asn_invoice_type) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $asn_invoice_type)), __LINE__);
        }
        if (is_null($asn_invoice_type) || (is_array($asn_invoice_type) && empty($asn_invoice_type))) {
            unset($this->asn_invoice_type);
        } else {
            $this->asn_invoice_type = $asn_invoice_type;
        }
        
        return $this;
    }
    /**
     * Get asn_set_on_paid_date_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_set_on_paid_date_flag(): ?string
    {
        return $this->asn_set_on_paid_date_flag ?? null;
    }
    /**
     * Set asn_set_on_paid_date_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_set_on_paid_date_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_set_on_paid_date_flag(?string $asn_set_on_paid_date_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_set_on_paid_date_flag) && !is_string($asn_set_on_paid_date_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_set_on_paid_date_flag, true), gettype($asn_set_on_paid_date_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asn_set_on_paid_date_flag) && $asn_set_on_paid_date_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asn_set_on_paid_date_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asn_set_on_paid_date_flag) && $asn_set_on_paid_date_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asn_set_on_paid_date_flag, true)), __LINE__);
        }
        if (is_null($asn_set_on_paid_date_flag) || (is_array($asn_set_on_paid_date_flag) && empty($asn_set_on_paid_date_flag))) {
            unset($this->asn_set_on_paid_date_flag);
        } else {
            $this->asn_set_on_paid_date_flag = $asn_set_on_paid_date_flag;
        }
        
        return $this;
    }
    /**
     * Get asn_flip_customer_member_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_flip_customer_member_flag(): ?string
    {
        return $this->asn_flip_customer_member_flag ?? null;
    }
    /**
     * Set asn_flip_customer_member_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_flip_customer_member_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_flip_customer_member_flag(?string $asn_flip_customer_member_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_flip_customer_member_flag) && !is_string($asn_flip_customer_member_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_flip_customer_member_flag, true), gettype($asn_flip_customer_member_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asn_flip_customer_member_flag) && $asn_flip_customer_member_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asn_flip_customer_member_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asn_flip_customer_member_flag) && $asn_flip_customer_member_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asn_flip_customer_member_flag, true)), __LINE__);
        }
        if (is_null($asn_flip_customer_member_flag) || (is_array($asn_flip_customer_member_flag) && empty($asn_flip_customer_member_flag))) {
            unset($this->asn_flip_customer_member_flag);
        } else {
            $this->asn_flip_customer_member_flag = $asn_flip_customer_member_flag;
        }
        
        return $this;
    }
    /**
     * Get asn_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsn_entity_key(): ?string
    {
        return $this->asn_entity_key ?? null;
    }
    /**
     * Set asn_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asn_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_DataObjectType
     */
    public function setAsn_entity_key(?string $asn_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asn_entity_key) && !is_string($asn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asn_entity_key, true), gettype($asn_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asn_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asn_entity_key, true)), __LINE__);
        }
        if (is_null($asn_entity_key) || (is_array($asn_entity_key) && empty($asn_entity_key))) {
            unset($this->asn_entity_key);
        } else {
            $this->asn_entity_key = $asn_entity_key;
        }
        
        return $this;
    }
}
