<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Association_Package_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Association_Package_DataObjectType extends AbstractStructBase
{
    /**
     * The asp_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_key = null;
    /**
     * The asp_asn_key
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_asn_key = null;
    /**
     * The asp_mbt_key
     * Meta information extracted from the WSDL
     * - documentation: Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_mbt_key = null;
    /**
     * The asp_mbs_key
     * Meta information extracted from the WSDL
     * - documentation: Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_mbs_key = null;
    /**
     * The asp_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: New Member Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_pak_prd_key = null;
    /**
     * The asp_pak_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_pak_prd_renewal_key = null;
    /**
     * The asp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_add_user = null;
    /**
     * The asp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_add_date = null;
    /**
     * The asp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_change_user = null;
    /**
     * The asp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_change_date = null;
    /**
     * The asp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_delete_flag = null;
    /**
     * The asp_chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_chp_cst_key = null;
    /**
     * The asp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asp_entity_key = null;
    /**
     * The asp_optional_item_count
     * Meta information extracted from the WSDL
     * - documentation: Optional Item Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $asp_optional_item_count = null;
    /**
     * The asp_split_invoice
     * Meta information extracted from the WSDL
     * - documentation: Split Invoice. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asp_split_invoice = null;
    /**
     * Constructor method for mb_membership_Association_Package_DataObjectType
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_asn_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_mbt_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_mbs_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_pak_prd_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_pak_prd_renewal_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_add_user()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_add_date()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_change_user()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_change_date()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_delete_flag()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_chp_cst_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_entity_key()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_optional_item_count()
     * @uses Mb_membership_Association_Package_DataObjectType::setAsp_split_invoice()
     * @param string $asp_key
     * @param string $asp_asn_key
     * @param string $asp_mbt_key
     * @param string $asp_mbs_key
     * @param string $asp_pak_prd_key
     * @param string $asp_pak_prd_renewal_key
     * @param string $asp_add_user
     * @param string $asp_add_date
     * @param string $asp_change_user
     * @param string $asp_change_date
     * @param string $asp_delete_flag
     * @param string $asp_chp_cst_key
     * @param string $asp_entity_key
     * @param int $asp_optional_item_count
     * @param string $asp_split_invoice
     */
    public function __construct(?string $asp_key = null, ?string $asp_asn_key = null, ?string $asp_mbt_key = null, ?string $asp_mbs_key = null, ?string $asp_pak_prd_key = null, ?string $asp_pak_prd_renewal_key = null, ?string $asp_add_user = null, ?string $asp_add_date = null, ?string $asp_change_user = null, ?string $asp_change_date = null, ?string $asp_delete_flag = null, ?string $asp_chp_cst_key = null, ?string $asp_entity_key = null, ?int $asp_optional_item_count = null, ?string $asp_split_invoice = null)
    {
        $this
            ->setAsp_key($asp_key)
            ->setAsp_asn_key($asp_asn_key)
            ->setAsp_mbt_key($asp_mbt_key)
            ->setAsp_mbs_key($asp_mbs_key)
            ->setAsp_pak_prd_key($asp_pak_prd_key)
            ->setAsp_pak_prd_renewal_key($asp_pak_prd_renewal_key)
            ->setAsp_add_user($asp_add_user)
            ->setAsp_add_date($asp_add_date)
            ->setAsp_change_user($asp_change_user)
            ->setAsp_change_date($asp_change_date)
            ->setAsp_delete_flag($asp_delete_flag)
            ->setAsp_chp_cst_key($asp_chp_cst_key)
            ->setAsp_entity_key($asp_entity_key)
            ->setAsp_optional_item_count($asp_optional_item_count)
            ->setAsp_split_invoice($asp_split_invoice);
    }
    /**
     * Get asp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_key(): ?string
    {
        return $this->asp_key ?? null;
    }
    /**
     * Set asp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_key(?string $asp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_key) && !is_string($asp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_key, true), gettype($asp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_key, true)), __LINE__);
        }
        if (is_null($asp_key) || (is_array($asp_key) && empty($asp_key))) {
            unset($this->asp_key);
        } else {
            $this->asp_key = $asp_key;
        }
        
        return $this;
    }
    /**
     * Get asp_asn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_asn_key(): ?string
    {
        return $this->asp_asn_key ?? null;
    }
    /**
     * Set asp_asn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_asn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_asn_key(?string $asp_asn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_asn_key) && !is_string($asp_asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_asn_key, true), gettype($asp_asn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_asn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_asn_key, true)), __LINE__);
        }
        if (is_null($asp_asn_key) || (is_array($asp_asn_key) && empty($asp_asn_key))) {
            unset($this->asp_asn_key);
        } else {
            $this->asp_asn_key = $asp_asn_key;
        }
        
        return $this;
    }
    /**
     * Get asp_mbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_mbt_key(): ?string
    {
        return $this->asp_mbt_key ?? null;
    }
    /**
     * Set asp_mbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_mbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_mbt_key(?string $asp_mbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_mbt_key) && !is_string($asp_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_mbt_key, true), gettype($asp_mbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_mbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_mbt_key, true)), __LINE__);
        }
        if (is_null($asp_mbt_key) || (is_array($asp_mbt_key) && empty($asp_mbt_key))) {
            unset($this->asp_mbt_key);
        } else {
            $this->asp_mbt_key = $asp_mbt_key;
        }
        
        return $this;
    }
    /**
     * Get asp_mbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_mbs_key(): ?string
    {
        return $this->asp_mbs_key ?? null;
    }
    /**
     * Set asp_mbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_mbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_mbs_key(?string $asp_mbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_mbs_key) && !is_string($asp_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_mbs_key, true), gettype($asp_mbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_mbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_mbs_key, true)), __LINE__);
        }
        if (is_null($asp_mbs_key) || (is_array($asp_mbs_key) && empty($asp_mbs_key))) {
            unset($this->asp_mbs_key);
        } else {
            $this->asp_mbs_key = $asp_mbs_key;
        }
        
        return $this;
    }
    /**
     * Get asp_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_pak_prd_key(): ?string
    {
        return $this->asp_pak_prd_key ?? null;
    }
    /**
     * Set asp_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_pak_prd_key(?string $asp_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_pak_prd_key) && !is_string($asp_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_pak_prd_key, true), gettype($asp_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_pak_prd_key, true)), __LINE__);
        }
        if (is_null($asp_pak_prd_key) || (is_array($asp_pak_prd_key) && empty($asp_pak_prd_key))) {
            unset($this->asp_pak_prd_key);
        } else {
            $this->asp_pak_prd_key = $asp_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get asp_pak_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_pak_prd_renewal_key(): ?string
    {
        return $this->asp_pak_prd_renewal_key ?? null;
    }
    /**
     * Set asp_pak_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_pak_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_pak_prd_renewal_key(?string $asp_pak_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_pak_prd_renewal_key) && !is_string($asp_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_pak_prd_renewal_key, true), gettype($asp_pak_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_pak_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_pak_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($asp_pak_prd_renewal_key) || (is_array($asp_pak_prd_renewal_key) && empty($asp_pak_prd_renewal_key))) {
            unset($this->asp_pak_prd_renewal_key);
        } else {
            $this->asp_pak_prd_renewal_key = $asp_pak_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get asp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_add_user(): ?string
    {
        return $this->asp_add_user ?? null;
    }
    /**
     * Set asp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_add_user(?string $asp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_add_user) && !is_string($asp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_add_user, true), gettype($asp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asp_add_user) && mb_strlen((string) $asp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asp_add_user)), __LINE__);
        }
        if (is_null($asp_add_user) || (is_array($asp_add_user) && empty($asp_add_user))) {
            unset($this->asp_add_user);
        } else {
            $this->asp_add_user = $asp_add_user;
        }
        
        return $this;
    }
    /**
     * Get asp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_add_date(): ?string
    {
        return $this->asp_add_date ?? null;
    }
    /**
     * Set asp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_add_date(?string $asp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_add_date) && !is_string($asp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_add_date, true), gettype($asp_add_date)), __LINE__);
        }
        if (is_null($asp_add_date) || (is_array($asp_add_date) && empty($asp_add_date))) {
            unset($this->asp_add_date);
        } else {
            $this->asp_add_date = $asp_add_date;
        }
        
        return $this;
    }
    /**
     * Get asp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_change_user(): ?string
    {
        return $this->asp_change_user ?? null;
    }
    /**
     * Set asp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_change_user(?string $asp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_change_user) && !is_string($asp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_change_user, true), gettype($asp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asp_change_user) && mb_strlen((string) $asp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asp_change_user)), __LINE__);
        }
        if (is_null($asp_change_user) || (is_array($asp_change_user) && empty($asp_change_user))) {
            unset($this->asp_change_user);
        } else {
            $this->asp_change_user = $asp_change_user;
        }
        
        return $this;
    }
    /**
     * Get asp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_change_date(): ?string
    {
        return $this->asp_change_date ?? null;
    }
    /**
     * Set asp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_change_date(?string $asp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_change_date) && !is_string($asp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_change_date, true), gettype($asp_change_date)), __LINE__);
        }
        if (is_null($asp_change_date) || (is_array($asp_change_date) && empty($asp_change_date))) {
            unset($this->asp_change_date);
        } else {
            $this->asp_change_date = $asp_change_date;
        }
        
        return $this;
    }
    /**
     * Get asp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_delete_flag(): ?string
    {
        return $this->asp_delete_flag ?? null;
    }
    /**
     * Set asp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_delete_flag(?string $asp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_delete_flag) && !is_string($asp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_delete_flag, true), gettype($asp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asp_delete_flag) && $asp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asp_delete_flag) && $asp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asp_delete_flag, true)), __LINE__);
        }
        if (is_null($asp_delete_flag) || (is_array($asp_delete_flag) && empty($asp_delete_flag))) {
            unset($this->asp_delete_flag);
        } else {
            $this->asp_delete_flag = $asp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get asp_chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_chp_cst_key(): ?string
    {
        return $this->asp_chp_cst_key ?? null;
    }
    /**
     * Set asp_chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_chp_cst_key(?string $asp_chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_chp_cst_key) && !is_string($asp_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_chp_cst_key, true), gettype($asp_chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_chp_cst_key, true)), __LINE__);
        }
        if (is_null($asp_chp_cst_key) || (is_array($asp_chp_cst_key) && empty($asp_chp_cst_key))) {
            unset($this->asp_chp_cst_key);
        } else {
            $this->asp_chp_cst_key = $asp_chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get asp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_entity_key(): ?string
    {
        return $this->asp_entity_key ?? null;
    }
    /**
     * Set asp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_entity_key(?string $asp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_entity_key) && !is_string($asp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_entity_key, true), gettype($asp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asp_entity_key, true)), __LINE__);
        }
        if (is_null($asp_entity_key) || (is_array($asp_entity_key) && empty($asp_entity_key))) {
            unset($this->asp_entity_key);
        } else {
            $this->asp_entity_key = $asp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get asp_optional_item_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsp_optional_item_count(): ?int
    {
        return $this->asp_optional_item_count ?? null;
    }
    /**
     * Set asp_optional_item_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asp_optional_item_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_optional_item_count(?int $asp_optional_item_count = null): self
    {
        // validation for constraint: int
        if (!is_null($asp_optional_item_count) && !(is_int($asp_optional_item_count) || ctype_digit($asp_optional_item_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asp_optional_item_count, true), gettype($asp_optional_item_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($asp_optional_item_count) && $asp_optional_item_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($asp_optional_item_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($asp_optional_item_count) && $asp_optional_item_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($asp_optional_item_count, true)), __LINE__);
        }
        if (is_null($asp_optional_item_count) || (is_array($asp_optional_item_count) && empty($asp_optional_item_count))) {
            unset($this->asp_optional_item_count);
        } else {
            $this->asp_optional_item_count = $asp_optional_item_count;
        }
        
        return $this;
    }
    /**
     * Get asp_split_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsp_split_invoice(): ?string
    {
        return $this->asp_split_invoice ?? null;
    }
    /**
     * Set asp_split_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asp_split_invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Association_Package_DataObjectType
     */
    public function setAsp_split_invoice(?string $asp_split_invoice = null): self
    {
        // validation for constraint: string
        if (!is_null($asp_split_invoice) && !is_string($asp_split_invoice)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asp_split_invoice, true), gettype($asp_split_invoice)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asp_split_invoice) && $asp_split_invoice > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asp_split_invoice, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asp_split_invoice) && $asp_split_invoice < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asp_split_invoice, true)), __LINE__);
        }
        if (is_null($asp_split_invoice) || (is_array($asp_split_invoice) && empty($asp_split_invoice))) {
            unset($this->asp_split_invoice);
        } else {
            $this->asp_split_invoice = $asp_split_invoice;
        }
        
        return $this;
    }
}
