<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Bundle_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Bundle_DataObjectType extends AbstractStructBase
{
    /**
     * The bun_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_add_user = null;
    /**
     * The bun_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_add_date = null;
    /**
     * The bun_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_change_user = null;
    /**
     * The bun_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_change_date = null;
    /**
     * The bun_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_delete_flag = null;
    /**
     * The bun_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bun_entity_key = null;
    /**
     * The bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bun_prd_key = null;
    /**
     * The bun_supress_products_on_invoice
     * Meta information extracted from the WSDL
     * - documentation: supress products. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_supress_products_on_invoice = null;
    /**
     * The bun_hide_price_on_invoice
     * Meta information extracted from the WSDL
     * - documentation: hide price?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_hide_price_on_invoice = null;
    /**
     * The bun_bun_key_renewal
     * Meta information extracted from the WSDL
     * - documentation: renewal key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bun_bun_key_renewal = null;
    /**
     * The bun_prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bun_prd_key_ext = null;
    /**
     * The bun_sell_online_flag
     * Meta information extracted from the WSDL
     * - documentation: Sell Online?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bun_sell_online_flag = null;
    /**
     * Constructor method for mb_membership_Bundle_DataObjectType
     * @uses Mb_membership_Bundle_DataObjectType::setBun_add_user()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_add_date()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_change_user()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_change_date()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_delete_flag()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_entity_key()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_prd_key()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_supress_products_on_invoice()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_hide_price_on_invoice()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_bun_key_renewal()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_prd_key_ext()
     * @uses Mb_membership_Bundle_DataObjectType::setBun_sell_online_flag()
     * @param string $bun_add_user
     * @param string $bun_add_date
     * @param string $bun_change_user
     * @param string $bun_change_date
     * @param string $bun_delete_flag
     * @param string $bun_entity_key
     * @param string $bun_prd_key
     * @param string $bun_supress_products_on_invoice
     * @param string $bun_hide_price_on_invoice
     * @param string $bun_bun_key_renewal
     * @param string $bun_prd_key_ext
     * @param string $bun_sell_online_flag
     */
    public function __construct(?string $bun_add_user = null, ?string $bun_add_date = null, ?string $bun_change_user = null, ?string $bun_change_date = null, ?string $bun_delete_flag = null, ?string $bun_entity_key = null, ?string $bun_prd_key = null, ?string $bun_supress_products_on_invoice = null, ?string $bun_hide_price_on_invoice = null, ?string $bun_bun_key_renewal = null, ?string $bun_prd_key_ext = null, ?string $bun_sell_online_flag = null)
    {
        $this
            ->setBun_add_user($bun_add_user)
            ->setBun_add_date($bun_add_date)
            ->setBun_change_user($bun_change_user)
            ->setBun_change_date($bun_change_date)
            ->setBun_delete_flag($bun_delete_flag)
            ->setBun_entity_key($bun_entity_key)
            ->setBun_prd_key($bun_prd_key)
            ->setBun_supress_products_on_invoice($bun_supress_products_on_invoice)
            ->setBun_hide_price_on_invoice($bun_hide_price_on_invoice)
            ->setBun_bun_key_renewal($bun_bun_key_renewal)
            ->setBun_prd_key_ext($bun_prd_key_ext)
            ->setBun_sell_online_flag($bun_sell_online_flag);
    }
    /**
     * Get bun_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_add_user(): ?string
    {
        return $this->bun_add_user ?? null;
    }
    /**
     * Set bun_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_add_user(?string $bun_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_add_user) && !is_string($bun_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_add_user, true), gettype($bun_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bun_add_user) && mb_strlen((string) $bun_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bun_add_user)), __LINE__);
        }
        if (is_null($bun_add_user) || (is_array($bun_add_user) && empty($bun_add_user))) {
            unset($this->bun_add_user);
        } else {
            $this->bun_add_user = $bun_add_user;
        }
        
        return $this;
    }
    /**
     * Get bun_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_add_date(): ?string
    {
        return $this->bun_add_date ?? null;
    }
    /**
     * Set bun_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_add_date(?string $bun_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_add_date) && !is_string($bun_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_add_date, true), gettype($bun_add_date)), __LINE__);
        }
        if (is_null($bun_add_date) || (is_array($bun_add_date) && empty($bun_add_date))) {
            unset($this->bun_add_date);
        } else {
            $this->bun_add_date = $bun_add_date;
        }
        
        return $this;
    }
    /**
     * Get bun_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_change_user(): ?string
    {
        return $this->bun_change_user ?? null;
    }
    /**
     * Set bun_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_change_user(?string $bun_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_change_user) && !is_string($bun_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_change_user, true), gettype($bun_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bun_change_user) && mb_strlen((string) $bun_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bun_change_user)), __LINE__);
        }
        if (is_null($bun_change_user) || (is_array($bun_change_user) && empty($bun_change_user))) {
            unset($this->bun_change_user);
        } else {
            $this->bun_change_user = $bun_change_user;
        }
        
        return $this;
    }
    /**
     * Get bun_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_change_date(): ?string
    {
        return $this->bun_change_date ?? null;
    }
    /**
     * Set bun_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_change_date(?string $bun_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_change_date) && !is_string($bun_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_change_date, true), gettype($bun_change_date)), __LINE__);
        }
        if (is_null($bun_change_date) || (is_array($bun_change_date) && empty($bun_change_date))) {
            unset($this->bun_change_date);
        } else {
            $this->bun_change_date = $bun_change_date;
        }
        
        return $this;
    }
    /**
     * Get bun_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_delete_flag(): ?string
    {
        return $this->bun_delete_flag ?? null;
    }
    /**
     * Set bun_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_delete_flag(?string $bun_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_delete_flag) && !is_string($bun_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_delete_flag, true), gettype($bun_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bun_delete_flag) && $bun_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bun_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bun_delete_flag) && $bun_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bun_delete_flag, true)), __LINE__);
        }
        if (is_null($bun_delete_flag) || (is_array($bun_delete_flag) && empty($bun_delete_flag))) {
            unset($this->bun_delete_flag);
        } else {
            $this->bun_delete_flag = $bun_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bun_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_entity_key(): ?string
    {
        return $this->bun_entity_key ?? null;
    }
    /**
     * Set bun_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_entity_key(?string $bun_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_entity_key) && !is_string($bun_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_entity_key, true), gettype($bun_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bun_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bun_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bun_entity_key, true)), __LINE__);
        }
        if (is_null($bun_entity_key) || (is_array($bun_entity_key) && empty($bun_entity_key))) {
            unset($this->bun_entity_key);
        } else {
            $this->bun_entity_key = $bun_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_prd_key(): ?string
    {
        return $this->bun_prd_key ?? null;
    }
    /**
     * Set bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_prd_key(?string $bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_prd_key) && !is_string($bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_prd_key, true), gettype($bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bun_prd_key, true)), __LINE__);
        }
        if (is_null($bun_prd_key) || (is_array($bun_prd_key) && empty($bun_prd_key))) {
            unset($this->bun_prd_key);
        } else {
            $this->bun_prd_key = $bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get bun_supress_products_on_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_supress_products_on_invoice(): ?string
    {
        return $this->bun_supress_products_on_invoice ?? null;
    }
    /**
     * Set bun_supress_products_on_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_supress_products_on_invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_supress_products_on_invoice(?string $bun_supress_products_on_invoice = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_supress_products_on_invoice) && !is_string($bun_supress_products_on_invoice)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_supress_products_on_invoice, true), gettype($bun_supress_products_on_invoice)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bun_supress_products_on_invoice) && $bun_supress_products_on_invoice > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bun_supress_products_on_invoice, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bun_supress_products_on_invoice) && $bun_supress_products_on_invoice < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bun_supress_products_on_invoice, true)), __LINE__);
        }
        if (is_null($bun_supress_products_on_invoice) || (is_array($bun_supress_products_on_invoice) && empty($bun_supress_products_on_invoice))) {
            unset($this->bun_supress_products_on_invoice);
        } else {
            $this->bun_supress_products_on_invoice = $bun_supress_products_on_invoice;
        }
        
        return $this;
    }
    /**
     * Get bun_hide_price_on_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_hide_price_on_invoice(): ?string
    {
        return $this->bun_hide_price_on_invoice ?? null;
    }
    /**
     * Set bun_hide_price_on_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_hide_price_on_invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_hide_price_on_invoice(?string $bun_hide_price_on_invoice = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_hide_price_on_invoice) && !is_string($bun_hide_price_on_invoice)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_hide_price_on_invoice, true), gettype($bun_hide_price_on_invoice)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bun_hide_price_on_invoice) && $bun_hide_price_on_invoice > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bun_hide_price_on_invoice, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bun_hide_price_on_invoice) && $bun_hide_price_on_invoice < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bun_hide_price_on_invoice, true)), __LINE__);
        }
        if (is_null($bun_hide_price_on_invoice) || (is_array($bun_hide_price_on_invoice) && empty($bun_hide_price_on_invoice))) {
            unset($this->bun_hide_price_on_invoice);
        } else {
            $this->bun_hide_price_on_invoice = $bun_hide_price_on_invoice;
        }
        
        return $this;
    }
    /**
     * Get bun_bun_key_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_bun_key_renewal(): ?string
    {
        return $this->bun_bun_key_renewal ?? null;
    }
    /**
     * Set bun_bun_key_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_bun_key_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_bun_key_renewal(?string $bun_bun_key_renewal = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_bun_key_renewal) && !is_string($bun_bun_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_bun_key_renewal, true), gettype($bun_bun_key_renewal)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bun_bun_key_renewal) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bun_bun_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bun_bun_key_renewal, true)), __LINE__);
        }
        if (is_null($bun_bun_key_renewal) || (is_array($bun_bun_key_renewal) && empty($bun_bun_key_renewal))) {
            unset($this->bun_bun_key_renewal);
        } else {
            $this->bun_bun_key_renewal = $bun_bun_key_renewal;
        }
        
        return $this;
    }
    /**
     * Get bun_prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_prd_key_ext(): ?string
    {
        return $this->bun_prd_key_ext ?? null;
    }
    /**
     * Set bun_prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_prd_key_ext(?string $bun_prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_prd_key_ext) && !is_string($bun_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_prd_key_ext, true), gettype($bun_prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bun_prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bun_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bun_prd_key_ext, true)), __LINE__);
        }
        if (is_null($bun_prd_key_ext) || (is_array($bun_prd_key_ext) && empty($bun_prd_key_ext))) {
            unset($this->bun_prd_key_ext);
        } else {
            $this->bun_prd_key_ext = $bun_prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bun_sell_online_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBun_sell_online_flag(): ?string
    {
        return $this->bun_sell_online_flag ?? null;
    }
    /**
     * Set bun_sell_online_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bun_sell_online_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Bundle_DataObjectType
     */
    public function setBun_sell_online_flag(?string $bun_sell_online_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bun_sell_online_flag) && !is_string($bun_sell_online_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bun_sell_online_flag, true), gettype($bun_sell_online_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bun_sell_online_flag) && $bun_sell_online_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bun_sell_online_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bun_sell_online_flag) && $bun_sell_online_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bun_sell_online_flag, true)), __LINE__);
        }
        if (is_null($bun_sell_online_flag) || (is_array($bun_sell_online_flag) && empty($bun_sell_online_flag))) {
            unset($this->bun_sell_online_flag);
        } else {
            $this->bun_sell_online_flag = $bun_sell_online_flag;
        }
        
        return $this;
    }
}
