<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Change_Membership_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Change_Membership_DataObjectType extends AbstractStructBase
{
    /**
     * The nmb__mbr_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_src_key = null;
    /**
     * The nmb__mbr_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_src_code = null;
    /**
     * The nmb__mbr_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_asn_code = null;
    /**
     * The nmb__mbr_join_date
     * Meta information extracted from the WSDL
     * - documentation: Join Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_join_date = null;
    /**
     * The nmb__mbr_renew_date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_renew_date = null;
    /**
     * The nmb__mbr_expire_date
     * Meta information extracted from the WSDL
     * - documentation: Expire Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_expire_date = null;
    /**
     * The nmb__mbr_terminate_date
     * Meta information extracted from the WSDL
     * - documentation: Termination Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_terminate_date = null;
    /**
     * The nmb__mbr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_add_date = null;
    /**
     * The nmb__mbr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_add_user = null;
    /**
     * The nmb__mbr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_change_user = null;
    /**
     * The nmb__mbr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_change_date = null;
    /**
     * The nmb__mbr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_delete_flag = null;
    /**
     * The nmb__mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_key = null;
    /**
     * The nmb__mbr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_key_ext = null;
    /**
     * The nmb__mbr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Member Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_cst_key = null;
    /**
     * The nmb__mbr_opt_out
     * Meta information extracted from the WSDL
     * - documentation: Opt Out Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_opt_out = null;
    /**
     * The nmb__mbr_mbt_key
     * Meta information extracted from the WSDL
     * - documentation: Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_mbt_key = null;
    /**
     * The nmb__mbr_mbs_key
     * Meta information extracted from the WSDL
     * - documentation: Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_mbs_key = null;
    /**
     * The nmb__mbr_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Member Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_pak_prd_key = null;
    /**
     * The nmb__mbr_ind_cst_key_referral
     * Meta information extracted from the WSDL
     * - documentation: Referral. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_ind_cst_key_referral = null;
    /**
     * The nmb__mbr_pak_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_pak_prd_renewal_key = null;
    /**
     * The nmb__mbr_do_not_renew_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Renew. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_do_not_renew_flag = null;
    /**
     * The nmb__mbr_invoice_date
     * Meta information extracted from the WSDL
     * - documentation: Date of Last Invoice. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_invoice_date = null;
    /**
     * The nmb__mbr_rejoin_date
     * Meta information extracted from the WSDL
     * - documentation: Rejoin Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_rejoin_date = null;
    /**
     * The nmb__mbr_popup
     * Meta information extracted from the WSDL
     * - documentation: Popup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_popup = null;
    /**
     * The nmb__mbr_voting_rights
     * Meta information extracted from the WSDL
     * - documentation: Voting Rights. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_voting_rights = null;
    /**
     * The nmb__mbr_chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_chp_cst_key = null;
    /**
     * The nmb__mbr_converted_flag
     * Meta information extracted from the WSDL
     * - documentation: Converted Record?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_converted_flag = null;
    /**
     * The nmb__mbr_approval_flag
     * Meta information extracted from the WSDL
     * - documentation: Membership Approved. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_approval_flag = null;
    /**
     * The nmb__mbr_installment_frequency
     * Meta information extracted from the WSDL
     * - documentation: frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $nmb__mbr_installment_frequency = null;
    /**
     * The nmb__mbr_approval_date
     * Meta information extracted from the WSDL
     * - documentation: Approval Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_approval_date = null;
    /**
     * The nmb__mbr_ord_key
     * Meta information extracted from the WSDL
     * - documentation: Order. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_ord_key = null;
    /**
     * The nmb__mbr_mtr_key
     * Meta information extracted from the WSDL
     * - documentation: Terminate Reason Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_mtr_key = null;
    /**
     * The nmb__mbr_terminate_reason
     * Meta information extracted from the WSDL
     * - documentation: Termination Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_terminate_reason = null;
    /**
     * The nmb__mbr_installment_frequency_for_renewal
     * Meta information extracted from the WSDL
     * - documentation: installment frequency for renewal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $nmb__mbr_installment_frequency_for_renewal = null;
    /**
     * The nmb__mbr_num_of_installments_for_renewal
     * Meta information extracted from the WSDL
     * - documentation: num of installments for renewal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $nmb__mbr_num_of_installments_for_renewal = null;
    /**
     * The nmb__mbr_ord_ait_key_renewal
     * Meta information extracted from the WSDL
     * - documentation: renewal terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_ord_ait_key_renewal = null;
    /**
     * The nmb__mbr_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Association Membership Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_mbr_key = null;
    /**
     * The nmb__mbr_proforma_renewal
     * Meta information extracted from the WSDL
     * - documentation: renew by proforma. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_proforma_renewal = null;
    /**
     * The nmb__mbr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_entity_key = null;
    /**
     * The nmb__mbr_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_ord_code = null;
    /**
     * The nmb__mbr_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_odd_key = null;
    /**
     * The nmb__mbr_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_bun_prd_key = null;
    /**
     * The nmb__mbr_bun_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Bundle Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_bun_prd_renewal_key = null;
    /**
     * The nmb__mbr_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Dues Rate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_prc_key = null;
    /**
     * The nmb__mbr_bup_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle Component. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_bup_key = null;
    /**
     * The nmb__mbr_mbt_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_mbt_renewal_key = null;
    /**
     * The nmb__mbr_chp_cst_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_chp_cst_renewal_key = null;
    /**
     * The nmb__mbr_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_cpi_key = null;
    /**
     * The nmb__mbr_auto_pay
     * Meta information extracted from the WSDL
     * - documentation: auto-pay membership. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_auto_pay = null;
    /**
     * The nmb__mbr_installment_payments_flag
     * Meta information extracted from the WSDL
     * - documentation: Installment Payments?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_installment_payments_flag = null;
    /**
     * The nmb__mbr_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nmb__mbr_gft_key = null;
    /**
     * The nmb__mbr_cpi_consent_date
     * Meta information extracted from the WSDL
     * - documentation: Date cardholder consented to store their payment info for installment/recurring/renewal payments.. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nmb__mbr_cpi_consent_date = null;
    /**
     * Constructor method for mb_membership_Change_Membership_DataObjectType
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_src_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_src_code()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_asn_code()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_join_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_renew_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_expire_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_terminate_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_add_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_add_user()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_change_user()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_change_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_delete_flag()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_key_ext()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_cst_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_opt_out()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_mbt_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_mbs_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_pak_prd_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_ind_cst_key_referral()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_pak_prd_renewal_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_do_not_renew_flag()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_invoice_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_rejoin_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_popup()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_voting_rights()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_chp_cst_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_converted_flag()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_approval_flag()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_installment_frequency()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_approval_date()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_ord_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_mtr_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_terminate_reason()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_installment_frequency_for_renewal()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_num_of_installments_for_renewal()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_ord_ait_key_renewal()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_mbr_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_proforma_renewal()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_entity_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_ord_code()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_odd_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_bun_prd_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_bun_prd_renewal_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_prc_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_bup_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_mbt_renewal_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_chp_cst_renewal_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_cpi_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_auto_pay()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_installment_payments_flag()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_gft_key()
     * @uses Mb_membership_Change_Membership_DataObjectType::setNmb__mbr_cpi_consent_date()
     * @param string $nmb__mbr_src_key
     * @param string $nmb__mbr_src_code
     * @param string $nmb__mbr_asn_code
     * @param string $nmb__mbr_join_date
     * @param string $nmb__mbr_renew_date
     * @param string $nmb__mbr_expire_date
     * @param string $nmb__mbr_terminate_date
     * @param string $nmb__mbr_add_date
     * @param string $nmb__mbr_add_user
     * @param string $nmb__mbr_change_user
     * @param string $nmb__mbr_change_date
     * @param string $nmb__mbr_delete_flag
     * @param string $nmb__mbr_key
     * @param string $nmb__mbr_key_ext
     * @param string $nmb__mbr_cst_key
     * @param string $nmb__mbr_opt_out
     * @param string $nmb__mbr_mbt_key
     * @param string $nmb__mbr_mbs_key
     * @param string $nmb__mbr_pak_prd_key
     * @param string $nmb__mbr_ind_cst_key_referral
     * @param string $nmb__mbr_pak_prd_renewal_key
     * @param string $nmb__mbr_do_not_renew_flag
     * @param string $nmb__mbr_invoice_date
     * @param string $nmb__mbr_rejoin_date
     * @param string $nmb__mbr_popup
     * @param string $nmb__mbr_voting_rights
     * @param string $nmb__mbr_chp_cst_key
     * @param string $nmb__mbr_converted_flag
     * @param string $nmb__mbr_approval_flag
     * @param int $nmb__mbr_installment_frequency
     * @param string $nmb__mbr_approval_date
     * @param string $nmb__mbr_ord_key
     * @param string $nmb__mbr_mtr_key
     * @param string $nmb__mbr_terminate_reason
     * @param int $nmb__mbr_installment_frequency_for_renewal
     * @param int $nmb__mbr_num_of_installments_for_renewal
     * @param string $nmb__mbr_ord_ait_key_renewal
     * @param string $nmb__mbr_mbr_key
     * @param string $nmb__mbr_proforma_renewal
     * @param string $nmb__mbr_entity_key
     * @param string $nmb__mbr_ord_code
     * @param string $nmb__mbr_odd_key
     * @param string $nmb__mbr_bun_prd_key
     * @param string $nmb__mbr_bun_prd_renewal_key
     * @param string $nmb__mbr_prc_key
     * @param string $nmb__mbr_bup_key
     * @param string $nmb__mbr_mbt_renewal_key
     * @param string $nmb__mbr_chp_cst_renewal_key
     * @param string $nmb__mbr_cpi_key
     * @param string $nmb__mbr_auto_pay
     * @param string $nmb__mbr_installment_payments_flag
     * @param string $nmb__mbr_gft_key
     * @param string $nmb__mbr_cpi_consent_date
     */
    public function __construct(?string $nmb__mbr_src_key = null, ?string $nmb__mbr_src_code = null, ?string $nmb__mbr_asn_code = null, ?string $nmb__mbr_join_date = null, ?string $nmb__mbr_renew_date = null, ?string $nmb__mbr_expire_date = null, ?string $nmb__mbr_terminate_date = null, ?string $nmb__mbr_add_date = null, ?string $nmb__mbr_add_user = null, ?string $nmb__mbr_change_user = null, ?string $nmb__mbr_change_date = null, ?string $nmb__mbr_delete_flag = null, ?string $nmb__mbr_key = null, ?string $nmb__mbr_key_ext = null, ?string $nmb__mbr_cst_key = null, ?string $nmb__mbr_opt_out = null, ?string $nmb__mbr_mbt_key = null, ?string $nmb__mbr_mbs_key = null, ?string $nmb__mbr_pak_prd_key = null, ?string $nmb__mbr_ind_cst_key_referral = null, ?string $nmb__mbr_pak_prd_renewal_key = null, ?string $nmb__mbr_do_not_renew_flag = null, ?string $nmb__mbr_invoice_date = null, ?string $nmb__mbr_rejoin_date = null, ?string $nmb__mbr_popup = null, ?string $nmb__mbr_voting_rights = null, ?string $nmb__mbr_chp_cst_key = null, ?string $nmb__mbr_converted_flag = null, ?string $nmb__mbr_approval_flag = null, ?int $nmb__mbr_installment_frequency = null, ?string $nmb__mbr_approval_date = null, ?string $nmb__mbr_ord_key = null, ?string $nmb__mbr_mtr_key = null, ?string $nmb__mbr_terminate_reason = null, ?int $nmb__mbr_installment_frequency_for_renewal = null, ?int $nmb__mbr_num_of_installments_for_renewal = null, ?string $nmb__mbr_ord_ait_key_renewal = null, ?string $nmb__mbr_mbr_key = null, ?string $nmb__mbr_proforma_renewal = null, ?string $nmb__mbr_entity_key = null, ?string $nmb__mbr_ord_code = null, ?string $nmb__mbr_odd_key = null, ?string $nmb__mbr_bun_prd_key = null, ?string $nmb__mbr_bun_prd_renewal_key = null, ?string $nmb__mbr_prc_key = null, ?string $nmb__mbr_bup_key = null, ?string $nmb__mbr_mbt_renewal_key = null, ?string $nmb__mbr_chp_cst_renewal_key = null, ?string $nmb__mbr_cpi_key = null, ?string $nmb__mbr_auto_pay = null, ?string $nmb__mbr_installment_payments_flag = null, ?string $nmb__mbr_gft_key = null, ?string $nmb__mbr_cpi_consent_date = null)
    {
        $this
            ->setNmb__mbr_src_key($nmb__mbr_src_key)
            ->setNmb__mbr_src_code($nmb__mbr_src_code)
            ->setNmb__mbr_asn_code($nmb__mbr_asn_code)
            ->setNmb__mbr_join_date($nmb__mbr_join_date)
            ->setNmb__mbr_renew_date($nmb__mbr_renew_date)
            ->setNmb__mbr_expire_date($nmb__mbr_expire_date)
            ->setNmb__mbr_terminate_date($nmb__mbr_terminate_date)
            ->setNmb__mbr_add_date($nmb__mbr_add_date)
            ->setNmb__mbr_add_user($nmb__mbr_add_user)
            ->setNmb__mbr_change_user($nmb__mbr_change_user)
            ->setNmb__mbr_change_date($nmb__mbr_change_date)
            ->setNmb__mbr_delete_flag($nmb__mbr_delete_flag)
            ->setNmb__mbr_key($nmb__mbr_key)
            ->setNmb__mbr_key_ext($nmb__mbr_key_ext)
            ->setNmb__mbr_cst_key($nmb__mbr_cst_key)
            ->setNmb__mbr_opt_out($nmb__mbr_opt_out)
            ->setNmb__mbr_mbt_key($nmb__mbr_mbt_key)
            ->setNmb__mbr_mbs_key($nmb__mbr_mbs_key)
            ->setNmb__mbr_pak_prd_key($nmb__mbr_pak_prd_key)
            ->setNmb__mbr_ind_cst_key_referral($nmb__mbr_ind_cst_key_referral)
            ->setNmb__mbr_pak_prd_renewal_key($nmb__mbr_pak_prd_renewal_key)
            ->setNmb__mbr_do_not_renew_flag($nmb__mbr_do_not_renew_flag)
            ->setNmb__mbr_invoice_date($nmb__mbr_invoice_date)
            ->setNmb__mbr_rejoin_date($nmb__mbr_rejoin_date)
            ->setNmb__mbr_popup($nmb__mbr_popup)
            ->setNmb__mbr_voting_rights($nmb__mbr_voting_rights)
            ->setNmb__mbr_chp_cst_key($nmb__mbr_chp_cst_key)
            ->setNmb__mbr_converted_flag($nmb__mbr_converted_flag)
            ->setNmb__mbr_approval_flag($nmb__mbr_approval_flag)
            ->setNmb__mbr_installment_frequency($nmb__mbr_installment_frequency)
            ->setNmb__mbr_approval_date($nmb__mbr_approval_date)
            ->setNmb__mbr_ord_key($nmb__mbr_ord_key)
            ->setNmb__mbr_mtr_key($nmb__mbr_mtr_key)
            ->setNmb__mbr_terminate_reason($nmb__mbr_terminate_reason)
            ->setNmb__mbr_installment_frequency_for_renewal($nmb__mbr_installment_frequency_for_renewal)
            ->setNmb__mbr_num_of_installments_for_renewal($nmb__mbr_num_of_installments_for_renewal)
            ->setNmb__mbr_ord_ait_key_renewal($nmb__mbr_ord_ait_key_renewal)
            ->setNmb__mbr_mbr_key($nmb__mbr_mbr_key)
            ->setNmb__mbr_proforma_renewal($nmb__mbr_proforma_renewal)
            ->setNmb__mbr_entity_key($nmb__mbr_entity_key)
            ->setNmb__mbr_ord_code($nmb__mbr_ord_code)
            ->setNmb__mbr_odd_key($nmb__mbr_odd_key)
            ->setNmb__mbr_bun_prd_key($nmb__mbr_bun_prd_key)
            ->setNmb__mbr_bun_prd_renewal_key($nmb__mbr_bun_prd_renewal_key)
            ->setNmb__mbr_prc_key($nmb__mbr_prc_key)
            ->setNmb__mbr_bup_key($nmb__mbr_bup_key)
            ->setNmb__mbr_mbt_renewal_key($nmb__mbr_mbt_renewal_key)
            ->setNmb__mbr_chp_cst_renewal_key($nmb__mbr_chp_cst_renewal_key)
            ->setNmb__mbr_cpi_key($nmb__mbr_cpi_key)
            ->setNmb__mbr_auto_pay($nmb__mbr_auto_pay)
            ->setNmb__mbr_installment_payments_flag($nmb__mbr_installment_payments_flag)
            ->setNmb__mbr_gft_key($nmb__mbr_gft_key)
            ->setNmb__mbr_cpi_consent_date($nmb__mbr_cpi_consent_date);
    }
    /**
     * Get nmb__mbr_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_src_key(): ?string
    {
        return $this->nmb__mbr_src_key ?? null;
    }
    /**
     * Set nmb__mbr_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_src_key(?string $nmb__mbr_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_src_key) && !is_string($nmb__mbr_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_src_key, true), gettype($nmb__mbr_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_src_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_src_key) || (is_array($nmb__mbr_src_key) && empty($nmb__mbr_src_key))) {
            unset($this->nmb__mbr_src_key);
        } else {
            $this->nmb__mbr_src_key = $nmb__mbr_src_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_src_code(): ?string
    {
        return $this->nmb__mbr_src_code ?? null;
    }
    /**
     * Set nmb__mbr_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_src_code(?string $nmb__mbr_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_src_code) && !is_string($nmb__mbr_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_src_code, true), gettype($nmb__mbr_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($nmb__mbr_src_code) && mb_strlen((string) $nmb__mbr_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $nmb__mbr_src_code)), __LINE__);
        }
        if (is_null($nmb__mbr_src_code) || (is_array($nmb__mbr_src_code) && empty($nmb__mbr_src_code))) {
            unset($this->nmb__mbr_src_code);
        } else {
            $this->nmb__mbr_src_code = $nmb__mbr_src_code;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_asn_code(): ?string
    {
        return $this->nmb__mbr_asn_code ?? null;
    }
    /**
     * Set nmb__mbr_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_asn_code(?string $nmb__mbr_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_asn_code) && !is_string($nmb__mbr_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_asn_code, true), gettype($nmb__mbr_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nmb__mbr_asn_code) && mb_strlen((string) $nmb__mbr_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $nmb__mbr_asn_code)), __LINE__);
        }
        if (is_null($nmb__mbr_asn_code) || (is_array($nmb__mbr_asn_code) && empty($nmb__mbr_asn_code))) {
            unset($this->nmb__mbr_asn_code);
        } else {
            $this->nmb__mbr_asn_code = $nmb__mbr_asn_code;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_join_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_join_date(): ?string
    {
        return $this->nmb__mbr_join_date ?? null;
    }
    /**
     * Set nmb__mbr_join_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_join_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_join_date(?string $nmb__mbr_join_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_join_date) && !is_string($nmb__mbr_join_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_join_date, true), gettype($nmb__mbr_join_date)), __LINE__);
        }
        if (is_null($nmb__mbr_join_date) || (is_array($nmb__mbr_join_date) && empty($nmb__mbr_join_date))) {
            unset($this->nmb__mbr_join_date);
        } else {
            $this->nmb__mbr_join_date = $nmb__mbr_join_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_renew_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_renew_date(): ?string
    {
        return $this->nmb__mbr_renew_date ?? null;
    }
    /**
     * Set nmb__mbr_renew_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_renew_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_renew_date(?string $nmb__mbr_renew_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_renew_date) && !is_string($nmb__mbr_renew_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_renew_date, true), gettype($nmb__mbr_renew_date)), __LINE__);
        }
        if (is_null($nmb__mbr_renew_date) || (is_array($nmb__mbr_renew_date) && empty($nmb__mbr_renew_date))) {
            unset($this->nmb__mbr_renew_date);
        } else {
            $this->nmb__mbr_renew_date = $nmb__mbr_renew_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_expire_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_expire_date(): ?string
    {
        return $this->nmb__mbr_expire_date ?? null;
    }
    /**
     * Set nmb__mbr_expire_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_expire_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_expire_date(?string $nmb__mbr_expire_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_expire_date) && !is_string($nmb__mbr_expire_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_expire_date, true), gettype($nmb__mbr_expire_date)), __LINE__);
        }
        if (is_null($nmb__mbr_expire_date) || (is_array($nmb__mbr_expire_date) && empty($nmb__mbr_expire_date))) {
            unset($this->nmb__mbr_expire_date);
        } else {
            $this->nmb__mbr_expire_date = $nmb__mbr_expire_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_terminate_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_terminate_date(): ?string
    {
        return $this->nmb__mbr_terminate_date ?? null;
    }
    /**
     * Set nmb__mbr_terminate_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_terminate_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_terminate_date(?string $nmb__mbr_terminate_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_terminate_date) && !is_string($nmb__mbr_terminate_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_terminate_date, true), gettype($nmb__mbr_terminate_date)), __LINE__);
        }
        if (is_null($nmb__mbr_terminate_date) || (is_array($nmb__mbr_terminate_date) && empty($nmb__mbr_terminate_date))) {
            unset($this->nmb__mbr_terminate_date);
        } else {
            $this->nmb__mbr_terminate_date = $nmb__mbr_terminate_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_add_date(): ?string
    {
        return $this->nmb__mbr_add_date ?? null;
    }
    /**
     * Set nmb__mbr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_add_date(?string $nmb__mbr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_add_date) && !is_string($nmb__mbr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_add_date, true), gettype($nmb__mbr_add_date)), __LINE__);
        }
        if (is_null($nmb__mbr_add_date) || (is_array($nmb__mbr_add_date) && empty($nmb__mbr_add_date))) {
            unset($this->nmb__mbr_add_date);
        } else {
            $this->nmb__mbr_add_date = $nmb__mbr_add_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_add_user(): ?string
    {
        return $this->nmb__mbr_add_user ?? null;
    }
    /**
     * Set nmb__mbr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_add_user(?string $nmb__mbr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_add_user) && !is_string($nmb__mbr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_add_user, true), gettype($nmb__mbr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nmb__mbr_add_user) && mb_strlen((string) $nmb__mbr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nmb__mbr_add_user)), __LINE__);
        }
        if (is_null($nmb__mbr_add_user) || (is_array($nmb__mbr_add_user) && empty($nmb__mbr_add_user))) {
            unset($this->nmb__mbr_add_user);
        } else {
            $this->nmb__mbr_add_user = $nmb__mbr_add_user;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_change_user(): ?string
    {
        return $this->nmb__mbr_change_user ?? null;
    }
    /**
     * Set nmb__mbr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_change_user(?string $nmb__mbr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_change_user) && !is_string($nmb__mbr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_change_user, true), gettype($nmb__mbr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nmb__mbr_change_user) && mb_strlen((string) $nmb__mbr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nmb__mbr_change_user)), __LINE__);
        }
        if (is_null($nmb__mbr_change_user) || (is_array($nmb__mbr_change_user) && empty($nmb__mbr_change_user))) {
            unset($this->nmb__mbr_change_user);
        } else {
            $this->nmb__mbr_change_user = $nmb__mbr_change_user;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_change_date(): ?string
    {
        return $this->nmb__mbr_change_date ?? null;
    }
    /**
     * Set nmb__mbr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_change_date(?string $nmb__mbr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_change_date) && !is_string($nmb__mbr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_change_date, true), gettype($nmb__mbr_change_date)), __LINE__);
        }
        if (is_null($nmb__mbr_change_date) || (is_array($nmb__mbr_change_date) && empty($nmb__mbr_change_date))) {
            unset($this->nmb__mbr_change_date);
        } else {
            $this->nmb__mbr_change_date = $nmb__mbr_change_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_delete_flag(): ?string
    {
        return $this->nmb__mbr_delete_flag ?? null;
    }
    /**
     * Set nmb__mbr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_delete_flag(?string $nmb__mbr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_delete_flag) && !is_string($nmb__mbr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_delete_flag, true), gettype($nmb__mbr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_delete_flag) && $nmb__mbr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_delete_flag) && $nmb__mbr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_delete_flag, true)), __LINE__);
        }
        if (is_null($nmb__mbr_delete_flag) || (is_array($nmb__mbr_delete_flag) && empty($nmb__mbr_delete_flag))) {
            unset($this->nmb__mbr_delete_flag);
        } else {
            $this->nmb__mbr_delete_flag = $nmb__mbr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_key(): ?string
    {
        return $this->nmb__mbr_key ?? null;
    }
    /**
     * Set nmb__mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_key(?string $nmb__mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_key) && !is_string($nmb__mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_key, true), gettype($nmb__mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_key) || (is_array($nmb__mbr_key) && empty($nmb__mbr_key))) {
            unset($this->nmb__mbr_key);
        } else {
            $this->nmb__mbr_key = $nmb__mbr_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_key_ext(): ?string
    {
        return $this->nmb__mbr_key_ext ?? null;
    }
    /**
     * Set nmb__mbr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_key_ext(?string $nmb__mbr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_key_ext) && !is_string($nmb__mbr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_key_ext, true), gettype($nmb__mbr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_key_ext, true)), __LINE__);
        }
        if (is_null($nmb__mbr_key_ext) || (is_array($nmb__mbr_key_ext) && empty($nmb__mbr_key_ext))) {
            unset($this->nmb__mbr_key_ext);
        } else {
            $this->nmb__mbr_key_ext = $nmb__mbr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_cst_key(): ?string
    {
        return $this->nmb__mbr_cst_key ?? null;
    }
    /**
     * Set nmb__mbr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_cst_key(?string $nmb__mbr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_cst_key) && !is_string($nmb__mbr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_cst_key, true), gettype($nmb__mbr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_cst_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_cst_key) || (is_array($nmb__mbr_cst_key) && empty($nmb__mbr_cst_key))) {
            unset($this->nmb__mbr_cst_key);
        } else {
            $this->nmb__mbr_cst_key = $nmb__mbr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_opt_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_opt_out(): ?string
    {
        return $this->nmb__mbr_opt_out ?? null;
    }
    /**
     * Set nmb__mbr_opt_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_opt_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_opt_out(?string $nmb__mbr_opt_out = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_opt_out) && !is_string($nmb__mbr_opt_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_opt_out, true), gettype($nmb__mbr_opt_out)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_opt_out) && $nmb__mbr_opt_out > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_opt_out, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_opt_out) && $nmb__mbr_opt_out < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_opt_out, true)), __LINE__);
        }
        if (is_null($nmb__mbr_opt_out) || (is_array($nmb__mbr_opt_out) && empty($nmb__mbr_opt_out))) {
            unset($this->nmb__mbr_opt_out);
        } else {
            $this->nmb__mbr_opt_out = $nmb__mbr_opt_out;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_mbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_mbt_key(): ?string
    {
        return $this->nmb__mbr_mbt_key ?? null;
    }
    /**
     * Set nmb__mbr_mbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_mbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_mbt_key(?string $nmb__mbr_mbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_mbt_key) && !is_string($nmb__mbr_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_mbt_key, true), gettype($nmb__mbr_mbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_mbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_mbt_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_mbt_key) || (is_array($nmb__mbr_mbt_key) && empty($nmb__mbr_mbt_key))) {
            unset($this->nmb__mbr_mbt_key);
        } else {
            $this->nmb__mbr_mbt_key = $nmb__mbr_mbt_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_mbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_mbs_key(): ?string
    {
        return $this->nmb__mbr_mbs_key ?? null;
    }
    /**
     * Set nmb__mbr_mbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_mbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_mbs_key(?string $nmb__mbr_mbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_mbs_key) && !is_string($nmb__mbr_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_mbs_key, true), gettype($nmb__mbr_mbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_mbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_mbs_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_mbs_key) || (is_array($nmb__mbr_mbs_key) && empty($nmb__mbr_mbs_key))) {
            unset($this->nmb__mbr_mbs_key);
        } else {
            $this->nmb__mbr_mbs_key = $nmb__mbr_mbs_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_pak_prd_key(): ?string
    {
        return $this->nmb__mbr_pak_prd_key ?? null;
    }
    /**
     * Set nmb__mbr_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_pak_prd_key(?string $nmb__mbr_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_pak_prd_key) && !is_string($nmb__mbr_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_pak_prd_key, true), gettype($nmb__mbr_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_pak_prd_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_pak_prd_key) || (is_array($nmb__mbr_pak_prd_key) && empty($nmb__mbr_pak_prd_key))) {
            unset($this->nmb__mbr_pak_prd_key);
        } else {
            $this->nmb__mbr_pak_prd_key = $nmb__mbr_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_ind_cst_key_referral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_ind_cst_key_referral(): ?string
    {
        return $this->nmb__mbr_ind_cst_key_referral ?? null;
    }
    /**
     * Set nmb__mbr_ind_cst_key_referral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_ind_cst_key_referral
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_ind_cst_key_referral(?string $nmb__mbr_ind_cst_key_referral = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_ind_cst_key_referral) && !is_string($nmb__mbr_ind_cst_key_referral)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_ind_cst_key_referral, true), gettype($nmb__mbr_ind_cst_key_referral)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_ind_cst_key_referral) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_ind_cst_key_referral)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_ind_cst_key_referral, true)), __LINE__);
        }
        if (is_null($nmb__mbr_ind_cst_key_referral) || (is_array($nmb__mbr_ind_cst_key_referral) && empty($nmb__mbr_ind_cst_key_referral))) {
            unset($this->nmb__mbr_ind_cst_key_referral);
        } else {
            $this->nmb__mbr_ind_cst_key_referral = $nmb__mbr_ind_cst_key_referral;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_pak_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_pak_prd_renewal_key(): ?string
    {
        return $this->nmb__mbr_pak_prd_renewal_key ?? null;
    }
    /**
     * Set nmb__mbr_pak_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_pak_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_pak_prd_renewal_key(?string $nmb__mbr_pak_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_pak_prd_renewal_key) && !is_string($nmb__mbr_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_pak_prd_renewal_key, true), gettype($nmb__mbr_pak_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_pak_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_pak_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_pak_prd_renewal_key) || (is_array($nmb__mbr_pak_prd_renewal_key) && empty($nmb__mbr_pak_prd_renewal_key))) {
            unset($this->nmb__mbr_pak_prd_renewal_key);
        } else {
            $this->nmb__mbr_pak_prd_renewal_key = $nmb__mbr_pak_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_do_not_renew_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_do_not_renew_flag(): ?string
    {
        return $this->nmb__mbr_do_not_renew_flag ?? null;
    }
    /**
     * Set nmb__mbr_do_not_renew_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_do_not_renew_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_do_not_renew_flag(?string $nmb__mbr_do_not_renew_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_do_not_renew_flag) && !is_string($nmb__mbr_do_not_renew_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_do_not_renew_flag, true), gettype($nmb__mbr_do_not_renew_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_do_not_renew_flag) && $nmb__mbr_do_not_renew_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_do_not_renew_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_do_not_renew_flag) && $nmb__mbr_do_not_renew_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_do_not_renew_flag, true)), __LINE__);
        }
        if (is_null($nmb__mbr_do_not_renew_flag) || (is_array($nmb__mbr_do_not_renew_flag) && empty($nmb__mbr_do_not_renew_flag))) {
            unset($this->nmb__mbr_do_not_renew_flag);
        } else {
            $this->nmb__mbr_do_not_renew_flag = $nmb__mbr_do_not_renew_flag;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_invoice_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_invoice_date(): ?string
    {
        return $this->nmb__mbr_invoice_date ?? null;
    }
    /**
     * Set nmb__mbr_invoice_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_invoice_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_invoice_date(?string $nmb__mbr_invoice_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_invoice_date) && !is_string($nmb__mbr_invoice_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_invoice_date, true), gettype($nmb__mbr_invoice_date)), __LINE__);
        }
        if (is_null($nmb__mbr_invoice_date) || (is_array($nmb__mbr_invoice_date) && empty($nmb__mbr_invoice_date))) {
            unset($this->nmb__mbr_invoice_date);
        } else {
            $this->nmb__mbr_invoice_date = $nmb__mbr_invoice_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_rejoin_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_rejoin_date(): ?string
    {
        return $this->nmb__mbr_rejoin_date ?? null;
    }
    /**
     * Set nmb__mbr_rejoin_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_rejoin_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_rejoin_date(?string $nmb__mbr_rejoin_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_rejoin_date) && !is_string($nmb__mbr_rejoin_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_rejoin_date, true), gettype($nmb__mbr_rejoin_date)), __LINE__);
        }
        if (is_null($nmb__mbr_rejoin_date) || (is_array($nmb__mbr_rejoin_date) && empty($nmb__mbr_rejoin_date))) {
            unset($this->nmb__mbr_rejoin_date);
        } else {
            $this->nmb__mbr_rejoin_date = $nmb__mbr_rejoin_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_popup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_popup(): ?string
    {
        return $this->nmb__mbr_popup ?? null;
    }
    /**
     * Set nmb__mbr_popup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_popup
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_popup(?string $nmb__mbr_popup = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_popup) && !is_string($nmb__mbr_popup)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_popup, true), gettype($nmb__mbr_popup)), __LINE__);
        }
        if (is_null($nmb__mbr_popup) || (is_array($nmb__mbr_popup) && empty($nmb__mbr_popup))) {
            unset($this->nmb__mbr_popup);
        } else {
            $this->nmb__mbr_popup = $nmb__mbr_popup;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_voting_rights value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_voting_rights(): ?string
    {
        return $this->nmb__mbr_voting_rights ?? null;
    }
    /**
     * Set nmb__mbr_voting_rights value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_voting_rights
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_voting_rights(?string $nmb__mbr_voting_rights = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_voting_rights) && !is_string($nmb__mbr_voting_rights)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_voting_rights, true), gettype($nmb__mbr_voting_rights)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_voting_rights) && $nmb__mbr_voting_rights > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_voting_rights, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_voting_rights) && $nmb__mbr_voting_rights < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_voting_rights, true)), __LINE__);
        }
        if (is_null($nmb__mbr_voting_rights) || (is_array($nmb__mbr_voting_rights) && empty($nmb__mbr_voting_rights))) {
            unset($this->nmb__mbr_voting_rights);
        } else {
            $this->nmb__mbr_voting_rights = $nmb__mbr_voting_rights;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_chp_cst_key(): ?string
    {
        return $this->nmb__mbr_chp_cst_key ?? null;
    }
    /**
     * Set nmb__mbr_chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_chp_cst_key(?string $nmb__mbr_chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_chp_cst_key) && !is_string($nmb__mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_chp_cst_key, true), gettype($nmb__mbr_chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_chp_cst_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_chp_cst_key) || (is_array($nmb__mbr_chp_cst_key) && empty($nmb__mbr_chp_cst_key))) {
            unset($this->nmb__mbr_chp_cst_key);
        } else {
            $this->nmb__mbr_chp_cst_key = $nmb__mbr_chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_converted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_converted_flag(): ?string
    {
        return $this->nmb__mbr_converted_flag ?? null;
    }
    /**
     * Set nmb__mbr_converted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_converted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_converted_flag(?string $nmb__mbr_converted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_converted_flag) && !is_string($nmb__mbr_converted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_converted_flag, true), gettype($nmb__mbr_converted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_converted_flag) && $nmb__mbr_converted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_converted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_converted_flag) && $nmb__mbr_converted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_converted_flag, true)), __LINE__);
        }
        if (is_null($nmb__mbr_converted_flag) || (is_array($nmb__mbr_converted_flag) && empty($nmb__mbr_converted_flag))) {
            unset($this->nmb__mbr_converted_flag);
        } else {
            $this->nmb__mbr_converted_flag = $nmb__mbr_converted_flag;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_approval_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_approval_flag(): ?string
    {
        return $this->nmb__mbr_approval_flag ?? null;
    }
    /**
     * Set nmb__mbr_approval_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_approval_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_approval_flag(?string $nmb__mbr_approval_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_approval_flag) && !is_string($nmb__mbr_approval_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_approval_flag, true), gettype($nmb__mbr_approval_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_approval_flag) && $nmb__mbr_approval_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_approval_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_approval_flag) && $nmb__mbr_approval_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_approval_flag, true)), __LINE__);
        }
        if (is_null($nmb__mbr_approval_flag) || (is_array($nmb__mbr_approval_flag) && empty($nmb__mbr_approval_flag))) {
            unset($this->nmb__mbr_approval_flag);
        } else {
            $this->nmb__mbr_approval_flag = $nmb__mbr_approval_flag;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_installment_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNmb__mbr_installment_frequency(): ?int
    {
        return $this->nmb__mbr_installment_frequency ?? null;
    }
    /**
     * Set nmb__mbr_installment_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nmb__mbr_installment_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_installment_frequency(?int $nmb__mbr_installment_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($nmb__mbr_installment_frequency) && !(is_int($nmb__mbr_installment_frequency) || ctype_digit($nmb__mbr_installment_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmb__mbr_installment_frequency, true), gettype($nmb__mbr_installment_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($nmb__mbr_installment_frequency) && $nmb__mbr_installment_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($nmb__mbr_installment_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($nmb__mbr_installment_frequency) && $nmb__mbr_installment_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($nmb__mbr_installment_frequency, true)), __LINE__);
        }
        if (is_null($nmb__mbr_installment_frequency) || (is_array($nmb__mbr_installment_frequency) && empty($nmb__mbr_installment_frequency))) {
            unset($this->nmb__mbr_installment_frequency);
        } else {
            $this->nmb__mbr_installment_frequency = $nmb__mbr_installment_frequency;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_approval_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_approval_date(): ?string
    {
        return $this->nmb__mbr_approval_date ?? null;
    }
    /**
     * Set nmb__mbr_approval_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_approval_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_approval_date(?string $nmb__mbr_approval_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_approval_date) && !is_string($nmb__mbr_approval_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_approval_date, true), gettype($nmb__mbr_approval_date)), __LINE__);
        }
        if (is_null($nmb__mbr_approval_date) || (is_array($nmb__mbr_approval_date) && empty($nmb__mbr_approval_date))) {
            unset($this->nmb__mbr_approval_date);
        } else {
            $this->nmb__mbr_approval_date = $nmb__mbr_approval_date;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_ord_key(): ?string
    {
        return $this->nmb__mbr_ord_key ?? null;
    }
    /**
     * Set nmb__mbr_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_ord_key(?string $nmb__mbr_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_ord_key) && !is_string($nmb__mbr_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_ord_key, true), gettype($nmb__mbr_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_ord_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_ord_key) || (is_array($nmb__mbr_ord_key) && empty($nmb__mbr_ord_key))) {
            unset($this->nmb__mbr_ord_key);
        } else {
            $this->nmb__mbr_ord_key = $nmb__mbr_ord_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_mtr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_mtr_key(): ?string
    {
        return $this->nmb__mbr_mtr_key ?? null;
    }
    /**
     * Set nmb__mbr_mtr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_mtr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_mtr_key(?string $nmb__mbr_mtr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_mtr_key) && !is_string($nmb__mbr_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_mtr_key, true), gettype($nmb__mbr_mtr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_mtr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_mtr_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_mtr_key) || (is_array($nmb__mbr_mtr_key) && empty($nmb__mbr_mtr_key))) {
            unset($this->nmb__mbr_mtr_key);
        } else {
            $this->nmb__mbr_mtr_key = $nmb__mbr_mtr_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_terminate_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_terminate_reason(): ?string
    {
        return $this->nmb__mbr_terminate_reason ?? null;
    }
    /**
     * Set nmb__mbr_terminate_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_terminate_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_terminate_reason(?string $nmb__mbr_terminate_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_terminate_reason) && !is_string($nmb__mbr_terminate_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_terminate_reason, true), gettype($nmb__mbr_terminate_reason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($nmb__mbr_terminate_reason) && mb_strlen((string) $nmb__mbr_terminate_reason) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $nmb__mbr_terminate_reason)), __LINE__);
        }
        if (is_null($nmb__mbr_terminate_reason) || (is_array($nmb__mbr_terminate_reason) && empty($nmb__mbr_terminate_reason))) {
            unset($this->nmb__mbr_terminate_reason);
        } else {
            $this->nmb__mbr_terminate_reason = $nmb__mbr_terminate_reason;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_installment_frequency_for_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNmb__mbr_installment_frequency_for_renewal(): ?int
    {
        return $this->nmb__mbr_installment_frequency_for_renewal ?? null;
    }
    /**
     * Set nmb__mbr_installment_frequency_for_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nmb__mbr_installment_frequency_for_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_installment_frequency_for_renewal(?int $nmb__mbr_installment_frequency_for_renewal = null): self
    {
        // validation for constraint: int
        if (!is_null($nmb__mbr_installment_frequency_for_renewal) && !(is_int($nmb__mbr_installment_frequency_for_renewal) || ctype_digit($nmb__mbr_installment_frequency_for_renewal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmb__mbr_installment_frequency_for_renewal, true), gettype($nmb__mbr_installment_frequency_for_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($nmb__mbr_installment_frequency_for_renewal) && $nmb__mbr_installment_frequency_for_renewal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($nmb__mbr_installment_frequency_for_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($nmb__mbr_installment_frequency_for_renewal) && $nmb__mbr_installment_frequency_for_renewal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($nmb__mbr_installment_frequency_for_renewal, true)), __LINE__);
        }
        if (is_null($nmb__mbr_installment_frequency_for_renewal) || (is_array($nmb__mbr_installment_frequency_for_renewal) && empty($nmb__mbr_installment_frequency_for_renewal))) {
            unset($this->nmb__mbr_installment_frequency_for_renewal);
        } else {
            $this->nmb__mbr_installment_frequency_for_renewal = $nmb__mbr_installment_frequency_for_renewal;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_num_of_installments_for_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNmb__mbr_num_of_installments_for_renewal(): ?int
    {
        return $this->nmb__mbr_num_of_installments_for_renewal ?? null;
    }
    /**
     * Set nmb__mbr_num_of_installments_for_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nmb__mbr_num_of_installments_for_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_num_of_installments_for_renewal(?int $nmb__mbr_num_of_installments_for_renewal = null): self
    {
        // validation for constraint: int
        if (!is_null($nmb__mbr_num_of_installments_for_renewal) && !(is_int($nmb__mbr_num_of_installments_for_renewal) || ctype_digit($nmb__mbr_num_of_installments_for_renewal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmb__mbr_num_of_installments_for_renewal, true), gettype($nmb__mbr_num_of_installments_for_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($nmb__mbr_num_of_installments_for_renewal) && $nmb__mbr_num_of_installments_for_renewal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($nmb__mbr_num_of_installments_for_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($nmb__mbr_num_of_installments_for_renewal) && $nmb__mbr_num_of_installments_for_renewal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($nmb__mbr_num_of_installments_for_renewal, true)), __LINE__);
        }
        if (is_null($nmb__mbr_num_of_installments_for_renewal) || (is_array($nmb__mbr_num_of_installments_for_renewal) && empty($nmb__mbr_num_of_installments_for_renewal))) {
            unset($this->nmb__mbr_num_of_installments_for_renewal);
        } else {
            $this->nmb__mbr_num_of_installments_for_renewal = $nmb__mbr_num_of_installments_for_renewal;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_ord_ait_key_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_ord_ait_key_renewal(): ?string
    {
        return $this->nmb__mbr_ord_ait_key_renewal ?? null;
    }
    /**
     * Set nmb__mbr_ord_ait_key_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_ord_ait_key_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_ord_ait_key_renewal(?string $nmb__mbr_ord_ait_key_renewal = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_ord_ait_key_renewal) && !is_string($nmb__mbr_ord_ait_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_ord_ait_key_renewal, true), gettype($nmb__mbr_ord_ait_key_renewal)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_ord_ait_key_renewal) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_ord_ait_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_ord_ait_key_renewal, true)), __LINE__);
        }
        if (is_null($nmb__mbr_ord_ait_key_renewal) || (is_array($nmb__mbr_ord_ait_key_renewal) && empty($nmb__mbr_ord_ait_key_renewal))) {
            unset($this->nmb__mbr_ord_ait_key_renewal);
        } else {
            $this->nmb__mbr_ord_ait_key_renewal = $nmb__mbr_ord_ait_key_renewal;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_mbr_key(): ?string
    {
        return $this->nmb__mbr_mbr_key ?? null;
    }
    /**
     * Set nmb__mbr_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_mbr_key(?string $nmb__mbr_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_mbr_key) && !is_string($nmb__mbr_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_mbr_key, true), gettype($nmb__mbr_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_mbr_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_mbr_key) || (is_array($nmb__mbr_mbr_key) && empty($nmb__mbr_mbr_key))) {
            unset($this->nmb__mbr_mbr_key);
        } else {
            $this->nmb__mbr_mbr_key = $nmb__mbr_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_proforma_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_proforma_renewal(): ?string
    {
        return $this->nmb__mbr_proforma_renewal ?? null;
    }
    /**
     * Set nmb__mbr_proforma_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_proforma_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_proforma_renewal(?string $nmb__mbr_proforma_renewal = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_proforma_renewal) && !is_string($nmb__mbr_proforma_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_proforma_renewal, true), gettype($nmb__mbr_proforma_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_proforma_renewal) && $nmb__mbr_proforma_renewal > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_proforma_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_proforma_renewal) && $nmb__mbr_proforma_renewal < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_proforma_renewal, true)), __LINE__);
        }
        if (is_null($nmb__mbr_proforma_renewal) || (is_array($nmb__mbr_proforma_renewal) && empty($nmb__mbr_proforma_renewal))) {
            unset($this->nmb__mbr_proforma_renewal);
        } else {
            $this->nmb__mbr_proforma_renewal = $nmb__mbr_proforma_renewal;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_entity_key(): ?string
    {
        return $this->nmb__mbr_entity_key ?? null;
    }
    /**
     * Set nmb__mbr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_entity_key(?string $nmb__mbr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_entity_key) && !is_string($nmb__mbr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_entity_key, true), gettype($nmb__mbr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_entity_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_entity_key) || (is_array($nmb__mbr_entity_key) && empty($nmb__mbr_entity_key))) {
            unset($this->nmb__mbr_entity_key);
        } else {
            $this->nmb__mbr_entity_key = $nmb__mbr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_ord_code(): ?string
    {
        return $this->nmb__mbr_ord_code ?? null;
    }
    /**
     * Set nmb__mbr_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_ord_code(?string $nmb__mbr_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_ord_code) && !is_string($nmb__mbr_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_ord_code, true), gettype($nmb__mbr_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($nmb__mbr_ord_code) && mb_strlen((string) $nmb__mbr_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $nmb__mbr_ord_code)), __LINE__);
        }
        if (is_null($nmb__mbr_ord_code) || (is_array($nmb__mbr_ord_code) && empty($nmb__mbr_ord_code))) {
            unset($this->nmb__mbr_ord_code);
        } else {
            $this->nmb__mbr_ord_code = $nmb__mbr_ord_code;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_odd_key(): ?string
    {
        return $this->nmb__mbr_odd_key ?? null;
    }
    /**
     * Set nmb__mbr_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_odd_key(?string $nmb__mbr_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_odd_key) && !is_string($nmb__mbr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_odd_key, true), gettype($nmb__mbr_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_odd_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_odd_key) || (is_array($nmb__mbr_odd_key) && empty($nmb__mbr_odd_key))) {
            unset($this->nmb__mbr_odd_key);
        } else {
            $this->nmb__mbr_odd_key = $nmb__mbr_odd_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_bun_prd_key(): ?string
    {
        return $this->nmb__mbr_bun_prd_key ?? null;
    }
    /**
     * Set nmb__mbr_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_bun_prd_key(?string $nmb__mbr_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_bun_prd_key) && !is_string($nmb__mbr_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_bun_prd_key, true), gettype($nmb__mbr_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_bun_prd_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_bun_prd_key) || (is_array($nmb__mbr_bun_prd_key) && empty($nmb__mbr_bun_prd_key))) {
            unset($this->nmb__mbr_bun_prd_key);
        } else {
            $this->nmb__mbr_bun_prd_key = $nmb__mbr_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_bun_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_bun_prd_renewal_key(): ?string
    {
        return $this->nmb__mbr_bun_prd_renewal_key ?? null;
    }
    /**
     * Set nmb__mbr_bun_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_bun_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_bun_prd_renewal_key(?string $nmb__mbr_bun_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_bun_prd_renewal_key) && !is_string($nmb__mbr_bun_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_bun_prd_renewal_key, true), gettype($nmb__mbr_bun_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_bun_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_bun_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_bun_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_bun_prd_renewal_key) || (is_array($nmb__mbr_bun_prd_renewal_key) && empty($nmb__mbr_bun_prd_renewal_key))) {
            unset($this->nmb__mbr_bun_prd_renewal_key);
        } else {
            $this->nmb__mbr_bun_prd_renewal_key = $nmb__mbr_bun_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_prc_key(): ?string
    {
        return $this->nmb__mbr_prc_key ?? null;
    }
    /**
     * Set nmb__mbr_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_prc_key(?string $nmb__mbr_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_prc_key) && !is_string($nmb__mbr_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_prc_key, true), gettype($nmb__mbr_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_prc_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_prc_key) || (is_array($nmb__mbr_prc_key) && empty($nmb__mbr_prc_key))) {
            unset($this->nmb__mbr_prc_key);
        } else {
            $this->nmb__mbr_prc_key = $nmb__mbr_prc_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_bup_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_bup_key(): ?string
    {
        return $this->nmb__mbr_bup_key ?? null;
    }
    /**
     * Set nmb__mbr_bup_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_bup_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_bup_key(?string $nmb__mbr_bup_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_bup_key) && !is_string($nmb__mbr_bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_bup_key, true), gettype($nmb__mbr_bup_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_bup_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_bup_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_bup_key) || (is_array($nmb__mbr_bup_key) && empty($nmb__mbr_bup_key))) {
            unset($this->nmb__mbr_bup_key);
        } else {
            $this->nmb__mbr_bup_key = $nmb__mbr_bup_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_mbt_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_mbt_renewal_key(): ?string
    {
        return $this->nmb__mbr_mbt_renewal_key ?? null;
    }
    /**
     * Set nmb__mbr_mbt_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_mbt_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_mbt_renewal_key(?string $nmb__mbr_mbt_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_mbt_renewal_key) && !is_string($nmb__mbr_mbt_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_mbt_renewal_key, true), gettype($nmb__mbr_mbt_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_mbt_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_mbt_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_mbt_renewal_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_mbt_renewal_key) || (is_array($nmb__mbr_mbt_renewal_key) && empty($nmb__mbr_mbt_renewal_key))) {
            unset($this->nmb__mbr_mbt_renewal_key);
        } else {
            $this->nmb__mbr_mbt_renewal_key = $nmb__mbr_mbt_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_chp_cst_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_chp_cst_renewal_key(): ?string
    {
        return $this->nmb__mbr_chp_cst_renewal_key ?? null;
    }
    /**
     * Set nmb__mbr_chp_cst_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_chp_cst_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_chp_cst_renewal_key(?string $nmb__mbr_chp_cst_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_chp_cst_renewal_key) && !is_string($nmb__mbr_chp_cst_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_chp_cst_renewal_key, true), gettype($nmb__mbr_chp_cst_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_chp_cst_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_chp_cst_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_chp_cst_renewal_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_chp_cst_renewal_key) || (is_array($nmb__mbr_chp_cst_renewal_key) && empty($nmb__mbr_chp_cst_renewal_key))) {
            unset($this->nmb__mbr_chp_cst_renewal_key);
        } else {
            $this->nmb__mbr_chp_cst_renewal_key = $nmb__mbr_chp_cst_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_cpi_key(): ?string
    {
        return $this->nmb__mbr_cpi_key ?? null;
    }
    /**
     * Set nmb__mbr_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_cpi_key(?string $nmb__mbr_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_cpi_key) && !is_string($nmb__mbr_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_cpi_key, true), gettype($nmb__mbr_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_cpi_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_cpi_key) || (is_array($nmb__mbr_cpi_key) && empty($nmb__mbr_cpi_key))) {
            unset($this->nmb__mbr_cpi_key);
        } else {
            $this->nmb__mbr_cpi_key = $nmb__mbr_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_auto_pay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_auto_pay(): ?string
    {
        return $this->nmb__mbr_auto_pay ?? null;
    }
    /**
     * Set nmb__mbr_auto_pay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_auto_pay
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_auto_pay(?string $nmb__mbr_auto_pay = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_auto_pay) && !is_string($nmb__mbr_auto_pay)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_auto_pay, true), gettype($nmb__mbr_auto_pay)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_auto_pay) && $nmb__mbr_auto_pay > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_auto_pay, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_auto_pay) && $nmb__mbr_auto_pay < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_auto_pay, true)), __LINE__);
        }
        if (is_null($nmb__mbr_auto_pay) || (is_array($nmb__mbr_auto_pay) && empty($nmb__mbr_auto_pay))) {
            unset($this->nmb__mbr_auto_pay);
        } else {
            $this->nmb__mbr_auto_pay = $nmb__mbr_auto_pay;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_installment_payments_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_installment_payments_flag(): ?string
    {
        return $this->nmb__mbr_installment_payments_flag ?? null;
    }
    /**
     * Set nmb__mbr_installment_payments_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_installment_payments_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_installment_payments_flag(?string $nmb__mbr_installment_payments_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_installment_payments_flag) && !is_string($nmb__mbr_installment_payments_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_installment_payments_flag, true), gettype($nmb__mbr_installment_payments_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nmb__mbr_installment_payments_flag) && $nmb__mbr_installment_payments_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nmb__mbr_installment_payments_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nmb__mbr_installment_payments_flag) && $nmb__mbr_installment_payments_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nmb__mbr_installment_payments_flag, true)), __LINE__);
        }
        if (is_null($nmb__mbr_installment_payments_flag) || (is_array($nmb__mbr_installment_payments_flag) && empty($nmb__mbr_installment_payments_flag))) {
            unset($this->nmb__mbr_installment_payments_flag);
        } else {
            $this->nmb__mbr_installment_payments_flag = $nmb__mbr_installment_payments_flag;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_gft_key(): ?string
    {
        return $this->nmb__mbr_gft_key ?? null;
    }
    /**
     * Set nmb__mbr_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_gft_key(?string $nmb__mbr_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_gft_key) && !is_string($nmb__mbr_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_gft_key, true), gettype($nmb__mbr_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nmb__mbr_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nmb__mbr_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nmb__mbr_gft_key, true)), __LINE__);
        }
        if (is_null($nmb__mbr_gft_key) || (is_array($nmb__mbr_gft_key) && empty($nmb__mbr_gft_key))) {
            unset($this->nmb__mbr_gft_key);
        } else {
            $this->nmb__mbr_gft_key = $nmb__mbr_gft_key;
        }
        
        return $this;
    }
    /**
     * Get nmb__mbr_cpi_consent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNmb__mbr_cpi_consent_date(): ?string
    {
        return $this->nmb__mbr_cpi_consent_date ?? null;
    }
    /**
     * Set nmb__mbr_cpi_consent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nmb__mbr_cpi_consent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Change_Membership_DataObjectType
     */
    public function setNmb__mbr_cpi_consent_date(?string $nmb__mbr_cpi_consent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nmb__mbr_cpi_consent_date) && !is_string($nmb__mbr_cpi_consent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nmb__mbr_cpi_consent_date, true), gettype($nmb__mbr_cpi_consent_date)), __LINE__);
        }
        if (is_null($nmb__mbr_cpi_consent_date) || (is_array($nmb__mbr_cpi_consent_date) && empty($nmb__mbr_cpi_consent_date))) {
            unset($this->nmb__mbr_cpi_consent_date);
        } else {
            $this->nmb__mbr_cpi_consent_date = $nmb__mbr_cpi_consent_date;
        }
        
        return $this;
    }
}
