<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Chapter_Product_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Chapter_Product_DataObjectType extends AbstractStructBase
{
    /**
     * The cpr__prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_key = null;
    /**
     * The cpr__prd_name
     * Meta information extracted from the WSDL
     * - documentation: Product Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_name = null;
    /**
     * The cpr__prd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_add_user = null;
    /**
     * The cpr__prd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_add_date = null;
    /**
     * The cpr__prd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_change_user = null;
    /**
     * The cpr__prd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_change_date = null;
    /**
     * The cpr__prd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_delete_flag = null;
    /**
     * The cpr__prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_key_ext = null;
    /**
     * The cpr__prd_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_description = null;
    /**
     * The cpr__prd_allow_partial_ship_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Partial Shipments. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_allow_partial_ship_flag = null;
    /**
     * The cpr__prd_track_inventory_flag
     * Meta information extracted from the WSDL
     * - documentation: Track Inventory Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_track_inventory_flag = null;
    /**
     * The cpr__prd_gla_cogs_key
     * Meta information extracted from the WSDL
     * - documentation: COGS Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_gla_cogs_key = null;
    /**
     * The cpr__prd_gla_inventory_key
     * Meta information extracted from the WSDL
     * - documentation: Inventory Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_gla_inventory_key = null;
    /**
     * The cpr__prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_ptp_key = null;
    /**
     * The cpr__prd_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_start_date = null;
    /**
     * The cpr__prd_taxable_flag
     * Meta information extracted from the WSDL
     * - documentation: Taxable Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_taxable_flag = null;
    /**
     * The cpr__prd_allow_backorder
     * Meta information extracted from the WSDL
     * - documentation: Allow Backorders. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_allow_backorder = null;
    /**
     * The cpr__prd_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_end_date = null;
    /**
     * The cpr__prd_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Business Unit.This element has a default value of 'aad02d37-912e-47b0-88fe-ee3b6caf35da'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_atc_key = null;
    /**
     * The cpr__prd_qty_reorder
     * Meta information extracted from the WSDL
     * - documentation: Quantity on Order. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cpr__prd_qty_reorder = null;
    /**
     * The cpr__prd_restock_fee
     * Meta information extracted from the WSDL
     * - documentation: Default Restocking Fee. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cpr__prd_restock_fee = null;
    /**
     * The cpr__prd_restock_percent
     * Meta information extracted from the WSDL
     * - documentation: Default Restocking Percent. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cpr__prd_restock_percent = null;
    /**
     * The cpr__prd_restock_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: restock percent. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cpr__prd_restock_percent_cp = null;
    /**
     * The cpr__prd_mail
     * Meta information extracted from the WSDL
     * - documentation: send via mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_mail = null;
    /**
     * The cpr__prd_email
     * Meta information extracted from the WSDL
     * - documentation: send via email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_email = null;
    /**
     * The cpr__prd_fax
     * Meta information extracted from the WSDL
     * - documentation: send via fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_fax = null;
    /**
     * The cpr__prd_sell_online
     * Meta information extracted from the WSDL
     * - documentation: Sell Online?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_sell_online = null;
    /**
     * The cpr__prd_online_abstract
     * Meta information extracted from the WSDL
     * - documentation: Online Abstract. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_online_abstract = null;
    /**
     * The cpr__prd_code
     * Meta information extracted from the WSDL
     * - documentation: Product Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_code = null;
    /**
     * The cpr__prd_short_description
     * Meta information extracted from the WSDL
     * - documentation: Short Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_short_description = null;
    /**
     * The cpr__prd_thumbnail_doc_key
     * Meta information extracted from the WSDL
     * - documentation: Thumbnail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_thumbnail_doc_key = null;
    /**
     * The cpr__prd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_entity_key = null;
    /**
     * The cpr__prd_web
     * Meta information extracted from the WSDL
     * - documentation: send via web. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_web = null;
    /**
     * The cpr__prd_microfiche
     * Meta information extracted from the WSDL
     * - documentation: send via microfiche. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_microfiche = null;
    /**
     * The cpr__prd_post_to_web_date
     * Meta information extracted from the WSDL
     * - documentation: post to web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_post_to_web_date = null;
    /**
     * The cpr__prd_remove_from_web_date
     * Meta information extracted from the WSDL
     * - documentation: remove from web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_remove_from_web_date = null;
    /**
     * The cpr__prd_ptc_key
     * Meta information extracted from the WSDL
     * - documentation: Product Category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_ptc_key = null;
    /**
     * The cpr__prd_format
     * Meta information extracted from the WSDL
     * - documentation: Product Format. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_format = null;
    /**
     * The cpr__prd_download_url
     * Meta information extracted from the WSDL
     * - documentation: Electronic Product Download UR. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_download_url = null;
    /**
     * The cpr__prd_show_as_new_until
     * Meta information extracted from the WSDL
     * - documentation: Show as new until. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_show_as_new_until = null;
    /**
     * The cpr__prd_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_pjt_key = null;
    /**
     * The cpr__prd_gla_damaged_goods_key
     * Meta information extracted from the WSDL
     * - documentation: Damaged Goods Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_gla_damaged_goods_key = null;
    /**
     * The cpr__prd_order
     * Meta information extracted from the WSDL
     * - documentation: order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cpr__prd_order = null;
    /**
     * The cpr__prd_download_available_days
     * Meta information extracted from the WSDL
     * - documentation: Days Available. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cpr__prd_download_available_days = null;
    /**
     * The cpr__prd_weighted_average_cost
     * Meta information extracted from the WSDL
     * - documentation: Weighted Average Cost. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cpr__prd_weighted_average_cost = null;
    /**
     * The cpr__prd_featured_product_flag
     * Meta information extracted from the WSDL
     * - documentation: Featured Product?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_featured_product_flag = null;
    /**
     * The cpr__prd_download_available_count
     * Meta information extracted from the WSDL
     * - documentation: Number of Available Downloads. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cpr__prd_download_available_count = null;
    /**
     * The cpr__prd_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_cct_key = null;
    /**
     * The cpr__prd_pts_key
     * Meta information extracted from the WSDL
     * - documentation: Subcategory. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_pts_key = null;
    /**
     * The cpr__prd_cmo_key
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_cmo_key = null;
    /**
     * The cpr__prd_out_of_stock_override_message
     * Meta information extracted from the WSDL
     * - documentation: Out of stock override message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_out_of_stock_override_message = null;
    /**
     * The cpr__prd_pst_key
     * Meta information extracted from the WSDL
     * - documentation: Size/Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_pst_key = null;
    /**
     * The cpr__prd_pcr_key
     * Meta information extracted from the WSDL
     * - documentation: Color. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_pcr_key = null;
    /**
     * The cpr__prd_display_product_name
     * Meta information extracted from the WSDL
     * - documentation: Display/Search Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpr__prd_display_product_name = null;
    /**
     * The cpr__prd_display_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Display/Search Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpr__prd_display_prd_key = null;
    /**
     * Constructor method for mb_membership_Chapter_Product_DataObjectType
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_name()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_add_user()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_add_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_change_user()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_change_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_delete_flag()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_key_ext()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_description()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_allow_partial_ship_flag()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_track_inventory_flag()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_gla_cogs_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_gla_inventory_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_ptp_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_start_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_taxable_flag()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_allow_backorder()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_end_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_atc_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_qty_reorder()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_restock_fee()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_restock_percent()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_restock_percent_cp()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_mail()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_email()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_fax()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_sell_online()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_online_abstract()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_code()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_short_description()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_thumbnail_doc_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_entity_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_web()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_microfiche()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_post_to_web_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_remove_from_web_date()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_ptc_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_format()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_download_url()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_show_as_new_until()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_pjt_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_gla_damaged_goods_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_order()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_download_available_days()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_weighted_average_cost()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_featured_product_flag()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_download_available_count()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_cct_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_pts_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_cmo_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_out_of_stock_override_message()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_pst_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_pcr_key()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_display_product_name()
     * @uses Mb_membership_Chapter_Product_DataObjectType::setCpr__prd_display_prd_key()
     * @param string $cpr__prd_key
     * @param string $cpr__prd_name
     * @param string $cpr__prd_add_user
     * @param string $cpr__prd_add_date
     * @param string $cpr__prd_change_user
     * @param string $cpr__prd_change_date
     * @param string $cpr__prd_delete_flag
     * @param string $cpr__prd_key_ext
     * @param string $cpr__prd_description
     * @param string $cpr__prd_allow_partial_ship_flag
     * @param string $cpr__prd_track_inventory_flag
     * @param string $cpr__prd_gla_cogs_key
     * @param string $cpr__prd_gla_inventory_key
     * @param string $cpr__prd_ptp_key
     * @param string $cpr__prd_start_date
     * @param string $cpr__prd_taxable_flag
     * @param string $cpr__prd_allow_backorder
     * @param string $cpr__prd_end_date
     * @param string $cpr__prd_atc_key
     * @param float $cpr__prd_qty_reorder
     * @param float $cpr__prd_restock_fee
     * @param float $cpr__prd_restock_percent
     * @param float $cpr__prd_restock_percent_cp
     * @param string $cpr__prd_mail
     * @param string $cpr__prd_email
     * @param string $cpr__prd_fax
     * @param string $cpr__prd_sell_online
     * @param string $cpr__prd_online_abstract
     * @param string $cpr__prd_code
     * @param string $cpr__prd_short_description
     * @param string $cpr__prd_thumbnail_doc_key
     * @param string $cpr__prd_entity_key
     * @param string $cpr__prd_web
     * @param string $cpr__prd_microfiche
     * @param string $cpr__prd_post_to_web_date
     * @param string $cpr__prd_remove_from_web_date
     * @param string $cpr__prd_ptc_key
     * @param string $cpr__prd_format
     * @param string $cpr__prd_download_url
     * @param string $cpr__prd_show_as_new_until
     * @param string $cpr__prd_pjt_key
     * @param string $cpr__prd_gla_damaged_goods_key
     * @param int $cpr__prd_order
     * @param int $cpr__prd_download_available_days
     * @param float $cpr__prd_weighted_average_cost
     * @param string $cpr__prd_featured_product_flag
     * @param int $cpr__prd_download_available_count
     * @param string $cpr__prd_cct_key
     * @param string $cpr__prd_pts_key
     * @param string $cpr__prd_cmo_key
     * @param string $cpr__prd_out_of_stock_override_message
     * @param string $cpr__prd_pst_key
     * @param string $cpr__prd_pcr_key
     * @param string $cpr__prd_display_product_name
     * @param string $cpr__prd_display_prd_key
     */
    public function __construct(?string $cpr__prd_key = null, ?string $cpr__prd_name = null, ?string $cpr__prd_add_user = null, ?string $cpr__prd_add_date = null, ?string $cpr__prd_change_user = null, ?string $cpr__prd_change_date = null, ?string $cpr__prd_delete_flag = null, ?string $cpr__prd_key_ext = null, ?string $cpr__prd_description = null, ?string $cpr__prd_allow_partial_ship_flag = null, ?string $cpr__prd_track_inventory_flag = null, ?string $cpr__prd_gla_cogs_key = null, ?string $cpr__prd_gla_inventory_key = null, ?string $cpr__prd_ptp_key = null, ?string $cpr__prd_start_date = null, ?string $cpr__prd_taxable_flag = null, ?string $cpr__prd_allow_backorder = null, ?string $cpr__prd_end_date = null, ?string $cpr__prd_atc_key = null, ?float $cpr__prd_qty_reorder = null, ?float $cpr__prd_restock_fee = null, ?float $cpr__prd_restock_percent = null, ?float $cpr__prd_restock_percent_cp = null, ?string $cpr__prd_mail = null, ?string $cpr__prd_email = null, ?string $cpr__prd_fax = null, ?string $cpr__prd_sell_online = null, ?string $cpr__prd_online_abstract = null, ?string $cpr__prd_code = null, ?string $cpr__prd_short_description = null, ?string $cpr__prd_thumbnail_doc_key = null, ?string $cpr__prd_entity_key = null, ?string $cpr__prd_web = null, ?string $cpr__prd_microfiche = null, ?string $cpr__prd_post_to_web_date = null, ?string $cpr__prd_remove_from_web_date = null, ?string $cpr__prd_ptc_key = null, ?string $cpr__prd_format = null, ?string $cpr__prd_download_url = null, ?string $cpr__prd_show_as_new_until = null, ?string $cpr__prd_pjt_key = null, ?string $cpr__prd_gla_damaged_goods_key = null, ?int $cpr__prd_order = null, ?int $cpr__prd_download_available_days = null, ?float $cpr__prd_weighted_average_cost = null, ?string $cpr__prd_featured_product_flag = null, ?int $cpr__prd_download_available_count = null, ?string $cpr__prd_cct_key = null, ?string $cpr__prd_pts_key = null, ?string $cpr__prd_cmo_key = null, ?string $cpr__prd_out_of_stock_override_message = null, ?string $cpr__prd_pst_key = null, ?string $cpr__prd_pcr_key = null, ?string $cpr__prd_display_product_name = null, ?string $cpr__prd_display_prd_key = null)
    {
        $this
            ->setCpr__prd_key($cpr__prd_key)
            ->setCpr__prd_name($cpr__prd_name)
            ->setCpr__prd_add_user($cpr__prd_add_user)
            ->setCpr__prd_add_date($cpr__prd_add_date)
            ->setCpr__prd_change_user($cpr__prd_change_user)
            ->setCpr__prd_change_date($cpr__prd_change_date)
            ->setCpr__prd_delete_flag($cpr__prd_delete_flag)
            ->setCpr__prd_key_ext($cpr__prd_key_ext)
            ->setCpr__prd_description($cpr__prd_description)
            ->setCpr__prd_allow_partial_ship_flag($cpr__prd_allow_partial_ship_flag)
            ->setCpr__prd_track_inventory_flag($cpr__prd_track_inventory_flag)
            ->setCpr__prd_gla_cogs_key($cpr__prd_gla_cogs_key)
            ->setCpr__prd_gla_inventory_key($cpr__prd_gla_inventory_key)
            ->setCpr__prd_ptp_key($cpr__prd_ptp_key)
            ->setCpr__prd_start_date($cpr__prd_start_date)
            ->setCpr__prd_taxable_flag($cpr__prd_taxable_flag)
            ->setCpr__prd_allow_backorder($cpr__prd_allow_backorder)
            ->setCpr__prd_end_date($cpr__prd_end_date)
            ->setCpr__prd_atc_key($cpr__prd_atc_key)
            ->setCpr__prd_qty_reorder($cpr__prd_qty_reorder)
            ->setCpr__prd_restock_fee($cpr__prd_restock_fee)
            ->setCpr__prd_restock_percent($cpr__prd_restock_percent)
            ->setCpr__prd_restock_percent_cp($cpr__prd_restock_percent_cp)
            ->setCpr__prd_mail($cpr__prd_mail)
            ->setCpr__prd_email($cpr__prd_email)
            ->setCpr__prd_fax($cpr__prd_fax)
            ->setCpr__prd_sell_online($cpr__prd_sell_online)
            ->setCpr__prd_online_abstract($cpr__prd_online_abstract)
            ->setCpr__prd_code($cpr__prd_code)
            ->setCpr__prd_short_description($cpr__prd_short_description)
            ->setCpr__prd_thumbnail_doc_key($cpr__prd_thumbnail_doc_key)
            ->setCpr__prd_entity_key($cpr__prd_entity_key)
            ->setCpr__prd_web($cpr__prd_web)
            ->setCpr__prd_microfiche($cpr__prd_microfiche)
            ->setCpr__prd_post_to_web_date($cpr__prd_post_to_web_date)
            ->setCpr__prd_remove_from_web_date($cpr__prd_remove_from_web_date)
            ->setCpr__prd_ptc_key($cpr__prd_ptc_key)
            ->setCpr__prd_format($cpr__prd_format)
            ->setCpr__prd_download_url($cpr__prd_download_url)
            ->setCpr__prd_show_as_new_until($cpr__prd_show_as_new_until)
            ->setCpr__prd_pjt_key($cpr__prd_pjt_key)
            ->setCpr__prd_gla_damaged_goods_key($cpr__prd_gla_damaged_goods_key)
            ->setCpr__prd_order($cpr__prd_order)
            ->setCpr__prd_download_available_days($cpr__prd_download_available_days)
            ->setCpr__prd_weighted_average_cost($cpr__prd_weighted_average_cost)
            ->setCpr__prd_featured_product_flag($cpr__prd_featured_product_flag)
            ->setCpr__prd_download_available_count($cpr__prd_download_available_count)
            ->setCpr__prd_cct_key($cpr__prd_cct_key)
            ->setCpr__prd_pts_key($cpr__prd_pts_key)
            ->setCpr__prd_cmo_key($cpr__prd_cmo_key)
            ->setCpr__prd_out_of_stock_override_message($cpr__prd_out_of_stock_override_message)
            ->setCpr__prd_pst_key($cpr__prd_pst_key)
            ->setCpr__prd_pcr_key($cpr__prd_pcr_key)
            ->setCpr__prd_display_product_name($cpr__prd_display_product_name)
            ->setCpr__prd_display_prd_key($cpr__prd_display_prd_key);
    }
    /**
     * Get cpr__prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_key(): ?string
    {
        return $this->cpr__prd_key ?? null;
    }
    /**
     * Set cpr__prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_key(?string $cpr__prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_key) && !is_string($cpr__prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_key, true), gettype($cpr__prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_key) || (is_array($cpr__prd_key) && empty($cpr__prd_key))) {
            unset($this->cpr__prd_key);
        } else {
            $this->cpr__prd_key = $cpr__prd_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_name(): ?string
    {
        return $this->cpr__prd_name ?? null;
    }
    /**
     * Set cpr__prd_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_name(?string $cpr__prd_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_name) && !is_string($cpr__prd_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_name, true), gettype($cpr__prd_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cpr__prd_name) && mb_strlen((string) $cpr__prd_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $cpr__prd_name)), __LINE__);
        }
        if (is_null($cpr__prd_name) || (is_array($cpr__prd_name) && empty($cpr__prd_name))) {
            unset($this->cpr__prd_name);
        } else {
            $this->cpr__prd_name = $cpr__prd_name;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_add_user(): ?string
    {
        return $this->cpr__prd_add_user ?? null;
    }
    /**
     * Set cpr__prd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_add_user(?string $cpr__prd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_add_user) && !is_string($cpr__prd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_add_user, true), gettype($cpr__prd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cpr__prd_add_user) && mb_strlen((string) $cpr__prd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cpr__prd_add_user)), __LINE__);
        }
        if (is_null($cpr__prd_add_user) || (is_array($cpr__prd_add_user) && empty($cpr__prd_add_user))) {
            unset($this->cpr__prd_add_user);
        } else {
            $this->cpr__prd_add_user = $cpr__prd_add_user;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_add_date(): ?string
    {
        return $this->cpr__prd_add_date ?? null;
    }
    /**
     * Set cpr__prd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_add_date(?string $cpr__prd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_add_date) && !is_string($cpr__prd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_add_date, true), gettype($cpr__prd_add_date)), __LINE__);
        }
        if (is_null($cpr__prd_add_date) || (is_array($cpr__prd_add_date) && empty($cpr__prd_add_date))) {
            unset($this->cpr__prd_add_date);
        } else {
            $this->cpr__prd_add_date = $cpr__prd_add_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_change_user(): ?string
    {
        return $this->cpr__prd_change_user ?? null;
    }
    /**
     * Set cpr__prd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_change_user(?string $cpr__prd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_change_user) && !is_string($cpr__prd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_change_user, true), gettype($cpr__prd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cpr__prd_change_user) && mb_strlen((string) $cpr__prd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cpr__prd_change_user)), __LINE__);
        }
        if (is_null($cpr__prd_change_user) || (is_array($cpr__prd_change_user) && empty($cpr__prd_change_user))) {
            unset($this->cpr__prd_change_user);
        } else {
            $this->cpr__prd_change_user = $cpr__prd_change_user;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_change_date(): ?string
    {
        return $this->cpr__prd_change_date ?? null;
    }
    /**
     * Set cpr__prd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_change_date(?string $cpr__prd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_change_date) && !is_string($cpr__prd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_change_date, true), gettype($cpr__prd_change_date)), __LINE__);
        }
        if (is_null($cpr__prd_change_date) || (is_array($cpr__prd_change_date) && empty($cpr__prd_change_date))) {
            unset($this->cpr__prd_change_date);
        } else {
            $this->cpr__prd_change_date = $cpr__prd_change_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_delete_flag(): ?string
    {
        return $this->cpr__prd_delete_flag ?? null;
    }
    /**
     * Set cpr__prd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_delete_flag(?string $cpr__prd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_delete_flag) && !is_string($cpr__prd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_delete_flag, true), gettype($cpr__prd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_delete_flag) && $cpr__prd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_delete_flag) && $cpr__prd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_delete_flag, true)), __LINE__);
        }
        if (is_null($cpr__prd_delete_flag) || (is_array($cpr__prd_delete_flag) && empty($cpr__prd_delete_flag))) {
            unset($this->cpr__prd_delete_flag);
        } else {
            $this->cpr__prd_delete_flag = $cpr__prd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_key_ext(): ?string
    {
        return $this->cpr__prd_key_ext ?? null;
    }
    /**
     * Set cpr__prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_key_ext(?string $cpr__prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_key_ext) && !is_string($cpr__prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_key_ext, true), gettype($cpr__prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_key_ext, true)), __LINE__);
        }
        if (is_null($cpr__prd_key_ext) || (is_array($cpr__prd_key_ext) && empty($cpr__prd_key_ext))) {
            unset($this->cpr__prd_key_ext);
        } else {
            $this->cpr__prd_key_ext = $cpr__prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_description(): ?string
    {
        return $this->cpr__prd_description ?? null;
    }
    /**
     * Set cpr__prd_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_description(?string $cpr__prd_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_description) && !is_string($cpr__prd_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_description, true), gettype($cpr__prd_description)), __LINE__);
        }
        if (is_null($cpr__prd_description) || (is_array($cpr__prd_description) && empty($cpr__prd_description))) {
            unset($this->cpr__prd_description);
        } else {
            $this->cpr__prd_description = $cpr__prd_description;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_allow_partial_ship_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_allow_partial_ship_flag(): ?string
    {
        return $this->cpr__prd_allow_partial_ship_flag ?? null;
    }
    /**
     * Set cpr__prd_allow_partial_ship_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_allow_partial_ship_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_allow_partial_ship_flag(?string $cpr__prd_allow_partial_ship_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_allow_partial_ship_flag) && !is_string($cpr__prd_allow_partial_ship_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_allow_partial_ship_flag, true), gettype($cpr__prd_allow_partial_ship_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_allow_partial_ship_flag) && $cpr__prd_allow_partial_ship_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_allow_partial_ship_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_allow_partial_ship_flag) && $cpr__prd_allow_partial_ship_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_allow_partial_ship_flag, true)), __LINE__);
        }
        if (is_null($cpr__prd_allow_partial_ship_flag) || (is_array($cpr__prd_allow_partial_ship_flag) && empty($cpr__prd_allow_partial_ship_flag))) {
            unset($this->cpr__prd_allow_partial_ship_flag);
        } else {
            $this->cpr__prd_allow_partial_ship_flag = $cpr__prd_allow_partial_ship_flag;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_track_inventory_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_track_inventory_flag(): ?string
    {
        return $this->cpr__prd_track_inventory_flag ?? null;
    }
    /**
     * Set cpr__prd_track_inventory_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_track_inventory_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_track_inventory_flag(?string $cpr__prd_track_inventory_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_track_inventory_flag) && !is_string($cpr__prd_track_inventory_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_track_inventory_flag, true), gettype($cpr__prd_track_inventory_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_track_inventory_flag) && $cpr__prd_track_inventory_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_track_inventory_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_track_inventory_flag) && $cpr__prd_track_inventory_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_track_inventory_flag, true)), __LINE__);
        }
        if (is_null($cpr__prd_track_inventory_flag) || (is_array($cpr__prd_track_inventory_flag) && empty($cpr__prd_track_inventory_flag))) {
            unset($this->cpr__prd_track_inventory_flag);
        } else {
            $this->cpr__prd_track_inventory_flag = $cpr__prd_track_inventory_flag;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_gla_cogs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_gla_cogs_key(): ?string
    {
        return $this->cpr__prd_gla_cogs_key ?? null;
    }
    /**
     * Set cpr__prd_gla_cogs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_gla_cogs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_gla_cogs_key(?string $cpr__prd_gla_cogs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_gla_cogs_key) && !is_string($cpr__prd_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_gla_cogs_key, true), gettype($cpr__prd_gla_cogs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_gla_cogs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_gla_cogs_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_gla_cogs_key) || (is_array($cpr__prd_gla_cogs_key) && empty($cpr__prd_gla_cogs_key))) {
            unset($this->cpr__prd_gla_cogs_key);
        } else {
            $this->cpr__prd_gla_cogs_key = $cpr__prd_gla_cogs_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_gla_inventory_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_gla_inventory_key(): ?string
    {
        return $this->cpr__prd_gla_inventory_key ?? null;
    }
    /**
     * Set cpr__prd_gla_inventory_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_gla_inventory_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_gla_inventory_key(?string $cpr__prd_gla_inventory_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_gla_inventory_key) && !is_string($cpr__prd_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_gla_inventory_key, true), gettype($cpr__prd_gla_inventory_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_gla_inventory_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_gla_inventory_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_gla_inventory_key) || (is_array($cpr__prd_gla_inventory_key) && empty($cpr__prd_gla_inventory_key))) {
            unset($this->cpr__prd_gla_inventory_key);
        } else {
            $this->cpr__prd_gla_inventory_key = $cpr__prd_gla_inventory_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_ptp_key(): ?string
    {
        return $this->cpr__prd_ptp_key ?? null;
    }
    /**
     * Set cpr__prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_ptp_key(?string $cpr__prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_ptp_key) && !is_string($cpr__prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_ptp_key, true), gettype($cpr__prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_ptp_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_ptp_key) || (is_array($cpr__prd_ptp_key) && empty($cpr__prd_ptp_key))) {
            unset($this->cpr__prd_ptp_key);
        } else {
            $this->cpr__prd_ptp_key = $cpr__prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_start_date(): ?string
    {
        return $this->cpr__prd_start_date ?? null;
    }
    /**
     * Set cpr__prd_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_start_date(?string $cpr__prd_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_start_date) && !is_string($cpr__prd_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_start_date, true), gettype($cpr__prd_start_date)), __LINE__);
        }
        if (is_null($cpr__prd_start_date) || (is_array($cpr__prd_start_date) && empty($cpr__prd_start_date))) {
            unset($this->cpr__prd_start_date);
        } else {
            $this->cpr__prd_start_date = $cpr__prd_start_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_taxable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_taxable_flag(): ?string
    {
        return $this->cpr__prd_taxable_flag ?? null;
    }
    /**
     * Set cpr__prd_taxable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_taxable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_taxable_flag(?string $cpr__prd_taxable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_taxable_flag) && !is_string($cpr__prd_taxable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_taxable_flag, true), gettype($cpr__prd_taxable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_taxable_flag) && $cpr__prd_taxable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_taxable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_taxable_flag) && $cpr__prd_taxable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_taxable_flag, true)), __LINE__);
        }
        if (is_null($cpr__prd_taxable_flag) || (is_array($cpr__prd_taxable_flag) && empty($cpr__prd_taxable_flag))) {
            unset($this->cpr__prd_taxable_flag);
        } else {
            $this->cpr__prd_taxable_flag = $cpr__prd_taxable_flag;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_allow_backorder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_allow_backorder(): ?string
    {
        return $this->cpr__prd_allow_backorder ?? null;
    }
    /**
     * Set cpr__prd_allow_backorder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_allow_backorder
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_allow_backorder(?string $cpr__prd_allow_backorder = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_allow_backorder) && !is_string($cpr__prd_allow_backorder)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_allow_backorder, true), gettype($cpr__prd_allow_backorder)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_allow_backorder) && $cpr__prd_allow_backorder > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_allow_backorder, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_allow_backorder) && $cpr__prd_allow_backorder < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_allow_backorder, true)), __LINE__);
        }
        if (is_null($cpr__prd_allow_backorder) || (is_array($cpr__prd_allow_backorder) && empty($cpr__prd_allow_backorder))) {
            unset($this->cpr__prd_allow_backorder);
        } else {
            $this->cpr__prd_allow_backorder = $cpr__prd_allow_backorder;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_end_date(): ?string
    {
        return $this->cpr__prd_end_date ?? null;
    }
    /**
     * Set cpr__prd_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_end_date(?string $cpr__prd_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_end_date) && !is_string($cpr__prd_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_end_date, true), gettype($cpr__prd_end_date)), __LINE__);
        }
        if (is_null($cpr__prd_end_date) || (is_array($cpr__prd_end_date) && empty($cpr__prd_end_date))) {
            unset($this->cpr__prd_end_date);
        } else {
            $this->cpr__prd_end_date = $cpr__prd_end_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_atc_key(): ?string
    {
        return $this->cpr__prd_atc_key ?? null;
    }
    /**
     * Set cpr__prd_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_atc_key(?string $cpr__prd_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_atc_key) && !is_string($cpr__prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_atc_key, true), gettype($cpr__prd_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_atc_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_atc_key) || (is_array($cpr__prd_atc_key) && empty($cpr__prd_atc_key))) {
            unset($this->cpr__prd_atc_key);
        } else {
            $this->cpr__prd_atc_key = $cpr__prd_atc_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_qty_reorder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCpr__prd_qty_reorder(): ?float
    {
        return $this->cpr__prd_qty_reorder ?? null;
    }
    /**
     * Set cpr__prd_qty_reorder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cpr__prd_qty_reorder
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_qty_reorder(?float $cpr__prd_qty_reorder = null): self
    {
        // validation for constraint: float
        if (!is_null($cpr__prd_qty_reorder) && !(is_float($cpr__prd_qty_reorder) || is_numeric($cpr__prd_qty_reorder))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpr__prd_qty_reorder, true), gettype($cpr__prd_qty_reorder)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cpr__prd_qty_reorder) && mb_strlen(mb_substr((string) $cpr__prd_qty_reorder, false !== mb_strpos((string) $cpr__prd_qty_reorder, '.') ? mb_strpos((string) $cpr__prd_qty_reorder, '.') + 1 : mb_strlen((string) $cpr__prd_qty_reorder))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cpr__prd_qty_reorder, true), mb_strlen(mb_substr((string) $cpr__prd_qty_reorder, mb_strpos((string) $cpr__prd_qty_reorder, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cpr__prd_qty_reorder) && mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_qty_reorder)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cpr__prd_qty_reorder, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_qty_reorder))), __LINE__);
        }
        if (is_null($cpr__prd_qty_reorder) || (is_array($cpr__prd_qty_reorder) && empty($cpr__prd_qty_reorder))) {
            unset($this->cpr__prd_qty_reorder);
        } else {
            $this->cpr__prd_qty_reorder = $cpr__prd_qty_reorder;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_restock_fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCpr__prd_restock_fee(): ?float
    {
        return $this->cpr__prd_restock_fee ?? null;
    }
    /**
     * Set cpr__prd_restock_fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cpr__prd_restock_fee
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_restock_fee(?float $cpr__prd_restock_fee = null): self
    {
        // validation for constraint: float
        if (!is_null($cpr__prd_restock_fee) && !(is_float($cpr__prd_restock_fee) || is_numeric($cpr__prd_restock_fee))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpr__prd_restock_fee, true), gettype($cpr__prd_restock_fee)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cpr__prd_restock_fee) && mb_strlen(mb_substr((string) $cpr__prd_restock_fee, false !== mb_strpos((string) $cpr__prd_restock_fee, '.') ? mb_strpos((string) $cpr__prd_restock_fee, '.') + 1 : mb_strlen((string) $cpr__prd_restock_fee))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cpr__prd_restock_fee, true), mb_strlen(mb_substr((string) $cpr__prd_restock_fee, mb_strpos((string) $cpr__prd_restock_fee, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cpr__prd_restock_fee) && mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_fee)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cpr__prd_restock_fee, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_fee))), __LINE__);
        }
        if (is_null($cpr__prd_restock_fee) || (is_array($cpr__prd_restock_fee) && empty($cpr__prd_restock_fee))) {
            unset($this->cpr__prd_restock_fee);
        } else {
            $this->cpr__prd_restock_fee = $cpr__prd_restock_fee;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_restock_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCpr__prd_restock_percent(): ?float
    {
        return $this->cpr__prd_restock_percent ?? null;
    }
    /**
     * Set cpr__prd_restock_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cpr__prd_restock_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_restock_percent(?float $cpr__prd_restock_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($cpr__prd_restock_percent) && !(is_float($cpr__prd_restock_percent) || is_numeric($cpr__prd_restock_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpr__prd_restock_percent, true), gettype($cpr__prd_restock_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cpr__prd_restock_percent) && mb_strlen(mb_substr((string) $cpr__prd_restock_percent, false !== mb_strpos((string) $cpr__prd_restock_percent, '.') ? mb_strpos((string) $cpr__prd_restock_percent, '.') + 1 : mb_strlen((string) $cpr__prd_restock_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cpr__prd_restock_percent, true), mb_strlen(mb_substr((string) $cpr__prd_restock_percent, mb_strpos((string) $cpr__prd_restock_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cpr__prd_restock_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cpr__prd_restock_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_percent))), __LINE__);
        }
        if (is_null($cpr__prd_restock_percent) || (is_array($cpr__prd_restock_percent) && empty($cpr__prd_restock_percent))) {
            unset($this->cpr__prd_restock_percent);
        } else {
            $this->cpr__prd_restock_percent = $cpr__prd_restock_percent;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_restock_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCpr__prd_restock_percent_cp(): ?float
    {
        return $this->cpr__prd_restock_percent_cp ?? null;
    }
    /**
     * Set cpr__prd_restock_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cpr__prd_restock_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_restock_percent_cp(?float $cpr__prd_restock_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($cpr__prd_restock_percent_cp) && !(is_float($cpr__prd_restock_percent_cp) || is_numeric($cpr__prd_restock_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpr__prd_restock_percent_cp, true), gettype($cpr__prd_restock_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cpr__prd_restock_percent_cp) && mb_strlen(mb_substr((string) $cpr__prd_restock_percent_cp, false !== mb_strpos((string) $cpr__prd_restock_percent_cp, '.') ? mb_strpos((string) $cpr__prd_restock_percent_cp, '.') + 1 : mb_strlen((string) $cpr__prd_restock_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cpr__prd_restock_percent_cp, true), mb_strlen(mb_substr((string) $cpr__prd_restock_percent_cp, mb_strpos((string) $cpr__prd_restock_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cpr__prd_restock_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cpr__prd_restock_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_restock_percent_cp))), __LINE__);
        }
        if (is_null($cpr__prd_restock_percent_cp) || (is_array($cpr__prd_restock_percent_cp) && empty($cpr__prd_restock_percent_cp))) {
            unset($this->cpr__prd_restock_percent_cp);
        } else {
            $this->cpr__prd_restock_percent_cp = $cpr__prd_restock_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_mail(): ?string
    {
        return $this->cpr__prd_mail ?? null;
    }
    /**
     * Set cpr__prd_mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_mail
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_mail(?string $cpr__prd_mail = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_mail) && !is_string($cpr__prd_mail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_mail, true), gettype($cpr__prd_mail)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_mail) && $cpr__prd_mail > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_mail, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_mail) && $cpr__prd_mail < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_mail, true)), __LINE__);
        }
        if (is_null($cpr__prd_mail) || (is_array($cpr__prd_mail) && empty($cpr__prd_mail))) {
            unset($this->cpr__prd_mail);
        } else {
            $this->cpr__prd_mail = $cpr__prd_mail;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_email(): ?string
    {
        return $this->cpr__prd_email ?? null;
    }
    /**
     * Set cpr__prd_email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_email
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_email(?string $cpr__prd_email = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_email) && !is_string($cpr__prd_email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_email, true), gettype($cpr__prd_email)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_email) && $cpr__prd_email > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_email, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_email) && $cpr__prd_email < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_email, true)), __LINE__);
        }
        if (is_null($cpr__prd_email) || (is_array($cpr__prd_email) && empty($cpr__prd_email))) {
            unset($this->cpr__prd_email);
        } else {
            $this->cpr__prd_email = $cpr__prd_email;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_fax(): ?string
    {
        return $this->cpr__prd_fax ?? null;
    }
    /**
     * Set cpr__prd_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_fax(?string $cpr__prd_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_fax) && !is_string($cpr__prd_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_fax, true), gettype($cpr__prd_fax)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_fax) && $cpr__prd_fax > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_fax, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_fax) && $cpr__prd_fax < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_fax, true)), __LINE__);
        }
        if (is_null($cpr__prd_fax) || (is_array($cpr__prd_fax) && empty($cpr__prd_fax))) {
            unset($this->cpr__prd_fax);
        } else {
            $this->cpr__prd_fax = $cpr__prd_fax;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_sell_online value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_sell_online(): ?string
    {
        return $this->cpr__prd_sell_online ?? null;
    }
    /**
     * Set cpr__prd_sell_online value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_sell_online
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_sell_online(?string $cpr__prd_sell_online = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_sell_online) && !is_string($cpr__prd_sell_online)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_sell_online, true), gettype($cpr__prd_sell_online)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_sell_online) && $cpr__prd_sell_online > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_sell_online, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_sell_online) && $cpr__prd_sell_online < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_sell_online, true)), __LINE__);
        }
        if (is_null($cpr__prd_sell_online) || (is_array($cpr__prd_sell_online) && empty($cpr__prd_sell_online))) {
            unset($this->cpr__prd_sell_online);
        } else {
            $this->cpr__prd_sell_online = $cpr__prd_sell_online;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_online_abstract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_online_abstract(): ?string
    {
        return $this->cpr__prd_online_abstract ?? null;
    }
    /**
     * Set cpr__prd_online_abstract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_online_abstract
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_online_abstract(?string $cpr__prd_online_abstract = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_online_abstract) && !is_string($cpr__prd_online_abstract)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_online_abstract, true), gettype($cpr__prd_online_abstract)), __LINE__);
        }
        if (is_null($cpr__prd_online_abstract) || (is_array($cpr__prd_online_abstract) && empty($cpr__prd_online_abstract))) {
            unset($this->cpr__prd_online_abstract);
        } else {
            $this->cpr__prd_online_abstract = $cpr__prd_online_abstract;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_code(): ?string
    {
        return $this->cpr__prd_code ?? null;
    }
    /**
     * Set cpr__prd_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_code(?string $cpr__prd_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_code) && !is_string($cpr__prd_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_code, true), gettype($cpr__prd_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cpr__prd_code) && mb_strlen((string) $cpr__prd_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cpr__prd_code)), __LINE__);
        }
        if (is_null($cpr__prd_code) || (is_array($cpr__prd_code) && empty($cpr__prd_code))) {
            unset($this->cpr__prd_code);
        } else {
            $this->cpr__prd_code = $cpr__prd_code;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_short_description(): ?string
    {
        return $this->cpr__prd_short_description ?? null;
    }
    /**
     * Set cpr__prd_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_short_description(?string $cpr__prd_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_short_description) && !is_string($cpr__prd_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_short_description, true), gettype($cpr__prd_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($cpr__prd_short_description) && mb_strlen((string) $cpr__prd_short_description) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $cpr__prd_short_description)), __LINE__);
        }
        if (is_null($cpr__prd_short_description) || (is_array($cpr__prd_short_description) && empty($cpr__prd_short_description))) {
            unset($this->cpr__prd_short_description);
        } else {
            $this->cpr__prd_short_description = $cpr__prd_short_description;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_thumbnail_doc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_thumbnail_doc_key(): ?string
    {
        return $this->cpr__prd_thumbnail_doc_key ?? null;
    }
    /**
     * Set cpr__prd_thumbnail_doc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_thumbnail_doc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_thumbnail_doc_key(?string $cpr__prd_thumbnail_doc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_thumbnail_doc_key) && !is_string($cpr__prd_thumbnail_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_thumbnail_doc_key, true), gettype($cpr__prd_thumbnail_doc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_thumbnail_doc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_thumbnail_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_thumbnail_doc_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_thumbnail_doc_key) || (is_array($cpr__prd_thumbnail_doc_key) && empty($cpr__prd_thumbnail_doc_key))) {
            unset($this->cpr__prd_thumbnail_doc_key);
        } else {
            $this->cpr__prd_thumbnail_doc_key = $cpr__prd_thumbnail_doc_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_entity_key(): ?string
    {
        return $this->cpr__prd_entity_key ?? null;
    }
    /**
     * Set cpr__prd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_entity_key(?string $cpr__prd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_entity_key) && !is_string($cpr__prd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_entity_key, true), gettype($cpr__prd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_entity_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_entity_key) || (is_array($cpr__prd_entity_key) && empty($cpr__prd_entity_key))) {
            unset($this->cpr__prd_entity_key);
        } else {
            $this->cpr__prd_entity_key = $cpr__prd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_web value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_web(): ?string
    {
        return $this->cpr__prd_web ?? null;
    }
    /**
     * Set cpr__prd_web value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_web
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_web(?string $cpr__prd_web = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_web) && !is_string($cpr__prd_web)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_web, true), gettype($cpr__prd_web)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_web) && $cpr__prd_web > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_web, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_web) && $cpr__prd_web < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_web, true)), __LINE__);
        }
        if (is_null($cpr__prd_web) || (is_array($cpr__prd_web) && empty($cpr__prd_web))) {
            unset($this->cpr__prd_web);
        } else {
            $this->cpr__prd_web = $cpr__prd_web;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_microfiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_microfiche(): ?string
    {
        return $this->cpr__prd_microfiche ?? null;
    }
    /**
     * Set cpr__prd_microfiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_microfiche
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_microfiche(?string $cpr__prd_microfiche = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_microfiche) && !is_string($cpr__prd_microfiche)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_microfiche, true), gettype($cpr__prd_microfiche)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_microfiche) && $cpr__prd_microfiche > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_microfiche, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_microfiche) && $cpr__prd_microfiche < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_microfiche, true)), __LINE__);
        }
        if (is_null($cpr__prd_microfiche) || (is_array($cpr__prd_microfiche) && empty($cpr__prd_microfiche))) {
            unset($this->cpr__prd_microfiche);
        } else {
            $this->cpr__prd_microfiche = $cpr__prd_microfiche;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_post_to_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_post_to_web_date(): ?string
    {
        return $this->cpr__prd_post_to_web_date ?? null;
    }
    /**
     * Set cpr__prd_post_to_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_post_to_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_post_to_web_date(?string $cpr__prd_post_to_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_post_to_web_date) && !is_string($cpr__prd_post_to_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_post_to_web_date, true), gettype($cpr__prd_post_to_web_date)), __LINE__);
        }
        if (is_null($cpr__prd_post_to_web_date) || (is_array($cpr__prd_post_to_web_date) && empty($cpr__prd_post_to_web_date))) {
            unset($this->cpr__prd_post_to_web_date);
        } else {
            $this->cpr__prd_post_to_web_date = $cpr__prd_post_to_web_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_remove_from_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_remove_from_web_date(): ?string
    {
        return $this->cpr__prd_remove_from_web_date ?? null;
    }
    /**
     * Set cpr__prd_remove_from_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_remove_from_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_remove_from_web_date(?string $cpr__prd_remove_from_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_remove_from_web_date) && !is_string($cpr__prd_remove_from_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_remove_from_web_date, true), gettype($cpr__prd_remove_from_web_date)), __LINE__);
        }
        if (is_null($cpr__prd_remove_from_web_date) || (is_array($cpr__prd_remove_from_web_date) && empty($cpr__prd_remove_from_web_date))) {
            unset($this->cpr__prd_remove_from_web_date);
        } else {
            $this->cpr__prd_remove_from_web_date = $cpr__prd_remove_from_web_date;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_ptc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_ptc_key(): ?string
    {
        return $this->cpr__prd_ptc_key ?? null;
    }
    /**
     * Set cpr__prd_ptc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_ptc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_ptc_key(?string $cpr__prd_ptc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_ptc_key) && !is_string($cpr__prd_ptc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_ptc_key, true), gettype($cpr__prd_ptc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_ptc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_ptc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_ptc_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_ptc_key) || (is_array($cpr__prd_ptc_key) && empty($cpr__prd_ptc_key))) {
            unset($this->cpr__prd_ptc_key);
        } else {
            $this->cpr__prd_ptc_key = $cpr__prd_ptc_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_format(): ?string
    {
        return $this->cpr__prd_format ?? null;
    }
    /**
     * Set cpr__prd_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_format(?string $cpr__prd_format = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_format) && !is_string($cpr__prd_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_format, true), gettype($cpr__prd_format)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($cpr__prd_format) && mb_strlen((string) $cpr__prd_format) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $cpr__prd_format)), __LINE__);
        }
        if (is_null($cpr__prd_format) || (is_array($cpr__prd_format) && empty($cpr__prd_format))) {
            unset($this->cpr__prd_format);
        } else {
            $this->cpr__prd_format = $cpr__prd_format;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_download_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_download_url(): ?string
    {
        return $this->cpr__prd_download_url ?? null;
    }
    /**
     * Set cpr__prd_download_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_download_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_download_url(?string $cpr__prd_download_url = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_download_url) && !is_string($cpr__prd_download_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_download_url, true), gettype($cpr__prd_download_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($cpr__prd_download_url) && mb_strlen((string) $cpr__prd_download_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $cpr__prd_download_url)), __LINE__);
        }
        if (is_null($cpr__prd_download_url) || (is_array($cpr__prd_download_url) && empty($cpr__prd_download_url))) {
            unset($this->cpr__prd_download_url);
        } else {
            $this->cpr__prd_download_url = $cpr__prd_download_url;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_show_as_new_until value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_show_as_new_until(): ?string
    {
        return $this->cpr__prd_show_as_new_until ?? null;
    }
    /**
     * Set cpr__prd_show_as_new_until value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_show_as_new_until
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_show_as_new_until(?string $cpr__prd_show_as_new_until = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_show_as_new_until) && !is_string($cpr__prd_show_as_new_until)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_show_as_new_until, true), gettype($cpr__prd_show_as_new_until)), __LINE__);
        }
        if (is_null($cpr__prd_show_as_new_until) || (is_array($cpr__prd_show_as_new_until) && empty($cpr__prd_show_as_new_until))) {
            unset($this->cpr__prd_show_as_new_until);
        } else {
            $this->cpr__prd_show_as_new_until = $cpr__prd_show_as_new_until;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_pjt_key(): ?string
    {
        return $this->cpr__prd_pjt_key ?? null;
    }
    /**
     * Set cpr__prd_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_pjt_key(?string $cpr__prd_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_pjt_key) && !is_string($cpr__prd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_pjt_key, true), gettype($cpr__prd_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_pjt_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_pjt_key) || (is_array($cpr__prd_pjt_key) && empty($cpr__prd_pjt_key))) {
            unset($this->cpr__prd_pjt_key);
        } else {
            $this->cpr__prd_pjt_key = $cpr__prd_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_gla_damaged_goods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_gla_damaged_goods_key(): ?string
    {
        return $this->cpr__prd_gla_damaged_goods_key ?? null;
    }
    /**
     * Set cpr__prd_gla_damaged_goods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_gla_damaged_goods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_gla_damaged_goods_key(?string $cpr__prd_gla_damaged_goods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_gla_damaged_goods_key) && !is_string($cpr__prd_gla_damaged_goods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_gla_damaged_goods_key, true), gettype($cpr__prd_gla_damaged_goods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_gla_damaged_goods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_gla_damaged_goods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_gla_damaged_goods_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_gla_damaged_goods_key) || (is_array($cpr__prd_gla_damaged_goods_key) && empty($cpr__prd_gla_damaged_goods_key))) {
            unset($this->cpr__prd_gla_damaged_goods_key);
        } else {
            $this->cpr__prd_gla_damaged_goods_key = $cpr__prd_gla_damaged_goods_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCpr__prd_order(): ?int
    {
        return $this->cpr__prd_order ?? null;
    }
    /**
     * Set cpr__prd_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cpr__prd_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_order(?int $cpr__prd_order = null): self
    {
        // validation for constraint: int
        if (!is_null($cpr__prd_order) && !(is_int($cpr__prd_order) || ctype_digit($cpr__prd_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpr__prd_order, true), gettype($cpr__prd_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cpr__prd_order) && $cpr__prd_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cpr__prd_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cpr__prd_order) && $cpr__prd_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cpr__prd_order, true)), __LINE__);
        }
        if (is_null($cpr__prd_order) || (is_array($cpr__prd_order) && empty($cpr__prd_order))) {
            unset($this->cpr__prd_order);
        } else {
            $this->cpr__prd_order = $cpr__prd_order;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_download_available_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCpr__prd_download_available_days(): ?int
    {
        return $this->cpr__prd_download_available_days ?? null;
    }
    /**
     * Set cpr__prd_download_available_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cpr__prd_download_available_days
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_download_available_days(?int $cpr__prd_download_available_days = null): self
    {
        // validation for constraint: int
        if (!is_null($cpr__prd_download_available_days) && !(is_int($cpr__prd_download_available_days) || ctype_digit($cpr__prd_download_available_days))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpr__prd_download_available_days, true), gettype($cpr__prd_download_available_days)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cpr__prd_download_available_days) && $cpr__prd_download_available_days > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cpr__prd_download_available_days, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cpr__prd_download_available_days) && $cpr__prd_download_available_days < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cpr__prd_download_available_days, true)), __LINE__);
        }
        if (is_null($cpr__prd_download_available_days) || (is_array($cpr__prd_download_available_days) && empty($cpr__prd_download_available_days))) {
            unset($this->cpr__prd_download_available_days);
        } else {
            $this->cpr__prd_download_available_days = $cpr__prd_download_available_days;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_weighted_average_cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCpr__prd_weighted_average_cost(): ?float
    {
        return $this->cpr__prd_weighted_average_cost ?? null;
    }
    /**
     * Set cpr__prd_weighted_average_cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cpr__prd_weighted_average_cost
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_weighted_average_cost(?float $cpr__prd_weighted_average_cost = null): self
    {
        // validation for constraint: float
        if (!is_null($cpr__prd_weighted_average_cost) && !(is_float($cpr__prd_weighted_average_cost) || is_numeric($cpr__prd_weighted_average_cost))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpr__prd_weighted_average_cost, true), gettype($cpr__prd_weighted_average_cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cpr__prd_weighted_average_cost) && mb_strlen(mb_substr((string) $cpr__prd_weighted_average_cost, false !== mb_strpos((string) $cpr__prd_weighted_average_cost, '.') ? mb_strpos((string) $cpr__prd_weighted_average_cost, '.') + 1 : mb_strlen((string) $cpr__prd_weighted_average_cost))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cpr__prd_weighted_average_cost, true), mb_strlen(mb_substr((string) $cpr__prd_weighted_average_cost, mb_strpos((string) $cpr__prd_weighted_average_cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cpr__prd_weighted_average_cost) && mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_weighted_average_cost)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cpr__prd_weighted_average_cost, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cpr__prd_weighted_average_cost))), __LINE__);
        }
        if (is_null($cpr__prd_weighted_average_cost) || (is_array($cpr__prd_weighted_average_cost) && empty($cpr__prd_weighted_average_cost))) {
            unset($this->cpr__prd_weighted_average_cost);
        } else {
            $this->cpr__prd_weighted_average_cost = $cpr__prd_weighted_average_cost;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_featured_product_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_featured_product_flag(): ?string
    {
        return $this->cpr__prd_featured_product_flag ?? null;
    }
    /**
     * Set cpr__prd_featured_product_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_featured_product_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_featured_product_flag(?string $cpr__prd_featured_product_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_featured_product_flag) && !is_string($cpr__prd_featured_product_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_featured_product_flag, true), gettype($cpr__prd_featured_product_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpr__prd_featured_product_flag) && $cpr__prd_featured_product_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpr__prd_featured_product_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpr__prd_featured_product_flag) && $cpr__prd_featured_product_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpr__prd_featured_product_flag, true)), __LINE__);
        }
        if (is_null($cpr__prd_featured_product_flag) || (is_array($cpr__prd_featured_product_flag) && empty($cpr__prd_featured_product_flag))) {
            unset($this->cpr__prd_featured_product_flag);
        } else {
            $this->cpr__prd_featured_product_flag = $cpr__prd_featured_product_flag;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_download_available_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCpr__prd_download_available_count(): ?int
    {
        return $this->cpr__prd_download_available_count ?? null;
    }
    /**
     * Set cpr__prd_download_available_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cpr__prd_download_available_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_download_available_count(?int $cpr__prd_download_available_count = null): self
    {
        // validation for constraint: int
        if (!is_null($cpr__prd_download_available_count) && !(is_int($cpr__prd_download_available_count) || ctype_digit($cpr__prd_download_available_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpr__prd_download_available_count, true), gettype($cpr__prd_download_available_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cpr__prd_download_available_count) && $cpr__prd_download_available_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cpr__prd_download_available_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cpr__prd_download_available_count) && $cpr__prd_download_available_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cpr__prd_download_available_count, true)), __LINE__);
        }
        if (is_null($cpr__prd_download_available_count) || (is_array($cpr__prd_download_available_count) && empty($cpr__prd_download_available_count))) {
            unset($this->cpr__prd_download_available_count);
        } else {
            $this->cpr__prd_download_available_count = $cpr__prd_download_available_count;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_cct_key(): ?string
    {
        return $this->cpr__prd_cct_key ?? null;
    }
    /**
     * Set cpr__prd_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_cct_key(?string $cpr__prd_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_cct_key) && !is_string($cpr__prd_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_cct_key, true), gettype($cpr__prd_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_cct_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_cct_key) || (is_array($cpr__prd_cct_key) && empty($cpr__prd_cct_key))) {
            unset($this->cpr__prd_cct_key);
        } else {
            $this->cpr__prd_cct_key = $cpr__prd_cct_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_pts_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_pts_key(): ?string
    {
        return $this->cpr__prd_pts_key ?? null;
    }
    /**
     * Set cpr__prd_pts_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_pts_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_pts_key(?string $cpr__prd_pts_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_pts_key) && !is_string($cpr__prd_pts_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_pts_key, true), gettype($cpr__prd_pts_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_pts_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_pts_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_pts_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_pts_key) || (is_array($cpr__prd_pts_key) && empty($cpr__prd_pts_key))) {
            unset($this->cpr__prd_pts_key);
        } else {
            $this->cpr__prd_pts_key = $cpr__prd_pts_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_cmo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_cmo_key(): ?string
    {
        return $this->cpr__prd_cmo_key ?? null;
    }
    /**
     * Set cpr__prd_cmo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_cmo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_cmo_key(?string $cpr__prd_cmo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_cmo_key) && !is_string($cpr__prd_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_cmo_key, true), gettype($cpr__prd_cmo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_cmo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_cmo_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_cmo_key) || (is_array($cpr__prd_cmo_key) && empty($cpr__prd_cmo_key))) {
            unset($this->cpr__prd_cmo_key);
        } else {
            $this->cpr__prd_cmo_key = $cpr__prd_cmo_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_out_of_stock_override_message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_out_of_stock_override_message(): ?string
    {
        return $this->cpr__prd_out_of_stock_override_message ?? null;
    }
    /**
     * Set cpr__prd_out_of_stock_override_message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_out_of_stock_override_message
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_out_of_stock_override_message(?string $cpr__prd_out_of_stock_override_message = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_out_of_stock_override_message) && !is_string($cpr__prd_out_of_stock_override_message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_out_of_stock_override_message, true), gettype($cpr__prd_out_of_stock_override_message)), __LINE__);
        }
        if (is_null($cpr__prd_out_of_stock_override_message) || (is_array($cpr__prd_out_of_stock_override_message) && empty($cpr__prd_out_of_stock_override_message))) {
            unset($this->cpr__prd_out_of_stock_override_message);
        } else {
            $this->cpr__prd_out_of_stock_override_message = $cpr__prd_out_of_stock_override_message;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_pst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_pst_key(): ?string
    {
        return $this->cpr__prd_pst_key ?? null;
    }
    /**
     * Set cpr__prd_pst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_pst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_pst_key(?string $cpr__prd_pst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_pst_key) && !is_string($cpr__prd_pst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_pst_key, true), gettype($cpr__prd_pst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_pst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_pst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_pst_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_pst_key) || (is_array($cpr__prd_pst_key) && empty($cpr__prd_pst_key))) {
            unset($this->cpr__prd_pst_key);
        } else {
            $this->cpr__prd_pst_key = $cpr__prd_pst_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_pcr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_pcr_key(): ?string
    {
        return $this->cpr__prd_pcr_key ?? null;
    }
    /**
     * Set cpr__prd_pcr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_pcr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_pcr_key(?string $cpr__prd_pcr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_pcr_key) && !is_string($cpr__prd_pcr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_pcr_key, true), gettype($cpr__prd_pcr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_pcr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_pcr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_pcr_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_pcr_key) || (is_array($cpr__prd_pcr_key) && empty($cpr__prd_pcr_key))) {
            unset($this->cpr__prd_pcr_key);
        } else {
            $this->cpr__prd_pcr_key = $cpr__prd_pcr_key;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_display_product_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_display_product_name(): ?string
    {
        return $this->cpr__prd_display_product_name ?? null;
    }
    /**
     * Set cpr__prd_display_product_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_display_product_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_display_product_name(?string $cpr__prd_display_product_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_display_product_name) && !is_string($cpr__prd_display_product_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_display_product_name, true), gettype($cpr__prd_display_product_name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cpr__prd_display_product_name) && mb_strlen((string) $cpr__prd_display_product_name) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cpr__prd_display_product_name)), __LINE__);
        }
        if (is_null($cpr__prd_display_product_name) || (is_array($cpr__prd_display_product_name) && empty($cpr__prd_display_product_name))) {
            unset($this->cpr__prd_display_product_name);
        } else {
            $this->cpr__prd_display_product_name = $cpr__prd_display_product_name;
        }
        
        return $this;
    }
    /**
     * Get cpr__prd_display_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpr__prd_display_prd_key(): ?string
    {
        return $this->cpr__prd_display_prd_key ?? null;
    }
    /**
     * Set cpr__prd_display_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpr__prd_display_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Chapter_Product_DataObjectType
     */
    public function setCpr__prd_display_prd_key(?string $cpr__prd_display_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpr__prd_display_prd_key) && !is_string($cpr__prd_display_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpr__prd_display_prd_key, true), gettype($cpr__prd_display_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpr__prd_display_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpr__prd_display_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpr__prd_display_prd_key, true)), __LINE__);
        }
        if (is_null($cpr__prd_display_prd_key) || (is_array($cpr__prd_display_prd_key) && empty($cpr__prd_display_prd_key))) {
            unset($this->cpr__prd_display_prd_key);
        } else {
            $this->cpr__prd_display_prd_key = $cpr__prd_display_prd_key;
        }
        
        return $this;
    }
}
