<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Dues_Variables_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Dues_Variables_DataObjectType extends AbstractStructBase
{
    /**
     * The dcv_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dcv_key = null;
    /**
     * The dcv_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_add_user = null;
    /**
     * The dcv_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_add_date = null;
    /**
     * The dcv_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_change_user = null;
    /**
     * The dcv_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_change_date = null;
    /**
     * The dcv_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_delete_flag = null;
    /**
     * The dcv_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dcv_key_ext = null;
    /**
     * The dcv_dues_year
     * Meta information extracted from the WSDL
     * - documentation: Dues Year. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dcv_dues_year = null;
    /**
     * The dcv_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dcv_entity_key = null;
    /**
     * Constructor method for mb_membership_Dues_Variables_DataObjectType
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_key()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_add_user()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_add_date()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_change_user()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_change_date()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_delete_flag()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_key_ext()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_dues_year()
     * @uses Mb_membership_Dues_Variables_DataObjectType::setDcv_entity_key()
     * @param string $dcv_key
     * @param string $dcv_add_user
     * @param string $dcv_add_date
     * @param string $dcv_change_user
     * @param string $dcv_change_date
     * @param string $dcv_delete_flag
     * @param string $dcv_key_ext
     * @param string $dcv_dues_year
     * @param string $dcv_entity_key
     */
    public function __construct(?string $dcv_key = null, ?string $dcv_add_user = null, ?string $dcv_add_date = null, ?string $dcv_change_user = null, ?string $dcv_change_date = null, ?string $dcv_delete_flag = null, ?string $dcv_key_ext = null, ?string $dcv_dues_year = null, ?string $dcv_entity_key = null)
    {
        $this
            ->setDcv_key($dcv_key)
            ->setDcv_add_user($dcv_add_user)
            ->setDcv_add_date($dcv_add_date)
            ->setDcv_change_user($dcv_change_user)
            ->setDcv_change_date($dcv_change_date)
            ->setDcv_delete_flag($dcv_delete_flag)
            ->setDcv_key_ext($dcv_key_ext)
            ->setDcv_dues_year($dcv_dues_year)
            ->setDcv_entity_key($dcv_entity_key);
    }
    /**
     * Get dcv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_key(): ?string
    {
        return $this->dcv_key ?? null;
    }
    /**
     * Set dcv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_key(?string $dcv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_key) && !is_string($dcv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_key, true), gettype($dcv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dcv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dcv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dcv_key, true)), __LINE__);
        }
        if (is_null($dcv_key) || (is_array($dcv_key) && empty($dcv_key))) {
            unset($this->dcv_key);
        } else {
            $this->dcv_key = $dcv_key;
        }
        
        return $this;
    }
    /**
     * Get dcv_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_add_user(): ?string
    {
        return $this->dcv_add_user ?? null;
    }
    /**
     * Set dcv_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_add_user(?string $dcv_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_add_user) && !is_string($dcv_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_add_user, true), gettype($dcv_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dcv_add_user) && mb_strlen((string) $dcv_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dcv_add_user)), __LINE__);
        }
        if (is_null($dcv_add_user) || (is_array($dcv_add_user) && empty($dcv_add_user))) {
            unset($this->dcv_add_user);
        } else {
            $this->dcv_add_user = $dcv_add_user;
        }
        
        return $this;
    }
    /**
     * Get dcv_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_add_date(): ?string
    {
        return $this->dcv_add_date ?? null;
    }
    /**
     * Set dcv_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_add_date(?string $dcv_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_add_date) && !is_string($dcv_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_add_date, true), gettype($dcv_add_date)), __LINE__);
        }
        if (is_null($dcv_add_date) || (is_array($dcv_add_date) && empty($dcv_add_date))) {
            unset($this->dcv_add_date);
        } else {
            $this->dcv_add_date = $dcv_add_date;
        }
        
        return $this;
    }
    /**
     * Get dcv_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_change_user(): ?string
    {
        return $this->dcv_change_user ?? null;
    }
    /**
     * Set dcv_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_change_user(?string $dcv_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_change_user) && !is_string($dcv_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_change_user, true), gettype($dcv_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dcv_change_user) && mb_strlen((string) $dcv_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dcv_change_user)), __LINE__);
        }
        if (is_null($dcv_change_user) || (is_array($dcv_change_user) && empty($dcv_change_user))) {
            unset($this->dcv_change_user);
        } else {
            $this->dcv_change_user = $dcv_change_user;
        }
        
        return $this;
    }
    /**
     * Get dcv_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_change_date(): ?string
    {
        return $this->dcv_change_date ?? null;
    }
    /**
     * Set dcv_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_change_date(?string $dcv_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_change_date) && !is_string($dcv_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_change_date, true), gettype($dcv_change_date)), __LINE__);
        }
        if (is_null($dcv_change_date) || (is_array($dcv_change_date) && empty($dcv_change_date))) {
            unset($this->dcv_change_date);
        } else {
            $this->dcv_change_date = $dcv_change_date;
        }
        
        return $this;
    }
    /**
     * Get dcv_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_delete_flag(): ?string
    {
        return $this->dcv_delete_flag ?? null;
    }
    /**
     * Set dcv_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_delete_flag(?string $dcv_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_delete_flag) && !is_string($dcv_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_delete_flag, true), gettype($dcv_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dcv_delete_flag) && $dcv_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dcv_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dcv_delete_flag) && $dcv_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dcv_delete_flag, true)), __LINE__);
        }
        if (is_null($dcv_delete_flag) || (is_array($dcv_delete_flag) && empty($dcv_delete_flag))) {
            unset($this->dcv_delete_flag);
        } else {
            $this->dcv_delete_flag = $dcv_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get dcv_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_key_ext(): ?string
    {
        return $this->dcv_key_ext ?? null;
    }
    /**
     * Set dcv_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_key_ext(?string $dcv_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_key_ext) && !is_string($dcv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_key_ext, true), gettype($dcv_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dcv_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dcv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dcv_key_ext, true)), __LINE__);
        }
        if (is_null($dcv_key_ext) || (is_array($dcv_key_ext) && empty($dcv_key_ext))) {
            unset($this->dcv_key_ext);
        } else {
            $this->dcv_key_ext = $dcv_key_ext;
        }
        
        return $this;
    }
    /**
     * Get dcv_dues_year value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_dues_year(): ?string
    {
        return $this->dcv_dues_year ?? null;
    }
    /**
     * Set dcv_dues_year value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_dues_year
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_dues_year(?string $dcv_dues_year = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_dues_year) && !is_string($dcv_dues_year)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_dues_year, true), gettype($dcv_dues_year)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($dcv_dues_year) && mb_strlen((string) $dcv_dues_year) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $dcv_dues_year)), __LINE__);
        }
        if (is_null($dcv_dues_year) || (is_array($dcv_dues_year) && empty($dcv_dues_year))) {
            unset($this->dcv_dues_year);
        } else {
            $this->dcv_dues_year = $dcv_dues_year;
        }
        
        return $this;
    }
    /**
     * Get dcv_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDcv_entity_key(): ?string
    {
        return $this->dcv_entity_key ?? null;
    }
    /**
     * Set dcv_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dcv_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Dues_Variables_DataObjectType
     */
    public function setDcv_entity_key(?string $dcv_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dcv_entity_key) && !is_string($dcv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcv_entity_key, true), gettype($dcv_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dcv_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dcv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dcv_entity_key, true)), __LINE__);
        }
        if (is_null($dcv_entity_key) || (is_array($dcv_entity_key) && empty($dcv_entity_key))) {
            unset($this->dcv_entity_key);
        } else {
            $this->dcv_entity_key = $dcv_entity_key;
        }
        
        return $this;
    }
}
