<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Inovice_Terms_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Inovice_Terms_DataObjectType extends AbstractStructBase
{
    /**
     * The ait_key
     * Meta information extracted from the WSDL
     * - documentation: Terms Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ait_key = null;
    /**
     * The ait_code
     * Meta information extracted from the WSDL
     * - documentation: Terms Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_code = null;
    /**
     * The ait_atc_code
     * Meta information extracted from the WSDL
     * - documentation: Business Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_atc_code = null;
    /**
     * The ait_days
     * Meta information extracted from the WSDL
     * - documentation: Terms Days. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ait_days = null;
    /**
     * The ait_discount_days
     * Meta information extracted from the WSDL
     * - documentation: Discount Days.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ait_discount_days = null;
    /**
     * The ait_discount_percent
     * Meta information extracted from the WSDL
     * - documentation: Discount Percent.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ait_discount_percent = null;
    /**
     * The ait_discount_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: Discount Percentage. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ait_discount_percent_cp = null;
    /**
     * The ait_finance_charge_days
     * Meta information extracted from the WSDL
     * - documentation: Finance Charge Days.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ait_finance_charge_days = null;
    /**
     * The ait_finance_charge_percent
     * Meta information extracted from the WSDL
     * - documentation: Finance Charge Percent.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ait_finance_charge_percent = null;
    /**
     * The ait_finance_charge_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: Finance Charge Percentage. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ait_finance_charge_percent_cp = null;
    /**
     * The ait_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add user. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_add_user = null;
    /**
     * The ait_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_add_date = null;
    /**
     * The ait_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_change_date = null;
    /**
     * The ait_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_change_user = null;
    /**
     * The ait_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ait_delete_flag = null;
    /**
     * The ait_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ait_entity_key = null;
    /**
     * The ait_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ait_key_ext = null;
    /**
     * The ait_prc_discount_key
     * Meta information extracted from the WSDL
     * - documentation: Discount Price. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ait_prc_discount_key = null;
    /**
     * The ait_prc_finance_charge_key
     * Meta information extracted from the WSDL
     * - documentation: Finance Charge Price. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ait_prc_finance_charge_key = null;
    /**
     * Constructor method for mb_membership_Inovice_Terms_DataObjectType
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_key()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_code()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_atc_code()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_days()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_discount_days()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_discount_percent()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_discount_percent_cp()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_finance_charge_days()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_finance_charge_percent()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_finance_charge_percent_cp()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_add_user()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_add_date()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_change_date()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_change_user()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_delete_flag()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_entity_key()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_key_ext()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_prc_discount_key()
     * @uses Mb_membership_Inovice_Terms_DataObjectType::setAit_prc_finance_charge_key()
     * @param string $ait_key
     * @param string $ait_code
     * @param string $ait_atc_code
     * @param int $ait_days
     * @param int $ait_discount_days
     * @param float $ait_discount_percent
     * @param float $ait_discount_percent_cp
     * @param int $ait_finance_charge_days
     * @param float $ait_finance_charge_percent
     * @param float $ait_finance_charge_percent_cp
     * @param string $ait_add_user
     * @param string $ait_add_date
     * @param string $ait_change_date
     * @param string $ait_change_user
     * @param string $ait_delete_flag
     * @param string $ait_entity_key
     * @param string $ait_key_ext
     * @param string $ait_prc_discount_key
     * @param string $ait_prc_finance_charge_key
     */
    public function __construct(?string $ait_key = null, ?string $ait_code = null, ?string $ait_atc_code = null, ?int $ait_days = null, ?int $ait_discount_days = null, ?float $ait_discount_percent = null, ?float $ait_discount_percent_cp = null, ?int $ait_finance_charge_days = null, ?float $ait_finance_charge_percent = null, ?float $ait_finance_charge_percent_cp = null, ?string $ait_add_user = null, ?string $ait_add_date = null, ?string $ait_change_date = null, ?string $ait_change_user = null, ?string $ait_delete_flag = null, ?string $ait_entity_key = null, ?string $ait_key_ext = null, ?string $ait_prc_discount_key = null, ?string $ait_prc_finance_charge_key = null)
    {
        $this
            ->setAit_key($ait_key)
            ->setAit_code($ait_code)
            ->setAit_atc_code($ait_atc_code)
            ->setAit_days($ait_days)
            ->setAit_discount_days($ait_discount_days)
            ->setAit_discount_percent($ait_discount_percent)
            ->setAit_discount_percent_cp($ait_discount_percent_cp)
            ->setAit_finance_charge_days($ait_finance_charge_days)
            ->setAit_finance_charge_percent($ait_finance_charge_percent)
            ->setAit_finance_charge_percent_cp($ait_finance_charge_percent_cp)
            ->setAit_add_user($ait_add_user)
            ->setAit_add_date($ait_add_date)
            ->setAit_change_date($ait_change_date)
            ->setAit_change_user($ait_change_user)
            ->setAit_delete_flag($ait_delete_flag)
            ->setAit_entity_key($ait_entity_key)
            ->setAit_key_ext($ait_key_ext)
            ->setAit_prc_discount_key($ait_prc_discount_key)
            ->setAit_prc_finance_charge_key($ait_prc_finance_charge_key);
    }
    /**
     * Get ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_key(): ?string
    {
        return $this->ait_key ?? null;
    }
    /**
     * Set ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_key(?string $ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_key) && !is_string($ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_key, true), gettype($ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ait_key, true)), __LINE__);
        }
        if (is_null($ait_key) || (is_array($ait_key) && empty($ait_key))) {
            unset($this->ait_key);
        } else {
            $this->ait_key = $ait_key;
        }
        
        return $this;
    }
    /**
     * Get ait_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_code(): ?string
    {
        return $this->ait_code ?? null;
    }
    /**
     * Set ait_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_code(?string $ait_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_code) && !is_string($ait_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_code, true), gettype($ait_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ait_code) && mb_strlen((string) $ait_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ait_code)), __LINE__);
        }
        if (is_null($ait_code) || (is_array($ait_code) && empty($ait_code))) {
            unset($this->ait_code);
        } else {
            $this->ait_code = $ait_code;
        }
        
        return $this;
    }
    /**
     * Get ait_atc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_atc_code(): ?string
    {
        return $this->ait_atc_code ?? null;
    }
    /**
     * Set ait_atc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_atc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_atc_code(?string $ait_atc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_atc_code) && !is_string($ait_atc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_atc_code, true), gettype($ait_atc_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ait_atc_code) && mb_strlen((string) $ait_atc_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ait_atc_code)), __LINE__);
        }
        if (is_null($ait_atc_code) || (is_array($ait_atc_code) && empty($ait_atc_code))) {
            unset($this->ait_atc_code);
        } else {
            $this->ait_atc_code = $ait_atc_code;
        }
        
        return $this;
    }
    /**
     * Get ait_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAit_days(): ?int
    {
        return $this->ait_days ?? null;
    }
    /**
     * Set ait_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ait_days
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_days(?int $ait_days = null): self
    {
        // validation for constraint: int
        if (!is_null($ait_days) && !(is_int($ait_days) || ctype_digit($ait_days))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ait_days, true), gettype($ait_days)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ait_days) && $ait_days > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ait_days, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ait_days) && $ait_days < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ait_days, true)), __LINE__);
        }
        if (is_null($ait_days) || (is_array($ait_days) && empty($ait_days))) {
            unset($this->ait_days);
        } else {
            $this->ait_days = $ait_days;
        }
        
        return $this;
    }
    /**
     * Get ait_discount_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAit_discount_days(): ?int
    {
        return $this->ait_discount_days ?? null;
    }
    /**
     * Set ait_discount_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ait_discount_days
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_discount_days(?int $ait_discount_days = null): self
    {
        // validation for constraint: int
        if (!is_null($ait_discount_days) && !(is_int($ait_discount_days) || ctype_digit($ait_discount_days))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ait_discount_days, true), gettype($ait_discount_days)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ait_discount_days) && $ait_discount_days > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ait_discount_days, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ait_discount_days) && $ait_discount_days < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ait_discount_days, true)), __LINE__);
        }
        if (is_null($ait_discount_days) || (is_array($ait_discount_days) && empty($ait_discount_days))) {
            unset($this->ait_discount_days);
        } else {
            $this->ait_discount_days = $ait_discount_days;
        }
        
        return $this;
    }
    /**
     * Get ait_discount_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAit_discount_percent(): ?float
    {
        return $this->ait_discount_percent ?? null;
    }
    /**
     * Set ait_discount_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ait_discount_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_discount_percent(?float $ait_discount_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($ait_discount_percent) && !(is_float($ait_discount_percent) || is_numeric($ait_discount_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ait_discount_percent, true), gettype($ait_discount_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ait_discount_percent) && mb_strlen(mb_substr((string) $ait_discount_percent, false !== mb_strpos((string) $ait_discount_percent, '.') ? mb_strpos((string) $ait_discount_percent, '.') + 1 : mb_strlen((string) $ait_discount_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ait_discount_percent, true), mb_strlen(mb_substr((string) $ait_discount_percent, mb_strpos((string) $ait_discount_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ait_discount_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $ait_discount_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ait_discount_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ait_discount_percent))), __LINE__);
        }
        if (is_null($ait_discount_percent) || (is_array($ait_discount_percent) && empty($ait_discount_percent))) {
            unset($this->ait_discount_percent);
        } else {
            $this->ait_discount_percent = $ait_discount_percent;
        }
        
        return $this;
    }
    /**
     * Get ait_discount_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAit_discount_percent_cp(): ?float
    {
        return $this->ait_discount_percent_cp ?? null;
    }
    /**
     * Set ait_discount_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ait_discount_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_discount_percent_cp(?float $ait_discount_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ait_discount_percent_cp) && !(is_float($ait_discount_percent_cp) || is_numeric($ait_discount_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ait_discount_percent_cp, true), gettype($ait_discount_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ait_discount_percent_cp) && mb_strlen(mb_substr((string) $ait_discount_percent_cp, false !== mb_strpos((string) $ait_discount_percent_cp, '.') ? mb_strpos((string) $ait_discount_percent_cp, '.') + 1 : mb_strlen((string) $ait_discount_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ait_discount_percent_cp, true), mb_strlen(mb_substr((string) $ait_discount_percent_cp, mb_strpos((string) $ait_discount_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ait_discount_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ait_discount_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ait_discount_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ait_discount_percent_cp))), __LINE__);
        }
        if (is_null($ait_discount_percent_cp) || (is_array($ait_discount_percent_cp) && empty($ait_discount_percent_cp))) {
            unset($this->ait_discount_percent_cp);
        } else {
            $this->ait_discount_percent_cp = $ait_discount_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get ait_finance_charge_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAit_finance_charge_days(): ?int
    {
        return $this->ait_finance_charge_days ?? null;
    }
    /**
     * Set ait_finance_charge_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ait_finance_charge_days
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_finance_charge_days(?int $ait_finance_charge_days = null): self
    {
        // validation for constraint: int
        if (!is_null($ait_finance_charge_days) && !(is_int($ait_finance_charge_days) || ctype_digit($ait_finance_charge_days))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ait_finance_charge_days, true), gettype($ait_finance_charge_days)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ait_finance_charge_days) && $ait_finance_charge_days > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ait_finance_charge_days, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ait_finance_charge_days) && $ait_finance_charge_days < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ait_finance_charge_days, true)), __LINE__);
        }
        if (is_null($ait_finance_charge_days) || (is_array($ait_finance_charge_days) && empty($ait_finance_charge_days))) {
            unset($this->ait_finance_charge_days);
        } else {
            $this->ait_finance_charge_days = $ait_finance_charge_days;
        }
        
        return $this;
    }
    /**
     * Get ait_finance_charge_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAit_finance_charge_percent(): ?float
    {
        return $this->ait_finance_charge_percent ?? null;
    }
    /**
     * Set ait_finance_charge_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ait_finance_charge_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_finance_charge_percent(?float $ait_finance_charge_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($ait_finance_charge_percent) && !(is_float($ait_finance_charge_percent) || is_numeric($ait_finance_charge_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ait_finance_charge_percent, true), gettype($ait_finance_charge_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ait_finance_charge_percent) && mb_strlen(mb_substr((string) $ait_finance_charge_percent, false !== mb_strpos((string) $ait_finance_charge_percent, '.') ? mb_strpos((string) $ait_finance_charge_percent, '.') + 1 : mb_strlen((string) $ait_finance_charge_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ait_finance_charge_percent, true), mb_strlen(mb_substr((string) $ait_finance_charge_percent, mb_strpos((string) $ait_finance_charge_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ait_finance_charge_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $ait_finance_charge_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ait_finance_charge_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ait_finance_charge_percent))), __LINE__);
        }
        if (is_null($ait_finance_charge_percent) || (is_array($ait_finance_charge_percent) && empty($ait_finance_charge_percent))) {
            unset($this->ait_finance_charge_percent);
        } else {
            $this->ait_finance_charge_percent = $ait_finance_charge_percent;
        }
        
        return $this;
    }
    /**
     * Get ait_finance_charge_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAit_finance_charge_percent_cp(): ?float
    {
        return $this->ait_finance_charge_percent_cp ?? null;
    }
    /**
     * Set ait_finance_charge_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ait_finance_charge_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_finance_charge_percent_cp(?float $ait_finance_charge_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ait_finance_charge_percent_cp) && !(is_float($ait_finance_charge_percent_cp) || is_numeric($ait_finance_charge_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ait_finance_charge_percent_cp, true), gettype($ait_finance_charge_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ait_finance_charge_percent_cp) && mb_strlen(mb_substr((string) $ait_finance_charge_percent_cp, false !== mb_strpos((string) $ait_finance_charge_percent_cp, '.') ? mb_strpos((string) $ait_finance_charge_percent_cp, '.') + 1 : mb_strlen((string) $ait_finance_charge_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ait_finance_charge_percent_cp, true), mb_strlen(mb_substr((string) $ait_finance_charge_percent_cp, mb_strpos((string) $ait_finance_charge_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ait_finance_charge_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ait_finance_charge_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ait_finance_charge_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ait_finance_charge_percent_cp))), __LINE__);
        }
        if (is_null($ait_finance_charge_percent_cp) || (is_array($ait_finance_charge_percent_cp) && empty($ait_finance_charge_percent_cp))) {
            unset($this->ait_finance_charge_percent_cp);
        } else {
            $this->ait_finance_charge_percent_cp = $ait_finance_charge_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get ait_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_add_user(): ?string
    {
        return $this->ait_add_user ?? null;
    }
    /**
     * Set ait_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_add_user(?string $ait_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_add_user) && !is_string($ait_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_add_user, true), gettype($ait_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ait_add_user) && mb_strlen((string) $ait_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ait_add_user)), __LINE__);
        }
        if (is_null($ait_add_user) || (is_array($ait_add_user) && empty($ait_add_user))) {
            unset($this->ait_add_user);
        } else {
            $this->ait_add_user = $ait_add_user;
        }
        
        return $this;
    }
    /**
     * Get ait_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_add_date(): ?string
    {
        return $this->ait_add_date ?? null;
    }
    /**
     * Set ait_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_add_date(?string $ait_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_add_date) && !is_string($ait_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_add_date, true), gettype($ait_add_date)), __LINE__);
        }
        if (is_null($ait_add_date) || (is_array($ait_add_date) && empty($ait_add_date))) {
            unset($this->ait_add_date);
        } else {
            $this->ait_add_date = $ait_add_date;
        }
        
        return $this;
    }
    /**
     * Get ait_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_change_date(): ?string
    {
        return $this->ait_change_date ?? null;
    }
    /**
     * Set ait_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_change_date(?string $ait_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_change_date) && !is_string($ait_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_change_date, true), gettype($ait_change_date)), __LINE__);
        }
        if (is_null($ait_change_date) || (is_array($ait_change_date) && empty($ait_change_date))) {
            unset($this->ait_change_date);
        } else {
            $this->ait_change_date = $ait_change_date;
        }
        
        return $this;
    }
    /**
     * Get ait_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_change_user(): ?string
    {
        return $this->ait_change_user ?? null;
    }
    /**
     * Set ait_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_change_user(?string $ait_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_change_user) && !is_string($ait_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_change_user, true), gettype($ait_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ait_change_user) && mb_strlen((string) $ait_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ait_change_user)), __LINE__);
        }
        if (is_null($ait_change_user) || (is_array($ait_change_user) && empty($ait_change_user))) {
            unset($this->ait_change_user);
        } else {
            $this->ait_change_user = $ait_change_user;
        }
        
        return $this;
    }
    /**
     * Get ait_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_delete_flag(): ?string
    {
        return $this->ait_delete_flag ?? null;
    }
    /**
     * Set ait_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_delete_flag(?string $ait_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_delete_flag) && !is_string($ait_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_delete_flag, true), gettype($ait_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ait_delete_flag) && $ait_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ait_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ait_delete_flag) && $ait_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ait_delete_flag, true)), __LINE__);
        }
        if (is_null($ait_delete_flag) || (is_array($ait_delete_flag) && empty($ait_delete_flag))) {
            unset($this->ait_delete_flag);
        } else {
            $this->ait_delete_flag = $ait_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ait_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_entity_key(): ?string
    {
        return $this->ait_entity_key ?? null;
    }
    /**
     * Set ait_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_entity_key(?string $ait_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_entity_key) && !is_string($ait_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_entity_key, true), gettype($ait_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ait_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ait_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ait_entity_key, true)), __LINE__);
        }
        if (is_null($ait_entity_key) || (is_array($ait_entity_key) && empty($ait_entity_key))) {
            unset($this->ait_entity_key);
        } else {
            $this->ait_entity_key = $ait_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ait_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_key_ext(): ?string
    {
        return $this->ait_key_ext ?? null;
    }
    /**
     * Set ait_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_key_ext(?string $ait_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_key_ext) && !is_string($ait_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_key_ext, true), gettype($ait_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ait_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ait_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ait_key_ext, true)), __LINE__);
        }
        if (is_null($ait_key_ext) || (is_array($ait_key_ext) && empty($ait_key_ext))) {
            unset($this->ait_key_ext);
        } else {
            $this->ait_key_ext = $ait_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ait_prc_discount_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_prc_discount_key(): ?string
    {
        return $this->ait_prc_discount_key ?? null;
    }
    /**
     * Set ait_prc_discount_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_prc_discount_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_prc_discount_key(?string $ait_prc_discount_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_prc_discount_key) && !is_string($ait_prc_discount_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_prc_discount_key, true), gettype($ait_prc_discount_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ait_prc_discount_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ait_prc_discount_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ait_prc_discount_key, true)), __LINE__);
        }
        if (is_null($ait_prc_discount_key) || (is_array($ait_prc_discount_key) && empty($ait_prc_discount_key))) {
            unset($this->ait_prc_discount_key);
        } else {
            $this->ait_prc_discount_key = $ait_prc_discount_key;
        }
        
        return $this;
    }
    /**
     * Get ait_prc_finance_charge_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAit_prc_finance_charge_key(): ?string
    {
        return $this->ait_prc_finance_charge_key ?? null;
    }
    /**
     * Set ait_prc_finance_charge_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ait_prc_finance_charge_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Inovice_Terms_DataObjectType
     */
    public function setAit_prc_finance_charge_key(?string $ait_prc_finance_charge_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ait_prc_finance_charge_key) && !is_string($ait_prc_finance_charge_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ait_prc_finance_charge_key, true), gettype($ait_prc_finance_charge_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ait_prc_finance_charge_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ait_prc_finance_charge_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ait_prc_finance_charge_key, true)), __LINE__);
        }
        if (is_null($ait_prc_finance_charge_key) || (is_array($ait_prc_finance_charge_key) && empty($ait_prc_finance_charge_key))) {
            unset($this->ait_prc_finance_charge_key);
        } else {
            $this->ait_prc_finance_charge_key = $ait_prc_finance_charge_key;
        }
        
        return $this;
    }
}
