<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Installment_Billing_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Installment_Billing_DataObjectType extends AbstractStructBase
{
    /**
     * The ord_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_key = null;
    /**
     * The ord_cst_key
     * Meta information extracted from the WSDL
     * - documentation: customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cst_key = null;
    /**
     * The ord_frequency
     * Meta information extracted from the WSDL
     * - documentation: frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_frequency = null;
    /**
     * The ord_ptr_key
     * Meta information extracted from the WSDL
     * - documentation: term. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ptr_key = null;
    /**
     * The ord_last_bill_date
     * Meta information extracted from the WSDL
     * - documentation: last bill date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_last_bill_date = null;
    /**
     * The ord_proforma
     * Meta information extracted from the WSDL
     * - documentation: proforma.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_proforma = null;
    /**
     * The ord_type
     * Meta information extracted from the WSDL
     * - documentation: type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_type = null;
    /**
     * The ord_pin_key
     * Meta information extracted from the WSDL
     * - documentation: payment info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_pin_key = null;
    /**
     * The ord_num_of_installments
     * Meta information extracted from the WSDL
     * - documentation: number of installments. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_num_of_installments = null;
    /**
     * The ord_num_invoices_to_date
     * Meta information extracted from the WSDL
     * - documentation: num invoices to date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_num_invoices_to_date = null;
    /**
     * The ord_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: bill to customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cst_billing_key = null;
    /**
     * The ord_ind_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: billing contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ind_cst_billing_key = null;
    /**
     * The ord_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: billing address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cxa_key = null;
    /**
     * The ord_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cph_key = null;
    /**
     * The ord_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cfx_key = null;
    /**
     * The ord_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_eml_key = null;
    /**
     * The ord_pref_comm_method
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_pref_comm_method = null;
    /**
     * The ord_src_key
     * Meta information extracted from the WSDL
     * - documentation: source code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_src_key = null;
    /**
     * The ord_med_key
     * Meta information extracted from the WSDL
     * - documentation: media code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_med_key = null;
    /**
     * The ord_notes_internal
     * Meta information extracted from the WSDL
     * - documentation: notes internal. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_notes_internal = null;
    /**
     * The ord_notes_external
     * Meta information extracted from the WSDL
     * - documentation: notes external. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_notes_external = null;
    /**
     * The ord_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_add_user = null;
    /**
     * The ord_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_add_date = null;
    /**
     * The ord_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_change_user = null;
    /**
     * The ord_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_change_date = null;
    /**
     * The ord_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_delete_flag = null;
    /**
     * The ord_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_entity_key = null;
    /**
     * The ord_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_key_ext = null;
    /**
     * The ord_ait_key
     * Meta information extracted from the WSDL
     * - documentation: invoice terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ait_key = null;
    /**
     * The ord_first_process_date
     * Meta information extracted from the WSDL
     * - documentation: Process First Invoice on. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_first_process_date = null;
    /**
     * The ord_code
     * Meta information extracted from the WSDL
     * - documentation: order code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_code = null;
    /**
     * The ord_close_flag
     * Meta information extracted from the WSDL
     * - documentation: order closed. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_close_flag = null;
    /**
     * The ord_milestone_flag
     * Meta information extracted from the WSDL
     * - documentation: milestone based. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_milestone_flag = null;
    /**
     * The ord_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cpi_key = null;
    /**
     * The ord_auto_pay
     * Meta information extracted from the WSDL
     * - documentation: Auto-Pay Installments. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_auto_pay = null;
    /**
     * The ord_orig_trans_type
     * Meta information extracted from the WSDL
     * - documentation: Original Transaction Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_orig_trans_type = null;
    /**
     * The ord_po_number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_po_number = null;
    /**
     * The ord_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cur_key = null;
    /**
     * The ord_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Order Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_trx_date = null;
    /**
     * The ord_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: opportunity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_sfo_key = null;
    /**
     * The ord_group_flag
     * Meta information extracted from the WSDL
     * - documentation: Group order for reporting. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_group_flag = null;
    /**
     * The ord_group_description
     * Meta information extracted from the WSDL
     * - documentation: Order Group Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_group_description = null;
    /**
     * The ord_recurring_date_1
     * Meta information extracted from the WSDL
     * - documentation: First Date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_recurring_date_1 = null;
    /**
     * The ord_recurring_date_2
     * Meta information extracted from the WSDL
     * - documentation: Second Date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_recurring_date_2 = null;
    /**
     * The ord_cpi_consent_date
     * Meta information extracted from the WSDL
     * - documentation: Date cardholder consented to store their payment info for installment/recurring/renewal payments.. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_cpi_consent_date = null;
    /**
     * The ord_generate_from_date
     * Meta information extracted from the WSDL
     * - documentation: Generate From Date.This element has a default value of '07/01/2025'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_generate_from_date = null;
    /**
     * The ord_generate_to_date
     * Meta information extracted from the WSDL
     * - documentation: Generate To Date.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_generate_to_date = null;
    /**
     * The ord_inst_gen_auto_pay_option
     * Meta information extracted from the WSDL
     * - documentation: Generate Installments for.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_inst_gen_auto_pay_option = null;
    /**
     * The ord_inst_distributed_only_flag
     * Meta information extracted from the WSDL
     * - documentation: Union Distributed Installment Only.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_inst_distributed_only_flag = null;
    /**
     * The ord_distributed_liability_flag
     * Meta information extracted from the WSDL
     * - documentation: Distributed Liability Flag.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_distributed_liability_flag = null;
    /**
     * The ord_individual_payment_return_option
     * Meta information extracted from the WSDL
     * - documentation: Process Individual:.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_individual_payment_return_option = null;
    /**
     * The ord_payments_returns_flag
     * Meta information extracted from the WSDL
     * - documentation: Individual Payments Returns Flag.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_payments_returns_flag = null;
    /**
     * The ord_bat_key
     * Meta information extracted from the WSDL
     * - documentation: Batch.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_bat_key = null;
    /**
     * The ord_processed_schedule_count
     * Meta information extracted from the WSDL
     * - documentation: number of processed schedules.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_processed_schedule_count = null;
    /**
     * The ord_bat_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Date.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_bat_trx_date = null;
    /**
     * The ord_current_schedule_processed
     * Meta information extracted from the WSDL
     * - documentation: ScheduleKey. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_current_schedule_processed = null;
    /**
     * The ord_first_installment_amount
     * Meta information extracted from the WSDL
     * - documentation: ord_first_installment_amount. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_first_installment_amount = null;
    /**
     * The ord_balance
     * Meta information extracted from the WSDL
     * - documentation: balance.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_balance = null;
    /**
     * The ord_process
     * Meta information extracted from the WSDL
     * - documentation: process.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_process = null;
    /**
     * The ord_schedule_flag
     * Meta information extracted from the WSDL
     * - documentation: schedule task.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_schedule_flag = null;
    /**
     * The ord_task_start_date
     * Meta information extracted from the WSDL
     * - documentation: task start date.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_task_start_date = null;
    /**
     * The ord_task_start_time
     * Meta information extracted from the WSDL
     * - documentation: task start time.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_task_start_time = null;
    /**
     * The ord_eml_address
     * Meta information extracted from the WSDL
     * - documentation: email notification address:.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_eml_address = null;
    /**
     * The ord_frequency_user_readable_text
     * Meta information extracted from the WSDL
     * - documentation: Order Frequency User Readable Text.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_frequency_user_readable_text = null;
    /**
     * The ord_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Tempate.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cct_key = null;
    /**
     * The ord_oig_key
     * Meta information extracted from the WSDL
     * - documentation: Installment Generate Header.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_oig_key = null;
    /**
     * The ord_num_of_paid_installments
     * Meta information extracted from the WSDL
     * - documentation: ord_number_of_paid_installments.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_num_of_paid_installments = null;
    /**
     * The ord_hide_gen_next_installmt_btn_flag
     * Meta information extracted from the WSDL
     * - documentation: Hide generate next installment on order profile.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_hide_gen_next_installmt_btn_flag = null;
    /**
     * The ord_payment_choice
     * Meta information extracted from the WSDL
     * - documentation: Payment Choice.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_payment_choice = null;
    /**
     * The ord_action_type_virt
     * Meta information extracted from the WSDL
     * - documentation: Action type.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_action_type_virt = null;
    /**
     * The ord_cpi_status
     * Meta information extracted from the WSDL
     * - documentation: Stored Payment Info Status. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_cpi_status = null;
    /**
     * The ord_amount_paid
     * Meta information extracted from the WSDL
     * - documentation: Amount paid different than scheduled.This element has a default value of '0.00'. This field has this Input Mask: 999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ord_amount_paid = null;
    /**
     * The ord_first_installment_amount_user_edit
     * Meta information extracted from the WSDL
     * - documentation: ord_first_installment_amount_user_edit.This element has a default value of '0.00'. This field has this Input Mask: 999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ord_first_installment_amount_user_edit = null;
    /**
     * Constructor method for mb_membership_Installment_Billing_DataObjectType
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cst_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_frequency()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_ptr_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_last_bill_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_proforma()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_type()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_pin_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_num_of_installments()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_num_invoices_to_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cst_billing_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_ind_cst_billing_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cxa_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cph_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cfx_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_eml_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_pref_comm_method()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_src_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_med_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_notes_internal()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_notes_external()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_add_user()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_add_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_change_user()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_change_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_delete_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_entity_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_key_ext()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_ait_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_first_process_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_code()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_close_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_milestone_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cpi_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_auto_pay()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_orig_trans_type()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_po_number()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cur_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_trx_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_sfo_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_group_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_group_description()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_recurring_date_1()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_recurring_date_2()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cpi_consent_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_generate_from_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_generate_to_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_inst_gen_auto_pay_option()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_inst_distributed_only_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_distributed_liability_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_individual_payment_return_option()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_payments_returns_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_bat_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_processed_schedule_count()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_bat_trx_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_current_schedule_processed()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_first_installment_amount()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_balance()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_process()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_schedule_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_task_start_date()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_task_start_time()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_eml_address()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_frequency_user_readable_text()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cct_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_oig_key()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_num_of_paid_installments()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_hide_gen_next_installmt_btn_flag()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_payment_choice()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_action_type_virt()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_cpi_status()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_amount_paid()
     * @uses Mb_membership_Installment_Billing_DataObjectType::setOrd_first_installment_amount_user_edit()
     * @param string $ord_key
     * @param string $ord_cst_key
     * @param int $ord_frequency
     * @param string $ord_ptr_key
     * @param string $ord_last_bill_date
     * @param string $ord_proforma
     * @param string $ord_type
     * @param string $ord_pin_key
     * @param int $ord_num_of_installments
     * @param int $ord_num_invoices_to_date
     * @param string $ord_cst_billing_key
     * @param string $ord_ind_cst_billing_key
     * @param string $ord_cxa_key
     * @param string $ord_cph_key
     * @param string $ord_cfx_key
     * @param string $ord_eml_key
     * @param string $ord_pref_comm_method
     * @param string $ord_src_key
     * @param string $ord_med_key
     * @param string $ord_notes_internal
     * @param string $ord_notes_external
     * @param string $ord_add_user
     * @param string $ord_add_date
     * @param string $ord_change_user
     * @param string $ord_change_date
     * @param string $ord_delete_flag
     * @param string $ord_entity_key
     * @param string $ord_key_ext
     * @param string $ord_ait_key
     * @param string $ord_first_process_date
     * @param string $ord_code
     * @param string $ord_close_flag
     * @param string $ord_milestone_flag
     * @param string $ord_cpi_key
     * @param string $ord_auto_pay
     * @param string $ord_orig_trans_type
     * @param string $ord_po_number
     * @param string $ord_cur_key
     * @param string $ord_trx_date
     * @param string $ord_sfo_key
     * @param string $ord_group_flag
     * @param string $ord_group_description
     * @param int $ord_recurring_date_1
     * @param int $ord_recurring_date_2
     * @param string $ord_cpi_consent_date
     * @param string $ord_generate_from_date
     * @param string $ord_generate_to_date
     * @param string $ord_inst_gen_auto_pay_option
     * @param string $ord_inst_distributed_only_flag
     * @param string $ord_distributed_liability_flag
     * @param string $ord_individual_payment_return_option
     * @param string $ord_payments_returns_flag
     * @param string $ord_bat_key
     * @param string $ord_processed_schedule_count
     * @param string $ord_bat_trx_date
     * @param string $ord_current_schedule_processed
     * @param string $ord_first_installment_amount
     * @param string $ord_balance
     * @param string $ord_process
     * @param string $ord_schedule_flag
     * @param string $ord_task_start_date
     * @param string $ord_task_start_time
     * @param string $ord_eml_address
     * @param int $ord_frequency_user_readable_text
     * @param string $ord_cct_key
     * @param string $ord_oig_key
     * @param int $ord_num_of_paid_installments
     * @param string $ord_hide_gen_next_installmt_btn_flag
     * @param int $ord_payment_choice
     * @param string $ord_action_type_virt
     * @param string $ord_cpi_status
     * @param float $ord_amount_paid
     * @param float $ord_first_installment_amount_user_edit
     */
    public function __construct(?string $ord_key = null, ?string $ord_cst_key = null, ?int $ord_frequency = null, ?string $ord_ptr_key = null, ?string $ord_last_bill_date = null, ?string $ord_proforma = null, ?string $ord_type = null, ?string $ord_pin_key = null, ?int $ord_num_of_installments = null, ?int $ord_num_invoices_to_date = null, ?string $ord_cst_billing_key = null, ?string $ord_ind_cst_billing_key = null, ?string $ord_cxa_key = null, ?string $ord_cph_key = null, ?string $ord_cfx_key = null, ?string $ord_eml_key = null, ?string $ord_pref_comm_method = null, ?string $ord_src_key = null, ?string $ord_med_key = null, ?string $ord_notes_internal = null, ?string $ord_notes_external = null, ?string $ord_add_user = null, ?string $ord_add_date = null, ?string $ord_change_user = null, ?string $ord_change_date = null, ?string $ord_delete_flag = null, ?string $ord_entity_key = null, ?string $ord_key_ext = null, ?string $ord_ait_key = null, ?string $ord_first_process_date = null, ?string $ord_code = null, ?string $ord_close_flag = null, ?string $ord_milestone_flag = null, ?string $ord_cpi_key = null, ?string $ord_auto_pay = null, ?string $ord_orig_trans_type = null, ?string $ord_po_number = null, ?string $ord_cur_key = null, ?string $ord_trx_date = null, ?string $ord_sfo_key = null, ?string $ord_group_flag = null, ?string $ord_group_description = null, ?int $ord_recurring_date_1 = null, ?int $ord_recurring_date_2 = null, ?string $ord_cpi_consent_date = null, ?string $ord_generate_from_date = null, ?string $ord_generate_to_date = null, ?string $ord_inst_gen_auto_pay_option = null, ?string $ord_inst_distributed_only_flag = null, ?string $ord_distributed_liability_flag = null, ?string $ord_individual_payment_return_option = null, ?string $ord_payments_returns_flag = null, ?string $ord_bat_key = null, ?string $ord_processed_schedule_count = null, ?string $ord_bat_trx_date = null, ?string $ord_current_schedule_processed = null, ?string $ord_first_installment_amount = null, ?string $ord_balance = null, ?string $ord_process = null, ?string $ord_schedule_flag = null, ?string $ord_task_start_date = null, ?string $ord_task_start_time = null, ?string $ord_eml_address = null, ?int $ord_frequency_user_readable_text = null, ?string $ord_cct_key = null, ?string $ord_oig_key = null, ?int $ord_num_of_paid_installments = null, ?string $ord_hide_gen_next_installmt_btn_flag = null, ?int $ord_payment_choice = null, ?string $ord_action_type_virt = null, ?string $ord_cpi_status = null, ?float $ord_amount_paid = null, ?float $ord_first_installment_amount_user_edit = null)
    {
        $this
            ->setOrd_key($ord_key)
            ->setOrd_cst_key($ord_cst_key)
            ->setOrd_frequency($ord_frequency)
            ->setOrd_ptr_key($ord_ptr_key)
            ->setOrd_last_bill_date($ord_last_bill_date)
            ->setOrd_proforma($ord_proforma)
            ->setOrd_type($ord_type)
            ->setOrd_pin_key($ord_pin_key)
            ->setOrd_num_of_installments($ord_num_of_installments)
            ->setOrd_num_invoices_to_date($ord_num_invoices_to_date)
            ->setOrd_cst_billing_key($ord_cst_billing_key)
            ->setOrd_ind_cst_billing_key($ord_ind_cst_billing_key)
            ->setOrd_cxa_key($ord_cxa_key)
            ->setOrd_cph_key($ord_cph_key)
            ->setOrd_cfx_key($ord_cfx_key)
            ->setOrd_eml_key($ord_eml_key)
            ->setOrd_pref_comm_method($ord_pref_comm_method)
            ->setOrd_src_key($ord_src_key)
            ->setOrd_med_key($ord_med_key)
            ->setOrd_notes_internal($ord_notes_internal)
            ->setOrd_notes_external($ord_notes_external)
            ->setOrd_add_user($ord_add_user)
            ->setOrd_add_date($ord_add_date)
            ->setOrd_change_user($ord_change_user)
            ->setOrd_change_date($ord_change_date)
            ->setOrd_delete_flag($ord_delete_flag)
            ->setOrd_entity_key($ord_entity_key)
            ->setOrd_key_ext($ord_key_ext)
            ->setOrd_ait_key($ord_ait_key)
            ->setOrd_first_process_date($ord_first_process_date)
            ->setOrd_code($ord_code)
            ->setOrd_close_flag($ord_close_flag)
            ->setOrd_milestone_flag($ord_milestone_flag)
            ->setOrd_cpi_key($ord_cpi_key)
            ->setOrd_auto_pay($ord_auto_pay)
            ->setOrd_orig_trans_type($ord_orig_trans_type)
            ->setOrd_po_number($ord_po_number)
            ->setOrd_cur_key($ord_cur_key)
            ->setOrd_trx_date($ord_trx_date)
            ->setOrd_sfo_key($ord_sfo_key)
            ->setOrd_group_flag($ord_group_flag)
            ->setOrd_group_description($ord_group_description)
            ->setOrd_recurring_date_1($ord_recurring_date_1)
            ->setOrd_recurring_date_2($ord_recurring_date_2)
            ->setOrd_cpi_consent_date($ord_cpi_consent_date)
            ->setOrd_generate_from_date($ord_generate_from_date)
            ->setOrd_generate_to_date($ord_generate_to_date)
            ->setOrd_inst_gen_auto_pay_option($ord_inst_gen_auto_pay_option)
            ->setOrd_inst_distributed_only_flag($ord_inst_distributed_only_flag)
            ->setOrd_distributed_liability_flag($ord_distributed_liability_flag)
            ->setOrd_individual_payment_return_option($ord_individual_payment_return_option)
            ->setOrd_payments_returns_flag($ord_payments_returns_flag)
            ->setOrd_bat_key($ord_bat_key)
            ->setOrd_processed_schedule_count($ord_processed_schedule_count)
            ->setOrd_bat_trx_date($ord_bat_trx_date)
            ->setOrd_current_schedule_processed($ord_current_schedule_processed)
            ->setOrd_first_installment_amount($ord_first_installment_amount)
            ->setOrd_balance($ord_balance)
            ->setOrd_process($ord_process)
            ->setOrd_schedule_flag($ord_schedule_flag)
            ->setOrd_task_start_date($ord_task_start_date)
            ->setOrd_task_start_time($ord_task_start_time)
            ->setOrd_eml_address($ord_eml_address)
            ->setOrd_frequency_user_readable_text($ord_frequency_user_readable_text)
            ->setOrd_cct_key($ord_cct_key)
            ->setOrd_oig_key($ord_oig_key)
            ->setOrd_num_of_paid_installments($ord_num_of_paid_installments)
            ->setOrd_hide_gen_next_installmt_btn_flag($ord_hide_gen_next_installmt_btn_flag)
            ->setOrd_payment_choice($ord_payment_choice)
            ->setOrd_action_type_virt($ord_action_type_virt)
            ->setOrd_cpi_status($ord_cpi_status)
            ->setOrd_amount_paid($ord_amount_paid)
            ->setOrd_first_installment_amount_user_edit($ord_first_installment_amount_user_edit);
    }
    /**
     * Get ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_key(): ?string
    {
        return $this->ord_key ?? null;
    }
    /**
     * Set ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_key(?string $ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_key) && !is_string($ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_key, true), gettype($ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_key, true)), __LINE__);
        }
        if (is_null($ord_key) || (is_array($ord_key) && empty($ord_key))) {
            unset($this->ord_key);
        } else {
            $this->ord_key = $ord_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cst_key(): ?string
    {
        return $this->ord_cst_key ?? null;
    }
    /**
     * Set ord_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cst_key(?string $ord_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cst_key) && !is_string($ord_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cst_key, true), gettype($ord_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cst_key, true)), __LINE__);
        }
        if (is_null($ord_cst_key) || (is_array($ord_cst_key) && empty($ord_cst_key))) {
            unset($this->ord_cst_key);
        } else {
            $this->ord_cst_key = $ord_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ord_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_frequency(): ?int
    {
        return $this->ord_frequency ?? null;
    }
    /**
     * Set ord_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_frequency(?int $ord_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_frequency) && !(is_int($ord_frequency) || ctype_digit($ord_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_frequency, true), gettype($ord_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_frequency) && $ord_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_frequency) && $ord_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_frequency, true)), __LINE__);
        }
        if (is_null($ord_frequency) || (is_array($ord_frequency) && empty($ord_frequency))) {
            unset($this->ord_frequency);
        } else {
            $this->ord_frequency = $ord_frequency;
        }
        
        return $this;
    }
    /**
     * Get ord_ptr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ptr_key(): ?string
    {
        return $this->ord_ptr_key ?? null;
    }
    /**
     * Set ord_ptr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ptr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_ptr_key(?string $ord_ptr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ptr_key) && !is_string($ord_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ptr_key, true), gettype($ord_ptr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ptr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ptr_key, true)), __LINE__);
        }
        if (is_null($ord_ptr_key) || (is_array($ord_ptr_key) && empty($ord_ptr_key))) {
            unset($this->ord_ptr_key);
        } else {
            $this->ord_ptr_key = $ord_ptr_key;
        }
        
        return $this;
    }
    /**
     * Get ord_last_bill_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_last_bill_date(): ?string
    {
        return $this->ord_last_bill_date ?? null;
    }
    /**
     * Set ord_last_bill_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_last_bill_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_last_bill_date(?string $ord_last_bill_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_last_bill_date) && !is_string($ord_last_bill_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_last_bill_date, true), gettype($ord_last_bill_date)), __LINE__);
        }
        if (is_null($ord_last_bill_date) || (is_array($ord_last_bill_date) && empty($ord_last_bill_date))) {
            unset($this->ord_last_bill_date);
        } else {
            $this->ord_last_bill_date = $ord_last_bill_date;
        }
        
        return $this;
    }
    /**
     * Get ord_proforma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_proforma(): ?string
    {
        return $this->ord_proforma ?? null;
    }
    /**
     * Set ord_proforma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_proforma
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_proforma(?string $ord_proforma = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_proforma) && !is_string($ord_proforma)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_proforma, true), gettype($ord_proforma)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_proforma) && $ord_proforma > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_proforma, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_proforma) && $ord_proforma < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_proforma, true)), __LINE__);
        }
        if (is_null($ord_proforma) || (is_array($ord_proforma) && empty($ord_proforma))) {
            unset($this->ord_proforma);
        } else {
            $this->ord_proforma = $ord_proforma;
        }
        
        return $this;
    }
    /**
     * Get ord_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_type(): ?string
    {
        return $this->ord_type ?? null;
    }
    /**
     * Set ord_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_type(?string $ord_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_type) && !is_string($ord_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_type, true), gettype($ord_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_type) && mb_strlen((string) $ord_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_type)), __LINE__);
        }
        if (is_null($ord_type) || (is_array($ord_type) && empty($ord_type))) {
            unset($this->ord_type);
        } else {
            $this->ord_type = $ord_type;
        }
        
        return $this;
    }
    /**
     * Get ord_pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_pin_key(): ?string
    {
        return $this->ord_pin_key ?? null;
    }
    /**
     * Set ord_pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_pin_key(?string $ord_pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_pin_key) && !is_string($ord_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_pin_key, true), gettype($ord_pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_pin_key, true)), __LINE__);
        }
        if (is_null($ord_pin_key) || (is_array($ord_pin_key) && empty($ord_pin_key))) {
            unset($this->ord_pin_key);
        } else {
            $this->ord_pin_key = $ord_pin_key;
        }
        
        return $this;
    }
    /**
     * Get ord_num_of_installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_num_of_installments(): ?int
    {
        return $this->ord_num_of_installments ?? null;
    }
    /**
     * Set ord_num_of_installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_num_of_installments
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_num_of_installments(?int $ord_num_of_installments = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_num_of_installments) && !(is_int($ord_num_of_installments) || ctype_digit($ord_num_of_installments))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_num_of_installments, true), gettype($ord_num_of_installments)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_num_of_installments) && $ord_num_of_installments > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_num_of_installments, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_num_of_installments) && $ord_num_of_installments < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_num_of_installments, true)), __LINE__);
        }
        if (is_null($ord_num_of_installments) || (is_array($ord_num_of_installments) && empty($ord_num_of_installments))) {
            unset($this->ord_num_of_installments);
        } else {
            $this->ord_num_of_installments = $ord_num_of_installments;
        }
        
        return $this;
    }
    /**
     * Get ord_num_invoices_to_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_num_invoices_to_date(): ?int
    {
        return $this->ord_num_invoices_to_date ?? null;
    }
    /**
     * Set ord_num_invoices_to_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_num_invoices_to_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_num_invoices_to_date(?int $ord_num_invoices_to_date = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_num_invoices_to_date) && !(is_int($ord_num_invoices_to_date) || ctype_digit($ord_num_invoices_to_date))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_num_invoices_to_date, true), gettype($ord_num_invoices_to_date)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_num_invoices_to_date) && $ord_num_invoices_to_date > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_num_invoices_to_date, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_num_invoices_to_date) && $ord_num_invoices_to_date < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_num_invoices_to_date, true)), __LINE__);
        }
        if (is_null($ord_num_invoices_to_date) || (is_array($ord_num_invoices_to_date) && empty($ord_num_invoices_to_date))) {
            unset($this->ord_num_invoices_to_date);
        } else {
            $this->ord_num_invoices_to_date = $ord_num_invoices_to_date;
        }
        
        return $this;
    }
    /**
     * Get ord_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cst_billing_key(): ?string
    {
        return $this->ord_cst_billing_key ?? null;
    }
    /**
     * Set ord_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cst_billing_key(?string $ord_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cst_billing_key) && !is_string($ord_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cst_billing_key, true), gettype($ord_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cst_billing_key, true)), __LINE__);
        }
        if (is_null($ord_cst_billing_key) || (is_array($ord_cst_billing_key) && empty($ord_cst_billing_key))) {
            unset($this->ord_cst_billing_key);
        } else {
            $this->ord_cst_billing_key = $ord_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get ord_ind_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ind_cst_billing_key(): ?string
    {
        return $this->ord_ind_cst_billing_key ?? null;
    }
    /**
     * Set ord_ind_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ind_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_ind_cst_billing_key(?string $ord_ind_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ind_cst_billing_key) && !is_string($ord_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ind_cst_billing_key, true), gettype($ord_ind_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ind_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ind_cst_billing_key, true)), __LINE__);
        }
        if (is_null($ord_ind_cst_billing_key) || (is_array($ord_ind_cst_billing_key) && empty($ord_ind_cst_billing_key))) {
            unset($this->ord_ind_cst_billing_key);
        } else {
            $this->ord_ind_cst_billing_key = $ord_ind_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cxa_key(): ?string
    {
        return $this->ord_cxa_key ?? null;
    }
    /**
     * Set ord_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cxa_key(?string $ord_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cxa_key) && !is_string($ord_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cxa_key, true), gettype($ord_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cxa_key, true)), __LINE__);
        }
        if (is_null($ord_cxa_key) || (is_array($ord_cxa_key) && empty($ord_cxa_key))) {
            unset($this->ord_cxa_key);
        } else {
            $this->ord_cxa_key = $ord_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cph_key(): ?string
    {
        return $this->ord_cph_key ?? null;
    }
    /**
     * Set ord_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cph_key(?string $ord_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cph_key) && !is_string($ord_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cph_key, true), gettype($ord_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cph_key, true)), __LINE__);
        }
        if (is_null($ord_cph_key) || (is_array($ord_cph_key) && empty($ord_cph_key))) {
            unset($this->ord_cph_key);
        } else {
            $this->ord_cph_key = $ord_cph_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cfx_key(): ?string
    {
        return $this->ord_cfx_key ?? null;
    }
    /**
     * Set ord_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cfx_key(?string $ord_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cfx_key) && !is_string($ord_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cfx_key, true), gettype($ord_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cfx_key, true)), __LINE__);
        }
        if (is_null($ord_cfx_key) || (is_array($ord_cfx_key) && empty($ord_cfx_key))) {
            unset($this->ord_cfx_key);
        } else {
            $this->ord_cfx_key = $ord_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get ord_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_eml_key(): ?string
    {
        return $this->ord_eml_key ?? null;
    }
    /**
     * Set ord_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_eml_key(?string $ord_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_eml_key) && !is_string($ord_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_eml_key, true), gettype($ord_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_eml_key, true)), __LINE__);
        }
        if (is_null($ord_eml_key) || (is_array($ord_eml_key) && empty($ord_eml_key))) {
            unset($this->ord_eml_key);
        } else {
            $this->ord_eml_key = $ord_eml_key;
        }
        
        return $this;
    }
    /**
     * Get ord_pref_comm_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_pref_comm_method(): ?string
    {
        return $this->ord_pref_comm_method ?? null;
    }
    /**
     * Set ord_pref_comm_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_pref_comm_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_pref_comm_method(?string $ord_pref_comm_method = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_pref_comm_method) && !is_string($ord_pref_comm_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_pref_comm_method, true), gettype($ord_pref_comm_method)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ord_pref_comm_method) && mb_strlen((string) $ord_pref_comm_method) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ord_pref_comm_method)), __LINE__);
        }
        if (is_null($ord_pref_comm_method) || (is_array($ord_pref_comm_method) && empty($ord_pref_comm_method))) {
            unset($this->ord_pref_comm_method);
        } else {
            $this->ord_pref_comm_method = $ord_pref_comm_method;
        }
        
        return $this;
    }
    /**
     * Get ord_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_src_key(): ?string
    {
        return $this->ord_src_key ?? null;
    }
    /**
     * Set ord_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_src_key(?string $ord_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_src_key) && !is_string($ord_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_src_key, true), gettype($ord_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_src_key, true)), __LINE__);
        }
        if (is_null($ord_src_key) || (is_array($ord_src_key) && empty($ord_src_key))) {
            unset($this->ord_src_key);
        } else {
            $this->ord_src_key = $ord_src_key;
        }
        
        return $this;
    }
    /**
     * Get ord_med_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_med_key(): ?string
    {
        return $this->ord_med_key ?? null;
    }
    /**
     * Set ord_med_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_med_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_med_key(?string $ord_med_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_med_key) && !is_string($ord_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_med_key, true), gettype($ord_med_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_med_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_med_key, true)), __LINE__);
        }
        if (is_null($ord_med_key) || (is_array($ord_med_key) && empty($ord_med_key))) {
            unset($this->ord_med_key);
        } else {
            $this->ord_med_key = $ord_med_key;
        }
        
        return $this;
    }
    /**
     * Get ord_notes_internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_notes_internal(): ?string
    {
        return $this->ord_notes_internal ?? null;
    }
    /**
     * Set ord_notes_internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_notes_internal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_notes_internal(?string $ord_notes_internal = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_notes_internal) && !is_string($ord_notes_internal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_notes_internal, true), gettype($ord_notes_internal)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_notes_internal) && mb_strlen((string) $ord_notes_internal) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_notes_internal)), __LINE__);
        }
        if (is_null($ord_notes_internal) || (is_array($ord_notes_internal) && empty($ord_notes_internal))) {
            unset($this->ord_notes_internal);
        } else {
            $this->ord_notes_internal = $ord_notes_internal;
        }
        
        return $this;
    }
    /**
     * Get ord_notes_external value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_notes_external(): ?string
    {
        return $this->ord_notes_external ?? null;
    }
    /**
     * Set ord_notes_external value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_notes_external
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_notes_external(?string $ord_notes_external = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_notes_external) && !is_string($ord_notes_external)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_notes_external, true), gettype($ord_notes_external)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_notes_external) && mb_strlen((string) $ord_notes_external) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_notes_external)), __LINE__);
        }
        if (is_null($ord_notes_external) || (is_array($ord_notes_external) && empty($ord_notes_external))) {
            unset($this->ord_notes_external);
        } else {
            $this->ord_notes_external = $ord_notes_external;
        }
        
        return $this;
    }
    /**
     * Get ord_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_add_user(): ?string
    {
        return $this->ord_add_user ?? null;
    }
    /**
     * Set ord_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_add_user(?string $ord_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_add_user) && !is_string($ord_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_add_user, true), gettype($ord_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ord_add_user) && mb_strlen((string) $ord_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ord_add_user)), __LINE__);
        }
        if (is_null($ord_add_user) || (is_array($ord_add_user) && empty($ord_add_user))) {
            unset($this->ord_add_user);
        } else {
            $this->ord_add_user = $ord_add_user;
        }
        
        return $this;
    }
    /**
     * Get ord_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_add_date(): ?string
    {
        return $this->ord_add_date ?? null;
    }
    /**
     * Set ord_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_add_date(?string $ord_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_add_date) && !is_string($ord_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_add_date, true), gettype($ord_add_date)), __LINE__);
        }
        if (is_null($ord_add_date) || (is_array($ord_add_date) && empty($ord_add_date))) {
            unset($this->ord_add_date);
        } else {
            $this->ord_add_date = $ord_add_date;
        }
        
        return $this;
    }
    /**
     * Get ord_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_change_user(): ?string
    {
        return $this->ord_change_user ?? null;
    }
    /**
     * Set ord_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_change_user(?string $ord_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_change_user) && !is_string($ord_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_change_user, true), gettype($ord_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ord_change_user) && mb_strlen((string) $ord_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ord_change_user)), __LINE__);
        }
        if (is_null($ord_change_user) || (is_array($ord_change_user) && empty($ord_change_user))) {
            unset($this->ord_change_user);
        } else {
            $this->ord_change_user = $ord_change_user;
        }
        
        return $this;
    }
    /**
     * Get ord_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_change_date(): ?string
    {
        return $this->ord_change_date ?? null;
    }
    /**
     * Set ord_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_change_date(?string $ord_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_change_date) && !is_string($ord_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_change_date, true), gettype($ord_change_date)), __LINE__);
        }
        if (is_null($ord_change_date) || (is_array($ord_change_date) && empty($ord_change_date))) {
            unset($this->ord_change_date);
        } else {
            $this->ord_change_date = $ord_change_date;
        }
        
        return $this;
    }
    /**
     * Get ord_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_delete_flag(): ?string
    {
        return $this->ord_delete_flag ?? null;
    }
    /**
     * Set ord_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_delete_flag(?string $ord_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_delete_flag) && !is_string($ord_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_delete_flag, true), gettype($ord_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_delete_flag) && $ord_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_delete_flag) && $ord_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_delete_flag, true)), __LINE__);
        }
        if (is_null($ord_delete_flag) || (is_array($ord_delete_flag) && empty($ord_delete_flag))) {
            unset($this->ord_delete_flag);
        } else {
            $this->ord_delete_flag = $ord_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_entity_key(): ?string
    {
        return $this->ord_entity_key ?? null;
    }
    /**
     * Set ord_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_entity_key(?string $ord_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_entity_key) && !is_string($ord_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_entity_key, true), gettype($ord_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_entity_key, true)), __LINE__);
        }
        if (is_null($ord_entity_key) || (is_array($ord_entity_key) && empty($ord_entity_key))) {
            unset($this->ord_entity_key);
        } else {
            $this->ord_entity_key = $ord_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ord_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_key_ext(): ?string
    {
        return $this->ord_key_ext ?? null;
    }
    /**
     * Set ord_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_key_ext(?string $ord_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_key_ext) && !is_string($ord_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_key_ext, true), gettype($ord_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_key_ext, true)), __LINE__);
        }
        if (is_null($ord_key_ext) || (is_array($ord_key_ext) && empty($ord_key_ext))) {
            unset($this->ord_key_ext);
        } else {
            $this->ord_key_ext = $ord_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ord_ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ait_key(): ?string
    {
        return $this->ord_ait_key ?? null;
    }
    /**
     * Set ord_ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_ait_key(?string $ord_ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ait_key) && !is_string($ord_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ait_key, true), gettype($ord_ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ait_key, true)), __LINE__);
        }
        if (is_null($ord_ait_key) || (is_array($ord_ait_key) && empty($ord_ait_key))) {
            unset($this->ord_ait_key);
        } else {
            $this->ord_ait_key = $ord_ait_key;
        }
        
        return $this;
    }
    /**
     * Get ord_first_process_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_first_process_date(): ?string
    {
        return $this->ord_first_process_date ?? null;
    }
    /**
     * Set ord_first_process_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_first_process_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_first_process_date(?string $ord_first_process_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_first_process_date) && !is_string($ord_first_process_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_first_process_date, true), gettype($ord_first_process_date)), __LINE__);
        }
        if (is_null($ord_first_process_date) || (is_array($ord_first_process_date) && empty($ord_first_process_date))) {
            unset($this->ord_first_process_date);
        } else {
            $this->ord_first_process_date = $ord_first_process_date;
        }
        
        return $this;
    }
    /**
     * Get ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_code(): ?string
    {
        return $this->ord_code ?? null;
    }
    /**
     * Set ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_code(?string $ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_code) && !is_string($ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_code, true), gettype($ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_code) && mb_strlen((string) $ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_code)), __LINE__);
        }
        if (is_null($ord_code) || (is_array($ord_code) && empty($ord_code))) {
            unset($this->ord_code);
        } else {
            $this->ord_code = $ord_code;
        }
        
        return $this;
    }
    /**
     * Get ord_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_close_flag(): ?string
    {
        return $this->ord_close_flag ?? null;
    }
    /**
     * Set ord_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_close_flag(?string $ord_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_close_flag) && !is_string($ord_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_close_flag, true), gettype($ord_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_close_flag) && $ord_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_close_flag) && $ord_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_close_flag, true)), __LINE__);
        }
        if (is_null($ord_close_flag) || (is_array($ord_close_flag) && empty($ord_close_flag))) {
            unset($this->ord_close_flag);
        } else {
            $this->ord_close_flag = $ord_close_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_milestone_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_milestone_flag(): ?string
    {
        return $this->ord_milestone_flag ?? null;
    }
    /**
     * Set ord_milestone_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_milestone_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_milestone_flag(?string $ord_milestone_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_milestone_flag) && !is_string($ord_milestone_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_milestone_flag, true), gettype($ord_milestone_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_milestone_flag) && $ord_milestone_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_milestone_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_milestone_flag) && $ord_milestone_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_milestone_flag, true)), __LINE__);
        }
        if (is_null($ord_milestone_flag) || (is_array($ord_milestone_flag) && empty($ord_milestone_flag))) {
            unset($this->ord_milestone_flag);
        } else {
            $this->ord_milestone_flag = $ord_milestone_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cpi_key(): ?string
    {
        return $this->ord_cpi_key ?? null;
    }
    /**
     * Set ord_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cpi_key(?string $ord_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cpi_key) && !is_string($ord_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cpi_key, true), gettype($ord_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cpi_key, true)), __LINE__);
        }
        if (is_null($ord_cpi_key) || (is_array($ord_cpi_key) && empty($ord_cpi_key))) {
            unset($this->ord_cpi_key);
        } else {
            $this->ord_cpi_key = $ord_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get ord_auto_pay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_auto_pay(): ?string
    {
        return $this->ord_auto_pay ?? null;
    }
    /**
     * Set ord_auto_pay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_auto_pay
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_auto_pay(?string $ord_auto_pay = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_auto_pay) && !is_string($ord_auto_pay)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_auto_pay, true), gettype($ord_auto_pay)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_auto_pay) && $ord_auto_pay > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_auto_pay, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_auto_pay) && $ord_auto_pay < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_auto_pay, true)), __LINE__);
        }
        if (is_null($ord_auto_pay) || (is_array($ord_auto_pay) && empty($ord_auto_pay))) {
            unset($this->ord_auto_pay);
        } else {
            $this->ord_auto_pay = $ord_auto_pay;
        }
        
        return $this;
    }
    /**
     * Get ord_orig_trans_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_orig_trans_type(): ?string
    {
        return $this->ord_orig_trans_type ?? null;
    }
    /**
     * Set ord_orig_trans_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_orig_trans_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_orig_trans_type(?string $ord_orig_trans_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_orig_trans_type) && !is_string($ord_orig_trans_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_orig_trans_type, true), gettype($ord_orig_trans_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ord_orig_trans_type) && mb_strlen((string) $ord_orig_trans_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ord_orig_trans_type)), __LINE__);
        }
        if (is_null($ord_orig_trans_type) || (is_array($ord_orig_trans_type) && empty($ord_orig_trans_type))) {
            unset($this->ord_orig_trans_type);
        } else {
            $this->ord_orig_trans_type = $ord_orig_trans_type;
        }
        
        return $this;
    }
    /**
     * Get ord_po_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_po_number(): ?string
    {
        return $this->ord_po_number ?? null;
    }
    /**
     * Set ord_po_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_po_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_po_number(?string $ord_po_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_po_number) && !is_string($ord_po_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_po_number, true), gettype($ord_po_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_po_number) && mb_strlen((string) $ord_po_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_po_number)), __LINE__);
        }
        if (is_null($ord_po_number) || (is_array($ord_po_number) && empty($ord_po_number))) {
            unset($this->ord_po_number);
        } else {
            $this->ord_po_number = $ord_po_number;
        }
        
        return $this;
    }
    /**
     * Get ord_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cur_key(): ?string
    {
        return $this->ord_cur_key ?? null;
    }
    /**
     * Set ord_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cur_key(?string $ord_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cur_key) && !is_string($ord_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cur_key, true), gettype($ord_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cur_key, true)), __LINE__);
        }
        if (is_null($ord_cur_key) || (is_array($ord_cur_key) && empty($ord_cur_key))) {
            unset($this->ord_cur_key);
        } else {
            $this->ord_cur_key = $ord_cur_key;
        }
        
        return $this;
    }
    /**
     * Get ord_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_trx_date(): ?string
    {
        return $this->ord_trx_date ?? null;
    }
    /**
     * Set ord_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_trx_date(?string $ord_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_trx_date) && !is_string($ord_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_trx_date, true), gettype($ord_trx_date)), __LINE__);
        }
        if (is_null($ord_trx_date) || (is_array($ord_trx_date) && empty($ord_trx_date))) {
            unset($this->ord_trx_date);
        } else {
            $this->ord_trx_date = $ord_trx_date;
        }
        
        return $this;
    }
    /**
     * Get ord_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_sfo_key(): ?string
    {
        return $this->ord_sfo_key ?? null;
    }
    /**
     * Set ord_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_sfo_key(?string $ord_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_sfo_key) && !is_string($ord_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_sfo_key, true), gettype($ord_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_sfo_key, true)), __LINE__);
        }
        if (is_null($ord_sfo_key) || (is_array($ord_sfo_key) && empty($ord_sfo_key))) {
            unset($this->ord_sfo_key);
        } else {
            $this->ord_sfo_key = $ord_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get ord_group_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_group_flag(): ?string
    {
        return $this->ord_group_flag ?? null;
    }
    /**
     * Set ord_group_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_group_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_group_flag(?string $ord_group_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_group_flag) && !is_string($ord_group_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_group_flag, true), gettype($ord_group_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_group_flag) && $ord_group_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_group_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_group_flag) && $ord_group_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_group_flag, true)), __LINE__);
        }
        if (is_null($ord_group_flag) || (is_array($ord_group_flag) && empty($ord_group_flag))) {
            unset($this->ord_group_flag);
        } else {
            $this->ord_group_flag = $ord_group_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_group_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_group_description(): ?string
    {
        return $this->ord_group_description ?? null;
    }
    /**
     * Set ord_group_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_group_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_group_description(?string $ord_group_description = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_group_description) && !is_string($ord_group_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_group_description, true), gettype($ord_group_description)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_group_description) && mb_strlen((string) $ord_group_description) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_group_description)), __LINE__);
        }
        if (is_null($ord_group_description) || (is_array($ord_group_description) && empty($ord_group_description))) {
            unset($this->ord_group_description);
        } else {
            $this->ord_group_description = $ord_group_description;
        }
        
        return $this;
    }
    /**
     * Get ord_recurring_date value
     * @return ord_recurring_date
     */
    public function getOrd_recurring_date_1(): ?int
    {
        return $this->ord_recurring_date_1 ?? null;
    }
    /**
     * Set ord_recurring_date value
     * @param ord_recurring_date $ord_recurring_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_recurring_date_1(?int $ord_recurring_date_1 = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_recurring_date_1) && !(is_int($ord_recurring_date_1) || ctype_digit($ord_recurring_date_1))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_recurring_date_1, true), gettype($ord_recurring_date_1)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_recurring_date_1) && $ord_recurring_date_1 > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_recurring_date_1, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_recurring_date_1) && $ord_recurring_date_1 < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_recurring_date_1, true)), __LINE__);
        }
        if (is_null($ord_recurring_date_1) || (is_array($ord_recurring_date_1) && empty($ord_recurring_date_1))) {
            unset($this->ord_recurring_date_1);
        } else {
            $this->ord_recurring_date_1 = $ord_recurring_date_1;
        }
        
        return $this;
    }
    /**
     * Get ord_recurring_date value
     * @return ord_recurring_date
     */
    public function getOrd_recurring_date_2(): ?int
    {
        return $this->ord_recurring_date_2 ?? null;
    }
    /**
     * Set ord_recurring_date value
     * @param ord_recurring_date $ord_recurring_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_recurring_date_2(?int $ord_recurring_date_2 = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_recurring_date_2) && !(is_int($ord_recurring_date_2) || ctype_digit($ord_recurring_date_2))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_recurring_date_2, true), gettype($ord_recurring_date_2)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_recurring_date_2) && $ord_recurring_date_2 > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_recurring_date_2, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_recurring_date_2) && $ord_recurring_date_2 < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_recurring_date_2, true)), __LINE__);
        }
        if (is_null($ord_recurring_date_2) || (is_array($ord_recurring_date_2) && empty($ord_recurring_date_2))) {
            unset($this->ord_recurring_date_2);
        } else {
            $this->ord_recurring_date_2 = $ord_recurring_date_2;
        }
        
        return $this;
    }
    /**
     * Get ord_cpi_consent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cpi_consent_date(): ?string
    {
        return $this->ord_cpi_consent_date ?? null;
    }
    /**
     * Set ord_cpi_consent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cpi_consent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cpi_consent_date(?string $ord_cpi_consent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cpi_consent_date) && !is_string($ord_cpi_consent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cpi_consent_date, true), gettype($ord_cpi_consent_date)), __LINE__);
        }
        if (is_null($ord_cpi_consent_date) || (is_array($ord_cpi_consent_date) && empty($ord_cpi_consent_date))) {
            unset($this->ord_cpi_consent_date);
        } else {
            $this->ord_cpi_consent_date = $ord_cpi_consent_date;
        }
        
        return $this;
    }
    /**
     * Get ord_generate_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_generate_from_date(): ?string
    {
        return $this->ord_generate_from_date ?? null;
    }
    /**
     * Set ord_generate_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_generate_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_generate_from_date(?string $ord_generate_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_generate_from_date) && !is_string($ord_generate_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_generate_from_date, true), gettype($ord_generate_from_date)), __LINE__);
        }
        if (is_null($ord_generate_from_date) || (is_array($ord_generate_from_date) && empty($ord_generate_from_date))) {
            unset($this->ord_generate_from_date);
        } else {
            $this->ord_generate_from_date = $ord_generate_from_date;
        }
        
        return $this;
    }
    /**
     * Get ord_generate_to_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_generate_to_date(): ?string
    {
        return $this->ord_generate_to_date ?? null;
    }
    /**
     * Set ord_generate_to_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_generate_to_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_generate_to_date(?string $ord_generate_to_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_generate_to_date) && !is_string($ord_generate_to_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_generate_to_date, true), gettype($ord_generate_to_date)), __LINE__);
        }
        if (is_null($ord_generate_to_date) || (is_array($ord_generate_to_date) && empty($ord_generate_to_date))) {
            unset($this->ord_generate_to_date);
        } else {
            $this->ord_generate_to_date = $ord_generate_to_date;
        }
        
        return $this;
    }
    /**
     * Get ord_inst_gen_auto_pay_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_inst_gen_auto_pay_option(): ?string
    {
        return $this->ord_inst_gen_auto_pay_option ?? null;
    }
    /**
     * Set ord_inst_gen_auto_pay_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_inst_gen_auto_pay_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_inst_gen_auto_pay_option(?string $ord_inst_gen_auto_pay_option = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_inst_gen_auto_pay_option) && !is_string($ord_inst_gen_auto_pay_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_inst_gen_auto_pay_option, true), gettype($ord_inst_gen_auto_pay_option)), __LINE__);
        }
        if (is_null($ord_inst_gen_auto_pay_option) || (is_array($ord_inst_gen_auto_pay_option) && empty($ord_inst_gen_auto_pay_option))) {
            unset($this->ord_inst_gen_auto_pay_option);
        } else {
            $this->ord_inst_gen_auto_pay_option = $ord_inst_gen_auto_pay_option;
        }
        
        return $this;
    }
    /**
     * Get ord_inst_distributed_only_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_inst_distributed_only_flag(): ?string
    {
        return $this->ord_inst_distributed_only_flag ?? null;
    }
    /**
     * Set ord_inst_distributed_only_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_inst_distributed_only_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_inst_distributed_only_flag(?string $ord_inst_distributed_only_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_inst_distributed_only_flag) && !is_string($ord_inst_distributed_only_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_inst_distributed_only_flag, true), gettype($ord_inst_distributed_only_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_inst_distributed_only_flag) && $ord_inst_distributed_only_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_inst_distributed_only_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_inst_distributed_only_flag) && $ord_inst_distributed_only_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_inst_distributed_only_flag, true)), __LINE__);
        }
        if (is_null($ord_inst_distributed_only_flag) || (is_array($ord_inst_distributed_only_flag) && empty($ord_inst_distributed_only_flag))) {
            unset($this->ord_inst_distributed_only_flag);
        } else {
            $this->ord_inst_distributed_only_flag = $ord_inst_distributed_only_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_distributed_liability_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_distributed_liability_flag(): ?string
    {
        return $this->ord_distributed_liability_flag ?? null;
    }
    /**
     * Set ord_distributed_liability_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_distributed_liability_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_distributed_liability_flag(?string $ord_distributed_liability_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_distributed_liability_flag) && !is_string($ord_distributed_liability_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_distributed_liability_flag, true), gettype($ord_distributed_liability_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_distributed_liability_flag) && $ord_distributed_liability_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_distributed_liability_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_distributed_liability_flag) && $ord_distributed_liability_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_distributed_liability_flag, true)), __LINE__);
        }
        if (is_null($ord_distributed_liability_flag) || (is_array($ord_distributed_liability_flag) && empty($ord_distributed_liability_flag))) {
            unset($this->ord_distributed_liability_flag);
        } else {
            $this->ord_distributed_liability_flag = $ord_distributed_liability_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_individual_payment_return_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_individual_payment_return_option(): ?string
    {
        return $this->ord_individual_payment_return_option ?? null;
    }
    /**
     * Set ord_individual_payment_return_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_individual_payment_return_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_individual_payment_return_option(?string $ord_individual_payment_return_option = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_individual_payment_return_option) && !is_string($ord_individual_payment_return_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_individual_payment_return_option, true), gettype($ord_individual_payment_return_option)), __LINE__);
        }
        if (is_null($ord_individual_payment_return_option) || (is_array($ord_individual_payment_return_option) && empty($ord_individual_payment_return_option))) {
            unset($this->ord_individual_payment_return_option);
        } else {
            $this->ord_individual_payment_return_option = $ord_individual_payment_return_option;
        }
        
        return $this;
    }
    /**
     * Get ord_payments_returns_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_payments_returns_flag(): ?string
    {
        return $this->ord_payments_returns_flag ?? null;
    }
    /**
     * Set ord_payments_returns_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_payments_returns_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_payments_returns_flag(?string $ord_payments_returns_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_payments_returns_flag) && !is_string($ord_payments_returns_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_payments_returns_flag, true), gettype($ord_payments_returns_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_payments_returns_flag) && $ord_payments_returns_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_payments_returns_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_payments_returns_flag) && $ord_payments_returns_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_payments_returns_flag, true)), __LINE__);
        }
        if (is_null($ord_payments_returns_flag) || (is_array($ord_payments_returns_flag) && empty($ord_payments_returns_flag))) {
            unset($this->ord_payments_returns_flag);
        } else {
            $this->ord_payments_returns_flag = $ord_payments_returns_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_bat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_bat_key(): ?string
    {
        return $this->ord_bat_key ?? null;
    }
    /**
     * Set ord_bat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_bat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_bat_key(?string $ord_bat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_bat_key) && !is_string($ord_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_bat_key, true), gettype($ord_bat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_bat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_bat_key, true)), __LINE__);
        }
        if (is_null($ord_bat_key) || (is_array($ord_bat_key) && empty($ord_bat_key))) {
            unset($this->ord_bat_key);
        } else {
            $this->ord_bat_key = $ord_bat_key;
        }
        
        return $this;
    }
    /**
     * Get ord_processed_schedule_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_processed_schedule_count(): ?string
    {
        return $this->ord_processed_schedule_count ?? null;
    }
    /**
     * Set ord_processed_schedule_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_processed_schedule_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_processed_schedule_count(?string $ord_processed_schedule_count = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_processed_schedule_count) && !is_string($ord_processed_schedule_count)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_processed_schedule_count, true), gettype($ord_processed_schedule_count)), __LINE__);
        }
        if (is_null($ord_processed_schedule_count) || (is_array($ord_processed_schedule_count) && empty($ord_processed_schedule_count))) {
            unset($this->ord_processed_schedule_count);
        } else {
            $this->ord_processed_schedule_count = $ord_processed_schedule_count;
        }
        
        return $this;
    }
    /**
     * Get ord_bat_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_bat_trx_date(): ?string
    {
        return $this->ord_bat_trx_date ?? null;
    }
    /**
     * Set ord_bat_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_bat_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_bat_trx_date(?string $ord_bat_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_bat_trx_date) && !is_string($ord_bat_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_bat_trx_date, true), gettype($ord_bat_trx_date)), __LINE__);
        }
        if (is_null($ord_bat_trx_date) || (is_array($ord_bat_trx_date) && empty($ord_bat_trx_date))) {
            unset($this->ord_bat_trx_date);
        } else {
            $this->ord_bat_trx_date = $ord_bat_trx_date;
        }
        
        return $this;
    }
    /**
     * Get ord_current_schedule_processed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_current_schedule_processed(): ?string
    {
        return $this->ord_current_schedule_processed ?? null;
    }
    /**
     * Set ord_current_schedule_processed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_current_schedule_processed
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_current_schedule_processed(?string $ord_current_schedule_processed = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_current_schedule_processed) && !is_string($ord_current_schedule_processed)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_current_schedule_processed, true), gettype($ord_current_schedule_processed)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_current_schedule_processed) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_current_schedule_processed)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_current_schedule_processed, true)), __LINE__);
        }
        if (is_null($ord_current_schedule_processed) || (is_array($ord_current_schedule_processed) && empty($ord_current_schedule_processed))) {
            unset($this->ord_current_schedule_processed);
        } else {
            $this->ord_current_schedule_processed = $ord_current_schedule_processed;
        }
        
        return $this;
    }
    /**
     * Get ord_first_installment_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_first_installment_amount(): ?string
    {
        return $this->ord_first_installment_amount ?? null;
    }
    /**
     * Set ord_first_installment_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_first_installment_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_first_installment_amount(?string $ord_first_installment_amount = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_first_installment_amount) && !is_string($ord_first_installment_amount)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_first_installment_amount, true), gettype($ord_first_installment_amount)), __LINE__);
        }
        if (is_null($ord_first_installment_amount) || (is_array($ord_first_installment_amount) && empty($ord_first_installment_amount))) {
            unset($this->ord_first_installment_amount);
        } else {
            $this->ord_first_installment_amount = $ord_first_installment_amount;
        }
        
        return $this;
    }
    /**
     * Get ord_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_balance(): ?string
    {
        return $this->ord_balance ?? null;
    }
    /**
     * Set ord_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_balance(?string $ord_balance = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_balance) && !is_string($ord_balance)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_balance, true), gettype($ord_balance)), __LINE__);
        }
        if (is_null($ord_balance) || (is_array($ord_balance) && empty($ord_balance))) {
            unset($this->ord_balance);
        } else {
            $this->ord_balance = $ord_balance;
        }
        
        return $this;
    }
    /**
     * Get ord_process value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_process(): ?string
    {
        return $this->ord_process ?? null;
    }
    /**
     * Set ord_process value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_process
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_process(?string $ord_process = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_process) && !is_string($ord_process)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_process, true), gettype($ord_process)), __LINE__);
        }
        if (is_null($ord_process) || (is_array($ord_process) && empty($ord_process))) {
            unset($this->ord_process);
        } else {
            $this->ord_process = $ord_process;
        }
        
        return $this;
    }
    /**
     * Get ord_schedule_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_schedule_flag(): ?string
    {
        return $this->ord_schedule_flag ?? null;
    }
    /**
     * Set ord_schedule_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_schedule_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_schedule_flag(?string $ord_schedule_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_schedule_flag) && !is_string($ord_schedule_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_schedule_flag, true), gettype($ord_schedule_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_schedule_flag) && $ord_schedule_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_schedule_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_schedule_flag) && $ord_schedule_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_schedule_flag, true)), __LINE__);
        }
        if (is_null($ord_schedule_flag) || (is_array($ord_schedule_flag) && empty($ord_schedule_flag))) {
            unset($this->ord_schedule_flag);
        } else {
            $this->ord_schedule_flag = $ord_schedule_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_task_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_task_start_date(): ?string
    {
        return $this->ord_task_start_date ?? null;
    }
    /**
     * Set ord_task_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_task_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_task_start_date(?string $ord_task_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_task_start_date) && !is_string($ord_task_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_task_start_date, true), gettype($ord_task_start_date)), __LINE__);
        }
        if (is_null($ord_task_start_date) || (is_array($ord_task_start_date) && empty($ord_task_start_date))) {
            unset($this->ord_task_start_date);
        } else {
            $this->ord_task_start_date = $ord_task_start_date;
        }
        
        return $this;
    }
    /**
     * Get ord_task_start_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_task_start_time(): ?string
    {
        return $this->ord_task_start_time ?? null;
    }
    /**
     * Set ord_task_start_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_task_start_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_task_start_time(?string $ord_task_start_time = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_task_start_time) && !is_string($ord_task_start_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_task_start_time, true), gettype($ord_task_start_time)), __LINE__);
        }
        if (is_null($ord_task_start_time) || (is_array($ord_task_start_time) && empty($ord_task_start_time))) {
            unset($this->ord_task_start_time);
        } else {
            $this->ord_task_start_time = $ord_task_start_time;
        }
        
        return $this;
    }
    /**
     * Get ord_eml_address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_eml_address(): ?string
    {
        return $this->ord_eml_address ?? null;
    }
    /**
     * Set ord_eml_address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_eml_address
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_eml_address(?string $ord_eml_address = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_eml_address) && !is_string($ord_eml_address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_eml_address, true), gettype($ord_eml_address)), __LINE__);
        }
        if (is_null($ord_eml_address) || (is_array($ord_eml_address) && empty($ord_eml_address))) {
            unset($this->ord_eml_address);
        } else {
            $this->ord_eml_address = $ord_eml_address;
        }
        
        return $this;
    }
    /**
     * Get ord_frequency_user_readable_text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_frequency_user_readable_text(): ?int
    {
        return $this->ord_frequency_user_readable_text ?? null;
    }
    /**
     * Set ord_frequency_user_readable_text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_frequency_user_readable_text
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_frequency_user_readable_text(?int $ord_frequency_user_readable_text = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_frequency_user_readable_text) && !(is_int($ord_frequency_user_readable_text) || ctype_digit($ord_frequency_user_readable_text))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_frequency_user_readable_text, true), gettype($ord_frequency_user_readable_text)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_frequency_user_readable_text) && $ord_frequency_user_readable_text > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_frequency_user_readable_text, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_frequency_user_readable_text) && $ord_frequency_user_readable_text < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_frequency_user_readable_text, true)), __LINE__);
        }
        if (is_null($ord_frequency_user_readable_text) || (is_array($ord_frequency_user_readable_text) && empty($ord_frequency_user_readable_text))) {
            unset($this->ord_frequency_user_readable_text);
        } else {
            $this->ord_frequency_user_readable_text = $ord_frequency_user_readable_text;
        }
        
        return $this;
    }
    /**
     * Get ord_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cct_key(): ?string
    {
        return $this->ord_cct_key ?? null;
    }
    /**
     * Set ord_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cct_key(?string $ord_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cct_key) && !is_string($ord_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cct_key, true), gettype($ord_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cct_key, true)), __LINE__);
        }
        if (is_null($ord_cct_key) || (is_array($ord_cct_key) && empty($ord_cct_key))) {
            unset($this->ord_cct_key);
        } else {
            $this->ord_cct_key = $ord_cct_key;
        }
        
        return $this;
    }
    /**
     * Get ord_oig_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_oig_key(): ?string
    {
        return $this->ord_oig_key ?? null;
    }
    /**
     * Set ord_oig_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_oig_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_oig_key(?string $ord_oig_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_oig_key) && !is_string($ord_oig_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_oig_key, true), gettype($ord_oig_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_oig_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_oig_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_oig_key, true)), __LINE__);
        }
        if (is_null($ord_oig_key) || (is_array($ord_oig_key) && empty($ord_oig_key))) {
            unset($this->ord_oig_key);
        } else {
            $this->ord_oig_key = $ord_oig_key;
        }
        
        return $this;
    }
    /**
     * Get ord_num_of_paid_installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_num_of_paid_installments(): ?int
    {
        return $this->ord_num_of_paid_installments ?? null;
    }
    /**
     * Set ord_num_of_paid_installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_num_of_paid_installments
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_num_of_paid_installments(?int $ord_num_of_paid_installments = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_num_of_paid_installments) && !(is_int($ord_num_of_paid_installments) || ctype_digit($ord_num_of_paid_installments))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_num_of_paid_installments, true), gettype($ord_num_of_paid_installments)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_num_of_paid_installments) && $ord_num_of_paid_installments > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_num_of_paid_installments, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_num_of_paid_installments) && $ord_num_of_paid_installments < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_num_of_paid_installments, true)), __LINE__);
        }
        if (is_null($ord_num_of_paid_installments) || (is_array($ord_num_of_paid_installments) && empty($ord_num_of_paid_installments))) {
            unset($this->ord_num_of_paid_installments);
        } else {
            $this->ord_num_of_paid_installments = $ord_num_of_paid_installments;
        }
        
        return $this;
    }
    /**
     * Get ord_hide_gen_next_installmt_btn_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_hide_gen_next_installmt_btn_flag(): ?string
    {
        return $this->ord_hide_gen_next_installmt_btn_flag ?? null;
    }
    /**
     * Set ord_hide_gen_next_installmt_btn_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_hide_gen_next_installmt_btn_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_hide_gen_next_installmt_btn_flag(?string $ord_hide_gen_next_installmt_btn_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_hide_gen_next_installmt_btn_flag) && !is_string($ord_hide_gen_next_installmt_btn_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_hide_gen_next_installmt_btn_flag, true), gettype($ord_hide_gen_next_installmt_btn_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_hide_gen_next_installmt_btn_flag) && $ord_hide_gen_next_installmt_btn_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_hide_gen_next_installmt_btn_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_hide_gen_next_installmt_btn_flag) && $ord_hide_gen_next_installmt_btn_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_hide_gen_next_installmt_btn_flag, true)), __LINE__);
        }
        if (is_null($ord_hide_gen_next_installmt_btn_flag) || (is_array($ord_hide_gen_next_installmt_btn_flag) && empty($ord_hide_gen_next_installmt_btn_flag))) {
            unset($this->ord_hide_gen_next_installmt_btn_flag);
        } else {
            $this->ord_hide_gen_next_installmt_btn_flag = $ord_hide_gen_next_installmt_btn_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_payment_choice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_payment_choice(): ?int
    {
        return $this->ord_payment_choice ?? null;
    }
    /**
     * Set ord_payment_choice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_payment_choice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_payment_choice(?int $ord_payment_choice = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_payment_choice) && !(is_int($ord_payment_choice) || ctype_digit($ord_payment_choice))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_payment_choice, true), gettype($ord_payment_choice)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_payment_choice) && $ord_payment_choice > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_payment_choice, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_payment_choice) && $ord_payment_choice < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_payment_choice, true)), __LINE__);
        }
        if (is_null($ord_payment_choice) || (is_array($ord_payment_choice) && empty($ord_payment_choice))) {
            unset($this->ord_payment_choice);
        } else {
            $this->ord_payment_choice = $ord_payment_choice;
        }
        
        return $this;
    }
    /**
     * Get ord_action_type_virt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_action_type_virt(): ?string
    {
        return $this->ord_action_type_virt ?? null;
    }
    /**
     * Set ord_action_type_virt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_action_type_virt
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_action_type_virt(?string $ord_action_type_virt = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_action_type_virt) && !is_string($ord_action_type_virt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_action_type_virt, true), gettype($ord_action_type_virt)), __LINE__);
        }
        if (is_null($ord_action_type_virt) || (is_array($ord_action_type_virt) && empty($ord_action_type_virt))) {
            unset($this->ord_action_type_virt);
        } else {
            $this->ord_action_type_virt = $ord_action_type_virt;
        }
        
        return $this;
    }
    /**
     * Get ord_cpi_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cpi_status(): ?string
    {
        return $this->ord_cpi_status ?? null;
    }
    /**
     * Set ord_cpi_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cpi_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_cpi_status(?string $ord_cpi_status = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cpi_status) && !is_string($ord_cpi_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cpi_status, true), gettype($ord_cpi_status)), __LINE__);
        }
        if (is_null($ord_cpi_status) || (is_array($ord_cpi_status) && empty($ord_cpi_status))) {
            unset($this->ord_cpi_status);
        } else {
            $this->ord_cpi_status = $ord_cpi_status;
        }
        
        return $this;
    }
    /**
     * Get ord_amount_paid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrd_amount_paid(): ?float
    {
        return $this->ord_amount_paid ?? null;
    }
    /**
     * Set ord_amount_paid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ord_amount_paid
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_amount_paid(?float $ord_amount_paid = null): self
    {
        // validation for constraint: float
        if (!is_null($ord_amount_paid) && !(is_float($ord_amount_paid) || is_numeric($ord_amount_paid))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ord_amount_paid, true), gettype($ord_amount_paid)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ord_amount_paid) && mb_strlen(mb_substr((string) $ord_amount_paid, false !== mb_strpos((string) $ord_amount_paid, '.') ? mb_strpos((string) $ord_amount_paid, '.') + 1 : mb_strlen((string) $ord_amount_paid))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ord_amount_paid, true), mb_strlen(mb_substr((string) $ord_amount_paid, mb_strpos((string) $ord_amount_paid, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ord_amount_paid) && mb_strlen(preg_replace('/(\D)/', '', (string) $ord_amount_paid)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ord_amount_paid, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ord_amount_paid))), __LINE__);
        }
        if (is_null($ord_amount_paid) || (is_array($ord_amount_paid) && empty($ord_amount_paid))) {
            unset($this->ord_amount_paid);
        } else {
            $this->ord_amount_paid = $ord_amount_paid;
        }
        
        return $this;
    }
    /**
     * Get ord_first_installment_amount_user_edit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrd_first_installment_amount_user_edit(): ?float
    {
        return $this->ord_first_installment_amount_user_edit ?? null;
    }
    /**
     * Set ord_first_installment_amount_user_edit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ord_first_installment_amount_user_edit
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Installment_Billing_DataObjectType
     */
    public function setOrd_first_installment_amount_user_edit(?float $ord_first_installment_amount_user_edit = null): self
    {
        // validation for constraint: float
        if (!is_null($ord_first_installment_amount_user_edit) && !(is_float($ord_first_installment_amount_user_edit) || is_numeric($ord_first_installment_amount_user_edit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ord_first_installment_amount_user_edit, true), gettype($ord_first_installment_amount_user_edit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ord_first_installment_amount_user_edit) && mb_strlen(mb_substr((string) $ord_first_installment_amount_user_edit, false !== mb_strpos((string) $ord_first_installment_amount_user_edit, '.') ? mb_strpos((string) $ord_first_installment_amount_user_edit, '.') + 1 : mb_strlen((string) $ord_first_installment_amount_user_edit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ord_first_installment_amount_user_edit, true), mb_strlen(mb_substr((string) $ord_first_installment_amount_user_edit, mb_strpos((string) $ord_first_installment_amount_user_edit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ord_first_installment_amount_user_edit) && mb_strlen(preg_replace('/(\D)/', '', (string) $ord_first_installment_amount_user_edit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ord_first_installment_amount_user_edit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ord_first_installment_amount_user_edit))), __LINE__);
        }
        if (is_null($ord_first_installment_amount_user_edit) || (is_array($ord_first_installment_amount_user_edit) && empty($ord_first_installment_amount_user_edit))) {
            unset($this->ord_first_installment_amount_user_edit);
        } else {
            $this->ord_first_installment_amount_user_edit = $ord_first_installment_amount_user_edit;
        }
        
        return $this;
    }
}
