<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Member_Dues_History_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Member_Dues_History_DataObjectType extends AbstractStructBase
{
    /**
     * The mdh_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_key = null;
    /**
     * The mdh_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_add_user = null;
    /**
     * The mdh_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_add_date = null;
    /**
     * The mdh_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_change_user = null;
    /**
     * The mdh_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_change_date = null;
    /**
     * The mdh_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_delete_flag = null;
    /**
     * The mdh_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_key_ext = null;
    /**
     * The mdh_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_cst_key = null;
    /**
     * The mdh_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Membership Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_mbr_key = null;
    /**
     * The mdh_dues_year
     * Meta information extracted from the WSDL
     * - documentation: Dues Year. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mdh_dues_year = null;
    /**
     * The mdh_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_inv_key = null;
    /**
     * The mdh_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mdh_entity_key = null;
    /**
     * Constructor method for mb_membership_Member_Dues_History_DataObjectType
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_key()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_add_user()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_add_date()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_change_user()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_change_date()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_delete_flag()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_key_ext()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_cst_key()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_mbr_key()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_dues_year()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_inv_key()
     * @uses Mb_membership_Member_Dues_History_DataObjectType::setMdh_entity_key()
     * @param string $mdh_key
     * @param string $mdh_add_user
     * @param string $mdh_add_date
     * @param string $mdh_change_user
     * @param string $mdh_change_date
     * @param string $mdh_delete_flag
     * @param string $mdh_key_ext
     * @param string $mdh_cst_key
     * @param string $mdh_mbr_key
     * @param string $mdh_dues_year
     * @param string $mdh_inv_key
     * @param string $mdh_entity_key
     */
    public function __construct(?string $mdh_key = null, ?string $mdh_add_user = null, ?string $mdh_add_date = null, ?string $mdh_change_user = null, ?string $mdh_change_date = null, ?string $mdh_delete_flag = null, ?string $mdh_key_ext = null, ?string $mdh_cst_key = null, ?string $mdh_mbr_key = null, ?string $mdh_dues_year = null, ?string $mdh_inv_key = null, ?string $mdh_entity_key = null)
    {
        $this
            ->setMdh_key($mdh_key)
            ->setMdh_add_user($mdh_add_user)
            ->setMdh_add_date($mdh_add_date)
            ->setMdh_change_user($mdh_change_user)
            ->setMdh_change_date($mdh_change_date)
            ->setMdh_delete_flag($mdh_delete_flag)
            ->setMdh_key_ext($mdh_key_ext)
            ->setMdh_cst_key($mdh_cst_key)
            ->setMdh_mbr_key($mdh_mbr_key)
            ->setMdh_dues_year($mdh_dues_year)
            ->setMdh_inv_key($mdh_inv_key)
            ->setMdh_entity_key($mdh_entity_key);
    }
    /**
     * Get mdh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_key(): ?string
    {
        return $this->mdh_key ?? null;
    }
    /**
     * Set mdh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_key(?string $mdh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_key) && !is_string($mdh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_key, true), gettype($mdh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_key, true)), __LINE__);
        }
        if (is_null($mdh_key) || (is_array($mdh_key) && empty($mdh_key))) {
            unset($this->mdh_key);
        } else {
            $this->mdh_key = $mdh_key;
        }
        
        return $this;
    }
    /**
     * Get mdh_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_add_user(): ?string
    {
        return $this->mdh_add_user ?? null;
    }
    /**
     * Set mdh_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_add_user(?string $mdh_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_add_user) && !is_string($mdh_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_add_user, true), gettype($mdh_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mdh_add_user) && mb_strlen((string) $mdh_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mdh_add_user)), __LINE__);
        }
        if (is_null($mdh_add_user) || (is_array($mdh_add_user) && empty($mdh_add_user))) {
            unset($this->mdh_add_user);
        } else {
            $this->mdh_add_user = $mdh_add_user;
        }
        
        return $this;
    }
    /**
     * Get mdh_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_add_date(): ?string
    {
        return $this->mdh_add_date ?? null;
    }
    /**
     * Set mdh_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_add_date(?string $mdh_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_add_date) && !is_string($mdh_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_add_date, true), gettype($mdh_add_date)), __LINE__);
        }
        if (is_null($mdh_add_date) || (is_array($mdh_add_date) && empty($mdh_add_date))) {
            unset($this->mdh_add_date);
        } else {
            $this->mdh_add_date = $mdh_add_date;
        }
        
        return $this;
    }
    /**
     * Get mdh_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_change_user(): ?string
    {
        return $this->mdh_change_user ?? null;
    }
    /**
     * Set mdh_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_change_user(?string $mdh_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_change_user) && !is_string($mdh_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_change_user, true), gettype($mdh_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mdh_change_user) && mb_strlen((string) $mdh_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mdh_change_user)), __LINE__);
        }
        if (is_null($mdh_change_user) || (is_array($mdh_change_user) && empty($mdh_change_user))) {
            unset($this->mdh_change_user);
        } else {
            $this->mdh_change_user = $mdh_change_user;
        }
        
        return $this;
    }
    /**
     * Get mdh_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_change_date(): ?string
    {
        return $this->mdh_change_date ?? null;
    }
    /**
     * Set mdh_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_change_date(?string $mdh_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_change_date) && !is_string($mdh_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_change_date, true), gettype($mdh_change_date)), __LINE__);
        }
        if (is_null($mdh_change_date) || (is_array($mdh_change_date) && empty($mdh_change_date))) {
            unset($this->mdh_change_date);
        } else {
            $this->mdh_change_date = $mdh_change_date;
        }
        
        return $this;
    }
    /**
     * Get mdh_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_delete_flag(): ?string
    {
        return $this->mdh_delete_flag ?? null;
    }
    /**
     * Set mdh_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_delete_flag(?string $mdh_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_delete_flag) && !is_string($mdh_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_delete_flag, true), gettype($mdh_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mdh_delete_flag) && $mdh_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mdh_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mdh_delete_flag) && $mdh_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mdh_delete_flag, true)), __LINE__);
        }
        if (is_null($mdh_delete_flag) || (is_array($mdh_delete_flag) && empty($mdh_delete_flag))) {
            unset($this->mdh_delete_flag);
        } else {
            $this->mdh_delete_flag = $mdh_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get mdh_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_key_ext(): ?string
    {
        return $this->mdh_key_ext ?? null;
    }
    /**
     * Set mdh_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_key_ext(?string $mdh_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_key_ext) && !is_string($mdh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_key_ext, true), gettype($mdh_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_key_ext, true)), __LINE__);
        }
        if (is_null($mdh_key_ext) || (is_array($mdh_key_ext) && empty($mdh_key_ext))) {
            unset($this->mdh_key_ext);
        } else {
            $this->mdh_key_ext = $mdh_key_ext;
        }
        
        return $this;
    }
    /**
     * Get mdh_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_cst_key(): ?string
    {
        return $this->mdh_cst_key ?? null;
    }
    /**
     * Set mdh_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_cst_key(?string $mdh_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_cst_key) && !is_string($mdh_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_cst_key, true), gettype($mdh_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_cst_key, true)), __LINE__);
        }
        if (is_null($mdh_cst_key) || (is_array($mdh_cst_key) && empty($mdh_cst_key))) {
            unset($this->mdh_cst_key);
        } else {
            $this->mdh_cst_key = $mdh_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mdh_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_mbr_key(): ?string
    {
        return $this->mdh_mbr_key ?? null;
    }
    /**
     * Set mdh_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_mbr_key(?string $mdh_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_mbr_key) && !is_string($mdh_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_mbr_key, true), gettype($mdh_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_mbr_key, true)), __LINE__);
        }
        if (is_null($mdh_mbr_key) || (is_array($mdh_mbr_key) && empty($mdh_mbr_key))) {
            unset($this->mdh_mbr_key);
        } else {
            $this->mdh_mbr_key = $mdh_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get mdh_dues_year value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_dues_year(): ?string
    {
        return $this->mdh_dues_year ?? null;
    }
    /**
     * Set mdh_dues_year value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_dues_year
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_dues_year(?string $mdh_dues_year = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_dues_year) && !is_string($mdh_dues_year)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_dues_year, true), gettype($mdh_dues_year)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($mdh_dues_year) && mb_strlen((string) $mdh_dues_year) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $mdh_dues_year)), __LINE__);
        }
        if (is_null($mdh_dues_year) || (is_array($mdh_dues_year) && empty($mdh_dues_year))) {
            unset($this->mdh_dues_year);
        } else {
            $this->mdh_dues_year = $mdh_dues_year;
        }
        
        return $this;
    }
    /**
     * Get mdh_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_inv_key(): ?string
    {
        return $this->mdh_inv_key ?? null;
    }
    /**
     * Set mdh_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_inv_key(?string $mdh_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_inv_key) && !is_string($mdh_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_inv_key, true), gettype($mdh_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_inv_key, true)), __LINE__);
        }
        if (is_null($mdh_inv_key) || (is_array($mdh_inv_key) && empty($mdh_inv_key))) {
            unset($this->mdh_inv_key);
        } else {
            $this->mdh_inv_key = $mdh_inv_key;
        }
        
        return $this;
    }
    /**
     * Get mdh_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMdh_entity_key(): ?string
    {
        return $this->mdh_entity_key ?? null;
    }
    /**
     * Set mdh_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mdh_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Dues_History_DataObjectType
     */
    public function setMdh_entity_key(?string $mdh_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mdh_entity_key) && !is_string($mdh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdh_entity_key, true), gettype($mdh_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mdh_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mdh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mdh_entity_key, true)), __LINE__);
        }
        if (is_null($mdh_entity_key) || (is_array($mdh_entity_key) && empty($mdh_entity_key))) {
            unset($this->mdh_entity_key);
        } else {
            $this->mdh_entity_key = $mdh_entity_key;
        }
        
        return $this;
    }
}
