<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Member_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Member_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The mbt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_key = null;
    /**
     * The mbt_code
     * Meta information extracted from the WSDL
     * - documentation: Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_code = null;
    /**
     * The mbt_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_asn_code = null;
    /**
     * The mbt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_add_user = null;
    /**
     * The mbt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_add_date = null;
    /**
     * The mbt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_change_user = null;
    /**
     * The mbt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_change_date = null;
    /**
     * The mbt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_delete_flag = null;
    /**
     * The mbt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_key_ext = null;
    /**
     * The mbt_chapter_flag
     * Meta information extracted from the WSDL
     * - documentation: Chapter Member Type Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_chapter_flag = null;
    /**
     * The mbt_calendar_flag
     * Meta information extracted from the WSDL
     * - documentation: calendar. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_calendar_flag = null;
    /**
     * The mbt_membership_start_month
     * Meta information extracted from the WSDL
     * - documentation: start month. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_start_month = null;
    /**
     * The mbt_membership_start_day
     * Meta information extracted from the WSDL
     * - documentation: start day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_start_day = null;
    /**
     * The mbt_membership_next_month_after_day
     * Meta information extracted from the WSDL
     * - documentation: sell next month after day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_next_month_after_day = null;
    /**
     * The mbt_membership_sell_next_year_after_month
     * Meta information extracted from the WSDL
     * - documentation: sell for next year after month. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_sell_next_year_after_month = null;
    /**
     * The mbt_membership_sell_next_year_after_day
     * Meta information extracted from the WSDL
     * - documentation: sell for next year after day. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_sell_next_year_after_day = null;
    /**
     * The mbt_membership_grace_period
     * Meta information extracted from the WSDL
     * - documentation: grace period. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_membership_grace_period = null;
    /**
     * The mbt_membership_grace_length
     * Meta information extracted from the WSDL
     * - documentation: grace length. This field has this Input Mask: 999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_membership_grace_length = null;
    /**
     * The mbt_update_date_when
     * Meta information extracted from the WSDL
     * - documentation: Update Dates When. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_update_date_when = null;
    /**
     * The mbt_percent_paid
     * Meta information extracted from the WSDL
     * - documentation: Percent Paid. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbt_percent_paid = null;
    /**
     * The mbt_flow_down
     * Meta information extracted from the WSDL
     * - documentation: Benefit Flow Down. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_flow_down = null;
    /**
     * The mbt_voting_rights
     * Meta information extracted from the WSDL
     * - documentation: Voting Rights. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_voting_rights = null;
    /**
     * The mbt_invoice_type
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_invoice_type = null;
    /**
     * The mbt_flip_customer_member_flag
     * Meta information extracted from the WSDL
     * - documentation: Set Customer Member Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_flip_customer_member_flag = null;
    /**
     * The mbt_set_on_paid_date_flag
     * Meta information extracted from the WSDL
     * - documentation: Set Dates Based on Payment Dat. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_set_on_paid_date_flag = null;
    /**
     * The mbt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_entity_key = null;
    /**
     * The mbt_mbs_drop_key
     * Meta information extracted from the WSDL
     * - documentation: Drop Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_mbs_drop_key = null;
    /**
     * The mbt_mbs_approval_key
     * Meta information extracted from the WSDL
     * - documentation: Approval Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_mbs_approval_key = null;
    /**
     * The mbt_mbt_dependency_key
     * Meta information extracted from the WSDL
     * - documentation: MemberType Dependency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_mbt_dependency_key = null;
    /**
     * The mbt_chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_chp_cst_key = null;
    /**
     * The mbt_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_description = null;
    /**
     * The mbt_dyn_key
     * Meta information extracted from the WSDL
     * - documentation: Custom New Individual Form. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_dyn_key = null;
    /**
     * The mbt_wiz_key
     * Meta information extracted from the WSDL
     * - documentation: Join Association Wizard. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbt_wiz_key = null;
    /**
     * The mbt_cst_type
     * Meta information extracted from the WSDL
     * - documentation: Customer Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_cst_type = null;
    /**
     * The mbt_mbt_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Member Type. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_mbt_renewal_key = null;
    /**
     * The mbt_first_installment_flag
     * Meta information extracted from the WSDL
     * - documentation: First Installment?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_first_installment_flag = null;
    /**
     * The mbt_online_autopay_enroll
     * Meta information extracted from the WSDL
     * - documentation: Online Autopay Enrollment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbt_online_autopay_enroll = null;
    /**
     * Constructor method for mb_membership_Member_Type_DataObjectType
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_code()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_asn_code()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_add_user()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_add_date()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_change_user()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_change_date()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_delete_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_key_ext()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_chapter_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_calendar_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_start_month()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_start_day()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_next_month_after_day()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_sell_next_year_after_month()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_sell_next_year_after_day()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_grace_period()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_membership_grace_length()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_update_date_when()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_percent_paid()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_flow_down()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_voting_rights()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_invoice_type()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_flip_customer_member_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_set_on_paid_date_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_entity_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_mbs_drop_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_mbs_approval_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_mbt_dependency_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_chp_cst_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_description()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_dyn_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_wiz_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_cst_type()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_mbt_renewal_key()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_first_installment_flag()
     * @uses Mb_membership_Member_Type_DataObjectType::setMbt_online_autopay_enroll()
     * @param string $mbt_key
     * @param string $mbt_code
     * @param string $mbt_asn_code
     * @param string $mbt_add_user
     * @param string $mbt_add_date
     * @param string $mbt_change_user
     * @param string $mbt_change_date
     * @param string $mbt_delete_flag
     * @param string $mbt_key_ext
     * @param string $mbt_chapter_flag
     * @param string $mbt_calendar_flag
     * @param int $mbt_membership_start_month
     * @param int $mbt_membership_start_day
     * @param int $mbt_membership_next_month_after_day
     * @param int $mbt_membership_sell_next_year_after_month
     * @param int $mbt_membership_sell_next_year_after_day
     * @param string $mbt_membership_grace_period
     * @param int $mbt_membership_grace_length
     * @param string $mbt_update_date_when
     * @param int $mbt_percent_paid
     * @param string $mbt_flow_down
     * @param string $mbt_voting_rights
     * @param string $mbt_invoice_type
     * @param string $mbt_flip_customer_member_flag
     * @param string $mbt_set_on_paid_date_flag
     * @param string $mbt_entity_key
     * @param string $mbt_mbs_drop_key
     * @param string $mbt_mbs_approval_key
     * @param string $mbt_mbt_dependency_key
     * @param string $mbt_chp_cst_key
     * @param string $mbt_description
     * @param string $mbt_dyn_key
     * @param string $mbt_wiz_key
     * @param string $mbt_cst_type
     * @param string $mbt_mbt_renewal_key
     * @param string $mbt_first_installment_flag
     * @param string $mbt_online_autopay_enroll
     */
    public function __construct(?string $mbt_key = null, ?string $mbt_code = null, ?string $mbt_asn_code = null, ?string $mbt_add_user = null, ?string $mbt_add_date = null, ?string $mbt_change_user = null, ?string $mbt_change_date = null, ?string $mbt_delete_flag = null, ?string $mbt_key_ext = null, ?string $mbt_chapter_flag = null, ?string $mbt_calendar_flag = null, ?int $mbt_membership_start_month = null, ?int $mbt_membership_start_day = null, ?int $mbt_membership_next_month_after_day = null, ?int $mbt_membership_sell_next_year_after_month = null, ?int $mbt_membership_sell_next_year_after_day = null, ?string $mbt_membership_grace_period = null, ?int $mbt_membership_grace_length = null, ?string $mbt_update_date_when = null, ?int $mbt_percent_paid = null, ?string $mbt_flow_down = null, ?string $mbt_voting_rights = null, ?string $mbt_invoice_type = null, ?string $mbt_flip_customer_member_flag = null, ?string $mbt_set_on_paid_date_flag = null, ?string $mbt_entity_key = null, ?string $mbt_mbs_drop_key = null, ?string $mbt_mbs_approval_key = null, ?string $mbt_mbt_dependency_key = null, ?string $mbt_chp_cst_key = null, ?string $mbt_description = null, ?string $mbt_dyn_key = null, ?string $mbt_wiz_key = null, ?string $mbt_cst_type = null, ?string $mbt_mbt_renewal_key = null, ?string $mbt_first_installment_flag = null, ?string $mbt_online_autopay_enroll = null)
    {
        $this
            ->setMbt_key($mbt_key)
            ->setMbt_code($mbt_code)
            ->setMbt_asn_code($mbt_asn_code)
            ->setMbt_add_user($mbt_add_user)
            ->setMbt_add_date($mbt_add_date)
            ->setMbt_change_user($mbt_change_user)
            ->setMbt_change_date($mbt_change_date)
            ->setMbt_delete_flag($mbt_delete_flag)
            ->setMbt_key_ext($mbt_key_ext)
            ->setMbt_chapter_flag($mbt_chapter_flag)
            ->setMbt_calendar_flag($mbt_calendar_flag)
            ->setMbt_membership_start_month($mbt_membership_start_month)
            ->setMbt_membership_start_day($mbt_membership_start_day)
            ->setMbt_membership_next_month_after_day($mbt_membership_next_month_after_day)
            ->setMbt_membership_sell_next_year_after_month($mbt_membership_sell_next_year_after_month)
            ->setMbt_membership_sell_next_year_after_day($mbt_membership_sell_next_year_after_day)
            ->setMbt_membership_grace_period($mbt_membership_grace_period)
            ->setMbt_membership_grace_length($mbt_membership_grace_length)
            ->setMbt_update_date_when($mbt_update_date_when)
            ->setMbt_percent_paid($mbt_percent_paid)
            ->setMbt_flow_down($mbt_flow_down)
            ->setMbt_voting_rights($mbt_voting_rights)
            ->setMbt_invoice_type($mbt_invoice_type)
            ->setMbt_flip_customer_member_flag($mbt_flip_customer_member_flag)
            ->setMbt_set_on_paid_date_flag($mbt_set_on_paid_date_flag)
            ->setMbt_entity_key($mbt_entity_key)
            ->setMbt_mbs_drop_key($mbt_mbs_drop_key)
            ->setMbt_mbs_approval_key($mbt_mbs_approval_key)
            ->setMbt_mbt_dependency_key($mbt_mbt_dependency_key)
            ->setMbt_chp_cst_key($mbt_chp_cst_key)
            ->setMbt_description($mbt_description)
            ->setMbt_dyn_key($mbt_dyn_key)
            ->setMbt_wiz_key($mbt_wiz_key)
            ->setMbt_cst_type($mbt_cst_type)
            ->setMbt_mbt_renewal_key($mbt_mbt_renewal_key)
            ->setMbt_first_installment_flag($mbt_first_installment_flag)
            ->setMbt_online_autopay_enroll($mbt_online_autopay_enroll);
    }
    /**
     * Get mbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_key(): ?string
    {
        return $this->mbt_key ?? null;
    }
    /**
     * Set mbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_key(?string $mbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_key) && !is_string($mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_key, true), gettype($mbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_key, true)), __LINE__);
        }
        if (is_null($mbt_key) || (is_array($mbt_key) && empty($mbt_key))) {
            unset($this->mbt_key);
        } else {
            $this->mbt_key = $mbt_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_code(): ?string
    {
        return $this->mbt_code ?? null;
    }
    /**
     * Set mbt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_code(?string $mbt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_code) && !is_string($mbt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_code, true), gettype($mbt_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mbt_code) && mb_strlen((string) $mbt_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $mbt_code)), __LINE__);
        }
        if (is_null($mbt_code) || (is_array($mbt_code) && empty($mbt_code))) {
            unset($this->mbt_code);
        } else {
            $this->mbt_code = $mbt_code;
        }
        
        return $this;
    }
    /**
     * Get mbt_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_asn_code(): ?string
    {
        return $this->mbt_asn_code ?? null;
    }
    /**
     * Set mbt_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_asn_code(?string $mbt_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_asn_code) && !is_string($mbt_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_asn_code, true), gettype($mbt_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($mbt_asn_code) && mb_strlen((string) $mbt_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $mbt_asn_code)), __LINE__);
        }
        if (is_null($mbt_asn_code) || (is_array($mbt_asn_code) && empty($mbt_asn_code))) {
            unset($this->mbt_asn_code);
        } else {
            $this->mbt_asn_code = $mbt_asn_code;
        }
        
        return $this;
    }
    /**
     * Get mbt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_add_user(): ?string
    {
        return $this->mbt_add_user ?? null;
    }
    /**
     * Set mbt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_add_user(?string $mbt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_add_user) && !is_string($mbt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_add_user, true), gettype($mbt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mbt_add_user) && mb_strlen((string) $mbt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mbt_add_user)), __LINE__);
        }
        if (is_null($mbt_add_user) || (is_array($mbt_add_user) && empty($mbt_add_user))) {
            unset($this->mbt_add_user);
        } else {
            $this->mbt_add_user = $mbt_add_user;
        }
        
        return $this;
    }
    /**
     * Get mbt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_add_date(): ?string
    {
        return $this->mbt_add_date ?? null;
    }
    /**
     * Set mbt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_add_date(?string $mbt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_add_date) && !is_string($mbt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_add_date, true), gettype($mbt_add_date)), __LINE__);
        }
        if (is_null($mbt_add_date) || (is_array($mbt_add_date) && empty($mbt_add_date))) {
            unset($this->mbt_add_date);
        } else {
            $this->mbt_add_date = $mbt_add_date;
        }
        
        return $this;
    }
    /**
     * Get mbt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_change_user(): ?string
    {
        return $this->mbt_change_user ?? null;
    }
    /**
     * Set mbt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_change_user(?string $mbt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_change_user) && !is_string($mbt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_change_user, true), gettype($mbt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mbt_change_user) && mb_strlen((string) $mbt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mbt_change_user)), __LINE__);
        }
        if (is_null($mbt_change_user) || (is_array($mbt_change_user) && empty($mbt_change_user))) {
            unset($this->mbt_change_user);
        } else {
            $this->mbt_change_user = $mbt_change_user;
        }
        
        return $this;
    }
    /**
     * Get mbt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_change_date(): ?string
    {
        return $this->mbt_change_date ?? null;
    }
    /**
     * Set mbt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_change_date(?string $mbt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_change_date) && !is_string($mbt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_change_date, true), gettype($mbt_change_date)), __LINE__);
        }
        if (is_null($mbt_change_date) || (is_array($mbt_change_date) && empty($mbt_change_date))) {
            unset($this->mbt_change_date);
        } else {
            $this->mbt_change_date = $mbt_change_date;
        }
        
        return $this;
    }
    /**
     * Get mbt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_delete_flag(): ?string
    {
        return $this->mbt_delete_flag ?? null;
    }
    /**
     * Set mbt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_delete_flag(?string $mbt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_delete_flag) && !is_string($mbt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_delete_flag, true), gettype($mbt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_delete_flag) && $mbt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_delete_flag) && $mbt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_delete_flag, true)), __LINE__);
        }
        if (is_null($mbt_delete_flag) || (is_array($mbt_delete_flag) && empty($mbt_delete_flag))) {
            unset($this->mbt_delete_flag);
        } else {
            $this->mbt_delete_flag = $mbt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_key_ext(): ?string
    {
        return $this->mbt_key_ext ?? null;
    }
    /**
     * Set mbt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_key_ext(?string $mbt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_key_ext) && !is_string($mbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_key_ext, true), gettype($mbt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_key_ext, true)), __LINE__);
        }
        if (is_null($mbt_key_ext) || (is_array($mbt_key_ext) && empty($mbt_key_ext))) {
            unset($this->mbt_key_ext);
        } else {
            $this->mbt_key_ext = $mbt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get mbt_chapter_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_chapter_flag(): ?string
    {
        return $this->mbt_chapter_flag ?? null;
    }
    /**
     * Set mbt_chapter_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_chapter_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_chapter_flag(?string $mbt_chapter_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_chapter_flag) && !is_string($mbt_chapter_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_chapter_flag, true), gettype($mbt_chapter_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_chapter_flag) && $mbt_chapter_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_chapter_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_chapter_flag) && $mbt_chapter_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_chapter_flag, true)), __LINE__);
        }
        if (is_null($mbt_chapter_flag) || (is_array($mbt_chapter_flag) && empty($mbt_chapter_flag))) {
            unset($this->mbt_chapter_flag);
        } else {
            $this->mbt_chapter_flag = $mbt_chapter_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_calendar_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_calendar_flag(): ?string
    {
        return $this->mbt_calendar_flag ?? null;
    }
    /**
     * Set mbt_calendar_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_calendar_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_calendar_flag(?string $mbt_calendar_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_calendar_flag) && !is_string($mbt_calendar_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_calendar_flag, true), gettype($mbt_calendar_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_calendar_flag) && $mbt_calendar_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_calendar_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_calendar_flag) && $mbt_calendar_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_calendar_flag, true)), __LINE__);
        }
        if (is_null($mbt_calendar_flag) || (is_array($mbt_calendar_flag) && empty($mbt_calendar_flag))) {
            unset($this->mbt_calendar_flag);
        } else {
            $this->mbt_calendar_flag = $mbt_calendar_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_start_month value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_start_month(): ?int
    {
        return $this->mbt_membership_start_month ?? null;
    }
    /**
     * Set mbt_membership_start_month value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_start_month
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_start_month(?int $mbt_membership_start_month = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_start_month) && !(is_int($mbt_membership_start_month) || ctype_digit($mbt_membership_start_month))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_start_month, true), gettype($mbt_membership_start_month)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_start_month) && $mbt_membership_start_month > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_start_month, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_start_month) && $mbt_membership_start_month < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_start_month, true)), __LINE__);
        }
        if (is_null($mbt_membership_start_month) || (is_array($mbt_membership_start_month) && empty($mbt_membership_start_month))) {
            unset($this->mbt_membership_start_month);
        } else {
            $this->mbt_membership_start_month = $mbt_membership_start_month;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_start_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_start_day(): ?int
    {
        return $this->mbt_membership_start_day ?? null;
    }
    /**
     * Set mbt_membership_start_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_start_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_start_day(?int $mbt_membership_start_day = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_start_day) && !(is_int($mbt_membership_start_day) || ctype_digit($mbt_membership_start_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_start_day, true), gettype($mbt_membership_start_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_start_day) && $mbt_membership_start_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_start_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_start_day) && $mbt_membership_start_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_start_day, true)), __LINE__);
        }
        if (is_null($mbt_membership_start_day) || (is_array($mbt_membership_start_day) && empty($mbt_membership_start_day))) {
            unset($this->mbt_membership_start_day);
        } else {
            $this->mbt_membership_start_day = $mbt_membership_start_day;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_next_month_after_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_next_month_after_day(): ?int
    {
        return $this->mbt_membership_next_month_after_day ?? null;
    }
    /**
     * Set mbt_membership_next_month_after_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_next_month_after_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_next_month_after_day(?int $mbt_membership_next_month_after_day = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_next_month_after_day) && !(is_int($mbt_membership_next_month_after_day) || ctype_digit($mbt_membership_next_month_after_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_next_month_after_day, true), gettype($mbt_membership_next_month_after_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_next_month_after_day) && $mbt_membership_next_month_after_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_next_month_after_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_next_month_after_day) && $mbt_membership_next_month_after_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_next_month_after_day, true)), __LINE__);
        }
        if (is_null($mbt_membership_next_month_after_day) || (is_array($mbt_membership_next_month_after_day) && empty($mbt_membership_next_month_after_day))) {
            unset($this->mbt_membership_next_month_after_day);
        } else {
            $this->mbt_membership_next_month_after_day = $mbt_membership_next_month_after_day;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_sell_next_year_after_month value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_sell_next_year_after_month(): ?int
    {
        return $this->mbt_membership_sell_next_year_after_month ?? null;
    }
    /**
     * Set mbt_membership_sell_next_year_after_month value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_sell_next_year_after_month
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_sell_next_year_after_month(?int $mbt_membership_sell_next_year_after_month = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_sell_next_year_after_month) && !(is_int($mbt_membership_sell_next_year_after_month) || ctype_digit($mbt_membership_sell_next_year_after_month))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_sell_next_year_after_month, true), gettype($mbt_membership_sell_next_year_after_month)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_sell_next_year_after_month) && $mbt_membership_sell_next_year_after_month > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_sell_next_year_after_month, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_sell_next_year_after_month) && $mbt_membership_sell_next_year_after_month < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_sell_next_year_after_month, true)), __LINE__);
        }
        if (is_null($mbt_membership_sell_next_year_after_month) || (is_array($mbt_membership_sell_next_year_after_month) && empty($mbt_membership_sell_next_year_after_month))) {
            unset($this->mbt_membership_sell_next_year_after_month);
        } else {
            $this->mbt_membership_sell_next_year_after_month = $mbt_membership_sell_next_year_after_month;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_sell_next_year_after_day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_sell_next_year_after_day(): ?int
    {
        return $this->mbt_membership_sell_next_year_after_day ?? null;
    }
    /**
     * Set mbt_membership_sell_next_year_after_day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_sell_next_year_after_day
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_sell_next_year_after_day(?int $mbt_membership_sell_next_year_after_day = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_sell_next_year_after_day) && !(is_int($mbt_membership_sell_next_year_after_day) || ctype_digit($mbt_membership_sell_next_year_after_day))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_sell_next_year_after_day, true), gettype($mbt_membership_sell_next_year_after_day)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_sell_next_year_after_day) && $mbt_membership_sell_next_year_after_day > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_sell_next_year_after_day, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_sell_next_year_after_day) && $mbt_membership_sell_next_year_after_day < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_sell_next_year_after_day, true)), __LINE__);
        }
        if (is_null($mbt_membership_sell_next_year_after_day) || (is_array($mbt_membership_sell_next_year_after_day) && empty($mbt_membership_sell_next_year_after_day))) {
            unset($this->mbt_membership_sell_next_year_after_day);
        } else {
            $this->mbt_membership_sell_next_year_after_day = $mbt_membership_sell_next_year_after_day;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_grace_period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_membership_grace_period(): ?string
    {
        return $this->mbt_membership_grace_period ?? null;
    }
    /**
     * Set mbt_membership_grace_period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_membership_grace_period
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_grace_period(?string $mbt_membership_grace_period = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_membership_grace_period) && !is_string($mbt_membership_grace_period)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_membership_grace_period, true), gettype($mbt_membership_grace_period)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($mbt_membership_grace_period) && mb_strlen((string) $mbt_membership_grace_period) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $mbt_membership_grace_period)), __LINE__);
        }
        if (is_null($mbt_membership_grace_period) || (is_array($mbt_membership_grace_period) && empty($mbt_membership_grace_period))) {
            unset($this->mbt_membership_grace_period);
        } else {
            $this->mbt_membership_grace_period = $mbt_membership_grace_period;
        }
        
        return $this;
    }
    /**
     * Get mbt_membership_grace_length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_membership_grace_length(): ?int
    {
        return $this->mbt_membership_grace_length ?? null;
    }
    /**
     * Set mbt_membership_grace_length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_membership_grace_length
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_membership_grace_length(?int $mbt_membership_grace_length = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_membership_grace_length) && !(is_int($mbt_membership_grace_length) || ctype_digit($mbt_membership_grace_length))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_membership_grace_length, true), gettype($mbt_membership_grace_length)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_membership_grace_length) && $mbt_membership_grace_length > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_membership_grace_length, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_membership_grace_length) && $mbt_membership_grace_length < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_membership_grace_length, true)), __LINE__);
        }
        if (is_null($mbt_membership_grace_length) || (is_array($mbt_membership_grace_length) && empty($mbt_membership_grace_length))) {
            unset($this->mbt_membership_grace_length);
        } else {
            $this->mbt_membership_grace_length = $mbt_membership_grace_length;
        }
        
        return $this;
    }
    /**
     * Get mbt_update_date_when value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_update_date_when(): ?string
    {
        return $this->mbt_update_date_when ?? null;
    }
    /**
     * Set mbt_update_date_when value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_update_date_when
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_update_date_when(?string $mbt_update_date_when = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_update_date_when) && !is_string($mbt_update_date_when)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_update_date_when, true), gettype($mbt_update_date_when)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($mbt_update_date_when) && mb_strlen((string) $mbt_update_date_when) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $mbt_update_date_when)), __LINE__);
        }
        if (is_null($mbt_update_date_when) || (is_array($mbt_update_date_when) && empty($mbt_update_date_when))) {
            unset($this->mbt_update_date_when);
        } else {
            $this->mbt_update_date_when = $mbt_update_date_when;
        }
        
        return $this;
    }
    /**
     * Get mbt_percent_paid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbt_percent_paid(): ?int
    {
        return $this->mbt_percent_paid ?? null;
    }
    /**
     * Set mbt_percent_paid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbt_percent_paid
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_percent_paid(?int $mbt_percent_paid = null): self
    {
        // validation for constraint: int
        if (!is_null($mbt_percent_paid) && !(is_int($mbt_percent_paid) || ctype_digit($mbt_percent_paid))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbt_percent_paid, true), gettype($mbt_percent_paid)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbt_percent_paid) && $mbt_percent_paid > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbt_percent_paid, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbt_percent_paid) && $mbt_percent_paid < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbt_percent_paid, true)), __LINE__);
        }
        if (is_null($mbt_percent_paid) || (is_array($mbt_percent_paid) && empty($mbt_percent_paid))) {
            unset($this->mbt_percent_paid);
        } else {
            $this->mbt_percent_paid = $mbt_percent_paid;
        }
        
        return $this;
    }
    /**
     * Get mbt_flow_down value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_flow_down(): ?string
    {
        return $this->mbt_flow_down ?? null;
    }
    /**
     * Set mbt_flow_down value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_flow_down
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_flow_down(?string $mbt_flow_down = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_flow_down) && !is_string($mbt_flow_down)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_flow_down, true), gettype($mbt_flow_down)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_flow_down) && $mbt_flow_down > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_flow_down, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_flow_down) && $mbt_flow_down < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_flow_down, true)), __LINE__);
        }
        if (is_null($mbt_flow_down) || (is_array($mbt_flow_down) && empty($mbt_flow_down))) {
            unset($this->mbt_flow_down);
        } else {
            $this->mbt_flow_down = $mbt_flow_down;
        }
        
        return $this;
    }
    /**
     * Get mbt_voting_rights value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_voting_rights(): ?string
    {
        return $this->mbt_voting_rights ?? null;
    }
    /**
     * Set mbt_voting_rights value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_voting_rights
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_voting_rights(?string $mbt_voting_rights = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_voting_rights) && !is_string($mbt_voting_rights)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_voting_rights, true), gettype($mbt_voting_rights)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_voting_rights) && $mbt_voting_rights > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_voting_rights, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_voting_rights) && $mbt_voting_rights < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_voting_rights, true)), __LINE__);
        }
        if (is_null($mbt_voting_rights) || (is_array($mbt_voting_rights) && empty($mbt_voting_rights))) {
            unset($this->mbt_voting_rights);
        } else {
            $this->mbt_voting_rights = $mbt_voting_rights;
        }
        
        return $this;
    }
    /**
     * Get mbt_invoice_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_invoice_type(): ?string
    {
        return $this->mbt_invoice_type ?? null;
    }
    /**
     * Set mbt_invoice_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_invoice_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_invoice_type(?string $mbt_invoice_type = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_invoice_type) && !is_string($mbt_invoice_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_invoice_type, true), gettype($mbt_invoice_type)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($mbt_invoice_type) && mb_strlen((string) $mbt_invoice_type) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $mbt_invoice_type)), __LINE__);
        }
        if (is_null($mbt_invoice_type) || (is_array($mbt_invoice_type) && empty($mbt_invoice_type))) {
            unset($this->mbt_invoice_type);
        } else {
            $this->mbt_invoice_type = $mbt_invoice_type;
        }
        
        return $this;
    }
    /**
     * Get mbt_flip_customer_member_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_flip_customer_member_flag(): ?string
    {
        return $this->mbt_flip_customer_member_flag ?? null;
    }
    /**
     * Set mbt_flip_customer_member_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_flip_customer_member_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_flip_customer_member_flag(?string $mbt_flip_customer_member_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_flip_customer_member_flag) && !is_string($mbt_flip_customer_member_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_flip_customer_member_flag, true), gettype($mbt_flip_customer_member_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_flip_customer_member_flag) && $mbt_flip_customer_member_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_flip_customer_member_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_flip_customer_member_flag) && $mbt_flip_customer_member_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_flip_customer_member_flag, true)), __LINE__);
        }
        if (is_null($mbt_flip_customer_member_flag) || (is_array($mbt_flip_customer_member_flag) && empty($mbt_flip_customer_member_flag))) {
            unset($this->mbt_flip_customer_member_flag);
        } else {
            $this->mbt_flip_customer_member_flag = $mbt_flip_customer_member_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_set_on_paid_date_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_set_on_paid_date_flag(): ?string
    {
        return $this->mbt_set_on_paid_date_flag ?? null;
    }
    /**
     * Set mbt_set_on_paid_date_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_set_on_paid_date_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_set_on_paid_date_flag(?string $mbt_set_on_paid_date_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_set_on_paid_date_flag) && !is_string($mbt_set_on_paid_date_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_set_on_paid_date_flag, true), gettype($mbt_set_on_paid_date_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_set_on_paid_date_flag) && $mbt_set_on_paid_date_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_set_on_paid_date_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_set_on_paid_date_flag) && $mbt_set_on_paid_date_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_set_on_paid_date_flag, true)), __LINE__);
        }
        if (is_null($mbt_set_on_paid_date_flag) || (is_array($mbt_set_on_paid_date_flag) && empty($mbt_set_on_paid_date_flag))) {
            unset($this->mbt_set_on_paid_date_flag);
        } else {
            $this->mbt_set_on_paid_date_flag = $mbt_set_on_paid_date_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_entity_key(): ?string
    {
        return $this->mbt_entity_key ?? null;
    }
    /**
     * Set mbt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_entity_key(?string $mbt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_entity_key) && !is_string($mbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_entity_key, true), gettype($mbt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_entity_key, true)), __LINE__);
        }
        if (is_null($mbt_entity_key) || (is_array($mbt_entity_key) && empty($mbt_entity_key))) {
            unset($this->mbt_entity_key);
        } else {
            $this->mbt_entity_key = $mbt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_mbs_drop_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_mbs_drop_key(): ?string
    {
        return $this->mbt_mbs_drop_key ?? null;
    }
    /**
     * Set mbt_mbs_drop_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_mbs_drop_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_mbs_drop_key(?string $mbt_mbs_drop_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_mbs_drop_key) && !is_string($mbt_mbs_drop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_mbs_drop_key, true), gettype($mbt_mbs_drop_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_mbs_drop_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_mbs_drop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_mbs_drop_key, true)), __LINE__);
        }
        if (is_null($mbt_mbs_drop_key) || (is_array($mbt_mbs_drop_key) && empty($mbt_mbs_drop_key))) {
            unset($this->mbt_mbs_drop_key);
        } else {
            $this->mbt_mbs_drop_key = $mbt_mbs_drop_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_mbs_approval_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_mbs_approval_key(): ?string
    {
        return $this->mbt_mbs_approval_key ?? null;
    }
    /**
     * Set mbt_mbs_approval_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_mbs_approval_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_mbs_approval_key(?string $mbt_mbs_approval_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_mbs_approval_key) && !is_string($mbt_mbs_approval_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_mbs_approval_key, true), gettype($mbt_mbs_approval_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_mbs_approval_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_mbs_approval_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_mbs_approval_key, true)), __LINE__);
        }
        if (is_null($mbt_mbs_approval_key) || (is_array($mbt_mbs_approval_key) && empty($mbt_mbs_approval_key))) {
            unset($this->mbt_mbs_approval_key);
        } else {
            $this->mbt_mbs_approval_key = $mbt_mbs_approval_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_mbt_dependency_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_mbt_dependency_key(): ?string
    {
        return $this->mbt_mbt_dependency_key ?? null;
    }
    /**
     * Set mbt_mbt_dependency_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_mbt_dependency_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_mbt_dependency_key(?string $mbt_mbt_dependency_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_mbt_dependency_key) && !is_string($mbt_mbt_dependency_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_mbt_dependency_key, true), gettype($mbt_mbt_dependency_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_mbt_dependency_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_mbt_dependency_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_mbt_dependency_key, true)), __LINE__);
        }
        if (is_null($mbt_mbt_dependency_key) || (is_array($mbt_mbt_dependency_key) && empty($mbt_mbt_dependency_key))) {
            unset($this->mbt_mbt_dependency_key);
        } else {
            $this->mbt_mbt_dependency_key = $mbt_mbt_dependency_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_chp_cst_key(): ?string
    {
        return $this->mbt_chp_cst_key ?? null;
    }
    /**
     * Set mbt_chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_chp_cst_key(?string $mbt_chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_chp_cst_key) && !is_string($mbt_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_chp_cst_key, true), gettype($mbt_chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_chp_cst_key, true)), __LINE__);
        }
        if (is_null($mbt_chp_cst_key) || (is_array($mbt_chp_cst_key) && empty($mbt_chp_cst_key))) {
            unset($this->mbt_chp_cst_key);
        } else {
            $this->mbt_chp_cst_key = $mbt_chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_description(): ?string
    {
        return $this->mbt_description ?? null;
    }
    /**
     * Set mbt_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_description(?string $mbt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_description) && !is_string($mbt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_description, true), gettype($mbt_description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mbt_description) && mb_strlen((string) $mbt_description) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $mbt_description)), __LINE__);
        }
        if (is_null($mbt_description) || (is_array($mbt_description) && empty($mbt_description))) {
            unset($this->mbt_description);
        } else {
            $this->mbt_description = $mbt_description;
        }
        
        return $this;
    }
    /**
     * Get mbt_dyn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_dyn_key(): ?string
    {
        return $this->mbt_dyn_key ?? null;
    }
    /**
     * Set mbt_dyn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_dyn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_dyn_key(?string $mbt_dyn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_dyn_key) && !is_string($mbt_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_dyn_key, true), gettype($mbt_dyn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_dyn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_dyn_key, true)), __LINE__);
        }
        if (is_null($mbt_dyn_key) || (is_array($mbt_dyn_key) && empty($mbt_dyn_key))) {
            unset($this->mbt_dyn_key);
        } else {
            $this->mbt_dyn_key = $mbt_dyn_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_wiz_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_wiz_key(): ?string
    {
        return $this->mbt_wiz_key ?? null;
    }
    /**
     * Set mbt_wiz_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_wiz_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_wiz_key(?string $mbt_wiz_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_wiz_key) && !is_string($mbt_wiz_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_wiz_key, true), gettype($mbt_wiz_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbt_wiz_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbt_wiz_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbt_wiz_key, true)), __LINE__);
        }
        if (is_null($mbt_wiz_key) || (is_array($mbt_wiz_key) && empty($mbt_wiz_key))) {
            unset($this->mbt_wiz_key);
        } else {
            $this->mbt_wiz_key = $mbt_wiz_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_cst_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_cst_type(): ?string
    {
        return $this->mbt_cst_type ?? null;
    }
    /**
     * Set mbt_cst_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_cst_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_cst_type(?string $mbt_cst_type = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_cst_type) && !is_string($mbt_cst_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_cst_type, true), gettype($mbt_cst_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($mbt_cst_type) && mb_strlen((string) $mbt_cst_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $mbt_cst_type)), __LINE__);
        }
        if (is_null($mbt_cst_type) || (is_array($mbt_cst_type) && empty($mbt_cst_type))) {
            unset($this->mbt_cst_type);
        } else {
            $this->mbt_cst_type = $mbt_cst_type;
        }
        
        return $this;
    }
    /**
     * Get mbt_mbt_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_mbt_renewal_key(): ?string
    {
        return $this->mbt_mbt_renewal_key ?? null;
    }
    /**
     * Set mbt_mbt_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_mbt_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_mbt_renewal_key(?string $mbt_mbt_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_mbt_renewal_key) && !is_string($mbt_mbt_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_mbt_renewal_key, true), gettype($mbt_mbt_renewal_key)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_mbt_renewal_key) && $mbt_mbt_renewal_key > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_mbt_renewal_key, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_mbt_renewal_key) && $mbt_mbt_renewal_key < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_mbt_renewal_key, true)), __LINE__);
        }
        if (is_null($mbt_mbt_renewal_key) || (is_array($mbt_mbt_renewal_key) && empty($mbt_mbt_renewal_key))) {
            unset($this->mbt_mbt_renewal_key);
        } else {
            $this->mbt_mbt_renewal_key = $mbt_mbt_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get mbt_first_installment_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_first_installment_flag(): ?string
    {
        return $this->mbt_first_installment_flag ?? null;
    }
    /**
     * Set mbt_first_installment_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_first_installment_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_first_installment_flag(?string $mbt_first_installment_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_first_installment_flag) && !is_string($mbt_first_installment_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_first_installment_flag, true), gettype($mbt_first_installment_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_first_installment_flag) && $mbt_first_installment_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_first_installment_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_first_installment_flag) && $mbt_first_installment_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_first_installment_flag, true)), __LINE__);
        }
        if (is_null($mbt_first_installment_flag) || (is_array($mbt_first_installment_flag) && empty($mbt_first_installment_flag))) {
            unset($this->mbt_first_installment_flag);
        } else {
            $this->mbt_first_installment_flag = $mbt_first_installment_flag;
        }
        
        return $this;
    }
    /**
     * Get mbt_online_autopay_enroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbt_online_autopay_enroll(): ?string
    {
        return $this->mbt_online_autopay_enroll ?? null;
    }
    /**
     * Set mbt_online_autopay_enroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbt_online_autopay_enroll
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Member_Type_DataObjectType
     */
    public function setMbt_online_autopay_enroll(?string $mbt_online_autopay_enroll = null): self
    {
        // validation for constraint: string
        if (!is_null($mbt_online_autopay_enroll) && !is_string($mbt_online_autopay_enroll)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbt_online_autopay_enroll, true), gettype($mbt_online_autopay_enroll)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbt_online_autopay_enroll) && $mbt_online_autopay_enroll > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbt_online_autopay_enroll, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbt_online_autopay_enroll) && $mbt_online_autopay_enroll < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbt_online_autopay_enroll, true)), __LINE__);
        }
        if (is_null($mbt_online_autopay_enroll) || (is_array($mbt_online_autopay_enroll) && empty($mbt_online_autopay_enroll))) {
            unset($this->mbt_online_autopay_enroll);
        } else {
            $this->mbt_online_autopay_enroll = $mbt_online_autopay_enroll;
        }
        
        return $this;
    }
}
