<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Membership_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Membership_DataObjectType extends AbstractStructBase
{
    /**
     * The mbr_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_src_key = null;
    /**
     * The mbr_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_src_code = null;
    /**
     * The mbr_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_asn_code = null;
    /**
     * The mbr_join_date
     * Meta information extracted from the WSDL
     * - documentation: Join Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_join_date = null;
    /**
     * The mbr_renew_date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_renew_date = null;
    /**
     * The mbr_expire_date
     * Meta information extracted from the WSDL
     * - documentation: Expire Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_expire_date = null;
    /**
     * The mbr_terminate_date
     * Meta information extracted from the WSDL
     * - documentation: Termination Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_terminate_date = null;
    /**
     * The mbr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_add_date = null;
    /**
     * The mbr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_add_user = null;
    /**
     * The mbr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_change_user = null;
    /**
     * The mbr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_change_date = null;
    /**
     * The mbr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_delete_flag = null;
    /**
     * The mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_key = null;
    /**
     * The mbr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_key_ext = null;
    /**
     * The mbr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Member Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_cst_key = null;
    /**
     * The mbr_opt_out
     * Meta information extracted from the WSDL
     * - documentation: Opt Out Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_opt_out = null;
    /**
     * The mbr_mbt_key
     * Meta information extracted from the WSDL
     * - documentation: Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mbt_key = null;
    /**
     * The mbr_mbs_key
     * Meta information extracted from the WSDL
     * - documentation: Member Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mbs_key = null;
    /**
     * The mbr_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Member Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_pak_prd_key = null;
    /**
     * The mbr_ind_cst_key_referral
     * Meta information extracted from the WSDL
     * - documentation: Referral. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_ind_cst_key_referral = null;
    /**
     * The mbr_pak_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_pak_prd_renewal_key = null;
    /**
     * The mbr_do_not_renew_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Renew. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_do_not_renew_flag = null;
    /**
     * The mbr_invoice_date
     * Meta information extracted from the WSDL
     * - documentation: Date of Last Invoice. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_invoice_date = null;
    /**
     * The mbr_rejoin_date
     * Meta information extracted from the WSDL
     * - documentation: Rejoin Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_rejoin_date = null;
    /**
     * The mbr_popup
     * Meta information extracted from the WSDL
     * - documentation: Popup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_popup = null;
    /**
     * The mbr_voting_rights
     * Meta information extracted from the WSDL
     * - documentation: Voting Rights. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_voting_rights = null;
    /**
     * The mbr_chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_chp_cst_key = null;
    /**
     * The mbr_converted_flag
     * Meta information extracted from the WSDL
     * - documentation: Converted Record?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_converted_flag = null;
    /**
     * The mbr_approval_flag
     * Meta information extracted from the WSDL
     * - documentation: Membership Approved. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_approval_flag = null;
    /**
     * The mbr_installment_frequency
     * Meta information extracted from the WSDL
     * - documentation: frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbr_installment_frequency = null;
    /**
     * The mbr_approval_date
     * Meta information extracted from the WSDL
     * - documentation: Approval Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_approval_date = null;
    /**
     * The mbr_ord_key
     * Meta information extracted from the WSDL
     * - documentation: Order. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_ord_key = null;
    /**
     * The mbr_mtr_key
     * Meta information extracted from the WSDL
     * - documentation: Terminate Reason Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mtr_key = null;
    /**
     * The mbr_terminate_reason
     * Meta information extracted from the WSDL
     * - documentation: Termination Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_terminate_reason = null;
    /**
     * The mbr_installment_frequency_for_renewal
     * Meta information extracted from the WSDL
     * - documentation: installment frequency for renewal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbr_installment_frequency_for_renewal = null;
    /**
     * The mbr_num_of_installments_for_renewal
     * Meta information extracted from the WSDL
     * - documentation: num of installments for renewal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $mbr_num_of_installments_for_renewal = null;
    /**
     * The mbr_ord_ait_key_renewal
     * Meta information extracted from the WSDL
     * - documentation: renewal terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_ord_ait_key_renewal = null;
    /**
     * The mbr_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: Association Membership Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mbr_key = null;
    /**
     * The mbr_proforma_renewal
     * Meta information extracted from the WSDL
     * - documentation: renew by proforma. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_proforma_renewal = null;
    /**
     * The mbr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_entity_key = null;
    /**
     * The mbr_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_ord_code = null;
    /**
     * The mbr_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_odd_key = null;
    /**
     * The mbr_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_bun_prd_key = null;
    /**
     * The mbr_bun_prd_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Bundle Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_bun_prd_renewal_key = null;
    /**
     * The mbr_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Dues Rate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_prc_key = null;
    /**
     * The mbr_bup_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle Component. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_bup_key = null;
    /**
     * The mbr_mbt_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Member Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mbt_renewal_key = null;
    /**
     * The mbr_chp_cst_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Chapter. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_chp_cst_renewal_key = null;
    /**
     * The mbr_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_cpi_key = null;
    /**
     * The mbr_auto_pay
     * Meta information extracted from the WSDL
     * - documentation: auto-pay membership. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_auto_pay = null;
    /**
     * The mbr_installment_payments_flag
     * Meta information extracted from the WSDL
     * - documentation: Installment Payments?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_installment_payments_flag = null;
    /**
     * The mbr_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_gft_key = null;
    /**
     * The mbr_cpi_consent_date
     * Meta information extracted from the WSDL
     * - documentation: Date cardholder consented to store their payment info for installment/recurring/renewal payments.. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_cpi_consent_date = null;
    /**
     * The mbr_allowed_action
     * Meta information extracted from the WSDL
     * - documentation: Allowed Action. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_allowed_action = null;
    /**
     * The mbr_rejoin_flag
     * Meta information extracted from the WSDL
     * - documentation: Renew.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_rejoin_flag = null;
    /**
     * The mbr_renew_related
     * Meta information extracted from the WSDL
     * - documentation: Renew.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_renew_related = null;
    /**
     * The mbr_apply_credits_flag
     * Meta information extracted from the WSDL
     * - documentation: Apply Credits.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_apply_credits_flag = null;
    /**
     * The mbr_bup_prd_key
     * Meta information extracted from the WSDL
     * - documentation: bundle component product key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_bup_prd_key = null;
    /**
     * The mbr_addl_info
     * Meta information extracted from the WSDL
     * - documentation: Addl info. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $mbr_addl_info = null;
    /**
     * The mbr_available_credit
     * Meta information extracted from the WSDL
     * - documentation: Credits Available.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $mbr_available_credit = null;
    /**
     * The mbr_mbt_key_new
     * Meta information extracted from the WSDL
     * - documentation: new member type key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $mbr_mbt_key_new = null;
    /**
     * The mbr_total
     * Meta information extracted from the WSDL
     * - documentation: Total.This element has a default value of '0'. This field has this Input Mask: $999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $mbr_total = null;
    /**
     * Constructor method for mb_membership_Membership_DataObjectType
     * @uses Mb_membership_Membership_DataObjectType::setMbr_src_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_src_code()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_asn_code()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_join_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_renew_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_expire_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_terminate_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_add_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_add_user()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_change_user()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_change_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_delete_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_key_ext()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_cst_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_opt_out()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mbt_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mbs_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_pak_prd_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_ind_cst_key_referral()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_pak_prd_renewal_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_do_not_renew_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_invoice_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_rejoin_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_popup()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_voting_rights()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_chp_cst_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_converted_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_approval_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_installment_frequency()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_approval_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_ord_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mtr_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_terminate_reason()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_installment_frequency_for_renewal()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_num_of_installments_for_renewal()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_ord_ait_key_renewal()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mbr_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_proforma_renewal()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_entity_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_ord_code()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_odd_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_bun_prd_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_bun_prd_renewal_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_prc_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_bup_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mbt_renewal_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_chp_cst_renewal_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_cpi_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_auto_pay()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_installment_payments_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_gft_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_cpi_consent_date()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_allowed_action()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_rejoin_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_renew_related()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_apply_credits_flag()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_bup_prd_key()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_addl_info()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_available_credit()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_mbt_key_new()
     * @uses Mb_membership_Membership_DataObjectType::setMbr_total()
     * @param string $mbr_src_key
     * @param string $mbr_src_code
     * @param string $mbr_asn_code
     * @param string $mbr_join_date
     * @param string $mbr_renew_date
     * @param string $mbr_expire_date
     * @param string $mbr_terminate_date
     * @param string $mbr_add_date
     * @param string $mbr_add_user
     * @param string $mbr_change_user
     * @param string $mbr_change_date
     * @param string $mbr_delete_flag
     * @param string $mbr_key
     * @param string $mbr_key_ext
     * @param string $mbr_cst_key
     * @param string $mbr_opt_out
     * @param string $mbr_mbt_key
     * @param string $mbr_mbs_key
     * @param string $mbr_pak_prd_key
     * @param string $mbr_ind_cst_key_referral
     * @param string $mbr_pak_prd_renewal_key
     * @param string $mbr_do_not_renew_flag
     * @param string $mbr_invoice_date
     * @param string $mbr_rejoin_date
     * @param string $mbr_popup
     * @param string $mbr_voting_rights
     * @param string $mbr_chp_cst_key
     * @param string $mbr_converted_flag
     * @param string $mbr_approval_flag
     * @param int $mbr_installment_frequency
     * @param string $mbr_approval_date
     * @param string $mbr_ord_key
     * @param string $mbr_mtr_key
     * @param string $mbr_terminate_reason
     * @param int $mbr_installment_frequency_for_renewal
     * @param int $mbr_num_of_installments_for_renewal
     * @param string $mbr_ord_ait_key_renewal
     * @param string $mbr_mbr_key
     * @param string $mbr_proforma_renewal
     * @param string $mbr_entity_key
     * @param string $mbr_ord_code
     * @param string $mbr_odd_key
     * @param string $mbr_bun_prd_key
     * @param string $mbr_bun_prd_renewal_key
     * @param string $mbr_prc_key
     * @param string $mbr_bup_key
     * @param string $mbr_mbt_renewal_key
     * @param string $mbr_chp_cst_renewal_key
     * @param string $mbr_cpi_key
     * @param string $mbr_auto_pay
     * @param string $mbr_installment_payments_flag
     * @param string $mbr_gft_key
     * @param string $mbr_cpi_consent_date
     * @param string $mbr_allowed_action
     * @param string $mbr_rejoin_flag
     * @param string $mbr_renew_related
     * @param string $mbr_apply_credits_flag
     * @param string $mbr_bup_prd_key
     * @param string $mbr_addl_info
     * @param float $mbr_available_credit
     * @param string $mbr_mbt_key_new
     * @param float $mbr_total
     */
    public function __construct(?string $mbr_src_key = null, ?string $mbr_src_code = null, ?string $mbr_asn_code = null, ?string $mbr_join_date = null, ?string $mbr_renew_date = null, ?string $mbr_expire_date = null, ?string $mbr_terminate_date = null, ?string $mbr_add_date = null, ?string $mbr_add_user = null, ?string $mbr_change_user = null, ?string $mbr_change_date = null, ?string $mbr_delete_flag = null, ?string $mbr_key = null, ?string $mbr_key_ext = null, ?string $mbr_cst_key = null, ?string $mbr_opt_out = null, ?string $mbr_mbt_key = null, ?string $mbr_mbs_key = null, ?string $mbr_pak_prd_key = null, ?string $mbr_ind_cst_key_referral = null, ?string $mbr_pak_prd_renewal_key = null, ?string $mbr_do_not_renew_flag = null, ?string $mbr_invoice_date = null, ?string $mbr_rejoin_date = null, ?string $mbr_popup = null, ?string $mbr_voting_rights = null, ?string $mbr_chp_cst_key = null, ?string $mbr_converted_flag = null, ?string $mbr_approval_flag = null, ?int $mbr_installment_frequency = null, ?string $mbr_approval_date = null, ?string $mbr_ord_key = null, ?string $mbr_mtr_key = null, ?string $mbr_terminate_reason = null, ?int $mbr_installment_frequency_for_renewal = null, ?int $mbr_num_of_installments_for_renewal = null, ?string $mbr_ord_ait_key_renewal = null, ?string $mbr_mbr_key = null, ?string $mbr_proforma_renewal = null, ?string $mbr_entity_key = null, ?string $mbr_ord_code = null, ?string $mbr_odd_key = null, ?string $mbr_bun_prd_key = null, ?string $mbr_bun_prd_renewal_key = null, ?string $mbr_prc_key = null, ?string $mbr_bup_key = null, ?string $mbr_mbt_renewal_key = null, ?string $mbr_chp_cst_renewal_key = null, ?string $mbr_cpi_key = null, ?string $mbr_auto_pay = null, ?string $mbr_installment_payments_flag = null, ?string $mbr_gft_key = null, ?string $mbr_cpi_consent_date = null, ?string $mbr_allowed_action = null, ?string $mbr_rejoin_flag = null, ?string $mbr_renew_related = null, ?string $mbr_apply_credits_flag = null, ?string $mbr_bup_prd_key = null, ?string $mbr_addl_info = null, ?float $mbr_available_credit = null, ?string $mbr_mbt_key_new = null, ?float $mbr_total = null)
    {
        $this
            ->setMbr_src_key($mbr_src_key)
            ->setMbr_src_code($mbr_src_code)
            ->setMbr_asn_code($mbr_asn_code)
            ->setMbr_join_date($mbr_join_date)
            ->setMbr_renew_date($mbr_renew_date)
            ->setMbr_expire_date($mbr_expire_date)
            ->setMbr_terminate_date($mbr_terminate_date)
            ->setMbr_add_date($mbr_add_date)
            ->setMbr_add_user($mbr_add_user)
            ->setMbr_change_user($mbr_change_user)
            ->setMbr_change_date($mbr_change_date)
            ->setMbr_delete_flag($mbr_delete_flag)
            ->setMbr_key($mbr_key)
            ->setMbr_key_ext($mbr_key_ext)
            ->setMbr_cst_key($mbr_cst_key)
            ->setMbr_opt_out($mbr_opt_out)
            ->setMbr_mbt_key($mbr_mbt_key)
            ->setMbr_mbs_key($mbr_mbs_key)
            ->setMbr_pak_prd_key($mbr_pak_prd_key)
            ->setMbr_ind_cst_key_referral($mbr_ind_cst_key_referral)
            ->setMbr_pak_prd_renewal_key($mbr_pak_prd_renewal_key)
            ->setMbr_do_not_renew_flag($mbr_do_not_renew_flag)
            ->setMbr_invoice_date($mbr_invoice_date)
            ->setMbr_rejoin_date($mbr_rejoin_date)
            ->setMbr_popup($mbr_popup)
            ->setMbr_voting_rights($mbr_voting_rights)
            ->setMbr_chp_cst_key($mbr_chp_cst_key)
            ->setMbr_converted_flag($mbr_converted_flag)
            ->setMbr_approval_flag($mbr_approval_flag)
            ->setMbr_installment_frequency($mbr_installment_frequency)
            ->setMbr_approval_date($mbr_approval_date)
            ->setMbr_ord_key($mbr_ord_key)
            ->setMbr_mtr_key($mbr_mtr_key)
            ->setMbr_terminate_reason($mbr_terminate_reason)
            ->setMbr_installment_frequency_for_renewal($mbr_installment_frequency_for_renewal)
            ->setMbr_num_of_installments_for_renewal($mbr_num_of_installments_for_renewal)
            ->setMbr_ord_ait_key_renewal($mbr_ord_ait_key_renewal)
            ->setMbr_mbr_key($mbr_mbr_key)
            ->setMbr_proforma_renewal($mbr_proforma_renewal)
            ->setMbr_entity_key($mbr_entity_key)
            ->setMbr_ord_code($mbr_ord_code)
            ->setMbr_odd_key($mbr_odd_key)
            ->setMbr_bun_prd_key($mbr_bun_prd_key)
            ->setMbr_bun_prd_renewal_key($mbr_bun_prd_renewal_key)
            ->setMbr_prc_key($mbr_prc_key)
            ->setMbr_bup_key($mbr_bup_key)
            ->setMbr_mbt_renewal_key($mbr_mbt_renewal_key)
            ->setMbr_chp_cst_renewal_key($mbr_chp_cst_renewal_key)
            ->setMbr_cpi_key($mbr_cpi_key)
            ->setMbr_auto_pay($mbr_auto_pay)
            ->setMbr_installment_payments_flag($mbr_installment_payments_flag)
            ->setMbr_gft_key($mbr_gft_key)
            ->setMbr_cpi_consent_date($mbr_cpi_consent_date)
            ->setMbr_allowed_action($mbr_allowed_action)
            ->setMbr_rejoin_flag($mbr_rejoin_flag)
            ->setMbr_renew_related($mbr_renew_related)
            ->setMbr_apply_credits_flag($mbr_apply_credits_flag)
            ->setMbr_bup_prd_key($mbr_bup_prd_key)
            ->setMbr_addl_info($mbr_addl_info)
            ->setMbr_available_credit($mbr_available_credit)
            ->setMbr_mbt_key_new($mbr_mbt_key_new)
            ->setMbr_total($mbr_total);
    }
    /**
     * Get mbr_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_src_key(): ?string
    {
        return $this->mbr_src_key ?? null;
    }
    /**
     * Set mbr_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_src_key(?string $mbr_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_src_key) && !is_string($mbr_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_src_key, true), gettype($mbr_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_src_key, true)), __LINE__);
        }
        if (is_null($mbr_src_key) || (is_array($mbr_src_key) && empty($mbr_src_key))) {
            unset($this->mbr_src_key);
        } else {
            $this->mbr_src_key = $mbr_src_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_src_code(): ?string
    {
        return $this->mbr_src_code ?? null;
    }
    /**
     * Set mbr_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_src_code(?string $mbr_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_src_code) && !is_string($mbr_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_src_code, true), gettype($mbr_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mbr_src_code) && mb_strlen((string) $mbr_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $mbr_src_code)), __LINE__);
        }
        if (is_null($mbr_src_code) || (is_array($mbr_src_code) && empty($mbr_src_code))) {
            unset($this->mbr_src_code);
        } else {
            $this->mbr_src_code = $mbr_src_code;
        }
        
        return $this;
    }
    /**
     * Get mbr_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_asn_code(): ?string
    {
        return $this->mbr_asn_code ?? null;
    }
    /**
     * Set mbr_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_asn_code(?string $mbr_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_asn_code) && !is_string($mbr_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_asn_code, true), gettype($mbr_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($mbr_asn_code) && mb_strlen((string) $mbr_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $mbr_asn_code)), __LINE__);
        }
        if (is_null($mbr_asn_code) || (is_array($mbr_asn_code) && empty($mbr_asn_code))) {
            unset($this->mbr_asn_code);
        } else {
            $this->mbr_asn_code = $mbr_asn_code;
        }
        
        return $this;
    }
    /**
     * Get mbr_join_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_join_date(): ?string
    {
        return $this->mbr_join_date ?? null;
    }
    /**
     * Set mbr_join_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_join_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_join_date(?string $mbr_join_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_join_date) && !is_string($mbr_join_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_join_date, true), gettype($mbr_join_date)), __LINE__);
        }
        if (is_null($mbr_join_date) || (is_array($mbr_join_date) && empty($mbr_join_date))) {
            unset($this->mbr_join_date);
        } else {
            $this->mbr_join_date = $mbr_join_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_renew_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_renew_date(): ?string
    {
        return $this->mbr_renew_date ?? null;
    }
    /**
     * Set mbr_renew_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_renew_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_renew_date(?string $mbr_renew_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_renew_date) && !is_string($mbr_renew_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_renew_date, true), gettype($mbr_renew_date)), __LINE__);
        }
        if (is_null($mbr_renew_date) || (is_array($mbr_renew_date) && empty($mbr_renew_date))) {
            unset($this->mbr_renew_date);
        } else {
            $this->mbr_renew_date = $mbr_renew_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_expire_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_expire_date(): ?string
    {
        return $this->mbr_expire_date ?? null;
    }
    /**
     * Set mbr_expire_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_expire_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_expire_date(?string $mbr_expire_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_expire_date) && !is_string($mbr_expire_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_expire_date, true), gettype($mbr_expire_date)), __LINE__);
        }
        if (is_null($mbr_expire_date) || (is_array($mbr_expire_date) && empty($mbr_expire_date))) {
            unset($this->mbr_expire_date);
        } else {
            $this->mbr_expire_date = $mbr_expire_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_terminate_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_terminate_date(): ?string
    {
        return $this->mbr_terminate_date ?? null;
    }
    /**
     * Set mbr_terminate_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_terminate_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_terminate_date(?string $mbr_terminate_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_terminate_date) && !is_string($mbr_terminate_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_terminate_date, true), gettype($mbr_terminate_date)), __LINE__);
        }
        if (is_null($mbr_terminate_date) || (is_array($mbr_terminate_date) && empty($mbr_terminate_date))) {
            unset($this->mbr_terminate_date);
        } else {
            $this->mbr_terminate_date = $mbr_terminate_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_add_date(): ?string
    {
        return $this->mbr_add_date ?? null;
    }
    /**
     * Set mbr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_add_date(?string $mbr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_add_date) && !is_string($mbr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_add_date, true), gettype($mbr_add_date)), __LINE__);
        }
        if (is_null($mbr_add_date) || (is_array($mbr_add_date) && empty($mbr_add_date))) {
            unset($this->mbr_add_date);
        } else {
            $this->mbr_add_date = $mbr_add_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_add_user(): ?string
    {
        return $this->mbr_add_user ?? null;
    }
    /**
     * Set mbr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_add_user(?string $mbr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_add_user) && !is_string($mbr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_add_user, true), gettype($mbr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mbr_add_user) && mb_strlen((string) $mbr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mbr_add_user)), __LINE__);
        }
        if (is_null($mbr_add_user) || (is_array($mbr_add_user) && empty($mbr_add_user))) {
            unset($this->mbr_add_user);
        } else {
            $this->mbr_add_user = $mbr_add_user;
        }
        
        return $this;
    }
    /**
     * Get mbr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_change_user(): ?string
    {
        return $this->mbr_change_user ?? null;
    }
    /**
     * Set mbr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_change_user(?string $mbr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_change_user) && !is_string($mbr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_change_user, true), gettype($mbr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($mbr_change_user) && mb_strlen((string) $mbr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $mbr_change_user)), __LINE__);
        }
        if (is_null($mbr_change_user) || (is_array($mbr_change_user) && empty($mbr_change_user))) {
            unset($this->mbr_change_user);
        } else {
            $this->mbr_change_user = $mbr_change_user;
        }
        
        return $this;
    }
    /**
     * Get mbr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_change_date(): ?string
    {
        return $this->mbr_change_date ?? null;
    }
    /**
     * Set mbr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_change_date(?string $mbr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_change_date) && !is_string($mbr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_change_date, true), gettype($mbr_change_date)), __LINE__);
        }
        if (is_null($mbr_change_date) || (is_array($mbr_change_date) && empty($mbr_change_date))) {
            unset($this->mbr_change_date);
        } else {
            $this->mbr_change_date = $mbr_change_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_delete_flag(): ?string
    {
        return $this->mbr_delete_flag ?? null;
    }
    /**
     * Set mbr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_delete_flag(?string $mbr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_delete_flag) && !is_string($mbr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_delete_flag, true), gettype($mbr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_delete_flag) && $mbr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_delete_flag) && $mbr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_delete_flag, true)), __LINE__);
        }
        if (is_null($mbr_delete_flag) || (is_array($mbr_delete_flag) && empty($mbr_delete_flag))) {
            unset($this->mbr_delete_flag);
        } else {
            $this->mbr_delete_flag = $mbr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_key(): ?string
    {
        return $this->mbr_key ?? null;
    }
    /**
     * Set mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_key(?string $mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_key) && !is_string($mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_key, true), gettype($mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_key, true)), __LINE__);
        }
        if (is_null($mbr_key) || (is_array($mbr_key) && empty($mbr_key))) {
            unset($this->mbr_key);
        } else {
            $this->mbr_key = $mbr_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_key_ext(): ?string
    {
        return $this->mbr_key_ext ?? null;
    }
    /**
     * Set mbr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_key_ext(?string $mbr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_key_ext) && !is_string($mbr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_key_ext, true), gettype($mbr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_key_ext, true)), __LINE__);
        }
        if (is_null($mbr_key_ext) || (is_array($mbr_key_ext) && empty($mbr_key_ext))) {
            unset($this->mbr_key_ext);
        } else {
            $this->mbr_key_ext = $mbr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get mbr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_cst_key(): ?string
    {
        return $this->mbr_cst_key ?? null;
    }
    /**
     * Set mbr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_cst_key(?string $mbr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_cst_key) && !is_string($mbr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_cst_key, true), gettype($mbr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_cst_key, true)), __LINE__);
        }
        if (is_null($mbr_cst_key) || (is_array($mbr_cst_key) && empty($mbr_cst_key))) {
            unset($this->mbr_cst_key);
        } else {
            $this->mbr_cst_key = $mbr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_opt_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_opt_out(): ?string
    {
        return $this->mbr_opt_out ?? null;
    }
    /**
     * Set mbr_opt_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_opt_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_opt_out(?string $mbr_opt_out = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_opt_out) && !is_string($mbr_opt_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_opt_out, true), gettype($mbr_opt_out)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_opt_out) && $mbr_opt_out > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_opt_out, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_opt_out) && $mbr_opt_out < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_opt_out, true)), __LINE__);
        }
        if (is_null($mbr_opt_out) || (is_array($mbr_opt_out) && empty($mbr_opt_out))) {
            unset($this->mbr_opt_out);
        } else {
            $this->mbr_opt_out = $mbr_opt_out;
        }
        
        return $this;
    }
    /**
     * Get mbr_mbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mbt_key(): ?string
    {
        return $this->mbr_mbt_key ?? null;
    }
    /**
     * Set mbr_mbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mbt_key(?string $mbr_mbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mbt_key) && !is_string($mbr_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mbt_key, true), gettype($mbr_mbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mbt_key, true)), __LINE__);
        }
        if (is_null($mbr_mbt_key) || (is_array($mbr_mbt_key) && empty($mbr_mbt_key))) {
            unset($this->mbr_mbt_key);
        } else {
            $this->mbr_mbt_key = $mbr_mbt_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_mbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mbs_key(): ?string
    {
        return $this->mbr_mbs_key ?? null;
    }
    /**
     * Set mbr_mbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mbs_key(?string $mbr_mbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mbs_key) && !is_string($mbr_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mbs_key, true), gettype($mbr_mbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mbs_key, true)), __LINE__);
        }
        if (is_null($mbr_mbs_key) || (is_array($mbr_mbs_key) && empty($mbr_mbs_key))) {
            unset($this->mbr_mbs_key);
        } else {
            $this->mbr_mbs_key = $mbr_mbs_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_pak_prd_key(): ?string
    {
        return $this->mbr_pak_prd_key ?? null;
    }
    /**
     * Set mbr_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_pak_prd_key(?string $mbr_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_pak_prd_key) && !is_string($mbr_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_pak_prd_key, true), gettype($mbr_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_pak_prd_key, true)), __LINE__);
        }
        if (is_null($mbr_pak_prd_key) || (is_array($mbr_pak_prd_key) && empty($mbr_pak_prd_key))) {
            unset($this->mbr_pak_prd_key);
        } else {
            $this->mbr_pak_prd_key = $mbr_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_ind_cst_key_referral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_ind_cst_key_referral(): ?string
    {
        return $this->mbr_ind_cst_key_referral ?? null;
    }
    /**
     * Set mbr_ind_cst_key_referral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_ind_cst_key_referral
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_ind_cst_key_referral(?string $mbr_ind_cst_key_referral = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_ind_cst_key_referral) && !is_string($mbr_ind_cst_key_referral)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_ind_cst_key_referral, true), gettype($mbr_ind_cst_key_referral)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_ind_cst_key_referral) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_ind_cst_key_referral)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_ind_cst_key_referral, true)), __LINE__);
        }
        if (is_null($mbr_ind_cst_key_referral) || (is_array($mbr_ind_cst_key_referral) && empty($mbr_ind_cst_key_referral))) {
            unset($this->mbr_ind_cst_key_referral);
        } else {
            $this->mbr_ind_cst_key_referral = $mbr_ind_cst_key_referral;
        }
        
        return $this;
    }
    /**
     * Get mbr_pak_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_pak_prd_renewal_key(): ?string
    {
        return $this->mbr_pak_prd_renewal_key ?? null;
    }
    /**
     * Set mbr_pak_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_pak_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_pak_prd_renewal_key(?string $mbr_pak_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_pak_prd_renewal_key) && !is_string($mbr_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_pak_prd_renewal_key, true), gettype($mbr_pak_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_pak_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_pak_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_pak_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($mbr_pak_prd_renewal_key) || (is_array($mbr_pak_prd_renewal_key) && empty($mbr_pak_prd_renewal_key))) {
            unset($this->mbr_pak_prd_renewal_key);
        } else {
            $this->mbr_pak_prd_renewal_key = $mbr_pak_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_do_not_renew_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_do_not_renew_flag(): ?string
    {
        return $this->mbr_do_not_renew_flag ?? null;
    }
    /**
     * Set mbr_do_not_renew_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_do_not_renew_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_do_not_renew_flag(?string $mbr_do_not_renew_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_do_not_renew_flag) && !is_string($mbr_do_not_renew_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_do_not_renew_flag, true), gettype($mbr_do_not_renew_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_do_not_renew_flag) && $mbr_do_not_renew_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_do_not_renew_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_do_not_renew_flag) && $mbr_do_not_renew_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_do_not_renew_flag, true)), __LINE__);
        }
        if (is_null($mbr_do_not_renew_flag) || (is_array($mbr_do_not_renew_flag) && empty($mbr_do_not_renew_flag))) {
            unset($this->mbr_do_not_renew_flag);
        } else {
            $this->mbr_do_not_renew_flag = $mbr_do_not_renew_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_invoice_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_invoice_date(): ?string
    {
        return $this->mbr_invoice_date ?? null;
    }
    /**
     * Set mbr_invoice_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_invoice_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_invoice_date(?string $mbr_invoice_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_invoice_date) && !is_string($mbr_invoice_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_invoice_date, true), gettype($mbr_invoice_date)), __LINE__);
        }
        if (is_null($mbr_invoice_date) || (is_array($mbr_invoice_date) && empty($mbr_invoice_date))) {
            unset($this->mbr_invoice_date);
        } else {
            $this->mbr_invoice_date = $mbr_invoice_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_rejoin_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_rejoin_date(): ?string
    {
        return $this->mbr_rejoin_date ?? null;
    }
    /**
     * Set mbr_rejoin_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_rejoin_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_rejoin_date(?string $mbr_rejoin_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_rejoin_date) && !is_string($mbr_rejoin_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_rejoin_date, true), gettype($mbr_rejoin_date)), __LINE__);
        }
        if (is_null($mbr_rejoin_date) || (is_array($mbr_rejoin_date) && empty($mbr_rejoin_date))) {
            unset($this->mbr_rejoin_date);
        } else {
            $this->mbr_rejoin_date = $mbr_rejoin_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_popup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_popup(): ?string
    {
        return $this->mbr_popup ?? null;
    }
    /**
     * Set mbr_popup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_popup
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_popup(?string $mbr_popup = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_popup) && !is_string($mbr_popup)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_popup, true), gettype($mbr_popup)), __LINE__);
        }
        if (is_null($mbr_popup) || (is_array($mbr_popup) && empty($mbr_popup))) {
            unset($this->mbr_popup);
        } else {
            $this->mbr_popup = $mbr_popup;
        }
        
        return $this;
    }
    /**
     * Get mbr_voting_rights value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_voting_rights(): ?string
    {
        return $this->mbr_voting_rights ?? null;
    }
    /**
     * Set mbr_voting_rights value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_voting_rights
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_voting_rights(?string $mbr_voting_rights = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_voting_rights) && !is_string($mbr_voting_rights)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_voting_rights, true), gettype($mbr_voting_rights)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_voting_rights) && $mbr_voting_rights > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_voting_rights, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_voting_rights) && $mbr_voting_rights < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_voting_rights, true)), __LINE__);
        }
        if (is_null($mbr_voting_rights) || (is_array($mbr_voting_rights) && empty($mbr_voting_rights))) {
            unset($this->mbr_voting_rights);
        } else {
            $this->mbr_voting_rights = $mbr_voting_rights;
        }
        
        return $this;
    }
    /**
     * Get mbr_chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_chp_cst_key(): ?string
    {
        return $this->mbr_chp_cst_key ?? null;
    }
    /**
     * Set mbr_chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_chp_cst_key(?string $mbr_chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_chp_cst_key) && !is_string($mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_chp_cst_key, true), gettype($mbr_chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_chp_cst_key, true)), __LINE__);
        }
        if (is_null($mbr_chp_cst_key) || (is_array($mbr_chp_cst_key) && empty($mbr_chp_cst_key))) {
            unset($this->mbr_chp_cst_key);
        } else {
            $this->mbr_chp_cst_key = $mbr_chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_converted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_converted_flag(): ?string
    {
        return $this->mbr_converted_flag ?? null;
    }
    /**
     * Set mbr_converted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_converted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_converted_flag(?string $mbr_converted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_converted_flag) && !is_string($mbr_converted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_converted_flag, true), gettype($mbr_converted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_converted_flag) && $mbr_converted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_converted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_converted_flag) && $mbr_converted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_converted_flag, true)), __LINE__);
        }
        if (is_null($mbr_converted_flag) || (is_array($mbr_converted_flag) && empty($mbr_converted_flag))) {
            unset($this->mbr_converted_flag);
        } else {
            $this->mbr_converted_flag = $mbr_converted_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_approval_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_approval_flag(): ?string
    {
        return $this->mbr_approval_flag ?? null;
    }
    /**
     * Set mbr_approval_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_approval_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_approval_flag(?string $mbr_approval_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_approval_flag) && !is_string($mbr_approval_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_approval_flag, true), gettype($mbr_approval_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_approval_flag) && $mbr_approval_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_approval_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_approval_flag) && $mbr_approval_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_approval_flag, true)), __LINE__);
        }
        if (is_null($mbr_approval_flag) || (is_array($mbr_approval_flag) && empty($mbr_approval_flag))) {
            unset($this->mbr_approval_flag);
        } else {
            $this->mbr_approval_flag = $mbr_approval_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_installment_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbr_installment_frequency(): ?int
    {
        return $this->mbr_installment_frequency ?? null;
    }
    /**
     * Set mbr_installment_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbr_installment_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_installment_frequency(?int $mbr_installment_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($mbr_installment_frequency) && !(is_int($mbr_installment_frequency) || ctype_digit($mbr_installment_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbr_installment_frequency, true), gettype($mbr_installment_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbr_installment_frequency) && $mbr_installment_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbr_installment_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbr_installment_frequency) && $mbr_installment_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbr_installment_frequency, true)), __LINE__);
        }
        if (is_null($mbr_installment_frequency) || (is_array($mbr_installment_frequency) && empty($mbr_installment_frequency))) {
            unset($this->mbr_installment_frequency);
        } else {
            $this->mbr_installment_frequency = $mbr_installment_frequency;
        }
        
        return $this;
    }
    /**
     * Get mbr_approval_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_approval_date(): ?string
    {
        return $this->mbr_approval_date ?? null;
    }
    /**
     * Set mbr_approval_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_approval_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_approval_date(?string $mbr_approval_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_approval_date) && !is_string($mbr_approval_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_approval_date, true), gettype($mbr_approval_date)), __LINE__);
        }
        if (is_null($mbr_approval_date) || (is_array($mbr_approval_date) && empty($mbr_approval_date))) {
            unset($this->mbr_approval_date);
        } else {
            $this->mbr_approval_date = $mbr_approval_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_ord_key(): ?string
    {
        return $this->mbr_ord_key ?? null;
    }
    /**
     * Set mbr_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_ord_key(?string $mbr_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_ord_key) && !is_string($mbr_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_ord_key, true), gettype($mbr_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_ord_key, true)), __LINE__);
        }
        if (is_null($mbr_ord_key) || (is_array($mbr_ord_key) && empty($mbr_ord_key))) {
            unset($this->mbr_ord_key);
        } else {
            $this->mbr_ord_key = $mbr_ord_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_mtr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mtr_key(): ?string
    {
        return $this->mbr_mtr_key ?? null;
    }
    /**
     * Set mbr_mtr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mtr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mtr_key(?string $mbr_mtr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mtr_key) && !is_string($mbr_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mtr_key, true), gettype($mbr_mtr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mtr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mtr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mtr_key, true)), __LINE__);
        }
        if (is_null($mbr_mtr_key) || (is_array($mbr_mtr_key) && empty($mbr_mtr_key))) {
            unset($this->mbr_mtr_key);
        } else {
            $this->mbr_mtr_key = $mbr_mtr_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_terminate_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_terminate_reason(): ?string
    {
        return $this->mbr_terminate_reason ?? null;
    }
    /**
     * Set mbr_terminate_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_terminate_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_terminate_reason(?string $mbr_terminate_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_terminate_reason) && !is_string($mbr_terminate_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_terminate_reason, true), gettype($mbr_terminate_reason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($mbr_terminate_reason) && mb_strlen((string) $mbr_terminate_reason) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $mbr_terminate_reason)), __LINE__);
        }
        if (is_null($mbr_terminate_reason) || (is_array($mbr_terminate_reason) && empty($mbr_terminate_reason))) {
            unset($this->mbr_terminate_reason);
        } else {
            $this->mbr_terminate_reason = $mbr_terminate_reason;
        }
        
        return $this;
    }
    /**
     * Get mbr_installment_frequency_for_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbr_installment_frequency_for_renewal(): ?int
    {
        return $this->mbr_installment_frequency_for_renewal ?? null;
    }
    /**
     * Set mbr_installment_frequency_for_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbr_installment_frequency_for_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_installment_frequency_for_renewal(?int $mbr_installment_frequency_for_renewal = null): self
    {
        // validation for constraint: int
        if (!is_null($mbr_installment_frequency_for_renewal) && !(is_int($mbr_installment_frequency_for_renewal) || ctype_digit($mbr_installment_frequency_for_renewal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbr_installment_frequency_for_renewal, true), gettype($mbr_installment_frequency_for_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbr_installment_frequency_for_renewal) && $mbr_installment_frequency_for_renewal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbr_installment_frequency_for_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbr_installment_frequency_for_renewal) && $mbr_installment_frequency_for_renewal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbr_installment_frequency_for_renewal, true)), __LINE__);
        }
        if (is_null($mbr_installment_frequency_for_renewal) || (is_array($mbr_installment_frequency_for_renewal) && empty($mbr_installment_frequency_for_renewal))) {
            unset($this->mbr_installment_frequency_for_renewal);
        } else {
            $this->mbr_installment_frequency_for_renewal = $mbr_installment_frequency_for_renewal;
        }
        
        return $this;
    }
    /**
     * Get mbr_num_of_installments_for_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMbr_num_of_installments_for_renewal(): ?int
    {
        return $this->mbr_num_of_installments_for_renewal ?? null;
    }
    /**
     * Set mbr_num_of_installments_for_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mbr_num_of_installments_for_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_num_of_installments_for_renewal(?int $mbr_num_of_installments_for_renewal = null): self
    {
        // validation for constraint: int
        if (!is_null($mbr_num_of_installments_for_renewal) && !(is_int($mbr_num_of_installments_for_renewal) || ctype_digit($mbr_num_of_installments_for_renewal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mbr_num_of_installments_for_renewal, true), gettype($mbr_num_of_installments_for_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($mbr_num_of_installments_for_renewal) && $mbr_num_of_installments_for_renewal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($mbr_num_of_installments_for_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($mbr_num_of_installments_for_renewal) && $mbr_num_of_installments_for_renewal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($mbr_num_of_installments_for_renewal, true)), __LINE__);
        }
        if (is_null($mbr_num_of_installments_for_renewal) || (is_array($mbr_num_of_installments_for_renewal) && empty($mbr_num_of_installments_for_renewal))) {
            unset($this->mbr_num_of_installments_for_renewal);
        } else {
            $this->mbr_num_of_installments_for_renewal = $mbr_num_of_installments_for_renewal;
        }
        
        return $this;
    }
    /**
     * Get mbr_ord_ait_key_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_ord_ait_key_renewal(): ?string
    {
        return $this->mbr_ord_ait_key_renewal ?? null;
    }
    /**
     * Set mbr_ord_ait_key_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_ord_ait_key_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_ord_ait_key_renewal(?string $mbr_ord_ait_key_renewal = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_ord_ait_key_renewal) && !is_string($mbr_ord_ait_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_ord_ait_key_renewal, true), gettype($mbr_ord_ait_key_renewal)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_ord_ait_key_renewal) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_ord_ait_key_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_ord_ait_key_renewal, true)), __LINE__);
        }
        if (is_null($mbr_ord_ait_key_renewal) || (is_array($mbr_ord_ait_key_renewal) && empty($mbr_ord_ait_key_renewal))) {
            unset($this->mbr_ord_ait_key_renewal);
        } else {
            $this->mbr_ord_ait_key_renewal = $mbr_ord_ait_key_renewal;
        }
        
        return $this;
    }
    /**
     * Get mbr_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mbr_key(): ?string
    {
        return $this->mbr_mbr_key ?? null;
    }
    /**
     * Set mbr_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mbr_key(?string $mbr_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mbr_key) && !is_string($mbr_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mbr_key, true), gettype($mbr_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mbr_key, true)), __LINE__);
        }
        if (is_null($mbr_mbr_key) || (is_array($mbr_mbr_key) && empty($mbr_mbr_key))) {
            unset($this->mbr_mbr_key);
        } else {
            $this->mbr_mbr_key = $mbr_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_proforma_renewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_proforma_renewal(): ?string
    {
        return $this->mbr_proforma_renewal ?? null;
    }
    /**
     * Set mbr_proforma_renewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_proforma_renewal
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_proforma_renewal(?string $mbr_proforma_renewal = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_proforma_renewal) && !is_string($mbr_proforma_renewal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_proforma_renewal, true), gettype($mbr_proforma_renewal)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_proforma_renewal) && $mbr_proforma_renewal > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_proforma_renewal, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_proforma_renewal) && $mbr_proforma_renewal < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_proforma_renewal, true)), __LINE__);
        }
        if (is_null($mbr_proforma_renewal) || (is_array($mbr_proforma_renewal) && empty($mbr_proforma_renewal))) {
            unset($this->mbr_proforma_renewal);
        } else {
            $this->mbr_proforma_renewal = $mbr_proforma_renewal;
        }
        
        return $this;
    }
    /**
     * Get mbr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_entity_key(): ?string
    {
        return $this->mbr_entity_key ?? null;
    }
    /**
     * Set mbr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_entity_key(?string $mbr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_entity_key) && !is_string($mbr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_entity_key, true), gettype($mbr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_entity_key, true)), __LINE__);
        }
        if (is_null($mbr_entity_key) || (is_array($mbr_entity_key) && empty($mbr_entity_key))) {
            unset($this->mbr_entity_key);
        } else {
            $this->mbr_entity_key = $mbr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_ord_code(): ?string
    {
        return $this->mbr_ord_code ?? null;
    }
    /**
     * Set mbr_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_ord_code(?string $mbr_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_ord_code) && !is_string($mbr_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_ord_code, true), gettype($mbr_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mbr_ord_code) && mb_strlen((string) $mbr_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $mbr_ord_code)), __LINE__);
        }
        if (is_null($mbr_ord_code) || (is_array($mbr_ord_code) && empty($mbr_ord_code))) {
            unset($this->mbr_ord_code);
        } else {
            $this->mbr_ord_code = $mbr_ord_code;
        }
        
        return $this;
    }
    /**
     * Get mbr_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_odd_key(): ?string
    {
        return $this->mbr_odd_key ?? null;
    }
    /**
     * Set mbr_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_odd_key(?string $mbr_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_odd_key) && !is_string($mbr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_odd_key, true), gettype($mbr_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_odd_key, true)), __LINE__);
        }
        if (is_null($mbr_odd_key) || (is_array($mbr_odd_key) && empty($mbr_odd_key))) {
            unset($this->mbr_odd_key);
        } else {
            $this->mbr_odd_key = $mbr_odd_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_bun_prd_key(): ?string
    {
        return $this->mbr_bun_prd_key ?? null;
    }
    /**
     * Set mbr_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_bun_prd_key(?string $mbr_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_bun_prd_key) && !is_string($mbr_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_bun_prd_key, true), gettype($mbr_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_bun_prd_key, true)), __LINE__);
        }
        if (is_null($mbr_bun_prd_key) || (is_array($mbr_bun_prd_key) && empty($mbr_bun_prd_key))) {
            unset($this->mbr_bun_prd_key);
        } else {
            $this->mbr_bun_prd_key = $mbr_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_bun_prd_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_bun_prd_renewal_key(): ?string
    {
        return $this->mbr_bun_prd_renewal_key ?? null;
    }
    /**
     * Set mbr_bun_prd_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_bun_prd_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_bun_prd_renewal_key(?string $mbr_bun_prd_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_bun_prd_renewal_key) && !is_string($mbr_bun_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_bun_prd_renewal_key, true), gettype($mbr_bun_prd_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_bun_prd_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_bun_prd_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_bun_prd_renewal_key, true)), __LINE__);
        }
        if (is_null($mbr_bun_prd_renewal_key) || (is_array($mbr_bun_prd_renewal_key) && empty($mbr_bun_prd_renewal_key))) {
            unset($this->mbr_bun_prd_renewal_key);
        } else {
            $this->mbr_bun_prd_renewal_key = $mbr_bun_prd_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_prc_key(): ?string
    {
        return $this->mbr_prc_key ?? null;
    }
    /**
     * Set mbr_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_prc_key(?string $mbr_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_prc_key) && !is_string($mbr_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_prc_key, true), gettype($mbr_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_prc_key, true)), __LINE__);
        }
        if (is_null($mbr_prc_key) || (is_array($mbr_prc_key) && empty($mbr_prc_key))) {
            unset($this->mbr_prc_key);
        } else {
            $this->mbr_prc_key = $mbr_prc_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_bup_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_bup_key(): ?string
    {
        return $this->mbr_bup_key ?? null;
    }
    /**
     * Set mbr_bup_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_bup_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_bup_key(?string $mbr_bup_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_bup_key) && !is_string($mbr_bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_bup_key, true), gettype($mbr_bup_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_bup_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_bup_key, true)), __LINE__);
        }
        if (is_null($mbr_bup_key) || (is_array($mbr_bup_key) && empty($mbr_bup_key))) {
            unset($this->mbr_bup_key);
        } else {
            $this->mbr_bup_key = $mbr_bup_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_mbt_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mbt_renewal_key(): ?string
    {
        return $this->mbr_mbt_renewal_key ?? null;
    }
    /**
     * Set mbr_mbt_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mbt_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mbt_renewal_key(?string $mbr_mbt_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mbt_renewal_key) && !is_string($mbr_mbt_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mbt_renewal_key, true), gettype($mbr_mbt_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mbt_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mbt_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mbt_renewal_key, true)), __LINE__);
        }
        if (is_null($mbr_mbt_renewal_key) || (is_array($mbr_mbt_renewal_key) && empty($mbr_mbt_renewal_key))) {
            unset($this->mbr_mbt_renewal_key);
        } else {
            $this->mbr_mbt_renewal_key = $mbr_mbt_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_chp_cst_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_chp_cst_renewal_key(): ?string
    {
        return $this->mbr_chp_cst_renewal_key ?? null;
    }
    /**
     * Set mbr_chp_cst_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_chp_cst_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_chp_cst_renewal_key(?string $mbr_chp_cst_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_chp_cst_renewal_key) && !is_string($mbr_chp_cst_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_chp_cst_renewal_key, true), gettype($mbr_chp_cst_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_chp_cst_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_chp_cst_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_chp_cst_renewal_key, true)), __LINE__);
        }
        if (is_null($mbr_chp_cst_renewal_key) || (is_array($mbr_chp_cst_renewal_key) && empty($mbr_chp_cst_renewal_key))) {
            unset($this->mbr_chp_cst_renewal_key);
        } else {
            $this->mbr_chp_cst_renewal_key = $mbr_chp_cst_renewal_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_cpi_key(): ?string
    {
        return $this->mbr_cpi_key ?? null;
    }
    /**
     * Set mbr_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_cpi_key(?string $mbr_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_cpi_key) && !is_string($mbr_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_cpi_key, true), gettype($mbr_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_cpi_key, true)), __LINE__);
        }
        if (is_null($mbr_cpi_key) || (is_array($mbr_cpi_key) && empty($mbr_cpi_key))) {
            unset($this->mbr_cpi_key);
        } else {
            $this->mbr_cpi_key = $mbr_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_auto_pay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_auto_pay(): ?string
    {
        return $this->mbr_auto_pay ?? null;
    }
    /**
     * Set mbr_auto_pay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_auto_pay
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_auto_pay(?string $mbr_auto_pay = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_auto_pay) && !is_string($mbr_auto_pay)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_auto_pay, true), gettype($mbr_auto_pay)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_auto_pay) && $mbr_auto_pay > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_auto_pay, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_auto_pay) && $mbr_auto_pay < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_auto_pay, true)), __LINE__);
        }
        if (is_null($mbr_auto_pay) || (is_array($mbr_auto_pay) && empty($mbr_auto_pay))) {
            unset($this->mbr_auto_pay);
        } else {
            $this->mbr_auto_pay = $mbr_auto_pay;
        }
        
        return $this;
    }
    /**
     * Get mbr_installment_payments_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_installment_payments_flag(): ?string
    {
        return $this->mbr_installment_payments_flag ?? null;
    }
    /**
     * Set mbr_installment_payments_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_installment_payments_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_installment_payments_flag(?string $mbr_installment_payments_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_installment_payments_flag) && !is_string($mbr_installment_payments_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_installment_payments_flag, true), gettype($mbr_installment_payments_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_installment_payments_flag) && $mbr_installment_payments_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_installment_payments_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_installment_payments_flag) && $mbr_installment_payments_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_installment_payments_flag, true)), __LINE__);
        }
        if (is_null($mbr_installment_payments_flag) || (is_array($mbr_installment_payments_flag) && empty($mbr_installment_payments_flag))) {
            unset($this->mbr_installment_payments_flag);
        } else {
            $this->mbr_installment_payments_flag = $mbr_installment_payments_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_gft_key(): ?string
    {
        return $this->mbr_gft_key ?? null;
    }
    /**
     * Set mbr_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_gft_key(?string $mbr_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_gft_key) && !is_string($mbr_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_gft_key, true), gettype($mbr_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_gft_key, true)), __LINE__);
        }
        if (is_null($mbr_gft_key) || (is_array($mbr_gft_key) && empty($mbr_gft_key))) {
            unset($this->mbr_gft_key);
        } else {
            $this->mbr_gft_key = $mbr_gft_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_cpi_consent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_cpi_consent_date(): ?string
    {
        return $this->mbr_cpi_consent_date ?? null;
    }
    /**
     * Set mbr_cpi_consent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_cpi_consent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_cpi_consent_date(?string $mbr_cpi_consent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_cpi_consent_date) && !is_string($mbr_cpi_consent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_cpi_consent_date, true), gettype($mbr_cpi_consent_date)), __LINE__);
        }
        if (is_null($mbr_cpi_consent_date) || (is_array($mbr_cpi_consent_date) && empty($mbr_cpi_consent_date))) {
            unset($this->mbr_cpi_consent_date);
        } else {
            $this->mbr_cpi_consent_date = $mbr_cpi_consent_date;
        }
        
        return $this;
    }
    /**
     * Get mbr_allowed_action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_allowed_action(): ?string
    {
        return $this->mbr_allowed_action ?? null;
    }
    /**
     * Set mbr_allowed_action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_allowed_action
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_allowed_action(?string $mbr_allowed_action = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_allowed_action) && !is_string($mbr_allowed_action)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_allowed_action, true), gettype($mbr_allowed_action)), __LINE__);
        }
        if (is_null($mbr_allowed_action) || (is_array($mbr_allowed_action) && empty($mbr_allowed_action))) {
            unset($this->mbr_allowed_action);
        } else {
            $this->mbr_allowed_action = $mbr_allowed_action;
        }
        
        return $this;
    }
    /**
     * Get mbr_rejoin_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_rejoin_flag(): ?string
    {
        return $this->mbr_rejoin_flag ?? null;
    }
    /**
     * Set mbr_rejoin_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_rejoin_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_rejoin_flag(?string $mbr_rejoin_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_rejoin_flag) && !is_string($mbr_rejoin_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_rejoin_flag, true), gettype($mbr_rejoin_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_rejoin_flag) && $mbr_rejoin_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_rejoin_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_rejoin_flag) && $mbr_rejoin_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_rejoin_flag, true)), __LINE__);
        }
        if (is_null($mbr_rejoin_flag) || (is_array($mbr_rejoin_flag) && empty($mbr_rejoin_flag))) {
            unset($this->mbr_rejoin_flag);
        } else {
            $this->mbr_rejoin_flag = $mbr_rejoin_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_renew_related value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_renew_related(): ?string
    {
        return $this->mbr_renew_related ?? null;
    }
    /**
     * Set mbr_renew_related value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_renew_related
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_renew_related(?string $mbr_renew_related = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_renew_related) && !is_string($mbr_renew_related)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_renew_related, true), gettype($mbr_renew_related)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_renew_related) && $mbr_renew_related > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_renew_related, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_renew_related) && $mbr_renew_related < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_renew_related, true)), __LINE__);
        }
        if (is_null($mbr_renew_related) || (is_array($mbr_renew_related) && empty($mbr_renew_related))) {
            unset($this->mbr_renew_related);
        } else {
            $this->mbr_renew_related = $mbr_renew_related;
        }
        
        return $this;
    }
    /**
     * Get mbr_apply_credits_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_apply_credits_flag(): ?string
    {
        return $this->mbr_apply_credits_flag ?? null;
    }
    /**
     * Set mbr_apply_credits_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_apply_credits_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_apply_credits_flag(?string $mbr_apply_credits_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_apply_credits_flag) && !is_string($mbr_apply_credits_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_apply_credits_flag, true), gettype($mbr_apply_credits_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($mbr_apply_credits_flag) && $mbr_apply_credits_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($mbr_apply_credits_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($mbr_apply_credits_flag) && $mbr_apply_credits_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($mbr_apply_credits_flag, true)), __LINE__);
        }
        if (is_null($mbr_apply_credits_flag) || (is_array($mbr_apply_credits_flag) && empty($mbr_apply_credits_flag))) {
            unset($this->mbr_apply_credits_flag);
        } else {
            $this->mbr_apply_credits_flag = $mbr_apply_credits_flag;
        }
        
        return $this;
    }
    /**
     * Get mbr_bup_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_bup_prd_key(): ?string
    {
        return $this->mbr_bup_prd_key ?? null;
    }
    /**
     * Set mbr_bup_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_bup_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_bup_prd_key(?string $mbr_bup_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_bup_prd_key) && !is_string($mbr_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_bup_prd_key, true), gettype($mbr_bup_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_bup_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_bup_prd_key, true)), __LINE__);
        }
        if (is_null($mbr_bup_prd_key) || (is_array($mbr_bup_prd_key) && empty($mbr_bup_prd_key))) {
            unset($this->mbr_bup_prd_key);
        } else {
            $this->mbr_bup_prd_key = $mbr_bup_prd_key;
        }
        
        return $this;
    }
    /**
     * Get mbr_addl_info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_addl_info(): ?string
    {
        return $this->mbr_addl_info ?? null;
    }
    /**
     * Set mbr_addl_info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_addl_info
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_addl_info(?string $mbr_addl_info = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_addl_info) && !is_string($mbr_addl_info)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_addl_info, true), gettype($mbr_addl_info)), __LINE__);
        }
        if (is_null($mbr_addl_info) || (is_array($mbr_addl_info) && empty($mbr_addl_info))) {
            unset($this->mbr_addl_info);
        } else {
            $this->mbr_addl_info = $mbr_addl_info;
        }
        
        return $this;
    }
    /**
     * Get mbr_available_credit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMbr_available_credit(): ?float
    {
        return $this->mbr_available_credit ?? null;
    }
    /**
     * Set mbr_available_credit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mbr_available_credit
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_available_credit(?float $mbr_available_credit = null): self
    {
        // validation for constraint: float
        if (!is_null($mbr_available_credit) && !(is_float($mbr_available_credit) || is_numeric($mbr_available_credit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mbr_available_credit, true), gettype($mbr_available_credit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($mbr_available_credit) && mb_strlen(mb_substr((string) $mbr_available_credit, false !== mb_strpos((string) $mbr_available_credit, '.') ? mb_strpos((string) $mbr_available_credit, '.') + 1 : mb_strlen((string) $mbr_available_credit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($mbr_available_credit, true), mb_strlen(mb_substr((string) $mbr_available_credit, mb_strpos((string) $mbr_available_credit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($mbr_available_credit) && mb_strlen(preg_replace('/(\D)/', '', (string) $mbr_available_credit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($mbr_available_credit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $mbr_available_credit))), __LINE__);
        }
        if (is_null($mbr_available_credit) || (is_array($mbr_available_credit) && empty($mbr_available_credit))) {
            unset($this->mbr_available_credit);
        } else {
            $this->mbr_available_credit = $mbr_available_credit;
        }
        
        return $this;
    }
    /**
     * Get mbr_mbt_key_new value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMbr_mbt_key_new(): ?string
    {
        return $this->mbr_mbt_key_new ?? null;
    }
    /**
     * Set mbr_mbt_key_new value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mbr_mbt_key_new
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_mbt_key_new(?string $mbr_mbt_key_new = null): self
    {
        // validation for constraint: string
        if (!is_null($mbr_mbt_key_new) && !is_string($mbr_mbt_key_new)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbr_mbt_key_new, true), gettype($mbr_mbt_key_new)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($mbr_mbt_key_new) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $mbr_mbt_key_new)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($mbr_mbt_key_new, true)), __LINE__);
        }
        if (is_null($mbr_mbt_key_new) || (is_array($mbr_mbt_key_new) && empty($mbr_mbt_key_new))) {
            unset($this->mbr_mbt_key_new);
        } else {
            $this->mbr_mbt_key_new = $mbr_mbt_key_new;
        }
        
        return $this;
    }
    /**
     * Get mbr_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMbr_total(): ?float
    {
        return $this->mbr_total ?? null;
    }
    /**
     * Set mbr_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mbr_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Membership_DataObjectType
     */
    public function setMbr_total(?float $mbr_total = null): self
    {
        // validation for constraint: float
        if (!is_null($mbr_total) && !(is_float($mbr_total) || is_numeric($mbr_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mbr_total, true), gettype($mbr_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($mbr_total) && mb_strlen(mb_substr((string) $mbr_total, false !== mb_strpos((string) $mbr_total, '.') ? mb_strpos((string) $mbr_total, '.') + 1 : mb_strlen((string) $mbr_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($mbr_total, true), mb_strlen(mb_substr((string) $mbr_total, mb_strpos((string) $mbr_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($mbr_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $mbr_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($mbr_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $mbr_total))), __LINE__);
        }
        if (is_null($mbr_total) || (is_array($mbr_total) && empty($mbr_total))) {
            unset($this->mbr_total);
        } else {
            $this->mbr_total = $mbr_total;
        }
        
        return $this;
    }
}
