<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mb_membership_Package_Component_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Mb_membership_Package_Component_DataObjectType extends AbstractStructBase
{
    /**
     * The pkg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pkg_key = null;
    /**
     * The pkg_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Package Product Price. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pkg_prc_key = null;
    /**
     * The pkg_qty
     * Meta information extracted from the WSDL
     * - documentation: Package Quantity.This element has a default value of '1'. This field has this Input Mask: 999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pkg_qty = null;
    /**
     * The pkg_price
     * Meta information extracted from the WSDL
     * - documentation: Package Item Price. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pkg_price = null;
    /**
     * The pkg_show_on_invoice
     * Meta information extracted from the WSDL
     * - documentation: Show on Invoice. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_show_on_invoice = null;
    /**
     * The pkg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_add_user = null;
    /**
     * The pkg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_add_date = null;
    /**
     * The pkg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_change_user = null;
    /**
     * The pkg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_change_date = null;
    /**
     * The pkg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_delete_flag = null;
    /**
     * The pkg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pkg_key_ext = null;
    /**
     * The pkg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pkg_entity_key = null;
    /**
     * The pkg_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package Header. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pkg_pak_prd_key = null;
    /**
     * The pkg_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_start_date = null;
    /**
     * The pkg_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_end_date = null;
    /**
     * The pkg_custom_calculation_flag
     * Meta information extracted from the WSDL
     * - documentation: Custom Calculation. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_custom_calculation_flag = null;
    /**
     * The pkg_optional
     * Meta information extracted from the WSDL
     * - documentation: Optional?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pkg_optional = null;
    /**
     * Constructor method for mb_membership_Package_Component_DataObjectType
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_key()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_prc_key()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_qty()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_price()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_show_on_invoice()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_add_user()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_add_date()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_change_user()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_change_date()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_delete_flag()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_key_ext()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_entity_key()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_pak_prd_key()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_start_date()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_end_date()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_custom_calculation_flag()
     * @uses Mb_membership_Package_Component_DataObjectType::setPkg_optional()
     * @param string $pkg_key
     * @param string $pkg_prc_key
     * @param float $pkg_qty
     * @param float $pkg_price
     * @param string $pkg_show_on_invoice
     * @param string $pkg_add_user
     * @param string $pkg_add_date
     * @param string $pkg_change_user
     * @param string $pkg_change_date
     * @param string $pkg_delete_flag
     * @param string $pkg_key_ext
     * @param string $pkg_entity_key
     * @param string $pkg_pak_prd_key
     * @param string $pkg_start_date
     * @param string $pkg_end_date
     * @param string $pkg_custom_calculation_flag
     * @param string $pkg_optional
     */
    public function __construct(?string $pkg_key = null, ?string $pkg_prc_key = null, ?float $pkg_qty = null, ?float $pkg_price = null, ?string $pkg_show_on_invoice = null, ?string $pkg_add_user = null, ?string $pkg_add_date = null, ?string $pkg_change_user = null, ?string $pkg_change_date = null, ?string $pkg_delete_flag = null, ?string $pkg_key_ext = null, ?string $pkg_entity_key = null, ?string $pkg_pak_prd_key = null, ?string $pkg_start_date = null, ?string $pkg_end_date = null, ?string $pkg_custom_calculation_flag = null, ?string $pkg_optional = null)
    {
        $this
            ->setPkg_key($pkg_key)
            ->setPkg_prc_key($pkg_prc_key)
            ->setPkg_qty($pkg_qty)
            ->setPkg_price($pkg_price)
            ->setPkg_show_on_invoice($pkg_show_on_invoice)
            ->setPkg_add_user($pkg_add_user)
            ->setPkg_add_date($pkg_add_date)
            ->setPkg_change_user($pkg_change_user)
            ->setPkg_change_date($pkg_change_date)
            ->setPkg_delete_flag($pkg_delete_flag)
            ->setPkg_key_ext($pkg_key_ext)
            ->setPkg_entity_key($pkg_entity_key)
            ->setPkg_pak_prd_key($pkg_pak_prd_key)
            ->setPkg_start_date($pkg_start_date)
            ->setPkg_end_date($pkg_end_date)
            ->setPkg_custom_calculation_flag($pkg_custom_calculation_flag)
            ->setPkg_optional($pkg_optional);
    }
    /**
     * Get pkg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_key(): ?string
    {
        return $this->pkg_key ?? null;
    }
    /**
     * Set pkg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_key(?string $pkg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_key) && !is_string($pkg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_key, true), gettype($pkg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pkg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pkg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pkg_key, true)), __LINE__);
        }
        if (is_null($pkg_key) || (is_array($pkg_key) && empty($pkg_key))) {
            unset($this->pkg_key);
        } else {
            $this->pkg_key = $pkg_key;
        }
        
        return $this;
    }
    /**
     * Get pkg_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_prc_key(): ?string
    {
        return $this->pkg_prc_key ?? null;
    }
    /**
     * Set pkg_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_prc_key(?string $pkg_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_prc_key) && !is_string($pkg_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_prc_key, true), gettype($pkg_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pkg_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pkg_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pkg_prc_key, true)), __LINE__);
        }
        if (is_null($pkg_prc_key) || (is_array($pkg_prc_key) && empty($pkg_prc_key))) {
            unset($this->pkg_prc_key);
        } else {
            $this->pkg_prc_key = $pkg_prc_key;
        }
        
        return $this;
    }
    /**
     * Get pkg_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPkg_qty(): ?float
    {
        return $this->pkg_qty ?? null;
    }
    /**
     * Set pkg_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pkg_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_qty(?float $pkg_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($pkg_qty) && !(is_float($pkg_qty) || is_numeric($pkg_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pkg_qty, true), gettype($pkg_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pkg_qty) && mb_strlen(mb_substr((string) $pkg_qty, false !== mb_strpos((string) $pkg_qty, '.') ? mb_strpos((string) $pkg_qty, '.') + 1 : mb_strlen((string) $pkg_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pkg_qty, true), mb_strlen(mb_substr((string) $pkg_qty, mb_strpos((string) $pkg_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pkg_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $pkg_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pkg_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pkg_qty))), __LINE__);
        }
        if (is_null($pkg_qty) || (is_array($pkg_qty) && empty($pkg_qty))) {
            unset($this->pkg_qty);
        } else {
            $this->pkg_qty = $pkg_qty;
        }
        
        return $this;
    }
    /**
     * Get pkg_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPkg_price(): ?float
    {
        return $this->pkg_price ?? null;
    }
    /**
     * Set pkg_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pkg_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_price(?float $pkg_price = null): self
    {
        // validation for constraint: float
        if (!is_null($pkg_price) && !(is_float($pkg_price) || is_numeric($pkg_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pkg_price, true), gettype($pkg_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pkg_price) && mb_strlen(mb_substr((string) $pkg_price, false !== mb_strpos((string) $pkg_price, '.') ? mb_strpos((string) $pkg_price, '.') + 1 : mb_strlen((string) $pkg_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pkg_price, true), mb_strlen(mb_substr((string) $pkg_price, mb_strpos((string) $pkg_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pkg_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $pkg_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pkg_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pkg_price))), __LINE__);
        }
        if (is_null($pkg_price) || (is_array($pkg_price) && empty($pkg_price))) {
            unset($this->pkg_price);
        } else {
            $this->pkg_price = $pkg_price;
        }
        
        return $this;
    }
    /**
     * Get pkg_show_on_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_show_on_invoice(): ?string
    {
        return $this->pkg_show_on_invoice ?? null;
    }
    /**
     * Set pkg_show_on_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_show_on_invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_show_on_invoice(?string $pkg_show_on_invoice = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_show_on_invoice) && !is_string($pkg_show_on_invoice)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_show_on_invoice, true), gettype($pkg_show_on_invoice)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pkg_show_on_invoice) && $pkg_show_on_invoice > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pkg_show_on_invoice, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pkg_show_on_invoice) && $pkg_show_on_invoice < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pkg_show_on_invoice, true)), __LINE__);
        }
        if (is_null($pkg_show_on_invoice) || (is_array($pkg_show_on_invoice) && empty($pkg_show_on_invoice))) {
            unset($this->pkg_show_on_invoice);
        } else {
            $this->pkg_show_on_invoice = $pkg_show_on_invoice;
        }
        
        return $this;
    }
    /**
     * Get pkg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_add_user(): ?string
    {
        return $this->pkg_add_user ?? null;
    }
    /**
     * Set pkg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_add_user(?string $pkg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_add_user) && !is_string($pkg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_add_user, true), gettype($pkg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pkg_add_user) && mb_strlen((string) $pkg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pkg_add_user)), __LINE__);
        }
        if (is_null($pkg_add_user) || (is_array($pkg_add_user) && empty($pkg_add_user))) {
            unset($this->pkg_add_user);
        } else {
            $this->pkg_add_user = $pkg_add_user;
        }
        
        return $this;
    }
    /**
     * Get pkg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_add_date(): ?string
    {
        return $this->pkg_add_date ?? null;
    }
    /**
     * Set pkg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_add_date(?string $pkg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_add_date) && !is_string($pkg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_add_date, true), gettype($pkg_add_date)), __LINE__);
        }
        if (is_null($pkg_add_date) || (is_array($pkg_add_date) && empty($pkg_add_date))) {
            unset($this->pkg_add_date);
        } else {
            $this->pkg_add_date = $pkg_add_date;
        }
        
        return $this;
    }
    /**
     * Get pkg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_change_user(): ?string
    {
        return $this->pkg_change_user ?? null;
    }
    /**
     * Set pkg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_change_user(?string $pkg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_change_user) && !is_string($pkg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_change_user, true), gettype($pkg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pkg_change_user) && mb_strlen((string) $pkg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pkg_change_user)), __LINE__);
        }
        if (is_null($pkg_change_user) || (is_array($pkg_change_user) && empty($pkg_change_user))) {
            unset($this->pkg_change_user);
        } else {
            $this->pkg_change_user = $pkg_change_user;
        }
        
        return $this;
    }
    /**
     * Get pkg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_change_date(): ?string
    {
        return $this->pkg_change_date ?? null;
    }
    /**
     * Set pkg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_change_date(?string $pkg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_change_date) && !is_string($pkg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_change_date, true), gettype($pkg_change_date)), __LINE__);
        }
        if (is_null($pkg_change_date) || (is_array($pkg_change_date) && empty($pkg_change_date))) {
            unset($this->pkg_change_date);
        } else {
            $this->pkg_change_date = $pkg_change_date;
        }
        
        return $this;
    }
    /**
     * Get pkg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_delete_flag(): ?string
    {
        return $this->pkg_delete_flag ?? null;
    }
    /**
     * Set pkg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_delete_flag(?string $pkg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_delete_flag) && !is_string($pkg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_delete_flag, true), gettype($pkg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pkg_delete_flag) && $pkg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pkg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pkg_delete_flag) && $pkg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pkg_delete_flag, true)), __LINE__);
        }
        if (is_null($pkg_delete_flag) || (is_array($pkg_delete_flag) && empty($pkg_delete_flag))) {
            unset($this->pkg_delete_flag);
        } else {
            $this->pkg_delete_flag = $pkg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pkg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_key_ext(): ?string
    {
        return $this->pkg_key_ext ?? null;
    }
    /**
     * Set pkg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_key_ext(?string $pkg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_key_ext) && !is_string($pkg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_key_ext, true), gettype($pkg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pkg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pkg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pkg_key_ext, true)), __LINE__);
        }
        if (is_null($pkg_key_ext) || (is_array($pkg_key_ext) && empty($pkg_key_ext))) {
            unset($this->pkg_key_ext);
        } else {
            $this->pkg_key_ext = $pkg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pkg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_entity_key(): ?string
    {
        return $this->pkg_entity_key ?? null;
    }
    /**
     * Set pkg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_entity_key(?string $pkg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_entity_key) && !is_string($pkg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_entity_key, true), gettype($pkg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pkg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pkg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pkg_entity_key, true)), __LINE__);
        }
        if (is_null($pkg_entity_key) || (is_array($pkg_entity_key) && empty($pkg_entity_key))) {
            unset($this->pkg_entity_key);
        } else {
            $this->pkg_entity_key = $pkg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pkg_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_pak_prd_key(): ?string
    {
        return $this->pkg_pak_prd_key ?? null;
    }
    /**
     * Set pkg_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_pak_prd_key(?string $pkg_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_pak_prd_key) && !is_string($pkg_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_pak_prd_key, true), gettype($pkg_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pkg_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pkg_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pkg_pak_prd_key, true)), __LINE__);
        }
        if (is_null($pkg_pak_prd_key) || (is_array($pkg_pak_prd_key) && empty($pkg_pak_prd_key))) {
            unset($this->pkg_pak_prd_key);
        } else {
            $this->pkg_pak_prd_key = $pkg_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get pkg_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_start_date(): ?string
    {
        return $this->pkg_start_date ?? null;
    }
    /**
     * Set pkg_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_start_date(?string $pkg_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_start_date) && !is_string($pkg_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_start_date, true), gettype($pkg_start_date)), __LINE__);
        }
        if (is_null($pkg_start_date) || (is_array($pkg_start_date) && empty($pkg_start_date))) {
            unset($this->pkg_start_date);
        } else {
            $this->pkg_start_date = $pkg_start_date;
        }
        
        return $this;
    }
    /**
     * Get pkg_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_end_date(): ?string
    {
        return $this->pkg_end_date ?? null;
    }
    /**
     * Set pkg_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_end_date(?string $pkg_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_end_date) && !is_string($pkg_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_end_date, true), gettype($pkg_end_date)), __LINE__);
        }
        if (is_null($pkg_end_date) || (is_array($pkg_end_date) && empty($pkg_end_date))) {
            unset($this->pkg_end_date);
        } else {
            $this->pkg_end_date = $pkg_end_date;
        }
        
        return $this;
    }
    /**
     * Get pkg_custom_calculation_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_custom_calculation_flag(): ?string
    {
        return $this->pkg_custom_calculation_flag ?? null;
    }
    /**
     * Set pkg_custom_calculation_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_custom_calculation_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_custom_calculation_flag(?string $pkg_custom_calculation_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_custom_calculation_flag) && !is_string($pkg_custom_calculation_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_custom_calculation_flag, true), gettype($pkg_custom_calculation_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pkg_custom_calculation_flag) && $pkg_custom_calculation_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pkg_custom_calculation_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pkg_custom_calculation_flag) && $pkg_custom_calculation_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pkg_custom_calculation_flag, true)), __LINE__);
        }
        if (is_null($pkg_custom_calculation_flag) || (is_array($pkg_custom_calculation_flag) && empty($pkg_custom_calculation_flag))) {
            unset($this->pkg_custom_calculation_flag);
        } else {
            $this->pkg_custom_calculation_flag = $pkg_custom_calculation_flag;
        }
        
        return $this;
    }
    /**
     * Get pkg_optional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPkg_optional(): ?string
    {
        return $this->pkg_optional ?? null;
    }
    /**
     * Set pkg_optional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pkg_optional
     * @return \Drupal\netforum\xWeb\Generated\StructType\Mb_membership_Package_Component_DataObjectType
     */
    public function setPkg_optional(?string $pkg_optional = null): self
    {
        // validation for constraint: string
        if (!is_null($pkg_optional) && !is_string($pkg_optional)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkg_optional, true), gettype($pkg_optional)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pkg_optional) && $pkg_optional > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pkg_optional, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pkg_optional) && $pkg_optional < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pkg_optional, true)), __LINE__);
        }
        if (is_null($pkg_optional) || (is_array($pkg_optional) && empty($pkg_optional))) {
            unset($this->pkg_optional);
        } else {
            $this->pkg_optional = $pkg_optional;
        }
        
        return $this;
    }
}
