<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeCustomerResult StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MergeCustomerResult extends AbstractStructBase
{
    /**
     * The cst_key
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $cst_key;
    /**
     * The AfterMergeAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $AfterMergeAction;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $Status;
    /**
     * The ModuleResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult $ModuleResults = null;
    /**
     * Constructor method for MergeCustomerResult
     * @uses MergeCustomerResult::setCst_key()
     * @uses MergeCustomerResult::setAfterMergeAction()
     * @uses MergeCustomerResult::setStatus()
     * @uses MergeCustomerResult::setModuleResults()
     * @param string $cst_key
     * @param string $afterMergeAction
     * @param string $status
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult $moduleResults
     */
    public function __construct(string $cst_key, string $afterMergeAction, string $status, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult $moduleResults = null)
    {
        $this
            ->setCst_key($cst_key)
            ->setAfterMergeAction($afterMergeAction)
            ->setStatus($status)
            ->setModuleResults($moduleResults);
    }
    /**
     * Get cst_key value
     * @return string
     */
    public function getCst_key(): string
    {
        return $this->cst_key;
    }
    /**
     * Set cst_key value
     * @param string $cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResult
     */
    public function setCst_key(string $cst_key): self
    {
        // validation for constraint: string
        if (!is_null($cst_key) && !is_string($cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_key, true), gettype($cst_key)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($cst_key) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($cst_key, true)), __LINE__);
        }
        $this->cst_key = $cst_key;
        
        return $this;
    }
    /**
     * Get AfterMergeAction value
     * @return string
     */
    public function getAfterMergeAction(): string
    {
        return $this->AfterMergeAction;
    }
    /**
     * Set AfterMergeAction value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\AfterMergeAction::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\AfterMergeAction::getValidValues()
     * @throws InvalidArgumentException
     * @param string $afterMergeAction
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResult
     */
    public function setAfterMergeAction(string $afterMergeAction): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\AfterMergeAction::valueIsValid($afterMergeAction)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\AfterMergeAction', is_array($afterMergeAction) ? implode(', ', $afterMergeAction) : var_export($afterMergeAction, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\AfterMergeAction::getValidValues())), __LINE__);
        }
        $this->AfterMergeAction = $afterMergeAction;
        
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus(): string
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::getValidValues()
     * @throws InvalidArgumentException
     * @param string $status
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResult
     */
    public function setStatus(string $status): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\MergeResult::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\MergeResult', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\MergeResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        
        return $this;
    }
    /**
     * Get ModuleResults value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult|null
     */
    public function getModuleResults(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult
    {
        return $this->ModuleResults;
    }
    /**
     * Set ModuleResults value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult $moduleResults
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResult
     */
    public function setModuleResults(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfModuleResult $moduleResults = null): self
    {
        $this->ModuleResults = $moduleResults;
        
        return $this;
    }
}
