<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeCustomerResults StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MergeCustomerResults extends AbstractStructBase
{
    /**
     * The cst_key_keep
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $cst_key_keep;
    /**
     * The CustomerResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult $CustomerResults = null;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ErrorMessage = null;
    /**
     * Constructor method for MergeCustomerResults
     * @uses MergeCustomerResults::setCst_key_keep()
     * @uses MergeCustomerResults::setCustomerResults()
     * @uses MergeCustomerResults::setErrorMessage()
     * @param string $cst_key_keep
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult $customerResults
     * @param string $errorMessage
     */
    public function __construct(string $cst_key_keep, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult $customerResults = null, ?string $errorMessage = null)
    {
        $this
            ->setCst_key_keep($cst_key_keep)
            ->setCustomerResults($customerResults)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get cst_key_keep value
     * @return string
     */
    public function getCst_key_keep(): string
    {
        return $this->cst_key_keep;
    }
    /**
     * Set cst_key_keep value
     * @param string $cst_key_keep
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResults
     */
    public function setCst_key_keep(string $cst_key_keep): self
    {
        // validation for constraint: string
        if (!is_null($cst_key_keep) && !is_string($cst_key_keep)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_key_keep, true), gettype($cst_key_keep)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($cst_key_keep) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $cst_key_keep)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($cst_key_keep, true)), __LINE__);
        }
        $this->cst_key_keep = $cst_key_keep;
        
        return $this;
    }
    /**
     * Get CustomerResults value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult|null
     */
    public function getCustomerResults(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult
    {
        return $this->CustomerResults;
    }
    /**
     * Set CustomerResults value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult $customerResults
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResults
     */
    public function setCustomerResults(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomerResult $customerResults = null): self
    {
        $this->CustomerResults = $customerResults;
        
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage(): ?string
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomerResults
     */
    public function setErrorMessage(?string $errorMessage = null): self
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        
        return $this;
    }
}
