<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeCustomers StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MergeCustomers extends AbstractStructBase
{
    /**
     * The cst_key_keep
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $cst_key_keep;
    /**
     * The customersToMerge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer $customersToMerge = null;
    /**
     * Constructor method for MergeCustomers
     * @uses MergeCustomers::setCst_key_keep()
     * @uses MergeCustomers::setCustomersToMerge()
     * @param string $cst_key_keep
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer $customersToMerge
     */
    public function __construct(string $cst_key_keep, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer $customersToMerge = null)
    {
        $this
            ->setCst_key_keep($cst_key_keep)
            ->setCustomersToMerge($customersToMerge);
    }
    /**
     * Get cst_key_keep value
     * @return string
     */
    public function getCst_key_keep(): string
    {
        return $this->cst_key_keep;
    }
    /**
     * Set cst_key_keep value
     * @param string $cst_key_keep
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomers
     */
    public function setCst_key_keep(string $cst_key_keep): self
    {
        // validation for constraint: string
        if (!is_null($cst_key_keep) && !is_string($cst_key_keep)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cst_key_keep, true), gettype($cst_key_keep)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($cst_key_keep) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $cst_key_keep)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($cst_key_keep, true)), __LINE__);
        }
        $this->cst_key_keep = $cst_key_keep;
        
        return $this;
    }
    /**
     * Get customersToMerge value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer|null
     */
    public function getCustomersToMerge(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer
    {
        return $this->customersToMerge;
    }
    /**
     * Set customersToMerge value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer $customersToMerge
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomers
     */
    public function setCustomersToMerge(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMergeCustomer $customersToMerge = null): self
    {
        $this->customersToMerge = $customersToMerge;
        
        return $this;
    }
}
