<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetaDataGetWizard StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class MetaDataGetWizard extends AbstractStructBase
{
    /**
     * The WizardKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $WizardKey;
    /**
     * Constructor method for MetaDataGetWizard
     * @uses MetaDataGetWizard::setWizardKey()
     * @param string $wizardKey
     */
    public function __construct(string $wizardKey)
    {
        $this
            ->setWizardKey($wizardKey);
    }
    /**
     * Get WizardKey value
     * @return string
     */
    public function getWizardKey(): string
    {
        return $this->WizardKey;
    }
    /**
     * Set WizardKey value
     * @param string $wizardKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizard
     */
    public function setWizardKey(string $wizardKey): self
    {
        // validation for constraint: string
        if (!is_null($wizardKey) && !is_string($wizardKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wizardKey, true), gettype($wizardKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($wizardKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $wizardKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($wizardKey, true)), __LINE__);
        }
        $this->WizardKey = $wizardKey;
        
        return $this;
    }
}
