<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Business_Address_State_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Organization_Business_Address_State_DataObjectType extends AbstractStructBase
{
    /**
     * The sta_code
     * Meta information extracted from the WSDL
     * - documentation: State/Territory Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_code = null;
    /**
     * The sta_cty_code
     * Meta information extracted from the WSDL
     * - documentation: Country. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_cty_code = null;
    /**
     * The sta_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add user. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_add_user = null;
    /**
     * The sta_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_add_date = null;
    /**
     * The sta_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_change_date = null;
    /**
     * The sta_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_change_user = null;
    /**
     * The sta_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_delete_flag = null;
    /**
     * The sta_key
     * Meta information extracted from the WSDL
     * - documentation: State Territory Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sta_key = null;
    /**
     * The sta_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sta_key_ext = null;
    /**
     * The sta_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sta_entity_key = null;
    /**
     * The sta_name
     * Meta information extracted from the WSDL
     * - documentation: State Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_name = null;
    /**
     * The sta_type
     * Meta information extracted from the WSDL
     * - documentation: State Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_type = null;
    /**
     * The sta_rgn_key
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sta_rgn_key = null;
    /**
     * The sta_bpa_region
     * Meta information extracted from the WSDL
     * - documentation: BPA Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_bpa_region = null;
    /**
     * The sta_iso_code
     * Meta information extracted from the WSDL
     * - documentation: ISO code that represent states and territories associated with countries.. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sta_iso_code = null;
    /**
     * Constructor method for Organization_Business_Address_State_DataObjectType
     * @uses Organization_Business_Address_State_DataObjectType::setSta_code()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_cty_code()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_add_user()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_add_date()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_change_date()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_change_user()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_delete_flag()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_key()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_key_ext()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_entity_key()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_name()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_type()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_rgn_key()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_bpa_region()
     * @uses Organization_Business_Address_State_DataObjectType::setSta_iso_code()
     * @param string $sta_code
     * @param string $sta_cty_code
     * @param string $sta_add_user
     * @param string $sta_add_date
     * @param string $sta_change_date
     * @param string $sta_change_user
     * @param string $sta_delete_flag
     * @param string $sta_key
     * @param string $sta_key_ext
     * @param string $sta_entity_key
     * @param string $sta_name
     * @param string $sta_type
     * @param string $sta_rgn_key
     * @param string $sta_bpa_region
     * @param string $sta_iso_code
     */
    public function __construct(?string $sta_code = null, ?string $sta_cty_code = null, ?string $sta_add_user = null, ?string $sta_add_date = null, ?string $sta_change_date = null, ?string $sta_change_user = null, ?string $sta_delete_flag = null, ?string $sta_key = null, ?string $sta_key_ext = null, ?string $sta_entity_key = null, ?string $sta_name = null, ?string $sta_type = null, ?string $sta_rgn_key = null, ?string $sta_bpa_region = null, ?string $sta_iso_code = null)
    {
        $this
            ->setSta_code($sta_code)
            ->setSta_cty_code($sta_cty_code)
            ->setSta_add_user($sta_add_user)
            ->setSta_add_date($sta_add_date)
            ->setSta_change_date($sta_change_date)
            ->setSta_change_user($sta_change_user)
            ->setSta_delete_flag($sta_delete_flag)
            ->setSta_key($sta_key)
            ->setSta_key_ext($sta_key_ext)
            ->setSta_entity_key($sta_entity_key)
            ->setSta_name($sta_name)
            ->setSta_type($sta_type)
            ->setSta_rgn_key($sta_rgn_key)
            ->setSta_bpa_region($sta_bpa_region)
            ->setSta_iso_code($sta_iso_code);
    }
    /**
     * Get sta_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_code(): ?string
    {
        return $this->sta_code ?? null;
    }
    /**
     * Set sta_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_code(?string $sta_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_code) && !is_string($sta_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_code, true), gettype($sta_code)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($sta_code) && mb_strlen((string) $sta_code) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $sta_code)), __LINE__);
        }
        if (is_null($sta_code) || (is_array($sta_code) && empty($sta_code))) {
            unset($this->sta_code);
        } else {
            $this->sta_code = $sta_code;
        }
        
        return $this;
    }
    /**
     * Get sta_cty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_cty_code(): ?string
    {
        return $this->sta_cty_code ?? null;
    }
    /**
     * Set sta_cty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_cty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_cty_code(?string $sta_cty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_cty_code) && !is_string($sta_cty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_cty_code, true), gettype($sta_cty_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($sta_cty_code) && mb_strlen((string) $sta_cty_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $sta_cty_code)), __LINE__);
        }
        if (is_null($sta_cty_code) || (is_array($sta_cty_code) && empty($sta_cty_code))) {
            unset($this->sta_cty_code);
        } else {
            $this->sta_cty_code = $sta_cty_code;
        }
        
        return $this;
    }
    /**
     * Get sta_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_add_user(): ?string
    {
        return $this->sta_add_user ?? null;
    }
    /**
     * Set sta_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_add_user(?string $sta_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_add_user) && !is_string($sta_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_add_user, true), gettype($sta_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sta_add_user) && mb_strlen((string) $sta_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sta_add_user)), __LINE__);
        }
        if (is_null($sta_add_user) || (is_array($sta_add_user) && empty($sta_add_user))) {
            unset($this->sta_add_user);
        } else {
            $this->sta_add_user = $sta_add_user;
        }
        
        return $this;
    }
    /**
     * Get sta_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_add_date(): ?string
    {
        return $this->sta_add_date ?? null;
    }
    /**
     * Set sta_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_add_date(?string $sta_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_add_date) && !is_string($sta_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_add_date, true), gettype($sta_add_date)), __LINE__);
        }
        if (is_null($sta_add_date) || (is_array($sta_add_date) && empty($sta_add_date))) {
            unset($this->sta_add_date);
        } else {
            $this->sta_add_date = $sta_add_date;
        }
        
        return $this;
    }
    /**
     * Get sta_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_change_date(): ?string
    {
        return $this->sta_change_date ?? null;
    }
    /**
     * Set sta_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_change_date(?string $sta_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_change_date) && !is_string($sta_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_change_date, true), gettype($sta_change_date)), __LINE__);
        }
        if (is_null($sta_change_date) || (is_array($sta_change_date) && empty($sta_change_date))) {
            unset($this->sta_change_date);
        } else {
            $this->sta_change_date = $sta_change_date;
        }
        
        return $this;
    }
    /**
     * Get sta_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_change_user(): ?string
    {
        return $this->sta_change_user ?? null;
    }
    /**
     * Set sta_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_change_user(?string $sta_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_change_user) && !is_string($sta_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_change_user, true), gettype($sta_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sta_change_user) && mb_strlen((string) $sta_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sta_change_user)), __LINE__);
        }
        if (is_null($sta_change_user) || (is_array($sta_change_user) && empty($sta_change_user))) {
            unset($this->sta_change_user);
        } else {
            $this->sta_change_user = $sta_change_user;
        }
        
        return $this;
    }
    /**
     * Get sta_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_delete_flag(): ?string
    {
        return $this->sta_delete_flag ?? null;
    }
    /**
     * Set sta_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_delete_flag(?string $sta_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_delete_flag) && !is_string($sta_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_delete_flag, true), gettype($sta_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($sta_delete_flag) && $sta_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($sta_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sta_delete_flag) && $sta_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sta_delete_flag, true)), __LINE__);
        }
        if (is_null($sta_delete_flag) || (is_array($sta_delete_flag) && empty($sta_delete_flag))) {
            unset($this->sta_delete_flag);
        } else {
            $this->sta_delete_flag = $sta_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get sta_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_key(): ?string
    {
        return $this->sta_key ?? null;
    }
    /**
     * Set sta_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_key(?string $sta_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_key) && !is_string($sta_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_key, true), gettype($sta_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sta_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sta_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sta_key, true)), __LINE__);
        }
        if (is_null($sta_key) || (is_array($sta_key) && empty($sta_key))) {
            unset($this->sta_key);
        } else {
            $this->sta_key = $sta_key;
        }
        
        return $this;
    }
    /**
     * Get sta_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_key_ext(): ?string
    {
        return $this->sta_key_ext ?? null;
    }
    /**
     * Set sta_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_key_ext(?string $sta_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_key_ext) && !is_string($sta_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_key_ext, true), gettype($sta_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sta_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sta_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sta_key_ext, true)), __LINE__);
        }
        if (is_null($sta_key_ext) || (is_array($sta_key_ext) && empty($sta_key_ext))) {
            unset($this->sta_key_ext);
        } else {
            $this->sta_key_ext = $sta_key_ext;
        }
        
        return $this;
    }
    /**
     * Get sta_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_entity_key(): ?string
    {
        return $this->sta_entity_key ?? null;
    }
    /**
     * Set sta_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_entity_key(?string $sta_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_entity_key) && !is_string($sta_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_entity_key, true), gettype($sta_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sta_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sta_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sta_entity_key, true)), __LINE__);
        }
        if (is_null($sta_entity_key) || (is_array($sta_entity_key) && empty($sta_entity_key))) {
            unset($this->sta_entity_key);
        } else {
            $this->sta_entity_key = $sta_entity_key;
        }
        
        return $this;
    }
    /**
     * Get sta_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_name(): ?string
    {
        return $this->sta_name ?? null;
    }
    /**
     * Set sta_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_name(?string $sta_name = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_name) && !is_string($sta_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_name, true), gettype($sta_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($sta_name) && mb_strlen((string) $sta_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $sta_name)), __LINE__);
        }
        if (is_null($sta_name) || (is_array($sta_name) && empty($sta_name))) {
            unset($this->sta_name);
        } else {
            $this->sta_name = $sta_name;
        }
        
        return $this;
    }
    /**
     * Get sta_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_type(): ?string
    {
        return $this->sta_type ?? null;
    }
    /**
     * Set sta_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_type(?string $sta_type = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_type) && !is_string($sta_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_type, true), gettype($sta_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sta_type) && mb_strlen((string) $sta_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sta_type)), __LINE__);
        }
        if (is_null($sta_type) || (is_array($sta_type) && empty($sta_type))) {
            unset($this->sta_type);
        } else {
            $this->sta_type = $sta_type;
        }
        
        return $this;
    }
    /**
     * Get sta_rgn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_rgn_key(): ?string
    {
        return $this->sta_rgn_key ?? null;
    }
    /**
     * Set sta_rgn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_rgn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_rgn_key(?string $sta_rgn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_rgn_key) && !is_string($sta_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_rgn_key, true), gettype($sta_rgn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sta_rgn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sta_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sta_rgn_key, true)), __LINE__);
        }
        if (is_null($sta_rgn_key) || (is_array($sta_rgn_key) && empty($sta_rgn_key))) {
            unset($this->sta_rgn_key);
        } else {
            $this->sta_rgn_key = $sta_rgn_key;
        }
        
        return $this;
    }
    /**
     * Get sta_bpa_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_bpa_region(): ?string
    {
        return $this->sta_bpa_region ?? null;
    }
    /**
     * Set sta_bpa_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_bpa_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_bpa_region(?string $sta_bpa_region = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_bpa_region) && !is_string($sta_bpa_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_bpa_region, true), gettype($sta_bpa_region)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($sta_bpa_region) && mb_strlen((string) $sta_bpa_region) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $sta_bpa_region)), __LINE__);
        }
        if (is_null($sta_bpa_region) || (is_array($sta_bpa_region) && empty($sta_bpa_region))) {
            unset($this->sta_bpa_region);
        } else {
            $this->sta_bpa_region = $sta_bpa_region;
        }
        
        return $this;
    }
    /**
     * Get sta_iso_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSta_iso_code(): ?string
    {
        return $this->sta_iso_code ?? null;
    }
    /**
     * Set sta_iso_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sta_iso_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Business_Address_State_DataObjectType
     */
    public function setSta_iso_code(?string $sta_iso_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sta_iso_code) && !is_string($sta_iso_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sta_iso_code, true), gettype($sta_iso_code)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($sta_iso_code) && mb_strlen((string) $sta_iso_code) > 6) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen((string) $sta_iso_code)), __LINE__);
        }
        if (is_null($sta_iso_code) || (is_array($sta_iso_code) && empty($sta_iso_code))) {
            unset($this->sta_iso_code);
        } else {
            $this->sta_iso_code = $sta_iso_code;
        }
        
        return $this;
    }
}
