<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Home_Address_State_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Organization_Home_Address_State_DataObjectType extends AbstractStructBase
{
    /**
     * The st2__sta_code
     * Meta information extracted from the WSDL
     * - documentation: State/Territory Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_code = null;
    /**
     * The st2__sta_cty_code
     * Meta information extracted from the WSDL
     * - documentation: Country. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_cty_code = null;
    /**
     * The st2__sta_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add user. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_add_user = null;
    /**
     * The st2__sta_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_add_date = null;
    /**
     * The st2__sta_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_change_date = null;
    /**
     * The st2__sta_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_change_user = null;
    /**
     * The st2__sta_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_delete_flag = null;
    /**
     * The st2__sta_key
     * Meta information extracted from the WSDL
     * - documentation: State Territory Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $st2__sta_key = null;
    /**
     * The st2__sta_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $st2__sta_key_ext = null;
    /**
     * The st2__sta_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $st2__sta_entity_key = null;
    /**
     * The st2__sta_name
     * Meta information extracted from the WSDL
     * - documentation: State Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_name = null;
    /**
     * The st2__sta_type
     * Meta information extracted from the WSDL
     * - documentation: State Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_type = null;
    /**
     * The st2__sta_rgn_key
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $st2__sta_rgn_key = null;
    /**
     * The st2__sta_bpa_region
     * Meta information extracted from the WSDL
     * - documentation: BPA Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_bpa_region = null;
    /**
     * The st2__sta_iso_code
     * Meta information extracted from the WSDL
     * - documentation: ISO code that represent states and territories associated with countries.. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $st2__sta_iso_code = null;
    /**
     * Constructor method for Organization_Home_Address_State_DataObjectType
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_code()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_cty_code()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_add_user()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_add_date()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_change_date()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_change_user()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_delete_flag()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_key()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_key_ext()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_entity_key()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_name()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_type()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_rgn_key()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_bpa_region()
     * @uses Organization_Home_Address_State_DataObjectType::setSt2__sta_iso_code()
     * @param string $st2__sta_code
     * @param string $st2__sta_cty_code
     * @param string $st2__sta_add_user
     * @param string $st2__sta_add_date
     * @param string $st2__sta_change_date
     * @param string $st2__sta_change_user
     * @param string $st2__sta_delete_flag
     * @param string $st2__sta_key
     * @param string $st2__sta_key_ext
     * @param string $st2__sta_entity_key
     * @param string $st2__sta_name
     * @param string $st2__sta_type
     * @param string $st2__sta_rgn_key
     * @param string $st2__sta_bpa_region
     * @param string $st2__sta_iso_code
     */
    public function __construct(?string $st2__sta_code = null, ?string $st2__sta_cty_code = null, ?string $st2__sta_add_user = null, ?string $st2__sta_add_date = null, ?string $st2__sta_change_date = null, ?string $st2__sta_change_user = null, ?string $st2__sta_delete_flag = null, ?string $st2__sta_key = null, ?string $st2__sta_key_ext = null, ?string $st2__sta_entity_key = null, ?string $st2__sta_name = null, ?string $st2__sta_type = null, ?string $st2__sta_rgn_key = null, ?string $st2__sta_bpa_region = null, ?string $st2__sta_iso_code = null)
    {
        $this
            ->setSt2__sta_code($st2__sta_code)
            ->setSt2__sta_cty_code($st2__sta_cty_code)
            ->setSt2__sta_add_user($st2__sta_add_user)
            ->setSt2__sta_add_date($st2__sta_add_date)
            ->setSt2__sta_change_date($st2__sta_change_date)
            ->setSt2__sta_change_user($st2__sta_change_user)
            ->setSt2__sta_delete_flag($st2__sta_delete_flag)
            ->setSt2__sta_key($st2__sta_key)
            ->setSt2__sta_key_ext($st2__sta_key_ext)
            ->setSt2__sta_entity_key($st2__sta_entity_key)
            ->setSt2__sta_name($st2__sta_name)
            ->setSt2__sta_type($st2__sta_type)
            ->setSt2__sta_rgn_key($st2__sta_rgn_key)
            ->setSt2__sta_bpa_region($st2__sta_bpa_region)
            ->setSt2__sta_iso_code($st2__sta_iso_code);
    }
    /**
     * Get st2__sta_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_code(): ?string
    {
        return $this->st2__sta_code ?? null;
    }
    /**
     * Set st2__sta_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_code(?string $st2__sta_code = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_code) && !is_string($st2__sta_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_code, true), gettype($st2__sta_code)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($st2__sta_code) && mb_strlen((string) $st2__sta_code) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $st2__sta_code)), __LINE__);
        }
        if (is_null($st2__sta_code) || (is_array($st2__sta_code) && empty($st2__sta_code))) {
            unset($this->st2__sta_code);
        } else {
            $this->st2__sta_code = $st2__sta_code;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_cty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_cty_code(): ?string
    {
        return $this->st2__sta_cty_code ?? null;
    }
    /**
     * Set st2__sta_cty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_cty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_cty_code(?string $st2__sta_cty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_cty_code) && !is_string($st2__sta_cty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_cty_code, true), gettype($st2__sta_cty_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($st2__sta_cty_code) && mb_strlen((string) $st2__sta_cty_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $st2__sta_cty_code)), __LINE__);
        }
        if (is_null($st2__sta_cty_code) || (is_array($st2__sta_cty_code) && empty($st2__sta_cty_code))) {
            unset($this->st2__sta_cty_code);
        } else {
            $this->st2__sta_cty_code = $st2__sta_cty_code;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_add_user(): ?string
    {
        return $this->st2__sta_add_user ?? null;
    }
    /**
     * Set st2__sta_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_add_user(?string $st2__sta_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_add_user) && !is_string($st2__sta_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_add_user, true), gettype($st2__sta_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($st2__sta_add_user) && mb_strlen((string) $st2__sta_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $st2__sta_add_user)), __LINE__);
        }
        if (is_null($st2__sta_add_user) || (is_array($st2__sta_add_user) && empty($st2__sta_add_user))) {
            unset($this->st2__sta_add_user);
        } else {
            $this->st2__sta_add_user = $st2__sta_add_user;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_add_date(): ?string
    {
        return $this->st2__sta_add_date ?? null;
    }
    /**
     * Set st2__sta_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_add_date(?string $st2__sta_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_add_date) && !is_string($st2__sta_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_add_date, true), gettype($st2__sta_add_date)), __LINE__);
        }
        if (is_null($st2__sta_add_date) || (is_array($st2__sta_add_date) && empty($st2__sta_add_date))) {
            unset($this->st2__sta_add_date);
        } else {
            $this->st2__sta_add_date = $st2__sta_add_date;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_change_date(): ?string
    {
        return $this->st2__sta_change_date ?? null;
    }
    /**
     * Set st2__sta_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_change_date(?string $st2__sta_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_change_date) && !is_string($st2__sta_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_change_date, true), gettype($st2__sta_change_date)), __LINE__);
        }
        if (is_null($st2__sta_change_date) || (is_array($st2__sta_change_date) && empty($st2__sta_change_date))) {
            unset($this->st2__sta_change_date);
        } else {
            $this->st2__sta_change_date = $st2__sta_change_date;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_change_user(): ?string
    {
        return $this->st2__sta_change_user ?? null;
    }
    /**
     * Set st2__sta_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_change_user(?string $st2__sta_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_change_user) && !is_string($st2__sta_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_change_user, true), gettype($st2__sta_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($st2__sta_change_user) && mb_strlen((string) $st2__sta_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $st2__sta_change_user)), __LINE__);
        }
        if (is_null($st2__sta_change_user) || (is_array($st2__sta_change_user) && empty($st2__sta_change_user))) {
            unset($this->st2__sta_change_user);
        } else {
            $this->st2__sta_change_user = $st2__sta_change_user;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_delete_flag(): ?string
    {
        return $this->st2__sta_delete_flag ?? null;
    }
    /**
     * Set st2__sta_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_delete_flag(?string $st2__sta_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_delete_flag) && !is_string($st2__sta_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_delete_flag, true), gettype($st2__sta_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($st2__sta_delete_flag) && $st2__sta_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($st2__sta_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($st2__sta_delete_flag) && $st2__sta_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($st2__sta_delete_flag, true)), __LINE__);
        }
        if (is_null($st2__sta_delete_flag) || (is_array($st2__sta_delete_flag) && empty($st2__sta_delete_flag))) {
            unset($this->st2__sta_delete_flag);
        } else {
            $this->st2__sta_delete_flag = $st2__sta_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_key(): ?string
    {
        return $this->st2__sta_key ?? null;
    }
    /**
     * Set st2__sta_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_key(?string $st2__sta_key = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_key) && !is_string($st2__sta_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_key, true), gettype($st2__sta_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($st2__sta_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $st2__sta_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($st2__sta_key, true)), __LINE__);
        }
        if (is_null($st2__sta_key) || (is_array($st2__sta_key) && empty($st2__sta_key))) {
            unset($this->st2__sta_key);
        } else {
            $this->st2__sta_key = $st2__sta_key;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_key_ext(): ?string
    {
        return $this->st2__sta_key_ext ?? null;
    }
    /**
     * Set st2__sta_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_key_ext(?string $st2__sta_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_key_ext) && !is_string($st2__sta_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_key_ext, true), gettype($st2__sta_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($st2__sta_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $st2__sta_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($st2__sta_key_ext, true)), __LINE__);
        }
        if (is_null($st2__sta_key_ext) || (is_array($st2__sta_key_ext) && empty($st2__sta_key_ext))) {
            unset($this->st2__sta_key_ext);
        } else {
            $this->st2__sta_key_ext = $st2__sta_key_ext;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_entity_key(): ?string
    {
        return $this->st2__sta_entity_key ?? null;
    }
    /**
     * Set st2__sta_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_entity_key(?string $st2__sta_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_entity_key) && !is_string($st2__sta_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_entity_key, true), gettype($st2__sta_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($st2__sta_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $st2__sta_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($st2__sta_entity_key, true)), __LINE__);
        }
        if (is_null($st2__sta_entity_key) || (is_array($st2__sta_entity_key) && empty($st2__sta_entity_key))) {
            unset($this->st2__sta_entity_key);
        } else {
            $this->st2__sta_entity_key = $st2__sta_entity_key;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_name(): ?string
    {
        return $this->st2__sta_name ?? null;
    }
    /**
     * Set st2__sta_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_name(?string $st2__sta_name = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_name) && !is_string($st2__sta_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_name, true), gettype($st2__sta_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($st2__sta_name) && mb_strlen((string) $st2__sta_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $st2__sta_name)), __LINE__);
        }
        if (is_null($st2__sta_name) || (is_array($st2__sta_name) && empty($st2__sta_name))) {
            unset($this->st2__sta_name);
        } else {
            $this->st2__sta_name = $st2__sta_name;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_type(): ?string
    {
        return $this->st2__sta_type ?? null;
    }
    /**
     * Set st2__sta_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_type(?string $st2__sta_type = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_type) && !is_string($st2__sta_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_type, true), gettype($st2__sta_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($st2__sta_type) && mb_strlen((string) $st2__sta_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $st2__sta_type)), __LINE__);
        }
        if (is_null($st2__sta_type) || (is_array($st2__sta_type) && empty($st2__sta_type))) {
            unset($this->st2__sta_type);
        } else {
            $this->st2__sta_type = $st2__sta_type;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_rgn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_rgn_key(): ?string
    {
        return $this->st2__sta_rgn_key ?? null;
    }
    /**
     * Set st2__sta_rgn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_rgn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_rgn_key(?string $st2__sta_rgn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_rgn_key) && !is_string($st2__sta_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_rgn_key, true), gettype($st2__sta_rgn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($st2__sta_rgn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $st2__sta_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($st2__sta_rgn_key, true)), __LINE__);
        }
        if (is_null($st2__sta_rgn_key) || (is_array($st2__sta_rgn_key) && empty($st2__sta_rgn_key))) {
            unset($this->st2__sta_rgn_key);
        } else {
            $this->st2__sta_rgn_key = $st2__sta_rgn_key;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_bpa_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_bpa_region(): ?string
    {
        return $this->st2__sta_bpa_region ?? null;
    }
    /**
     * Set st2__sta_bpa_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_bpa_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_bpa_region(?string $st2__sta_bpa_region = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_bpa_region) && !is_string($st2__sta_bpa_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_bpa_region, true), gettype($st2__sta_bpa_region)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($st2__sta_bpa_region) && mb_strlen((string) $st2__sta_bpa_region) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $st2__sta_bpa_region)), __LINE__);
        }
        if (is_null($st2__sta_bpa_region) || (is_array($st2__sta_bpa_region) && empty($st2__sta_bpa_region))) {
            unset($this->st2__sta_bpa_region);
        } else {
            $this->st2__sta_bpa_region = $st2__sta_bpa_region;
        }
        
        return $this;
    }
    /**
     * Get st2__sta_iso_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSt2__sta_iso_code(): ?string
    {
        return $this->st2__sta_iso_code ?? null;
    }
    /**
     * Set st2__sta_iso_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $st2__sta_iso_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Home_Address_State_DataObjectType
     */
    public function setSt2__sta_iso_code(?string $st2__sta_iso_code = null): self
    {
        // validation for constraint: string
        if (!is_null($st2__sta_iso_code) && !is_string($st2__sta_iso_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st2__sta_iso_code, true), gettype($st2__sta_iso_code)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($st2__sta_iso_code) && mb_strlen((string) $st2__sta_iso_code) > 6) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen((string) $st2__sta_iso_code)), __LINE__);
        }
        if (is_null($st2__sta_iso_code) || (is_array($st2__sta_iso_code) && empty($st2__sta_iso_code))) {
            unset($this->st2__sta_iso_code);
        } else {
            $this->st2__sta_iso_code = $st2__sta_iso_code;
        }
        
        return $this;
    }
}
