<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Messaging_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Organization_Messaging_DataObjectType extends AbstractStructBase
{
    /**
     * The msg_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $msg_key = null;
    /**
     * The msg_handle
     * Meta information extracted from the WSDL
     * - documentation: IM handle. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_handle = null;
    /**
     * The msg_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $msg_cst_key = null;
    /**
     * The msg_type
     * Meta information extracted from the WSDL
     * - documentation: IM Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_type = null;
    /**
     * The msg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_add_user = null;
    /**
     * The msg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_add_date = null;
    /**
     * The msg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_change_user = null;
    /**
     * The msg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_change_date = null;
    /**
     * The msg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_delete_flag = null;
    /**
     * The msg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $msg_key_ext = null;
    /**
     * The msg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $msg_entity_key = null;
    /**
     * The msg_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $msg_primary = null;
    /**
     * Constructor method for Organization_Messaging_DataObjectType
     * @uses Organization_Messaging_DataObjectType::setMsg_key()
     * @uses Organization_Messaging_DataObjectType::setMsg_handle()
     * @uses Organization_Messaging_DataObjectType::setMsg_cst_key()
     * @uses Organization_Messaging_DataObjectType::setMsg_type()
     * @uses Organization_Messaging_DataObjectType::setMsg_add_user()
     * @uses Organization_Messaging_DataObjectType::setMsg_add_date()
     * @uses Organization_Messaging_DataObjectType::setMsg_change_user()
     * @uses Organization_Messaging_DataObjectType::setMsg_change_date()
     * @uses Organization_Messaging_DataObjectType::setMsg_delete_flag()
     * @uses Organization_Messaging_DataObjectType::setMsg_key_ext()
     * @uses Organization_Messaging_DataObjectType::setMsg_entity_key()
     * @uses Organization_Messaging_DataObjectType::setMsg_primary()
     * @param string $msg_key
     * @param string $msg_handle
     * @param string $msg_cst_key
     * @param string $msg_type
     * @param string $msg_add_user
     * @param string $msg_add_date
     * @param string $msg_change_user
     * @param string $msg_change_date
     * @param string $msg_delete_flag
     * @param string $msg_key_ext
     * @param string $msg_entity_key
     * @param string $msg_primary
     */
    public function __construct(?string $msg_key = null, ?string $msg_handle = null, ?string $msg_cst_key = null, ?string $msg_type = null, ?string $msg_add_user = null, ?string $msg_add_date = null, ?string $msg_change_user = null, ?string $msg_change_date = null, ?string $msg_delete_flag = null, ?string $msg_key_ext = null, ?string $msg_entity_key = null, ?string $msg_primary = null)
    {
        $this
            ->setMsg_key($msg_key)
            ->setMsg_handle($msg_handle)
            ->setMsg_cst_key($msg_cst_key)
            ->setMsg_type($msg_type)
            ->setMsg_add_user($msg_add_user)
            ->setMsg_add_date($msg_add_date)
            ->setMsg_change_user($msg_change_user)
            ->setMsg_change_date($msg_change_date)
            ->setMsg_delete_flag($msg_delete_flag)
            ->setMsg_key_ext($msg_key_ext)
            ->setMsg_entity_key($msg_entity_key)
            ->setMsg_primary($msg_primary);
    }
    /**
     * Get msg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_key(): ?string
    {
        return $this->msg_key ?? null;
    }
    /**
     * Set msg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_key(?string $msg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_key) && !is_string($msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_key, true), gettype($msg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($msg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($msg_key, true)), __LINE__);
        }
        if (is_null($msg_key) || (is_array($msg_key) && empty($msg_key))) {
            unset($this->msg_key);
        } else {
            $this->msg_key = $msg_key;
        }
        
        return $this;
    }
    /**
     * Get msg_handle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_handle(): ?string
    {
        return $this->msg_handle ?? null;
    }
    /**
     * Set msg_handle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_handle
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_handle(?string $msg_handle = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_handle) && !is_string($msg_handle)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_handle, true), gettype($msg_handle)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($msg_handle) && mb_strlen((string) $msg_handle) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $msg_handle)), __LINE__);
        }
        if (is_null($msg_handle) || (is_array($msg_handle) && empty($msg_handle))) {
            unset($this->msg_handle);
        } else {
            $this->msg_handle = $msg_handle;
        }
        
        return $this;
    }
    /**
     * Get msg_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_cst_key(): ?string
    {
        return $this->msg_cst_key ?? null;
    }
    /**
     * Set msg_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_cst_key(?string $msg_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_cst_key) && !is_string($msg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_cst_key, true), gettype($msg_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($msg_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $msg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($msg_cst_key, true)), __LINE__);
        }
        if (is_null($msg_cst_key) || (is_array($msg_cst_key) && empty($msg_cst_key))) {
            unset($this->msg_cst_key);
        } else {
            $this->msg_cst_key = $msg_cst_key;
        }
        
        return $this;
    }
    /**
     * Get msg_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_type(): ?string
    {
        return $this->msg_type ?? null;
    }
    /**
     * Set msg_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_type(?string $msg_type = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_type) && !is_string($msg_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_type, true), gettype($msg_type)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($msg_type) && mb_strlen((string) $msg_type) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $msg_type)), __LINE__);
        }
        if (is_null($msg_type) || (is_array($msg_type) && empty($msg_type))) {
            unset($this->msg_type);
        } else {
            $this->msg_type = $msg_type;
        }
        
        return $this;
    }
    /**
     * Get msg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_add_user(): ?string
    {
        return $this->msg_add_user ?? null;
    }
    /**
     * Set msg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_add_user(?string $msg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_add_user) && !is_string($msg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_add_user, true), gettype($msg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($msg_add_user) && mb_strlen((string) $msg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $msg_add_user)), __LINE__);
        }
        if (is_null($msg_add_user) || (is_array($msg_add_user) && empty($msg_add_user))) {
            unset($this->msg_add_user);
        } else {
            $this->msg_add_user = $msg_add_user;
        }
        
        return $this;
    }
    /**
     * Get msg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_add_date(): ?string
    {
        return $this->msg_add_date ?? null;
    }
    /**
     * Set msg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_add_date(?string $msg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_add_date) && !is_string($msg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_add_date, true), gettype($msg_add_date)), __LINE__);
        }
        if (is_null($msg_add_date) || (is_array($msg_add_date) && empty($msg_add_date))) {
            unset($this->msg_add_date);
        } else {
            $this->msg_add_date = $msg_add_date;
        }
        
        return $this;
    }
    /**
     * Get msg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_change_user(): ?string
    {
        return $this->msg_change_user ?? null;
    }
    /**
     * Set msg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_change_user(?string $msg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_change_user) && !is_string($msg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_change_user, true), gettype($msg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($msg_change_user) && mb_strlen((string) $msg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $msg_change_user)), __LINE__);
        }
        if (is_null($msg_change_user) || (is_array($msg_change_user) && empty($msg_change_user))) {
            unset($this->msg_change_user);
        } else {
            $this->msg_change_user = $msg_change_user;
        }
        
        return $this;
    }
    /**
     * Get msg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_change_date(): ?string
    {
        return $this->msg_change_date ?? null;
    }
    /**
     * Set msg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_change_date(?string $msg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_change_date) && !is_string($msg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_change_date, true), gettype($msg_change_date)), __LINE__);
        }
        if (is_null($msg_change_date) || (is_array($msg_change_date) && empty($msg_change_date))) {
            unset($this->msg_change_date);
        } else {
            $this->msg_change_date = $msg_change_date;
        }
        
        return $this;
    }
    /**
     * Get msg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_delete_flag(): ?string
    {
        return $this->msg_delete_flag ?? null;
    }
    /**
     * Set msg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_delete_flag(?string $msg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_delete_flag) && !is_string($msg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_delete_flag, true), gettype($msg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($msg_delete_flag) && $msg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($msg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($msg_delete_flag) && $msg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($msg_delete_flag, true)), __LINE__);
        }
        if (is_null($msg_delete_flag) || (is_array($msg_delete_flag) && empty($msg_delete_flag))) {
            unset($this->msg_delete_flag);
        } else {
            $this->msg_delete_flag = $msg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get msg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_key_ext(): ?string
    {
        return $this->msg_key_ext ?? null;
    }
    /**
     * Set msg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_key_ext(?string $msg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_key_ext) && !is_string($msg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_key_ext, true), gettype($msg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($msg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $msg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($msg_key_ext, true)), __LINE__);
        }
        if (is_null($msg_key_ext) || (is_array($msg_key_ext) && empty($msg_key_ext))) {
            unset($this->msg_key_ext);
        } else {
            $this->msg_key_ext = $msg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get msg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_entity_key(): ?string
    {
        return $this->msg_entity_key ?? null;
    }
    /**
     * Set msg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_entity_key(?string $msg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_entity_key) && !is_string($msg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_entity_key, true), gettype($msg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($msg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $msg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($msg_entity_key, true)), __LINE__);
        }
        if (is_null($msg_entity_key) || (is_array($msg_entity_key) && empty($msg_entity_key))) {
            unset($this->msg_entity_key);
        } else {
            $this->msg_entity_key = $msg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get msg_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsg_primary(): ?string
    {
        return $this->msg_primary ?? null;
    }
    /**
     * Set msg_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msg_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\Organization_Messaging_DataObjectType
     */
    public function setMsg_primary(?string $msg_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($msg_primary) && !is_string($msg_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg_primary, true), gettype($msg_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($msg_primary) && $msg_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($msg_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($msg_primary) && $msg_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($msg_primary, true)), __LINE__);
        }
        if (is_null($msg_primary) || (is_array($msg_primary) && empty($msg_primary))) {
            unset($this->msg_primary);
        } else {
            $this->msg_primary = $msg_primary;
        }
        
        return $this;
    }
}
