<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryParameter StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class QueryParameter extends AbstractStructBase
{
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $Operator;
    /**
     * The IsExtended
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $IsExtended;
    /**
     * The IsNullable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $IsNullable;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Name = null;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Description = null;
    /**
     * The ColumnName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ColumnName = null;
    /**
     * The ColumnDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ColumnDescription = null;
    /**
     * The ControlClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ControlClass = null;
    /**
     * The DataType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $DataType = null;
    /**
     * The TableAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $TableAlias = null;
    /**
     * The TableDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $TableDescription = null;
    /**
     * The TableName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $TableName = null;
    /**
     * The ListOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption $ListOptions = null;
    /**
     * Constructor method for QueryParameter
     * @uses QueryParameter::setOperator()
     * @uses QueryParameter::setIsExtended()
     * @uses QueryParameter::setIsNullable()
     * @uses QueryParameter::setName()
     * @uses QueryParameter::setDescription()
     * @uses QueryParameter::setColumnName()
     * @uses QueryParameter::setColumnDescription()
     * @uses QueryParameter::setControlClass()
     * @uses QueryParameter::setDataType()
     * @uses QueryParameter::setTableAlias()
     * @uses QueryParameter::setTableDescription()
     * @uses QueryParameter::setTableName()
     * @uses QueryParameter::setListOptions()
     * @param string $operator
     * @param bool $isExtended
     * @param bool $isNullable
     * @param string $name
     * @param string $description
     * @param string $columnName
     * @param string $columnDescription
     * @param string $controlClass
     * @param string $dataType
     * @param string $tableAlias
     * @param string $tableDescription
     * @param string $tableName
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption $listOptions
     */
    public function __construct(string $operator, bool $isExtended, bool $isNullable, ?string $name = null, ?string $description = null, ?string $columnName = null, ?string $columnDescription = null, ?string $controlClass = null, ?string $dataType = null, ?string $tableAlias = null, ?string $tableDescription = null, ?string $tableName = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption $listOptions = null)
    {
        $this
            ->setOperator($operator)
            ->setIsExtended($isExtended)
            ->setIsNullable($isNullable)
            ->setName($name)
            ->setDescription($description)
            ->setColumnName($columnName)
            ->setColumnDescription($columnDescription)
            ->setControlClass($controlClass)
            ->setDataType($dataType)
            ->setTableAlias($tableAlias)
            ->setTableDescription($tableDescription)
            ->setTableName($tableName)
            ->setListOptions($listOptions);
    }
    /**
     * Get Operator value
     * @return string
     */
    public function getOperator(): string
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\QueryOperatorType::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\QueryOperatorType::getValidValues()
     * @throws InvalidArgumentException
     * @param string $operator
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setOperator(string $operator): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\QueryOperatorType::valueIsValid($operator)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\QueryOperatorType', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\QueryOperatorType::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        
        return $this;
    }
    /**
     * Get IsExtended value
     * @return bool
     */
    public function getIsExtended(): bool
    {
        return $this->IsExtended;
    }
    /**
     * Set IsExtended value
     * @param bool $isExtended
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setIsExtended(bool $isExtended): self
    {
        // validation for constraint: boolean
        if (!is_null($isExtended) && !is_bool($isExtended)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtended, true), gettype($isExtended)), __LINE__);
        }
        $this->IsExtended = $isExtended;
        
        return $this;
    }
    /**
     * Get IsNullable value
     * @return bool
     */
    public function getIsNullable(): bool
    {
        return $this->IsNullable;
    }
    /**
     * Set IsNullable value
     * @param bool $isNullable
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setIsNullable(bool $isNullable): self
    {
        // validation for constraint: boolean
        if (!is_null($isNullable) && !is_bool($isNullable)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNullable, true), gettype($isNullable)), __LINE__);
        }
        $this->IsNullable = $isNullable;
        
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setName(?string $name = null): self
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setDescription(?string $description = null): self
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        
        return $this;
    }
    /**
     * Get ColumnName value
     * @return string|null
     */
    public function getColumnName(): ?string
    {
        return $this->ColumnName;
    }
    /**
     * Set ColumnName value
     * @param string $columnName
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setColumnName(?string $columnName = null): self
    {
        // validation for constraint: string
        if (!is_null($columnName) && !is_string($columnName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnName, true), gettype($columnName)), __LINE__);
        }
        $this->ColumnName = $columnName;
        
        return $this;
    }
    /**
     * Get ColumnDescription value
     * @return string|null
     */
    public function getColumnDescription(): ?string
    {
        return $this->ColumnDescription;
    }
    /**
     * Set ColumnDescription value
     * @param string $columnDescription
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setColumnDescription(?string $columnDescription = null): self
    {
        // validation for constraint: string
        if (!is_null($columnDescription) && !is_string($columnDescription)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnDescription, true), gettype($columnDescription)), __LINE__);
        }
        $this->ColumnDescription = $columnDescription;
        
        return $this;
    }
    /**
     * Get ControlClass value
     * @return string|null
     */
    public function getControlClass(): ?string
    {
        return $this->ControlClass;
    }
    /**
     * Set ControlClass value
     * @param string $controlClass
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setControlClass(?string $controlClass = null): self
    {
        // validation for constraint: string
        if (!is_null($controlClass) && !is_string($controlClass)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($controlClass, true), gettype($controlClass)), __LINE__);
        }
        $this->ControlClass = $controlClass;
        
        return $this;
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType(): ?string
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param string $dataType
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setDataType(?string $dataType = null): self
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataType, true), gettype($dataType)), __LINE__);
        }
        $this->DataType = $dataType;
        
        return $this;
    }
    /**
     * Get TableAlias value
     * @return string|null
     */
    public function getTableAlias(): ?string
    {
        return $this->TableAlias;
    }
    /**
     * Set TableAlias value
     * @param string $tableAlias
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setTableAlias(?string $tableAlias = null): self
    {
        // validation for constraint: string
        if (!is_null($tableAlias) && !is_string($tableAlias)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableAlias, true), gettype($tableAlias)), __LINE__);
        }
        $this->TableAlias = $tableAlias;
        
        return $this;
    }
    /**
     * Get TableDescription value
     * @return string|null
     */
    public function getTableDescription(): ?string
    {
        return $this->TableDescription;
    }
    /**
     * Set TableDescription value
     * @param string $tableDescription
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setTableDescription(?string $tableDescription = null): self
    {
        // validation for constraint: string
        if (!is_null($tableDescription) && !is_string($tableDescription)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableDescription, true), gettype($tableDescription)), __LINE__);
        }
        $this->TableDescription = $tableDescription;
        
        return $this;
    }
    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName(): ?string
    {
        return $this->TableName;
    }
    /**
     * Set TableName value
     * @param string $tableName
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setTableName(?string $tableName = null): self
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableName, true), gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        
        return $this;
    }
    /**
     * Get ListOptions value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption|null
     */
    public function getListOptions(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption
    {
        return $this->ListOptions;
    }
    /**
     * Set ListOptions value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption $listOptions
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter
     */
    public function setListOptions(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption $listOptions = null): self
    {
        $this->ListOptions = $listOptions;
        
        return $this;
    }
}
