<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenewMembership StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class RenewMembership extends AbstractStructBase
{
    /**
     * The MembershipKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $MembershipKey;
    /**
     * The oCentralizedOrderEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null;
    /**
     * Constructor method for RenewMembership
     * @uses RenewMembership::setMembershipKey()
     * @uses RenewMembership::setOCentralizedOrderEntry()
     * @param string $membershipKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     */
    public function __construct(string $membershipKey, ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null)
    {
        $this
            ->setMembershipKey($membershipKey)
            ->setOCentralizedOrderEntry($oCentralizedOrderEntry);
    }
    /**
     * Get MembershipKey value
     * @return string
     */
    public function getMembershipKey(): string
    {
        return $this->MembershipKey;
    }
    /**
     * Set MembershipKey value
     * @param string $membershipKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\RenewMembership
     */
    public function setMembershipKey(string $membershipKey): self
    {
        // validation for constraint: string
        if (!is_null($membershipKey) && !is_string($membershipKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipKey, true), gettype($membershipKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($membershipKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $membershipKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($membershipKey, true)), __LINE__);
        }
        $this->MembershipKey = $membershipKey;
        
        return $this;
    }
    /**
     * Get oCentralizedOrderEntry value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    public function getOCentralizedOrderEntry(): ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType
    {
        return $this->oCentralizedOrderEntry;
    }
    /**
     * Set oCentralizedOrderEntry value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     * @return \Drupal\netforum\xWeb\Generated\StructType\RenewMembership
     */
    public function setOCentralizedOrderEntry(?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null): self
    {
        $this->oCentralizedOrderEntry = $oCentralizedOrderEntry;
        
        return $this;
    }
}
