<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetIndividualInformation StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class SetIndividualInformation extends AbstractStructBase
{
    /**
     * The oUpdateNode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null;
    /**
     * The IndividualKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $IndividualKey;
    /**
     * Constructor method for SetIndividualInformation
     * @uses SetIndividualInformation::setOUpdateNode()
     * @uses SetIndividualInformation::setIndividualKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode
     * @param string $individualKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null, ?string $individualKey)
    {
        $this
            ->setOUpdateNode($oUpdateNode)
            ->setIndividualKey($individualKey);
    }
    /**
     * Get oUpdateNode value
     * @return \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode|null
     */
    public function getOUpdateNode(): ?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode
    {
        return $this->oUpdateNode;
    }
    /**
     * Set oUpdateNode value
     * @param \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformation
     */
    public function setOUpdateNode(?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null): self
    {
        $this->oUpdateNode = $oUpdateNode;
        
        return $this;
    }
    /**
     * Get IndividualKey value
     * @return string|null
     */
    public function getIndividualKey(): ?string
    {
        return $this->IndividualKey;
    }
    /**
     * Set IndividualKey value
     * @param string $individualKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformation
     */
    public function setIndividualKey(?string $individualKey): self
    {
        // validation for constraint: string
        if (!is_null($individualKey) && !is_string($individualKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualKey, true), gettype($individualKey)), __LINE__);
        }
        $this->IndividualKey = $individualKey;
        
        return $this;
    }
}
