<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrganizationInformation StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class SetOrganizationInformation extends AbstractStructBase
{
    /**
     * The oUpdateNode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null;
    /**
     * The OrganizationKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $OrganizationKey;
    /**
     * Constructor method for SetOrganizationInformation
     * @uses SetOrganizationInformation::setOUpdateNode()
     * @uses SetOrganizationInformation::setOrganizationKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode
     * @param string $organizationKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null, ?string $organizationKey)
    {
        $this
            ->setOUpdateNode($oUpdateNode)
            ->setOrganizationKey($organizationKey);
    }
    /**
     * Get oUpdateNode value
     * @return \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode|null
     */
    public function getOUpdateNode(): ?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode
    {
        return $this->oUpdateNode;
    }
    /**
     * Set oUpdateNode value
     * @param \Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformation
     */
    public function setOUpdateNode(?\Drupal\netforum\xWeb\Generated\StructType\OUpdateNode $oUpdateNode = null): self
    {
        $this->oUpdateNode = $oUpdateNode;
        
        return $this;
    }
    /**
     * Get OrganizationKey value
     * @return string|null
     */
    public function getOrganizationKey(): ?string
    {
        return $this->OrganizationKey;
    }
    /**
     * Set OrganizationKey value
     * @param string $organizationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformation
     */
    public function setOrganizationKey(?string $organizationKey): self
    {
        // validation for constraint: string
        if (!is_null($organizationKey) && !is_string($organizationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationKey, true), gettype($organizationKey)), __LINE__);
        }
        $this->OrganizationKey = $organizationKey;
        
        return $this;
    }
}
