<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBActivityAlreadyRegisteredForEvent StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBActivityAlreadyRegisteredForEvent extends AbstractStructBase
{
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $CustomerKey;
    /**
     * The EventKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $EventKey;
    /**
     * Constructor method for WEBActivityAlreadyRegisteredForEvent
     * @uses WEBActivityAlreadyRegisteredForEvent::setCustomerKey()
     * @uses WEBActivityAlreadyRegisteredForEvent::setEventKey()
     * @param string $customerKey
     * @param string $eventKey
     */
    public function __construct(string $customerKey, string $eventKey)
    {
        $this
            ->setCustomerKey($customerKey)
            ->setEventKey($eventKey);
    }
    /**
     * Get CustomerKey value
     * @return string
     */
    public function getCustomerKey(): string
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEvent
     */
    public function setCustomerKey(string $customerKey): self
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($customerKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($customerKey, true)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        
        return $this;
    }
    /**
     * Get EventKey value
     * @return string
     */
    public function getEventKey(): string
    {
        return $this->EventKey;
    }
    /**
     * Set EventKey value
     * @param string $eventKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEvent
     */
    public function setEventKey(string $eventKey): self
    {
        // validation for constraint: string
        if (!is_null($eventKey) && !is_string($eventKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventKey, true), gettype($eventKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($eventKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $eventKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($eventKey, true)), __LINE__);
        }
        $this->EventKey = $eventKey;
        
        return $this;
    }
}
