<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBActivityNumberOfRegisteredGuests StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBActivityNumberOfRegisteredGuests extends AbstractStructBase
{
    /**
     * The RegistrationKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $RegistrationKey;
    /**
     * Constructor method for WEBActivityNumberOfRegisteredGuests
     * @uses WEBActivityNumberOfRegisteredGuests::setRegistrationKey()
     * @param string $registrationKey
     */
    public function __construct(string $registrationKey)
    {
        $this
            ->setRegistrationKey($registrationKey);
    }
    /**
     * Get RegistrationKey value
     * @return string
     */
    public function getRegistrationKey(): string
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param string $registrationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityNumberOfRegisteredGuests
     */
    public function setRegistrationKey(string $registrationKey): self
    {
        // validation for constraint: string
        if (!is_null($registrationKey) && !is_string($registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationKey, true), gettype($registrationKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($registrationKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($registrationKey, true)), __LINE__);
        }
        $this->RegistrationKey = $registrationKey;
        
        return $this;
    }
}
